/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
 import { canonicalizeBaseUrl } from "@gnu-taler/taler-util";
import { uiSettings } from "../settings.js";


export function getInitialBackendBaseURL(): string {
  const overrideUrl =
    typeof localStorage !== "undefined"
      ? localStorage.getItem("exchange-base-url")
      : undefined;

  let result: string;

  if (!overrideUrl) {
    //normal path
    if (!uiSettings.backendBaseURL) {
      console.error(
        "ERROR: backendBaseURL was overridden by a setting file and missing. Setting value to 'window.origin'",
      );      
      result = typeof (window as any) !== "undefined" ? window.origin : "localhost"
    } else {
      result = uiSettings.backendBaseURL;
    }
  } else {
    // testing/development path
    result = overrideUrl
  }
  try {
    return canonicalizeBaseUrl(result)
  } catch (e) {
    //fall back
    return canonicalizeBaseUrl(window.origin)
  }
}
