import type {
  TranslatedString
} from "@gnu-taler/taler-util";

import type { DoubleColumnFormSection, FlexibleForm, FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { BaseForm } from "./declaration.js";
import { amlStateConverter } from "../utils/converter.js";
import { AmlExchangeBackend } from "../utils/types.js";

export const v1 = (i18n: InternationalizationAPI) => (current: BaseForm): FlexibleForm<Simplest.Form> => ({
  design: [
    {
      title: i18n.str`Simple form`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "comment",
            label: i18n.str`Comments`,
          },
        },
      ],
    },
    resolutionSection(current, i18n),
  ],
  behavior: function formBehavior(
    v: Partial<Simplest.Form>,
  ): FormState<Simplest.Form> {
    return {
      comment: {
        help: ((v.comment?.length ?? 0) > 100 ? "keep it short" : "") as TranslatedString,

      },
      threshold: {
        disabled: v.state === AmlExchangeBackend.AmlState.frozen,
      },
    };
  },
});

export namespace Simplest {
  export interface Form extends BaseForm {
    comment: string;
  }
}

export function resolutionSection(current: BaseForm, i18n: InternationalizationAPI): DoubleColumnFormSection {
  return {
    title: i18n.str`Resolution`,
    description: `Current state is ${amlStateConverter.toStringUI(
      current.state,
    )} and threshold at ` as TranslatedString,
    fields: [
      {
        type: "choiceHorizontal",
        props: {
          name: "state",
          label: i18n.str`New state`,
          converter: amlStateConverter,
          choices: [
            {
              value: AmlExchangeBackend.AmlState.frozen,
              label: i18n.str`Frozen`,
            },
            {
              value: AmlExchangeBackend.AmlState.pending,
              label: i18n.str`Pending`,
            },
            {
              value: AmlExchangeBackend.AmlState.normal,
              label: i18n.str`Normal`,
            },
          ],
        },
      },
      {
        type: "amount",
        props: {
          name: "threshold",
          label: i18n.str`New threshold`,
        },
      },
    ],
  };
}
