/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import type { AmountJson, TranslatedString } from "@gnu-taler/taler-util";
import type { FlexibleForm, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { AmlExchangeBackend } from "../utils/types.js";

/**
 * import entry point without hard reference.
 * 
 * This file just export types and UI Forms 
 * based on what `globalThis` contains.
 * 
 * `./index.js` must be imported first before 
 * so `globaThis` will have the correct value. 
 */

export interface BaseForm {
  state: AmlExchangeBackend.AmlState;
  threshold: AmountJson;
}

export type FormMetadata<T extends BaseForm> = {
  label: TranslatedString,
  id: string,
  version: number,
  impl: (current: T) => FlexibleForm<T>
}

interface LabelValue {
  label: TranslatedString;
  value: string,
}

export interface UiForms {
  currencies: (i18n: InternationalizationAPI) => LabelValue[],
  languages: (i18n: InternationalizationAPI) => LabelValue[],
  forms: (i18n: InternationalizationAPI) => Array<FormMetadata<BaseForm>>,
}

/**
 * Global settings for the UI.
 */
const defaultUIForms: UiForms = {
  currencies: () => [],
  languages: () => [],
  forms: () => [],
};

declare global {
  var amlExchangeBackoffice: UiForms;
}

export const uiForms: UiForms =
  "amlExchangeBackoffice" in globalThis
    ? (globalThis as any).amlExchangeBackoffice
    : defaultUIForms;
