import type { TranslatedString } from "@gnu-taler/taler-util";
import type { FlexibleForm, FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { BaseForm, uiForms } from "./declaration.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (i18n: InternationalizationAPI) => (current: BaseForm): FlexibleForm<Form902_5.Form> => ({
  design: [
    {
      title: i18n.str`Customer Profile`,
      description:
        i18n.str`The information below has to refer to the persons from whom the assets originate ultimately (e.g. beneficial owner of the assets, founder/creator of a trust or foundation). Is the customer an operational legal entity or partnership the information may refer to the entity itself (not to the controlling person), unless the entity holds the assets in trust for a third party.`,
      fields: [
        {
          type: "text",
          props: {
            name: "customer",
            label: i18n.str`Customer`,
            help: i18n.str`Pursuant Identification Form (VQF doc. No. 902.1) numeral 1`,
          },
        },
      ],
    },
    {
      title: i18n.str`Business activity`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Profession, business activities`,
            name: "businessActivity",
            help: i18n.str`former, current, potentially planned`,
          },
        },
      ],
    },
    {
      title: i18n.str`Financial circumstances`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Income and assets, liabilities`,
            name: "financial",
            help: i18n.str`estimated`,
          },
        },
      ],
    },
    {
      title: i18n.str`Origin of the deposited assets involved`,
      fields: [
        {
          type: "text",
          props: {
            label: i18n.str`Nature`,
            name: "originOfAssets.nature",
            help: i18n.str`nature of the involved assets`,
          },
        },
        {
          type: "selectOne",
          props: {
            name: "originOfAssets.currency",
            label: i18n.str`Currency`,
            choices: uiForms.currencies(i18n),
          },
        },
        {
          type: "integer",
          props: {
            label: i18n.str`Amount`,
            name: "originOfAssets.amount",
          },
        },
        {
          type: "choiceStacked",
          props: {
            label: i18n.str`Category`,
            name: "originOfAssets.category",
            choices: [
              {
                label: i18n.str`Savings`,
                value: "savings",
              },
              {
                label: i18n.str`Own business operations`,
                value: "own-business",
              },
              {
                label: i18n.str`Inheritance`,
                value: "inheritance",
              },
              {
                label: i18n.str`Other, what?`,
                value: "other",
              },
            ],
          },
        },
        {
          type: "text",
          props: {
            label: i18n.str`Other category`,
            name: "originOfAssets.categoryOther",
            required: true,
          },
        },
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Detailed description of the origins/economical background of the assets involved in the business relationship`,
            name: "originOfAssets.details",
          },
        },
      ],
    },
    {
      title:
        i18n.str`Nature and purpose of the business relationship`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Purpose of the business relationship`,
            name: "nature.purpose",
            help: i18n.str`nature of the involved assets`,
          },
        },
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Information on the planned development of the business relationship and the assets`,
            name: "nature.plan",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Especially in the case of cash or money and asset transfer transactions with regular customers: Details on usual business volume, Information on the beneficiaries, (Full name, address, bank account)`,
            name: "nature.cashOrMoneyTransfer",
          },
        },
      ],
    },
    {
      title: i18n.str`Relationship with third parties`,
      fields: [
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Relation of the customer to the beneficial owner involved in the business relationship`,
            name: "relations.beneficialOwners",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Relation of the customer to the controlling persons involved in the business relationship`,
            name: "relations.controllingPersons",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Relation of the customer to the authorized signatories involved in the business relationship`,
            name: "relations.authorizedSignatories",
          },
        },
        {
          type: "textArea",
          props: {
            label:
              i18n.str`Relation of the customer to other persons involved in the business relationship`,
            name: "relations.otherPersons",
          },
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Relation to other AMLA-Files`,
            name: "relations.withOtherAmlaFiles",
          },
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Introducer / agents / references`,
            name: "relations.references",
          },
        },
      ],
    },
    {
      title: i18n.str`Further information`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Other relevant information`,
            name: "furtherInformation",
          },
        },
      ],
    },
    resolutionSection(current, i18n),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_5.Form>,
  ): FormState<Form902_5.Form> {
    return {
      originOfAssets: {
        categoryOther: {
          hidden: v.originOfAssets?.category !== "other",
        },
      },
    };
  },
});

namespace Form902_5 {
  export interface Form extends BaseForm {
    customer: string;
    fullName: string;
    businessActivity: string;
    financial: string;
    originOfAssets: {
      nature: string;
      currency: string;
      amount: number;
      category: "savings" | "own-business" | "inheritance" | "other";
      categoryOther: string;
      details: string;
    };
    nature: {
      purpose: string;
      plan: string;
      cashOrMoneyTransfer: string;
    };
    relations: {
      beneficialOwners: string;
      controllingPersons: string;
      authorizedSignatories: string;
      otherPersons: string;
      withOtherAmlaFiles: string;
      references: string;
    };
    furtherInformation: string;
  }
}
