import type { AbsoluteTime } from "@gnu-taler/taler-util";
import type { FlexibleForm, FormState, InternationalizationAPI } from "@gnu-taler/web-util/browser";
import { BaseForm } from "./declaration.js";
import { resolutionSection } from "./simplest.js";

export const v1 = (i18n: InternationalizationAPI) => (current: BaseForm): FlexibleForm<Form902_13.Form> => ({
  design: [
    {
      title: i18n.str`Declaration for trusts`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`,
          },
        },
        {
          type: "text",
          props: {
            name: "knownAs",
            label:
              i18n.str`The undersigned hereby declare(s) that as trustee or a member of highest supervisory body of an underlying company of a trust known as`,
          },
        },
        {
          type: "text",
          props: {
            name: "trust.name",
            label:
              i18n.str`Name and information pertaining to the trust`,
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "trust.type",
            label: i18n.str`Type of trust`,
            choices: [
              {
                label: i18n.str`Discretionary trust`,
                value: "discretionary",
              },
              {
                label: i18n.str`Non-discretionary trust`,
                value: "non-discretionary",
              },
            ],
          },
        },
        {
          type: "choiceStacked",
          props: {
            name: "trust.revocability",
            label: i18n.str`Revocability`,
            choices: [
              {
                label: i18n.str`Revocable foundation`,
                value: "revocable",
              },
              {
                label: i18n.str`Irrevocable foundation`,
                value: "irrevocable",
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              i18n.str`Information pertaining to the (ultimate economic, not fiduciary) settlor of the trust (individual(s) or entity/ies)`,
            labelField: "fullName",
            name: "settlors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`if deceased. format 'dd/MM/yyyy'`,
                  help: i18n.str`if deceased'`,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToRevoke",
                  required: true,
                  label:
                    i18n.str`Does the founder have the right to revoke the trust?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes",
                    },
                    {
                      label: i18n.str`No`,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              i18n.str`If the trust results from the restructuring of pre-existing trust (re-settlement) or the merger of pre-existing trusts, the following information pertaining to the (actual) settlor of the pre-existing trust(s) has to be given`,
            labelField: "fullName",
            name: "preExistingSettlors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  pattern: "dd/MM/yyyy",
                  help: i18n.str`if deceased.`,
                  // help: i18n.str`if deceased. format 'dd/MM/yyyy'`,
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              i18n.str`Pertaining to the beneficiary/-ies at the time of the signing of this form`,
            labelField: "fullName",
            name: "beneficiaryWhenSigning",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    i18n.str`Has the beneficiary an actual right to claim distribution?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes",
                    },
                    {
                      label: i18n.str`No`,
                      value: "no",
                    },
                  ],
                },
              },
              {
                type: "textArea",
                props: {
                  label:
                    i18n.str`in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the settlor) known at the time of the signing of this form`,
                  name: "beneficiaryExtra",
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              i18n.str`Information pertaining to the protector(s) as well as (a) further person(s) having the right to revoke the trust (in case of revocable trusts) or to appoint the trustee of a trust`,
            labelField: "asd",
            name: "nothing",
            fields: [],
          },
        },

        {
          type: "array",
          props: {
            label:
              i18n.str`Information pertaining to the protectors`,
            labelField: "fullName",
            name: "protectors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    i18n.str`Does the protector have the right to revoke the trust?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes",
                    },
                    {
                      label: i18n.str`No`,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "array",
          props: {
            label:
              i18n.str`Information pertaining to further persons`,
            labelField: "fullName",
            name: "furtherPersons",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label:
                    i18n.str`Last name(s), first name(s)/entity`,
                },
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label:
                    i18n.str`Actual address of domicile/registered office`,
                },
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`,
                },
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                },
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                },
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label:
                    i18n.str`Has this further person the right to revoke the trust?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes",
                    },
                    {
                      label: i18n.str`No`,
                      value: "no",
                    },
                  ],
                },
              },
            ],
          },
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: i18n.str`Signature`,
          },
        },
      ],
    },
    resolutionSection(current, i18n),
  ],
  behavior: function formBehavior(
    v: Partial<Form902_13.Form>,
  ): FormState<Form902_13.Form> {
    return {
      settlors: {
        elements: (v.settlors ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
      protectors: {
        elements: (v.protectors ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
      furtherPersons: {
        elements: (v.furtherPersons ?? []).map((f) => {
          return {
            rightToRevoke: {
              hidden: v.foundation?.revocability !== "revocable",
            },
          };
        }),
      },
    };
  },
});

namespace Form902_13 {
  interface Foundation {
    name: string;
    type: "discretionary" | "non-discretionary";
    revocability: "revocable" | "irrevocable";
  }
  interface Person {
    fullName: string;
    address: string;
    country: string;
    dateOfBirth: AbsoluteTime;
    nationality: string;
  }
  type WithRevoke<T> = {
    rightToRevoke: "yes" | "no";
  } & T;
  type WithClaim<T> = {
    rightToClaim: "yes" | "no";
  } & T;
  type WithDeath<T> = {
    dateOfDeath: AbsoluteTime;
  } & T;

  type Founder = WithRevoke<WithDeath<Person>>;
  type Beneficiary = WithClaim<Person>;

  export interface Form extends BaseForm {
    contractingPartner: string;
    knownAs: string;
    boardMember: string;
    foundation: Foundation;
    settlors: Array<Founder>;
    preExistingSettlors: Array<Founder>;
    beneficiaryWhenSigning: Array<Beneficiary>;
    beneficiaryExtra: Array<Beneficiary>;
    protectors: Array<WithRevoke<Person>>;
    furtherPersons: Array<WithRevoke<Person>>;
  }
}
