import { TranslationProvider } from "@gnu-taler/web-util/browser";
import { h, VNode } from "preact";
import { ExchangeAmlFrame } from "./Dashboard.js";
import "./scss/main.css";
import { ExchangeApiProvider } from "./context/config.js";
import { getInitialBackendBaseURL } from "./hooks/useBackend.js";
import { HashPathProvider, Router } from "./route.js";
import { Pages } from "./pages.js";
import { SWRConfig } from "swr";

const WITH_LOCAL_STORAGE_CACHE = false;

const pageList = Object.values(Pages);

export function App(): VNode {
  const baseUrl = getInitialBackendBaseURL();
  return (
    <TranslationProvider source={{}}>
      <ExchangeApiProvider baseUrl={baseUrl} frameOnError={ExchangeAmlFrame}>
        <HashPathProvider>
          <SWRConfig
            value={{
              provider: WITH_LOCAL_STORAGE_CACHE
                ? localStorageProvider
                : undefined,
              // normally, do not revalidate
              revalidateOnFocus: false,
              revalidateOnReconnect: false,
              revalidateIfStale: false,
              revalidateOnMount: undefined,
              focusThrottleInterval: undefined,

              // normally, do not refresh
              refreshInterval: undefined,
              dedupingInterval: 2000,
              refreshWhenHidden: false,
              refreshWhenOffline: false,

              // ignore errors
              shouldRetryOnError: false,
              errorRetryCount: 0,
              errorRetryInterval: undefined,

              // do not go to loading again if already has data
              keepPreviousData: true,
            }}
          >

            <ExchangeAmlFrame>
              <Router
                pageList={pageList}
                onNotFound={() => {
                  window.location.href = Pages.cases.url
                  return <div>not found</div>;
                }}
              />
            </ExchangeAmlFrame>
          </SWRConfig>
        </HashPathProvider>
      </ExchangeApiProvider>
    </TranslationProvider>
  );
}


function localStorageProvider(): Map<unknown, unknown> {
  const map = new Map(JSON.parse(localStorage.getItem("app-cache") || "[]"));

  window.addEventListener("beforeunload", () => {
    const appCache = JSON.stringify(Array.from(map.entries()));
    localStorage.setItem("app-cache", appCache);
  });
  return map;
}
