/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_product.h
 * @brief implementation of the update_product function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_UPDATE_PRODUCT_H
#define PG_UPDATE_PRODUCT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Update details about a particular product. Note that the
 * transaction must enforce that the sold/stocked/lost counters
 * are not reduced (i.e. by expanding the WHERE clause on the existing
 * values).
 *
 * @param cls closure
 * @param instance_id instance to lookup products for
 * @param product_id product to lookup
 * @param[out] pd set to the product details on success, can be NULL
 *             (in that case we only want to check if the product exists)
 *             total_sold in @a pd is ignored, total_lost must not
 *             exceed total_stock minus the existing total_sold;
 *             total_sold and total_stock must be larger or equal to
 *             the existing value;
 * @return database result code, #GNUNET_DB_STATUS_SUCCESS_NO_RESULTS if the
 *         non-decreasing constraints are not met *or* if the product
 *         does not yet exist.
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_product (void *cls,
                       const char *instance_id,
                       const char *product_id,
                       const struct TALER_MERCHANTDB_ProductDetails *pd);

#endif
