/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_rewards.h
 * @brief implementation of the lookup_rewards function for Postgres
 * @author Iván Ávalos
 */
#ifndef PG_LOOKUP_REWARDS_H
#define PG_LOOKUP_REWARDS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Lookup rewards
 *
 * @param cls closure, typically a connection to the db
 * @param instance_id which instance should we lookup rewards for
 * @param expired should we include expired rewards?
 * @param limit maximum number of results to return, positive for
 *   ascending row id, negative for descending
 * @param offset row id to start returning results from
 * @param cb function to call with reward data
 * @param cb_cls closure for @a cb
 * @return transaction status
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_rewards (void *cls,
                       const char *instance_id,
                       enum TALER_EXCHANGE_YesNoAll expired,
                       int64_t limit,
                       uint64_t offset,
                       TALER_MERCHANTDB_RewardsCallback cb,
                       void *cb_cls);

#endif
