/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_reward_details.h
 * @brief implementation of the lookup_reward_details function for Postgres
 * @author Iván Ávalos
 */
#ifndef PG_LOOKUP_REWARD_DETAILS_H
#define PG_LOOKUP_REWARD_DETAILS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Lookup reward details for reward @a reward_id.
 *
 * @param cls closure, typically a connection to the db
 * @param instance_id which instance should we lookup reward details for
 * @param reward_id which reward should we lookup details on
 * @param fpu should we fetch details about individual pickups
 * @param[out] total_authorized amount how high is the reward (with fees)
 * @param[out] total_picked_up how much of the reward was so far picked up (with fees)
 * @param[out] justification why was the reward approved
 * @param[out] expiration set to when the reward expires
 * @param[out] reserve_pub set to which reserve is debited
 * @param[out] pickups_length set to the length of @e pickups
 * @param[out] pickups if @a fpu is true, set to details about the pickup operations
 * @return transaction status,
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_reward_details (void *cls,
                              const char *instance_id,
                              const struct TALER_RewardIdentifierP *reward_id,
                              bool fpu,
                              struct TALER_Amount *total_authorized,
                              struct TALER_Amount *total_picked_up,
                              char **justification,
                              struct GNUNET_TIME_Timestamp *expiration,
                              struct TALER_ReservePublicKeyP *reserve_pub,
                              unsigned int *pickups_length,
                              struct TALER_MERCHANTDB_PickupDetails **pickups);

#endif
