/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_reserves.h
 * @brief implementation of the lookup_reserves function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_LOOKUP_RESERVES_H
#define PG_LOOKUP_RESERVES_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Lookup reserves.
 *
 * @param cls closure
 * @param instance_id instance to lookup payments for
 * @param created_after filter by reserves created after this date
 * @param active filter by active reserves
 * @param failures filter by reserves with a disagreement on the initial balance
 * @param cb function to call with reserve summary data
 * @param cb_cls closure for @a cb
 * @return transaction status
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_reserves (void *cls,
                        const char *instance_id,
                        struct GNUNET_TIME_Timestamp created_after,
                        enum TALER_EXCHANGE_YesNoAll active,
                        enum TALER_EXCHANGE_YesNoAll failures,
                        TALER_MERCHANTDB_ReservesCallback cb,
                        void *cb_cls);


#endif
