/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_pickup.h
 * @brief implementation of the lookup_pickup function for Postgres
 * @author Iván Ávalos
 */
#ifndef PG_LOOKUP_PICKUP_H
#define PG_LOOKUP_PICKUP_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Lookup pickup details for pickup @a pickup_id.
 *
 * @param cls closure, typically a connection to the db
 * @param instance_id which instance should we lookup reward details for
 * @param reward_id which reward should we lookup details on
 * @param pickup_id which pickup should we lookup details on
 * @param[out] exchange_url which exchange is the reward withdrawn from
 * @param[out] reserve_priv private key the reward is withdrawn from (set if still available!)
 * @param sigs_length length of the @a sigs array
 * @param[out] sigs set to the (blind) signatures we have for this @a pickup_id,
 *              those that are unavailable are left at NULL
 * @return transaction status
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_pickup (void *cls,
                      const char *instance_id,
                      const struct TALER_RewardIdentifierP *reward_id,
                      const struct TALER_PickupIdentifierP *pickup_id,
                      char **exchange_url,
                      struct TALER_ReservePrivateKeyP *reserve_priv,
                      unsigned int sigs_length,
                      struct TALER_BlindedDenominationSignature sigs[]);

#endif
