/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_payment_status.h
 * @brief implementation of the lookup_payment_status function for Postgres
 * @author Iván Ávalos
 */
#ifndef PG_LOOKUP_PAYMENT_STATUS_H
#define PG_LOOKUP_PAYMENT_STATUS_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Retrieve payment and wire status for a given @a order_serial and session ID.
 *
 * @param cls closure
 * @param order_serial identifies the order
 * @param session_id session for which to check the payment status, NULL for any
 * @param[out] paid set to the payment status of the contract
 * @param[out] wired set to the wire transfer status of the exchange payment
 * @return transaction status
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_payment_status (void *cls,
                              uint64_t order_serial,
                              const char *session_id,
                              bool *paid,
                              bool *wired);

#endif
