/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_reserve.h
 * @brief implementation of the insert_reserve function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_INSERT_RESERVE_H
#define PG_INSERT_RESERVE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Add @a credit to a reserve to be used for rewardping.  Note that
 * this function does not actually perform any wire transfers to
 * credit the reserve, it merely tells the merchant backend that
 * a reserve now exists.  This has to happen before rewards can be
 * authorized.
 *
 * @param cls closure, typically a connection to the db
 * @param instance_id which instance is the reserve tied to
 * @param reserve_priv which reserve is topped up or created
 * @param reserve_pub which reserve is topped up or created
 * @param master_pub master public key of the exchange
 * @param exchange_url what URL is the exchange reachable at where the reserve is located
 * @param initial_balance how much money will be added to the reserve
 * @param expiration when does the reserve expire?
 * @return transaction status, usually
 *      #GNUNET_DB_STATUS_SUCCESS_ONE_RESULT for success
 */
enum TALER_ErrorCode
TMH_PG_insert_reserve (void *cls,
                       const char *instance_id,
                       const struct TALER_ReservePrivateKeyP *reserve_priv,
                       const struct TALER_ReservePublicKeyP *reserve_pub,
                       const struct TALER_MasterPublicKeyP *master_pub,
                       const char *exchange_url,
                       const struct TALER_Amount *initial_balance,
                       struct GNUNET_TIME_Timestamp expiration);

#endif
