/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_pickup_blind_signature.h
 * @brief implementation of the insert_pickup_blind_signature function for Postgres
 * @author Iván Ávalos
 */
#ifndef PG_INSERT_PICKUP_BLIND_SIGNATURE_H
#define PG_INSERT_PICKUP_BLIND_SIGNATURE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Insert blind signature obtained from the exchange during a
 * reward pickup operation.
 *
 * @param cls closure, typically a connection to the db
 * @param pickup_id unique ID for the operation
 * @param offset offset of the blind signature for the pickup
 * @param blind_sig the blind signature
 * @return transaction status, usually
 *      #GNUNET_DB_STATUS_SUCCESS_ONE_RESULT for success
 *      #GNUNET_DB_STATUS_SUCCESS_NO_RESULTS if @a credit_uuid already known
 */
enum GNUNET_DB_QueryStatus
TMH_PG_insert_pickup_blind_signature (void *cls,
                                      const struct TALER_PickupIdentifierP *pickup_id,
                                      uint32_t offset,
                                      const struct TALER_BlindedDenominationSignature *blind_sig);

#endif
