/*
   This file is part of TALER
   Copyright (C) 2023 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_pickup_blind_signature.c
 * @brief Implementation of the insert_pickup_blind_signature function for Postgres
 * @author Iván Ávalos
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_insert_pickup_blind_signature.h"
#include "pg_helper.h"

enum GNUNET_DB_QueryStatus
TMH_PG_insert_pickup_blind_signature (void *cls,
                                      const struct TALER_PickupIdentifierP *pickup_id,
                                      uint32_t offset,
                                      const struct TALER_BlindedDenominationSignature *blind_sig)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_auto_from_type (pickup_id),
    GNUNET_PQ_query_param_uint32 (&offset),
    TALER_PQ_query_param_blinded_denom_sig (blind_sig),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);
  PREPARE (pg,
           "insert_pickup_blind_signature",
           "INSERT INTO merchant_reward_pickup_signatures"
           "(pickup_serial"
           ",coin_offset"
           ",blind_sig"
           ") "
           "SELECT"
           " pickup_serial, $2, $3"
           " FROM merchant_reward_pickups"
           " WHERE pickup_id=$1");

  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "insert_pickup_blind_signature",
                                             params);
}
