/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_pickup.h
 * @brief implementation of the insert_pickup function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_INSERT_PICKUP_H
#define PG_INSERT_PICKUP_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Insert details about a reward pickup operation.  The @a total_picked_up
 * UPDATES the total amount under the @a reward_id, while the @a
 * total_requested is the amount to be associated with this @a pickup_id.
 * While there is usually only one pickup event that picks up the entire
 * amount, our schema allows for wallets to pick up the amount incrementally
 * over mulrewardle pick up operations.
 *
 * @param cls closure, typically a connection to the db
 * @param instance_id which instance gave the reward
 * @param reward_id the unique ID for the reward
 * @param total_picked_up how much was picked up overall at this
 *          point (includes @a total_requested)
 * @param pickup_id unique ID for the operation
 * @param total_requested how much is being picked up in this operation
 * @return transaction status, usually
 *      #GNUNET_DB_STATUS_SUCCESS_ONE_RESULT for success
 *      #GNUNET_DB_STATUS_SUCCESS_NO_RESULTS if @a credit_uuid already known
 */
enum GNUNET_DB_QueryStatus
TMH_PG_insert_pickup (
  void *cls,
  const char *instance_id,
  const struct TALER_RewardIdentifierP *reward_id,
  const struct TALER_Amount *total_picked_up,
  const struct TALER_PickupIdentifierP *pickup_id,
  const struct TALER_Amount *total_requested);

#endif
