/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_activate_reserve.h
 * @brief implementation of the activate_reserve function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_ACTIVATE_RESERVE_H
#define PG_ACTIVATE_RESERVE_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"


/**
 * Confirms @a credit as the amount the exchange claims to have received and
 * thus really 'activates' the reserve.  This has to happen before rewards can
 * be authorized.
 *
 * @param cls closure, typically a connection to the db
 * @param instance_id which instance is the reserve tied to
 * @param reserve_pub which reserve is topped up or created
 * @param initial_exchange_balance how much money was be added to the reserve
 *           according to the exchange
 * @return transaction status, usually
 *      #GNUNET_DB_STATUS_SUCCESS_ONE_RESULT for success
 */
enum GNUNET_DB_QueryStatus
TMH_PG_activate_reserve (void *cls,
                         const char *instance_id,
                         const struct TALER_ReservePublicKeyP *reserve_pub,
                         const struct TALER_Amount *initial_exchange_balance);

#endif
