/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_deposit_to_transfer.c
 * @brief Implementation of the insert_deposit_to_transfer function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_insert_deposit_to_transfer.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_insert_deposit_to_transfer (
  void *cls,
  uint64_t deposit_serial,
  const struct TALER_EXCHANGE_DepositData *dd)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_uint64 (&deposit_serial),
    TALER_PQ_query_param_amount_with_currency (pg->conn,
                                 &dd->coin_contribution),
    GNUNET_PQ_query_param_timestamp (&dd->execution_time),
    GNUNET_PQ_query_param_auto_from_type (&dd->exchange_sig),
    GNUNET_PQ_query_param_auto_from_type (&dd->exchange_pub),
    GNUNET_PQ_query_param_auto_from_type (&dd->wtid),
    GNUNET_PQ_query_param_end
  };

  PREPARE (pg,
           "insert_deposit_to_transfer",
           "INSERT INTO merchant_deposit_to_transfer"
           "(deposit_serial"
           ",coin_contribution_value"
           ",credit_serial"
           ",execution_time"
           ",signkey_serial"
           ",exchange_sig"
           ") SELECT $1, $2, credit_serial, $3, signkey_serial, $4"
           " FROM merchant_transfers"
           " CROSS JOIN merchant_exchange_signing_keys"
           " WHERE exchange_pub=$5"
           "   AND wtid=$6");
  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "insert_deposit_to_transfer",
                                             params);
}
