/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_activate_reserve.c
 * @brief Implementation of the activate_reserve function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_activate_reserve.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_activate_reserve (void *cls,
                         const char *instance_id,
                         const struct TALER_ReservePublicKeyP *reserve_pub,
                         const struct TALER_Amount *initial_exchange_balance)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (instance_id),
    GNUNET_PQ_query_param_auto_from_type (reserve_pub),
    TALER_PQ_query_param_amount_with_currency (pg->conn,
                                 initial_exchange_balance),
    GNUNET_PQ_query_param_end
  };

  PREPARE (pg,
           "activate_reserve",
           "UPDATE merchant_reward_reserves SET"
           " exchange_initial_balance=$3"
           " WHERE reserve_pub=$2"
           " AND merchant_serial="
           "   (SELECT merchant_serial"
           "      FROM merchant_instances"
           "     WHERE merchant_id=$1)");
  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "activate_reserve",
                                             params);
}
