#!/bin/bash
# This file is part of TALER
# Copyright (C) 2014-2021 Taler Systems SA
#
# TALER is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 3, or
# (at your option) any later version.
#
# TALER is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with TALER; see the file COPYING.  If not, see
# <http://www.gnu.org/licenses/>
#

# Exit, with status code "skip" (no 'real' failure)
function exit_skip() {
    echo $1
    exit 77
}

. initialize_taler_system.sh


echo -n "Configuring 'default' instance ..."

STATUS=$(curl -H "Content-Type: application/json" -X POST \
    http://localhost:9966/management/instances \
    -d '{"auth":{"method":"token","token":"secret-token:new_value"},"payto_uris":["payto://x-taler-bank/localhost/43"],"id":"default","name":"default","address":{},"jurisdiction":{},"default_max_wire_fee":"TESTKUDOS:1", "default_max_deposit_fee":"TESTKUDOS:1","default_wire_fee_amortization":1,"default_wire_transfer_delay":{"d_us" : 3600000000},"default_pay_delay":{"d_us": 3600000000}}' \
    -w "%{http_code}" -s -o /dev/null)

if [ "$STATUS" != "204" ]
then
    echo 'should respond ok, instance created. got:' $STATUS
    exit 1
fi

echo " OK"


kill $MERCHANT_HTTPD_PID
wait $MERCHANT_HTTPD_PID

NEW_SECRET=secret-token:different_value

taler-merchant-httpd -a "${NEW_SECRET}" -c "${CONF}" -L DEBUG 2> taler-merchant-httpd.log &
MERCHANT_HTTPD_PID=$!
#taler-merchant-httpd -c $CONF -L DEBUG 2> taler-merchant-httpd.log &

echo -n "Waiting for the merchant..."
# Wait for merchant to be available (usually the slowest)
for n in `seq 1 50`
do
    echo -n "."
    sleep 0.1
    OK=0
    # merchant
    wget --waitretry=0 --timeout=1 http://localhost:9966/ -o /dev/null -O /dev/null >/dev/null || continue
    OK=1
    break
done

if [ "x$OK" != "x1" ]
then 
    exit_skip "Failed to start merchant backend"
fi

echo -n "Creating order to test auth is ok..."
STATUS=$(curl -H "Content-Type: application/json" -X POST \
    'http://localhost:9966/instances/default/private/orders' \
    -H 'Authorization: Bearer '$NEW_SECRET \
    -d '{"order":{"amount":"TESTKUDOS:1","summary":"payme"}}' \
    -w "%{http_code}" -s -o $LAST_RESPONSE)

if [ "$STATUS" != "200" ]
then
    echo 'should response ok, order created. got:' $STATUS `cat $LAST_RESPONSE`
    exit 1
fi

ORDER_ID=`jq -e -r .order_id < $LAST_RESPONSE`
TOKEN=`jq -e -r .token < $LAST_RESPONSE`

STATUS=$(curl "http://localhost:9966/instances/default/private/orders/${ORDER_ID}" \
     -H 'Authorization: Bearer '$NEW_SECRET \
     -w "%{http_code}" -s -o $LAST_RESPONSE)

if [ "$STATUS" != "200" ]
then
    echo 'should response ok, getting order info before claming it. got:' $STATUS `cat $LAST_RESPONSE`
    exit 1
fi

PAY_URL=`jq -e -r .taler_pay_uri < $LAST_RESPONSE`

echo OK order $ORDER_ID with $TOKEN 

echo -n "Configuring 'second' instance ..."

STATUS=$(curl -H "Content-Type: application/json" -X POST \
    -H 'Authorization: Bearer '$NEW_SECRET \
    http://localhost:9966/management/instances \
    -d '{"auth":{"method":"token","token":"secret-token:second"},"payto_uris":["payto://x-taler-bank/localhost/43"],"id":"second","name":"second","address":{},"jurisdiction":{},"default_max_wire_fee":"TESTKUDOS:1", "default_max_deposit_fee":"TESTKUDOS:1","default_wire_fee_amortization":1,"default_wire_transfer_delay":{"d_us" : 3600000000},"default_pay_delay":{"d_us": 3600000000}}' \
    -w "%{http_code}" -s -o /dev/null)

if [ "$STATUS" != "204" ]
then
    echo 'should respond ok, instance created. got:' $STATUS
    exit 1
fi

echo "OK"

echo -n "Updating 'second' instance token using the 'default' auth token..."

STATUS=$(curl -H "Content-Type: application/json" -X POST \
    -H 'Authorization: Bearer '$NEW_SECRET \
    http://localhost:9966/management/instances/second/auth \
    -d '{"method":"token","token":"secret-token:new_one"}' \
    -w "%{http_code}" -s -o /dev/null)

if [ "$STATUS" != "204" ]
then
    echo 'should respond ok, instance auth token changed. got:' $STATUS
    exit 1
fi

echo " OK"


exit 0
