/*
  This file is part of TALER
  Copyright (C) 2018 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 3, or
  (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public
  License along with TALER; see the file COPYING.  If not, see
  <http://www.gnu.org/licenses/>
*/
/**
 * @file testing_api_trait_hash.c
 * @brief offer any trait that is passed over as a hash code.
 * @author Marcello Stanisci
 */
#include "platform.h"
#include <taler/taler_signatures.h>
#include <taler/taler_exchange_service.h>
#include <taler/taler_testing_lib.h>

/**
 * FIXME: have _one_ pair of getter/setter for hash-coded
 * traits and define the getters/setters for tip id and hashed
 * contract terms as _macros_.
 */

#define TALER_TESTING_TRAIT_TIP_ID "tip-id"
#define TALER_TESTING_TRAIT_H_CONTRACT_TERMS "h-contract-terms"

int
TALER_TESTING_get_trait_tip_id
  (const struct TALER_TESTING_Command *cmd,
  unsigned int index,
  struct GNUNET_HashCode **tip_id)
{
  return cmd->traits (cmd->cls,
                      (const void **) tip_id,
                      TALER_TESTING_TRAIT_TIP_ID,
                      index);
}


struct TALER_TESTING_Trait
TALER_TESTING_make_trait_tip_id
  (unsigned int index,
  const struct GNUNET_HashCode *tip_id)
{
  struct TALER_TESTING_Trait ret = {
    .index = index,
    .trait_name = TALER_TESTING_TRAIT_TIP_ID,
    .ptr = (const void *) tip_id
  };
  return ret;
}


int
TALER_TESTING_get_trait_h_contract_terms
  (const struct TALER_TESTING_Command *cmd,
  unsigned int index,
  const struct GNUNET_HashCode **h_contract_terms)
{
  return cmd->traits (cmd->cls,
                      (const void **) h_contract_terms,
                      TALER_TESTING_TRAIT_H_CONTRACT_TERMS,
                      index);
}


struct TALER_TESTING_Trait
TALER_TESTING_make_trait_h_contract_terms
  (unsigned int index,
  const struct GNUNET_HashCode *h_contract_terms)
{
  struct TALER_TESTING_Trait ret = {
    .index = index,
    .trait_name = TALER_TESTING_TRAIT_H_CONTRACT_TERMS,
    .ptr = (const void *) h_contract_terms
  };
  return ret;
}
