#!/bin/bash
# This file is in the public domain.

. initialize_taler_system.sh

echo -n "Configuring default instance ..."

STATUS=$(curl -H "Content-Type: application/json" -X POST \
    -H 'Authorization: Bearer secret-token:super_secret' \
    http://localhost:9966/management/instances \
    -d '{"auth":{"method":"external"},"payto_uris":["payto://x-taler-bank/localhost/43"],"id":"default","name":"default","address":{},"jurisdiction":{},"default_max_wire_fee":"TESTKUDOS:1", "default_max_deposit_fee":"TESTKUDOS:1","default_wire_fee_amortization":1,"default_wire_transfer_delay":{"d_ms" : 3600000},"default_pay_delay":{"d_ms": 3600000}}' \
    -w "%{http_code}" -s -o /dev/null)

if [ "$STATUS" != "204" ]
then
    echo 'should respond ok, instance created. got:' $STATUS
    exit 1
fi

echo " OK"

echo -n "Configuring merchant instance ..."

STATUS=$(curl -H "Content-Type: application/json" -X POST \
    http://localhost:9966/management/instances \
    -d '{"auth":{"method":"token","token":"secret-token:other_secret"},"payto_uris":["payto://x-taler-bank/localhost/43"],"id":"test","name":"test","address":{},"jurisdiction":{},"default_max_wire_fee":"TESTKUDOS:1", "default_max_deposit_fee":"TESTKUDOS:1","default_wire_fee_amortization":1,"default_wire_transfer_delay":{"d_ms" : 3600000},"default_pay_delay":{"d_ms": 3600000}}' \
    -w "%{http_code}" -s -o /dev/null)

if [ "$STATUS" != "204" ]
then
    echo 'should respond ok, instance created. got:' $STATUS
    exit 1
fi

echo " OK"


echo -n "Deleting instance ..."

STATUS=$(curl -H "Content-Type: application/json" -X DELETE \
    "http://localhost:9966/management/instances/test" \
    -w "%{http_code}" -s -o /dev/null)


if [ "$STATUS" != "204" ]
then
    echo 'should respond ok, instance deleted. got:' $STATUS
    exit 1
fi

echo " OK"
echo -n "Purging instance ..."

STATUS=$(curl -H "Content-Type: application/json" -X DELETE \
    "http://localhost:9966/management/instances/test?purge=yes" \
    -w "%{http_code}" -s -o /dev/null)


if [ "$STATUS" != "204" ]
then
    echo 'should respond ok, instance deleted. got:' $STATUS
    exit 1
fi

echo " OK"

exit 0
