#!/usr/bin/env bash

# This script runs test from the wallet's integration test harness.
# If the wallet is not installed, the tests are skipped.
# Only tests from the "merchant" test suite are run.

set -eu

res=0
taler-wallet-cli testing run-integrationtests --dry --suites merchant 2&>/dev/null || res=$?

if [[ $res -ne 0 ]]; then
  echo "skipping wallet test harness"
  exit 77
fi


exec taler-wallet-cli testing run-integrationtests --suites merchant
