/*
  This file is part of TALER
  Copyright (C) 2018 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 3, or
  (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public
  License along with TALER; see the file COPYING.  If not, see
  <http://www.gnu.org/licenses/>
*/
/**
 * @file testing_api_trait_string.c
 * @brief offer traits that come as strings.
 * @author Marcello Stanisci
 */
#include "platform.h"
#include <taler/taler_signatures.h>
#include <taler/taler_exchange_service.h>
#include <taler/taler_testing_lib.h>

#define TALER_TESTING_TRAIT_PROPOSAL_REFERENCE "proposal-reference"
#define TALER_TESTING_TRAIT_COIN_REFERENCE "coin-reference"

int
TALER_TESTING_get_trait_proposal_reference
  (const struct TALER_TESTING_Command *cmd,
  unsigned int index,
  const char **proposal_reference)
{
  return cmd->traits (cmd->cls,
                      (const void **) proposal_reference,
                      TALER_TESTING_TRAIT_PROPOSAL_REFERENCE,
                      index);
}


struct TALER_TESTING_Trait
TALER_TESTING_make_trait_proposal_reference
  (unsigned int index,
  const char *proposal_reference)
{
  struct TALER_TESTING_Trait ret = {
    .index = index,
    .trait_name = TALER_TESTING_TRAIT_PROPOSAL_REFERENCE,
    .ptr = (const void *) proposal_reference
  };
  return ret;
}


int
TALER_TESTING_get_trait_coin_reference
  (const struct TALER_TESTING_Command *cmd,
  unsigned int index,
  const char **coin_reference)
{
  return cmd->traits (cmd->cls,
                      (const void **) coin_reference,
                      TALER_TESTING_TRAIT_COIN_REFERENCE,
                      index);
}


struct TALER_TESTING_Trait
TALER_TESTING_make_trait_coin_reference
  (unsigned int index,
  const char *coin_reference)
{
  struct TALER_TESTING_Trait ret = {
    .index = index,
    .trait_name = TALER_TESTING_TRAIT_COIN_REFERENCE,
    .ptr = (const void *) coin_reference
  };
  return ret;
}


/* end of testing_api_trait_string.c */
