/*
  This file is part of TALER
  (C) 2024 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Lesser General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_contract.c
 * @brief shared logic for contract terms handling
 * @author Christian Blättler
 */
#include "platform.h"
#include <jansson.h>
#include "taler-merchant-httpd_contract.h"

enum TALER_MerchantContractInputType
TMH_string_to_contract_input_type (const char *str)
{
  /* For now, only 'token' is the only supported option. */
  if (0 == strcmp("token", str))
  {
    return TALER_MCIT_TOKEN;
  }

  return TALER_MCIT_INVALID;
}

enum TALER_MerchantContractOutputType
TMH_string_to_contract_output_type (const char *str)
{
  /* For now, only 'token' is the only supported option. */
  if (0 == strcmp("token", str))
  {
    return TALER_MCOT_TOKEN;
  }

  return TALER_MCOT_INVALID;
}
