<!DOCTYPE html>
<!--
  This file is aprt of GNU TALER
  Copyright (C) 2014,2015, 2016 INRIA

  TALER is free software: you can
  redistribute it and/or modify it under the terms of the GNU
  Lesser General Public License (GNU LGPL) as published by the
  Free Software
  Foundation, either version 3 of the License, or (at your option)
  any later version.  The code is distributed WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU LGPL for more details.

  As additional permission under GNU LGPL version 3 section 7, you
  may distribute non-source (e.g., minimized or compacted) forms of
  that code without the copy of the GNU LGPL normally required by
  section 4, provided you include this license notice and a URL
  through which recipients can access the Corresponding Source.

-->
<html>
<head>
  <title>Toy Store - Payment method - Taler Demo</title>
  <link rel="stylesheet" type="text/css" href="web-common/style.css">
  <script type="application/javascript" src="web-common/taler-presence.js"></script>
</head>
<body>

<?php
  // get the donation information from form
  $donation_receiver = $_POST['donation_receiver'];
  $donation_amount = $_POST['donation_amount'];
  $donation_currency = $_POST['donation_currency'];

  // get frational part
  list ($donation_value, $donation_fraction) = explode (".", $donation_amount, 2);
  // create PHP session and store donation information in session
  $donation_fraction = (float) ("0." . $donation_fraction);
  session_start();
  $_SESSION['receiver'] = $donation_receiver;
  $_SESSION['amount_value'] = (int) $donation_amount;
  $_SESSION['amount_fraction'] = (int) ($donation_fraction * 1000000);
  $_SESSION['currency'] = $donation_currency;
?>

  <header>
    <div id="logo">
      <svg height="100" width="100">
        <circle cx="50" cy="50" r="40" stroke="darkcyan" stroke-width="6" fill="white" />
        <text x="19" y="82" font-family="Verdana" font-size="90" fill="darkcyan">S</text>
      </svg>
    </div>
    <!--#include virtual="web-common/dropdown-navbar.html" -->
    <h1 class="nav">Toy Store - Select payment method</h1>
  </header>

  <aside class="sidebar" id="left">
  </aside>

  <section id="main">
    <article>
      <h1>Select your payment method</h1>

      <p>
        This is an example for a "checkout" page of a Web shop.
        On the previous page, you have created the shopping cart
        and decided which product to buy (i.e. which project to
        donate KUDOS to).  Now in this page, you are asked to
        select a payment option.  As Taler is not yet universally
        used, we expect merchants will offer various payment options.
      </p>
      <p>
        The page also demonstrates how to only enable (or show) the Taler
        option if Taler is actually supported by the browser.  For example,
        if you disable the Taler extension now, the Taler payment option
        will be disabled in the page.  Naturally, you could also trivially
        hide the Taler option entirely by changing the visibility instead.
      </p>
      <p>
        Note that you MUST select Taler here for the demo to continue,
        as the other payment options are just placeholders and not
        really working in the demonstration.  Also, it is of course
        possible to ask the user to make this choice already on the
        previous page (with the shopping cart), we just separated the
        two steps to keep each step as simple as possible.
      </p>

      <form name="tform" action="" method="POST">
        <div id="opt-form" align="left"><br>
          <input type="radio" name="payment_system" value="lisa"
                 id="lisa-radio-button-id">Lisa</input>
          <br/>
          <input type="radio" name="payment_system" value="ycard">You Card</input>
          <br/>
          <input type="radio" name="payment_system" value="cardme">Card Me</input>
          <br/>
          <input type="radio" name="payment_system" value="taler"
                 checked
                 id="taler-radio-button-id" class="taler-installed-enable">Taler</input>
          <br/>
          <input type="button" onclick="pay(this.form)" value="Ok"></input>
        </div>
      </form>

    </article>
  </section>

<script type="text/javascript">

/* This function is called from "taler_pay" after
   we downloaded the JSON contract from the merchant.
   We now need to pass it to the extension. */
function handle_contract(contract_wrapper) {
  var cEvent = new CustomEvent('taler-confirm-contract', {
    detail: {
      contract_wrapper: contract_wrapper
    }
  });
  document.dispatchEvent(cEvent);
};


/* Trigger Taler contract generation on the server, and pass the
   contract to the extension once we got it. */
function taler_pay(form) {
  var contract_request = new XMLHttpRequest();

  /* Note that the URL we give here is specific to the Demo-shop
     and not dictated by the protocol: each web shop can
     have its own way of generating and transmitting the
     contract, there just must be a way to get the contract
     and to pass it to the wallet when the user selects 'Pay'. */
  contract_request.open("GET", "generate_taler_contract.php", true);
  contract_request.onload = function (e) {
    if (contract_request.readyState == 4) {
      if (contract_request.status == 200) {
        /* display contract_requestificate (i.e. it sends the JSON string
          to the extension) alert (contract_request.responseText); */
        console.log("response text:", contract_request.responseText);
        var contract_wrapper = JSON.parse(contract_request.responseText);
        if (!contract_wrapper) {
          console.error("response text is invalid JSON");
          return;
        }
        handle_contract(contract_wrapper);
      } else {
        /* There was an error obtaining the contract from the merchant,
           obviously this should not happen. To keep it simple, we just
           alert the user to the error. */
        alert("Failure to download contract from merchant " +
              "(" + contract_request.status + "):\n" +
              contract_request.responseText);
      }
    }
  };
  contract_request.onerror = function (e) {
    /* There was an error obtaining the contract from the merchant,
       obviously this should not happen. To keep it simple, we just
       alert the user to the error. */
    alert("Failure requesting the contract:\n" + contract_request.statusText);
  };
  contract_request.send();
}


/* This function is called when the user presses the
   'Ok' button.  We are now supposed to trigger the
   "correct" payment system logic. For this demo, we
   only handle "taler". */
function pay(form) {
  var choice = form.elements["payment_system"].value;
  if (choice == "taler") {
    taler_pay(form);
  }
  else {
    alert("You selected '" + choice + "', but we do not support this payment system in the demo.");
  }
};

</script>
</body>
</html>
