--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE auditor_purses
  (auditor_purses_rowid BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,purse_pub BYTEA PRIMARY KEY CHECK(LENGTH(purse_pub)=32)
  ,balance taler_amount NOT NULL DEFAULT(0,0)
  ,target taler_amount NOT NULL
  ,expiration_date INT8 NOT NULL
  );
COMMENT ON TABLE auditor_purses
  IS 'all of the purses and their respective balances that the auditor is aware of';
