// src/utils/types.ts
var AmlExchangeBackend;
((AmlExchangeBackend2) => {
  let AmlState;
  ((AmlState2) => {
    AmlState2[AmlState2["normal"] = 0] = "normal";
    AmlState2[AmlState2["pending"] = 1] = "pending";
    AmlState2[AmlState2["frozen"] = 2] = "frozen";
  })(AmlState = AmlExchangeBackend2.AmlState || (AmlExchangeBackend2.AmlState = {}));
})(AmlExchangeBackend || (AmlExchangeBackend = {}));

// src/utils/converter.ts
var amlStateConverter = {
  toStringUI: stringifyAmlState,
  fromStringUI: parseAmlState
};
function stringifyAmlState(s2) {
  if (s2 === void 0)
    return "";
  switch (s2) {
    case AmlExchangeBackend.AmlState.normal:
      return "normal";
    case AmlExchangeBackend.AmlState.pending:
      return "pending";
    case AmlExchangeBackend.AmlState.frozen:
      return "frozen";
  }
}
function parseAmlState(s2) {
  switch (s2) {
    case "normal":
      return AmlExchangeBackend.AmlState.normal;
    case "pending":
      return AmlExchangeBackend.AmlState.pending;
    case "frozen":
      return AmlExchangeBackend.AmlState.frozen;
    default:
      throw Error(`unknown AML state: ${s2}`);
  }
}

// src/forms/simplest.ts
var v1 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Simple form`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "comment",
            label: i18n.str`Comments`
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    var _a, _b;
    return {
      comment: {
        help: ((_b = (_a = v2.comment) == null ? void 0 : _a.length) != null ? _b : 0) > 100 ? "keep it short" : ""
      },
      threshold: {
        disabled: v2.state === AmlExchangeBackend.AmlState.frozen
      }
    };
  }
});
function resolutionSection(current, i18n) {
  return {
    title: i18n.str`Resolution`,
    description: `Current state is ${amlStateConverter.toStringUI(
      current.state
    )} and threshold at `,
    fields: [
      {
        type: "choiceHorizontal",
        props: {
          name: "state",
          label: i18n.str`New state`,
          converter: amlStateConverter,
          choices: [
            {
              value: AmlExchangeBackend.AmlState.frozen,
              label: i18n.str`Frozen`
            },
            {
              value: AmlExchangeBackend.AmlState.pending,
              label: i18n.str`Pending`
            },
            {
              value: AmlExchangeBackend.AmlState.normal,
              label: i18n.str`Normal`
            }
          ]
        }
      },
      {
        type: "amount",
        props: {
          name: "threshold",
          label: i18n.str`New threshold`
        }
      }
    ]
  };
}

// src/forms/902_11e.ts
var v12 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Establishing of the controlling person of operating legal entities and partnerships both not quoted on the stock exchange`,
      description: i18n.str`for operating legal entities and partnership that are contracting partner as well as analogously for operating legal entities and partnership that are beneficial owners.`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "declares",
            label: i18n.str`The contracting partner hereby declares that`,
            required: true,
            choices: [
              {
                label: i18n.str`the person(s) listed below is/are holding 25% or more of the contracting partner's shares (capital shares or voting rights)`,
                value: "25-or-more"
              },
              {
                label: i18n.str`if the capital shares or voting rights cannot be determined or in case there are no capital shares or voting rights 25% or more, the contracting partner hereby declares that the person(s) listed below is/are controlling the contracting partner in other ways`,
                value: "controlling-in-other-ways"
              },
              {
                label: i18n.str`in case this/these person(s) cannot be determined or this/these person(s) does/do not exist, the contracting partner hereby declares that the person(s) listed below is/are the managing director(s)`,
                value: "managing-director"
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            name: "people",
            label: i18n.str`People`,
            required: true,
            placeholder: i18n.str`this is the placeholder`,
            fields: [
              {
                type: "text",
                props: {
                  name: "lastName",
                  label: i18n.str`Last name(s)`,
                  required: true
                }
              },
              {
                type: "text",
                props: {
                  name: "firstName",
                  label: i18n.str`First name(s)`,
                  required: true
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile`,
                  required: true
                }
              }
            ],
            labelField: "lastName"
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "fiduciaryAssets",
            label: i18n.str`Fiduciary holding assets`,
            help: i18n.str`Is a third person the beneficial owner of the assets held in the account/securities account?`,
            required: true,
            choices: [
              {
                label: i18n.str`No`,
                value: "no"
              },
              {
                label: i18n.str`Yes`,
                value: "yes",
                description: i18n.str`The relevant information regarding the beneficial owner has to be obtained by filling in a separate VQF doc. No. 902.9`
              }
            ]
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    return {
      people: {
        hidden: v2.declares !== "controlling-in-other-ways" && v2.declares !== "managing-director"
      }
    };
  }
});

// src/forms/902_12e.ts
var v13 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Foundations`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`
          }
        },
        {
          type: "text",
          props: {
            name: "knownAs",
            label: i18n.str`The undersigned hereby declare(s) that as board member of the foundation, or of the highest supervisory body of an underlying company of a foundation, known as`
          }
        },
        {
          type: "text",
          props: {
            name: "foundation.name",
            label: i18n.str`Name and information pertaining to the foundation`
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "foundation.type",
            label: i18n.str`Type of foundation`,
            choices: [
              {
                label: i18n.str`Discretionary foundation`,
                value: "discretionary"
              },
              {
                label: i18n.str`Non-discretionary foundation`,
                value: "non-discretionary"
              }
            ]
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "foundation.revocability",
            label: i18n.str`Revocability`,
            choices: [
              {
                label: i18n.str`Revocable foundation`,
                value: "revocable"
              },
              {
                label: i18n.str`Irrevocable foundation`,
                value: "irrevocable"
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Information pertaining to the (ultimate economic, not fiduciary) founder (individual(s) or entity/ies)`,
            labelField: "fullName",
            name: "founders",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  help: i18n.str`if deceased`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToRevoke",
                  required: true,
                  label: i18n.str`Does the founder have the right to revoke the foundation?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes"
                    },
                    {
                      label: i18n.str`No`,
                      value: "no"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`If the foundation results from the restructuring of pre-existing foundation (re-settlement) or the merger of pre-existing foundations, the following information pertaining to the (actual) founder(s) of the pre-existing foundation(s) has to be given`,
            labelField: "fullName",
            name: "preExistingFounders",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  help: i18n.str`if deceased`
                }
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Pertaining to the beneficiary/-ies at the time of the signing of this form`,
            labelField: "fullName",
            name: "beneficiaryWhenSigning",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label: i18n.str`Has the beneficiary an actual right to claim distribution?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes"
                    },
                    {
                      label: i18n.str`No`,
                      value: "no"
                    }
                  ]
                }
              },
              {
                type: "textArea",
                props: {
                  label: i18n.str`in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the founder) known at the time of the signing of this form`,
                  name: "beneficiaryExtra"
                }
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Information pertaining to further persons having the right to determine or nominate representatives (e.g.) members of the foundation board), if these representatives may dispose over the assets or have the right to change the distribution of the assets or the nomination of beneficiaries`,
            labelField: "fullName",
            name: "withRightToNominate",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label: i18n.str`has the person the right to revoke the foundation?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes"
                    },
                    {
                      label: i18n.str`No`,
                      value: "no"
                    }
                  ]
                }
              },
              {
                type: "textArea",
                props: {
                  label: i18n.str`in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the founder) known at the time of the signing of this form`,
                  name: "beneficiaryExtra"
                }
              }
            ]
          }
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: i18n.str`Signature`
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    var _a, _b;
    return {
      founders: {
        elements: ((_a = v2.founders) != null ? _a : []).map((f2) => {
          var _a2;
          return {
            rightToRevoke: {
              hidden: ((_a2 = v2.foundation) == null ? void 0 : _a2.revocability) !== "revocable"
            }
          };
        })
      },
      withRightToNominate: {
        elements: ((_b = v2.withRightToNominate) != null ? _b : []).map((f2) => {
          var _a2;
          return {
            rightToRevoke: {
              hidden: ((_a2 = v2.foundation) == null ? void 0 : _a2.revocability) !== "revocable"
            }
          };
        })
      }
    };
  }
});

// src/forms/902_13e.ts
var v14 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Declaration for trusts`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`
          }
        },
        {
          type: "text",
          props: {
            name: "knownAs",
            label: i18n.str`The undersigned hereby declare(s) that as trustee or a member of highest supervisory body of an underlying company of a trust known as`
          }
        },
        {
          type: "text",
          props: {
            name: "trust.name",
            label: i18n.str`Name and information pertaining to the trust`
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "trust.type",
            label: i18n.str`Type of trust`,
            choices: [
              {
                label: i18n.str`Discretionary trust`,
                value: "discretionary"
              },
              {
                label: i18n.str`Non-discretionary trust`,
                value: "non-discretionary"
              }
            ]
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "trust.revocability",
            label: i18n.str`Revocability`,
            choices: [
              {
                label: i18n.str`Revocable foundation`,
                value: "revocable"
              },
              {
                label: i18n.str`Irrevocable foundation`,
                value: "irrevocable"
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Information pertaining to the (ultimate economic, not fiduciary) settlor of the trust (individual(s) or entity/ies)`,
            labelField: "fullName",
            name: "settlors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy"
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  pattern: "dd/MM/yyyy",
                  // help: i18n.str`if deceased. format 'dd/MM/yyyy'`,
                  help: i18n.str`if deceased'`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToRevoke",
                  required: true,
                  label: i18n.str`Does the founder have the right to revoke the trust?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes"
                    },
                    {
                      label: i18n.str`No`,
                      value: "no"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`If the trust results from the restructuring of pre-existing trust (re-settlement) or the merger of pre-existing trusts, the following information pertaining to the (actual) settlor of the pre-existing trust(s) has to be given`,
            labelField: "fullName",
            name: "preExistingSettlors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy"
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfDeath",
                  label: i18n.str`Date of death`,
                  pattern: "dd/MM/yyyy",
                  help: i18n.str`if deceased.`
                  // help: i18n.str`if deceased. format 'dd/MM/yyyy'`,
                }
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Pertaining to the beneficiary/-ies at the time of the signing of this form`,
            labelField: "fullName",
            name: "beneficiaryWhenSigning",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy"
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label: i18n.str`Has the beneficiary an actual right to claim distribution?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes"
                    },
                    {
                      label: i18n.str`No`,
                      value: "no"
                    }
                  ]
                }
              },
              {
                type: "textArea",
                props: {
                  label: i18n.str`in addition to certain beneficiaries or if there is/are no defined beneficiary/ies pertaining to (a) group(s) of beneficiaries (e.g. descendants of the settlor) known at the time of the signing of this form`,
                  name: "beneficiaryExtra"
                }
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Information pertaining to the protector(s) as well as (a) further person(s) having the right to revoke the trust (in case of revocable trusts) or to appoint the trustee of a trust`,
            labelField: "asd",
            name: "nothing",
            fields: []
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Information pertaining to the protectors`,
            labelField: "fullName",
            name: "protectors",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label: i18n.str`Does the protector have the right to revoke the trust?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes"
                    },
                    {
                      label: i18n.str`No`,
                      value: "no"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Information pertaining to further persons`,
            labelField: "fullName",
            name: "furtherPersons",
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile/registered office`
                }
              },
              {
                type: "text",
                props: {
                  name: "country",
                  label: i18n.str`Country`
                }
              },
              {
                type: "text",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "rightToClaim",
                  label: i18n.str`Has this further person the right to revoke the trust?`,
                  choices: [
                    {
                      label: i18n.str`Yes`,
                      value: "yes"
                    },
                    {
                      label: i18n.str`No`,
                      value: "no"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: i18n.str`Signature`
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    var _a, _b, _c;
    return {
      settlors: {
        elements: ((_a = v2.settlors) != null ? _a : []).map((f2) => {
          var _a2;
          return {
            rightToRevoke: {
              hidden: ((_a2 = v2.foundation) == null ? void 0 : _a2.revocability) !== "revocable"
            }
          };
        })
      },
      protectors: {
        elements: ((_b = v2.protectors) != null ? _b : []).map((f2) => {
          var _a2;
          return {
            rightToRevoke: {
              hidden: ((_a2 = v2.foundation) == null ? void 0 : _a2.revocability) !== "revocable"
            }
          };
        })
      },
      furtherPersons: {
        elements: ((_c = v2.furtherPersons) != null ? _c : []).map((f2) => {
          var _a2;
          return {
            rightToRevoke: {
              hidden: ((_a2 = v2.foundation) == null ? void 0 : _a2.revocability) !== "revocable"
            }
          };
        })
      }
    };
  }
});

// src/forms/902_15e.ts
var v15 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Information on life insurance policies with separately managed accounts/securities accounts`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`
          }
        },
        {
          type: "text",
          props: {
            name: "contractualRelationship",
            label: i18n.str`Name or number of the contractual relationship between the contracting party and the financial intermediary`
          }
        },
        {
          type: "text",
          props: {
            name: "insurancePolicy",
            label: i18n.str`Insurance policy`
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`The contracting partner confirms in accordance with Art. 41a SRO Regulations that it is a licensed and state-supervised insurance company and that it has entered into the above-mentioned contractual relationship the assets connected to the life insurance policy also mentioned above.`
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`In relation with the above insurance policy, the contracting partner gives the following further details`
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`Policy holder`,
            fields: [
              {
                type: "text",
                props: {
                  name: "holder.fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "holder.address",
                  label: i18n.str`Actual address of domicile/registered office (incl. country)`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "holder.dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy"
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                }
              },
              {
                type: "text",
                props: {
                  name: "holder.nationality",
                  label: i18n.str`Nationality`
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`Person actually (not in a fiduciary capacity) paying the premiums (to be filled in if not identical with point 1 above)`,
            fields: [
              {
                type: "text",
                props: {
                  name: "premiumPayer.fullName",
                  label: i18n.str`Last name(s), first name(s)/entity`
                }
              },
              {
                type: "text",
                props: {
                  name: "premiumPayer.address",
                  label: i18n.str`Actual address of domicile/registered office (incl. country)`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "premiumPayer.dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy"
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                }
              },
              {
                type: "text",
                props: {
                  name: "premiumPayer.nationality",
                  label: i18n.str`Nationality`
                }
              }
            ]
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`The contracting partner hereby undertakes to automatically inform the financial intermediary of any changes. The contracting partner hereby also declares having been given permission by the above individuals and/or entities to transmit their data to the financial intermediary`
          }
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: i18n.str`Signature`
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`It is a criminal offense to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery)`
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ]
});

// src/forms/declaration.ts
var defaultUIForms = {
  currencies: () => [],
  languages: () => [],
  forms: () => []
};
var uiForms = "amlExchangeBackoffice" in globalThis ? globalThis.amlExchangeBackoffice : defaultUIForms;

// src/forms/902_1e.ts
var v16 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Information on customer`,
      description: i18n.str`The customer is the person with whom the member concludes the contract with regard to the financial service provided (civil law). Does the member act as director of a domiciliary company, this domiciliary company is the customer.`,
      fields: [
        {
          type: "choiceStacked",
          props: {
            name: "customerType",
            label: i18n.str`Type of customer`,
            required: true,
            choices: [
              {
                label: i18n.str`Natural person`,
                value: "natural"
              },
              {
                label: i18n.str`Legal entity`,
                value: "legal"
              }
            ]
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.fullName",
            label: i18n.str`Full name`,
            required: true
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.address",
            label: i18n.str`Residential address`,
            required: true
          }
        },
        {
          type: "integer",
          props: {
            name: "naturalCustomer.telephone",
            label: i18n.str`Telephone`
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.email",
            label: i18n.str`E-mail`
          }
        },
        {
          type: "absoluteTime",
          props: {
            name: "naturalCustomer.dateOfBirth",
            label: i18n.str`Date of birth`,
            required: true
            // help: i18n.str`format 'dd/MM/yyyy'`,
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.nationality",
            label: i18n.str`Nationality`,
            required: true
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.document",
            label: i18n.str`Identification document`,
            required: true
          }
        },
        {
          type: "file",
          props: {
            name: "naturalCustomer.documentAttachment",
            label: i18n.str`Document attachment`,
            required: true,
            maxBites: 2 * 1024 * 1024,
            accept: ".png",
            help: i18n.str`Max size of 2 mega bytes`
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.companyName",
            label: i18n.str`Company name`
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.office",
            label: i18n.str`Registered office`
          }
        },
        {
          type: "text",
          props: {
            name: "naturalCustomer.companyDocument",
            label: i18n.str`Company identification document`
          }
        },
        {
          type: "file",
          props: {
            name: "naturalCustomer.companyDocumentAttachment",
            label: i18n.str`Document attachment`,
            required: true,
            maxBites: 2 * 1024 * 1024,
            accept: ".png",
            help: i18n.str`Max size of 2 mega bytes`
          }
        },
        {
          type: "text",
          props: {
            name: "legalCustomer.companyName",
            label: i18n.str`Company name`,
            required: true
          }
        },
        {
          type: "text",
          props: {
            name: "legalCustomer.domicile",
            label: i18n.str`Domicile`,
            required: true
          }
        },
        {
          type: "text",
          props: {
            name: "legalCustomer.contactPerson",
            label: i18n.str`Contact person`
          }
        },
        {
          type: "text",
          props: {
            name: "legalCustomer.telephone",
            label: i18n.str`Telephone`
          }
        },
        {
          type: "text",
          props: {
            name: "legalCustomer.email",
            label: i18n.str`E-mail`
          }
        },
        {
          type: "text",
          props: {
            name: "legalCustomer.document",
            label: i18n.str`Identification document`,
            help: i18n.str`Not older than 12 month`
          }
        },
        {
          type: "file",
          props: {
            name: "legalCustomer.documentAttachment",
            label: i18n.str`Document attachment`,
            required: true,
            maxBites: 2 * 1024 * 1024,
            accept: ".png",
            help: i18n.str`Max size of 2 mega bytes`
          }
        }
      ]
    },
    {
      title: i18n.str`Information on the natural persons who establish the business relationship for legal entities and partnerships`,
      description: i18n.str`For legal entities and partnerships the identity of the natural persons who establish the business relationship must be verified.`,
      fields: [
        {
          type: "array",
          props: {
            name: "businessEstablisher",
            label: i18n.str`Persons`,
            required: true,
            placeholder: i18n.str`this is the placeholder`,
            fields: [
              {
                type: "text",
                props: {
                  name: "fullName",
                  label: i18n.str`Full name`,
                  required: true
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Residential address`,
                  required: true
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  required: true
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`,
                  required: true
                }
              },
              {
                type: "text",
                props: {
                  name: "typeOfAuthorization",
                  label: i18n.str`Type of authorization (signatory of representation)`,
                  required: true
                }
              },
              {
                type: "file",
                props: {
                  name: "documentAttachment",
                  label: i18n.str`Identification document attachment`,
                  required: true,
                  maxBites: 2 * 1024 * 1024,
                  accept: ".png",
                  help: i18n.str`Max size of 2 mega bytes`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  name: "powerOfAttorneyArrangements",
                  label: i18n.str`Power of attorney arrangements`,
                  required: true,
                  choices: [
                    {
                      label: i18n.str`CR extract`,
                      value: "cr"
                    },
                    {
                      label: i18n.str`Mandate`,
                      value: "mandate"
                    },
                    {
                      label: i18n.str`Other`,
                      value: "other"
                    }
                  ]
                }
              },
              {
                type: "text",
                props: {
                  name: "powerOfAttorneyArrangementsOther",
                  label: i18n.str`Power of attorney arrangements`,
                  required: true
                }
              }
            ],
            labelField: "fullName"
          }
        }
      ]
    },
    {
      title: i18n.str`Acceptance of business relationship`,
      fields: [
        {
          type: "absoluteTime",
          props: {
            name: "acceptance.when",
            pattern: "dd/MM/yyyy",
            label: i18n.str`Date (conclusion of contract)`
            // help: i18n.str`format 'dd/MM/yyyy'`,
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "acceptance.acceptedBy",
            label: i18n.str`Accepted by`,
            required: true,
            choices: [
              {
                label: i18n.str`Face-to-face meeting with customer`,
                value: "face-to-face"
              },
              {
                label: i18n.str`Correspondence: authenticated copy of identification document obtained`,
                value: "correspondence-document"
              },
              {
                label: i18n.str`Correspondence: residential address validated`,
                value: "correspondence-address"
              }
            ]
          }
        },
        {
          type: "choiceStacked",
          props: {
            name: "acceptance.typeOfCorrespondence",
            label: i18n.str`Type of correspondence service`,
            choices: [
              {
                label: i18n.str`to the customer`,
                value: "customer"
              },
              {
                label: i18n.str`hold at bank`,
                value: "bank"
              },
              {
                label: i18n.str`to the member`,
                value: "member"
              },
              {
                label: i18n.str`to a third party`,
                value: "third-party"
              }
            ]
          }
        },
        {
          type: "text",
          props: {
            name: "acceptance.thirdPartyFullName",
            label: i18n.str`Third party full name`,
            required: true
          }
        },
        {
          type: "text",
          props: {
            name: "acceptance.thirdPartyAddress",
            label: i18n.str`Third party  address`,
            required: true
          }
        },
        {
          type: "selectMultiple",
          props: {
            name: "acceptance.language",
            label: i18n.str`Languages`,
            choices: uiForms.currencies(i18n),
            unique: true
          }
        },
        {
          type: "textArea",
          props: {
            name: "acceptance.furtherInformation",
            label: i18n.str`Further information`
          }
        }
      ]
    },
    {
      title: i18n.str`Information on the beneficial owner of the assets and/or controlling person`,
      description: i18n.str`Establishment of the beneficial owner of the assets and/or controlling person`,
      fields: [
        {
          type: "choiceStacked",
          props: {
            name: "establishment",
            label: i18n.str`The customer is`,
            required: true,
            choices: [
              {
                label: i18n.str`a natural person and there are no doubts that this person is the sole beneficial owner of the assets`,
                value: "natural"
              },
              {
                label: i18n.str`a foundation (or a similar construct; incl. underlying companies)`,
                value: "foundation"
              },
              {
                label: i18n.str`a trust (incl. underlying companies)`,
                value: "trust"
              },
              {
                label: i18n.str`a life insurance policy with separately managed accounts/securities accounts`,
                value: "insurance-wrapper"
              },
              {
                label: i18n.str`all other cases`,
                value: "other"
              }
            ]
          }
        }
      ]
    },
    {
      title: i18n.str`Evaluation with regard to embargo procedures/terrorism lists on establishing the business relationship`,
      description: i18n.str`Verification whether the customer, beneficial owners of the assets, controlling persons, authorized representatives or other involved persons are listed on an embargo/terrorism list (date of verification/result)`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "embargoEvaluation",
            help: i18n.str`The evaluation must be made at the beginning of the business relationship and has to be repeated in the case of permanent business relationship every time the according lists are updated.`,
            label: i18n.str`Evaluation`
          }
        }
      ]
    },
    {
      title: i18n.str`In the case of cash transactions/occasional customers: Information on type and purpose of business relationship`,
      description: i18n.str`These details are only necessary for occasional customers, i.e. money exchange, money and asset transfer or other cash transactions provided that no customer profile (VQF doc. No. 902.5) is created`,
      fields: [
        {
          type: "choiceStacked",
          props: {
            name: "cashTransactions.typeOfBusiness",
            label: i18n.str`Type of business relationship`,
            choices: [
              {
                label: i18n.str`Money exchange`,
                value: "money-exchange"
              },
              {
                label: i18n.str`Money and asset transfer`,
                value: "money-and-asset-transfer"
              },
              {
                label: i18n.str`Other cash transactions. Specify below`,
                value: "other"
              }
            ]
          }
        },
        {
          type: "text",
          props: {
            name: "cashTransactions.otherTypeOfBusiness",
            required: true,
            label: i18n.str`Specify other cash transactions:`
          }
        },
        {
          type: "textArea",
          props: {
            name: "cashTransactions.purpose",
            label: i18n.str`Purpose of the business relationship (purpose of service requested)`
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    var _a, _b, _c, _d;
    return {
      fullName: {
        disabled: true
      },
      businessEstablisher: {
        elements: ((_a = v2.businessEstablisher) != null ? _a : []).map((be) => {
          return {
            powerOfAttorneyArrangementsOther: {
              hidden: be.powerOfAttorneyArrangements !== "other"
            }
          };
        })
      },
      acceptance: {
        thirdPartyFullName: {
          hidden: ((_b = v2.acceptance) == null ? void 0 : _b.typeOfCorrespondence) !== "third-party"
        },
        thirdPartyAddress: {
          hidden: ((_c = v2.acceptance) == null ? void 0 : _c.typeOfCorrespondence) !== "third-party"
        }
      },
      cashTransactions: {
        otherTypeOfBusiness: {
          hidden: ((_d = v2.cashTransactions) == null ? void 0 : _d.typeOfBusiness) !== "other"
        }
      },
      naturalCustomer: {
        fullName: {
          hidden: v2.customerType !== "natural"
        },
        address: {
          hidden: v2.customerType !== "natural"
        },
        telephone: {
          hidden: v2.customerType !== "natural"
        },
        email: {
          hidden: v2.customerType !== "natural"
        },
        dateOfBirth: {
          hidden: v2.customerType !== "natural"
        },
        nationality: {
          hidden: v2.customerType !== "natural"
        },
        document: {
          hidden: v2.customerType !== "natural"
        },
        companyName: {
          hidden: v2.customerType !== "natural"
        },
        office: {
          hidden: v2.customerType !== "natural"
        },
        companyDocument: {
          hidden: v2.customerType !== "natural"
        },
        companyDocumentAttachment: {
          hidden: v2.customerType !== "natural"
        },
        documentAttachment: {
          hidden: v2.customerType !== "natural"
        }
      },
      legalCustomer: {
        companyName: {
          hidden: v2.customerType !== "legal"
        },
        contactPerson: {
          hidden: v2.customerType !== "legal"
        },
        document: {
          hidden: v2.customerType !== "legal"
        },
        domicile: {
          hidden: v2.customerType !== "legal"
        },
        email: {
          hidden: v2.customerType !== "legal"
        },
        telephone: {
          hidden: v2.customerType !== "legal"
        },
        documentAttachment: {
          hidden: v2.customerType !== "legal"
        }
      }
    };
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js
var n;
var l;
var u;
var i;
var t;
var o;
var r;
var f = {};
var e = [];
var c = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
function s(n2, l2) {
  for (var u2 in l2)
    n2[u2] = l2[u2];
  return n2;
}
function a(n2) {
  var l2 = n2.parentNode;
  l2 && l2.removeChild(n2);
}
function h(l2, u2, i2) {
  var t2, o2, r2, f2 = {};
  for (r2 in u2)
    "key" == r2 ? t2 = u2[r2] : "ref" == r2 ? o2 = u2[r2] : f2[r2] = u2[r2];
  if (arguments.length > 2 && (f2.children = arguments.length > 3 ? n.call(arguments, 2) : i2), "function" == typeof l2 && null != l2.defaultProps)
    for (r2 in l2.defaultProps)
      void 0 === f2[r2] && (f2[r2] = l2.defaultProps[r2]);
  return v(l2, f2, t2, o2, null);
}
function v(n2, i2, t2, o2, r2) {
  var f2 = { type: n2, props: i2, key: t2, ref: o2, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, __h: null, constructor: void 0, __v: null == r2 ? ++u : r2 };
  return null == r2 && null != l.vnode && l.vnode(f2), f2;
}
function p(n2) {
  return n2.children;
}
function d(n2, l2) {
  this.props = n2, this.context = l2;
}
function _(n2, l2) {
  if (null == l2)
    return n2.__ ? _(n2.__, n2.__.__k.indexOf(n2) + 1) : null;
  for (var u2; l2 < n2.__k.length; l2++)
    if (null != (u2 = n2.__k[l2]) && null != u2.__e)
      return u2.__e;
  return "function" == typeof n2.type ? _(n2) : null;
}
function k(n2) {
  var l2, u2;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l2 = 0; l2 < n2.__k.length; l2++)
      if (null != (u2 = n2.__k[l2]) && null != u2.__e) {
        n2.__e = n2.__c.base = u2.__e;
        break;
      }
    return k(n2);
  }
}
function b(n2) {
  (!n2.__d && (n2.__d = true) && t.push(n2) && !g.__r++ || o !== l.debounceRendering) && ((o = l.debounceRendering) || setTimeout)(g);
}
function g() {
  for (var n2; g.__r = t.length; )
    n2 = t.sort(function(n3, l2) {
      return n3.__v.__b - l2.__v.__b;
    }), t = [], n2.some(function(n3) {
      var l2, u2, i2, t2, o2, r2;
      n3.__d && (o2 = (t2 = (l2 = n3).__v).__e, (r2 = l2.__P) && (u2 = [], (i2 = s({}, t2)).__v = t2.__v + 1, j(r2, t2, i2, l2.__n, void 0 !== r2.ownerSVGElement, null != t2.__h ? [o2] : null, u2, null == o2 ? _(t2) : o2, t2.__h), z(u2, t2), t2.__e != o2 && k(t2)));
    });
}
function w(n2, l2, u2, i2, t2, o2, r2, c2, s2, a2) {
  var h2, y, d2, k2, b2, g2, w2, x = i2 && i2.__k || e, C2 = x.length;
  for (u2.__k = [], h2 = 0; h2 < l2.length; h2++)
    if (null != (k2 = u2.__k[h2] = null == (k2 = l2[h2]) || "boolean" == typeof k2 ? null : "string" == typeof k2 || "number" == typeof k2 || "bigint" == typeof k2 ? v(null, k2, null, null, k2) : Array.isArray(k2) ? v(p, { children: k2 }, null, null, null) : k2.__b > 0 ? v(k2.type, k2.props, k2.key, k2.ref ? k2.ref : null, k2.__v) : k2)) {
      if (k2.__ = u2, k2.__b = u2.__b + 1, null === (d2 = x[h2]) || d2 && k2.key == d2.key && k2.type === d2.type)
        x[h2] = void 0;
      else
        for (y = 0; y < C2; y++) {
          if ((d2 = x[y]) && k2.key == d2.key && k2.type === d2.type) {
            x[y] = void 0;
            break;
          }
          d2 = null;
        }
      j(n2, k2, d2 = d2 || f, t2, o2, r2, c2, s2, a2), b2 = k2.__e, (y = k2.ref) && d2.ref != y && (w2 || (w2 = []), d2.ref && w2.push(d2.ref, null, k2), w2.push(y, k2.__c || b2, k2)), null != b2 ? (null == g2 && (g2 = b2), "function" == typeof k2.type && k2.__k === d2.__k ? k2.__d = s2 = m(k2, s2, n2) : s2 = A(n2, k2, d2, x, b2, s2), "function" == typeof u2.type && (u2.__d = s2)) : s2 && d2.__e == s2 && s2.parentNode != n2 && (s2 = _(d2));
    }
  for (u2.__e = g2, h2 = C2; h2--; )
    null != x[h2] && N(x[h2], x[h2]);
  if (w2)
    for (h2 = 0; h2 < w2.length; h2++)
      M(w2[h2], w2[++h2], w2[++h2]);
}
function m(n2, l2, u2) {
  for (var i2, t2 = n2.__k, o2 = 0; t2 && o2 < t2.length; o2++)
    (i2 = t2[o2]) && (i2.__ = n2, l2 = "function" == typeof i2.type ? m(i2, l2, u2) : A(u2, i2, i2, t2, i2.__e, l2));
  return l2;
}
function A(n2, l2, u2, i2, t2, o2) {
  var r2, f2, e2;
  if (void 0 !== l2.__d)
    r2 = l2.__d, l2.__d = void 0;
  else if (null == u2 || t2 != o2 || null == t2.parentNode)
    n:
      if (null == o2 || o2.parentNode !== n2)
        n2.appendChild(t2), r2 = null;
      else {
        for (f2 = o2, e2 = 0; (f2 = f2.nextSibling) && e2 < i2.length; e2 += 1)
          if (f2 == t2)
            break n;
        n2.insertBefore(t2, o2), r2 = o2;
      }
  return void 0 !== r2 ? r2 : t2.nextSibling;
}
function C(n2, l2, u2, i2, t2) {
  var o2;
  for (o2 in u2)
    "children" === o2 || "key" === o2 || o2 in l2 || H(n2, o2, null, u2[o2], i2);
  for (o2 in l2)
    t2 && "function" != typeof l2[o2] || "children" === o2 || "key" === o2 || "value" === o2 || "checked" === o2 || u2[o2] === l2[o2] || H(n2, o2, l2[o2], u2[o2], i2);
}
function $(n2, l2, u2) {
  "-" === l2[0] ? n2.setProperty(l2, u2) : n2[l2] = null == u2 ? "" : "number" != typeof u2 || c.test(l2) ? u2 : u2 + "px";
}
function H(n2, l2, u2, i2, t2) {
  var o2;
  n:
    if ("style" === l2)
      if ("string" == typeof u2)
        n2.style.cssText = u2;
      else {
        if ("string" == typeof i2 && (n2.style.cssText = i2 = ""), i2)
          for (l2 in i2)
            u2 && l2 in u2 || $(n2.style, l2, "");
        if (u2)
          for (l2 in u2)
            i2 && u2[l2] === i2[l2] || $(n2.style, l2, u2[l2]);
      }
    else if ("o" === l2[0] && "n" === l2[1])
      o2 = l2 !== (l2 = l2.replace(/Capture$/, "")), l2 = l2.toLowerCase() in n2 ? l2.toLowerCase().slice(2) : l2.slice(2), n2.l || (n2.l = {}), n2.l[l2 + o2] = u2, u2 ? i2 || n2.addEventListener(l2, o2 ? T : I, o2) : n2.removeEventListener(l2, o2 ? T : I, o2);
    else if ("dangerouslySetInnerHTML" !== l2) {
      if (t2)
        l2 = l2.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
      else if ("href" !== l2 && "list" !== l2 && "form" !== l2 && "tabIndex" !== l2 && "download" !== l2 && l2 in n2)
        try {
          n2[l2] = null == u2 ? "" : u2;
          break n;
        } catch (n3) {
        }
      "function" == typeof u2 || (null == u2 || false === u2 && -1 == l2.indexOf("-") ? n2.removeAttribute(l2) : n2.setAttribute(l2, u2));
    }
}
function I(n2) {
  this.l[n2.type + false](l.event ? l.event(n2) : n2);
}
function T(n2) {
  this.l[n2.type + true](l.event ? l.event(n2) : n2);
}
function j(n2, u2, i2, t2, o2, r2, f2, e2, c2) {
  var a2, h2, v2, y, _2, k2, b2, g2, m2, x, A2, C2, $2, H2, I2, T2 = u2.type;
  if (void 0 !== u2.constructor)
    return null;
  null != i2.__h && (c2 = i2.__h, e2 = u2.__e = i2.__e, u2.__h = null, r2 = [e2]), (a2 = l.__b) && a2(u2);
  try {
    n:
      if ("function" == typeof T2) {
        if (g2 = u2.props, m2 = (a2 = T2.contextType) && t2[a2.__c], x = a2 ? m2 ? m2.props.value : a2.__ : t2, i2.__c ? b2 = (h2 = u2.__c = i2.__c).__ = h2.__E : ("prototype" in T2 && T2.prototype.render ? u2.__c = h2 = new T2(g2, x) : (u2.__c = h2 = new d(g2, x), h2.constructor = T2, h2.render = O), m2 && m2.sub(h2), h2.props = g2, h2.state || (h2.state = {}), h2.context = x, h2.__n = t2, v2 = h2.__d = true, h2.__h = [], h2._sb = []), null == h2.__s && (h2.__s = h2.state), null != T2.getDerivedStateFromProps && (h2.__s == h2.state && (h2.__s = s({}, h2.__s)), s(h2.__s, T2.getDerivedStateFromProps(g2, h2.__s))), y = h2.props, _2 = h2.state, v2)
          null == T2.getDerivedStateFromProps && null != h2.componentWillMount && h2.componentWillMount(), null != h2.componentDidMount && h2.__h.push(h2.componentDidMount);
        else {
          if (null == T2.getDerivedStateFromProps && g2 !== y && null != h2.componentWillReceiveProps && h2.componentWillReceiveProps(g2, x), !h2.__e && null != h2.shouldComponentUpdate && false === h2.shouldComponentUpdate(g2, h2.__s, x) || u2.__v === i2.__v) {
            for (h2.props = g2, h2.state = h2.__s, u2.__v !== i2.__v && (h2.__d = false), h2.__v = u2, u2.__e = i2.__e, u2.__k = i2.__k, u2.__k.forEach(function(n3) {
              n3 && (n3.__ = u2);
            }), A2 = 0; A2 < h2._sb.length; A2++)
              h2.__h.push(h2._sb[A2]);
            h2._sb = [], h2.__h.length && f2.push(h2);
            break n;
          }
          null != h2.componentWillUpdate && h2.componentWillUpdate(g2, h2.__s, x), null != h2.componentDidUpdate && h2.__h.push(function() {
            h2.componentDidUpdate(y, _2, k2);
          });
        }
        if (h2.context = x, h2.props = g2, h2.__v = u2, h2.__P = n2, C2 = l.__r, $2 = 0, "prototype" in T2 && T2.prototype.render) {
          for (h2.state = h2.__s, h2.__d = false, C2 && C2(u2), a2 = h2.render(h2.props, h2.state, h2.context), H2 = 0; H2 < h2._sb.length; H2++)
            h2.__h.push(h2._sb[H2]);
          h2._sb = [];
        } else
          do {
            h2.__d = false, C2 && C2(u2), a2 = h2.render(h2.props, h2.state, h2.context), h2.state = h2.__s;
          } while (h2.__d && ++$2 < 25);
        h2.state = h2.__s, null != h2.getChildContext && (t2 = s(s({}, t2), h2.getChildContext())), v2 || null == h2.getSnapshotBeforeUpdate || (k2 = h2.getSnapshotBeforeUpdate(y, _2)), I2 = null != a2 && a2.type === p && null == a2.key ? a2.props.children : a2, w(n2, Array.isArray(I2) ? I2 : [I2], u2, i2, t2, o2, r2, f2, e2, c2), h2.base = u2.__e, u2.__h = null, h2.__h.length && f2.push(h2), b2 && (h2.__E = h2.__ = null), h2.__e = false;
      } else
        null == r2 && u2.__v === i2.__v ? (u2.__k = i2.__k, u2.__e = i2.__e) : u2.__e = L(i2.__e, u2, i2, t2, o2, r2, f2, c2);
    (a2 = l.diffed) && a2(u2);
  } catch (n3) {
    u2.__v = null, (c2 || null != r2) && (u2.__e = e2, u2.__h = !!c2, r2[r2.indexOf(e2)] = null), l.__e(n3, u2, i2);
  }
}
function z(n2, u2) {
  l.__c && l.__c(u2, n2), n2.some(function(u3) {
    try {
      n2 = u3.__h, u3.__h = [], n2.some(function(n3) {
        n3.call(u3);
      });
    } catch (n3) {
      l.__e(n3, u3.__v);
    }
  });
}
function L(l2, u2, i2, t2, o2, r2, e2, c2) {
  var s2, h2, v2, y = i2.props, p2 = u2.props, d2 = u2.type, k2 = 0;
  if ("svg" === d2 && (o2 = true), null != r2) {
    for (; k2 < r2.length; k2++)
      if ((s2 = r2[k2]) && "setAttribute" in s2 == !!d2 && (d2 ? s2.localName === d2 : 3 === s2.nodeType)) {
        l2 = s2, r2[k2] = null;
        break;
      }
  }
  if (null == l2) {
    if (null === d2)
      return document.createTextNode(p2);
    l2 = o2 ? document.createElementNS("http://www.w3.org/2000/svg", d2) : document.createElement(d2, p2.is && p2), r2 = null, c2 = false;
  }
  if (null === d2)
    y === p2 || c2 && l2.data === p2 || (l2.data = p2);
  else {
    if (r2 = r2 && n.call(l2.childNodes), h2 = (y = i2.props || f).dangerouslySetInnerHTML, v2 = p2.dangerouslySetInnerHTML, !c2) {
      if (null != r2)
        for (y = {}, k2 = 0; k2 < l2.attributes.length; k2++)
          y[l2.attributes[k2].name] = l2.attributes[k2].value;
      (v2 || h2) && (v2 && (h2 && v2.__html == h2.__html || v2.__html === l2.innerHTML) || (l2.innerHTML = v2 && v2.__html || ""));
    }
    if (C(l2, p2, y, o2, c2), v2)
      u2.__k = [];
    else if (k2 = u2.props.children, w(l2, Array.isArray(k2) ? k2 : [k2], u2, i2, t2, o2 && "foreignObject" !== d2, r2, e2, r2 ? r2[0] : i2.__k && _(i2, 0), c2), null != r2)
      for (k2 = r2.length; k2--; )
        null != r2[k2] && a(r2[k2]);
    c2 || ("value" in p2 && void 0 !== (k2 = p2.value) && (k2 !== l2.value || "progress" === d2 && !k2 || "option" === d2 && k2 !== y.value) && H(l2, "value", k2, y.value, false), "checked" in p2 && void 0 !== (k2 = p2.checked) && k2 !== l2.checked && H(l2, "checked", k2, y.checked, false));
  }
  return l2;
}
function M(n2, u2, i2) {
  try {
    "function" == typeof n2 ? n2(u2) : n2.current = u2;
  } catch (n3) {
    l.__e(n3, i2);
  }
}
function N(n2, u2, i2) {
  var t2, o2;
  if (l.unmount && l.unmount(n2), (t2 = n2.ref) && (t2.current && t2.current !== n2.__e || M(t2, null, u2)), null != (t2 = n2.__c)) {
    if (t2.componentWillUnmount)
      try {
        t2.componentWillUnmount();
      } catch (n3) {
        l.__e(n3, u2);
      }
    t2.base = t2.__P = null, n2.__c = void 0;
  }
  if (t2 = n2.__k)
    for (o2 = 0; o2 < t2.length; o2++)
      t2[o2] && N(t2[o2], u2, i2 || "function" != typeof n2.type);
  i2 || null == n2.__e || a(n2.__e), n2.__ = n2.__e = n2.__d = void 0;
}
function O(n2, l2, u2) {
  return this.constructor(n2, u2);
}
n = e.slice, l = { __e: function(n2, l2, u2, i2) {
  for (var t2, o2, r2; l2 = l2.__; )
    if ((t2 = l2.__c) && !t2.__)
      try {
        if ((o2 = t2.constructor) && null != o2.getDerivedStateFromError && (t2.setState(o2.getDerivedStateFromError(n2)), r2 = t2.__d), null != t2.componentDidCatch && (t2.componentDidCatch(n2, i2 || {}), r2 = t2.__d), r2)
          return t2.__E = t2;
      } catch (l3) {
        n2 = l3;
      }
  throw n2;
} }, u = 0, i = function(n2) {
  return null != n2 && void 0 === n2.constructor;
}, d.prototype.setState = function(n2, l2) {
  var u2;
  u2 = null != this.__s && this.__s !== this.state ? this.__s : this.__s = s({}, this.state), "function" == typeof n2 && (n2 = n2(s({}, u2), this.props)), n2 && s(u2, n2), null != n2 && this.__v && (l2 && this._sb.push(l2), b(this));
}, d.prototype.forceUpdate = function(n2) {
  this.__v && (this.__e = true, n2 && this.__h.push(n2), b(this));
}, d.prototype.render = p, t = [], g.__r = 0, r = 0;

// src/forms/icons.tsx
var ChevronRightIcon = () => /* @__PURE__ */ h("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", viewBox: "0 0 24 24", "stroke-width": "1.5", stroke: "currentColor", class: "w-6 h-6" }, /* @__PURE__ */ h("path", { "stroke-linecap": "round", "stroke-linejoin": "round", d: "M8.25 4.5l7.5 7.5-7.5 7.5" }));
var ArrowRightIcon = () => /* @__PURE__ */ h("svg", { xmlns: "http://www.w3.org/2000/svg", fill: "none", viewBox: "0 0 24 24", "stroke-width": "1.5", stroke: "currentColor", class: "w-6 h-6" }, /* @__PURE__ */ h("path", { "stroke-linecap": "round", "stroke-linejoin": "round", d: "M13.5 4.5L21 12m0 0l-7.5 7.5M21 12H3" }));

// src/forms/902_4e.ts
var v17 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Risk Profile AMLA`,
      description: i18n.str`Evaluation of business relationship with increased risk and definition of criteria for transaction monitoring.`,
      fields: [
        {
          type: "caption",
          props: {
            label: i18n.str`The member performs additional clarifications if the business relationship or the transaction is classified as increased risk (Art. 56 SRO Regulations)`,
            before: h(ArrowRightIcon, { class: "h-6 w-6" })
          }
        },
        {
          type: "text",
          props: {
            name: "customer",
            label: i18n.str`Customer`,
            help: i18n.str`Pursuant identification form (VQF doc. Nr. 902.1) numeral 1`
          }
        }
      ]
    },
    {
      title: i18n.str`Evaluation of politically exposed persons (PEP-Check)`,
      fields: [
        {
          type: "caption",
          props: {
            label: i18n.str`This evaluation has to be completed by all members for every business relationship`,
            before: h(ArrowRightIcon, { class: "h-6 w-6" })
          }
        },
        {
          type: "choiceStacked",
          props: {
            label: i18n.str`Foreign PEP`,
            // tooltip:
            //   i18n.str`Definition see Art. 7 lit. g numeral 1 SRO Regulations`,
            help: i18n.str`Is the customer, the beneficial owner or the controlling person or authorized representative a foreign PEP or closely related to such a person?`,
            name: "pep.foreign",
            choices: [
              {
                label: i18n.str`No`,
                value: "no"
              },
              {
                label: i18n.str`Yes`,
                description: i18n.str`The business relationship is compulsory  classified as increased risk`,
                value: "yes"
              }
            ]
          }
        },
        {
          type: "choiceStacked",
          props: {
            label: i18n.str`Domestic PEP and PEP of International Organizations`,
            // tooltip:
            //   i18n.str`Definition see Art. 7 lit. g numeral 2 and 3 SRO Regulations `,
            help: i18n.str`Is the customer, the beneficial owner or the controlling person or authorized representative a domestic PEP or PEP in International Organizations or closely related to such a person?`,
            name: "pep.domestic",
            choices: [
              {
                label: i18n.str`No`,
                value: "no"
              },
              {
                label: i18n.str`Yes, but NOT risk criterion pursuant to numeral 3 subsequently increased.`,
                value: "yes-but-no-risk"
              },
              {
                label: i18n.str`Yes, AND a risk criterion pursuant to numeral 3 subsequently increased.`,
                description: i18n.str`Classification of the business relationship as increased risk is compulsory`,
                value: "yes"
              }
            ]
          }
        },
        {
          type: "absoluteTime",
          props: {
            label: i18n.str`The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on`,
            name: "pep.when",
            pattern: "dd/MM/yyyy"
            // placeholder: i18n.str`dd/MM/yyyy`,
          }
        }
      ]
    },
    {
      title: 'Evaluation "high risk" or non-cooperative country',
      fields: [
        {
          type: "caption",
          props: {
            label: i18n.str`This evaluation has to be completed by all members for every business relationship`,
            before: h(ArrowRightIcon, { class: "h-6 w-6" })
          }
        },
        {
          type: "choiceStacked",
          props: {
            label: '"High risk" or non-cooperative country',
            help: 'Is the customer, the beneficial owner or the controlling person or authorized representative in a country considered by the FATF "high risk" or non-cooperative and for which FATF requires increased diligence?',
            name: "highRisk.evaluation",
            choices: [
              {
                label: i18n.str`No`,
                value: "no"
              },
              {
                label: i18n.str`Yes`,
                description: i18n.str`considered as business relationship with increased risk`,
                value: "yes"
              }
            ]
          }
        },
        {
          type: "absoluteTime",
          props: {
            label: i18n.str`The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on`,
            name: "highRisk.when",
            pattern: "dd/MM/yyyy"
            // placeholder: i18n.str`dd/MM/yyyy`,
          }
        }
      ]
    },
    {
      title: i18n.str`Evaluation of business relationship risk`,
      fields: [
        {
          type: "caption",
          props: {
            label: i18n.str`This evaluation has to be completed by all members who have in total more than 20 customers for every business relationship. At least two risk categories have to be chosen and assessed`,
            before: h(ArrowRightIcon, { class: "h-6 w-6" })
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`a) Country risk (nationality)`,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Domicile/residential address`,
                  name: "evaluation.nationality.address",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer"
                    },
                    {
                      label: i18n.str`Beneficial owner of the assets`,
                      value: "owner"
                    },
                    {
                      label: i18n.str`Controlling person`,
                      value: "controlling"
                    }
                  ]
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Nationality`,
                  name: "evaluation.nationality.nationality",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer"
                    },
                    {
                      label: i18n.str`Beneficial owner of the assets`,
                      value: "owner"
                    }
                  ]
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.nationality.risk",
                  choices: [
                    {
                      label: i18n.str`Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "low"
                    },
                    {
                      label: i18n.str`Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "medium"
                    },
                    {
                      label: i18n.str`Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "high"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`b) Country risk (business activity)`,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Place of business activity`,
                  name: "evaluation.business.place",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer"
                    },
                    {
                      label: i18n.str`Beneficial owner of the assets`,
                      value: "owner"
                    }
                  ]
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.business.risk",
                  choices: [
                    {
                      label: i18n.str`Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "low"
                    },
                    {
                      label: i18n.str`Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "medium"
                    },
                    {
                      label: i18n.str`Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "high"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`c) Country risk (payments)`,
            fields: [
              {
                type: "caption",
                props: {
                  label: i18n.str`Country of origin and destination of frequent payments (if known)`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.payments.risk",
                  choices: [
                    {
                      label: i18n.str`Risk 0 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "low"
                    },
                    {
                      label: i18n.str`Risk 1 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "medium"
                    },
                    {
                      label: i18n.str`Risk 2 acc. to VQF country list (VQF doc. no. 902.4.1)`,
                      value: "high"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`d) Industry risk`,
            fields: [
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Nature of customer's business activity`,
                  name: "evaluation.industry.nature",
                  choices: [
                    {
                      label: i18n.str`Customer`,
                      value: "customer"
                    },
                    {
                      label: i18n.str`Beneficial owner of the assets`,
                      value: "owner"
                    }
                  ]
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.payments.risk",
                  choices: [
                    {
                      label: i18n.str`Clearly defined, transparent, easily comprehensible business activity well known to the member`,
                      value: "low"
                    },
                    {
                      label: i18n.str`Business activity with a high level of cash transactions`,
                      value: "medium-cash"
                    },
                    {
                      label: i18n.str`Business activity not well known to the member`,
                      value: "medium-unknown"
                    },
                    {
                      label: i18n.str`Trade in munitions/arms, raw gem stones/diamonds, jewelry, international trade in exotic animals, casino and lottery business, trade in erotic wares`,
                      value: "high-restricted"
                    },
                    {
                      label: i18n.str`Member has no personal knowledge of the customer's industry`,
                      value: "high-unknown"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`e) Contact risk`,
            fields: [
              {
                type: "caption",
                props: {
                  label: i18n.str`Types of contact to the customer/ beneficial owner of the assets`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.contact.risk",
                  choices: [
                    {
                      label: i18n.str`Personal acquaintance between member and customer/beneficial owner of the assets over several years (at least 2) prior to entering into the business relationship`,
                      value: "low"
                    },
                    {
                      label: i18n.str`The customer/beneficial owner was not personally known to the member for several years (at least 2) prior to entering into the business relationship; however (a) no business was entered into in the absence of the customer/beneficial owner, or (b) the customer was at least introduced/brokered by a trusted third party`,
                      value: "medium"
                    },
                    {
                      label: i18n.str`The customer/beneficial owner was not personally known to the member and business was entered into in the absence of the former (relationship by correspondence) and the customer was not introduced/brokered by a trusted third party`,
                      value: "high"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`f) Product risk`,
            fields: [
              {
                type: "caption",
                props: {
                  label: i18n.str`Nature of services and products requested by the customer`
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.product.risk",
                  choices: [
                    {
                      label: i18n.str`Easy to understand, transparent services and products whose financial background is easy to comprehend and verify`,
                      value: "low"
                    },
                    {
                      label: i18n.str`More sophisticated services/products whose financial background is not readily easy to comprehend and verify`,
                      value: "medium"
                    },
                    {
                      label: i18n.str`Main focus on offshore business (especially: relationships with domiciliary companies or other such offshore organisations)`,
                      value: "high-offshore"
                    },
                    {
                      label: i18n.str`Complex structures in particular by using a domiciliary company with fiduciary shareholders in a non-transparent jurisdiction, without comprehensible reason or for the purpose of short-term asset placement`,
                      value: "high-structure"
                    },
                    {
                      label: i18n.str`The customer or beneficial owner of the assets has a large number of accounts with pass-through transactions (pass-through accounts)`,
                      value: "high-accounts"
                    },
                    {
                      label: i18n.str`Complex services/products whose financial background can’t be understood or verified with considerable effort`,
                      value: "high-service"
                    },
                    {
                      label: i18n.str`Frequent transactions with increased risks`,
                      value: "high-freq-tx"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`g) Criteria defined by the member`,
            fields: [
              {
                type: "text",
                props: {
                  label: i18n.str`Criteria definition`,
                  name: "evaluation.custom.definition"
                }
              },
              {
                type: "choiceStacked",
                props: {
                  label: i18n.str`Risk level`,
                  name: "evaluation.custom.risk",
                  choices: [
                    {
                      label: i18n.str`Low`,
                      value: "low"
                    },
                    {
                      label: i18n.str`Medium`,
                      value: "medium"
                    },
                    {
                      label: i18n.str`High`,
                      value: "high"
                    }
                  ]
                }
              }
            ]
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`Overall assessment of the business relationship`
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`A business relationship is classified as increased risk if:`,
            fields: [
              {
                type: "caption",
                props: {
                  label: i18n.str`Business relationship with PEP pursuant to numeral 1 (no exception possible)`,
                  before: h(ChevronRightIcon, { class: "h-6 w-6" })
                }
              },
              {
                type: "caption",
                props: {
                  label: 'Relationship with a person from a "high risk" or non-cooperative country according to numeral 2 (no exceptions possible)',
                  before: h(ChevronRightIcon, { class: "h-6 w-6" })
                }
              },
              {
                type: "caption",
                props: {
                  label: i18n.str`Min. one criterion pursuant to numeral 3 was assessed with risk 2 or min. two criteria pursuant to numeral 3 were assessed with risk 1 (exception: justification by the member below why the business relationship overall does not have to be classified as increased risk despite the fact that individual risk criteria are increased)`,
                  before: h(ChevronRightIcon, { class: "h-6 w-6" })
                }
              }
            ]
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Justification for differing risk assessment`,
            name: "evaluation.overall.justification"
          }
        },
        {
          type: "choiceStacked",
          props: {
            label: i18n.str`Risk classified`,
            name: "evaluation.overall.risk",
            choices: [
              {
                label: i18n.str`Business relationship _without_ increased risk`,
                value: "without"
              },
              {
                label: i18n.str`Business relationship __with__ increased risk`,
                value: "with"
              }
            ]
          }
        },
        {
          type: "absoluteTime",
          props: {
            label: i18n.str`The decision of the Senior executive body on the acceptance of a business relationship with a PEP was obtained on`,
            name: "evaluation.when",
            pattern: "dd/MM/yyyy"
            // placeholder: i18n.str`dd/MM/yyyy`,
          }
        }
      ]
    },
    {
      title: i18n.str`Criteria for identification of increased risk transactions (transaction monitoring)`,
      fields: [
        {
          type: "group",
          props: {
            before: i18n.str`Criteria`,
            fields: [
              {
                type: "caption",
                props: {
                  label: i18n.str`Classification as as increased risk is compulsory if`
                }
              },
              {
                type: "caption",
                props: {
                  before: h(ChevronRightIcon, { class: "w-6 h-6" }),
                  label: i18n.str`Transactions for which assets with an equivalent value of CHF 100'000.- or more are physically introduced at the beginning of the business relationship, either at once or in a staggered manner`
                }
              },
              {
                type: "caption",
                props: {
                  before: h(ChevronRightIcon, { class: "w-6 h-6" }),
                  label: 'Money and asset transfers ("money transfer") whereby a single transaction or multiple transactions which appear to be related reach or exceed the amount of CHF 5,000.-'
                }
              },
              {
                type: "caption",
                props: {
                  before: h(ChevronRightIcon, { class: "w-6 h-6" }),
                  label: 'Payments from or to a country that is considered to be "high risk" or non-cooperative by the FATF and for which increased diligence is required'
                }
              }
            ]
          }
        },
        {
          type: "group",
          props: {
            before: i18n.str`Additional criteria defined by the member`,
            fields: [
              {
                type: "caption",
                props: {
                  before: h(ArrowRightIcon, { class: "w-6 h-6" }),
                  label: i18n.str`All members have to define min. 1 additional criterion for every business relationship to identify unusual transactions`
                }
              },
              {
                type: "textArea",
                props: {
                  label: i18n.str`Description`,
                  name: "criteria.additional"
                }
              },
              {
                type: "group",
                props: {
                  before: i18n.str`Possible criteria (Art. 59 para. 2 SRO Regulations)`,
                  fields: [
                    {
                      type: "caption",
                      props: {
                        before: h(ChevronRightIcon, { class: "w-4 h-4" }),
                        label: i18n.str`the amount of inflowing and outflowing assets`
                      }
                    },
                    {
                      type: "caption",
                      props: {
                        before: h(ChevronRightIcon, { class: "w-4 h-4" }),
                        label: i18n.str`type, volume and frequency of transactions usual to the business relationship (considerable variance would be unusual)`
                      }
                    },
                    {
                      type: "caption",
                      props: {
                        before: h(ChevronRightIcon, { class: "w-4 h-4" }),
                        label: i18n.str`type, volume and frequency of transactions usual to comparable business relationships (considerable variance would be unusual)`
                      }
                    },
                    {
                      type: "caption",
                      props: {
                        before: h(ChevronRightIcon, { class: "w-4 h-4" }),
                        label: i18n.str`description of expected transaction patterns which the client notify the member of (considerable variance would be unusual)`
                      }
                    },
                    {
                      type: "caption",
                      props: {
                        before: h(ChevronRightIcon, { class: "w-4 h-4" }),
                        label: 'The country of origin or destination of payments, especially in the case of payments from or to a country considered by the FATF as "high risk" or non-cooperative'
                      }
                    }
                  ]
                }
              }
            ]
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    return {};
  }
});

// src/forms/902_5e.ts
var v18 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Customer Profile`,
      description: i18n.str`The information below has to refer to the persons from whom the assets originate ultimately (e.g. beneficial owner of the assets, founder/creator of a trust or foundation). Is the customer an operational legal entity or partnership the information may refer to the entity itself (not to the controlling person), unless the entity holds the assets in trust for a third party.`,
      fields: [
        {
          type: "text",
          props: {
            name: "customer",
            label: i18n.str`Customer`,
            help: i18n.str`Pursuant Identification Form (VQF doc. No. 902.1) numeral 1`
          }
        }
      ]
    },
    {
      title: i18n.str`Business activity`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Profession, business activities`,
            name: "businessActivity",
            help: i18n.str`former, current, potentially planned`
          }
        }
      ]
    },
    {
      title: i18n.str`Financial circumstances`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Income and assets, liabilities`,
            name: "financial",
            help: i18n.str`estimated`
          }
        }
      ]
    },
    {
      title: i18n.str`Origin of the deposited assets involved`,
      fields: [
        {
          type: "text",
          props: {
            label: i18n.str`Nature`,
            name: "originOfAssets.nature",
            help: i18n.str`nature of the involved assets`
          }
        },
        {
          type: "selectOne",
          props: {
            name: "originOfAssets.currency",
            label: i18n.str`Currency`,
            choices: uiForms.currencies(i18n)
          }
        },
        {
          type: "integer",
          props: {
            label: i18n.str`Amount`,
            name: "originOfAssets.amount"
          }
        },
        {
          type: "choiceStacked",
          props: {
            label: i18n.str`Category`,
            name: "originOfAssets.category",
            choices: [
              {
                label: i18n.str`Savings`,
                value: "savings"
              },
              {
                label: i18n.str`Own business operations`,
                value: "own-business"
              },
              {
                label: i18n.str`Inheritance`,
                value: "inheritance"
              },
              {
                label: i18n.str`Other, what?`,
                value: "other"
              }
            ]
          }
        },
        {
          type: "text",
          props: {
            label: i18n.str`Other category`,
            name: "originOfAssets.categoryOther",
            required: true
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Detailed description of the origins/economical background of the assets involved in the business relationship`,
            name: "originOfAssets.details"
          }
        }
      ]
    },
    {
      title: i18n.str`Nature and purpose of the business relationship`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Purpose of the business relationship`,
            name: "nature.purpose",
            help: i18n.str`nature of the involved assets`
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Information on the planned development of the business relationship and the assets`,
            name: "nature.plan"
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Especially in the case of cash or money and asset transfer transactions with regular customers: Details on usual business volume, Information on the beneficiaries, (Full name, address, bank account)`,
            name: "nature.cashOrMoneyTransfer"
          }
        }
      ]
    },
    {
      title: i18n.str`Relationship with third parties`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Relation of the customer to the beneficial owner involved in the business relationship`,
            name: "relations.beneficialOwners"
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Relation of the customer to the controlling persons involved in the business relationship`,
            name: "relations.controllingPersons"
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Relation of the customer to the authorized signatories involved in the business relationship`,
            name: "relations.authorizedSignatories"
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Relation of the customer to other persons involved in the business relationship`,
            name: "relations.otherPersons"
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Relation to other AMLA-Files`,
            name: "relations.withOtherAmlaFiles"
          }
        },
        {
          type: "textArea",
          props: {
            label: i18n.str`Introducer / agents / references`,
            name: "relations.references"
          }
        }
      ]
    },
    {
      title: i18n.str`Further information`,
      fields: [
        {
          type: "textArea",
          props: {
            label: i18n.str`Other relevant information`,
            name: "furtherInformation"
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    var _a;
    return {
      originOfAssets: {
        categoryOther: {
          hidden: ((_a = v2.originOfAssets) == null ? void 0 : _a.category) !== "other"
        }
      }
    };
  }
});

// src/forms/902_9e.ts
var v19 = (i18n) => (current) => ({
  design: [
    {
      title: i18n.str`Declaration of identity of the beneficial owner`,
      fields: [
        {
          type: "textArea",
          props: {
            name: "contractingPartner",
            label: i18n.str`Contracting partner`
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`The contracting partner hereby declares that the person(s) listed below is/are the beneficial owner(s) of the assets involved in the business relationship. If the contracting partner is also the sole beneficial owner of the assets, the contracting partner's detail must be set out below`
          }
        },
        {
          type: "array",
          props: {
            label: i18n.str`Persons`,
            labelField: "surname",
            name: "persons",
            fields: [
              {
                type: "text",
                props: {
                  name: "surname",
                  label: i18n.str`Surname(s)`
                }
              },
              {
                type: "text",
                props: {
                  name: "firstName",
                  label: i18n.str`First name(s)`
                }
              },
              {
                type: "absoluteTime",
                props: {
                  name: "dateOfBirth",
                  label: i18n.str`Date of birth`,
                  pattern: "dd/MM/yyyy"
                  // help: i18n.str`format 'dd/MM/yyyy'`,
                }
              },
              {
                type: "text",
                props: {
                  name: "nationality",
                  label: i18n.str`Nationality`
                }
              },
              {
                type: "text",
                props: {
                  name: "address",
                  label: i18n.str`Actual address of domicile`
                }
              }
            ]
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`The contracting partner hereby undertakes to inform automatically of any changes to the information contained herein`
          }
        },
        {
          type: "text",
          props: {
            name: "signature",
            label: i18n.str`Signature`
          }
        },
        {
          type: "caption",
          props: {
            label: i18n.str`It is a criminal offense to deliberately provide false information on this form (article 251 of the Swiss Criminal Code, document forgery)`
          }
        }
      ]
    },
    resolutionSection(current, i18n)
  ],
  behavior: function formBehavior(v2) {
    return {};
  }
});

// src/forms/index.ts
var languages = (i18n) => [
  {
    label: i18n.str`Mandarin Chinese`,
    value: "cmn"
  },
  {
    label: i18n.str`Spanish`,
    value: "spa"
  },
  {
    label: i18n.str`English`,
    value: "eng"
  },
  {
    label: i18n.str`Hindi`,
    value: "hin"
  },
  {
    label: i18n.str`Portuguese`,
    value: "por"
  },
  {
    label: i18n.str`Bengali`,
    value: "ben"
  },
  {
    label: i18n.str`Russian`,
    value: "rus"
  },
  {
    label: i18n.str`Japanese`,
    value: "jpn"
  },
  {
    label: i18n.str`Yue`,
    value: "yue"
  },
  {
    label: i18n.str`Vietnamese`,
    value: "vie"
  },
  {
    label: i18n.str`Turkish`,
    value: "tur"
  },
  {
    label: i18n.str`Wu`,
    value: "wuu"
  },
  {
    label: i18n.str`Marathi`,
    value: "mar"
  },
  {
    label: i18n.str`Telugu`,
    value: "ten"
  },
  {
    label: i18n.str`Korean`,
    value: "kor"
  },
  {
    label: i18n.str`French`,
    value: "fra"
  },
  {
    label: i18n.str`Tamil`,
    value: "tam"
  },
  {
    label: i18n.str`Egyptian Arabic`,
    value: "arz"
  },
  {
    label: i18n.str`Standard German`,
    value: "deu"
  },
  {
    label: i18n.str`Urdu`,
    value: "urd"
  },
  {
    label: i18n.str`Javanese`,
    value: "jav"
  },
  {
    label: i18n.str`Punjabi`,
    value: "pan"
  },
  {
    label: i18n.str`Italian`,
    value: "ita"
  },
  {
    label: i18n.str`Gujarati`,
    value: "guj"
  },
  {
    label: i18n.str`Iranian Persian`,
    value: "pes"
  },
  {
    label: i18n.str`Bhojpuri`,
    value: "bho"
  },
  {
    label: i18n.str`Hausa`,
    value: "hau"
  }
];
var forms = (i18n) => [
  {
    label: i18n.str`Simple comment`,
    id: "simple_comment",
    version: 1,
    impl: v1(i18n)
  },
  {
    label: i18n.str`Identification form`,
    id: "902.1e",
    version: 1,
    impl: v16(i18n)
  },
  {
    label: i18n.str`Operational legal entity or partnership`,
    id: "902.11e",
    version: 1,
    impl: v12(i18n)
  },
  {
    label: i18n.str`Foundations`,
    id: "902.12e",
    version: 1,
    impl: v13(i18n)
  },
  {
    label: i18n.str`Declaration for trusts`,
    id: "902.13e",
    version: 1,
    impl: v14(i18n)
  },
  {
    label: i18n.str`Information on life insurance policies`,
    id: "902.15e",
    version: 1,
    impl: v15(i18n)
  },
  {
    label: i18n.str`Declaration of beneficial owner`,
    id: "902.9e",
    version: 1,
    impl: v19(i18n)
  },
  {
    label: i18n.str`Customer profile`,
    id: "902.5e",
    version: 1,
    impl: v18(i18n)
  },
  {
    label: i18n.str`Risk profile`,
    id: "902.4e",
    version: 1,
    impl: v17(i18n)
  }
];
var currencies = (i18n) => [
  {
    label: i18n.str`United States dollar`,
    value: "usd"
  },
  {
    label: i18n.str`Euro`,
    value: "eur"
  },
  {
    label: i18n.str`Swiss franc`,
    value: "chf"
  },
  {
    label: i18n.str`Argentine peso`,
    value: "ars"
  },
  {
    label: i18n.str`Mexican peso`,
    value: "mxn"
  },
  {
    label: i18n.str`Brazilian real`,
    value: "brl"
  }
];
globalThis.amlExchangeBackoffice = { currencies, languages, forms };
//# sourceMappingURL=forms.js.map
