/*
     This file is part of GNU Taler
     Copyright (C) 2012-2021 Taler Systems SA

     GNU Taler is free software: you can redistribute it and/or modify it
     under the terms of the GNU Lesser General Public License as published
     by the Free Software Foundation, either version 3 of the License,
     or (at your option) any later version.

     GNU Taler is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public License
     along with this program.  If not, see <http://www.gnu.org/licenses/>.

     SPDX-License-Identifier: LGPL3.0-or-later

     Note: the LGPL does not apply to all components of GNU Taler,
     but it does apply to this file.
 */
 /**
  * @file src/include/taler_dbevents.h
  * @brief GNU Taler database event types, generated via https://gana.gnunet.org/
  *
  * Do NOT edit this file, it is generated!
  */
#ifndef GNU_TALER_DBEVENTS_H
#define GNU_TALER_DBEVENTS_H

#ifdef __cplusplus
extern "C" {
#if 0 /* keep Emacsens' auto-indent happy */
}
#endif
#endif

#include <limits.h>


/**
 * Taler database event types.
 */
enum TALER_DbEventType
{


  /**
   * Event triggered when a reserve is funded via a bank transfer.
   */
  TALER_DBEVENT_EXCHANGE_RESERVE_INCOMING = 1000,


  /**
   * Event triggered when new online signing keys are activated via the management API.
   */
  TALER_DBEVENT_EXCHANGE_KEYS_UPDATED = 1001,


  /**
   * Event triggered when the wire response was changed via the management API.
   */
  TALER_DBEVENT_EXCHANGE_WIRE_UPDATED = 1002,


  /**
   * Event triggered when a user completed a KYC process.
   */
  TALER_DBEVENT_EXCHANGE_KYC_COMPLETED = 1003,


  /**
   * Event triggered when the configuration of an extension is updated.
   */
  TALER_DBEVENT_EXCHANGE_EXTENSIONS_UPDATED = 1004,


  /**
   * Event triggered when a purse was merged into a reserve.
   */
  TALER_DBEVENT_EXCHANGE_PURSE_MERGED = 1005,


  /**
   * Event triggered when coins are deposited into a purse.
   */
  TALER_DBEVENT_EXCHANGE_PURSE_DEPOSITED = 1006,


  /**
   * Some instance setting was changed (new instance, deleted instance, change options)
   */
  TALER_DBEVENT_MERCHANT_INSTANCE_SETTINGS = 1100,


  /**
   * Event triggered when an order is paid by a customer.
   */
  TALER_DBEVENT_MERCHANT_ORDER_PAID = 1101,


  /**
   * Event triggered when a refund is approved by the backoffice staff.
   */
  TALER_DBEVENT_MERCHANT_ORDER_REFUND = 1102,


  /**
   * Event triggered when a fulfillment URL becomes paid for a particular session.
   */
  TALER_DBEVENT_MERCHANT_SESSION_CAPTURED = 1103,


  /**
   * Event triggered when a refund is obtained by a wallet.
   */
  TALER_DBEVENT_MERCHANT_REFUND_OBTAINED = 1104,


  /**
   * Event triggered when the set of orders or their state changes.
   */
  TALER_DBEVENT_MERCHANT_ORDERS_CHANGE = 1105,


  /**
   * Event triggered when a new pending webhook is ready to be run.
   */
  TALER_DBEVENT_MERCHANT_WEBHOOK_PENDING = 1106,


  /**
   * A wire transfer from the target account with the correct wire transfer subject was received.
   */
  TALER_DBEVENT_ANASTASIS_AUTH_IBAN_TRANSFER = 2000,


};


#if 0 /* keep Emacsens' auto-indent happy */
{
#endif
#ifdef __cplusplus
}
#endif

#endif
