--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--


CREATE TABLE aml_staff
  (aml_staff_uuid BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,decider_pub BYTEA PRIMARY KEY CHECK (LENGTH(decider_pub)=32)
  ,master_sig BYTEA CHECK (LENGTH(master_sig)=64)
  ,decider_name VARCHAR NOT NULL
  ,is_active BOOLEAN NOT NULL
  ,read_only BOOLEAN NOT NULL
  ,last_change INT8 NOT NULL
  );
COMMENT ON TABLE aml_staff
  IS 'Table with AML staff members the exchange uses or has used in the past. Entries never expire as we need to remember the last_change column indefinitely.';
COMMENT ON COLUMN aml_staff.decider_pub
  IS 'Public key of the AML staff member.';
COMMENT ON COLUMN aml_staff.master_sig
  IS 'The master public key signature on the AML staff member status, of type TALER_SIGNATURE_MASTER_AML_KEY.';
COMMENT ON COLUMN aml_staff.decider_name
  IS 'Name of the staff member.';
COMMENT ON COLUMN aml_staff.is_active
  IS 'true if we are currently supporting the use of this AML staff member.';
COMMENT ON COLUMN aml_staff.is_active
  IS 'true if the member has read-only access.';
COMMENT ON COLUMN aml_staff.last_change
  IS 'Latest time when active status changed. Used to detect replays of old messages.';
