--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE FUNCTION create_table_aggregation_tracking(
  IN partition_suffix VARCHAR DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'aggregation_tracking';
BEGIN
  PERFORM create_partitioned_table(
    'CREATE TABLE %I'
      '(aggregation_serial_id BIGINT GENERATED BY DEFAULT AS IDENTITY'
      ',deposit_serial_id INT8 PRIMARY KEY'
      ',wtid_raw BYTEA NOT NULL'
    ') %s ;'
    ,table_name
    ,'PARTITION BY HASH (deposit_serial_id)'
    ,partition_suffix
  );
  PERFORM comment_partitioned_table(
     'mapping from wire transfer identifiers (WTID) to deposits (and back)'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'identifier of the wire transfer'
    ,'wtid_raw'
    ,table_name
    ,partition_suffix
  );
END
$$;


CREATE FUNCTION constrain_table_aggregation_tracking(
  IN partition_suffix VARCHAR
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'aggregation_tracking';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'CREATE INDEX ' || table_name || '_by_wtid_raw_index '
    'ON ' || table_name || ' '
    '(wtid_raw);'
  );
  EXECUTE FORMAT (
    'COMMENT ON INDEX ' || table_name || '_by_wtid_raw_index '
    'IS ' || quote_literal('for lookup_transactions') || ';'
  );
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_aggregation_serial_id_key'
    ' UNIQUE (aggregation_serial_id) '
  );
END
$$;


CREATE FUNCTION foreign_table_aggregation_tracking()
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'aggregation_tracking';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_foreign_deposit'
    ' FOREIGN KEY (deposit_serial_id) '
    ' REFERENCES deposits (deposit_serial_id) ON DELETE CASCADE' -- FIXME change to coin_pub + deposit_serial_id for more efficient deposit???
  );
END
$$;


INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('aggregation_tracking'
    ,'exchange-0002'
    ,'create'
    ,TRUE
    ,FALSE),
    ('aggregation_tracking'
    ,'exchange-0002'
    ,'constrain'
    ,TRUE
    ,FALSE),
    ('aggregation_tracking'
    ,'exchange-0002'
    ,'foreign'
    ,TRUE
    ,FALSE);
