/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file pg_insert_reserve_summary.c
 * @brief Low-level (statement-level) Postgres database access for the exchange
 * @author Christian Grothoff
 */
#include "platform.h"
#include "taler_error_codes.h"
#include "taler_dbevents.h"
#include "taler_pq_lib.h"
#include "pg_insert_reserve_summary.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TAH_PG_insert_reserve_summary (
  void *cls,
  const struct TALER_MasterPublicKeyP *master_pub,
  const struct TALER_AUDITORDB_ReserveFeeBalance *rfb)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_auto_from_type (master_pub),
    TALER_PQ_query_param_amount (&rfb->reserve_balance),
    TALER_PQ_query_param_amount (&rfb->reserve_loss),
    TALER_PQ_query_param_amount (&rfb->withdraw_fee_balance),
    TALER_PQ_query_param_amount (&rfb->close_fee_balance),
    TALER_PQ_query_param_amount (&rfb->purse_fee_balance),
    TALER_PQ_query_param_amount (&rfb->open_fee_balance),
    TALER_PQ_query_param_amount (&rfb->history_fee_balance),
    GNUNET_PQ_query_param_end
  };

  PREPARE (pg,
           "auditor_reserve_balance_insert",
           "INSERT INTO auditor_reserve_balance"
           "(master_pub"
           ",reserve_balance_val"
           ",reserve_balance_frac"
           ",reserve_loss_val"
           ",reserve_loss_frac"
           ",withdraw_fee_balance_val"
           ",withdraw_fee_balance_frac"
           ",close_fee_balance_val"
           ",close_fee_balance_frac"
           ",purse_fee_balance_val"
           ",purse_fee_balance_frac"
           ",open_fee_balance_val"
           ",open_fee_balance_frac"
           ",history_fee_balance_val"
           ",history_fee_balance_frac"
           ") VALUES "
           "($1,$2,$3,$4,$5,$6,$7,$8,$9,$10,$11,$12,$13,$14,$15)");
  GNUNET_assert (GNUNET_YES ==
                 TALER_amount_cmp_currency (&rfb->reserve_balance,
                                            &rfb->withdraw_fee_balance));

  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "auditor_reserve_balance_insert",
                                             params);
}
