/*
   This file is part of TALER
   Copyright (C) 2022 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file exchangedb/pg_select_aml_process.h
 * @brief implementation of the select_aml_process function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_SELECT_AML_PROCESS_H
#define PG_SELECT_AML_PROCESS_H

#include "taler_util.h"
#include "taler_json_lib.h"
#include "taler_exchangedb_plugin.h"


/**
 * Lookup AML decisions that have a particular state.
 *
 * @param cls closure
 * @param decision which decision states to filter by
 * @param row_off offset to start from
 * @param forward true to go forward in time, false to go backwards
 * @param cb callback to invoke on each match
 * @param cb_cls closure for @a cb
 * @return database transaction status
 */
enum GNUNET_DB_QueryStatus
TEH_PG_select_aml_process (
  void *cls,
  enum TALER_AmlDecisionState decision,
  uint64_t row_off,
  bool forward,
  TALER_EXCHANGEDB_AmlStatusCallback cb,
  void *cb_cls);


#endif
