--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE OR REPLACE FUNCTION create_table_purse_deletion(
  IN partition_suffix VARCHAR DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'purse_deletion';
BEGIN
  PERFORM create_partitioned_table(
    'CREATE TABLE IF NOT EXISTS %I'
      '(purse_deletion_serial_id BIGINT GENERATED BY DEFAULT AS IDENTITY'
      ',purse_sig BYTEA CHECK (LENGTH(purse_sig)=64)'
      ',purse_pub BYTEA NOT NULL CHECK (LENGTH(purse_pub)=32)'
    ') %s ;'
    ,table_name
    ,'PARTITION BY HASH (purse_pub)'
    ,partition_suffix
  );
  PERFORM comment_partitioned_table(
     'signatures affirming explicit purse deletions'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'signature of type WALLET_PURSE_DELETE'
    ,'purse_sig'
    ,table_name
    ,partition_suffix
  );
END $$;

COMMENT ON FUNCTION create_table_purse_deletion
  IS 'Creates the purse_deletion table';


CREATE OR REPLACE FUNCTION constrain_table_purse_deletion(
  IN partition_suffix VARCHAR DEFAULT NULL
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'purse_deletion';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
      ' ADD CONSTRAINT ' || table_name || '_delete_serial_key '
        'UNIQUE (purse_deletion_serial_id)'
  );
END $$;


CREATE OR REPLACE FUNCTION master_table_purse_requests_was_deleted (
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'purse_requests';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE exchange.' || table_name ||
    ' ADD COLUMN'
    ' was_deleted BOOLEAN NOT NULL DEFAULT(FALSE)'
  );
  COMMENT ON COLUMN purse_requests.was_deleted
    IS 'TRUE if the purse was explicitly deleted (purse must have an entry in the purse_deletion table)';
END $$;


INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('purse_deletion'
    ,'exchange-0003'
    ,'create'
    ,TRUE
    ,FALSE),
    ('purse_deletion'
    ,'exchange-0003'
    ,'constrain'
    ,TRUE
    ,FALSE),
    ('purse_requests_was_deleted'
    ,'exchange-0003'
    ,'master'
    ,TRUE
    ,FALSE);
