--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE OR REPLACE FUNCTION create_table_aml_status(
  IN partition_suffix VARCHAR DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'aml_status';
BEGIN
  PERFORM create_partitioned_table(
    'CREATE TABLE IF NOT EXISTS %I'
      '(aml_status_serial_id BIGINT GENERATED BY DEFAULT AS IDENTITY'
      ',h_payto BYTEA PRIMARY KEY CHECK (LENGTH(h_payto)=32)'
      ',threshold_val INT8 NOT NULL DEFAULT(0)'
      ',threshold_frac INT4 NOT NULL DEFAULT(0)'
      ',status INT4 NOT NULL DEFAULT(0)'
    ') %s ;'
    ,table_name
    ,'PARTITION BY HASH (h_payto)'
    ,partition_suffix
  );
  PERFORM comment_partitioned_table(
     'AML status for a particular payment destination'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'hash of the payto://-URI this AML status is about'
    ,'h_payto'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'monthly inbound transaction limit below which we are OK (if status is 1)'
    ,'threshold_val'
    ,table_name
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     '0 for all OK, 1 for AML decision required, 2 for account is frozen (prevents further transactions)'
    ,'status'
    ,table_name
    ,partition_suffix
  );
END $$;

COMMENT ON FUNCTION create_table_aml_status
  IS 'Creates the aml_status table';


CREATE OR REPLACE FUNCTION constrain_table_aml_status(
  IN partition_suffix VARCHAR
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'aml_status';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
      ' ADD CONSTRAINT ' || table_name || '_serial_key '
        'UNIQUE (aml_status_serial_id)'
  );
END $$;


INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('aml_status'
    ,'exchange-0003'
    ,'create'
    ,TRUE
    ,FALSE),
    ('aml_status'
    ,'exchange-0003'
    ,'constrain'
    ,TRUE
    ,FALSE);
