--
-- This file is part of TALER
-- Copyright (C) 2014--2022 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE FUNCTION create_table_wire_targets(
  IN partition_suffix VARCHAR DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
BEGIN
  PERFORM create_partitioned_table(
    'CREATE TABLE %I'
      '(wire_target_serial_id BIGINT GENERATED BY DEFAULT AS IDENTITY'
      ',wire_target_h_payto BYTEA PRIMARY KEY CHECK (LENGTH(wire_target_h_payto)=32)'
      ',payto_uri VARCHAR NOT NULL'
    ') %s ;'
    ,'wire_targets'
    ,'PARTITION BY HASH (wire_target_h_payto)'
    ,partition_suffix
  );
  PERFORM comment_partitioned_table(
     'All senders and recipients of money via the exchange'
    ,'wire_targets'
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'Can be a regular bank account, or also be a URI identifying a reserve-account (for P2P payments)'
    ,'payto_uri'
    ,'wire_targets'
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'Unsalted hash of payto_uri'
    ,'wire_target_h_payto'
    ,'wire_targets'
    ,partition_suffix
  );
END $$;


CREATE FUNCTION constrain_table_wire_targets(
  IN partition_suffix VARCHAR
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name VARCHAR DEFAULT 'wire_targets';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_wire_target_serial_id_key'
    ' UNIQUE (wire_target_serial_id)'
  );
END
$$;


INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('wire_targets'
    ,'exchange-0002'
    ,'create'
    ,TRUE
    ,FALSE),
    ('wire_targets'
    ,'exchange-0002'
    ,'constrain'
    ,TRUE
    ,FALSE);
