# This file is in the public domain.

from setuptools import setup, find_packages

setup(name='talerbank',
      version='0.6.0pre1',
      description='Taler friendly bank',
      url='git://taler.net/bank',
      author='Marcello Stanisci, Florian Dold',
      author_email='stanisci.m@gmail.com, flo@dold.me',
      license='GPL',
      packages=find_packages(),
      install_requires=["django>=3",
                        "psycopg2",
                        "requests",
                        "uWSGI",
                        "mock",
                        "jinja2",
                        "qrcode",
                        "lxml",
                        "taler-util>=0.6.4"],
      scripts=["./bin/taler-bank-manage"],
      package_data={
        'talerbank.app': [
            'templates/*.html',
            'templates/registration/*.html',
            'static/web-common/*.css',
            'static/web-common/*.html',
            'static/web-common/*.png',
            'static/*.css',
            ]
      },
      zip_safe=False)
