# Generated by Django 2.0.1 on 2018-02-13 10:23

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import talerbank.app.models


class Migration(migrations.Migration):

    replaces = [('app', '0001_initial'), ('app', '0002_bankaccount_amount'), ('app', '0003_auto_20171030_1346'), ('app', '0004_auto_20171030_1428'), ('app', '0005_remove_banktransaction_currency'), ('app', '0006_auto_20171031_0823'), ('app', '0007_auto_20171031_0906'), ('app', '0008_auto_20171031_0938'), ('app', '0009_auto_20171120_1642'), ('app', '0010_banktransaction_cancelled'), ('app', '0011_banktransaction_reimburses'), ('app', '0012_auto_20171212_1540'), ('app', '0013_remove_banktransaction_reimburses')]

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BankAccount',
            fields=[
                ('is_public', models.BooleanField(default=False)),
                ('debit', models.BooleanField(default=False)),
                ('balance_value', models.IntegerField(default=0)),
                ('balance_fraction', models.IntegerField(default=0)),
                ('balance', models.FloatField(default=0)),
                ('currency', models.CharField(default='', max_length=12)),
                ('account_no', models.AutoField(primary_key=True, serialize=False)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BankTransaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(default='(no subject given)', max_length=200)),
                ('date', models.DateTimeField(auto_now=True, db_index=True)),
                ('credit_account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='credit_account', to='app.BankAccount')),
                ('debit_account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='debit_account', to='app.BankAccount')),
                ('amount', talerbank.app.models.AmountField(default=False)),
                ('cancelled', models.BooleanField(default=False)),
            ],
        ),
        migrations.AddField(
            model_name='bankaccount',
            name='amount',
            field=talerbank.app.models.AmountField(default=talerbank.app.models.get_zero_amount),
        ),
        migrations.RemoveField(
            model_name='bankaccount',
            name='balance',
        ),
        migrations.RemoveField(
            model_name='bankaccount',
            name='balance_fraction',
        ),
        migrations.RemoveField(
            model_name='bankaccount',
            name='balance_value',
        ),
        migrations.RemoveField(
            model_name='bankaccount',
            name='currency',
        ),
    ]
