#  This file is part of TALER
#  (C) 2014, 2015, 2016 INRIA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
#
#  @author Marcello Stanisci

from django.test import TestCase, Client
from django.core.urlresolvers import reverse
from django.conf import settings
from django.contrib.auth.models import User
from .models import BankAccount, BankTransaction
from . import urls
from . import amounts
from .views import wire_transfer
import json

import logging

logger = logging.getLogger(__name__)

class BadDatabaseStringTestCase(TestCase):
    def test_baddbstring(self):
        pass

class BadMaxDebtOptionTestCase(TestCase):
    def test_badmaxdebtoption(self):
        try:
            amounts.parse_amount(settings.TALER_MAX_DEBT)
        except amounts.BadFormatAmount:
            self.assertTrue(True)
            return
        try:
            amounts.parse_amount(settings.TALER_MAX_DEBT_BANK)
        except amounts.BadFormatAmount:
            self.assertTrue(True)
            return
        # Force to have at least one bad amount in config
        self.assertTrue(False)

class NoCurrencyOptionTestCase(TestCase):
    pass
