#  This file is part of TALER
#  (C) 2014, 2015, 2106 INRIA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
#
#  @author Marcello Stanisci

from random import randint
from django.core.management.base import BaseCommand
from ...funds import wire_transfer_in_out
from django.conf import settings
from django.db.utils import OperationalError, ProgrammingError
from ...models import BankAccount
import logging
import sys

logger = logging.getLogger(__name__)

public_accounts = []
def sample_donations():
    counter = -1
    try:
        public_accounts = BankAccount.objects.filter(is_public=True)
        if len(public_accounts) is 0:
            logger.warning("No public accounts still activated. Run 'taler-bank-manage"
                           " django provide_accounts' first")            
        for account in public_accounts:
            logger.debug("*")
            for i in range(0, 9):
                counter += 1
                if account.user.username in settings.TALER_EXPECTS_DONATIONS:
                    value = randint(1, 100)
                    try:
                        # 1st take money from bank and give to exchange
                        wire_transfer_in_out({'value': value,
                                              'fraction': 0,
                                              'currency': settings.TALER_CURRENCY},
                                             1,
                                             2,
                                             "Test-withdrawal-%d" % counter)
    
                        # 2nd take money from exchange and give to donation receiver
                        wire_transfer_in_out({'value': value,
                                              'fraction': 0,
                                              'currency': settings.TALER_CURRENCY},
                                             2,
                                             account.account_no,
                                             "Test-donation-%d" % counter)
                    except BankAccount.DoesNotExist:
                        logger.error("(At least) one account is not found. Run "
                                     "'taler-bank-manage django provide_accounts' beforehand")
                        sys.exit(1)
    except (ProgrammingError, OperationalError):
        logger.error("likely causes: non existent DB or unmigrated project\n"
                     "(try 'taler-bank-manage django migrate' in the latter case)",
                     stack_info=False,
                     exc_info=True)
        sys.exit(1)

class Command(BaseCommand):
    def handle(self, *args, **options):
        sample_donations()
