#  This file is part of TALER
#  (C) 2017 INRIA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
#
#  @author Florian Dold

from django.contrib.staticfiles.storage import staticfiles_storage
from django.core.urlresolvers import reverse
from django.conf import settings
from django.core.urlresolvers import get_script_prefix
from urllib.parse import urlparse
from jinja2 import Environment
import os


def is_absolute(url):
    return bool(urlparse(url).netloc)


def join_urlparts(*parts):
    s = ""
    i = 0
    while i < len(parts):
        n = parts[i]
        i += 1
        if s.endswith("/"):
            n = n.lstrip("/")
        elif s and  not n.startswith("/"):
            n = "/" + n
        s += n
    return s


def static(url):
    if is_absolute(url):
        return url
    return join_urlparts(get_script_prefix(), settings.STATIC_URL, url)


def settings_value(name):
    return getattr(settings, name, "")


def url(*args, **kwargs):
    # strangely, Django's 'reverse' function
    # takes a named parameter 'kwargs' instead
    # of real kwargs.
    return reverse(*args, kwargs=kwargs)


def env_get(name, default=None):
    return os.environ.get(name, default)


def environment(**options):
    env = Environment(**options)
    env.globals.update({
        'static': static,
        'url': url,
        'settings_value': settings_value,
        'env': env_get,
    })
    return env

