# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-03-22 20:22
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='BankAccount',
            fields=[
                ('is_public', models.BooleanField(default=False)),
                ('debit', models.BooleanField(default=False)),
                ('balance_value', models.IntegerField(default=0)),
                ('balance_fraction', models.IntegerField(default=0)),
                ('balance', models.FloatField(default=0)),
                ('currency', models.CharField(default='', max_length=12)),
                ('account_no', models.AutoField(primary_key=True, serialize=False)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BankTransaction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount_value', models.IntegerField(default=0)),
                ('amount_fraction', models.IntegerField(default=0)),
                ('currency', models.CharField(max_length=12)),
                ('subject', models.CharField(default='(no subject given)', max_length=200)),
                ('date', models.DateTimeField(auto_now=True)),
                ('credit_account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='credit_account', to='app.BankAccount')),
                ('debit_account', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='debit_account', to='app.BankAccount')),
            ],
        ),
    ]
