#  This file is part of TALER
#  (C) 2014, 2015, 2016 INRIA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
#
#  @author Marcello Stanisci

from django.conf.urls import include, url
from . import user
from . import funds
from . import views
from . import history
from . import captcha

urlpatterns = [
    url(r'^', include('talerbank.urls')),
    url(r'^(?P<js>(use_js|no_js))?$', views.home_page, name='index'),
    url(r'^favicon\.ico$', views.ignore),
    url(r'^accounts/register/$', user.register_process, name="register"),
    url(r'^accounts/login/$', views.home_page, name="login"),
    url(r'^accounts/logout/$', user.logout_process, name="logout"),
    url(r'^profile$', views.profile_page, name="profile"),
    url(r'^withdraw$', funds.withdraw_nojs, name="withdraw-nojs"),
    url(r'^public-accounts/details$', user.view_public_accno_process),
    url(r'^public-accounts$', history.public_accounts_process, name="public-history"),
    url(r'^pin/question$', captcha.pin_tan_question, name="pin_tan"),
    url(r'^pin/verify$', captcha.pin_tan_verify),
    url(r'^javascript$', views.javascript_licensing)
    ]
