#  This file is part of TALER
#  (C) 2014, 2015, 2016 INRIA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
#
#  @author Marcello Stanisci


"""
definitions of JSON schemas for validating data
"""

import validictory
from .errors import BadIncomingRequest, BadWireDetails, BadAmount

wiredetails_schema = {"type": "object",
                      "properties": {
                          "test": {"type": "object",
                                   "properties": {
                                       "type": {"type": "string"},
                                       "account_number": {"type": "integer"},
                                       "bank_uri": {"type": "string"},
                                       "name": {"type": "string"},
                                       "salt": {"type": "string"},
                                       "sig": {"type": "string"}}}}}

amount_schema = {"type": "object",
                 "properties": {
                     "value": {"type": "integer"},
                     "fraction": {"type": "integer"},
                     "currency": {"type": "string"}}}

incoming_request_schema = {"type": "object",
                           "properties": {
                               "amount": {"type": amount_schema},
                               "wtid": {"type": "string"},
                               "credit_account": {"type": "integer"},
                               "debit_account": {"type": "integer"}}}

def validate_amount(amount):
    try:
        validictory.validate(amount, amount_schema)
    except (ValueError, TypeError):
        raise BadAmount()

def validate_wiredetails(wiredetails):
    try:
        validictory.validate(wiredetails, wiredetails_schema)
    except (ValueError, TypeError) as e:
        raise BadWireDetails(str(e))

def validate_incoming_request(incoming_request):
    try:
        validictory.validate(incoming_request, incoming_request_schema)
    except (ValueError, TypeError):
        raise BadIncomingRequest()
