#  This file is part of TALER
#  (C) 2014, 2015, 2016 INRIA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
#
#  @author Marcello Stanisci

from __future__ import unicode_literals
from django.contrib.auth.models import User
from django.db import models


class BankAccount(models.Model):
    is_public = models.BooleanField(default=False)
    balance = models.FloatField(default=0)
    currency = models.CharField(max_length=12, default="")
    account_no = models.AutoField(primary_key=True)
    user = models.OneToOneField(User, on_delete=models.CASCADE)


class History(models.Model):
    amount = models.FloatField(default=0)
    currency = models.CharField(max_length=12)
    direction = models.CharField(max_length=4)
    counterpart = models.ForeignKey(BankAccount,
                                    on_delete=models.CASCADE,
				    related_name="counterpart_account")
    subject = models.CharField(default="not given", max_length=200)
    date = models.DateTimeField(auto_now=True)
    account = models.ForeignKey(BankAccount, on_delete=models.CASCADE)
