#  This file is part of TALER
#  (C) 2014, 2015, 2106 INRIA
#
#  TALER is free software; you can redistribute it and/or modify it under the
#  terms of the GNU General Public License as published by the Free Software
#  Foundation; either version 3, or (at your option) any later version.
#
#  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
#  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License along with
#  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
#
#  @author Marcello Stanisci

from django.core.management.base import BaseCommand
from ...models import BankAccount, History
from django.db.utils import OperationalError, ProgrammingError
import logging
import sys

logger = logging.getLogger(__name__)

def dump_accounts():
    try:
        accounts = BankAccount.objects.all()
        if accounts.count() < 1:
            print("No accounts created yet..")
            return
        for acc in accounts:
            print(acc.user.username + " has account number " + str(acc.account_no))
    except (OperationalError, ProgrammingError):
        logger.error("likely causes: non existent DB or unmigrated project\n"
                     "(try 'taler-bank-manage django migrate' in the latter case)",
                     stack_info=False,
                     exc_info=True)
        sys.exit(1)


def dump_history():
    try:
        history = History.objects.all()
        for item in history:
            msg = []
            # concatenating via 'append' because the + operator put
            # as the first/last character on a line makes flake8 complain
            msg.append("Account ")
            msg.append(item.account.user.username + ": ")
            msg.append(item.direction + " " + str(item.amount) + " ")
            msg.append(item.currency + " on " + str(item.date))
            print(''.join(msg))
    except (OperationalError, ProgrammingError):
        logger.error("likely causes: non existent DB or unmigrated project\n"
                     "(try 'taler-bank-manage django migrate' in the latter case)",
                     stack_info=False,
                     exc_info=True)
        sys.exit(1)


class Command(BaseCommand):
    def handle(self, *args, **options):
        dump_accounts()
        dump_history()
