from django.core.checks import register, Warning
from django.db import OperationalError


@register()
def example_check(app_configs, **kwargs):
    errors = []
    try:
        from .models import User
        User.objects.get(username='Bank')
    except User.DoesNotExist:
        errors.append(
            Warning(
                'The bank user does not exist',
                hint="run the provide_accounts management command",
                id='talerbank.E001'
            ))
    except OperationalError:
            errors.append(Warning(
                'The bank user does not exist',
                hint="create a database for the application",
                id='talerbank.E002'
            ))
    return errors
