var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __pow = Math.pow;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a5, b4) => {
  for (var prop in b4 || (b4 = {}))
    if (__hasOwnProp.call(b4, prop))
      __defNormalProp(a5, prop, b4[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b4)) {
      if (__propIsEnum.call(b4, prop))
        __defNormalProp(a5, prop, b4[prop]);
    }
  return a5;
};
var __spreadProps = (a5, b4) => __defProps(a5, __getOwnPropDescs(b4));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __esm = (fn2, res) => function __init() {
  return fn2 && (res = (0, fn2[__getOwnPropNames(fn2)[0]])(fn2 = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e4) {
        reject(e4);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e4) {
        reject(e4);
      }
    };
    var step = (x6) => x6.done ? resolve(x6.value) : Promise.resolve(x6.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// ../../node_modules/.pnpm/big-integer@1.6.51/node_modules/big-integer/BigInteger.js
var require_BigInteger = __commonJS({
  "../../node_modules/.pnpm/big-integer@1.6.51/node_modules/big-integer/BigInteger.js"(exports, module) {
    var bigInt = function(undefined2) {
      "use strict";
      var BASE = 1e7, LOG_BASE = 7, MAX_INT = 9007199254740992, MAX_INT_ARR = smallToArray(MAX_INT), DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
      var supportsNativeBigInt = typeof BigInt === "function";
      function Integer(v3, radix, alphabet, caseSensitive) {
        if (typeof v3 === "undefined")
          return Integer[0];
        if (typeof radix !== "undefined")
          return +radix === 10 && !alphabet ? parseValue(v3) : parseBase(v3, radix, alphabet, caseSensitive);
        return parseValue(v3);
      }
      function BigInteger(value, sign) {
        this.value = value;
        this.sign = sign;
        this.isSmall = false;
      }
      BigInteger.prototype = Object.create(Integer.prototype);
      function SmallInteger(value) {
        this.value = value;
        this.sign = value < 0;
        this.isSmall = true;
      }
      SmallInteger.prototype = Object.create(Integer.prototype);
      function NativeBigInt(value) {
        this.value = value;
      }
      NativeBigInt.prototype = Object.create(Integer.prototype);
      function isPrecise(n2) {
        return -MAX_INT < n2 && n2 < MAX_INT;
      }
      function smallToArray(n2) {
        if (n2 < 1e7)
          return [n2];
        if (n2 < 1e14)
          return [n2 % 1e7, Math.floor(n2 / 1e7)];
        return [n2 % 1e7, Math.floor(n2 / 1e7) % 1e7, Math.floor(n2 / 1e14)];
      }
      function arrayToSmall(arr) {
        trim(arr);
        var length = arr.length;
        if (length < 4 && compareAbs(arr, MAX_INT_ARR) < 0) {
          switch (length) {
            case 0:
              return 0;
            case 1:
              return arr[0];
            case 2:
              return arr[0] + arr[1] * BASE;
            default:
              return arr[0] + (arr[1] + arr[2] * BASE) * BASE;
          }
        }
        return arr;
      }
      function trim(v3) {
        var i5 = v3.length;
        while (v3[--i5] === 0)
          ;
        v3.length = i5 + 1;
      }
      function createArray(length) {
        var x6 = new Array(length);
        var i5 = -1;
        while (++i5 < length) {
          x6[i5] = 0;
        }
        return x6;
      }
      function truncate(n2) {
        if (n2 > 0)
          return Math.floor(n2);
        return Math.ceil(n2);
      }
      function add2(a5, b4) {
        var l_a = a5.length, l_b = b4.length, r3 = new Array(l_a), carry = 0, base2 = BASE, sum, i5;
        for (i5 = 0; i5 < l_b; i5++) {
          sum = a5[i5] + b4[i5] + carry;
          carry = sum >= base2 ? 1 : 0;
          r3[i5] = sum - carry * base2;
        }
        while (i5 < l_a) {
          sum = a5[i5] + carry;
          carry = sum === base2 ? 1 : 0;
          r3[i5++] = sum - carry * base2;
        }
        if (carry > 0)
          r3.push(carry);
        return r3;
      }
      function addAny(a5, b4) {
        if (a5.length >= b4.length)
          return add2(a5, b4);
        return add2(b4, a5);
      }
      function addSmall(a5, carry) {
        var l3 = a5.length, r3 = new Array(l3), base2 = BASE, sum, i5;
        for (i5 = 0; i5 < l3; i5++) {
          sum = a5[i5] - base2 + carry;
          carry = Math.floor(sum / base2);
          r3[i5] = sum - carry * base2;
          carry += 1;
        }
        while (carry > 0) {
          r3[i5++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      BigInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var a5 = this.value, b4 = n2.value;
        if (n2.isSmall) {
          return new BigInteger(addSmall(a5, Math.abs(b4)), this.sign);
        }
        return new BigInteger(addAny(a5, b4), this.sign);
      };
      BigInteger.prototype.plus = BigInteger.prototype.add;
      SmallInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        var a5 = this.value;
        if (a5 < 0 !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var b4 = n2.value;
        if (n2.isSmall) {
          if (isPrecise(a5 + b4))
            return new SmallInteger(a5 + b4);
          b4 = smallToArray(Math.abs(b4));
        }
        return new BigInteger(addSmall(b4, Math.abs(a5)), a5 < 0);
      };
      SmallInteger.prototype.plus = SmallInteger.prototype.add;
      NativeBigInt.prototype.add = function(v3) {
        return new NativeBigInt(this.value + parseValue(v3).value);
      };
      NativeBigInt.prototype.plus = NativeBigInt.prototype.add;
      function subtract(a5, b4) {
        var a_l = a5.length, b_l = b4.length, r3 = new Array(a_l), borrow = 0, base2 = BASE, i5, difference;
        for (i5 = 0; i5 < b_l; i5++) {
          difference = a5[i5] - borrow - b4[i5];
          if (difference < 0) {
            difference += base2;
            borrow = 1;
          } else
            borrow = 0;
          r3[i5] = difference;
        }
        for (i5 = b_l; i5 < a_l; i5++) {
          difference = a5[i5] - borrow;
          if (difference < 0)
            difference += base2;
          else {
            r3[i5++] = difference;
            break;
          }
          r3[i5] = difference;
        }
        for (; i5 < a_l; i5++) {
          r3[i5] = a5[i5];
        }
        trim(r3);
        return r3;
      }
      function subtractAny(a5, b4, sign) {
        var value;
        if (compareAbs(a5, b4) >= 0) {
          value = subtract(a5, b4);
        } else {
          value = subtract(b4, a5);
          sign = !sign;
        }
        value = arrayToSmall(value);
        if (typeof value === "number") {
          if (sign)
            value = -value;
          return new SmallInteger(value);
        }
        return new BigInteger(value, sign);
      }
      function subtractSmall(a5, b4, sign) {
        var l3 = a5.length, r3 = new Array(l3), carry = -b4, base2 = BASE, i5, difference;
        for (i5 = 0; i5 < l3; i5++) {
          difference = a5[i5] + carry;
          carry = Math.floor(difference / base2);
          difference %= base2;
          r3[i5] = difference < 0 ? difference + base2 : difference;
        }
        r3 = arrayToSmall(r3);
        if (typeof r3 === "number") {
          if (sign)
            r3 = -r3;
          return new SmallInteger(r3);
        }
        return new BigInteger(r3, sign);
      }
      BigInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.add(n2.negate());
        }
        var a5 = this.value, b4 = n2.value;
        if (n2.isSmall)
          return subtractSmall(a5, Math.abs(b4), this.sign);
        return subtractAny(a5, b4, this.sign);
      };
      BigInteger.prototype.minus = BigInteger.prototype.subtract;
      SmallInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        var a5 = this.value;
        if (a5 < 0 !== n2.sign) {
          return this.add(n2.negate());
        }
        var b4 = n2.value;
        if (n2.isSmall) {
          return new SmallInteger(a5 - b4);
        }
        return subtractSmall(b4, Math.abs(a5), a5 >= 0);
      };
      SmallInteger.prototype.minus = SmallInteger.prototype.subtract;
      NativeBigInt.prototype.subtract = function(v3) {
        return new NativeBigInt(this.value - parseValue(v3).value);
      };
      NativeBigInt.prototype.minus = NativeBigInt.prototype.subtract;
      BigInteger.prototype.negate = function() {
        return new BigInteger(this.value, !this.sign);
      };
      SmallInteger.prototype.negate = function() {
        var sign = this.sign;
        var small = new SmallInteger(-this.value);
        small.sign = !sign;
        return small;
      };
      NativeBigInt.prototype.negate = function() {
        return new NativeBigInt(-this.value);
      };
      BigInteger.prototype.abs = function() {
        return new BigInteger(this.value, false);
      };
      SmallInteger.prototype.abs = function() {
        return new SmallInteger(Math.abs(this.value));
      };
      NativeBigInt.prototype.abs = function() {
        return new NativeBigInt(this.value >= 0 ? this.value : -this.value);
      };
      function multiplyLong(a5, b4) {
        var a_l = a5.length, b_l = b4.length, l3 = a_l + b_l, r3 = createArray(l3), base2 = BASE, product, carry, i5, a_i, b_j;
        for (i5 = 0; i5 < a_l; ++i5) {
          a_i = a5[i5];
          for (var j4 = 0; j4 < b_l; ++j4) {
            b_j = b4[j4];
            product = a_i * b_j + r3[i5 + j4];
            carry = Math.floor(product / base2);
            r3[i5 + j4] = product - carry * base2;
            r3[i5 + j4 + 1] += carry;
          }
        }
        trim(r3);
        return r3;
      }
      function multiplySmall(a5, b4) {
        var l3 = a5.length, r3 = new Array(l3), base2 = BASE, carry = 0, product, i5;
        for (i5 = 0; i5 < l3; i5++) {
          product = a5[i5] * b4 + carry;
          carry = Math.floor(product / base2);
          r3[i5] = product - carry * base2;
        }
        while (carry > 0) {
          r3[i5++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      function shiftLeft(x6, n2) {
        var r3 = [];
        while (n2-- > 0)
          r3.push(0);
        return r3.concat(x6);
      }
      function multiplyKaratsuba(x6, y5) {
        var n2 = Math.max(x6.length, y5.length);
        if (n2 <= 30)
          return multiplyLong(x6, y5);
        n2 = Math.ceil(n2 / 2);
        var b4 = x6.slice(n2), a5 = x6.slice(0, n2), d5 = y5.slice(n2), c4 = y5.slice(0, n2);
        var ac = multiplyKaratsuba(a5, c4), bd = multiplyKaratsuba(b4, d5), abcd = multiplyKaratsuba(addAny(a5, b4), addAny(c4, d5));
        var product = addAny(addAny(ac, shiftLeft(subtract(subtract(abcd, ac), bd), n2)), shiftLeft(bd, 2 * n2));
        trim(product);
        return product;
      }
      function useKaratsuba(l1, l22) {
        return -0.012 * l1 - 0.012 * l22 + 15e-6 * l1 * l22 > 0;
      }
      BigInteger.prototype.multiply = function(v3) {
        var n2 = parseValue(v3), a5 = this.value, b4 = n2.value, sign = this.sign !== n2.sign, abs;
        if (n2.isSmall) {
          if (b4 === 0)
            return Integer[0];
          if (b4 === 1)
            return this;
          if (b4 === -1)
            return this.negate();
          abs = Math.abs(b4);
          if (abs < BASE) {
            return new BigInteger(multiplySmall(a5, abs), sign);
          }
          b4 = smallToArray(abs);
        }
        if (useKaratsuba(a5.length, b4.length))
          return new BigInteger(multiplyKaratsuba(a5, b4), sign);
        return new BigInteger(multiplyLong(a5, b4), sign);
      };
      BigInteger.prototype.times = BigInteger.prototype.multiply;
      function multiplySmallAndArray(a5, b4, sign) {
        if (a5 < BASE) {
          return new BigInteger(multiplySmall(b4, a5), sign);
        }
        return new BigInteger(multiplyLong(b4, smallToArray(a5)), sign);
      }
      SmallInteger.prototype._multiplyBySmall = function(a5) {
        if (isPrecise(a5.value * this.value)) {
          return new SmallInteger(a5.value * this.value);
        }
        return multiplySmallAndArray(Math.abs(a5.value), smallToArray(Math.abs(this.value)), this.sign !== a5.sign);
      };
      BigInteger.prototype._multiplyBySmall = function(a5) {
        if (a5.value === 0)
          return Integer[0];
        if (a5.value === 1)
          return this;
        if (a5.value === -1)
          return this.negate();
        return multiplySmallAndArray(Math.abs(a5.value), this.value, this.sign !== a5.sign);
      };
      SmallInteger.prototype.multiply = function(v3) {
        return parseValue(v3)._multiplyBySmall(this);
      };
      SmallInteger.prototype.times = SmallInteger.prototype.multiply;
      NativeBigInt.prototype.multiply = function(v3) {
        return new NativeBigInt(this.value * parseValue(v3).value);
      };
      NativeBigInt.prototype.times = NativeBigInt.prototype.multiply;
      function square(a5) {
        var l3 = a5.length, r3 = createArray(l3 + l3), base2 = BASE, product, carry, i5, a_i, a_j;
        for (i5 = 0; i5 < l3; i5++) {
          a_i = a5[i5];
          carry = 0 - a_i * a_i;
          for (var j4 = i5; j4 < l3; j4++) {
            a_j = a5[j4];
            product = 2 * (a_i * a_j) + r3[i5 + j4] + carry;
            carry = Math.floor(product / base2);
            r3[i5 + j4] = product - carry * base2;
          }
          r3[i5 + l3] = carry;
        }
        trim(r3);
        return r3;
      }
      BigInteger.prototype.square = function() {
        return new BigInteger(square(this.value), false);
      };
      SmallInteger.prototype.square = function() {
        var value = this.value * this.value;
        if (isPrecise(value))
          return new SmallInteger(value);
        return new BigInteger(square(smallToArray(Math.abs(this.value))), false);
      };
      NativeBigInt.prototype.square = function(v3) {
        return new NativeBigInt(this.value * this.value);
      };
      function divMod1(a5, b4) {
        var a_l = a5.length, b_l = b4.length, base2 = BASE, result = createArray(b4.length), divisorMostSignificantDigit = b4[b_l - 1], lambda = Math.ceil(base2 / (2 * divisorMostSignificantDigit)), remainder = multiplySmall(a5, lambda), divisor = multiplySmall(b4, lambda), quotientDigit, shift, carry, borrow, i5, l3, q5;
        if (remainder.length <= a_l)
          remainder.push(0);
        divisor.push(0);
        divisorMostSignificantDigit = divisor[b_l - 1];
        for (shift = a_l - b_l; shift >= 0; shift--) {
          quotientDigit = base2 - 1;
          if (remainder[shift + b_l] !== divisorMostSignificantDigit) {
            quotientDigit = Math.floor((remainder[shift + b_l] * base2 + remainder[shift + b_l - 1]) / divisorMostSignificantDigit);
          }
          carry = 0;
          borrow = 0;
          l3 = divisor.length;
          for (i5 = 0; i5 < l3; i5++) {
            carry += quotientDigit * divisor[i5];
            q5 = Math.floor(carry / base2);
            borrow += remainder[shift + i5] - (carry - q5 * base2);
            carry = q5;
            if (borrow < 0) {
              remainder[shift + i5] = borrow + base2;
              borrow = -1;
            } else {
              remainder[shift + i5] = borrow;
              borrow = 0;
            }
          }
          while (borrow !== 0) {
            quotientDigit -= 1;
            carry = 0;
            for (i5 = 0; i5 < l3; i5++) {
              carry += remainder[shift + i5] - base2 + divisor[i5];
              if (carry < 0) {
                remainder[shift + i5] = carry + base2;
                carry = 0;
              } else {
                remainder[shift + i5] = carry;
                carry = 1;
              }
            }
            borrow += carry;
          }
          result[shift] = quotientDigit;
        }
        remainder = divModSmall(remainder, lambda)[0];
        return [arrayToSmall(result), arrayToSmall(remainder)];
      }
      function divMod2(a5, b4) {
        var a_l = a5.length, b_l = b4.length, result = [], part = [], base2 = BASE, guess, xlen, highx, highy, check;
        while (a_l) {
          part.unshift(a5[--a_l]);
          trim(part);
          if (compareAbs(part, b4) < 0) {
            result.push(0);
            continue;
          }
          xlen = part.length;
          highx = part[xlen - 1] * base2 + part[xlen - 2];
          highy = b4[b_l - 1] * base2 + b4[b_l - 2];
          if (xlen > b_l) {
            highx = (highx + 1) * base2;
          }
          guess = Math.ceil(highx / highy);
          do {
            check = multiplySmall(b4, guess);
            if (compareAbs(check, part) <= 0)
              break;
            guess--;
          } while (guess);
          result.push(guess);
          part = subtract(part, check);
        }
        result.reverse();
        return [arrayToSmall(result), arrayToSmall(part)];
      }
      function divModSmall(value, lambda) {
        var length = value.length, quotient = createArray(length), base2 = BASE, i5, q5, remainder, divisor;
        remainder = 0;
        for (i5 = length - 1; i5 >= 0; --i5) {
          divisor = remainder * base2 + value[i5];
          q5 = truncate(divisor / lambda);
          remainder = divisor - q5 * lambda;
          quotient[i5] = q5 | 0;
        }
        return [quotient, remainder | 0];
      }
      function divModAny(self2, v3) {
        var value, n2 = parseValue(v3);
        if (supportsNativeBigInt) {
          return [new NativeBigInt(self2.value / n2.value), new NativeBigInt(self2.value % n2.value)];
        }
        var a5 = self2.value, b4 = n2.value;
        var quotient;
        if (b4 === 0)
          throw new Error("Cannot divide by zero");
        if (self2.isSmall) {
          if (n2.isSmall) {
            return [new SmallInteger(truncate(a5 / b4)), new SmallInteger(a5 % b4)];
          }
          return [Integer[0], self2];
        }
        if (n2.isSmall) {
          if (b4 === 1)
            return [self2, Integer[0]];
          if (b4 == -1)
            return [self2.negate(), Integer[0]];
          var abs = Math.abs(b4);
          if (abs < BASE) {
            value = divModSmall(a5, abs);
            quotient = arrayToSmall(value[0]);
            var remainder = value[1];
            if (self2.sign)
              remainder = -remainder;
            if (typeof quotient === "number") {
              if (self2.sign !== n2.sign)
                quotient = -quotient;
              return [new SmallInteger(quotient), new SmallInteger(remainder)];
            }
            return [new BigInteger(quotient, self2.sign !== n2.sign), new SmallInteger(remainder)];
          }
          b4 = smallToArray(abs);
        }
        var comparison = compareAbs(a5, b4);
        if (comparison === -1)
          return [Integer[0], self2];
        if (comparison === 0)
          return [Integer[self2.sign === n2.sign ? 1 : -1], Integer[0]];
        if (a5.length + b4.length <= 200)
          value = divMod1(a5, b4);
        else
          value = divMod2(a5, b4);
        quotient = value[0];
        var qSign = self2.sign !== n2.sign, mod = value[1], mSign = self2.sign;
        if (typeof quotient === "number") {
          if (qSign)
            quotient = -quotient;
          quotient = new SmallInteger(quotient);
        } else
          quotient = new BigInteger(quotient, qSign);
        if (typeof mod === "number") {
          if (mSign)
            mod = -mod;
          mod = new SmallInteger(mod);
        } else
          mod = new BigInteger(mod, mSign);
        return [quotient, mod];
      }
      BigInteger.prototype.divmod = function(v3) {
        var result = divModAny(this, v3);
        return {
          quotient: result[0],
          remainder: result[1]
        };
      };
      NativeBigInt.prototype.divmod = SmallInteger.prototype.divmod = BigInteger.prototype.divmod;
      BigInteger.prototype.divide = function(v3) {
        return divModAny(this, v3)[0];
      };
      NativeBigInt.prototype.over = NativeBigInt.prototype.divide = function(v3) {
        return new NativeBigInt(this.value / parseValue(v3).value);
      };
      SmallInteger.prototype.over = SmallInteger.prototype.divide = BigInteger.prototype.over = BigInteger.prototype.divide;
      BigInteger.prototype.mod = function(v3) {
        return divModAny(this, v3)[1];
      };
      NativeBigInt.prototype.mod = NativeBigInt.prototype.remainder = function(v3) {
        return new NativeBigInt(this.value % parseValue(v3).value);
      };
      SmallInteger.prototype.remainder = SmallInteger.prototype.mod = BigInteger.prototype.remainder = BigInteger.prototype.mod;
      BigInteger.prototype.pow = function(v3) {
        var n2 = parseValue(v3), a5 = this.value, b4 = n2.value, value, x6, y5;
        if (b4 === 0)
          return Integer[1];
        if (a5 === 0)
          return Integer[0];
        if (a5 === 1)
          return Integer[1];
        if (a5 === -1)
          return n2.isEven() ? Integer[1] : Integer[-1];
        if (n2.sign) {
          return Integer[0];
        }
        if (!n2.isSmall)
          throw new Error("The exponent " + n2.toString() + " is too large.");
        if (this.isSmall) {
          if (isPrecise(value = Math.pow(a5, b4)))
            return new SmallInteger(truncate(value));
        }
        x6 = this;
        y5 = Integer[1];
        while (true) {
          if (b4 & true) {
            y5 = y5.times(x6);
            --b4;
          }
          if (b4 === 0)
            break;
          b4 /= 2;
          x6 = x6.square();
        }
        return y5;
      };
      SmallInteger.prototype.pow = BigInteger.prototype.pow;
      NativeBigInt.prototype.pow = function(v3) {
        var n2 = parseValue(v3);
        var a5 = this.value, b4 = n2.value;
        var _0 = BigInt(0), _1 = BigInt(1), _22 = BigInt(2);
        if (b4 === _0)
          return Integer[1];
        if (a5 === _0)
          return Integer[0];
        if (a5 === _1)
          return Integer[1];
        if (a5 === BigInt(-1))
          return n2.isEven() ? Integer[1] : Integer[-1];
        if (n2.isNegative())
          return new NativeBigInt(_0);
        var x6 = this;
        var y5 = Integer[1];
        while (true) {
          if ((b4 & _1) === _1) {
            y5 = y5.times(x6);
            --b4;
          }
          if (b4 === _0)
            break;
          b4 /= _22;
          x6 = x6.square();
        }
        return y5;
      };
      BigInteger.prototype.modPow = function(exp, mod) {
        exp = parseValue(exp);
        mod = parseValue(mod);
        if (mod.isZero())
          throw new Error("Cannot take modPow with modulus 0");
        var r3 = Integer[1], base2 = this.mod(mod);
        if (exp.isNegative()) {
          exp = exp.multiply(Integer[-1]);
          base2 = base2.modInv(mod);
        }
        while (exp.isPositive()) {
          if (base2.isZero())
            return Integer[0];
          if (exp.isOdd())
            r3 = r3.multiply(base2).mod(mod);
          exp = exp.divide(2);
          base2 = base2.square().mod(mod);
        }
        return r3;
      };
      NativeBigInt.prototype.modPow = SmallInteger.prototype.modPow = BigInteger.prototype.modPow;
      function compareAbs(a5, b4) {
        if (a5.length !== b4.length) {
          return a5.length > b4.length ? 1 : -1;
        }
        for (var i5 = a5.length - 1; i5 >= 0; i5--) {
          if (a5[i5] !== b4[i5])
            return a5[i5] > b4[i5] ? 1 : -1;
        }
        return 0;
      }
      BigInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a5 = this.value, b4 = n2.value;
        if (n2.isSmall)
          return 1;
        return compareAbs(a5, b4);
      };
      SmallInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a5 = Math.abs(this.value), b4 = n2.value;
        if (n2.isSmall) {
          b4 = Math.abs(b4);
          return a5 === b4 ? 0 : a5 > b4 ? 1 : -1;
        }
        return -1;
      };
      NativeBigInt.prototype.compareAbs = function(v3) {
        var a5 = this.value;
        var b4 = parseValue(v3).value;
        a5 = a5 >= 0 ? a5 : -a5;
        b4 = b4 >= 0 ? b4 : -b4;
        return a5 === b4 ? 0 : a5 > b4 ? 1 : -1;
      };
      BigInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a5 = this.value, b4 = n2.value;
        if (this.sign !== n2.sign) {
          return n2.sign ? 1 : -1;
        }
        if (n2.isSmall) {
          return this.sign ? -1 : 1;
        }
        return compareAbs(a5, b4) * (this.sign ? -1 : 1);
      };
      BigInteger.prototype.compareTo = BigInteger.prototype.compare;
      SmallInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a5 = this.value, b4 = n2.value;
        if (n2.isSmall) {
          return a5 == b4 ? 0 : a5 > b4 ? 1 : -1;
        }
        if (a5 < 0 !== n2.sign) {
          return a5 < 0 ? -1 : 1;
        }
        return a5 < 0 ? 1 : -1;
      };
      SmallInteger.prototype.compareTo = SmallInteger.prototype.compare;
      NativeBigInt.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var a5 = this.value;
        var b4 = parseValue(v3).value;
        return a5 === b4 ? 0 : a5 > b4 ? 1 : -1;
      };
      NativeBigInt.prototype.compareTo = NativeBigInt.prototype.compare;
      BigInteger.prototype.equals = function(v3) {
        return this.compare(v3) === 0;
      };
      NativeBigInt.prototype.eq = NativeBigInt.prototype.equals = SmallInteger.prototype.eq = SmallInteger.prototype.equals = BigInteger.prototype.eq = BigInteger.prototype.equals;
      BigInteger.prototype.notEquals = function(v3) {
        return this.compare(v3) !== 0;
      };
      NativeBigInt.prototype.neq = NativeBigInt.prototype.notEquals = SmallInteger.prototype.neq = SmallInteger.prototype.notEquals = BigInteger.prototype.neq = BigInteger.prototype.notEquals;
      BigInteger.prototype.greater = function(v3) {
        return this.compare(v3) > 0;
      };
      NativeBigInt.prototype.gt = NativeBigInt.prototype.greater = SmallInteger.prototype.gt = SmallInteger.prototype.greater = BigInteger.prototype.gt = BigInteger.prototype.greater;
      BigInteger.prototype.lesser = function(v3) {
        return this.compare(v3) < 0;
      };
      NativeBigInt.prototype.lt = NativeBigInt.prototype.lesser = SmallInteger.prototype.lt = SmallInteger.prototype.lesser = BigInteger.prototype.lt = BigInteger.prototype.lesser;
      BigInteger.prototype.greaterOrEquals = function(v3) {
        return this.compare(v3) >= 0;
      };
      NativeBigInt.prototype.geq = NativeBigInt.prototype.greaterOrEquals = SmallInteger.prototype.geq = SmallInteger.prototype.greaterOrEquals = BigInteger.prototype.geq = BigInteger.prototype.greaterOrEquals;
      BigInteger.prototype.lesserOrEquals = function(v3) {
        return this.compare(v3) <= 0;
      };
      NativeBigInt.prototype.leq = NativeBigInt.prototype.lesserOrEquals = SmallInteger.prototype.leq = SmallInteger.prototype.lesserOrEquals = BigInteger.prototype.leq = BigInteger.prototype.lesserOrEquals;
      BigInteger.prototype.isEven = function() {
        return (this.value[0] & 1) === 0;
      };
      SmallInteger.prototype.isEven = function() {
        return (this.value & 1) === 0;
      };
      NativeBigInt.prototype.isEven = function() {
        return (this.value & BigInt(1)) === BigInt(0);
      };
      BigInteger.prototype.isOdd = function() {
        return (this.value[0] & 1) === 1;
      };
      SmallInteger.prototype.isOdd = function() {
        return (this.value & 1) === 1;
      };
      NativeBigInt.prototype.isOdd = function() {
        return (this.value & BigInt(1)) === BigInt(1);
      };
      BigInteger.prototype.isPositive = function() {
        return !this.sign;
      };
      SmallInteger.prototype.isPositive = function() {
        return this.value > 0;
      };
      NativeBigInt.prototype.isPositive = SmallInteger.prototype.isPositive;
      BigInteger.prototype.isNegative = function() {
        return this.sign;
      };
      SmallInteger.prototype.isNegative = function() {
        return this.value < 0;
      };
      NativeBigInt.prototype.isNegative = SmallInteger.prototype.isNegative;
      BigInteger.prototype.isUnit = function() {
        return false;
      };
      SmallInteger.prototype.isUnit = function() {
        return Math.abs(this.value) === 1;
      };
      NativeBigInt.prototype.isUnit = function() {
        return this.abs().value === BigInt(1);
      };
      BigInteger.prototype.isZero = function() {
        return false;
      };
      SmallInteger.prototype.isZero = function() {
        return this.value === 0;
      };
      NativeBigInt.prototype.isZero = function() {
        return this.value === BigInt(0);
      };
      BigInteger.prototype.isDivisibleBy = function(v3) {
        var n2 = parseValue(v3);
        if (n2.isZero())
          return false;
        if (n2.isUnit())
          return true;
        if (n2.compareAbs(2) === 0)
          return this.isEven();
        return this.mod(n2).isZero();
      };
      NativeBigInt.prototype.isDivisibleBy = SmallInteger.prototype.isDivisibleBy = BigInteger.prototype.isDivisibleBy;
      function isBasicPrime(v3) {
        var n2 = v3.abs();
        if (n2.isUnit())
          return false;
        if (n2.equals(2) || n2.equals(3) || n2.equals(5))
          return true;
        if (n2.isEven() || n2.isDivisibleBy(3) || n2.isDivisibleBy(5))
          return false;
        if (n2.lesser(49))
          return true;
      }
      function millerRabinTest(n2, a5) {
        var nPrev = n2.prev(), b4 = nPrev, r3 = 0, d5, t4, i5, x6;
        while (b4.isEven())
          b4 = b4.divide(2), r3++;
        next:
          for (i5 = 0; i5 < a5.length; i5++) {
            if (n2.lesser(a5[i5]))
              continue;
            x6 = bigInt(a5[i5]).modPow(b4, n2);
            if (x6.isUnit() || x6.equals(nPrev))
              continue;
            for (d5 = r3 - 1; d5 != 0; d5--) {
              x6 = x6.square().mod(n2);
              if (x6.isUnit())
                return false;
              if (x6.equals(nPrev))
                continue next;
            }
            return false;
          }
        return true;
      }
      BigInteger.prototype.isPrime = function(strict) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var bits = n2.bitLength();
        if (bits <= 64)
          return millerRabinTest(n2, [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]);
        var logN = Math.log(2) * bits.toJSNumber();
        var t4 = Math.ceil(strict === true ? 2 * Math.pow(logN, 2) : logN);
        for (var a5 = [], i5 = 0; i5 < t4; i5++) {
          a5.push(bigInt(i5 + 2));
        }
        return millerRabinTest(n2, a5);
      };
      NativeBigInt.prototype.isPrime = SmallInteger.prototype.isPrime = BigInteger.prototype.isPrime;
      BigInteger.prototype.isProbablePrime = function(iterations, rng) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var t4 = iterations === undefined2 ? 5 : iterations;
        for (var a5 = [], i5 = 0; i5 < t4; i5++) {
          a5.push(bigInt.randBetween(2, n2.minus(2), rng));
        }
        return millerRabinTest(n2, a5);
      };
      NativeBigInt.prototype.isProbablePrime = SmallInteger.prototype.isProbablePrime = BigInteger.prototype.isProbablePrime;
      BigInteger.prototype.modInv = function(n2) {
        var t4 = bigInt.zero, newT = bigInt.one, r3 = parseValue(n2), newR = this.abs(), q5, lastT, lastR;
        while (!newR.isZero()) {
          q5 = r3.divide(newR);
          lastT = t4;
          lastR = r3;
          t4 = newT;
          r3 = newR;
          newT = lastT.subtract(q5.multiply(newT));
          newR = lastR.subtract(q5.multiply(newR));
        }
        if (!r3.isUnit())
          throw new Error(this.toString() + " and " + n2.toString() + " are not co-prime");
        if (t4.compare(0) === -1) {
          t4 = t4.add(n2);
        }
        if (this.isNegative()) {
          return t4.negate();
        }
        return t4;
      };
      NativeBigInt.prototype.modInv = SmallInteger.prototype.modInv = BigInteger.prototype.modInv;
      BigInteger.prototype.next = function() {
        var value = this.value;
        if (this.sign) {
          return subtractSmall(value, 1, this.sign);
        }
        return new BigInteger(addSmall(value, 1), this.sign);
      };
      SmallInteger.prototype.next = function() {
        var value = this.value;
        if (value + 1 < MAX_INT)
          return new SmallInteger(value + 1);
        return new BigInteger(MAX_INT_ARR, false);
      };
      NativeBigInt.prototype.next = function() {
        return new NativeBigInt(this.value + BigInt(1));
      };
      BigInteger.prototype.prev = function() {
        var value = this.value;
        if (this.sign) {
          return new BigInteger(addSmall(value, 1), true);
        }
        return subtractSmall(value, 1, this.sign);
      };
      SmallInteger.prototype.prev = function() {
        var value = this.value;
        if (value - 1 > -MAX_INT)
          return new SmallInteger(value - 1);
        return new BigInteger(MAX_INT_ARR, true);
      };
      NativeBigInt.prototype.prev = function() {
        return new NativeBigInt(this.value - BigInt(1));
      };
      var powersOfTwo = [1];
      while (2 * powersOfTwo[powersOfTwo.length - 1] <= BASE)
        powersOfTwo.push(2 * powersOfTwo[powersOfTwo.length - 1]);
      var powers2Length = powersOfTwo.length, highestPower2 = powersOfTwo[powers2Length - 1];
      function shift_isSmall(n2) {
        return Math.abs(n2) <= BASE;
      }
      BigInteger.prototype.shiftLeft = function(v3) {
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftRight(-n2);
        var result = this;
        if (result.isZero())
          return result;
        while (n2 >= powers2Length) {
          result = result.multiply(highestPower2);
          n2 -= powers2Length - 1;
        }
        return result.multiply(powersOfTwo[n2]);
      };
      NativeBigInt.prototype.shiftLeft = SmallInteger.prototype.shiftLeft = BigInteger.prototype.shiftLeft;
      BigInteger.prototype.shiftRight = function(v3) {
        var remQuo;
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftLeft(-n2);
        var result = this;
        while (n2 >= powers2Length) {
          if (result.isZero() || result.isNegative() && result.isUnit())
            return result;
          remQuo = divModAny(result, highestPower2);
          result = remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
          n2 -= powers2Length - 1;
        }
        remQuo = divModAny(result, powersOfTwo[n2]);
        return remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
      };
      NativeBigInt.prototype.shiftRight = SmallInteger.prototype.shiftRight = BigInteger.prototype.shiftRight;
      function bitwise(x6, y5, fn2) {
        y5 = parseValue(y5);
        var xSign = x6.isNegative(), ySign = y5.isNegative();
        var xRem = xSign ? x6.not() : x6, yRem = ySign ? y5.not() : y5;
        var xDigit = 0, yDigit = 0;
        var xDivMod = null, yDivMod = null;
        var result = [];
        while (!xRem.isZero() || !yRem.isZero()) {
          xDivMod = divModAny(xRem, highestPower2);
          xDigit = xDivMod[1].toJSNumber();
          if (xSign) {
            xDigit = highestPower2 - 1 - xDigit;
          }
          yDivMod = divModAny(yRem, highestPower2);
          yDigit = yDivMod[1].toJSNumber();
          if (ySign) {
            yDigit = highestPower2 - 1 - yDigit;
          }
          xRem = xDivMod[0];
          yRem = yDivMod[0];
          result.push(fn2(xDigit, yDigit));
        }
        var sum = fn2(xSign ? 1 : 0, ySign ? 1 : 0) !== 0 ? bigInt(-1) : bigInt(0);
        for (var i5 = result.length - 1; i5 >= 0; i5 -= 1) {
          sum = sum.multiply(highestPower2).add(bigInt(result[i5]));
        }
        return sum;
      }
      BigInteger.prototype.not = function() {
        return this.negate().prev();
      };
      NativeBigInt.prototype.not = SmallInteger.prototype.not = BigInteger.prototype.not;
      BigInteger.prototype.and = function(n2) {
        return bitwise(this, n2, function(a5, b4) {
          return a5 & b4;
        });
      };
      NativeBigInt.prototype.and = SmallInteger.prototype.and = BigInteger.prototype.and;
      BigInteger.prototype.or = function(n2) {
        return bitwise(this, n2, function(a5, b4) {
          return a5 | b4;
        });
      };
      NativeBigInt.prototype.or = SmallInteger.prototype.or = BigInteger.prototype.or;
      BigInteger.prototype.xor = function(n2) {
        return bitwise(this, n2, function(a5, b4) {
          return a5 ^ b4;
        });
      };
      NativeBigInt.prototype.xor = SmallInteger.prototype.xor = BigInteger.prototype.xor;
      var LOBMASK_I = 1 << 30, LOBMASK_BI = (BASE & -BASE) * (BASE & -BASE) | LOBMASK_I;
      function roughLOB(n2) {
        var v3 = n2.value, x6 = typeof v3 === "number" ? v3 | LOBMASK_I : typeof v3 === "bigint" ? v3 | BigInt(LOBMASK_I) : v3[0] + v3[1] * BASE | LOBMASK_BI;
        return x6 & -x6;
      }
      function integerLogarithm(value, base2) {
        if (base2.compareTo(value) <= 0) {
          var tmp = integerLogarithm(value, base2.square(base2));
          var p4 = tmp.p;
          var e4 = tmp.e;
          var t4 = p4.multiply(base2);
          return t4.compareTo(value) <= 0 ? { p: t4, e: e4 * 2 + 1 } : { p: p4, e: e4 * 2 };
        }
        return { p: bigInt(1), e: 0 };
      }
      BigInteger.prototype.bitLength = function() {
        var n2 = this;
        if (n2.compareTo(bigInt(0)) < 0) {
          n2 = n2.negate().subtract(bigInt(1));
        }
        if (n2.compareTo(bigInt(0)) === 0) {
          return bigInt(0);
        }
        return bigInt(integerLogarithm(n2, bigInt(2)).e).add(bigInt(1));
      };
      NativeBigInt.prototype.bitLength = SmallInteger.prototype.bitLength = BigInteger.prototype.bitLength;
      function max(a5, b4) {
        a5 = parseValue(a5);
        b4 = parseValue(b4);
        return a5.greater(b4) ? a5 : b4;
      }
      function min(a5, b4) {
        a5 = parseValue(a5);
        b4 = parseValue(b4);
        return a5.lesser(b4) ? a5 : b4;
      }
      function gcd(a5, b4) {
        a5 = parseValue(a5).abs();
        b4 = parseValue(b4).abs();
        if (a5.equals(b4))
          return a5;
        if (a5.isZero())
          return b4;
        if (b4.isZero())
          return a5;
        var c4 = Integer[1], d5, t4;
        while (a5.isEven() && b4.isEven()) {
          d5 = min(roughLOB(a5), roughLOB(b4));
          a5 = a5.divide(d5);
          b4 = b4.divide(d5);
          c4 = c4.multiply(d5);
        }
        while (a5.isEven()) {
          a5 = a5.divide(roughLOB(a5));
        }
        do {
          while (b4.isEven()) {
            b4 = b4.divide(roughLOB(b4));
          }
          if (a5.greater(b4)) {
            t4 = b4;
            b4 = a5;
            a5 = t4;
          }
          b4 = b4.subtract(a5);
        } while (!b4.isZero());
        return c4.isUnit() ? a5 : a5.multiply(c4);
      }
      function lcm(a5, b4) {
        a5 = parseValue(a5).abs();
        b4 = parseValue(b4).abs();
        return a5.divide(gcd(a5, b4)).multiply(b4);
      }
      function randBetween(a5, b4, rng) {
        a5 = parseValue(a5);
        b4 = parseValue(b4);
        var usedRNG = rng || Math.random;
        var low = min(a5, b4), high = max(a5, b4);
        var range = high.subtract(low).add(1);
        if (range.isSmall)
          return low.add(Math.floor(usedRNG() * range));
        var digits = toBase(range, BASE).value;
        var result = [], restricted = true;
        for (var i5 = 0; i5 < digits.length; i5++) {
          var top = restricted ? digits[i5] + (i5 + 1 < digits.length ? digits[i5 + 1] / BASE : 0) : BASE;
          var digit = truncate(usedRNG() * top);
          result.push(digit);
          if (digit < digits[i5])
            restricted = false;
        }
        return low.add(Integer.fromArray(result, BASE, false));
      }
      var parseBase = function(text, base2, alphabet, caseSensitive) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        text = String(text);
        if (!caseSensitive) {
          text = text.toLowerCase();
          alphabet = alphabet.toLowerCase();
        }
        var length = text.length;
        var i5;
        var absBase = Math.abs(base2);
        var alphabetValues = {};
        for (i5 = 0; i5 < alphabet.length; i5++) {
          alphabetValues[alphabet[i5]] = i5;
        }
        for (i5 = 0; i5 < length; i5++) {
          var c4 = text[i5];
          if (c4 === "-")
            continue;
          if (c4 in alphabetValues) {
            if (alphabetValues[c4] >= absBase) {
              if (c4 === "1" && absBase === 1)
                continue;
              throw new Error(c4 + " is not a valid digit in base " + base2 + ".");
            }
          }
        }
        base2 = parseValue(base2);
        var digits = [];
        var isNegative = text[0] === "-";
        for (i5 = isNegative ? 1 : 0; i5 < text.length; i5++) {
          var c4 = text[i5];
          if (c4 in alphabetValues)
            digits.push(parseValue(alphabetValues[c4]));
          else if (c4 === "<") {
            var start = i5;
            do {
              i5++;
            } while (text[i5] !== ">" && i5 < text.length);
            digits.push(parseValue(text.slice(start + 1, i5)));
          } else
            throw new Error(c4 + " is not a valid character");
        }
        return parseBaseFromArray(digits, base2, isNegative);
      };
      function parseBaseFromArray(digits, base2, isNegative) {
        var val = Integer[0], pow = Integer[1], i5;
        for (i5 = digits.length - 1; i5 >= 0; i5--) {
          val = val.add(digits[i5].times(pow));
          pow = pow.times(base2);
        }
        return isNegative ? val.negate() : val;
      }
      function stringify(digit, alphabet) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        if (digit < alphabet.length) {
          return alphabet[digit];
        }
        return "<" + digit + ">";
      }
      function toBase(n2, base2) {
        base2 = bigInt(base2);
        if (base2.isZero()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          throw new Error("Cannot convert nonzero numbers to base 0.");
        }
        if (base2.equals(-1)) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          if (n2.isNegative())
            return {
              value: [].concat.apply(
                [],
                Array.apply(null, Array(-n2.toJSNumber())).map(Array.prototype.valueOf, [1, 0])
              ),
              isNegative: false
            };
          var arr = Array.apply(null, Array(n2.toJSNumber() - 1)).map(Array.prototype.valueOf, [0, 1]);
          arr.unshift([1]);
          return {
            value: [].concat.apply([], arr),
            isNegative: false
          };
        }
        var neg = false;
        if (n2.isNegative() && base2.isPositive()) {
          neg = true;
          n2 = n2.abs();
        }
        if (base2.isUnit()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          return {
            value: Array.apply(null, Array(n2.toJSNumber())).map(Number.prototype.valueOf, 1),
            isNegative: neg
          };
        }
        var out = [];
        var left = n2, divmod;
        while (left.isNegative() || left.compareAbs(base2) >= 0) {
          divmod = left.divmod(base2);
          left = divmod.quotient;
          var digit = divmod.remainder;
          if (digit.isNegative()) {
            digit = base2.minus(digit).abs();
            left = left.next();
          }
          out.push(digit.toJSNumber());
        }
        out.push(left.toJSNumber());
        return { value: out.reverse(), isNegative: neg };
      }
      function toBaseString(n2, base2, alphabet) {
        var arr = toBase(n2, base2);
        return (arr.isNegative ? "-" : "") + arr.value.map(function(x6) {
          return stringify(x6, alphabet);
        }).join("");
      }
      BigInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      SmallInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      NativeBigInt.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      BigInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix !== 10)
          return toBaseString(this, radix, alphabet);
        var v3 = this.value, l3 = v3.length, str = String(v3[--l3]), zeros = "0000000", digit;
        while (--l3 >= 0) {
          digit = String(v3[l3]);
          str += zeros.slice(digit.length) + digit;
        }
        var sign = this.sign ? "-" : "";
        return sign + str;
      };
      SmallInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix != 10)
          return toBaseString(this, radix, alphabet);
        return String(this.value);
      };
      NativeBigInt.prototype.toString = SmallInteger.prototype.toString;
      NativeBigInt.prototype.toJSON = BigInteger.prototype.toJSON = SmallInteger.prototype.toJSON = function() {
        return this.toString();
      };
      BigInteger.prototype.valueOf = function() {
        return parseInt(this.toString(), 10);
      };
      BigInteger.prototype.toJSNumber = BigInteger.prototype.valueOf;
      SmallInteger.prototype.valueOf = function() {
        return this.value;
      };
      SmallInteger.prototype.toJSNumber = SmallInteger.prototype.valueOf;
      NativeBigInt.prototype.valueOf = NativeBigInt.prototype.toJSNumber = function() {
        return parseInt(this.toString(), 10);
      };
      function parseStringValue(v3) {
        if (isPrecise(+v3)) {
          var x6 = +v3;
          if (x6 === truncate(x6))
            return supportsNativeBigInt ? new NativeBigInt(BigInt(x6)) : new SmallInteger(x6);
          throw new Error("Invalid integer: " + v3);
        }
        var sign = v3[0] === "-";
        if (sign)
          v3 = v3.slice(1);
        var split = v3.split(/e/i);
        if (split.length > 2)
          throw new Error("Invalid integer: " + split.join("e"));
        if (split.length === 2) {
          var exp = split[1];
          if (exp[0] === "+")
            exp = exp.slice(1);
          exp = +exp;
          if (exp !== truncate(exp) || !isPrecise(exp))
            throw new Error("Invalid integer: " + exp + " is not a valid exponent.");
          var text = split[0];
          var decimalPlace = text.indexOf(".");
          if (decimalPlace >= 0) {
            exp -= text.length - decimalPlace - 1;
            text = text.slice(0, decimalPlace) + text.slice(decimalPlace + 1);
          }
          if (exp < 0)
            throw new Error("Cannot include negative exponent part for integers");
          text += new Array(exp + 1).join("0");
          v3 = text;
        }
        var isValid2 = /^([0-9][0-9]*)$/.test(v3);
        if (!isValid2)
          throw new Error("Invalid integer: " + v3);
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(sign ? "-" + v3 : v3));
        }
        var r3 = [], max2 = v3.length, l3 = LOG_BASE, min2 = max2 - l3;
        while (max2 > 0) {
          r3.push(+v3.slice(min2, max2));
          min2 -= l3;
          if (min2 < 0)
            min2 = 0;
          max2 -= l3;
        }
        trim(r3);
        return new BigInteger(r3, sign);
      }
      function parseNumberValue(v3) {
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(v3));
        }
        if (isPrecise(v3)) {
          if (v3 !== truncate(v3))
            throw new Error(v3 + " is not an integer.");
          return new SmallInteger(v3);
        }
        return parseStringValue(v3.toString());
      }
      function parseValue(v3) {
        if (typeof v3 === "number") {
          return parseNumberValue(v3);
        }
        if (typeof v3 === "string") {
          return parseStringValue(v3);
        }
        if (typeof v3 === "bigint") {
          return new NativeBigInt(v3);
        }
        return v3;
      }
      for (var i4 = 0; i4 < 1e3; i4++) {
        Integer[i4] = parseValue(i4);
        if (i4 > 0)
          Integer[-i4] = parseValue(-i4);
      }
      Integer.one = Integer[1];
      Integer.zero = Integer[0];
      Integer.minusOne = Integer[-1];
      Integer.max = max;
      Integer.min = min;
      Integer.gcd = gcd;
      Integer.lcm = lcm;
      Integer.isInstance = function(x6) {
        return x6 instanceof BigInteger || x6 instanceof SmallInteger || x6 instanceof NativeBigInt;
      };
      Integer.randBetween = randBetween;
      Integer.fromArray = function(digits, base2, isNegative) {
        return parseBaseFromArray(digits.map(parseValue), parseValue(base2 || 10), isNegative);
      };
      return Integer;
    }();
    if (typeof module !== "undefined" && module.hasOwnProperty("exports")) {
      module.exports = bigInt;
    }
    if (typeof define === "function" && define.amd) {
      define(function() {
        return bigInt;
      });
    }
  }
});

// ../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js
var require_jed = __commonJS({
  "../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js"(exports, module) {
    (function(root, undef) {
      var ArrayProto = Array.prototype, ObjProto = Object.prototype, slice = ArrayProto.slice, hasOwnProp = ObjProto.hasOwnProperty, nativeForEach = ArrayProto.forEach, breaker = {};
      var _3 = {
        forEach: function(obj, iterator, context) {
          var i4, l3, key;
          if (obj === null) {
            return;
          }
          if (nativeForEach && obj.forEach === nativeForEach) {
            obj.forEach(iterator, context);
          } else if (obj.length === +obj.length) {
            for (i4 = 0, l3 = obj.length; i4 < l3; i4++) {
              if (i4 in obj && iterator.call(context, obj[i4], i4, obj) === breaker) {
                return;
              }
            }
          } else {
            for (key in obj) {
              if (hasOwnProp.call(obj, key)) {
                if (iterator.call(context, obj[key], key, obj) === breaker) {
                  return;
                }
              }
            }
          }
        },
        extend: function(obj) {
          this.forEach(slice.call(arguments, 1), function(source) {
            for (var prop in source) {
              obj[prop] = source[prop];
            }
          });
          return obj;
        }
      };
      var Jed2 = function(options) {
        this.defaults = {
          "locale_data": {
            "messages": {
              "": {
                "domain": "messages",
                "lang": "en",
                "plural_forms": "nplurals=2; plural=(n != 1);"
              }
              // There are no default keys, though
            }
          },
          // The default domain if one is missing
          "domain": "messages",
          // enable debug mode to log untranslated strings to the console
          "debug": false
        };
        this.options = _3.extend({}, this.defaults, options);
        this.textdomain(this.options.domain);
        if (options.domain && !this.options.locale_data[this.options.domain]) {
          throw new Error("Text domain set to non-existent domain: `" + options.domain + "`");
        }
      };
      Jed2.context_delimiter = String.fromCharCode(4);
      function getPluralFormFunc(plural_form_string) {
        return Jed2.PF.compile(plural_form_string || "nplurals=2; plural=(n != 1);");
      }
      function Chain(key, i18n2) {
        this._key = key;
        this._i18n = i18n2;
      }
      _3.extend(Chain.prototype, {
        onDomain: function(domain) {
          this._domain = domain;
          return this;
        },
        withContext: function(context) {
          this._context = context;
          return this;
        },
        ifPlural: function(num, pkey) {
          this._val = num;
          this._pkey = pkey;
          return this;
        },
        fetch: function(sArr) {
          if ({}.toString.call(sArr) != "[object Array]") {
            sArr = [].slice.call(arguments, 0);
          }
          return (sArr && sArr.length ? Jed2.sprintf : function(x6) {
            return x6;
          })(
            this._i18n.dcnpgettext(this._domain, this._context, this._key, this._pkey, this._val),
            sArr
          );
        }
      });
      _3.extend(Jed2.prototype, {
        // The sexier api start point
        translate: function(key) {
          return new Chain(key, this);
        },
        textdomain: function(domain) {
          if (!domain) {
            return this._textdomain;
          }
          this._textdomain = domain;
        },
        gettext: function(key) {
          return this.dcnpgettext.call(this, undef, undef, key);
        },
        dgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        dcgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        ngettext: function(skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, undef, skey, pkey, val);
        },
        dngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        dcngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        pgettext: function(context, key) {
          return this.dcnpgettext.call(this, undef, context, key);
        },
        dpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        dcpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        npgettext: function(context, skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, context, skey, pkey, val);
        },
        dnpgettext: function(domain, context, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, context, skey, pkey, val);
        },
        // The most fully qualified gettext function. It has every option.
        // Since it has every option, we can use it from every other method.
        // This is the bread and butter.
        // Technically there should be one more argument in this function for 'Category',
        // but since we never use it, we might as well not waste the bytes to define it.
        dcnpgettext: function(domain, context, singular_key, plural_key, val) {
          plural_key = plural_key || singular_key;
          domain = domain || this._textdomain;
          var fallback;
          if (!this.options) {
            fallback = new Jed2();
            return fallback.dcnpgettext.call(fallback, void 0, void 0, singular_key, plural_key, val);
          }
          if (!this.options.locale_data) {
            throw new Error("No locale data provided.");
          }
          if (!this.options.locale_data[domain]) {
            throw new Error("Domain `" + domain + "` was not found.");
          }
          if (!this.options.locale_data[domain][""]) {
            throw new Error("No locale meta information provided.");
          }
          if (!singular_key) {
            throw new Error("No translation key found.");
          }
          var key = context ? context + Jed2.context_delimiter + singular_key : singular_key, locale_data = this.options.locale_data, dict = locale_data[domain], defaultConf = (locale_data.messages || this.defaults.locale_data.messages)[""], pluralForms = dict[""].plural_forms || dict[""]["Plural-Forms"] || dict[""]["plural-forms"] || defaultConf.plural_forms || defaultConf["Plural-Forms"] || defaultConf["plural-forms"], val_list, res;
          var val_idx;
          if (val === void 0) {
            val_idx = 0;
          } else {
            if (typeof val != "number") {
              val = parseInt(val, 10);
              if (isNaN(val)) {
                throw new Error("The number that was passed in is not a number.");
              }
            }
            val_idx = getPluralFormFunc(pluralForms)(val);
          }
          if (!dict) {
            throw new Error("No domain named `" + domain + "` could be found.");
          }
          val_list = dict[key];
          if (!val_list || val_idx > val_list.length) {
            if (this.options.missing_key_callback) {
              this.options.missing_key_callback(key, domain);
            }
            res = [singular_key, plural_key];
            if (this.options.debug === true) {
              console.log(res[getPluralFormFunc(pluralForms)(val)]);
            }
            return res[getPluralFormFunc()(val)];
          }
          res = val_list[val_idx];
          if (!res) {
            res = [singular_key, plural_key];
            return res[getPluralFormFunc()(val)];
          }
          return res;
        }
      });
      var sprintf = function() {
        function get_type(variable) {
          return Object.prototype.toString.call(variable).slice(8, -1).toLowerCase();
        }
        function str_repeat(input, multiplier) {
          for (var output = []; multiplier > 0; output[--multiplier] = input) {
          }
          return output.join("");
        }
        var str_format = function() {
          if (!str_format.cache.hasOwnProperty(arguments[0])) {
            str_format.cache[arguments[0]] = str_format.parse(arguments[0]);
          }
          return str_format.format.call(null, str_format.cache[arguments[0]], arguments);
        };
        str_format.format = function(parse_tree, argv) {
          var cursor = 1, tree_length = parse_tree.length, node_type = "", arg, output = [], i4, k5, match3, pad, pad_character, pad_length;
          for (i4 = 0; i4 < tree_length; i4++) {
            node_type = get_type(parse_tree[i4]);
            if (node_type === "string") {
              output.push(parse_tree[i4]);
            } else if (node_type === "array") {
              match3 = parse_tree[i4];
              if (match3[2]) {
                arg = argv[cursor];
                for (k5 = 0; k5 < match3[2].length; k5++) {
                  if (!arg.hasOwnProperty(match3[2][k5])) {
                    throw sprintf('[sprintf] property "%s" does not exist', match3[2][k5]);
                  }
                  arg = arg[match3[2][k5]];
                }
              } else if (match3[1]) {
                arg = argv[match3[1]];
              } else {
                arg = argv[cursor++];
              }
              if (/[^s]/.test(match3[8]) && get_type(arg) != "number") {
                throw sprintf("[sprintf] expecting number but found %s", get_type(arg));
              }
              if (typeof arg == "undefined" || arg === null) {
                arg = "";
              }
              switch (match3[8]) {
                case "b":
                  arg = arg.toString(2);
                  break;
                case "c":
                  arg = String.fromCharCode(arg);
                  break;
                case "d":
                  arg = parseInt(arg, 10);
                  break;
                case "e":
                  arg = match3[7] ? arg.toExponential(match3[7]) : arg.toExponential();
                  break;
                case "f":
                  arg = match3[7] ? parseFloat(arg).toFixed(match3[7]) : parseFloat(arg);
                  break;
                case "o":
                  arg = arg.toString(8);
                  break;
                case "s":
                  arg = (arg = String(arg)) && match3[7] ? arg.substring(0, match3[7]) : arg;
                  break;
                case "u":
                  arg = Math.abs(arg);
                  break;
                case "x":
                  arg = arg.toString(16);
                  break;
                case "X":
                  arg = arg.toString(16).toUpperCase();
                  break;
              }
              arg = /[def]/.test(match3[8]) && match3[3] && arg >= 0 ? "+" + arg : arg;
              pad_character = match3[4] ? match3[4] == "0" ? "0" : match3[4].charAt(1) : " ";
              pad_length = match3[6] - String(arg).length;
              pad = match3[6] ? str_repeat(pad_character, pad_length) : "";
              output.push(match3[5] ? arg + pad : pad + arg);
            }
          }
          return output.join("");
        };
        str_format.cache = {};
        str_format.parse = function(fmt) {
          var _fmt = fmt, match3 = [], parse_tree = [], arg_names = 0;
          while (_fmt) {
            if ((match3 = /^[^\x25]+/.exec(_fmt)) !== null) {
              parse_tree.push(match3[0]);
            } else if ((match3 = /^\x25{2}/.exec(_fmt)) !== null) {
              parse_tree.push("%");
            } else if ((match3 = /^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(_fmt)) !== null) {
              if (match3[2]) {
                arg_names |= 1;
                var field_list = [], replacement_field = match3[2], field_match = [];
                if ((field_match = /^([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                  field_list.push(field_match[1]);
                  while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                    if ((field_match = /^\.([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else if ((field_match = /^\[(\d+)\]/.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else {
                      throw "[sprintf] huh?";
                    }
                  }
                } else {
                  throw "[sprintf] huh?";
                }
                match3[2] = field_list;
              } else {
                arg_names |= 2;
              }
              if (arg_names === 3) {
                throw "[sprintf] mixing positional and named placeholders is not (yet) supported";
              }
              parse_tree.push(match3);
            } else {
              throw "[sprintf] huh?";
            }
            _fmt = _fmt.substring(match3[0].length);
          }
          return parse_tree;
        };
        return str_format;
      }();
      var vsprintf = function(fmt, argv) {
        argv.unshift(fmt);
        return sprintf.apply(null, argv);
      };
      Jed2.parse_plural = function(plural_forms, n2) {
        plural_forms = plural_forms.replace(/n/g, n2);
        return Jed2.parse_expression(plural_forms);
      };
      Jed2.sprintf = function(fmt, args) {
        if ({}.toString.call(args) == "[object Array]") {
          return vsprintf(fmt, [].slice.call(args));
        }
        return sprintf.apply(this, [].slice.call(arguments));
      };
      Jed2.prototype.sprintf = function() {
        return Jed2.sprintf.apply(this, arguments);
      };
      Jed2.PF = {};
      Jed2.PF.parse = function(p4) {
        var plural_str = Jed2.PF.extractPluralExpr(p4);
        return Jed2.PF.parser.parse.call(Jed2.PF.parser, plural_str);
      };
      Jed2.PF.compile = function(p4) {
        function imply(val) {
          return val === true ? 1 : val ? val : 0;
        }
        var ast = Jed2.PF.parse(p4);
        return function(n2) {
          return imply(Jed2.PF.interpreter(ast)(n2));
        };
      };
      Jed2.PF.interpreter = function(ast) {
        return function(n2) {
          var res;
          switch (ast.type) {
            case "GROUP":
              return Jed2.PF.interpreter(ast.expr)(n2);
            case "TERNARY":
              if (Jed2.PF.interpreter(ast.expr)(n2)) {
                return Jed2.PF.interpreter(ast.truthy)(n2);
              }
              return Jed2.PF.interpreter(ast.falsey)(n2);
            case "OR":
              return Jed2.PF.interpreter(ast.left)(n2) || Jed2.PF.interpreter(ast.right)(n2);
            case "AND":
              return Jed2.PF.interpreter(ast.left)(n2) && Jed2.PF.interpreter(ast.right)(n2);
            case "LT":
              return Jed2.PF.interpreter(ast.left)(n2) < Jed2.PF.interpreter(ast.right)(n2);
            case "GT":
              return Jed2.PF.interpreter(ast.left)(n2) > Jed2.PF.interpreter(ast.right)(n2);
            case "LTE":
              return Jed2.PF.interpreter(ast.left)(n2) <= Jed2.PF.interpreter(ast.right)(n2);
            case "GTE":
              return Jed2.PF.interpreter(ast.left)(n2) >= Jed2.PF.interpreter(ast.right)(n2);
            case "EQ":
              return Jed2.PF.interpreter(ast.left)(n2) == Jed2.PF.interpreter(ast.right)(n2);
            case "NEQ":
              return Jed2.PF.interpreter(ast.left)(n2) != Jed2.PF.interpreter(ast.right)(n2);
            case "MOD":
              return Jed2.PF.interpreter(ast.left)(n2) % Jed2.PF.interpreter(ast.right)(n2);
            case "VAR":
              return n2;
            case "NUM":
              return ast.val;
            default:
              throw new Error("Invalid Token found.");
          }
        };
      };
      Jed2.PF.extractPluralExpr = function(p4) {
        p4 = p4.replace(/^\s\s*/, "").replace(/\s\s*$/, "");
        if (!/;\s*$/.test(p4)) {
          p4 = p4.concat(";");
        }
        var nplurals_re = /nplurals\=(\d+);/, plural_re = /plural\=(.*);/, nplurals_matches = p4.match(nplurals_re), res = {}, plural_matches;
        if (nplurals_matches.length > 1) {
          res.nplurals = nplurals_matches[1];
        } else {
          throw new Error("nplurals not found in plural_forms string: " + p4);
        }
        p4 = p4.replace(nplurals_re, "");
        plural_matches = p4.match(plural_re);
        if (!(plural_matches && plural_matches.length > 1)) {
          throw new Error("`plural` expression not found: " + p4);
        }
        return plural_matches[1];
      };
      Jed2.PF.parser = function() {
        var parser = {
          trace: function trace() {
          },
          yy: {},
          symbols_: { "error": 2, "expressions": 3, "e": 4, "EOF": 5, "?": 6, ":": 7, "||": 8, "&&": 9, "<": 10, "<=": 11, ">": 12, ">=": 13, "!=": 14, "==": 15, "%": 16, "(": 17, ")": 18, "n": 19, "NUMBER": 20, "$accept": 0, "$end": 1 },
          terminals_: { 2: "error", 5: "EOF", 6: "?", 7: ":", 8: "||", 9: "&&", 10: "<", 11: "<=", 12: ">", 13: ">=", 14: "!=", 15: "==", 16: "%", 17: "(", 18: ")", 19: "n", 20: "NUMBER" },
          productions_: [0, [3, 2], [4, 5], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 1], [4, 1]],
          performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
            var $0 = $$.length - 1;
            switch (yystate) {
              case 1:
                return { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 2:
                this.$ = { type: "TERNARY", expr: $$[$0 - 4], truthy: $$[$0 - 2], falsey: $$[$0] };
                break;
              case 3:
                this.$ = { type: "OR", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 4:
                this.$ = { type: "AND", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 5:
                this.$ = { type: "LT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 6:
                this.$ = { type: "LTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 7:
                this.$ = { type: "GT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 8:
                this.$ = { type: "GTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 9:
                this.$ = { type: "NEQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 10:
                this.$ = { type: "EQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 11:
                this.$ = { type: "MOD", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 12:
                this.$ = { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 13:
                this.$ = { type: "VAR" };
                break;
              case 14:
                this.$ = { type: "NUM", val: Number(yytext) };
                break;
            }
          },
          table: [{ 3: 1, 4: 2, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 1: [3] }, { 5: [1, 6], 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 4: 17, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 13], 6: [2, 13], 7: [2, 13], 8: [2, 13], 9: [2, 13], 10: [2, 13], 11: [2, 13], 12: [2, 13], 13: [2, 13], 14: [2, 13], 15: [2, 13], 16: [2, 13], 18: [2, 13] }, { 5: [2, 14], 6: [2, 14], 7: [2, 14], 8: [2, 14], 9: [2, 14], 10: [2, 14], 11: [2, 14], 12: [2, 14], 13: [2, 14], 14: [2, 14], 15: [2, 14], 16: [2, 14], 18: [2, 14] }, { 1: [2, 1] }, { 4: 18, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 19, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 20, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 21, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 22, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 23, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 24, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 25, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 26, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 27, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [1, 28] }, { 6: [1, 7], 7: [1, 29], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 5: [2, 3], 6: [2, 3], 7: [2, 3], 8: [2, 3], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 3] }, { 5: [2, 4], 6: [2, 4], 7: [2, 4], 8: [2, 4], 9: [2, 4], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 4] }, { 5: [2, 5], 6: [2, 5], 7: [2, 5], 8: [2, 5], 9: [2, 5], 10: [2, 5], 11: [2, 5], 12: [2, 5], 13: [2, 5], 14: [2, 5], 15: [2, 5], 16: [1, 16], 18: [2, 5] }, { 5: [2, 6], 6: [2, 6], 7: [2, 6], 8: [2, 6], 9: [2, 6], 10: [2, 6], 11: [2, 6], 12: [2, 6], 13: [2, 6], 14: [2, 6], 15: [2, 6], 16: [1, 16], 18: [2, 6] }, { 5: [2, 7], 6: [2, 7], 7: [2, 7], 8: [2, 7], 9: [2, 7], 10: [2, 7], 11: [2, 7], 12: [2, 7], 13: [2, 7], 14: [2, 7], 15: [2, 7], 16: [1, 16], 18: [2, 7] }, { 5: [2, 8], 6: [2, 8], 7: [2, 8], 8: [2, 8], 9: [2, 8], 10: [2, 8], 11: [2, 8], 12: [2, 8], 13: [2, 8], 14: [2, 8], 15: [2, 8], 16: [1, 16], 18: [2, 8] }, { 5: [2, 9], 6: [2, 9], 7: [2, 9], 8: [2, 9], 9: [2, 9], 10: [2, 9], 11: [2, 9], 12: [2, 9], 13: [2, 9], 14: [2, 9], 15: [2, 9], 16: [1, 16], 18: [2, 9] }, { 5: [2, 10], 6: [2, 10], 7: [2, 10], 8: [2, 10], 9: [2, 10], 10: [2, 10], 11: [2, 10], 12: [2, 10], 13: [2, 10], 14: [2, 10], 15: [2, 10], 16: [1, 16], 18: [2, 10] }, { 5: [2, 11], 6: [2, 11], 7: [2, 11], 8: [2, 11], 9: [2, 11], 10: [2, 11], 11: [2, 11], 12: [2, 11], 13: [2, 11], 14: [2, 11], 15: [2, 11], 16: [2, 11], 18: [2, 11] }, { 5: [2, 12], 6: [2, 12], 7: [2, 12], 8: [2, 12], 9: [2, 12], 10: [2, 12], 11: [2, 12], 12: [2, 12], 13: [2, 12], 14: [2, 12], 15: [2, 12], 16: [2, 12], 18: [2, 12] }, { 4: 30, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 2], 6: [1, 7], 7: [2, 2], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 2] }],
          defaultActions: { 6: [2, 1] },
          parseError: function parseError(str, hash4) {
            throw new Error(str);
          },
          parse: function parse(input) {
            var self2 = this, stack = [0], vstack = [null], lstack = [], table2 = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
            this.lexer.setInput(input);
            this.lexer.yy = this.yy;
            this.yy.lexer = this.lexer;
            if (typeof this.lexer.yylloc == "undefined")
              this.lexer.yylloc = {};
            var yyloc = this.lexer.yylloc;
            lstack.push(yyloc);
            if (typeof this.yy.parseError === "function")
              this.parseError = this.yy.parseError;
            function popStack(n2) {
              stack.length = stack.length - 2 * n2;
              vstack.length = vstack.length - n2;
              lstack.length = lstack.length - n2;
            }
            function lex() {
              var token;
              token = self2.lexer.lex() || 1;
              if (typeof token !== "number") {
                token = self2.symbols_[token] || token;
              }
              return token;
            }
            var symbol, preErrorSymbol, state, action, a5, r3, yyval = {}, p4, len, newState, expected;
            while (true) {
              state = stack[stack.length - 1];
              if (this.defaultActions[state]) {
                action = this.defaultActions[state];
              } else {
                if (symbol == null)
                  symbol = lex();
                action = table2[state] && table2[state][symbol];
              }
              _handle_error:
                if (typeof action === "undefined" || !action.length || !action[0]) {
                  if (!recovering) {
                    expected = [];
                    for (p4 in table2[state])
                      if (this.terminals_[p4] && p4 > 2) {
                        expected.push("'" + this.terminals_[p4] + "'");
                      }
                    var errStr = "";
                    if (this.lexer.showPosition) {
                      errStr = "Parse error on line " + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + this.terminals_[symbol] + "'";
                    } else {
                      errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == 1 ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
                    }
                    this.parseError(
                      errStr,
                      { text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected }
                    );
                  }
                  if (recovering == 3) {
                    if (symbol == EOF) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    symbol = lex();
                  }
                  while (1) {
                    if (TERROR.toString() in table2[state]) {
                      break;
                    }
                    if (state == 0) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    popStack(1);
                    state = stack[stack.length - 1];
                  }
                  preErrorSymbol = symbol;
                  symbol = TERROR;
                  state = stack[stack.length - 1];
                  action = table2[state] && table2[state][TERROR];
                  recovering = 3;
                }
              if (action[0] instanceof Array && action.length > 1) {
                throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
              }
              switch (action[0]) {
                case 1:
                  stack.push(symbol);
                  vstack.push(this.lexer.yytext);
                  lstack.push(this.lexer.yylloc);
                  stack.push(action[1]);
                  symbol = null;
                  if (!preErrorSymbol) {
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                      recovering--;
                  } else {
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                  }
                  break;
                case 2:
                  len = this.productions_[action[1]][1];
                  yyval.$ = vstack[vstack.length - len];
                  yyval._$ = {
                    first_line: lstack[lstack.length - (len || 1)].first_line,
                    last_line: lstack[lstack.length - 1].last_line,
                    first_column: lstack[lstack.length - (len || 1)].first_column,
                    last_column: lstack[lstack.length - 1].last_column
                  };
                  r3 = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);
                  if (typeof r3 !== "undefined") {
                    return r3;
                  }
                  if (len) {
                    stack = stack.slice(0, -1 * len * 2);
                    vstack = vstack.slice(0, -1 * len);
                    lstack = lstack.slice(0, -1 * len);
                  }
                  stack.push(this.productions_[action[1]][0]);
                  vstack.push(yyval.$);
                  lstack.push(yyval._$);
                  newState = table2[stack[stack.length - 2]][stack[stack.length - 1]];
                  stack.push(newState);
                  break;
                case 3:
                  return true;
              }
            }
            return true;
          }
        };
        var lexer = function() {
          var lexer2 = {
            EOF: 1,
            parseError: function parseError(str, hash4) {
              if (this.yy.parseError) {
                this.yy.parseError(str, hash4);
              } else {
                throw new Error(str);
              }
            },
            setInput: function(input) {
              this._input = input;
              this._more = this._less = this.done = false;
              this.yylineno = this.yyleng = 0;
              this.yytext = this.matched = this.match = "";
              this.conditionStack = ["INITIAL"];
              this.yylloc = { first_line: 1, first_column: 0, last_line: 1, last_column: 0 };
              return this;
            },
            input: function() {
              var ch = this._input[0];
              this.yytext += ch;
              this.yyleng++;
              this.match += ch;
              this.matched += ch;
              var lines = ch.match(/\n/);
              if (lines)
                this.yylineno++;
              this._input = this._input.slice(1);
              return ch;
            },
            unput: function(ch) {
              this._input = ch + this._input;
              return this;
            },
            more: function() {
              this._more = true;
              return this;
            },
            pastInput: function() {
              var past = this.matched.substr(0, this.matched.length - this.match.length);
              return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
            },
            upcomingInput: function() {
              var next = this.match;
              if (next.length < 20) {
                next += this._input.substr(0, 20 - next.length);
              }
              return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
            },
            showPosition: function() {
              var pre = this.pastInput();
              var c4 = new Array(pre.length + 1).join("-");
              return pre + this.upcomingInput() + "\n" + c4 + "^";
            },
            next: function() {
              if (this.done) {
                return this.EOF;
              }
              if (!this._input)
                this.done = true;
              var token, match3, col, lines;
              if (!this._more) {
                this.yytext = "";
                this.match = "";
              }
              var rules = this._currentRules();
              for (var i4 = 0; i4 < rules.length; i4++) {
                match3 = this._input.match(this.rules[rules[i4]]);
                if (match3) {
                  lines = match3[0].match(/\n.*/g);
                  if (lines)
                    this.yylineno += lines.length;
                  this.yylloc = {
                    first_line: this.yylloc.last_line,
                    last_line: this.yylineno + 1,
                    first_column: this.yylloc.last_column,
                    last_column: lines ? lines[lines.length - 1].length - 1 : this.yylloc.last_column + match3[0].length
                  };
                  this.yytext += match3[0];
                  this.match += match3[0];
                  this.matches = match3;
                  this.yyleng = this.yytext.length;
                  this._more = false;
                  this._input = this._input.slice(match3[0].length);
                  this.matched += match3[0];
                  token = this.performAction.call(this, this.yy, this, rules[i4], this.conditionStack[this.conditionStack.length - 1]);
                  if (token)
                    return token;
                  else
                    return;
                }
              }
              if (this._input === "") {
                return this.EOF;
              } else {
                this.parseError(
                  "Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(),
                  { text: "", token: null, line: this.yylineno }
                );
              }
            },
            lex: function lex() {
              var r3 = this.next();
              if (typeof r3 !== "undefined") {
                return r3;
              } else {
                return this.lex();
              }
            },
            begin: function begin(condition) {
              this.conditionStack.push(condition);
            },
            popState: function popState() {
              return this.conditionStack.pop();
            },
            _currentRules: function _currentRules() {
              return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
            },
            topState: function() {
              return this.conditionStack[this.conditionStack.length - 2];
            },
            pushState: function begin(condition) {
              this.begin(condition);
            }
          };
          lexer2.performAction = function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
            var YYSTATE = YY_START;
            switch ($avoiding_name_collisions) {
              case 0:
                break;
              case 1:
                return 20;
                break;
              case 2:
                return 19;
                break;
              case 3:
                return 8;
                break;
              case 4:
                return 9;
                break;
              case 5:
                return 6;
                break;
              case 6:
                return 7;
                break;
              case 7:
                return 11;
                break;
              case 8:
                return 13;
                break;
              case 9:
                return 10;
                break;
              case 10:
                return 12;
                break;
              case 11:
                return 14;
                break;
              case 12:
                return 15;
                break;
              case 13:
                return 16;
                break;
              case 14:
                return 17;
                break;
              case 15:
                return 18;
                break;
              case 16:
                return 5;
                break;
              case 17:
                return "INVALID";
                break;
            }
          };
          lexer2.rules = [/^\s+/, /^[0-9]+(\.[0-9]+)?\b/, /^n\b/, /^\|\|/, /^&&/, /^\?/, /^:/, /^<=/, /^>=/, /^</, /^>/, /^!=/, /^==/, /^%/, /^\(/, /^\)/, /^$/, /^./];
          lexer2.conditions = { "INITIAL": { "rules": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], "inclusive": true } };
          return lexer2;
        }();
        parser.lexer = lexer;
        return parser;
      }();
      if (typeof exports !== "undefined") {
        if (typeof module !== "undefined" && module.exports) {
          exports = module.exports = Jed2;
        }
        exports.Jed = Jed2;
      } else {
        if (typeof define === "function" && define.amd) {
          define(function() {
            return Jed2;
          });
        }
        root["Jed"] = Jed2;
      }
    })(exports);
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js
function s(n2, l3) {
  for (var u4 in l3)
    n2[u4] = l3[u4];
  return n2;
}
function a(n2) {
  var l3 = n2.parentNode;
  l3 && l3.removeChild(n2);
}
function h(l3, u4, i4) {
  var t4, o3, r3, f3 = {};
  for (r3 in u4)
    "key" == r3 ? t4 = u4[r3] : "ref" == r3 ? o3 = u4[r3] : f3[r3] = u4[r3];
  if (arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i4), "function" == typeof l3 && null != l3.defaultProps)
    for (r3 in l3.defaultProps)
      void 0 === f3[r3] && (f3[r3] = l3.defaultProps[r3]);
  return v(l3, f3, t4, o3, null);
}
function v(n2, i4, t4, o3, r3) {
  var f3 = { type: n2, props: i4, key: t4, ref: o3, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, __h: null, constructor: void 0, __v: null == r3 ? ++u : r3 };
  return null == r3 && null != l.vnode && l.vnode(f3), f3;
}
function y() {
  return { current: null };
}
function p2(n2) {
  return n2.children;
}
function d(n2, l3) {
  this.props = n2, this.context = l3;
}
function _(n2, l3) {
  if (null == l3)
    return n2.__ ? _(n2.__, n2.__.__k.indexOf(n2) + 1) : null;
  for (var u4; l3 < n2.__k.length; l3++)
    if (null != (u4 = n2.__k[l3]) && null != u4.__e)
      return u4.__e;
  return "function" == typeof n2.type ? _(n2) : null;
}
function k(n2) {
  var l3, u4;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l3 = 0; l3 < n2.__k.length; l3++)
      if (null != (u4 = n2.__k[l3]) && null != u4.__e) {
        n2.__e = n2.__c.base = u4.__e;
        break;
      }
    return k(n2);
  }
}
function b(n2) {
  (!n2.__d && (n2.__d = true) && t.push(n2) && !g.__r++ || o !== l.debounceRendering) && ((o = l.debounceRendering) || setTimeout)(g);
}
function g() {
  for (var n2; g.__r = t.length; )
    n2 = t.sort(function(n3, l3) {
      return n3.__v.__b - l3.__v.__b;
    }), t = [], n2.some(function(n3) {
      var l3, u4, i4, t4, o3, r3;
      n3.__d && (o3 = (t4 = (l3 = n3).__v).__e, (r3 = l3.__P) && (u4 = [], (i4 = s({}, t4)).__v = t4.__v + 1, j(r3, t4, i4, l3.__n, void 0 !== r3.ownerSVGElement, null != t4.__h ? [o3] : null, u4, null == o3 ? _(t4) : o3, t4.__h), z(u4, t4), t4.__e != o3 && k(t4)));
    });
}
function w(n2, l3, u4, i4, t4, o3, r3, c4, s5, a5) {
  var h5, y5, d5, k5, b4, g4, w5, x6 = i4 && i4.__k || e, C3 = x6.length;
  for (u4.__k = [], h5 = 0; h5 < l3.length; h5++)
    if (null != (k5 = u4.__k[h5] = null == (k5 = l3[h5]) || "boolean" == typeof k5 ? null : "string" == typeof k5 || "number" == typeof k5 || "bigint" == typeof k5 ? v(null, k5, null, null, k5) : Array.isArray(k5) ? v(p2, { children: k5 }, null, null, null) : k5.__b > 0 ? v(k5.type, k5.props, k5.key, k5.ref ? k5.ref : null, k5.__v) : k5)) {
      if (k5.__ = u4, k5.__b = u4.__b + 1, null === (d5 = x6[h5]) || d5 && k5.key == d5.key && k5.type === d5.type)
        x6[h5] = void 0;
      else
        for (y5 = 0; y5 < C3; y5++) {
          if ((d5 = x6[y5]) && k5.key == d5.key && k5.type === d5.type) {
            x6[y5] = void 0;
            break;
          }
          d5 = null;
        }
      j(n2, k5, d5 = d5 || f, t4, o3, r3, c4, s5, a5), b4 = k5.__e, (y5 = k5.ref) && d5.ref != y5 && (w5 || (w5 = []), d5.ref && w5.push(d5.ref, null, k5), w5.push(y5, k5.__c || b4, k5)), null != b4 ? (null == g4 && (g4 = b4), "function" == typeof k5.type && k5.__k === d5.__k ? k5.__d = s5 = m(k5, s5, n2) : s5 = A2(n2, k5, d5, x6, b4, s5), "function" == typeof u4.type && (u4.__d = s5)) : s5 && d5.__e == s5 && s5.parentNode != n2 && (s5 = _(d5));
    }
  for (u4.__e = g4, h5 = C3; h5--; )
    null != x6[h5] && N(x6[h5], x6[h5]);
  if (w5)
    for (h5 = 0; h5 < w5.length; h5++)
      M2(w5[h5], w5[++h5], w5[++h5]);
}
function m(n2, l3, u4) {
  for (var i4, t4 = n2.__k, o3 = 0; t4 && o3 < t4.length; o3++)
    (i4 = t4[o3]) && (i4.__ = n2, l3 = "function" == typeof i4.type ? m(i4, l3, u4) : A2(u4, i4, i4, t4, i4.__e, l3));
  return l3;
}
function x2(n2, l3) {
  return l3 = l3 || [], null == n2 || "boolean" == typeof n2 || (Array.isArray(n2) ? n2.some(function(n3) {
    x2(n3, l3);
  }) : l3.push(n2)), l3;
}
function A2(n2, l3, u4, i4, t4, o3) {
  var r3, f3, e4;
  if (void 0 !== l3.__d)
    r3 = l3.__d, l3.__d = void 0;
  else if (null == u4 || t4 != o3 || null == t4.parentNode)
    n:
      if (null == o3 || o3.parentNode !== n2)
        n2.appendChild(t4), r3 = null;
      else {
        for (f3 = o3, e4 = 0; (f3 = f3.nextSibling) && e4 < i4.length; e4 += 1)
          if (f3 == t4)
            break n;
        n2.insertBefore(t4, o3), r3 = o3;
      }
  return void 0 !== r3 ? r3 : t4.nextSibling;
}
function C(n2, l3, u4, i4, t4) {
  var o3;
  for (o3 in u4)
    "children" === o3 || "key" === o3 || o3 in l3 || H(n2, o3, null, u4[o3], i4);
  for (o3 in l3)
    t4 && "function" != typeof l3[o3] || "children" === o3 || "key" === o3 || "value" === o3 || "checked" === o3 || u4[o3] === l3[o3] || H(n2, o3, l3[o3], u4[o3], i4);
}
function $(n2, l3, u4) {
  "-" === l3[0] ? n2.setProperty(l3, u4) : n2[l3] = null == u4 ? "" : "number" != typeof u4 || c.test(l3) ? u4 : u4 + "px";
}
function H(n2, l3, u4, i4, t4) {
  var o3;
  n:
    if ("style" === l3)
      if ("string" == typeof u4)
        n2.style.cssText = u4;
      else {
        if ("string" == typeof i4 && (n2.style.cssText = i4 = ""), i4)
          for (l3 in i4)
            u4 && l3 in u4 || $(n2.style, l3, "");
        if (u4)
          for (l3 in u4)
            i4 && u4[l3] === i4[l3] || $(n2.style, l3, u4[l3]);
      }
    else if ("o" === l3[0] && "n" === l3[1])
      o3 = l3 !== (l3 = l3.replace(/Capture$/, "")), l3 = l3.toLowerCase() in n2 ? l3.toLowerCase().slice(2) : l3.slice(2), n2.l || (n2.l = {}), n2.l[l3 + o3] = u4, u4 ? i4 || n2.addEventListener(l3, o3 ? T : I2, o3) : n2.removeEventListener(l3, o3 ? T : I2, o3);
    else if ("dangerouslySetInnerHTML" !== l3) {
      if (t4)
        l3 = l3.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
      else if ("href" !== l3 && "list" !== l3 && "form" !== l3 && "tabIndex" !== l3 && "download" !== l3 && l3 in n2)
        try {
          n2[l3] = null == u4 ? "" : u4;
          break n;
        } catch (n3) {
        }
      "function" == typeof u4 || (null == u4 || false === u4 && -1 == l3.indexOf("-") ? n2.removeAttribute(l3) : n2.setAttribute(l3, u4));
    }
}
function I2(n2) {
  this.l[n2.type + false](l.event ? l.event(n2) : n2);
}
function T(n2) {
  this.l[n2.type + true](l.event ? l.event(n2) : n2);
}
function j(n2, u4, i4, t4, o3, r3, f3, e4, c4) {
  var a5, h5, v3, y5, _3, k5, b4, g4, m5, x6, A5, C3, $3, H5, I5, T5 = u4.type;
  if (void 0 !== u4.constructor)
    return null;
  null != i4.__h && (c4 = i4.__h, e4 = u4.__e = i4.__e, u4.__h = null, r3 = [e4]), (a5 = l.__b) && a5(u4);
  try {
    n:
      if ("function" == typeof T5) {
        if (g4 = u4.props, m5 = (a5 = T5.contextType) && t4[a5.__c], x6 = a5 ? m5 ? m5.props.value : a5.__ : t4, i4.__c ? b4 = (h5 = u4.__c = i4.__c).__ = h5.__E : ("prototype" in T5 && T5.prototype.render ? u4.__c = h5 = new T5(g4, x6) : (u4.__c = h5 = new d(g4, x6), h5.constructor = T5, h5.render = O), m5 && m5.sub(h5), h5.props = g4, h5.state || (h5.state = {}), h5.context = x6, h5.__n = t4, v3 = h5.__d = true, h5.__h = [], h5._sb = []), null == h5.__s && (h5.__s = h5.state), null != T5.getDerivedStateFromProps && (h5.__s == h5.state && (h5.__s = s({}, h5.__s)), s(h5.__s, T5.getDerivedStateFromProps(g4, h5.__s))), y5 = h5.props, _3 = h5.state, v3)
          null == T5.getDerivedStateFromProps && null != h5.componentWillMount && h5.componentWillMount(), null != h5.componentDidMount && h5.__h.push(h5.componentDidMount);
        else {
          if (null == T5.getDerivedStateFromProps && g4 !== y5 && null != h5.componentWillReceiveProps && h5.componentWillReceiveProps(g4, x6), !h5.__e && null != h5.shouldComponentUpdate && false === h5.shouldComponentUpdate(g4, h5.__s, x6) || u4.__v === i4.__v) {
            for (h5.props = g4, h5.state = h5.__s, u4.__v !== i4.__v && (h5.__d = false), h5.__v = u4, u4.__e = i4.__e, u4.__k = i4.__k, u4.__k.forEach(function(n3) {
              n3 && (n3.__ = u4);
            }), A5 = 0; A5 < h5._sb.length; A5++)
              h5.__h.push(h5._sb[A5]);
            h5._sb = [], h5.__h.length && f3.push(h5);
            break n;
          }
          null != h5.componentWillUpdate && h5.componentWillUpdate(g4, h5.__s, x6), null != h5.componentDidUpdate && h5.__h.push(function() {
            h5.componentDidUpdate(y5, _3, k5);
          });
        }
        if (h5.context = x6, h5.props = g4, h5.__v = u4, h5.__P = n2, C3 = l.__r, $3 = 0, "prototype" in T5 && T5.prototype.render) {
          for (h5.state = h5.__s, h5.__d = false, C3 && C3(u4), a5 = h5.render(h5.props, h5.state, h5.context), H5 = 0; H5 < h5._sb.length; H5++)
            h5.__h.push(h5._sb[H5]);
          h5._sb = [];
        } else
          do {
            h5.__d = false, C3 && C3(u4), a5 = h5.render(h5.props, h5.state, h5.context), h5.state = h5.__s;
          } while (h5.__d && ++$3 < 25);
        h5.state = h5.__s, null != h5.getChildContext && (t4 = s(s({}, t4), h5.getChildContext())), v3 || null == h5.getSnapshotBeforeUpdate || (k5 = h5.getSnapshotBeforeUpdate(y5, _3)), I5 = null != a5 && a5.type === p2 && null == a5.key ? a5.props.children : a5, w(n2, Array.isArray(I5) ? I5 : [I5], u4, i4, t4, o3, r3, f3, e4, c4), h5.base = u4.__e, u4.__h = null, h5.__h.length && f3.push(h5), b4 && (h5.__E = h5.__ = null), h5.__e = false;
      } else
        null == r3 && u4.__v === i4.__v ? (u4.__k = i4.__k, u4.__e = i4.__e) : u4.__e = L2(i4.__e, u4, i4, t4, o3, r3, f3, c4);
    (a5 = l.diffed) && a5(u4);
  } catch (n3) {
    u4.__v = null, (c4 || null != r3) && (u4.__e = e4, u4.__h = !!c4, r3[r3.indexOf(e4)] = null), l.__e(n3, u4, i4);
  }
}
function z(n2, u4) {
  l.__c && l.__c(u4, n2), n2.some(function(u5) {
    try {
      n2 = u5.__h, u5.__h = [], n2.some(function(n3) {
        n3.call(u5);
      });
    } catch (n3) {
      l.__e(n3, u5.__v);
    }
  });
}
function L2(l3, u4, i4, t4, o3, r3, e4, c4) {
  var s5, h5, v3, y5 = i4.props, p4 = u4.props, d5 = u4.type, k5 = 0;
  if ("svg" === d5 && (o3 = true), null != r3) {
    for (; k5 < r3.length; k5++)
      if ((s5 = r3[k5]) && "setAttribute" in s5 == !!d5 && (d5 ? s5.localName === d5 : 3 === s5.nodeType)) {
        l3 = s5, r3[k5] = null;
        break;
      }
  }
  if (null == l3) {
    if (null === d5)
      return document.createTextNode(p4);
    l3 = o3 ? document.createElementNS("http://www.w3.org/2000/svg", d5) : document.createElement(d5, p4.is && p4), r3 = null, c4 = false;
  }
  if (null === d5)
    y5 === p4 || c4 && l3.data === p4 || (l3.data = p4);
  else {
    if (r3 = r3 && n.call(l3.childNodes), h5 = (y5 = i4.props || f).dangerouslySetInnerHTML, v3 = p4.dangerouslySetInnerHTML, !c4) {
      if (null != r3)
        for (y5 = {}, k5 = 0; k5 < l3.attributes.length; k5++)
          y5[l3.attributes[k5].name] = l3.attributes[k5].value;
      (v3 || h5) && (v3 && (h5 && v3.__html == h5.__html || v3.__html === l3.innerHTML) || (l3.innerHTML = v3 && v3.__html || ""));
    }
    if (C(l3, p4, y5, o3, c4), v3)
      u4.__k = [];
    else if (k5 = u4.props.children, w(l3, Array.isArray(k5) ? k5 : [k5], u4, i4, t4, o3 && "foreignObject" !== d5, r3, e4, r3 ? r3[0] : i4.__k && _(i4, 0), c4), null != r3)
      for (k5 = r3.length; k5--; )
        null != r3[k5] && a(r3[k5]);
    c4 || ("value" in p4 && void 0 !== (k5 = p4.value) && (k5 !== l3.value || "progress" === d5 && !k5 || "option" === d5 && k5 !== y5.value) && H(l3, "value", k5, y5.value, false), "checked" in p4 && void 0 !== (k5 = p4.checked) && k5 !== l3.checked && H(l3, "checked", k5, y5.checked, false));
  }
  return l3;
}
function M2(n2, u4, i4) {
  try {
    "function" == typeof n2 ? n2(u4) : n2.current = u4;
  } catch (n3) {
    l.__e(n3, i4);
  }
}
function N(n2, u4, i4) {
  var t4, o3;
  if (l.unmount && l.unmount(n2), (t4 = n2.ref) && (t4.current && t4.current !== n2.__e || M2(t4, null, u4)), null != (t4 = n2.__c)) {
    if (t4.componentWillUnmount)
      try {
        t4.componentWillUnmount();
      } catch (n3) {
        l.__e(n3, u4);
      }
    t4.base = t4.__P = null, n2.__c = void 0;
  }
  if (t4 = n2.__k)
    for (o3 = 0; o3 < t4.length; o3++)
      t4[o3] && N(t4[o3], u4, i4 || "function" != typeof n2.type);
  i4 || null == n2.__e || a(n2.__e), n2.__ = n2.__e = n2.__d = void 0;
}
function O(n2, l3, u4) {
  return this.constructor(n2, u4);
}
function P(u4, i4, t4) {
  var o3, r3, e4;
  l.__ && l.__(u4, i4), r3 = (o3 = "function" == typeof t4) ? null : t4 && t4.__k || i4.__k, e4 = [], j(i4, u4 = (!o3 && t4 || i4).__k = h(p2, null, [u4]), r3 || f, f, void 0 !== i4.ownerSVGElement, !o3 && t4 ? [t4] : r3 ? null : i4.firstChild ? n.call(i4.childNodes) : null, e4, !o3 && t4 ? t4 : r3 ? r3.__e : i4.firstChild, o3), z(e4, u4);
}
function S2(n2, l3) {
  P(n2, l3, S2);
}
function q(l3, u4, i4) {
  var t4, o3, r3, f3 = s({}, l3.props);
  for (r3 in u4)
    "key" == r3 ? t4 = u4[r3] : "ref" == r3 ? o3 = u4[r3] : f3[r3] = u4[r3];
  return arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i4), v(l3.type, f3, t4 || l3.key, o3 || l3.ref, null);
}
function B(n2, l3) {
  var u4 = { __c: l3 = "__cC" + r++, __: n2, Consumer: function(n3, l4) {
    return n3.children(l4);
  }, Provider: function(n3) {
    var u5, i4;
    return this.getChildContext || (u5 = [], (i4 = {})[l3] = this, this.getChildContext = function() {
      return i4;
    }, this.shouldComponentUpdate = function(n4) {
      this.props.value !== n4.value && u5.some(b);
    }, this.sub = function(n4) {
      u5.push(n4);
      var l4 = n4.componentWillUnmount;
      n4.componentWillUnmount = function() {
        u5.splice(u5.indexOf(n4), 1), l4 && l4.call(n4);
      };
    }), n3.children;
  } };
  return u4.Provider.__ = u4.Consumer.contextType = u4;
}
var n, l, u, i, t, o, r, f, e, c;
var init_preact_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js"() {
    f = {};
    e = [];
    c = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
    n = e.slice, l = { __e: function(n2, l3, u4, i4) {
      for (var t4, o3, r3; l3 = l3.__; )
        if ((t4 = l3.__c) && !t4.__)
          try {
            if ((o3 = t4.constructor) && null != o3.getDerivedStateFromError && (t4.setState(o3.getDerivedStateFromError(n2)), r3 = t4.__d), null != t4.componentDidCatch && (t4.componentDidCatch(n2, i4 || {}), r3 = t4.__d), r3)
              return t4.__E = t4;
          } catch (l4) {
            n2 = l4;
          }
      throw n2;
    } }, u = 0, i = function(n2) {
      return null != n2 && void 0 === n2.constructor;
    }, d.prototype.setState = function(n2, l3) {
      var u4;
      u4 = null != this.__s && this.__s !== this.state ? this.__s : this.__s = s({}, this.state), "function" == typeof n2 && (n2 = n2(s({}, u4), this.props)), n2 && s(u4, n2), null != n2 && this.__v && (l3 && this._sb.push(l3), b(this));
    }, d.prototype.forceUpdate = function(n2) {
      this.__v && (this.__e = true, n2 && this.__h.push(n2), b(this));
    }, d.prototype.render = p2, t = [], g.__r = 0, r = 0;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js
function d2(t4, u4) {
  l.__h && l.__h(r2, t4, o2 || u4), o2 = 0;
  var i4 = r2.__H || (r2.__H = { __: [], __h: [] });
  return t4 >= i4.__.length && i4.__.push({ __V: c2 }), i4.__[t4];
}
function p3(n2) {
  return o2 = 1, y2(B2, n2);
}
function y2(n2, u4, i4) {
  var o3 = d2(t2++, 2);
  if (o3.t = n2, !o3.__c && (o3.__ = [i4 ? i4(u4) : B2(void 0, u4), function(n3) {
    var t4 = o3.__N ? o3.__N[0] : o3.__[0], r3 = o3.t(t4, n3);
    t4 !== r3 && (o3.__N = [r3, o3.__[1]], o3.__c.setState({}));
  }], o3.__c = r2, !r2.u)) {
    r2.u = true;
    var f3 = r2.shouldComponentUpdate;
    r2.shouldComponentUpdate = function(n3, t4, r3) {
      if (!o3.__c.__H)
        return true;
      var u5 = o3.__c.__H.__.filter(function(n4) {
        return n4.__c;
      });
      if (u5.every(function(n4) {
        return !n4.__N;
      }))
        return !f3 || f3.call(this, n3, t4, r3);
      var i5 = false;
      return u5.forEach(function(n4) {
        if (n4.__N) {
          var t5 = n4.__[0];
          n4.__ = n4.__N, n4.__N = void 0, t5 !== n4.__[0] && (i5 = true);
        }
      }), !(!i5 && o3.__c.props === n3) && (!f3 || f3.call(this, n3, t4, r3));
    };
  }
  return o3.__N || o3.__;
}
function h2(u4, i4) {
  var o3 = d2(t2++, 3);
  !l.__s && z2(o3.__H, i4) && (o3.__ = u4, o3.i = i4, r2.__H.__h.push(o3));
}
function s2(u4, i4) {
  var o3 = d2(t2++, 4);
  !l.__s && z2(o3.__H, i4) && (o3.__ = u4, o3.i = i4, r2.__h.push(o3));
}
function _2(n2) {
  return o2 = 5, F(function() {
    return { current: n2 };
  }, []);
}
function A3(n2, t4, r3) {
  o2 = 6, s2(function() {
    return "function" == typeof n2 ? (n2(t4()), function() {
      return n2(null);
    }) : n2 ? (n2.current = t4(), function() {
      return n2.current = null;
    }) : void 0;
  }, null == r3 ? r3 : r3.concat(n2));
}
function F(n2, r3) {
  var u4 = d2(t2++, 7);
  return z2(u4.__H, r3) ? (u4.__V = n2(), u4.i = r3, u4.__h = n2, u4.__V) : u4.__;
}
function T2(n2, t4) {
  return o2 = 8, F(function() {
    return n2;
  }, t4);
}
function q2(n2) {
  var u4 = r2.context[n2.__c], i4 = d2(t2++, 9);
  return i4.c = n2, u4 ? (null == i4.__ && (i4.__ = true, u4.sub(r2)), u4.props.value) : n2.__;
}
function x3(t4, r3) {
  l.useDebugValue && l.useDebugValue(r3 ? r3(t4) : t4);
}
function P2(n2) {
  var u4 = d2(t2++, 10), i4 = p3();
  return u4.__ = n2, r2.componentDidCatch || (r2.componentDidCatch = function(n3, t4) {
    u4.__ && u4.__(n3, t4), i4[1](n3);
  }), [i4[0], function() {
    i4[1](void 0);
  }];
}
function V() {
  var n2 = d2(t2++, 11);
  if (!n2.__) {
    for (var u4 = r2.__v; null !== u4 && !u4.__m && null !== u4.__; )
      u4 = u4.__;
    var i4 = u4.__m || (u4.__m = [0, 0]);
    n2.__ = "P" + i4[0] + "-" + i4[1]++;
  }
  return n2.__;
}
function b2() {
  for (var t4; t4 = f2.shift(); )
    if (t4.__P && t4.__H)
      try {
        t4.__H.__h.forEach(k2), t4.__H.__h.forEach(w2), t4.__H.__h = [];
      } catch (r3) {
        t4.__H.__h = [], l.__e(r3, t4.__v);
      }
}
function j2(n2) {
  var t4, r3 = function() {
    clearTimeout(u4), g2 && cancelAnimationFrame(t4), setTimeout(n2);
  }, u4 = setTimeout(r3, 100);
  g2 && (t4 = requestAnimationFrame(r3));
}
function k2(n2) {
  var t4 = r2, u4 = n2.__c;
  "function" == typeof u4 && (n2.__c = void 0, u4()), r2 = t4;
}
function w2(n2) {
  var t4 = r2;
  n2.__c = n2.__(), r2 = t4;
}
function z2(n2, t4) {
  return !n2 || n2.length !== t4.length || t4.some(function(t5, r3) {
    return t5 !== n2[r3];
  });
}
function B2(n2, t4) {
  return "function" == typeof t4 ? t4(n2) : t4;
}
var t2, r2, u2, i2, o2, f2, c2, e2, a2, v2, l2, m2, g2;
var init_hooks_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js"() {
    init_preact_module();
    o2 = 0;
    f2 = [];
    c2 = [];
    e2 = l.__b;
    a2 = l.__r;
    v2 = l.diffed;
    l2 = l.__c;
    m2 = l.unmount;
    l.__b = function(n2) {
      r2 = null, e2 && e2(n2);
    }, l.__r = function(n2) {
      a2 && a2(n2), t2 = 0;
      var i4 = (r2 = n2.__c).__H;
      i4 && (u2 === r2 ? (i4.__h = [], r2.__h = [], i4.__.forEach(function(n3) {
        n3.__N && (n3.__ = n3.__N), n3.__V = c2, n3.__N = n3.i = void 0;
      })) : (i4.__h.forEach(k2), i4.__h.forEach(w2), i4.__h = [])), u2 = r2;
    }, l.diffed = function(t4) {
      v2 && v2(t4);
      var o3 = t4.__c;
      o3 && o3.__H && (o3.__H.__h.length && (1 !== f2.push(o3) && i2 === l.requestAnimationFrame || ((i2 = l.requestAnimationFrame) || j2)(b2)), o3.__H.__.forEach(function(n2) {
        n2.i && (n2.__H = n2.i), n2.__V !== c2 && (n2.__ = n2.__V), n2.i = void 0, n2.__V = c2;
      })), u2 = r2 = null;
    }, l.__c = function(t4, r3) {
      r3.some(function(t5) {
        try {
          t5.__h.forEach(k2), t5.__h = t5.__h.filter(function(n2) {
            return !n2.__ || w2(n2);
          });
        } catch (u4) {
          r3.some(function(n2) {
            n2.__h && (n2.__h = []);
          }), r3 = [], l.__e(u4, t5.__v);
        }
      }), l2 && l2(t4, r3);
    }, l.unmount = function(t4) {
      m2 && m2(t4);
      var r3, u4 = t4.__c;
      u4 && u4.__H && (u4.__H.__.forEach(function(n2) {
        try {
          k2(n2);
        } catch (n3) {
          r3 = n3;
        }
      }), u4.__H = void 0, r3 && l.__e(r3, u4.__v));
    };
    g2 = "function" == typeof requestAnimationFrame;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js
var compat_module_exports = {};
__export(compat_module_exports, {
  Children: () => O2,
  Component: () => d,
  Fragment: () => p2,
  PureComponent: () => w3,
  StrictMode: () => vn2,
  Suspense: () => D3,
  SuspenseList: () => V2,
  __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: () => rn,
  cloneElement: () => cn,
  createContext: () => B,
  createElement: () => h,
  createFactory: () => on,
  createPortal: () => j3,
  createRef: () => y,
  default: () => bn,
  findDOMNode: () => an,
  flushSync: () => hn,
  forwardRef: () => k3,
  hydrate: () => q3,
  isValidElement: () => ln,
  lazy: () => M3,
  memo: () => R,
  render: () => Y2,
  startTransition: () => dn,
  unmountComponentAtNode: () => fn,
  unstable_batchedUpdates: () => sn,
  useCallback: () => T2,
  useContext: () => q2,
  useDebugValue: () => x3,
  useDeferredValue: () => pn,
  useEffect: () => h2,
  useErrorBoundary: () => P2,
  useId: () => V,
  useImperativeHandle: () => A3,
  useInsertionEffect: () => yn,
  useLayoutEffect: () => s2,
  useMemo: () => F,
  useReducer: () => y2,
  useRef: () => _2,
  useState: () => p3,
  useSyncExternalStore: () => _n,
  useTransition: () => mn,
  version: () => un
});
function g3(n2, t4) {
  for (var e4 in t4)
    n2[e4] = t4[e4];
  return n2;
}
function C2(n2, t4) {
  for (var e4 in n2)
    if ("__source" !== e4 && !(e4 in t4))
      return true;
  for (var r3 in t4)
    if ("__source" !== r3 && n2[r3] !== t4[r3])
      return true;
  return false;
}
function E(n2, t4) {
  return n2 === t4 && (0 !== n2 || 1 / n2 == 1 / t4) || n2 != n2 && t4 != t4;
}
function w3(n2) {
  this.props = n2;
}
function R(n2, e4) {
  function r3(n3) {
    var t4 = this.props.ref, r4 = t4 == n3.ref;
    return !r4 && t4 && (t4.call ? t4(null) : t4.current = null), e4 ? !e4(this.props, n3) || !r4 : C2(this.props, n3);
  }
  function u4(e5) {
    return this.shouldComponentUpdate = r3, h(n2, e5);
  }
  return u4.displayName = "Memo(" + (n2.displayName || n2.name) + ")", u4.prototype.isReactComponent = true, u4.__f = true, u4;
}
function k3(n2) {
  function t4(t5) {
    var e4 = g3({}, t5);
    return delete e4.ref, n2(e4, t5.ref || null);
  }
  return t4.$$typeof = N2, t4.render = t4, t4.prototype.isReactComponent = t4.__f = true, t4.displayName = "ForwardRef(" + (n2.displayName || n2.name) + ")", t4;
}
function L3(n2, t4, e4) {
  return n2 && (n2.__c && n2.__c.__H && (n2.__c.__H.__.forEach(function(n3) {
    "function" == typeof n3.__c && n3.__c();
  }), n2.__c.__H = null), null != (n2 = g3({}, n2)).__c && (n2.__c.__P === e4 && (n2.__c.__P = t4), n2.__c = null), n2.__k = n2.__k && n2.__k.map(function(n3) {
    return L3(n3, t4, e4);
  })), n2;
}
function U(n2, t4, e4) {
  return n2 && (n2.__v = null, n2.__k = n2.__k && n2.__k.map(function(n3) {
    return U(n3, t4, e4);
  }), n2.__c && n2.__c.__P === t4 && (n2.__e && e4.insertBefore(n2.__e, n2.__d), n2.__c.__e = true, n2.__c.__P = e4)), n2;
}
function D3() {
  this.__u = 0, this.t = null, this.__b = null;
}
function F2(n2) {
  var t4 = n2.__.__c;
  return t4 && t4.__a && t4.__a(n2);
}
function M3(n2) {
  var e4, r3, u4;
  function o3(o4) {
    if (e4 || (e4 = n2()).then(function(n3) {
      r3 = n3.default || n3;
    }, function(n3) {
      u4 = n3;
    }), u4)
      throw u4;
    if (!r3)
      throw e4;
    return h(r3, o4);
  }
  return o3.displayName = "Lazy", o3.__f = true, o3;
}
function V2() {
  this.u = null, this.o = null;
}
function P3(n2) {
  return this.getChildContext = function() {
    return n2.context;
  }, n2.children;
}
function $2(n2) {
  var e4 = this, r3 = n2.i;
  e4.componentWillUnmount = function() {
    P(null, e4.l), e4.l = null, e4.i = null;
  }, e4.i && e4.i !== r3 && e4.componentWillUnmount(), n2.__v ? (e4.l || (e4.i = r3, e4.l = { nodeType: 1, parentNode: r3, childNodes: [], appendChild: function(n3) {
    this.childNodes.push(n3), e4.i.appendChild(n3);
  }, insertBefore: function(n3, t4) {
    this.childNodes.push(n3), e4.i.appendChild(n3);
  }, removeChild: function(n3) {
    this.childNodes.splice(this.childNodes.indexOf(n3) >>> 1, 1), e4.i.removeChild(n3);
  } }), P(h(P3, { context: e4.context }, n2.__v), e4.l)) : e4.l && e4.componentWillUnmount();
}
function j3(n2, e4) {
  var r3 = h($2, { __v: n2, i: e4 });
  return r3.containerInfo = e4, r3;
}
function Y2(n2, t4, e4) {
  return null == t4.__k && (t4.textContent = ""), P(n2, t4), "function" == typeof e4 && e4(), n2 ? n2.__c : null;
}
function q3(n2, t4, e4) {
  return S2(n2, t4), "function" == typeof e4 && e4(), n2 ? n2.__c : null;
}
function J() {
}
function K3() {
  return this.cancelBubble;
}
function Q() {
  return this.defaultPrevented;
}
function on(n2) {
  return h.bind(null, n2);
}
function ln(n2) {
  return !!n2 && n2.$$typeof === z3;
}
function cn(n2) {
  return ln(n2) ? q.apply(null, arguments) : n2;
}
function fn(n2) {
  return !!n2.__k && (P(null, n2), true);
}
function an(n2) {
  return n2 && (n2.base || 1 === n2.nodeType && n2) || null;
}
function dn(n2) {
  n2();
}
function pn(n2) {
  return n2;
}
function mn() {
  return [false, dn];
}
function _n(n2, t4) {
  var e4 = t4(), r3 = p3({ h: { __: e4, v: t4 } }), u4 = r3[0].h, o3 = r3[1];
  return s2(function() {
    u4.__ = e4, u4.v = t4, E(u4.__, t4()) || o3({ h: u4 });
  }, [n2, e4, t4]), h2(function() {
    return E(u4.__, u4.v()) || o3({ h: u4 }), n2(function() {
      E(u4.__, u4.v()) || o3({ h: u4 });
    });
  }, [n2]), e4;
}
var x4, N2, A4, O2, T3, I3, W, z3, B3, H2, Z2, G, X2, nn, tn, en, rn, un, sn, hn, vn2, yn, bn;
var init_compat_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js"() {
    init_preact_module();
    init_preact_module();
    init_hooks_module();
    init_hooks_module();
    (w3.prototype = new d()).isPureReactComponent = true, w3.prototype.shouldComponentUpdate = function(n2, t4) {
      return C2(this.props, n2) || C2(this.state, t4);
    };
    x4 = l.__b;
    l.__b = function(n2) {
      n2.type && n2.type.__f && n2.ref && (n2.props.ref = n2.ref, n2.ref = null), x4 && x4(n2);
    };
    N2 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.forward_ref") || 3911;
    A4 = function(n2, t4) {
      return null == n2 ? null : x2(x2(n2).map(t4));
    };
    O2 = { map: A4, forEach: A4, count: function(n2) {
      return n2 ? x2(n2).length : 0;
    }, only: function(n2) {
      var t4 = x2(n2);
      if (1 !== t4.length)
        throw "Children.only";
      return t4[0];
    }, toArray: x2 };
    T3 = l.__e;
    l.__e = function(n2, t4, e4, r3) {
      if (n2.then) {
        for (var u4, o3 = t4; o3 = o3.__; )
          if ((u4 = o3.__c) && u4.__c)
            return null == t4.__e && (t4.__e = e4.__e, t4.__k = e4.__k), u4.__c(n2, t4);
      }
      T3(n2, t4, e4, r3);
    };
    I3 = l.unmount;
    l.unmount = function(n2) {
      var t4 = n2.__c;
      t4 && t4.__R && t4.__R(), t4 && true === n2.__h && (n2.type = null), I3 && I3(n2);
    }, (D3.prototype = new d()).__c = function(n2, t4) {
      var e4 = t4.__c, r3 = this;
      null == r3.t && (r3.t = []), r3.t.push(e4);
      var u4 = F2(r3.__v), o3 = false, i4 = function() {
        o3 || (o3 = true, e4.__R = null, u4 ? u4(l3) : l3());
      };
      e4.__R = i4;
      var l3 = function() {
        if (!--r3.__u) {
          if (r3.state.__a) {
            var n3 = r3.state.__a;
            r3.__v.__k[0] = U(n3, n3.__c.__P, n3.__c.__O);
          }
          var t5;
          for (r3.setState({ __a: r3.__b = null }); t5 = r3.t.pop(); )
            t5.forceUpdate();
        }
      }, c4 = true === t4.__h;
      r3.__u++ || c4 || r3.setState({ __a: r3.__b = r3.__v.__k[0] }), n2.then(i4, i4);
    }, D3.prototype.componentWillUnmount = function() {
      this.t = [];
    }, D3.prototype.render = function(n2, e4) {
      if (this.__b) {
        if (this.__v.__k) {
          var r3 = document.createElement("div"), o3 = this.__v.__k[0].__c;
          this.__v.__k[0] = L3(this.__b, r3, o3.__O = o3.__P);
        }
        this.__b = null;
      }
      var i4 = e4.__a && h(p2, null, n2.fallback);
      return i4 && (i4.__h = null), [h(p2, null, e4.__a ? null : n2.children), i4];
    };
    W = function(n2, t4, e4) {
      if (++e4[1] === e4[0] && n2.o.delete(t4), n2.props.revealOrder && ("t" !== n2.props.revealOrder[0] || !n2.o.size))
        for (e4 = n2.u; e4; ) {
          for (; e4.length > 3; )
            e4.pop()();
          if (e4[1] < e4[0])
            break;
          n2.u = e4 = e4[2];
        }
    };
    (V2.prototype = new d()).__a = function(n2) {
      var t4 = this, e4 = F2(t4.__v), r3 = t4.o.get(n2);
      return r3[0]++, function(u4) {
        var o3 = function() {
          t4.props.revealOrder ? (r3.push(u4), W(t4, n2, r3)) : u4();
        };
        e4 ? e4(o3) : o3();
      };
    }, V2.prototype.render = function(n2) {
      this.u = null, this.o = /* @__PURE__ */ new Map();
      var t4 = x2(n2.children);
      n2.revealOrder && "b" === n2.revealOrder[0] && t4.reverse();
      for (var e4 = t4.length; e4--; )
        this.o.set(t4[e4], this.u = [1, 0, this.u]);
      return n2.children;
    }, V2.prototype.componentDidUpdate = V2.prototype.componentDidMount = function() {
      var n2 = this;
      this.o.forEach(function(t4, e4) {
        W(n2, e4, t4);
      });
    };
    z3 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.element") || 60103;
    B3 = /^(?:accent|alignment|arabic|baseline|cap|clip(?!PathU)|color|dominant|fill|flood|font|glyph(?!R)|horiz|image|letter|lighting|marker(?!H|W|U)|overline|paint|pointer|shape|stop|strikethrough|stroke|text(?!L)|transform|underline|unicode|units|v|vector|vert|word|writing|x(?!C))[A-Z]/;
    H2 = "undefined" != typeof document;
    Z2 = function(n2) {
      return ("undefined" != typeof Symbol && "symbol" == typeof Symbol() ? /fil|che|rad/i : /fil|che|ra/i).test(n2);
    };
    d.prototype.isReactComponent = {}, ["componentWillMount", "componentWillReceiveProps", "componentWillUpdate"].forEach(function(t4) {
      Object.defineProperty(d.prototype, t4, { configurable: true, get: function() {
        return this["UNSAFE_" + t4];
      }, set: function(n2) {
        Object.defineProperty(this, t4, { configurable: true, writable: true, value: n2 });
      } });
    });
    G = l.event;
    l.event = function(n2) {
      return G && (n2 = G(n2)), n2.persist = J, n2.isPropagationStopped = K3, n2.isDefaultPrevented = Q, n2.nativeEvent = n2;
    };
    nn = { configurable: true, get: function() {
      return this.class;
    } };
    tn = l.vnode;
    l.vnode = function(n2) {
      var t4 = n2.type, e4 = n2.props, u4 = e4;
      if ("string" == typeof t4) {
        var o3 = -1 === t4.indexOf("-");
        for (var i4 in u4 = {}, e4) {
          var l3 = e4[i4];
          H2 && "children" === i4 && "noscript" === t4 || "value" === i4 && "defaultValue" in e4 && null == l3 || ("defaultValue" === i4 && "value" in e4 && null == e4.value ? i4 = "value" : "download" === i4 && true === l3 ? l3 = "" : /ondoubleclick/i.test(i4) ? i4 = "ondblclick" : /^onchange(textarea|input)/i.test(i4 + t4) && !Z2(e4.type) ? i4 = "oninput" : /^onfocus$/i.test(i4) ? i4 = "onfocusin" : /^onblur$/i.test(i4) ? i4 = "onfocusout" : /^on(Ani|Tra|Tou|BeforeInp|Compo)/.test(i4) ? i4 = i4.toLowerCase() : o3 && B3.test(i4) ? i4 = i4.replace(/[A-Z0-9]/g, "-$&").toLowerCase() : null === l3 && (l3 = void 0), /^oninput$/i.test(i4) && (i4 = i4.toLowerCase(), u4[i4] && (i4 = "oninputCapture")), u4[i4] = l3);
        }
        "select" == t4 && u4.multiple && Array.isArray(u4.value) && (u4.value = x2(e4.children).forEach(function(n3) {
          n3.props.selected = -1 != u4.value.indexOf(n3.props.value);
        })), "select" == t4 && null != u4.defaultValue && (u4.value = x2(e4.children).forEach(function(n3) {
          n3.props.selected = u4.multiple ? -1 != u4.defaultValue.indexOf(n3.props.value) : u4.defaultValue == n3.props.value;
        })), n2.props = u4, e4.class != e4.className && (nn.enumerable = "className" in e4, null != e4.className && (u4.class = e4.className), Object.defineProperty(u4, "className", nn));
      }
      n2.$$typeof = z3, tn && tn(n2);
    };
    en = l.__r;
    l.__r = function(n2) {
      en && en(n2), X2 = n2.__c;
    };
    rn = { ReactCurrentDispatcher: { current: { readContext: function(n2) {
      return X2.__n[n2.__c].props.value;
    } } } };
    un = "17.0.2";
    sn = function(n2, t4) {
      return n2(t4);
    };
    hn = function(n2, t4) {
      return n2(t4);
    };
    vn2 = p2;
    yn = s2;
    bn = { useState: p3, useId: V, useReducer: y2, useEffect: h2, useLayoutEffect: s2, useInsertionEffect: yn, useTransition: mn, useDeferredValue: pn, useSyncExternalStore: _n, startTransition: dn, useRef: _2, useImperativeHandle: A3, useMemo: F, useCallback: T2, useContext: q2, useDebugValue: x3, version: "17.0.2", Children: O2, render: Y2, hydrate: q3, unmountComponentAtNode: fn, createPortal: j3, createElement: h, createContext: B, createFactory: on, cloneElement: cn, createRef: y, Fragment: p2, isValidElement: ln, findDOMNode: an, Component: d, PureComponent: w3, memo: R, forwardRef: k3, flushSync: hn, unstable_batchedUpdates: sn, StrictMode: vn2, Suspense: D3, SuspenseList: V2, lazy: M3, __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: rn };
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.2.0/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js
var require_use_sync_external_store_shim_production_min = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.2.0/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js"(exports) {
    "use strict";
    var e4 = (init_compat_module(), __toCommonJS(compat_module_exports));
    function h5(a5, b4) {
      return a5 === b4 && (0 !== a5 || 1 / a5 === 1 / b4) || a5 !== a5 && b4 !== b4;
    }
    var k5 = "function" === typeof Object.is ? Object.is : h5;
    var l3 = e4.useState;
    var m5 = e4.useEffect;
    var n2 = e4.useLayoutEffect;
    var p4 = e4.useDebugValue;
    function q5(a5, b4) {
      var d5 = b4(), f3 = l3({ inst: { value: d5, getSnapshot: b4 } }), c4 = f3[0].inst, g4 = f3[1];
      n2(function() {
        c4.value = d5;
        c4.getSnapshot = b4;
        r3(c4) && g4({ inst: c4 });
      }, [a5, d5, b4]);
      m5(function() {
        r3(c4) && g4({ inst: c4 });
        return a5(function() {
          r3(c4) && g4({ inst: c4 });
        });
      }, [a5]);
      p4(d5);
      return d5;
    }
    function r3(a5) {
      var b4 = a5.getSnapshot;
      a5 = a5.value;
      try {
        var d5 = b4();
        return !k5(a5, d5);
      } catch (f3) {
        return true;
      }
    }
    function t4(a5, b4) {
      return b4();
    }
    var u4 = "undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement ? t4 : q5;
    exports.useSyncExternalStore = void 0 !== e4.useSyncExternalStore ? e4.useSyncExternalStore : u4;
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.2.0/node_modules/use-sync-external-store/shim/index.js
var require_shim = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.2.0/node_modules/use-sync-external-store/shim/index.js"(exports, module) {
    "use strict";
    if (true) {
      module.exports = require_use_sync_external_store_shim_production_min();
    } else {
      module.exports = null;
    }
  }
});

// ../../node_modules/.pnpm/qrcode-generator@1.4.4/node_modules/qrcode-generator/qrcode.js
var require_qrcode = __commonJS({
  "../../node_modules/.pnpm/qrcode-generator@1.4.4/node_modules/qrcode-generator/qrcode.js"(exports, module) {
    var qrcode2 = function() {
      var qrcode3 = function(typeNumber, errorCorrectionLevel) {
        var PAD0 = 236;
        var PAD1 = 17;
        var _typeNumber = typeNumber;
        var _errorCorrectionLevel = QRErrorCorrectionLevel[errorCorrectionLevel];
        var _modules = null;
        var _moduleCount = 0;
        var _dataCache = null;
        var _dataList = [];
        var _this = {};
        var makeImpl = function(test, maskPattern) {
          _moduleCount = _typeNumber * 4 + 17;
          _modules = function(moduleCount) {
            var modules = new Array(moduleCount);
            for (var row = 0; row < moduleCount; row += 1) {
              modules[row] = new Array(moduleCount);
              for (var col = 0; col < moduleCount; col += 1) {
                modules[row][col] = null;
              }
            }
            return modules;
          }(_moduleCount);
          setupPositionProbePattern(0, 0);
          setupPositionProbePattern(_moduleCount - 7, 0);
          setupPositionProbePattern(0, _moduleCount - 7);
          setupPositionAdjustPattern();
          setupTimingPattern();
          setupTypeInfo(test, maskPattern);
          if (_typeNumber >= 7) {
            setupTypeNumber(test);
          }
          if (_dataCache == null) {
            _dataCache = createData(_typeNumber, _errorCorrectionLevel, _dataList);
          }
          mapData(_dataCache, maskPattern);
        };
        var setupPositionProbePattern = function(row, col) {
          for (var r3 = -1; r3 <= 7; r3 += 1) {
            if (row + r3 <= -1 || _moduleCount <= row + r3)
              continue;
            for (var c4 = -1; c4 <= 7; c4 += 1) {
              if (col + c4 <= -1 || _moduleCount <= col + c4)
                continue;
              if (0 <= r3 && r3 <= 6 && (c4 == 0 || c4 == 6) || 0 <= c4 && c4 <= 6 && (r3 == 0 || r3 == 6) || 2 <= r3 && r3 <= 4 && 2 <= c4 && c4 <= 4) {
                _modules[row + r3][col + c4] = true;
              } else {
                _modules[row + r3][col + c4] = false;
              }
            }
          }
        };
        var getBestMaskPattern = function() {
          var minLostPoint = 0;
          var pattern = 0;
          for (var i4 = 0; i4 < 8; i4 += 1) {
            makeImpl(true, i4);
            var lostPoint = QRUtil.getLostPoint(_this);
            if (i4 == 0 || minLostPoint > lostPoint) {
              minLostPoint = lostPoint;
              pattern = i4;
            }
          }
          return pattern;
        };
        var setupTimingPattern = function() {
          for (var r3 = 8; r3 < _moduleCount - 8; r3 += 1) {
            if (_modules[r3][6] != null) {
              continue;
            }
            _modules[r3][6] = r3 % 2 == 0;
          }
          for (var c4 = 8; c4 < _moduleCount - 8; c4 += 1) {
            if (_modules[6][c4] != null) {
              continue;
            }
            _modules[6][c4] = c4 % 2 == 0;
          }
        };
        var setupPositionAdjustPattern = function() {
          var pos = QRUtil.getPatternPosition(_typeNumber);
          for (var i4 = 0; i4 < pos.length; i4 += 1) {
            for (var j4 = 0; j4 < pos.length; j4 += 1) {
              var row = pos[i4];
              var col = pos[j4];
              if (_modules[row][col] != null) {
                continue;
              }
              for (var r3 = -2; r3 <= 2; r3 += 1) {
                for (var c4 = -2; c4 <= 2; c4 += 1) {
                  if (r3 == -2 || r3 == 2 || c4 == -2 || c4 == 2 || r3 == 0 && c4 == 0) {
                    _modules[row + r3][col + c4] = true;
                  } else {
                    _modules[row + r3][col + c4] = false;
                  }
                }
              }
            }
          }
        };
        var setupTypeNumber = function(test) {
          var bits = QRUtil.getBCHTypeNumber(_typeNumber);
          for (var i4 = 0; i4 < 18; i4 += 1) {
            var mod = !test && (bits >> i4 & 1) == 1;
            _modules[Math.floor(i4 / 3)][i4 % 3 + _moduleCount - 8 - 3] = mod;
          }
          for (var i4 = 0; i4 < 18; i4 += 1) {
            var mod = !test && (bits >> i4 & 1) == 1;
            _modules[i4 % 3 + _moduleCount - 8 - 3][Math.floor(i4 / 3)] = mod;
          }
        };
        var setupTypeInfo = function(test, maskPattern) {
          var data = _errorCorrectionLevel << 3 | maskPattern;
          var bits = QRUtil.getBCHTypeInfo(data);
          for (var i4 = 0; i4 < 15; i4 += 1) {
            var mod = !test && (bits >> i4 & 1) == 1;
            if (i4 < 6) {
              _modules[i4][8] = mod;
            } else if (i4 < 8) {
              _modules[i4 + 1][8] = mod;
            } else {
              _modules[_moduleCount - 15 + i4][8] = mod;
            }
          }
          for (var i4 = 0; i4 < 15; i4 += 1) {
            var mod = !test && (bits >> i4 & 1) == 1;
            if (i4 < 8) {
              _modules[8][_moduleCount - i4 - 1] = mod;
            } else if (i4 < 9) {
              _modules[8][15 - i4 - 1 + 1] = mod;
            } else {
              _modules[8][15 - i4 - 1] = mod;
            }
          }
          _modules[_moduleCount - 8][8] = !test;
        };
        var mapData = function(data, maskPattern) {
          var inc = -1;
          var row = _moduleCount - 1;
          var bitIndex = 7;
          var byteIndex = 0;
          var maskFunc = QRUtil.getMaskFunction(maskPattern);
          for (var col = _moduleCount - 1; col > 0; col -= 2) {
            if (col == 6)
              col -= 1;
            while (true) {
              for (var c4 = 0; c4 < 2; c4 += 1) {
                if (_modules[row][col - c4] == null) {
                  var dark = false;
                  if (byteIndex < data.length) {
                    dark = (data[byteIndex] >>> bitIndex & 1) == 1;
                  }
                  var mask = maskFunc(row, col - c4);
                  if (mask) {
                    dark = !dark;
                  }
                  _modules[row][col - c4] = dark;
                  bitIndex -= 1;
                  if (bitIndex == -1) {
                    byteIndex += 1;
                    bitIndex = 7;
                  }
                }
              }
              row += inc;
              if (row < 0 || _moduleCount <= row) {
                row -= inc;
                inc = -inc;
                break;
              }
            }
          }
        };
        var createBytes = function(buffer, rsBlocks) {
          var offset = 0;
          var maxDcCount = 0;
          var maxEcCount = 0;
          var dcdata = new Array(rsBlocks.length);
          var ecdata = new Array(rsBlocks.length);
          for (var r3 = 0; r3 < rsBlocks.length; r3 += 1) {
            var dcCount = rsBlocks[r3].dataCount;
            var ecCount = rsBlocks[r3].totalCount - dcCount;
            maxDcCount = Math.max(maxDcCount, dcCount);
            maxEcCount = Math.max(maxEcCount, ecCount);
            dcdata[r3] = new Array(dcCount);
            for (var i4 = 0; i4 < dcdata[r3].length; i4 += 1) {
              dcdata[r3][i4] = 255 & buffer.getBuffer()[i4 + offset];
            }
            offset += dcCount;
            var rsPoly = QRUtil.getErrorCorrectPolynomial(ecCount);
            var rawPoly = qrPolynomial(dcdata[r3], rsPoly.getLength() - 1);
            var modPoly = rawPoly.mod(rsPoly);
            ecdata[r3] = new Array(rsPoly.getLength() - 1);
            for (var i4 = 0; i4 < ecdata[r3].length; i4 += 1) {
              var modIndex = i4 + modPoly.getLength() - ecdata[r3].length;
              ecdata[r3][i4] = modIndex >= 0 ? modPoly.getAt(modIndex) : 0;
            }
          }
          var totalCodeCount = 0;
          for (var i4 = 0; i4 < rsBlocks.length; i4 += 1) {
            totalCodeCount += rsBlocks[i4].totalCount;
          }
          var data = new Array(totalCodeCount);
          var index = 0;
          for (var i4 = 0; i4 < maxDcCount; i4 += 1) {
            for (var r3 = 0; r3 < rsBlocks.length; r3 += 1) {
              if (i4 < dcdata[r3].length) {
                data[index] = dcdata[r3][i4];
                index += 1;
              }
            }
          }
          for (var i4 = 0; i4 < maxEcCount; i4 += 1) {
            for (var r3 = 0; r3 < rsBlocks.length; r3 += 1) {
              if (i4 < ecdata[r3].length) {
                data[index] = ecdata[r3][i4];
                index += 1;
              }
            }
          }
          return data;
        };
        var createData = function(typeNumber2, errorCorrectionLevel2, dataList) {
          var rsBlocks = QRRSBlock.getRSBlocks(typeNumber2, errorCorrectionLevel2);
          var buffer = qrBitBuffer();
          for (var i4 = 0; i4 < dataList.length; i4 += 1) {
            var data = dataList[i4];
            buffer.put(data.getMode(), 4);
            buffer.put(data.getLength(), QRUtil.getLengthInBits(data.getMode(), typeNumber2));
            data.write(buffer);
          }
          var totalDataCount = 0;
          for (var i4 = 0; i4 < rsBlocks.length; i4 += 1) {
            totalDataCount += rsBlocks[i4].dataCount;
          }
          if (buffer.getLengthInBits() > totalDataCount * 8) {
            throw "code length overflow. (" + buffer.getLengthInBits() + ">" + totalDataCount * 8 + ")";
          }
          if (buffer.getLengthInBits() + 4 <= totalDataCount * 8) {
            buffer.put(0, 4);
          }
          while (buffer.getLengthInBits() % 8 != 0) {
            buffer.putBit(false);
          }
          while (true) {
            if (buffer.getLengthInBits() >= totalDataCount * 8) {
              break;
            }
            buffer.put(PAD0, 8);
            if (buffer.getLengthInBits() >= totalDataCount * 8) {
              break;
            }
            buffer.put(PAD1, 8);
          }
          return createBytes(buffer, rsBlocks);
        };
        _this.addData = function(data, mode) {
          mode = mode || "Byte";
          var newData = null;
          switch (mode) {
            case "Numeric":
              newData = qrNumber(data);
              break;
            case "Alphanumeric":
              newData = qrAlphaNum(data);
              break;
            case "Byte":
              newData = qr8BitByte(data);
              break;
            case "Kanji":
              newData = qrKanji(data);
              break;
            default:
              throw "mode:" + mode;
          }
          _dataList.push(newData);
          _dataCache = null;
        };
        _this.isDark = function(row, col) {
          if (row < 0 || _moduleCount <= row || col < 0 || _moduleCount <= col) {
            throw row + "," + col;
          }
          return _modules[row][col];
        };
        _this.getModuleCount = function() {
          return _moduleCount;
        };
        _this.make = function() {
          if (_typeNumber < 1) {
            var typeNumber2 = 1;
            for (; typeNumber2 < 40; typeNumber2++) {
              var rsBlocks = QRRSBlock.getRSBlocks(typeNumber2, _errorCorrectionLevel);
              var buffer = qrBitBuffer();
              for (var i4 = 0; i4 < _dataList.length; i4++) {
                var data = _dataList[i4];
                buffer.put(data.getMode(), 4);
                buffer.put(data.getLength(), QRUtil.getLengthInBits(data.getMode(), typeNumber2));
                data.write(buffer);
              }
              var totalDataCount = 0;
              for (var i4 = 0; i4 < rsBlocks.length; i4++) {
                totalDataCount += rsBlocks[i4].dataCount;
              }
              if (buffer.getLengthInBits() <= totalDataCount * 8) {
                break;
              }
            }
            _typeNumber = typeNumber2;
          }
          makeImpl(false, getBestMaskPattern());
        };
        _this.createTableTag = function(cellSize, margin) {
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          var qrHtml = "";
          qrHtml += '<table style="';
          qrHtml += " border-width: 0px; border-style: none;";
          qrHtml += " border-collapse: collapse;";
          qrHtml += " padding: 0px; margin: " + margin + "px;";
          qrHtml += '">';
          qrHtml += "<tbody>";
          for (var r3 = 0; r3 < _this.getModuleCount(); r3 += 1) {
            qrHtml += "<tr>";
            for (var c4 = 0; c4 < _this.getModuleCount(); c4 += 1) {
              qrHtml += '<td style="';
              qrHtml += " border-width: 0px; border-style: none;";
              qrHtml += " border-collapse: collapse;";
              qrHtml += " padding: 0px; margin: 0px;";
              qrHtml += " width: " + cellSize + "px;";
              qrHtml += " height: " + cellSize + "px;";
              qrHtml += " background-color: ";
              qrHtml += _this.isDark(r3, c4) ? "#000000" : "#ffffff";
              qrHtml += ";";
              qrHtml += '"/>';
            }
            qrHtml += "</tr>";
          }
          qrHtml += "</tbody>";
          qrHtml += "</table>";
          return qrHtml;
        };
        _this.createSvgTag = function(cellSize, margin, alt, title) {
          var opts = {};
          if (typeof arguments[0] == "object") {
            opts = arguments[0];
            cellSize = opts.cellSize;
            margin = opts.margin;
            alt = opts.alt;
            title = opts.title;
          }
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          alt = typeof alt === "string" ? { text: alt } : alt || {};
          alt.text = alt.text || null;
          alt.id = alt.text ? alt.id || "qrcode-description" : null;
          title = typeof title === "string" ? { text: title } : title || {};
          title.text = title.text || null;
          title.id = title.text ? title.id || "qrcode-title" : null;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var c4, mc, r3, mr, qrSvg = "", rect;
          rect = "l" + cellSize + ",0 0," + cellSize + " -" + cellSize + ",0 0,-" + cellSize + "z ";
          qrSvg += '<svg version="1.1" xmlns="http://www.w3.org/2000/svg"';
          qrSvg += !opts.scalable ? ' width="' + size + 'px" height="' + size + 'px"' : "";
          qrSvg += ' viewBox="0 0 ' + size + " " + size + '" ';
          qrSvg += ' preserveAspectRatio="xMinYMin meet"';
          qrSvg += title.text || alt.text ? ' role="img" aria-labelledby="' + escapeXml([title.id, alt.id].join(" ").trim()) + '"' : "";
          qrSvg += ">";
          qrSvg += title.text ? '<title id="' + escapeXml(title.id) + '">' + escapeXml(title.text) + "</title>" : "";
          qrSvg += alt.text ? '<description id="' + escapeXml(alt.id) + '">' + escapeXml(alt.text) + "</description>" : "";
          qrSvg += '<rect width="100%" height="100%" fill="white" cx="0" cy="0"/>';
          qrSvg += '<path d="';
          for (r3 = 0; r3 < _this.getModuleCount(); r3 += 1) {
            mr = r3 * cellSize + margin;
            for (c4 = 0; c4 < _this.getModuleCount(); c4 += 1) {
              if (_this.isDark(r3, c4)) {
                mc = c4 * cellSize + margin;
                qrSvg += "M" + mc + "," + mr + rect;
              }
            }
          }
          qrSvg += '" stroke="transparent" fill="black"/>';
          qrSvg += "</svg>";
          return qrSvg;
        };
        _this.createDataURL = function(cellSize, margin) {
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var min = margin;
          var max = size - margin;
          return createDataURL(size, size, function(x6, y5) {
            if (min <= x6 && x6 < max && min <= y5 && y5 < max) {
              var c4 = Math.floor((x6 - min) / cellSize);
              var r3 = Math.floor((y5 - min) / cellSize);
              return _this.isDark(r3, c4) ? 0 : 1;
            } else {
              return 1;
            }
          });
        };
        _this.createImgTag = function(cellSize, margin, alt) {
          cellSize = cellSize || 2;
          margin = typeof margin == "undefined" ? cellSize * 4 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var img = "";
          img += "<img";
          img += ' src="';
          img += _this.createDataURL(cellSize, margin);
          img += '"';
          img += ' width="';
          img += size;
          img += '"';
          img += ' height="';
          img += size;
          img += '"';
          if (alt) {
            img += ' alt="';
            img += escapeXml(alt);
            img += '"';
          }
          img += "/>";
          return img;
        };
        var escapeXml = function(s5) {
          var escaped = "";
          for (var i4 = 0; i4 < s5.length; i4 += 1) {
            var c4 = s5.charAt(i4);
            switch (c4) {
              case "<":
                escaped += "&lt;";
                break;
              case ">":
                escaped += "&gt;";
                break;
              case "&":
                escaped += "&amp;";
                break;
              case '"':
                escaped += "&quot;";
                break;
              default:
                escaped += c4;
                break;
            }
          }
          return escaped;
        };
        var _createHalfASCII = function(margin) {
          var cellSize = 1;
          margin = typeof margin == "undefined" ? cellSize * 2 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var min = margin;
          var max = size - margin;
          var y5, x6, r1, r22, p4;
          var blocks = {
            "\u2588\u2588": "\u2588",
            "\u2588 ": "\u2580",
            " \u2588": "\u2584",
            "  ": " "
          };
          var blocksLastLineNoMargin = {
            "\u2588\u2588": "\u2580",
            "\u2588 ": "\u2580",
            " \u2588": " ",
            "  ": " "
          };
          var ascii = "";
          for (y5 = 0; y5 < size; y5 += 2) {
            r1 = Math.floor((y5 - min) / cellSize);
            r22 = Math.floor((y5 + 1 - min) / cellSize);
            for (x6 = 0; x6 < size; x6 += 1) {
              p4 = "\u2588";
              if (min <= x6 && x6 < max && min <= y5 && y5 < max && _this.isDark(r1, Math.floor((x6 - min) / cellSize))) {
                p4 = " ";
              }
              if (min <= x6 && x6 < max && min <= y5 + 1 && y5 + 1 < max && _this.isDark(r22, Math.floor((x6 - min) / cellSize))) {
                p4 += " ";
              } else {
                p4 += "\u2588";
              }
              ascii += margin < 1 && y5 + 1 >= max ? blocksLastLineNoMargin[p4] : blocks[p4];
            }
            ascii += "\n";
          }
          if (size % 2 && margin > 0) {
            return ascii.substring(0, ascii.length - size - 1) + Array(size + 1).join("\u2580");
          }
          return ascii.substring(0, ascii.length - 1);
        };
        _this.createASCII = function(cellSize, margin) {
          cellSize = cellSize || 1;
          if (cellSize < 2) {
            return _createHalfASCII(margin);
          }
          cellSize -= 1;
          margin = typeof margin == "undefined" ? cellSize * 2 : margin;
          var size = _this.getModuleCount() * cellSize + margin * 2;
          var min = margin;
          var max = size - margin;
          var y5, x6, r3, p4;
          var white = Array(cellSize + 1).join("\u2588\u2588");
          var black = Array(cellSize + 1).join("  ");
          var ascii = "";
          var line = "";
          for (y5 = 0; y5 < size; y5 += 1) {
            r3 = Math.floor((y5 - min) / cellSize);
            line = "";
            for (x6 = 0; x6 < size; x6 += 1) {
              p4 = 1;
              if (min <= x6 && x6 < max && min <= y5 && y5 < max && _this.isDark(r3, Math.floor((x6 - min) / cellSize))) {
                p4 = 0;
              }
              line += p4 ? white : black;
            }
            for (r3 = 0; r3 < cellSize; r3 += 1) {
              ascii += line + "\n";
            }
          }
          return ascii.substring(0, ascii.length - 1);
        };
        _this.renderTo2dContext = function(context, cellSize) {
          cellSize = cellSize || 2;
          var length = _this.getModuleCount();
          for (var row = 0; row < length; row++) {
            for (var col = 0; col < length; col++) {
              context.fillStyle = _this.isDark(row, col) ? "black" : "white";
              context.fillRect(row * cellSize, col * cellSize, cellSize, cellSize);
            }
          }
        };
        return _this;
      };
      qrcode3.stringToBytesFuncs = {
        "default": function(s5) {
          var bytes = [];
          for (var i4 = 0; i4 < s5.length; i4 += 1) {
            var c4 = s5.charCodeAt(i4);
            bytes.push(c4 & 255);
          }
          return bytes;
        }
      };
      qrcode3.stringToBytes = qrcode3.stringToBytesFuncs["default"];
      qrcode3.createStringToBytes = function(unicodeData, numChars) {
        var unicodeMap = function() {
          var bin = base64DecodeInputStream(unicodeData);
          var read = function() {
            var b4 = bin.read();
            if (b4 == -1)
              throw "eof";
            return b4;
          };
          var count = 0;
          var unicodeMap2 = {};
          while (true) {
            var b0 = bin.read();
            if (b0 == -1)
              break;
            var b1 = read();
            var b22 = read();
            var b32 = read();
            var k5 = String.fromCharCode(b0 << 8 | b1);
            var v3 = b22 << 8 | b32;
            unicodeMap2[k5] = v3;
            count += 1;
          }
          if (count != numChars) {
            throw count + " != " + numChars;
          }
          return unicodeMap2;
        }();
        var unknownChar = "?".charCodeAt(0);
        return function(s5) {
          var bytes = [];
          for (var i4 = 0; i4 < s5.length; i4 += 1) {
            var c4 = s5.charCodeAt(i4);
            if (c4 < 128) {
              bytes.push(c4);
            } else {
              var b4 = unicodeMap[s5.charAt(i4)];
              if (typeof b4 == "number") {
                if ((b4 & 255) == b4) {
                  bytes.push(b4);
                } else {
                  bytes.push(b4 >>> 8);
                  bytes.push(b4 & 255);
                }
              } else {
                bytes.push(unknownChar);
              }
            }
          }
          return bytes;
        };
      };
      var QRMode = {
        MODE_NUMBER: 1 << 0,
        MODE_ALPHA_NUM: 1 << 1,
        MODE_8BIT_BYTE: 1 << 2,
        MODE_KANJI: 1 << 3
      };
      var QRErrorCorrectionLevel = {
        L: 1,
        M: 0,
        Q: 3,
        H: 2
      };
      var QRMaskPattern = {
        PATTERN000: 0,
        PATTERN001: 1,
        PATTERN010: 2,
        PATTERN011: 3,
        PATTERN100: 4,
        PATTERN101: 5,
        PATTERN110: 6,
        PATTERN111: 7
      };
      var QRUtil = function() {
        var PATTERN_POSITION_TABLE = [
          [],
          [6, 18],
          [6, 22],
          [6, 26],
          [6, 30],
          [6, 34],
          [6, 22, 38],
          [6, 24, 42],
          [6, 26, 46],
          [6, 28, 50],
          [6, 30, 54],
          [6, 32, 58],
          [6, 34, 62],
          [6, 26, 46, 66],
          [6, 26, 48, 70],
          [6, 26, 50, 74],
          [6, 30, 54, 78],
          [6, 30, 56, 82],
          [6, 30, 58, 86],
          [6, 34, 62, 90],
          [6, 28, 50, 72, 94],
          [6, 26, 50, 74, 98],
          [6, 30, 54, 78, 102],
          [6, 28, 54, 80, 106],
          [6, 32, 58, 84, 110],
          [6, 30, 58, 86, 114],
          [6, 34, 62, 90, 118],
          [6, 26, 50, 74, 98, 122],
          [6, 30, 54, 78, 102, 126],
          [6, 26, 52, 78, 104, 130],
          [6, 30, 56, 82, 108, 134],
          [6, 34, 60, 86, 112, 138],
          [6, 30, 58, 86, 114, 142],
          [6, 34, 62, 90, 118, 146],
          [6, 30, 54, 78, 102, 126, 150],
          [6, 24, 50, 76, 102, 128, 154],
          [6, 28, 54, 80, 106, 132, 158],
          [6, 32, 58, 84, 110, 136, 162],
          [6, 26, 54, 82, 110, 138, 166],
          [6, 30, 58, 86, 114, 142, 170]
        ];
        var G15 = 1 << 10 | 1 << 8 | 1 << 5 | 1 << 4 | 1 << 2 | 1 << 1 | 1 << 0;
        var G18 = 1 << 12 | 1 << 11 | 1 << 10 | 1 << 9 | 1 << 8 | 1 << 5 | 1 << 2 | 1 << 0;
        var G15_MASK = 1 << 14 | 1 << 12 | 1 << 10 | 1 << 4 | 1 << 1;
        var _this = {};
        var getBCHDigit = function(data) {
          var digit = 0;
          while (data != 0) {
            digit += 1;
            data >>>= 1;
          }
          return digit;
        };
        _this.getBCHTypeInfo = function(data) {
          var d5 = data << 10;
          while (getBCHDigit(d5) - getBCHDigit(G15) >= 0) {
            d5 ^= G15 << getBCHDigit(d5) - getBCHDigit(G15);
          }
          return (data << 10 | d5) ^ G15_MASK;
        };
        _this.getBCHTypeNumber = function(data) {
          var d5 = data << 12;
          while (getBCHDigit(d5) - getBCHDigit(G18) >= 0) {
            d5 ^= G18 << getBCHDigit(d5) - getBCHDigit(G18);
          }
          return data << 12 | d5;
        };
        _this.getPatternPosition = function(typeNumber) {
          return PATTERN_POSITION_TABLE[typeNumber - 1];
        };
        _this.getMaskFunction = function(maskPattern) {
          switch (maskPattern) {
            case QRMaskPattern.PATTERN000:
              return function(i4, j4) {
                return (i4 + j4) % 2 == 0;
              };
            case QRMaskPattern.PATTERN001:
              return function(i4, j4) {
                return i4 % 2 == 0;
              };
            case QRMaskPattern.PATTERN010:
              return function(i4, j4) {
                return j4 % 3 == 0;
              };
            case QRMaskPattern.PATTERN011:
              return function(i4, j4) {
                return (i4 + j4) % 3 == 0;
              };
            case QRMaskPattern.PATTERN100:
              return function(i4, j4) {
                return (Math.floor(i4 / 2) + Math.floor(j4 / 3)) % 2 == 0;
              };
            case QRMaskPattern.PATTERN101:
              return function(i4, j4) {
                return i4 * j4 % 2 + i4 * j4 % 3 == 0;
              };
            case QRMaskPattern.PATTERN110:
              return function(i4, j4) {
                return (i4 * j4 % 2 + i4 * j4 % 3) % 2 == 0;
              };
            case QRMaskPattern.PATTERN111:
              return function(i4, j4) {
                return (i4 * j4 % 3 + (i4 + j4) % 2) % 2 == 0;
              };
            default:
              throw "bad maskPattern:" + maskPattern;
          }
        };
        _this.getErrorCorrectPolynomial = function(errorCorrectLength) {
          var a5 = qrPolynomial([1], 0);
          for (var i4 = 0; i4 < errorCorrectLength; i4 += 1) {
            a5 = a5.multiply(qrPolynomial([1, QRMath.gexp(i4)], 0));
          }
          return a5;
        };
        _this.getLengthInBits = function(mode, type) {
          if (1 <= type && type < 10) {
            switch (mode) {
              case QRMode.MODE_NUMBER:
                return 10;
              case QRMode.MODE_ALPHA_NUM:
                return 9;
              case QRMode.MODE_8BIT_BYTE:
                return 8;
              case QRMode.MODE_KANJI:
                return 8;
              default:
                throw "mode:" + mode;
            }
          } else if (type < 27) {
            switch (mode) {
              case QRMode.MODE_NUMBER:
                return 12;
              case QRMode.MODE_ALPHA_NUM:
                return 11;
              case QRMode.MODE_8BIT_BYTE:
                return 16;
              case QRMode.MODE_KANJI:
                return 10;
              default:
                throw "mode:" + mode;
            }
          } else if (type < 41) {
            switch (mode) {
              case QRMode.MODE_NUMBER:
                return 14;
              case QRMode.MODE_ALPHA_NUM:
                return 13;
              case QRMode.MODE_8BIT_BYTE:
                return 16;
              case QRMode.MODE_KANJI:
                return 12;
              default:
                throw "mode:" + mode;
            }
          } else {
            throw "type:" + type;
          }
        };
        _this.getLostPoint = function(qrcode4) {
          var moduleCount = qrcode4.getModuleCount();
          var lostPoint = 0;
          for (var row = 0; row < moduleCount; row += 1) {
            for (var col = 0; col < moduleCount; col += 1) {
              var sameCount = 0;
              var dark = qrcode4.isDark(row, col);
              for (var r3 = -1; r3 <= 1; r3 += 1) {
                if (row + r3 < 0 || moduleCount <= row + r3) {
                  continue;
                }
                for (var c4 = -1; c4 <= 1; c4 += 1) {
                  if (col + c4 < 0 || moduleCount <= col + c4) {
                    continue;
                  }
                  if (r3 == 0 && c4 == 0) {
                    continue;
                  }
                  if (dark == qrcode4.isDark(row + r3, col + c4)) {
                    sameCount += 1;
                  }
                }
              }
              if (sameCount > 5) {
                lostPoint += 3 + sameCount - 5;
              }
            }
          }
          ;
          for (var row = 0; row < moduleCount - 1; row += 1) {
            for (var col = 0; col < moduleCount - 1; col += 1) {
              var count = 0;
              if (qrcode4.isDark(row, col))
                count += 1;
              if (qrcode4.isDark(row + 1, col))
                count += 1;
              if (qrcode4.isDark(row, col + 1))
                count += 1;
              if (qrcode4.isDark(row + 1, col + 1))
                count += 1;
              if (count == 0 || count == 4) {
                lostPoint += 3;
              }
            }
          }
          for (var row = 0; row < moduleCount; row += 1) {
            for (var col = 0; col < moduleCount - 6; col += 1) {
              if (qrcode4.isDark(row, col) && !qrcode4.isDark(row, col + 1) && qrcode4.isDark(row, col + 2) && qrcode4.isDark(row, col + 3) && qrcode4.isDark(row, col + 4) && !qrcode4.isDark(row, col + 5) && qrcode4.isDark(row, col + 6)) {
                lostPoint += 40;
              }
            }
          }
          for (var col = 0; col < moduleCount; col += 1) {
            for (var row = 0; row < moduleCount - 6; row += 1) {
              if (qrcode4.isDark(row, col) && !qrcode4.isDark(row + 1, col) && qrcode4.isDark(row + 2, col) && qrcode4.isDark(row + 3, col) && qrcode4.isDark(row + 4, col) && !qrcode4.isDark(row + 5, col) && qrcode4.isDark(row + 6, col)) {
                lostPoint += 40;
              }
            }
          }
          var darkCount = 0;
          for (var col = 0; col < moduleCount; col += 1) {
            for (var row = 0; row < moduleCount; row += 1) {
              if (qrcode4.isDark(row, col)) {
                darkCount += 1;
              }
            }
          }
          var ratio = Math.abs(100 * darkCount / moduleCount / moduleCount - 50) / 5;
          lostPoint += ratio * 10;
          return lostPoint;
        };
        return _this;
      }();
      var QRMath = function() {
        var EXP_TABLE = new Array(256);
        var LOG_TABLE = new Array(256);
        for (var i4 = 0; i4 < 8; i4 += 1) {
          EXP_TABLE[i4] = 1 << i4;
        }
        for (var i4 = 8; i4 < 256; i4 += 1) {
          EXP_TABLE[i4] = EXP_TABLE[i4 - 4] ^ EXP_TABLE[i4 - 5] ^ EXP_TABLE[i4 - 6] ^ EXP_TABLE[i4 - 8];
        }
        for (var i4 = 0; i4 < 255; i4 += 1) {
          LOG_TABLE[EXP_TABLE[i4]] = i4;
        }
        var _this = {};
        _this.glog = function(n2) {
          if (n2 < 1) {
            throw "glog(" + n2 + ")";
          }
          return LOG_TABLE[n2];
        };
        _this.gexp = function(n2) {
          while (n2 < 0) {
            n2 += 255;
          }
          while (n2 >= 256) {
            n2 -= 255;
          }
          return EXP_TABLE[n2];
        };
        return _this;
      }();
      function qrPolynomial(num, shift) {
        if (typeof num.length == "undefined") {
          throw num.length + "/" + shift;
        }
        var _num = function() {
          var offset = 0;
          while (offset < num.length && num[offset] == 0) {
            offset += 1;
          }
          var _num2 = new Array(num.length - offset + shift);
          for (var i4 = 0; i4 < num.length - offset; i4 += 1) {
            _num2[i4] = num[i4 + offset];
          }
          return _num2;
        }();
        var _this = {};
        _this.getAt = function(index) {
          return _num[index];
        };
        _this.getLength = function() {
          return _num.length;
        };
        _this.multiply = function(e4) {
          var num2 = new Array(_this.getLength() + e4.getLength() - 1);
          for (var i4 = 0; i4 < _this.getLength(); i4 += 1) {
            for (var j4 = 0; j4 < e4.getLength(); j4 += 1) {
              num2[i4 + j4] ^= QRMath.gexp(QRMath.glog(_this.getAt(i4)) + QRMath.glog(e4.getAt(j4)));
            }
          }
          return qrPolynomial(num2, 0);
        };
        _this.mod = function(e4) {
          if (_this.getLength() - e4.getLength() < 0) {
            return _this;
          }
          var ratio = QRMath.glog(_this.getAt(0)) - QRMath.glog(e4.getAt(0));
          var num2 = new Array(_this.getLength());
          for (var i4 = 0; i4 < _this.getLength(); i4 += 1) {
            num2[i4] = _this.getAt(i4);
          }
          for (var i4 = 0; i4 < e4.getLength(); i4 += 1) {
            num2[i4] ^= QRMath.gexp(QRMath.glog(e4.getAt(i4)) + ratio);
          }
          return qrPolynomial(num2, 0).mod(e4);
        };
        return _this;
      }
      ;
      var QRRSBlock = function() {
        var RS_BLOCK_TABLE = [
          // L
          // M
          // Q
          // H
          // 1
          [1, 26, 19],
          [1, 26, 16],
          [1, 26, 13],
          [1, 26, 9],
          // 2
          [1, 44, 34],
          [1, 44, 28],
          [1, 44, 22],
          [1, 44, 16],
          // 3
          [1, 70, 55],
          [1, 70, 44],
          [2, 35, 17],
          [2, 35, 13],
          // 4
          [1, 100, 80],
          [2, 50, 32],
          [2, 50, 24],
          [4, 25, 9],
          // 5
          [1, 134, 108],
          [2, 67, 43],
          [2, 33, 15, 2, 34, 16],
          [2, 33, 11, 2, 34, 12],
          // 6
          [2, 86, 68],
          [4, 43, 27],
          [4, 43, 19],
          [4, 43, 15],
          // 7
          [2, 98, 78],
          [4, 49, 31],
          [2, 32, 14, 4, 33, 15],
          [4, 39, 13, 1, 40, 14],
          // 8
          [2, 121, 97],
          [2, 60, 38, 2, 61, 39],
          [4, 40, 18, 2, 41, 19],
          [4, 40, 14, 2, 41, 15],
          // 9
          [2, 146, 116],
          [3, 58, 36, 2, 59, 37],
          [4, 36, 16, 4, 37, 17],
          [4, 36, 12, 4, 37, 13],
          // 10
          [2, 86, 68, 2, 87, 69],
          [4, 69, 43, 1, 70, 44],
          [6, 43, 19, 2, 44, 20],
          [6, 43, 15, 2, 44, 16],
          // 11
          [4, 101, 81],
          [1, 80, 50, 4, 81, 51],
          [4, 50, 22, 4, 51, 23],
          [3, 36, 12, 8, 37, 13],
          // 12
          [2, 116, 92, 2, 117, 93],
          [6, 58, 36, 2, 59, 37],
          [4, 46, 20, 6, 47, 21],
          [7, 42, 14, 4, 43, 15],
          // 13
          [4, 133, 107],
          [8, 59, 37, 1, 60, 38],
          [8, 44, 20, 4, 45, 21],
          [12, 33, 11, 4, 34, 12],
          // 14
          [3, 145, 115, 1, 146, 116],
          [4, 64, 40, 5, 65, 41],
          [11, 36, 16, 5, 37, 17],
          [11, 36, 12, 5, 37, 13],
          // 15
          [5, 109, 87, 1, 110, 88],
          [5, 65, 41, 5, 66, 42],
          [5, 54, 24, 7, 55, 25],
          [11, 36, 12, 7, 37, 13],
          // 16
          [5, 122, 98, 1, 123, 99],
          [7, 73, 45, 3, 74, 46],
          [15, 43, 19, 2, 44, 20],
          [3, 45, 15, 13, 46, 16],
          // 17
          [1, 135, 107, 5, 136, 108],
          [10, 74, 46, 1, 75, 47],
          [1, 50, 22, 15, 51, 23],
          [2, 42, 14, 17, 43, 15],
          // 18
          [5, 150, 120, 1, 151, 121],
          [9, 69, 43, 4, 70, 44],
          [17, 50, 22, 1, 51, 23],
          [2, 42, 14, 19, 43, 15],
          // 19
          [3, 141, 113, 4, 142, 114],
          [3, 70, 44, 11, 71, 45],
          [17, 47, 21, 4, 48, 22],
          [9, 39, 13, 16, 40, 14],
          // 20
          [3, 135, 107, 5, 136, 108],
          [3, 67, 41, 13, 68, 42],
          [15, 54, 24, 5, 55, 25],
          [15, 43, 15, 10, 44, 16],
          // 21
          [4, 144, 116, 4, 145, 117],
          [17, 68, 42],
          [17, 50, 22, 6, 51, 23],
          [19, 46, 16, 6, 47, 17],
          // 22
          [2, 139, 111, 7, 140, 112],
          [17, 74, 46],
          [7, 54, 24, 16, 55, 25],
          [34, 37, 13],
          // 23
          [4, 151, 121, 5, 152, 122],
          [4, 75, 47, 14, 76, 48],
          [11, 54, 24, 14, 55, 25],
          [16, 45, 15, 14, 46, 16],
          // 24
          [6, 147, 117, 4, 148, 118],
          [6, 73, 45, 14, 74, 46],
          [11, 54, 24, 16, 55, 25],
          [30, 46, 16, 2, 47, 17],
          // 25
          [8, 132, 106, 4, 133, 107],
          [8, 75, 47, 13, 76, 48],
          [7, 54, 24, 22, 55, 25],
          [22, 45, 15, 13, 46, 16],
          // 26
          [10, 142, 114, 2, 143, 115],
          [19, 74, 46, 4, 75, 47],
          [28, 50, 22, 6, 51, 23],
          [33, 46, 16, 4, 47, 17],
          // 27
          [8, 152, 122, 4, 153, 123],
          [22, 73, 45, 3, 74, 46],
          [8, 53, 23, 26, 54, 24],
          [12, 45, 15, 28, 46, 16],
          // 28
          [3, 147, 117, 10, 148, 118],
          [3, 73, 45, 23, 74, 46],
          [4, 54, 24, 31, 55, 25],
          [11, 45, 15, 31, 46, 16],
          // 29
          [7, 146, 116, 7, 147, 117],
          [21, 73, 45, 7, 74, 46],
          [1, 53, 23, 37, 54, 24],
          [19, 45, 15, 26, 46, 16],
          // 30
          [5, 145, 115, 10, 146, 116],
          [19, 75, 47, 10, 76, 48],
          [15, 54, 24, 25, 55, 25],
          [23, 45, 15, 25, 46, 16],
          // 31
          [13, 145, 115, 3, 146, 116],
          [2, 74, 46, 29, 75, 47],
          [42, 54, 24, 1, 55, 25],
          [23, 45, 15, 28, 46, 16],
          // 32
          [17, 145, 115],
          [10, 74, 46, 23, 75, 47],
          [10, 54, 24, 35, 55, 25],
          [19, 45, 15, 35, 46, 16],
          // 33
          [17, 145, 115, 1, 146, 116],
          [14, 74, 46, 21, 75, 47],
          [29, 54, 24, 19, 55, 25],
          [11, 45, 15, 46, 46, 16],
          // 34
          [13, 145, 115, 6, 146, 116],
          [14, 74, 46, 23, 75, 47],
          [44, 54, 24, 7, 55, 25],
          [59, 46, 16, 1, 47, 17],
          // 35
          [12, 151, 121, 7, 152, 122],
          [12, 75, 47, 26, 76, 48],
          [39, 54, 24, 14, 55, 25],
          [22, 45, 15, 41, 46, 16],
          // 36
          [6, 151, 121, 14, 152, 122],
          [6, 75, 47, 34, 76, 48],
          [46, 54, 24, 10, 55, 25],
          [2, 45, 15, 64, 46, 16],
          // 37
          [17, 152, 122, 4, 153, 123],
          [29, 74, 46, 14, 75, 47],
          [49, 54, 24, 10, 55, 25],
          [24, 45, 15, 46, 46, 16],
          // 38
          [4, 152, 122, 18, 153, 123],
          [13, 74, 46, 32, 75, 47],
          [48, 54, 24, 14, 55, 25],
          [42, 45, 15, 32, 46, 16],
          // 39
          [20, 147, 117, 4, 148, 118],
          [40, 75, 47, 7, 76, 48],
          [43, 54, 24, 22, 55, 25],
          [10, 45, 15, 67, 46, 16],
          // 40
          [19, 148, 118, 6, 149, 119],
          [18, 75, 47, 31, 76, 48],
          [34, 54, 24, 34, 55, 25],
          [20, 45, 15, 61, 46, 16]
        ];
        var qrRSBlock = function(totalCount, dataCount) {
          var _this2 = {};
          _this2.totalCount = totalCount;
          _this2.dataCount = dataCount;
          return _this2;
        };
        var _this = {};
        var getRsBlockTable = function(typeNumber, errorCorrectionLevel) {
          switch (errorCorrectionLevel) {
            case QRErrorCorrectionLevel.L:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 0];
            case QRErrorCorrectionLevel.M:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 1];
            case QRErrorCorrectionLevel.Q:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 2];
            case QRErrorCorrectionLevel.H:
              return RS_BLOCK_TABLE[(typeNumber - 1) * 4 + 3];
            default:
              return void 0;
          }
        };
        _this.getRSBlocks = function(typeNumber, errorCorrectionLevel) {
          var rsBlock = getRsBlockTable(typeNumber, errorCorrectionLevel);
          if (typeof rsBlock == "undefined") {
            throw "bad rs block @ typeNumber:" + typeNumber + "/errorCorrectionLevel:" + errorCorrectionLevel;
          }
          var length = rsBlock.length / 3;
          var list = [];
          for (var i4 = 0; i4 < length; i4 += 1) {
            var count = rsBlock[i4 * 3 + 0];
            var totalCount = rsBlock[i4 * 3 + 1];
            var dataCount = rsBlock[i4 * 3 + 2];
            for (var j4 = 0; j4 < count; j4 += 1) {
              list.push(qrRSBlock(totalCount, dataCount));
            }
          }
          return list;
        };
        return _this;
      }();
      var qrBitBuffer = function() {
        var _buffer = [];
        var _length = 0;
        var _this = {};
        _this.getBuffer = function() {
          return _buffer;
        };
        _this.getAt = function(index) {
          var bufIndex = Math.floor(index / 8);
          return (_buffer[bufIndex] >>> 7 - index % 8 & 1) == 1;
        };
        _this.put = function(num, length) {
          for (var i4 = 0; i4 < length; i4 += 1) {
            _this.putBit((num >>> length - i4 - 1 & 1) == 1);
          }
        };
        _this.getLengthInBits = function() {
          return _length;
        };
        _this.putBit = function(bit) {
          var bufIndex = Math.floor(_length / 8);
          if (_buffer.length <= bufIndex) {
            _buffer.push(0);
          }
          if (bit) {
            _buffer[bufIndex] |= 128 >>> _length % 8;
          }
          _length += 1;
        };
        return _this;
      };
      var qrNumber = function(data) {
        var _mode = QRMode.MODE_NUMBER;
        var _data = data;
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return _data.length;
        };
        _this.write = function(buffer) {
          var data2 = _data;
          var i4 = 0;
          while (i4 + 2 < data2.length) {
            buffer.put(strToNum(data2.substring(i4, i4 + 3)), 10);
            i4 += 3;
          }
          if (i4 < data2.length) {
            if (data2.length - i4 == 1) {
              buffer.put(strToNum(data2.substring(i4, i4 + 1)), 4);
            } else if (data2.length - i4 == 2) {
              buffer.put(strToNum(data2.substring(i4, i4 + 2)), 7);
            }
          }
        };
        var strToNum = function(s5) {
          var num = 0;
          for (var i4 = 0; i4 < s5.length; i4 += 1) {
            num = num * 10 + chatToNum(s5.charAt(i4));
          }
          return num;
        };
        var chatToNum = function(c4) {
          if ("0" <= c4 && c4 <= "9") {
            return c4.charCodeAt(0) - "0".charCodeAt(0);
          }
          throw "illegal char :" + c4;
        };
        return _this;
      };
      var qrAlphaNum = function(data) {
        var _mode = QRMode.MODE_ALPHA_NUM;
        var _data = data;
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return _data.length;
        };
        _this.write = function(buffer) {
          var s5 = _data;
          var i4 = 0;
          while (i4 + 1 < s5.length) {
            buffer.put(
              getCode(s5.charAt(i4)) * 45 + getCode(s5.charAt(i4 + 1)),
              11
            );
            i4 += 2;
          }
          if (i4 < s5.length) {
            buffer.put(getCode(s5.charAt(i4)), 6);
          }
        };
        var getCode = function(c4) {
          if ("0" <= c4 && c4 <= "9") {
            return c4.charCodeAt(0) - "0".charCodeAt(0);
          } else if ("A" <= c4 && c4 <= "Z") {
            return c4.charCodeAt(0) - "A".charCodeAt(0) + 10;
          } else {
            switch (c4) {
              case " ":
                return 36;
              case "$":
                return 37;
              case "%":
                return 38;
              case "*":
                return 39;
              case "+":
                return 40;
              case "-":
                return 41;
              case ".":
                return 42;
              case "/":
                return 43;
              case ":":
                return 44;
              default:
                throw "illegal char :" + c4;
            }
          }
        };
        return _this;
      };
      var qr8BitByte = function(data) {
        var _mode = QRMode.MODE_8BIT_BYTE;
        var _data = data;
        var _bytes = qrcode3.stringToBytes(data);
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return _bytes.length;
        };
        _this.write = function(buffer) {
          for (var i4 = 0; i4 < _bytes.length; i4 += 1) {
            buffer.put(_bytes[i4], 8);
          }
        };
        return _this;
      };
      var qrKanji = function(data) {
        var _mode = QRMode.MODE_KANJI;
        var _data = data;
        var stringToBytes2 = qrcode3.stringToBytesFuncs["SJIS"];
        if (!stringToBytes2) {
          throw "sjis not supported.";
        }
        !function(c4, code) {
          var test = stringToBytes2(c4);
          if (test.length != 2 || (test[0] << 8 | test[1]) != code) {
            throw "sjis not supported.";
          }
        }("\u53CB", 38726);
        var _bytes = stringToBytes2(data);
        var _this = {};
        _this.getMode = function() {
          return _mode;
        };
        _this.getLength = function(buffer) {
          return ~~(_bytes.length / 2);
        };
        _this.write = function(buffer) {
          var data2 = _bytes;
          var i4 = 0;
          while (i4 + 1 < data2.length) {
            var c4 = (255 & data2[i4]) << 8 | 255 & data2[i4 + 1];
            if (33088 <= c4 && c4 <= 40956) {
              c4 -= 33088;
            } else if (57408 <= c4 && c4 <= 60351) {
              c4 -= 49472;
            } else {
              throw "illegal char at " + (i4 + 1) + "/" + c4;
            }
            c4 = (c4 >>> 8 & 255) * 192 + (c4 & 255);
            buffer.put(c4, 13);
            i4 += 2;
          }
          if (i4 < data2.length) {
            throw "illegal char at " + (i4 + 1);
          }
        };
        return _this;
      };
      var byteArrayOutputStream = function() {
        var _bytes = [];
        var _this = {};
        _this.writeByte = function(b4) {
          _bytes.push(b4 & 255);
        };
        _this.writeShort = function(i4) {
          _this.writeByte(i4);
          _this.writeByte(i4 >>> 8);
        };
        _this.writeBytes = function(b4, off, len) {
          off = off || 0;
          len = len || b4.length;
          for (var i4 = 0; i4 < len; i4 += 1) {
            _this.writeByte(b4[i4 + off]);
          }
        };
        _this.writeString = function(s5) {
          for (var i4 = 0; i4 < s5.length; i4 += 1) {
            _this.writeByte(s5.charCodeAt(i4));
          }
        };
        _this.toByteArray = function() {
          return _bytes;
        };
        _this.toString = function() {
          var s5 = "";
          s5 += "[";
          for (var i4 = 0; i4 < _bytes.length; i4 += 1) {
            if (i4 > 0) {
              s5 += ",";
            }
            s5 += _bytes[i4];
          }
          s5 += "]";
          return s5;
        };
        return _this;
      };
      var base64EncodeOutputStream = function() {
        var _buffer = 0;
        var _buflen = 0;
        var _length = 0;
        var _base64 = "";
        var _this = {};
        var writeEncoded = function(b4) {
          _base64 += String.fromCharCode(encode4(b4 & 63));
        };
        var encode4 = function(n2) {
          if (n2 < 0) {
          } else if (n2 < 26) {
            return 65 + n2;
          } else if (n2 < 52) {
            return 97 + (n2 - 26);
          } else if (n2 < 62) {
            return 48 + (n2 - 52);
          } else if (n2 == 62) {
            return 43;
          } else if (n2 == 63) {
            return 47;
          }
          throw "n:" + n2;
        };
        _this.writeByte = function(n2) {
          _buffer = _buffer << 8 | n2 & 255;
          _buflen += 8;
          _length += 1;
          while (_buflen >= 6) {
            writeEncoded(_buffer >>> _buflen - 6);
            _buflen -= 6;
          }
        };
        _this.flush = function() {
          if (_buflen > 0) {
            writeEncoded(_buffer << 6 - _buflen);
            _buffer = 0;
            _buflen = 0;
          }
          if (_length % 3 != 0) {
            var padlen = 3 - _length % 3;
            for (var i4 = 0; i4 < padlen; i4 += 1) {
              _base64 += "=";
            }
          }
        };
        _this.toString = function() {
          return _base64;
        };
        return _this;
      };
      var base64DecodeInputStream = function(str) {
        var _str = str;
        var _pos = 0;
        var _buffer = 0;
        var _buflen = 0;
        var _this = {};
        _this.read = function() {
          while (_buflen < 8) {
            if (_pos >= _str.length) {
              if (_buflen == 0) {
                return -1;
              }
              throw "unexpected end of file./" + _buflen;
            }
            var c4 = _str.charAt(_pos);
            _pos += 1;
            if (c4 == "=") {
              _buflen = 0;
              return -1;
            } else if (c4.match(/^\s$/)) {
              continue;
            }
            _buffer = _buffer << 6 | decode4(c4.charCodeAt(0));
            _buflen += 6;
          }
          var n2 = _buffer >>> _buflen - 8 & 255;
          _buflen -= 8;
          return n2;
        };
        var decode4 = function(c4) {
          if (65 <= c4 && c4 <= 90) {
            return c4 - 65;
          } else if (97 <= c4 && c4 <= 122) {
            return c4 - 97 + 26;
          } else if (48 <= c4 && c4 <= 57) {
            return c4 - 48 + 52;
          } else if (c4 == 43) {
            return 62;
          } else if (c4 == 47) {
            return 63;
          } else {
            throw "c:" + c4;
          }
        };
        return _this;
      };
      var gifImage = function(width, height) {
        var _width = width;
        var _height = height;
        var _data = new Array(width * height);
        var _this = {};
        _this.setPixel = function(x6, y5, pixel) {
          _data[y5 * _width + x6] = pixel;
        };
        _this.write = function(out) {
          out.writeString("GIF87a");
          out.writeShort(_width);
          out.writeShort(_height);
          out.writeByte(128);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(0);
          out.writeByte(255);
          out.writeByte(255);
          out.writeByte(255);
          out.writeString(",");
          out.writeShort(0);
          out.writeShort(0);
          out.writeShort(_width);
          out.writeShort(_height);
          out.writeByte(0);
          var lzwMinCodeSize = 2;
          var raster = getLZWRaster(lzwMinCodeSize);
          out.writeByte(lzwMinCodeSize);
          var offset = 0;
          while (raster.length - offset > 255) {
            out.writeByte(255);
            out.writeBytes(raster, offset, 255);
            offset += 255;
          }
          out.writeByte(raster.length - offset);
          out.writeBytes(raster, offset, raster.length - offset);
          out.writeByte(0);
          out.writeString(";");
        };
        var bitOutputStream = function(out) {
          var _out = out;
          var _bitLength = 0;
          var _bitBuffer = 0;
          var _this2 = {};
          _this2.write = function(data, length) {
            if (data >>> length != 0) {
              throw "length over";
            }
            while (_bitLength + length >= 8) {
              _out.writeByte(255 & (data << _bitLength | _bitBuffer));
              length -= 8 - _bitLength;
              data >>>= 8 - _bitLength;
              _bitBuffer = 0;
              _bitLength = 0;
            }
            _bitBuffer = data << _bitLength | _bitBuffer;
            _bitLength = _bitLength + length;
          };
          _this2.flush = function() {
            if (_bitLength > 0) {
              _out.writeByte(_bitBuffer);
            }
          };
          return _this2;
        };
        var getLZWRaster = function(lzwMinCodeSize) {
          var clearCode = 1 << lzwMinCodeSize;
          var endCode = (1 << lzwMinCodeSize) + 1;
          var bitLength = lzwMinCodeSize + 1;
          var table2 = lzwTable();
          for (var i4 = 0; i4 < clearCode; i4 += 1) {
            table2.add(String.fromCharCode(i4));
          }
          table2.add(String.fromCharCode(clearCode));
          table2.add(String.fromCharCode(endCode));
          var byteOut = byteArrayOutputStream();
          var bitOut = bitOutputStream(byteOut);
          bitOut.write(clearCode, bitLength);
          var dataIndex = 0;
          var s5 = String.fromCharCode(_data[dataIndex]);
          dataIndex += 1;
          while (dataIndex < _data.length) {
            var c4 = String.fromCharCode(_data[dataIndex]);
            dataIndex += 1;
            if (table2.contains(s5 + c4)) {
              s5 = s5 + c4;
            } else {
              bitOut.write(table2.indexOf(s5), bitLength);
              if (table2.size() < 4095) {
                if (table2.size() == 1 << bitLength) {
                  bitLength += 1;
                }
                table2.add(s5 + c4);
              }
              s5 = c4;
            }
          }
          bitOut.write(table2.indexOf(s5), bitLength);
          bitOut.write(endCode, bitLength);
          bitOut.flush();
          return byteOut.toByteArray();
        };
        var lzwTable = function() {
          var _map = {};
          var _size = 0;
          var _this2 = {};
          _this2.add = function(key) {
            if (_this2.contains(key)) {
              throw "dup key:" + key;
            }
            _map[key] = _size;
            _size += 1;
          };
          _this2.size = function() {
            return _size;
          };
          _this2.indexOf = function(key) {
            return _map[key];
          };
          _this2.contains = function(key) {
            return typeof _map[key] != "undefined";
          };
          return _this2;
        };
        return _this;
      };
      var createDataURL = function(width, height, getPixel) {
        var gif = gifImage(width, height);
        for (var y5 = 0; y5 < height; y5 += 1) {
          for (var x6 = 0; x6 < width; x6 += 1) {
            gif.setPixel(x6, y5, getPixel(x6, y5));
          }
        }
        var b4 = byteArrayOutputStream();
        gif.write(b4);
        var base64 = base64EncodeOutputStream();
        var bytes = b4.toByteArray();
        for (var i4 = 0; i4 < bytes.length; i4 += 1) {
          base64.writeByte(bytes[i4]);
        }
        base64.flush();
        return "data:image/gif;base64," + base64;
      };
      return qrcode3;
    }();
    !function() {
      qrcode2.stringToBytesFuncs["UTF-8"] = function(s5) {
        function toUTF8Array(str) {
          var utf8 = [];
          for (var i4 = 0; i4 < str.length; i4++) {
            var charcode = str.charCodeAt(i4);
            if (charcode < 128)
              utf8.push(charcode);
            else if (charcode < 2048) {
              utf8.push(
                192 | charcode >> 6,
                128 | charcode & 63
              );
            } else if (charcode < 55296 || charcode >= 57344) {
              utf8.push(
                224 | charcode >> 12,
                128 | charcode >> 6 & 63,
                128 | charcode & 63
              );
            } else {
              i4++;
              charcode = 65536 + ((charcode & 1023) << 10 | str.charCodeAt(i4) & 1023);
              utf8.push(
                240 | charcode >> 18,
                128 | charcode >> 12 & 63,
                128 | charcode >> 6 & 63,
                128 | charcode & 63
              );
            }
          }
          return utf8;
        }
        return toUTF8Array(s5);
      };
    }();
    (function(factory) {
      if (typeof define === "function" && define.amd) {
        define([], factory);
      } else if (typeof exports === "object") {
        module.exports = factory();
      }
    })(function() {
      return qrcode2;
    });
  }
});

// ../taler-util/lib/nacl-fast.js
var gf = function(init = []) {
  const r3 = new Float64Array(16);
  if (init)
    for (let i4 = 0; i4 < init.length; i4++)
      r3[i4] = init[i4];
  return r3;
};
var randombytes = function(x6, n2) {
  throw new Error("no PRNG");
};
var _9 = new Uint8Array(32);
_9[0] = 9;
var gf0 = gf();
var gf1 = gf([1]);
var _121665 = gf([56129, 1]);
var D = gf([
  30883,
  4953,
  19914,
  30187,
  55467,
  16705,
  2637,
  112,
  59544,
  30585,
  16505,
  36039,
  65139,
  11119,
  27886,
  20995
]);
var D2 = gf([
  61785,
  9906,
  39828,
  60374,
  45398,
  33411,
  5274,
  224,
  53552,
  61171,
  33010,
  6542,
  64743,
  22239,
  55772,
  9222
]);
var X = gf([
  54554,
  36645,
  11616,
  51542,
  42930,
  38181,
  51040,
  26924,
  56412,
  64982,
  57905,
  49316,
  21502,
  52590,
  14035,
  8553
]);
var Y = gf([
  26200,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214
]);
var I = gf([
  41136,
  18958,
  6951,
  50414,
  58488,
  44335,
  6150,
  12099,
  55207,
  15867,
  153,
  11085,
  57099,
  20417,
  9344,
  11139
]);
function ts64(x6, i4, h5, l3) {
  x6[i4] = h5 >> 24 & 255;
  x6[i4 + 1] = h5 >> 16 & 255;
  x6[i4 + 2] = h5 >> 8 & 255;
  x6[i4 + 3] = h5 & 255;
  x6[i4 + 4] = l3 >> 24 & 255;
  x6[i4 + 5] = l3 >> 16 & 255;
  x6[i4 + 6] = l3 >> 8 & 255;
  x6[i4 + 7] = l3 & 255;
}
function vn(x6, xi, y5, yi, n2) {
  let i4, d5 = 0;
  for (i4 = 0; i4 < n2; i4++)
    d5 |= x6[xi + i4] ^ y5[yi + i4];
  return (1 & d5 - 1 >>> 8) - 1;
}
function crypto_verify_32(x6, xi, y5, yi) {
  return vn(x6, xi, y5, yi, 32);
}
var sigma = new Uint8Array([
  101,
  120,
  112,
  97,
  110,
  100,
  32,
  51,
  50,
  45,
  98,
  121,
  116,
  101,
  32,
  107
]);
function set25519(r3, a5) {
  let i4;
  for (i4 = 0; i4 < 16; i4++)
    r3[i4] = a5[i4] | 0;
}
function car25519(o3) {
  let i4, v3, c4 = 1;
  for (i4 = 0; i4 < 16; i4++) {
    v3 = o3[i4] + c4 + 65535;
    c4 = Math.floor(v3 / 65536);
    o3[i4] = v3 - c4 * 65536;
  }
  o3[0] += c4 - 1 + 37 * (c4 - 1);
}
function sel25519(p4, q5, b4) {
  let t4;
  const c4 = ~(b4 - 1);
  for (let i4 = 0; i4 < 16; i4++) {
    t4 = c4 & (p4[i4] ^ q5[i4]);
    p4[i4] ^= t4;
    q5[i4] ^= t4;
  }
}
function pack25519(o3, n2) {
  let i4, j4, b4;
  const m5 = gf(), t4 = gf();
  for (i4 = 0; i4 < 16; i4++)
    t4[i4] = n2[i4];
  car25519(t4);
  car25519(t4);
  car25519(t4);
  for (j4 = 0; j4 < 2; j4++) {
    m5[0] = t4[0] - 65517;
    for (i4 = 1; i4 < 15; i4++) {
      m5[i4] = t4[i4] - 65535 - (m5[i4 - 1] >> 16 & 1);
      m5[i4 - 1] &= 65535;
    }
    m5[15] = t4[15] - 32767 - (m5[14] >> 16 & 1);
    b4 = m5[15] >> 16 & 1;
    m5[14] &= 65535;
    sel25519(t4, m5, 1 - b4);
  }
  for (i4 = 0; i4 < 16; i4++) {
    o3[2 * i4] = t4[i4] & 255;
    o3[2 * i4 + 1] = t4[i4] >> 8;
  }
}
function neq25519(a5, b4) {
  const c4 = new Uint8Array(32), d5 = new Uint8Array(32);
  pack25519(c4, a5);
  pack25519(d5, b4);
  return crypto_verify_32(c4, 0, d5, 0);
}
function par25519(a5) {
  const d5 = new Uint8Array(32);
  pack25519(d5, a5);
  return d5[0] & 1;
}
function unpack25519(o3, n2) {
  let i4;
  for (i4 = 0; i4 < 16; i4++)
    o3[i4] = n2[2 * i4] + (n2[2 * i4 + 1] << 8);
  o3[15] &= 32767;
}
function A(o3, a5, b4) {
  for (let i4 = 0; i4 < 16; i4++)
    o3[i4] = a5[i4] + b4[i4];
}
function Z(o3, a5, b4) {
  for (let i4 = 0; i4 < 16; i4++)
    o3[i4] = a5[i4] - b4[i4];
}
function M(o3, a5, b4) {
  let v3, c4, t0 = 0, t1 = 0, t22 = 0, t32 = 0, t4 = 0, t5 = 0, t6 = 0, t7 = 0, t8 = 0, t9 = 0, t10 = 0, t11 = 0, t12 = 0, t13 = 0, t14 = 0, t15 = 0, t16 = 0, t17 = 0, t18 = 0, t19 = 0, t20 = 0, t21 = 0, t222 = 0, t23 = 0, t24 = 0, t25 = 0, t26 = 0, t27 = 0, t28 = 0, t29 = 0, t30 = 0;
  const b0 = b4[0], b1 = b4[1], b22 = b4[2], b32 = b4[3], b42 = b4[4], b5 = b4[5], b6 = b4[6], b7 = b4[7], b8 = b4[8], b9 = b4[9], b10 = b4[10], b11 = b4[11], b12 = b4[12], b13 = b4[13], b14 = b4[14], b15 = b4[15];
  v3 = a5[0];
  t0 += v3 * b0;
  t1 += v3 * b1;
  t22 += v3 * b22;
  t32 += v3 * b32;
  t4 += v3 * b42;
  t5 += v3 * b5;
  t6 += v3 * b6;
  t7 += v3 * b7;
  t8 += v3 * b8;
  t9 += v3 * b9;
  t10 += v3 * b10;
  t11 += v3 * b11;
  t12 += v3 * b12;
  t13 += v3 * b13;
  t14 += v3 * b14;
  t15 += v3 * b15;
  v3 = a5[1];
  t1 += v3 * b0;
  t22 += v3 * b1;
  t32 += v3 * b22;
  t4 += v3 * b32;
  t5 += v3 * b42;
  t6 += v3 * b5;
  t7 += v3 * b6;
  t8 += v3 * b7;
  t9 += v3 * b8;
  t10 += v3 * b9;
  t11 += v3 * b10;
  t12 += v3 * b11;
  t13 += v3 * b12;
  t14 += v3 * b13;
  t15 += v3 * b14;
  t16 += v3 * b15;
  v3 = a5[2];
  t22 += v3 * b0;
  t32 += v3 * b1;
  t4 += v3 * b22;
  t5 += v3 * b32;
  t6 += v3 * b42;
  t7 += v3 * b5;
  t8 += v3 * b6;
  t9 += v3 * b7;
  t10 += v3 * b8;
  t11 += v3 * b9;
  t12 += v3 * b10;
  t13 += v3 * b11;
  t14 += v3 * b12;
  t15 += v3 * b13;
  t16 += v3 * b14;
  t17 += v3 * b15;
  v3 = a5[3];
  t32 += v3 * b0;
  t4 += v3 * b1;
  t5 += v3 * b22;
  t6 += v3 * b32;
  t7 += v3 * b42;
  t8 += v3 * b5;
  t9 += v3 * b6;
  t10 += v3 * b7;
  t11 += v3 * b8;
  t12 += v3 * b9;
  t13 += v3 * b10;
  t14 += v3 * b11;
  t15 += v3 * b12;
  t16 += v3 * b13;
  t17 += v3 * b14;
  t18 += v3 * b15;
  v3 = a5[4];
  t4 += v3 * b0;
  t5 += v3 * b1;
  t6 += v3 * b22;
  t7 += v3 * b32;
  t8 += v3 * b42;
  t9 += v3 * b5;
  t10 += v3 * b6;
  t11 += v3 * b7;
  t12 += v3 * b8;
  t13 += v3 * b9;
  t14 += v3 * b10;
  t15 += v3 * b11;
  t16 += v3 * b12;
  t17 += v3 * b13;
  t18 += v3 * b14;
  t19 += v3 * b15;
  v3 = a5[5];
  t5 += v3 * b0;
  t6 += v3 * b1;
  t7 += v3 * b22;
  t8 += v3 * b32;
  t9 += v3 * b42;
  t10 += v3 * b5;
  t11 += v3 * b6;
  t12 += v3 * b7;
  t13 += v3 * b8;
  t14 += v3 * b9;
  t15 += v3 * b10;
  t16 += v3 * b11;
  t17 += v3 * b12;
  t18 += v3 * b13;
  t19 += v3 * b14;
  t20 += v3 * b15;
  v3 = a5[6];
  t6 += v3 * b0;
  t7 += v3 * b1;
  t8 += v3 * b22;
  t9 += v3 * b32;
  t10 += v3 * b42;
  t11 += v3 * b5;
  t12 += v3 * b6;
  t13 += v3 * b7;
  t14 += v3 * b8;
  t15 += v3 * b9;
  t16 += v3 * b10;
  t17 += v3 * b11;
  t18 += v3 * b12;
  t19 += v3 * b13;
  t20 += v3 * b14;
  t21 += v3 * b15;
  v3 = a5[7];
  t7 += v3 * b0;
  t8 += v3 * b1;
  t9 += v3 * b22;
  t10 += v3 * b32;
  t11 += v3 * b42;
  t12 += v3 * b5;
  t13 += v3 * b6;
  t14 += v3 * b7;
  t15 += v3 * b8;
  t16 += v3 * b9;
  t17 += v3 * b10;
  t18 += v3 * b11;
  t19 += v3 * b12;
  t20 += v3 * b13;
  t21 += v3 * b14;
  t222 += v3 * b15;
  v3 = a5[8];
  t8 += v3 * b0;
  t9 += v3 * b1;
  t10 += v3 * b22;
  t11 += v3 * b32;
  t12 += v3 * b42;
  t13 += v3 * b5;
  t14 += v3 * b6;
  t15 += v3 * b7;
  t16 += v3 * b8;
  t17 += v3 * b9;
  t18 += v3 * b10;
  t19 += v3 * b11;
  t20 += v3 * b12;
  t21 += v3 * b13;
  t222 += v3 * b14;
  t23 += v3 * b15;
  v3 = a5[9];
  t9 += v3 * b0;
  t10 += v3 * b1;
  t11 += v3 * b22;
  t12 += v3 * b32;
  t13 += v3 * b42;
  t14 += v3 * b5;
  t15 += v3 * b6;
  t16 += v3 * b7;
  t17 += v3 * b8;
  t18 += v3 * b9;
  t19 += v3 * b10;
  t20 += v3 * b11;
  t21 += v3 * b12;
  t222 += v3 * b13;
  t23 += v3 * b14;
  t24 += v3 * b15;
  v3 = a5[10];
  t10 += v3 * b0;
  t11 += v3 * b1;
  t12 += v3 * b22;
  t13 += v3 * b32;
  t14 += v3 * b42;
  t15 += v3 * b5;
  t16 += v3 * b6;
  t17 += v3 * b7;
  t18 += v3 * b8;
  t19 += v3 * b9;
  t20 += v3 * b10;
  t21 += v3 * b11;
  t222 += v3 * b12;
  t23 += v3 * b13;
  t24 += v3 * b14;
  t25 += v3 * b15;
  v3 = a5[11];
  t11 += v3 * b0;
  t12 += v3 * b1;
  t13 += v3 * b22;
  t14 += v3 * b32;
  t15 += v3 * b42;
  t16 += v3 * b5;
  t17 += v3 * b6;
  t18 += v3 * b7;
  t19 += v3 * b8;
  t20 += v3 * b9;
  t21 += v3 * b10;
  t222 += v3 * b11;
  t23 += v3 * b12;
  t24 += v3 * b13;
  t25 += v3 * b14;
  t26 += v3 * b15;
  v3 = a5[12];
  t12 += v3 * b0;
  t13 += v3 * b1;
  t14 += v3 * b22;
  t15 += v3 * b32;
  t16 += v3 * b42;
  t17 += v3 * b5;
  t18 += v3 * b6;
  t19 += v3 * b7;
  t20 += v3 * b8;
  t21 += v3 * b9;
  t222 += v3 * b10;
  t23 += v3 * b11;
  t24 += v3 * b12;
  t25 += v3 * b13;
  t26 += v3 * b14;
  t27 += v3 * b15;
  v3 = a5[13];
  t13 += v3 * b0;
  t14 += v3 * b1;
  t15 += v3 * b22;
  t16 += v3 * b32;
  t17 += v3 * b42;
  t18 += v3 * b5;
  t19 += v3 * b6;
  t20 += v3 * b7;
  t21 += v3 * b8;
  t222 += v3 * b9;
  t23 += v3 * b10;
  t24 += v3 * b11;
  t25 += v3 * b12;
  t26 += v3 * b13;
  t27 += v3 * b14;
  t28 += v3 * b15;
  v3 = a5[14];
  t14 += v3 * b0;
  t15 += v3 * b1;
  t16 += v3 * b22;
  t17 += v3 * b32;
  t18 += v3 * b42;
  t19 += v3 * b5;
  t20 += v3 * b6;
  t21 += v3 * b7;
  t222 += v3 * b8;
  t23 += v3 * b9;
  t24 += v3 * b10;
  t25 += v3 * b11;
  t26 += v3 * b12;
  t27 += v3 * b13;
  t28 += v3 * b14;
  t29 += v3 * b15;
  v3 = a5[15];
  t15 += v3 * b0;
  t16 += v3 * b1;
  t17 += v3 * b22;
  t18 += v3 * b32;
  t19 += v3 * b42;
  t20 += v3 * b5;
  t21 += v3 * b6;
  t222 += v3 * b7;
  t23 += v3 * b8;
  t24 += v3 * b9;
  t25 += v3 * b10;
  t26 += v3 * b11;
  t27 += v3 * b12;
  t28 += v3 * b13;
  t29 += v3 * b14;
  t30 += v3 * b15;
  t0 += 38 * t16;
  t1 += 38 * t17;
  t22 += 38 * t18;
  t32 += 38 * t19;
  t4 += 38 * t20;
  t5 += 38 * t21;
  t6 += 38 * t222;
  t7 += 38 * t23;
  t8 += 38 * t24;
  t9 += 38 * t25;
  t10 += 38 * t26;
  t11 += 38 * t27;
  t12 += 38 * t28;
  t13 += 38 * t29;
  t14 += 38 * t30;
  c4 = 1;
  v3 = t0 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t0 = v3 - c4 * 65536;
  v3 = t1 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t1 = v3 - c4 * 65536;
  v3 = t22 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t22 = v3 - c4 * 65536;
  v3 = t32 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t32 = v3 - c4 * 65536;
  v3 = t4 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t4 = v3 - c4 * 65536;
  v3 = t5 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t5 = v3 - c4 * 65536;
  v3 = t6 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t6 = v3 - c4 * 65536;
  v3 = t7 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t7 = v3 - c4 * 65536;
  v3 = t8 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t8 = v3 - c4 * 65536;
  v3 = t9 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t9 = v3 - c4 * 65536;
  v3 = t10 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t10 = v3 - c4 * 65536;
  v3 = t11 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t11 = v3 - c4 * 65536;
  v3 = t12 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t12 = v3 - c4 * 65536;
  v3 = t13 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t13 = v3 - c4 * 65536;
  v3 = t14 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t14 = v3 - c4 * 65536;
  v3 = t15 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t15 = v3 - c4 * 65536;
  t0 += c4 - 1 + 37 * (c4 - 1);
  c4 = 1;
  v3 = t0 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t0 = v3 - c4 * 65536;
  v3 = t1 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t1 = v3 - c4 * 65536;
  v3 = t22 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t22 = v3 - c4 * 65536;
  v3 = t32 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t32 = v3 - c4 * 65536;
  v3 = t4 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t4 = v3 - c4 * 65536;
  v3 = t5 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t5 = v3 - c4 * 65536;
  v3 = t6 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t6 = v3 - c4 * 65536;
  v3 = t7 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t7 = v3 - c4 * 65536;
  v3 = t8 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t8 = v3 - c4 * 65536;
  v3 = t9 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t9 = v3 - c4 * 65536;
  v3 = t10 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t10 = v3 - c4 * 65536;
  v3 = t11 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t11 = v3 - c4 * 65536;
  v3 = t12 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t12 = v3 - c4 * 65536;
  v3 = t13 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t13 = v3 - c4 * 65536;
  v3 = t14 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t14 = v3 - c4 * 65536;
  v3 = t15 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t15 = v3 - c4 * 65536;
  t0 += c4 - 1 + 37 * (c4 - 1);
  o3[0] = t0;
  o3[1] = t1;
  o3[2] = t22;
  o3[3] = t32;
  o3[4] = t4;
  o3[5] = t5;
  o3[6] = t6;
  o3[7] = t7;
  o3[8] = t8;
  o3[9] = t9;
  o3[10] = t10;
  o3[11] = t11;
  o3[12] = t12;
  o3[13] = t13;
  o3[14] = t14;
  o3[15] = t15;
}
function S(o3, a5) {
  M(o3, a5, a5);
}
function inv25519(o3, i4) {
  const c4 = gf();
  let a5;
  for (a5 = 0; a5 < 16; a5++)
    c4[a5] = i4[a5];
  for (a5 = 253; a5 >= 0; a5--) {
    S(c4, c4);
    if (a5 !== 2 && a5 !== 4)
      M(c4, c4, i4);
  }
  for (a5 = 0; a5 < 16; a5++)
    o3[a5] = c4[a5];
}
function pow2523(o3, i4) {
  const c4 = gf();
  let a5;
  for (a5 = 0; a5 < 16; a5++)
    c4[a5] = i4[a5];
  for (a5 = 250; a5 >= 0; a5--) {
    S(c4, c4);
    if (a5 !== 1)
      M(c4, c4, i4);
  }
  for (a5 = 0; a5 < 16; a5++)
    o3[a5] = c4[a5];
}
var K = [
  1116352408,
  3609767458,
  1899447441,
  602891725,
  3049323471,
  3964484399,
  3921009573,
  2173295548,
  961987163,
  4081628472,
  1508970993,
  3053834265,
  2453635748,
  2937671579,
  2870763221,
  3664609560,
  3624381080,
  2734883394,
  310598401,
  1164996542,
  607225278,
  1323610764,
  1426881987,
  3590304994,
  1925078388,
  4068182383,
  2162078206,
  991336113,
  2614888103,
  633803317,
  3248222580,
  3479774868,
  3835390401,
  2666613458,
  4022224774,
  944711139,
  264347078,
  2341262773,
  604807628,
  2007800933,
  770255983,
  1495990901,
  1249150122,
  1856431235,
  1555081692,
  3175218132,
  1996064986,
  2198950837,
  2554220882,
  3999719339,
  2821834349,
  766784016,
  2952996808,
  2566594879,
  3210313671,
  3203337956,
  3336571891,
  1034457026,
  3584528711,
  2466948901,
  113926993,
  3758326383,
  338241895,
  168717936,
  666307205,
  1188179964,
  773529912,
  1546045734,
  1294757372,
  1522805485,
  1396182291,
  2643833823,
  1695183700,
  2343527390,
  1986661051,
  1014477480,
  2177026350,
  1206759142,
  2456956037,
  344077627,
  2730485921,
  1290863460,
  2820302411,
  3158454273,
  3259730800,
  3505952657,
  3345764771,
  106217008,
  3516065817,
  3606008344,
  3600352804,
  1432725776,
  4094571909,
  1467031594,
  275423344,
  851169720,
  430227734,
  3100823752,
  506948616,
  1363258195,
  659060556,
  3750685593,
  883997877,
  3785050280,
  958139571,
  3318307427,
  1322822218,
  3812723403,
  1537002063,
  2003034995,
  1747873779,
  3602036899,
  1955562222,
  1575990012,
  2024104815,
  1125592928,
  2227730452,
  2716904306,
  2361852424,
  442776044,
  2428436474,
  593698344,
  2756734187,
  3733110249,
  3204031479,
  2999351573,
  3329325298,
  3815920427,
  3391569614,
  3928383900,
  3515267271,
  566280711,
  3940187606,
  3454069534,
  4118630271,
  4000239992,
  116418474,
  1914138554,
  174292421,
  2731055270,
  289380356,
  3203993006,
  460393269,
  320620315,
  685471733,
  587496836,
  852142971,
  1086792851,
  1017036298,
  365543100,
  1126000580,
  2618297676,
  1288033470,
  3409855158,
  1501505948,
  4234509866,
  1607167915,
  987167468,
  1816402316,
  1246189591
];
function crypto_hashblocks_hl(hh, hl, m5, n2) {
  const wh = new Int32Array(16), wl = new Int32Array(16);
  let bh0, bh1, bh2, bh3, bh4, bh5, bh6, bh7, bl0, bl1, bl2, bl3, bl4, bl5, bl6, bl7, th, tl, i4, j4, h5, l3, a5, b4, c4, d5;
  let ah0 = hh[0], ah1 = hh[1], ah2 = hh[2], ah3 = hh[3], ah4 = hh[4], ah5 = hh[5], ah6 = hh[6], ah7 = hh[7], al0 = hl[0], al1 = hl[1], al2 = hl[2], al3 = hl[3], al4 = hl[4], al5 = hl[5], al6 = hl[6], al7 = hl[7];
  let pos = 0;
  while (n2 >= 128) {
    for (i4 = 0; i4 < 16; i4++) {
      j4 = 8 * i4 + pos;
      wh[i4] = m5[j4 + 0] << 24 | m5[j4 + 1] << 16 | m5[j4 + 2] << 8 | m5[j4 + 3];
      wl[i4] = m5[j4 + 4] << 24 | m5[j4 + 5] << 16 | m5[j4 + 6] << 8 | m5[j4 + 7];
    }
    for (i4 = 0; i4 < 80; i4++) {
      bh0 = ah0;
      bh1 = ah1;
      bh2 = ah2;
      bh3 = ah3;
      bh4 = ah4;
      bh5 = ah5;
      bh6 = ah6;
      bh7 = ah7;
      bl0 = al0;
      bl1 = al1;
      bl2 = al2;
      bl3 = al3;
      bl4 = al4;
      bl5 = al5;
      bl6 = al6;
      bl7 = al7;
      h5 = ah7;
      l3 = al7;
      a5 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h5 & 65535;
      d5 = h5 >>> 16;
      h5 = (ah4 >>> 14 | al4 << 32 - 14) ^ (ah4 >>> 18 | al4 << 32 - 18) ^ (al4 >>> 41 - 32 | ah4 << 32 - (41 - 32));
      l3 = (al4 >>> 14 | ah4 << 32 - 14) ^ (al4 >>> 18 | ah4 << 32 - 18) ^ (ah4 >>> 41 - 32 | al4 << 32 - (41 - 32));
      a5 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h5 & 65535;
      d5 += h5 >>> 16;
      h5 = ah4 & ah5 ^ ~ah4 & ah6;
      l3 = al4 & al5 ^ ~al4 & al6;
      a5 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h5 & 65535;
      d5 += h5 >>> 16;
      h5 = K[i4 * 2];
      l3 = K[i4 * 2 + 1];
      a5 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h5 & 65535;
      d5 += h5 >>> 16;
      h5 = wh[i4 % 16];
      l3 = wl[i4 % 16];
      a5 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h5 & 65535;
      d5 += h5 >>> 16;
      b4 += a5 >>> 16;
      c4 += b4 >>> 16;
      d5 += c4 >>> 16;
      th = c4 & 65535 | d5 << 16;
      tl = a5 & 65535 | b4 << 16;
      h5 = th;
      l3 = tl;
      a5 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h5 & 65535;
      d5 = h5 >>> 16;
      h5 = (ah0 >>> 28 | al0 << 32 - 28) ^ (al0 >>> 34 - 32 | ah0 << 32 - (34 - 32)) ^ (al0 >>> 39 - 32 | ah0 << 32 - (39 - 32));
      l3 = (al0 >>> 28 | ah0 << 32 - 28) ^ (ah0 >>> 34 - 32 | al0 << 32 - (34 - 32)) ^ (ah0 >>> 39 - 32 | al0 << 32 - (39 - 32));
      a5 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h5 & 65535;
      d5 += h5 >>> 16;
      h5 = ah0 & ah1 ^ ah0 & ah2 ^ ah1 & ah2;
      l3 = al0 & al1 ^ al0 & al2 ^ al1 & al2;
      a5 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h5 & 65535;
      d5 += h5 >>> 16;
      b4 += a5 >>> 16;
      c4 += b4 >>> 16;
      d5 += c4 >>> 16;
      bh7 = c4 & 65535 | d5 << 16;
      bl7 = a5 & 65535 | b4 << 16;
      h5 = bh3;
      l3 = bl3;
      a5 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h5 & 65535;
      d5 = h5 >>> 16;
      h5 = th;
      l3 = tl;
      a5 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h5 & 65535;
      d5 += h5 >>> 16;
      b4 += a5 >>> 16;
      c4 += b4 >>> 16;
      d5 += c4 >>> 16;
      bh3 = c4 & 65535 | d5 << 16;
      bl3 = a5 & 65535 | b4 << 16;
      ah1 = bh0;
      ah2 = bh1;
      ah3 = bh2;
      ah4 = bh3;
      ah5 = bh4;
      ah6 = bh5;
      ah7 = bh6;
      ah0 = bh7;
      al1 = bl0;
      al2 = bl1;
      al3 = bl2;
      al4 = bl3;
      al5 = bl4;
      al6 = bl5;
      al7 = bl6;
      al0 = bl7;
      if (i4 % 16 === 15) {
        for (j4 = 0; j4 < 16; j4++) {
          h5 = wh[j4];
          l3 = wl[j4];
          a5 = l3 & 65535;
          b4 = l3 >>> 16;
          c4 = h5 & 65535;
          d5 = h5 >>> 16;
          h5 = wh[(j4 + 9) % 16];
          l3 = wl[(j4 + 9) % 16];
          a5 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h5 & 65535;
          d5 += h5 >>> 16;
          th = wh[(j4 + 1) % 16];
          tl = wl[(j4 + 1) % 16];
          h5 = (th >>> 1 | tl << 32 - 1) ^ (th >>> 8 | tl << 32 - 8) ^ th >>> 7;
          l3 = (tl >>> 1 | th << 32 - 1) ^ (tl >>> 8 | th << 32 - 8) ^ (tl >>> 7 | th << 32 - 7);
          a5 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h5 & 65535;
          d5 += h5 >>> 16;
          th = wh[(j4 + 14) % 16];
          tl = wl[(j4 + 14) % 16];
          h5 = (th >>> 19 | tl << 32 - 19) ^ (tl >>> 61 - 32 | th << 32 - (61 - 32)) ^ th >>> 6;
          l3 = (tl >>> 19 | th << 32 - 19) ^ (th >>> 61 - 32 | tl << 32 - (61 - 32)) ^ (tl >>> 6 | th << 32 - 6);
          a5 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h5 & 65535;
          d5 += h5 >>> 16;
          b4 += a5 >>> 16;
          c4 += b4 >>> 16;
          d5 += c4 >>> 16;
          wh[j4] = c4 & 65535 | d5 << 16;
          wl[j4] = a5 & 65535 | b4 << 16;
        }
      }
    }
    h5 = ah0;
    l3 = al0;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[0];
    l3 = hl[0];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[0] = ah0 = c4 & 65535 | d5 << 16;
    hl[0] = al0 = a5 & 65535 | b4 << 16;
    h5 = ah1;
    l3 = al1;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[1];
    l3 = hl[1];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[1] = ah1 = c4 & 65535 | d5 << 16;
    hl[1] = al1 = a5 & 65535 | b4 << 16;
    h5 = ah2;
    l3 = al2;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[2];
    l3 = hl[2];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[2] = ah2 = c4 & 65535 | d5 << 16;
    hl[2] = al2 = a5 & 65535 | b4 << 16;
    h5 = ah3;
    l3 = al3;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[3];
    l3 = hl[3];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[3] = ah3 = c4 & 65535 | d5 << 16;
    hl[3] = al3 = a5 & 65535 | b4 << 16;
    h5 = ah4;
    l3 = al4;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[4];
    l3 = hl[4];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[4] = ah4 = c4 & 65535 | d5 << 16;
    hl[4] = al4 = a5 & 65535 | b4 << 16;
    h5 = ah5;
    l3 = al5;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[5];
    l3 = hl[5];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[5] = ah5 = c4 & 65535 | d5 << 16;
    hl[5] = al5 = a5 & 65535 | b4 << 16;
    h5 = ah6;
    l3 = al6;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[6];
    l3 = hl[6];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[6] = ah6 = c4 & 65535 | d5 << 16;
    hl[6] = al6 = a5 & 65535 | b4 << 16;
    h5 = ah7;
    l3 = al7;
    a5 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h5 & 65535;
    d5 = h5 >>> 16;
    h5 = hh[7];
    l3 = hl[7];
    a5 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h5 & 65535;
    d5 += h5 >>> 16;
    b4 += a5 >>> 16;
    c4 += b4 >>> 16;
    d5 += c4 >>> 16;
    hh[7] = ah7 = c4 & 65535 | d5 << 16;
    hl[7] = al7 = a5 & 65535 | b4 << 16;
    pos += 128;
    n2 -= 128;
  }
  return n2;
}
function crypto_hash(out, m5, n2) {
  const hh = new Int32Array(8);
  const hl = new Int32Array(8);
  const x6 = new Uint8Array(256);
  const b4 = n2;
  hh[0] = 1779033703;
  hh[1] = 3144134277;
  hh[2] = 1013904242;
  hh[3] = 2773480762;
  hh[4] = 1359893119;
  hh[5] = 2600822924;
  hh[6] = 528734635;
  hh[7] = 1541459225;
  hl[0] = 4089235720;
  hl[1] = 2227873595;
  hl[2] = 4271175723;
  hl[3] = 1595750129;
  hl[4] = 2917565137;
  hl[5] = 725511199;
  hl[6] = 4215389547;
  hl[7] = 327033209;
  crypto_hashblocks_hl(hh, hl, m5, n2);
  n2 %= 128;
  for (let i4 = 0; i4 < n2; i4++)
    x6[i4] = m5[b4 - n2 + i4];
  x6[n2] = 128;
  n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
  x6[n2 - 9] = 0;
  ts64(x6, n2 - 8, b4 / 536870912 | 0, b4 << 3);
  crypto_hashblocks_hl(hh, hl, x6, n2);
  for (let i4 = 0; i4 < 8; i4++)
    ts64(out, 8 * i4, hh[i4], hl[i4]);
  return 0;
}
var HashState = class {
  constructor() {
    this.hh = new Int32Array(8);
    this.hl = new Int32Array(8);
    this.next = new Uint8Array(128);
    this.p = 0;
    this.total = 0;
    this.hh[0] = 1779033703;
    this.hh[1] = 3144134277;
    this.hh[2] = 1013904242;
    this.hh[3] = 2773480762;
    this.hh[4] = 1359893119;
    this.hh[5] = 2600822924;
    this.hh[6] = 528734635;
    this.hh[7] = 1541459225;
    this.hl[0] = 4089235720;
    this.hl[1] = 2227873595;
    this.hl[2] = 4271175723;
    this.hl[3] = 1595750129;
    this.hl[4] = 2917565137;
    this.hl[5] = 725511199;
    this.hl[6] = 4215389547;
    this.hl[7] = 327033209;
  }
  update(data) {
    this.total += data.length;
    let i4 = 0;
    while (i4 < data.length) {
      const r3 = 128 - this.p;
      if (r3 > data.length - i4) {
        for (let j4 = 0; i4 + j4 < data.length; j4++) {
          this.next[this.p + j4] = data[i4 + j4];
        }
        this.p += data.length - i4;
        break;
      } else {
        for (let j4 = 0; this.p + j4 < 128; j4++) {
          this.next[this.p + j4] = data[i4 + j4];
        }
        crypto_hashblocks_hl(this.hh, this.hl, this.next, 128);
        i4 += 128 - this.p;
        this.p = 0;
      }
    }
    return this;
  }
  finish() {
    const out = new Uint8Array(64);
    let n2 = this.p;
    const x6 = new Uint8Array(256);
    const b4 = this.total;
    for (let i4 = 0; i4 < n2; i4++)
      x6[i4] = this.next[i4];
    x6[n2] = 128;
    n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
    x6[n2 - 9] = 0;
    ts64(x6, n2 - 8, b4 / 536870912 | 0, b4 << 3);
    crypto_hashblocks_hl(this.hh, this.hl, x6, n2);
    for (let i4 = 0; i4 < 8; i4++)
      ts64(out, 8 * i4, this.hh[i4], this.hl[i4]);
    return out;
  }
};
function add(p4, q5) {
  const a5 = gf(), b4 = gf(), c4 = gf(), d5 = gf(), e4 = gf(), f3 = gf(), g4 = gf(), h5 = gf(), t4 = gf();
  Z(a5, p4[1], p4[0]);
  Z(t4, q5[1], q5[0]);
  M(a5, a5, t4);
  A(b4, p4[0], p4[1]);
  A(t4, q5[0], q5[1]);
  M(b4, b4, t4);
  M(c4, p4[3], q5[3]);
  M(c4, c4, D2);
  M(d5, p4[2], q5[2]);
  A(d5, d5, d5);
  Z(e4, b4, a5);
  Z(f3, d5, c4);
  A(g4, d5, c4);
  A(h5, b4, a5);
  M(p4[0], e4, f3);
  M(p4[1], h5, g4);
  M(p4[2], g4, f3);
  M(p4[3], e4, h5);
}
function cswap(p4, q5, b4) {
  let i4;
  for (i4 = 0; i4 < 4; i4++) {
    sel25519(p4[i4], q5[i4], b4);
  }
}
function pack(r3, p4) {
  const tx = gf(), ty = gf(), zi = gf();
  inv25519(zi, p4[2]);
  M(tx, p4[0], zi);
  M(ty, p4[1], zi);
  pack25519(r3, ty);
  r3[31] ^= par25519(tx) << 7;
}
function scalarmult(p4, q5, s5) {
  let b4, i4;
  set25519(p4[0], gf0);
  set25519(p4[1], gf1);
  set25519(p4[2], gf1);
  set25519(p4[3], gf0);
  for (i4 = 255; i4 >= 0; --i4) {
    b4 = s5[i4 / 8 | 0] >> (i4 & 7) & 1;
    cswap(p4, q5, b4);
    add(q5, p4);
    add(p4, p4);
    cswap(p4, q5, b4);
  }
}
function scalarbase(p4, s5) {
  const q5 = [gf(), gf(), gf(), gf()];
  set25519(q5[0], X);
  set25519(q5[1], Y);
  set25519(q5[2], gf1);
  M(q5[3], X, Y);
  scalarmult(p4, q5, s5);
}
var L = new Float64Array([
  237,
  211,
  245,
  92,
  26,
  99,
  18,
  88,
  214,
  156,
  247,
  162,
  222,
  249,
  222,
  20,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  16
]);
function modL(r3, x6) {
  let carry, i4, j4, k5;
  for (i4 = 63; i4 >= 32; --i4) {
    carry = 0;
    for (j4 = i4 - 32, k5 = i4 - 12; j4 < k5; ++j4) {
      x6[j4] += carry - 16 * x6[i4] * L[j4 - (i4 - 32)];
      carry = Math.floor((x6[j4] + 128) / 256);
      x6[j4] -= carry * 256;
    }
    x6[j4] += carry;
    x6[i4] = 0;
  }
  carry = 0;
  for (j4 = 0; j4 < 32; j4++) {
    x6[j4] += carry - (x6[31] >> 4) * L[j4];
    carry = x6[j4] >> 8;
    x6[j4] &= 255;
  }
  for (j4 = 0; j4 < 32; j4++)
    x6[j4] -= carry * L[j4];
  for (i4 = 0; i4 < 32; i4++) {
    x6[i4 + 1] += x6[i4] >> 8;
    r3[i4] = x6[i4] & 255;
  }
}
function reduce(r3) {
  const x6 = new Float64Array(64);
  for (let i4 = 0; i4 < 64; i4++)
    x6[i4] = r3[i4];
  for (let i4 = 0; i4 < 64; i4++)
    r3[i4] = 0;
  modL(r3, x6);
}
function unpackpos(r3, p4) {
  const q5 = [gf(), gf(), gf(), gf()];
  if (unpackneg(q5, p4))
    return -1;
  const scalar0 = new Uint8Array(32);
  const scalar1 = new Uint8Array(32);
  scalar1[0] = 1;
  const scalarNeg1 = crypto_core_ed25519_scalar_sub(scalar0, scalar1);
  scalarmult(r3, q5, scalarNeg1);
  return 0;
}
function unpackneg(r3, p4) {
  const t4 = gf();
  const chk = gf();
  const num = gf();
  const den = gf();
  const den2 = gf();
  const den4 = gf();
  const den6 = gf();
  set25519(r3[2], gf1);
  unpack25519(r3[1], p4);
  S(num, r3[1]);
  M(den, num, D);
  Z(num, num, r3[2]);
  A(den, r3[2], den);
  S(den2, den);
  S(den4, den2);
  M(den6, den4, den2);
  M(t4, den6, num);
  M(t4, t4, den);
  pow2523(t4, t4);
  M(t4, t4, num);
  M(t4, t4, den);
  M(t4, t4, den);
  M(r3[0], t4, den);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    M(r3[0], r3[0], I);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    return -1;
  if (par25519(r3[0]) === p4[31] >> 7)
    Z(r3[0], gf0, r3[0]);
  M(r3[3], r3[0], r3[1]);
  return 0;
}
function crypto_scalarmult_ed25519_base_noclamp(s5) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  scalarbase(p4, s5);
  pack(r3, p4);
  return r3;
}
function crypto_scalarmult_ed25519_noclamp(s5, q5) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  const ql = [gf(), gf(), gf(), gf()];
  if (unpackpos(ql, q5))
    throw new Error();
  scalarmult(p4, ql, s5);
  pack(r3, p4);
  return r3;
}
function crypto_sign_open(m5, sm, n2, pk) {
  let i4, mlen;
  const t4 = new Uint8Array(32), h5 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()], q5 = [gf(), gf(), gf(), gf()];
  mlen = -1;
  if (n2 < 64)
    return -1;
  if (unpackneg(q5, pk))
    return -1;
  for (i4 = 0; i4 < n2; i4++)
    m5[i4] = sm[i4];
  for (i4 = 0; i4 < 32; i4++)
    m5[i4 + 32] = pk[i4];
  crypto_hash(h5, m5, n2);
  reduce(h5);
  scalarmult(p4, q5, h5);
  scalarbase(q5, sm.subarray(32));
  add(p4, q5);
  pack(t4, p4);
  n2 -= 64;
  if (crypto_verify_32(sm, 0, t4, 0)) {
    for (i4 = 0; i4 < n2; i4++)
      m5[i4] = 0;
    return -1;
  }
  for (i4 = 0; i4 < n2; i4++)
    m5[i4] = sm[i4 + 64];
  mlen = n2;
  return mlen;
}
var crypto_sign_BYTES = 64;
var crypto_sign_PUBLICKEYBYTES = 32;
var crypto_hash_BYTES = 64;
function checkArrayTypes(...args) {
  for (let i4 = 0; i4 < args.length; i4++) {
    if (!(args[i4] instanceof Uint8Array))
      throw new TypeError("unexpected type, use Uint8Array");
  }
}
function randomBytes(n2) {
  const b4 = new Uint8Array(n2);
  randombytes(b4, n2);
  return b4;
}
function hash(msg) {
  checkArrayTypes(msg);
  const h5 = new Uint8Array(crypto_hash_BYTES);
  crypto_hash(h5, msg, msg.length);
  return h5;
}
function setPRNG(fn2) {
  randombytes = fn2;
}
function crypto_core_ed25519_scalar_reduce(x6) {
  const len = x6.length;
  const z5 = new Float64Array(64);
  for (let i4 = 0; i4 < len; i4++)
    z5[i4] = x6[i4];
  const o3 = new Uint8Array(32);
  modL(o3, z5);
  return o3;
}
function crypto_core_ed25519_scalar_sub(x6, y5) {
  const z5 = new Float64Array(64);
  for (let i4 = 0; i4 < 32; i4++) {
    z5[i4] = x6[i4] - y5[i4];
  }
  const o3 = new Uint8Array(32);
  modL(o3, z5);
  return o3;
}
function crypto_edx25519_private_key_create() {
  const seed = new Uint8Array(32);
  randombytes(seed, 32);
  return crypto_edx25519_private_key_create_from_seed(seed);
}
function crypto_edx25519_private_key_create_from_seed(seed) {
  const pk = hash(seed);
  pk[0] &= 248;
  pk[31] &= 127;
  pk[31] |= 64;
  return pk;
}
function crypto_edx25519_get_public(priv) {
  return crypto_scalarmult_ed25519_base_noclamp(priv.subarray(0, 32));
}
function crypto_edx25519_sign_detached(m5, skx, pkx) {
  const n2 = m5.length;
  const h5 = new Uint8Array(64);
  const r3 = new Uint8Array(64);
  let i4, j4;
  const x6 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  const sm = new Uint8Array(n2 + 64);
  for (i4 = 0; i4 < n2; i4++)
    sm[64 + i4] = m5[i4];
  for (i4 = 0; i4 < 32; i4++)
    sm[32 + i4] = skx[32 + i4];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i4 = 32; i4 < 64; i4++)
    sm[i4] = pkx[i4 - 32];
  crypto_hash(h5, sm, n2 + 64);
  reduce(h5);
  for (i4 = 0; i4 < 64; i4++)
    x6[i4] = 0;
  for (i4 = 0; i4 < 32; i4++)
    x6[i4] = r3[i4];
  for (i4 = 0; i4 < 32; i4++) {
    for (j4 = 0; j4 < 32; j4++) {
      x6[i4 + j4] += h5[i4] * skx[j4];
    }
  }
  modL(sm.subarray(32), x6);
  return sm.subarray(0, 64);
}
function crypto_edx25519_sign_detached_verify(msg, sig, publicKey) {
  checkArrayTypes(msg, sig, publicKey);
  if (sig.length !== crypto_sign_BYTES)
    throw new Error("bad signature size");
  if (publicKey.length !== crypto_sign_PUBLICKEYBYTES)
    throw new Error("bad public key size");
  const sm = new Uint8Array(crypto_sign_BYTES + msg.length);
  const m5 = new Uint8Array(crypto_sign_BYTES + msg.length);
  let i4;
  for (i4 = 0; i4 < crypto_sign_BYTES; i4++)
    sm[i4] = sig[i4];
  for (i4 = 0; i4 < msg.length; i4++)
    sm[i4 + crypto_sign_BYTES] = msg[i4];
  return crypto_sign_open(m5, sm, sm.length, publicKey) >= 0;
}

// ../taler-util/lib/prng-browser.js
function loadBrowserPrng() {
  const cr = typeof self !== "undefined" ? self.crypto || self.msCrypto : null;
  const QUOTA = 65536;
  setPRNG(function(x6, n2) {
    let i4;
    const v3 = new Uint8Array(n2);
    for (i4 = 0; i4 < n2; i4 += QUOTA) {
      cr.getRandomValues(v3.subarray(i4, i4 + Math.min(n2 - i4, QUOTA)));
    }
    for (i4 = 0; i4 < n2; i4++)
      x6[i4] = v3[i4];
    for (i4 = 0; i4 < v3.length; i4++)
      v3[i4] = 0;
  });
}

// ../taler-util/lib/taler-error-codes.js
var TalerErrorCode;
(function(TalerErrorCode2) {
  TalerErrorCode2[TalerErrorCode2["NONE"] = 0] = "NONE";
  TalerErrorCode2[TalerErrorCode2["INVALID"] = 1] = "INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_INTERNAL_ERROR"] = 2] = "GENERIC_CLIENT_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INVALID_RESPONSE"] = 10] = "GENERIC_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TIMEOUT"] = 11] = "GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_VERSION_MALFORMED"] = 12] = "GENERIC_VERSION_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_REPLY_MALFORMED"] = 13] = "GENERIC_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CONFIGURATION_INVALID"] = 14] = "GENERIC_CONFIGURATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNEXPECTED_REQUEST_ERROR"] = 15] = "GENERIC_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_PERMISSION_INSUFFICIENT"] = 16] = "GENERIC_TOKEN_PERMISSION_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_METHOD_INVALID"] = 20] = "GENERIC_METHOD_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ENDPOINT_UNKNOWN"] = 21] = "GENERIC_ENDPOINT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_INVALID"] = 22] = "GENERIC_JSON_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_HTTP_HEADERS_MALFORMED"] = 23] = "GENERIC_HTTP_HEADERS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PAYTO_URI_MALFORMED"] = 24] = "GENERIC_PAYTO_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MISSING"] = 25] = "GENERIC_PARAMETER_MISSING";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MALFORMED"] = 26] = "GENERIC_PARAMETER_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_RESERVE_PUB_MALFORMED"] = 27] = "GENERIC_RESERVE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_COMPRESSION_INVALID"] = 28] = "GENERIC_COMPRESSION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURRENCY_MISMATCH"] = 30] = "GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_URI_TOO_LONG"] = 31] = "GENERIC_URI_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UPLOAD_EXCEEDS_LIMIT"] = 32] = "GENERIC_UPLOAD_EXCEEDS_LIMIT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNAUTHORIZED"] = 40] = "GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_UNKNOWN"] = 41] = "GENERIC_TOKEN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_EXPIRED"] = 42] = "GENERIC_TOKEN_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_MALFORMED"] = 43] = "GENERIC_TOKEN_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FORBIDDEN"] = 44] = "GENERIC_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SETUP_FAILED"] = 50] = "GENERIC_DB_SETUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_START_FAILED"] = 51] = "GENERIC_DB_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_STORE_FAILED"] = 52] = "GENERIC_DB_STORE_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_FETCH_FAILED"] = 53] = "GENERIC_DB_FETCH_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_COMMIT_FAILED"] = 54] = "GENERIC_DB_COMMIT_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SOFT_FAILURE"] = 55] = "GENERIC_DB_SOFT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_INVARIANT_FAILURE"] = 56] = "GENERIC_DB_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INTERNAL_INVARIANT_FAILURE"] = 60] = "GENERIC_INTERNAL_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_JSON_HASH"] = 61] = "GENERIC_FAILED_COMPUTE_JSON_HASH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_AMOUNT"] = 62] = "GENERIC_FAILED_COMPUTE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARSER_OUT_OF_MEMORY"] = 70] = "GENERIC_PARSER_OUT_OF_MEMORY";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ALLOCATION_FAILURE"] = 71] = "GENERIC_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_ALLOCATION_FAILURE"] = 72] = "GENERIC_JSON_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURL_ALLOCATION_FAILURE"] = 73] = "GENERIC_CURL_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_LOAD_TEMPLATE"] = 74] = "GENERIC_FAILED_TO_LOAD_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_EXPAND_TEMPLATE"] = 75] = "GENERIC_FAILED_TO_EXPAND_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BAD_CONFIGURATION"] = 1e3] = "EXCHANGE_GENERIC_BAD_CONFIGURATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_OPERATION_UNKNOWN"] = 1001] = "EXCHANGE_GENERIC_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 1002] = "EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY"] = 1003] = "EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB"] = 1004] = "EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN"] = 1005] = "EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_SIGNATURE_INVALID"] = 1006] = "EXCHANGE_DENOMINATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KEYS_MISSING"] = 1007] = "EXCHANGE_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE"] = 1008] = "EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_EXPIRED"] = 1009] = "EXCHANGE_GENERIC_DENOMINATION_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_REVOKED"] = 1010] = "EXCHANGE_GENERIC_DENOMINATION_REVOKED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_SECMOD_TIMEOUT"] = 1011] = "EXCHANGE_GENERIC_SECMOD_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INSUFFICIENT_FUNDS"] = 1012] = "EXCHANGE_GENERIC_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED"] = 1013] = "EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS"] = 1014] = "EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH"] = 1015] = "EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION"] = 1016] = "EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CIPHER_MISMATCH"] = 1017] = "EXCHANGE_GENERIC_CIPHER_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE"] = 1018] = "EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_UNKNOWN"] = 1019] = "EXCHANGE_GENERIC_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CLOCK_SKEW"] = 1020] = "EXCHANGE_GENERIC_CLOCK_SKEW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE"] = 1021] = "EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_GLOBAL_FEES_MISSING"] = 1022] = "EXCHANGE_GENERIC_GLOBAL_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WIRE_FEES_MISSING"] = 1023] = "EXCHANGE_GENERIC_WIRE_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_PUB_MALFORMED"] = 1024] = "EXCHANGE_GENERIC_PURSE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_UNKNOWN"] = 1025] = "EXCHANGE_GENERIC_PURSE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_EXPIRED"] = 1026] = "EXCHANGE_GENERIC_PURSE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_RESERVE_UNKNOWN"] = 1027] = "EXCHANGE_GENERIC_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_REQUIRED"] = 1028] = "EXCHANGE_GENERIC_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT"] = 1029] = "EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE"] = 1030] = "EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_DELETED"] = 1031] = "EXCHANGE_GENERIC_PURSE_DELETED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED"] = 1032] = "EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID"] = 1033] = "EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED"] = 1034] = "EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PENDING"] = 1035] = "EXCHANGE_GENERIC_AML_PENDING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_FROZEN"] = 1036] = "EXCHANGE_GENERIC_AML_FROZEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_CONVERTER_FAILED"] = 1037] = "EXCHANGE_GENERIC_KYC_CONVERTER_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_NOT_FOUND"] = 1100] = "EXCHANGE_DEPOSITS_GET_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE"] = 1101] = "EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB"] = 1102] = "EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS"] = 1103] = "EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB"] = 1104] = "EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1105] = "EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID"] = 1106] = "EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED"] = 1107] = "EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1150] = "EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1151] = "EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW"] = 1152] = "EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_SIGNATURE_FAILED"] = 1153] = "EXCHANGE_WITHDRAW_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID"] = 1154] = "EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS"] = 1155] = "EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE"] = 1156] = "EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST"] = 1158] = "EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_UNBLIND_FAILURE"] = 1159] = "EXCHANGE_WITHDRAW_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_NONCE_REUSE"] = 1160] = "EXCHANGE_WITHDRAW_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_COMMITMENT_UNKNOWN"] = 1161] = "EXCHANGE_AGE_WITHDRAW_COMMITMENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_AMOUNT_OVERFLOW"] = 1162] = "EXCHANGE_AGE_WITHDRAW_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT"] = 1163] = "EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_REVEAL_INVALID_HASH"] = 1164] = "EXCHANGE_AGE_WITHDRAW_REVEAL_INVALID_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE"] = 1165] = "EXCHANGE_AGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_BATCH_IDEMPOTENT_PLANCHET"] = 1175] = "EXCHANGE_WITHDRAW_BATCH_IDEMPOTENT_PLANCHET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1205] = "EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT"] = 1206] = "EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE"] = 1207] = "EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE"] = 1208] = "EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER"] = 1209] = "EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON"] = 1210] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT"] = 1211] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1221] = "EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT"] = 1222] = "EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT"] = 1240] = "EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_COIN_HISTORY_BAD_SIGNATURE"] = 1251] = "EXCHANGE_COIN_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE"] = 1252] = "EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION"] = 1302] = "EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_SIGNATURE_INVALID"] = 1303] = "EXCHANGE_MELT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE"] = 1305] = "EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1306] = "EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION"] = 1353] = "EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR"] = 1354] = "EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN"] = 1355] = "EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID"] = 1356] = "EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH"] = 1358] = "EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW"] = 1359] = "EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT"] = 1360] = "EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID"] = 1361] = "EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_INVALID_RCH"] = 1362] = "EXCHANGE_REFRESHES_REVEAL_INVALID_RCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID"] = 1363] = "EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED"] = 1364] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID"] = 1365] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_LINK_COIN_UNKNOWN"] = 1400] = "EXCHANGE_LINK_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_MALFORMED"] = 1450] = "EXCHANGE_TRANSFERS_GET_WTID_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND"] = 1451] = "EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND"] = 1452] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT"] = 1453] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_INVALID_WAIT_TARGET"] = 1475] = "EXCHANGE_PURSES_INVALID_WAIT_TARGET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1476] = "EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_COIN_NOT_FOUND"] = 1500] = "EXCHANGE_REFUND_COIN_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT"] = 1501] = "EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_DEPOSIT_NOT_FOUND"] = 1502] = "EXCHANGE_REFUND_DEPOSIT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_ALREADY_PAID"] = 1503] = "EXCHANGE_REFUND_MERCHANT_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_TOO_LOW"] = 1504] = "EXCHANGE_REFUND_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_ABOVE_AMOUNT"] = 1505] = "EXCHANGE_REFUND_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID"] = 1506] = "EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED"] = 1507] = "EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE"] = 1508] = "EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE"] = 1509] = "EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INCONSISTENT_AMOUNT"] = 1510] = "EXCHANGE_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_SIGNATURE_INVALID"] = 1550] = "EXCHANGE_RECOUP_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND"] = 1551] = "EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_ZERO"] = 1552] = "EXCHANGE_RECOUP_COIN_BALANCE_ZERO";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_BLINDING_FAILED"] = 1553] = "EXCHANGE_RECOUP_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE"] = 1554] = "EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_NOT_ELIGIBLE"] = 1555] = "EXCHANGE_RECOUP_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID"] = 1575] = "EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND"] = 1576] = "EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED"] = 1578] = "EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE"] = 1580] = "EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN"] = 1600] = "EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_SIGNATURE_INVALID"] = 1650] = "EXCHANGE_WIRE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED"] = 1651] = "EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED"] = 1652] = "EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_FEES_NOT_CONFIGURED"] = 1653] = "EXCHANGE_WIRE_FEES_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA"] = 1675] = "EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA"] = 1676] = "EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS"] = 1677] = "EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW"] = 1678] = "EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_ALREADY_DECIDED"] = 1679] = "EXCHANGE_PURSE_DELETE_ALREADY_DECIDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID"] = 1680] = "EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED"] = 1681] = "EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE"] = 1700] = "EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_BUG"] = 1701] = "EXCHANGE_DENOMINATION_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_TOO_EARLY"] = 1702] = "EXCHANGE_DENOMINATION_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID"] = 1725] = "EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE"] = 1750] = "EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_BUG"] = 1751] = "EXCHANGE_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_TOO_EARLY"] = 1752] = "EXCHANGE_SIGNKEY_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW"] = 1775] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER"] = 1776] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID"] = 1777] = "EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID"] = 1778] = "EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE"] = 1785] = "EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE"] = 1786] = "EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE"] = 1787] = "EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT"] = 1788] = "EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS"] = 1789] = "EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND"] = 1800] = "EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT"] = 1801] = "EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID"] = 1802] = "EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID"] = 1803] = "EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID"] = 1804] = "EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID"] = 1805] = "EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT"] = 1806] = "EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN"] = 1807] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID"] = 1808] = "EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID"] = 1809] = "EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID"] = 1810] = "EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND"] = 1811] = "EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID"] = 1812] = "EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH"] = 1813] = "EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID"] = 1814] = "EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID"] = 1815] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH"] = 1816] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID"] = 1817] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID"] = 1818] = "EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID"] = 1825] = "EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_INVALID_OFFICER"] = 1826] = "EXCHANGE_AML_DECISION_INVALID_OFFICER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT"] = 1827] = "EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_UNKNOWN_CHECK"] = 1828] = "EXCHANGE_AML_DECISION_UNKNOWN_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID"] = 1830] = "EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT"] = 1831] = "EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA"] = 1850] = "EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED"] = 1851] = "EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID"] = 1852] = "EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW"] = 1853] = "EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER"] = 1854] = "EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID"] = 1855] = "EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID"] = 1856] = "EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID"] = 1857] = "EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA"] = 1858] = "EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA"] = 1859] = "EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE"] = 1860] = "EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE"] = 1876] = "EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE"] = 1877] = "EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_NOT_FULL"] = 1878] = "EXCHANGE_PURSE_NOT_FULL";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID"] = 1879] = "EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN"] = 1880] = "EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID"] = 1890] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT"] = 1891] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID"] = 1900] = "EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_UNKNOWN"] = 1901] = "EXCHANGE_AUDITORS_AUDITOR_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_INACTIVE"] = 1902] = "EXCHANGE_AUDITORS_AUDITOR_INACTIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WALLET_SIGNATURE_INVALID"] = 1925] = "EXCHANGE_KYC_WALLET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE"] = 1926] = "EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_ERROR"] = 1927] = "EXCHANGE_KYC_PROOF_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED"] = 1928] = "EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN"] = 1929] = "EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED"] = 1930] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN"] = 1931] = "EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_GONE"] = 1932] = "EXCHANGE_KYC_GENERIC_LOGIC_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_BUG"] = 1933] = "EXCHANGE_KYC_GENERIC_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED"] = 1934] = "EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT"] = 1935] = "EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY"] = 1936] = "EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED"] = 1937] = "EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED"] = 1938] = "EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_UNKNOWN"] = 1950] = "EXCHANGE_CONTRACTS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB"] = 1951] = "EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECRYPTION_FAILED"] = 1952] = "EXCHANGE_CONTRACTS_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_SIGNATURE_INVALID"] = 1953] = "EXCHANGE_CONTRACTS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECODING_FAILED"] = 1954] = "EXCHANGE_CONTRACTS_DECODING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1975] = "EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY"] = 1976] = "EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TOTP_KEY_INVALID"] = 1980] = "EXCHANGE_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_UNKNOWN"] = 2e3] = "MERCHANT_GENERIC_INSTANCE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE"] = 2001] = "MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED"] = 2002] = "MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ORDER_UNKNOWN"] = 2005] = "MERCHANT_GENERIC_ORDER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PRODUCT_UNKNOWN"] = 2006] = "MERCHANT_GENERIC_PRODUCT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_REWARD_ID_UNKNOWN"] = 2007] = "MERCHANT_GENERIC_REWARD_ID_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID"] = 2008] = "MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER"] = 2009] = "MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE"] = 2010] = "MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_TIMEOUT"] = 2011] = "MERCHANT_GENERIC_EXCHANGE_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE"] = 2012] = "MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED"] = 2013] = "MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS"] = 2014] = "MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNAUTHORIZED"] = 2015] = "MERCHANT_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_DELETED"] = 2016] = "MERCHANT_GENERIC_INSTANCE_DELETED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TRANSFER_UNKNOWN"] = 2017] = "MERCHANT_GENERIC_TRANSFER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TEMPLATE_UNKNOWN"] = 2018] = "MERCHANT_GENERIC_TEMPLATE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_WEBHOOK_UNKNOWN"] = 2019] = "MERCHANT_GENERIC_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN"] = 2020] = "MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN"] = 2021] = "MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ACCOUNT_UNKNOWN"] = 2022] = "MERCHANT_GENERIC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_H_WIRE_MALFORMED"] = 2023] = "MERCHANT_GENERIC_H_WIRE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CURRENCY_MISMATCH"] = 2024] = "MERCHANT_GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE"] = 2100] = "MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE"] = 2103] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE"] = 2104] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_TOKEN"] = 2105] = "MERCHANT_GET_ORDERS_ID_INVALID_TOKEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH"] = 2106] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS"] = 2150] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND"] = 2151] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE"] = 2152] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW"] = 2153] = "MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT"] = 2154] = "MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES"] = 2155] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT"] = 2156] = "MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID"] = 2157] = "MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED"] = 2158] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE"] = 2159] = "MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID"] = 2160] = "MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED"] = 2161] = "MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING"] = 2162] = "MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN"] = 2163] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED"] = 2165] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED"] = 2166] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDED"] = 2167] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS"] = 2168] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS";
  TalerErrorCode2[TalerErrorCode2["DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2169] = "DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED"] = 2170] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING"] = 2171] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH"] = 2172] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED"] = 2173] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING"] = 2174] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED"] = 2175] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH"] = 2200] = "MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID"] = 2201] = "MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED"] = 2251] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED"] = 2252] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND"] = 2253] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2254] = "MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH"] = 2255] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY"] = 2256] = "MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND"] = 2300] = "MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED"] = 2301] = "MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE"] = 2302] = "MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED"] = 2350] = "MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE"] = 2400] = "MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR"] = 2403] = "MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_SUMMATION_FAILED"] = 2404] = "MERCHANT_REWARD_PICKUP_SUMMATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_HAS_EXPIRED"] = 2405] = "MERCHANT_REWARD_PICKUP_HAS_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING"] = 2406] = "MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN"] = 2407] = "MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE"] = 2500] = "MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME"] = 2501] = "MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR"] = 2502] = "MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS"] = 2503] = "MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE"] = 2504] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST"] = 2505] = "MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER"] = 2506] = "MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST"] = 2507] = "MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST"] = 2508] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD"] = 2509] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT"] = 2510] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE"] = 2511] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT"] = 2520] = "MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID"] = 2521] = "MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT"] = 2530] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID"] = 2531] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT"] = 2532] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN"] = 2550] = "MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR"] = 2551] = "MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS"] = 2552] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS"] = 2553] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE"] = 2554] = "MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND"] = 2555] = "MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED"] = 2556] = "MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION"] = 2557] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS"] = 2258] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST"] = 2259] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE"] = 2260] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND"] = 2261] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED"] = 2262] = "MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE"] = 2263] = "MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE"] = 2264] = "MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS"] = 2563] = "MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS"] = 2600] = "MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH"] = 2601] = "MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH"] = 2602] = "MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED"] = 2603] = "MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED"] = 2625] = "MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT"] = 2626] = "MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_EXISTS"] = 2627] = "MERCHANT_PRIVATE_ACCOUNT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS"] = 2650] = "MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED"] = 2660] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS"] = 2661] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED"] = 2662] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED"] = 2663] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS"] = 2670] = "MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK"] = 2680] = "MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD"] = 2700] = "MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED"] = 2701] = "MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE"] = 2710] = "MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED"] = 2750] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN"] = 2751] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS"] = 2752] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND"] = 2753] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE"] = 2800] = "MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS"] = 2850] = "MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS"] = 2851] = "MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT"] = 2860] = "MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT"] = 2861] = "MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT"] = 2862] = "MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY"] = 2863] = "MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS"] = 2900] = "MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS"] = 2910] = "MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID"] = 3100] = "AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED"] = 3101] = "AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED";
  TalerErrorCode2[TalerErrorCode2["BANK_SAME_ACCOUNT"] = 5101] = "BANK_SAME_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_UNALLOWED_DEBIT"] = 5102] = "BANK_UNALLOWED_DEBIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NEGATIVE_NUMBER_AMOUNT"] = 5103] = "BANK_NEGATIVE_NUMBER_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_NUMBER_TOO_BIG"] = 5104] = "BANK_NUMBER_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_ACCOUNT"] = 5106] = "BANK_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSACTION_NOT_FOUND"] = 5107] = "BANK_TRANSACTION_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_FORMAT_AMOUNT"] = 5108] = "BANK_BAD_FORMAT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_REJECT_NO_RIGHTS"] = 5109] = "BANK_REJECT_NO_RIGHTS";
  TalerErrorCode2[TalerErrorCode2["BANK_UNMANAGED_EXCEPTION"] = 5110] = "BANK_UNMANAGED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_SOFT_EXCEPTION"] = 5111] = "BANK_SOFT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_REQUEST_UID_REUSED"] = 5112] = "BANK_TRANSFER_REQUEST_UID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT"] = 5113] = "BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_DUPLICATE_RESERVE_PUB_SUBJECT"] = 5114] = "BANK_DUPLICATE_RESERVE_PUB_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["BANK_ANCIENT_TRANSACTION_GONE"] = 5115] = "BANK_ANCIENT_TRANSACTION_GONE";
  TalerErrorCode2[TalerErrorCode2["BANK_ABORT_CONFIRM_CONFLICT"] = 5116] = "BANK_ABORT_CONFIRM_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_ABORT_CONFLICT"] = 5117] = "BANK_CONFIRM_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_CONFLICT"] = 5118] = "BANK_REGISTER_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_POST_WITHDRAWAL_OPERATION_REQUIRED"] = 5119] = "BANK_POST_WITHDRAWAL_OPERATION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_RESERVED_USERNAME_CONFLICT"] = 5120] = "BANK_RESERVED_USERNAME_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_USERNAME_REUSE"] = 5121] = "BANK_REGISTER_USERNAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_PAYTO_URI_REUSE"] = 5122] = "BANK_REGISTER_PAYTO_URI_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_BALANCE_NOT_ZERO"] = 5123] = "BANK_ACCOUNT_BALANCE_NOT_ZERO";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_CREDITOR"] = 5124] = "BANK_UNKNOWN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_DEBTOR"] = 5125] = "BANK_UNKNOWN_DEBTOR";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_EXCHANGE"] = 5126] = "BANK_ACCOUNT_IS_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_NOT_EXCHANGE"] = 5127] = "BANK_ACCOUNT_IS_NOT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_CONVERSION"] = 5128] = "BANK_BAD_CONVERSION";
  TalerErrorCode2[TalerErrorCode2["BANK_MISSING_TAN_INFO"] = 5129] = "BANK_MISSING_TAN_INFO";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_INCOMPLETE"] = 5130] = "BANK_CONFIRM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_RATE_LIMITED"] = 5131] = "BANK_TAN_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_NOT_SUPPORTED"] = 5132] = "BANK_TAN_CHANNEL_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_SCRIPT_FAILED"] = 5133] = "BANK_TAN_CHANNEL_SCRIPT_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_FAILED"] = 5134] = "BANK_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_LEGAL_NAME"] = 5135] = "BANK_NON_ADMIN_PATCH_LEGAL_NAME";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_DEBT_LIMIT"] = 5136] = "BANK_NON_ADMIN_PATCH_DEBT_LIMIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD"] = 5137] = "BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_BAD_OLD_PASSWORD"] = 5138] = "BANK_PATCH_BAD_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_ADMIN_EXCHANGE"] = 5139] = "BANK_PATCH_ADMIN_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["SYNC_ACCOUNT_UNKNOWN"] = 6100] = "SYNC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_NONE_MATCH"] = 6101] = "SYNC_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_MATCH"] = 6102] = "SYNC_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_SYNC_SIGNATURE"] = 6103] = "SYNC_BAD_SYNC_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_SIGNATURE"] = 6104] = "SYNC_INVALID_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_MALFORMED_CONTENT_LENGTH"] = 6105] = "SYNC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_EXCESSIVE_CONTENT_LENGTH"] = 6106] = "SYNC_EXCESSIVE_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 6107] = "SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_UPLOAD"] = 6108] = "SYNC_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_GENERIC_TIMEOUT"] = 6109] = "SYNC_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_CREATE_BACKEND_ERROR"] = 6110] = "SYNC_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_PREVIOUS_BACKUP_UNKNOWN"] = 6111] = "SYNC_PREVIOUS_BACKUP_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_MISSING_CONTENT_LENGTH"] = 6112] = "SYNC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_ERROR"] = 6113] = "SYNC_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_TIMEOUT"] = 6114] = "SYNC_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE"] = 7e3] = "WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_EXCEPTION"] = 7001] = "WALLET_UNEXPECTED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["WALLET_RECEIVED_MALFORMED_RESPONSE"] = 7002] = "WALLET_RECEIVED_MALFORMED_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["WALLET_NETWORK_ERROR"] = 7003] = "WALLET_NETWORK_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_THROTTLED"] = 7004] = "WALLET_HTTP_REQUEST_THROTTLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_REQUEST_ERROR"] = 7005] = "WALLET_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT"] = 7006] = "WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_OPERATION_UNKNOWN"] = 7007] = "WALLET_CORE_API_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["WALLET_INVALID_TALER_PAY_URI"] = 7008] = "WALLET_INVALID_TALER_PAY_URI";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_COIN_SIGNATURE_INVALID"] = 7009] = "WALLET_EXCHANGE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_WITHDRAW_RESERVE_UNKNOWN_AT_EXCHANGE"] = 7010] = "WALLET_EXCHANGE_WITHDRAW_RESERVE_UNKNOWN_AT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_NOT_AVAILABLE"] = 7011] = "WALLET_CORE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK"] = 7012] = "WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_GENERIC_TIMEOUT"] = 7013] = "WALLET_HTTP_REQUEST_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_CLAIMED"] = 7014] = "WALLET_ORDER_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_GROUP_INCOMPLETE"] = 7015] = "WALLET_WITHDRAWAL_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REWARD_COIN_SIGNATURE_INVALID"] = 7016] = "WALLET_REWARD_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE"] = 7017] = "WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH"] = 7018] = "WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_SIGNATURE_INVALID"] = 7019] = "WALLET_CONTRACT_TERMS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_MALFORMED"] = 7020] = "WALLET_CONTRACT_TERMS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PENDING_OPERATION_FAILED"] = 7021] = "WALLET_PENDING_OPERATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_SERVER_ERROR"] = 7022] = "WALLET_PAY_MERCHANT_SERVER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_ERROR"] = 7023] = "WALLET_CRYPTO_WORKER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_BAD_REQUEST"] = 7024] = "WALLET_CRYPTO_WORKER_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_KYC_REQUIRED"] = 7025] = "WALLET_WITHDRAWAL_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE"] = 7026] = "WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE"] = 7027] = "WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE"] = 7028] = "WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REFRESH_GROUP_INCOMPLETE"] = 7029] = "WALLET_REFRESH_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_BASE_URL_MISMATCH"] = 7030] = "WALLET_EXCHANGE_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_PAID"] = 7031] = "WALLET_ORDER_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_TIMEOUT"] = 8e3] = "ANASTASIS_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST"] = 8001] = "ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_ERROR"] = 8002] = "ANASTASIS_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH"] = 8003] = "ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH"] = 8004] = "ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR"] = 8005] = "ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED"] = 8006] = "ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED"] = 8007] = "ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PROVIDER_UNREACHABLE"] = 8008] = "ANASTASIS_GENERIC_PROVIDER_UNREACHABLE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_PAYMENT_GENERIC_TIMEOUT"] = 8009] = "ANASTASIS_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNKNOWN"] = 8108] = "ANASTASIS_TRUTH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED"] = 8109] = "ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED"] = 8110] = "ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_FAILED"] = 8111] = "ANASTASIS_TRUTH_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_UNKNOWN"] = 8112] = "ANASTASIS_TRUTH_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED"] = 8114] = "ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_KEY_SHARE_GONE"] = 8115] = "ANASTASIS_TRUTH_KEY_SHARE_GONE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_ORDER_DISAPPEARED"] = 8116] = "ANASTASIS_TRUTH_ORDER_DISAPPEARED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD"] = 8117] = "ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS"] = 8118] = "ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR"] = 8119] = "ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_DECRYPTION_FAILED"] = 8120] = "ANASTASIS_TRUTH_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_RATE_LIMITED"] = 8121] = "ANASTASIS_TRUTH_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD"] = 8123] = "ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS"] = 8150] = "ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED"] = 8151] = "ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_PHONE_INVALID"] = 8200] = "ANASTASIS_SMS_PHONE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_EXEC_FAILED"] = 8201] = "ANASTASIS_SMS_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_COMMAND_FAILED"] = 8202] = "ANASTASIS_SMS_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_INVALID"] = 8210] = "ANASTASIS_EMAIL_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_EXEC_FAILED"] = 8211] = "ANASTASIS_EMAIL_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_COMMAND_FAILED"] = 8212] = "ANASTASIS_EMAIL_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_INVALID"] = 8220] = "ANASTASIS_POST_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_EXEC_FAILED"] = 8221] = "ANASTASIS_POST_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_COMMAND_FAILED"] = 8222] = "ANASTASIS_POST_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_INVALID"] = 8230] = "ANASTASIS_IBAN_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_MISSING_TRANSFER"] = 8231] = "ANASTASIS_IBAN_MISSING_TRANSFER";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_MISSING"] = 8240] = "ANASTASIS_TOTP_KEY_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_INVALID"] = 8241] = "ANASTASIS_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_NONE_MATCH"] = 8301] = "ANASTASIS_POLICY_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 8304] = "ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_SIGNATURE"] = 8305] = "ANASTASIS_POLICY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_MATCH"] = 8306] = "ANASTASIS_POLICY_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_INVALID_UPLOAD"] = 8307] = "ANASTASIS_POLICY_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_NOT_FOUND"] = 8350] = "ANASTASIS_POLICY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_ACTION_INVALID"] = 8400] = "ANASTASIS_REDUCER_ACTION_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_STATE_INVALID"] = 8401] = "ANASTASIS_REDUCER_STATE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID"] = 8402] = "ANASTASIS_REDUCER_INPUT_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED"] = 8403] = "ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE"] = 8404] = "ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKEND_FAILURE"] = 8405] = "ANASTASIS_REDUCER_BACKEND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MALFORMED"] = 8406] = "ANASTASIS_REDUCER_RESOURCE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MISSING"] = 8407] = "ANASTASIS_REDUCER_RESOURCE_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_REGEX_FAILED"] = 8408] = "ANASTASIS_REDUCER_INPUT_REGEX_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED"] = 8409] = "ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED"] = 8410] = "ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED"] = 8411] = "ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED"] = 8412] = "ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_MALFORMED"] = 8413] = "ANASTASIS_REDUCER_POLICY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_NETWORK_FAILED"] = 8414] = "ANASTASIS_REDUCER_NETWORK_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_MALFORMED"] = 8415] = "ANASTASIS_REDUCER_SECRET_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG"] = 8416] = "ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_TOO_BIG"] = 8417] = "ANASTASIS_REDUCER_SECRET_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG"] = 8418] = "ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INTERNAL_ERROR"] = 8419] = "ANASTASIS_REDUCER_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED"] = 8420] = "ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_GENERIC_ERROR"] = 9e3] = "LIBEUFIN_NEXUS_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION"] = 9001] = "LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_GENERIC_ERROR"] = 9500] = "LIBEUFIN_SANDBOX_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION"] = 9501] = "LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["TALDIR_METHOD_NOT_SUPPORTED"] = 9600] = "TALDIR_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["TALDIR_REGISTER_RATE_LIMITED"] = 9601] = "TALDIR_REGISTER_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_UNKNOWN"] = 9750] = "CHALLENGER_GENERIC_CLIENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI"] = 9751] = "CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_HELPER_EXEC_FAILED"] = 9752] = "CHALLENGER_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GRANT_UNKNOWN"] = 9753] = "CHALLENGER_GRANT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE"] = 9754] = "CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_VALIDATION_UNKNOWN"] = 9755] = "CHALLENGER_GENERIC_VALIDATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE"] = 9756] = "CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_TOO_MANY_ATTEMPTS"] = 9757] = "CHALLENGER_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_INVALID_PIN"] = 9758] = "CHALLENGER_INVALID_PIN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_MISSING_ADDRESS"] = 9759] = "CHALLENGER_MISSING_ADDRESS";
  TalerErrorCode2[TalerErrorCode2["END"] = 9999] = "END";
})(TalerErrorCode || (TalerErrorCode = {}));

// ../taler-util/lib/codec.js
var DecodingError = class extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, DecodingError.prototype);
    this.name = "DecodingError";
  }
};
function renderContext(c4) {
  const p4 = c4 == null ? void 0 : c4.path;
  if (p4) {
    return p4.join(".");
  } else {
    return "(unknown)";
  }
}
function joinContext(c4, part) {
  var _a;
  const path = (_a = c4 == null ? void 0 : c4.path) != null ? _a : [];
  return {
    path: path.concat([part])
  };
}
var ObjectCodecBuilder = class {
  constructor() {
    this.propList = [];
  }
  /**
   * Define a property for the object.
   */
  property(x6, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x6, codec });
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const propList = this.propList;
    return {
      decode(x6, c4) {
        if (!c4) {
          c4 = {
            path: [`(${objectDisplayName})`]
          };
        }
        if (typeof x6 !== "object") {
          throw new DecodingError(`expected object for ${objectDisplayName} at ${renderContext(c4)} but got ${typeof x6}`);
        }
        const obj = {};
        for (const prop of propList) {
          const propRawVal = x6[prop.name];
          const propVal = prop.codec.decode(propRawVal, joinContext(c4, prop.name));
          obj[prop.name] = propVal;
        }
        return obj;
      }
    };
  }
};
var UnionCodecBuilder = class {
  constructor(discriminator, baseCodec) {
    this.discriminator = discriminator;
    this.baseCodec = baseCodec;
    this.alternatives = /* @__PURE__ */ new Map();
  }
  /**
   * Define a property for the object.
   */
  alternative(tagValue, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.alternatives.set(tagValue, { codec, tagValue });
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const alternatives = this.alternatives;
    const discriminator = this.discriminator;
    const baseCodec = this.baseCodec;
    return {
      decode(x6, c4) {
        if (!c4) {
          c4 = {
            path: [`(${objectDisplayName})`]
          };
        }
        const d5 = x6[discriminator];
        if (d5 === void 0) {
          throw new DecodingError(`expected tag for ${objectDisplayName} at ${renderContext(c4)}.${String(discriminator)}`);
        }
        const alt = alternatives.get(d5);
        if (!alt) {
          throw new DecodingError(`unknown tag for ${objectDisplayName} ${d5} at ${renderContext(c4)}.${String(discriminator)}`);
        }
        const altDecoded = alt.codec.decode(x6);
        if (baseCodec) {
          const baseDecoded = baseCodec.decode(x6, c4);
          return __spreadValues(__spreadValues({}, baseDecoded), altDecoded);
        } else {
          return altDecoded;
        }
      }
    };
  }
};
var UnionCodecPreBuilder = class {
  discriminateOn(discriminator, baseCodec) {
    return new UnionCodecBuilder(discriminator, baseCodec);
  }
};
function buildCodecForObject() {
  return new ObjectCodecBuilder();
}
function buildCodecForUnion() {
  return new UnionCodecPreBuilder();
}
function codecForMap(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x6, c4) {
      const map2 = {};
      if (typeof x6 !== "object") {
        throw new DecodingError(`expected object at ${renderContext(c4)}`);
      }
      for (const i4 in x6) {
        map2[i4] = innerCodec.decode(x6[i4], joinContext(c4, `[${i4}]`));
      }
      return map2;
    }
  };
}
function codecForList(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x6, c4) {
      const arr = [];
      if (!Array.isArray(x6)) {
        throw new DecodingError(`expected array at ${renderContext(c4)}`);
      }
      for (const i4 in x6) {
        arr.push(innerCodec.decode(x6[i4], joinContext(c4, `[${i4}]`)));
      }
      return arr;
    }
  };
}
function codecForNumber() {
  return {
    decode(x6, c4) {
      if (typeof x6 === "number") {
        return x6;
      }
      throw new DecodingError(`expected number at ${renderContext(c4)} but got ${typeof x6}`);
    }
  };
}
function codecForBoolean() {
  return {
    decode(x6, c4) {
      if (typeof x6 === "boolean") {
        return x6;
      }
      throw new DecodingError(`expected boolean at ${renderContext(c4)} but got ${typeof x6}`);
    }
  };
}
function codecForString() {
  return {
    decode(x6, c4) {
      if (typeof x6 === "string") {
        return x6;
      }
      throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x6}`);
    }
  };
}
function codecForAny() {
  return {
    decode(x6, c4) {
      return x6;
    }
  };
}
function codecForConstString(s5) {
  return {
    decode(x6, c4) {
      if (x6 === s5) {
        return x6;
      }
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string constant "${s5}" at ${renderContext(c4)} but got ${typeof x6}`);
      }
      throw new DecodingError(`expected string constant "${s5}" at ${renderContext(c4)} but got string value "${x6}"`);
    }
  };
}
function codecOptional(innerCodec) {
  return {
    decode(x6, c4) {
      if (x6 === void 0 || x6 === null) {
        return void 0;
      }
      return innerCodec.decode(x6, c4);
    }
  };
}
function codecForEither(...alts) {
  return {
    decode(x6, c4) {
      for (const alt of alts) {
        try {
          return alt.decode(x6, c4);
        } catch (e4) {
          continue;
        }
      }
      throw new DecodingError(`No alternative matched at at ${renderContext(c4)}`);
    }
  };
}
var x = codecForEither(codecForString(), codecForNumber());

// ../taler-util/lib/amounts.js
var amountFractionalBase = 1e8;
var amountFractionalLength = 8;
var amountMaxValue = __pow(2, 52);
var FRAC_SEPARATOR = ".";
function codecForAmountString() {
  return {
    decode(x6, c4) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x6}`);
      }
      if (Amounts.parse(x6) === void 0) {
        throw new DecodingError(`invalid amount at ${renderContext(c4)} got "${x6}"`);
      }
      return x6;
    }
  };
}
var Amounts = class {
  constructor() {
    throw Error("not instantiable");
  }
  static currencyOf(amount) {
    const amt = Amounts.parseOrThrow(amount);
    return amt.currency;
  }
  static zeroOfAmount(amount) {
    const amt = Amounts.parseOrThrow(amount);
    return {
      currency: amt.currency,
      fraction: 0,
      value: 0
    };
  }
  /**
   * Get an amount that represents zero units of a currency.
   */
  static zeroOfCurrency(currency) {
    return {
      currency,
      fraction: 0,
      value: 0
    };
  }
  static jsonifyAmount(amt) {
    if (typeof amt === "string") {
      return Amounts.parseOrThrow(amt);
    }
    return amt;
  }
  static divmod(a1, a22) {
    const am1 = Amounts.jsonifyAmount(a1);
    const am2 = Amounts.jsonifyAmount(a22);
    if (am1.currency != am2.currency) {
      throw Error(`incompatible currency (${am1.currency} vs${am2.currency})`);
    }
    const x1 = BigInt(am1.value) * BigInt(amountFractionalBase) + BigInt(am1.fraction);
    const x22 = BigInt(am2.value) * BigInt(amountFractionalBase) + BigInt(am2.fraction);
    const quotient = x1 / x22;
    const remainderScaled = x1 % x22;
    return {
      quotient: Number(quotient),
      remainder: {
        currency: am1.currency,
        value: Number(remainderScaled / BigInt(amountFractionalBase)),
        fraction: Number(remainderScaled % BigInt(amountFractionalBase))
      }
    };
  }
  static sum(amounts) {
    if (amounts.length <= 0) {
      throw Error("can't sum zero amounts");
    }
    const jsonAmounts = amounts.map((x6) => Amounts.jsonifyAmount(x6));
    return Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  static sumOrZero(currency, amounts) {
    if (amounts.length <= 0) {
      return {
        amount: Amounts.zeroOfCurrency(currency),
        saturated: false
      };
    }
    const jsonAmounts = amounts.map((x6) => Amounts.jsonifyAmount(x6));
    return Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  /**
   * Add two amounts.  Return the result and whether
   * the addition overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static add(first, ...rest) {
    const firstJ = Amounts.jsonifyAmount(first);
    const currency = firstJ.currency;
    let value = firstJ.value + Math.floor(firstJ.fraction / amountFractionalBase);
    if (value > amountMaxValue) {
      return {
        amount: {
          currency,
          value: amountMaxValue,
          fraction: amountFractionalBase - 1
        },
        saturated: true
      };
    }
    let fraction = firstJ.fraction % amountFractionalBase;
    for (const x6 of rest) {
      const xJ = Amounts.jsonifyAmount(x6);
      if (xJ.currency.toUpperCase() !== currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${xJ.currency} and ${currency}`);
      }
      value = value + xJ.value + Math.floor((fraction + xJ.fraction) / amountFractionalBase);
      fraction = Math.floor((fraction + xJ.fraction) % amountFractionalBase);
      if (value > amountMaxValue) {
        return {
          amount: {
            currency,
            value: amountMaxValue,
            fraction: amountFractionalBase - 1
          },
          saturated: true
        };
      }
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Subtract two amounts.  Return the result and whether
   * the subtraction overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static sub(a5, ...rest) {
    const aJ = Amounts.jsonifyAmount(a5);
    const currency = aJ.currency;
    let value = aJ.value;
    let fraction = aJ.fraction;
    for (const b4 of rest) {
      const bJ = Amounts.jsonifyAmount(b4);
      if (bJ.currency.toUpperCase() !== aJ.currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${bJ.currency} and ${currency}`);
      }
      if (fraction < bJ.fraction) {
        if (value < 1) {
          return {
            amount: { currency, value: 0, fraction: 0 },
            saturated: true
          };
        }
        value--;
        fraction += amountFractionalBase;
      }
      console.assert(fraction >= bJ.fraction);
      fraction -= bJ.fraction;
      if (value < bJ.value) {
        return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
      }
      value -= bJ.value;
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Compare two amounts.  Returns 0 when equal, -1 when a < b
   * and +1 when a > b.  Throws when currencies don't match.
   */
  static cmp(a5, b4) {
    a5 = Amounts.jsonifyAmount(a5);
    b4 = Amounts.jsonifyAmount(b4);
    if (a5.currency !== b4.currency) {
      throw Error(`Mismatched currency: ${a5.currency} and ${b4.currency}`);
    }
    const av = a5.value + Math.floor(a5.fraction / amountFractionalBase);
    const af = a5.fraction % amountFractionalBase;
    const bv = b4.value + Math.floor(b4.fraction / amountFractionalBase);
    const bf = b4.fraction % amountFractionalBase;
    switch (true) {
      case av < bv:
        return -1;
      case av > bv:
        return 1;
      case af < bf:
        return -1;
      case af > bf:
        return 1;
      case af === bf:
        return 0;
      default:
        throw Error("assertion failed");
    }
  }
  /**
   * Create a copy of an amount.
   */
  static copy(a5) {
    return {
      currency: a5.currency,
      fraction: a5.fraction,
      value: a5.value
    };
  }
  /**
   * Divide an amount.  Throws on division by zero.
   */
  static divide(a5, n2) {
    if (n2 === 0) {
      throw Error(`Division by 0`);
    }
    if (n2 === 1) {
      return { value: a5.value, fraction: a5.fraction, currency: a5.currency };
    }
    const r3 = a5.value % n2;
    return {
      currency: a5.currency,
      fraction: Math.floor((r3 * amountFractionalBase + a5.fraction) / n2),
      value: Math.floor(a5.value / n2)
    };
  }
  /**
   * Check if an amount is non-zero.
   */
  static isNonZero(a5) {
    a5 = Amounts.jsonifyAmount(a5);
    return a5.value > 0 || a5.fraction > 0;
  }
  static isZero(a5) {
    a5 = Amounts.jsonifyAmount(a5);
    return a5.value === 0 && a5.fraction === 0;
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parse(s5) {
    const res = s5.match(/^([a-zA-Z]{1,11}):([0-9]+)([.][0-9]{1,8})?$/);
    if (!res) {
      return void 0;
    }
    const tail = res[3] || FRAC_SEPARATOR + "0";
    if (tail.length > amountFractionalLength + 1) {
      return void 0;
    }
    const value = Number.parseInt(res[2]);
    if (value > amountMaxValue) {
      return void 0;
    }
    return {
      currency: res[1].toUpperCase(),
      fraction: Math.round(amountFractionalBase * Number.parseFloat(tail)),
      value
    };
  }
  /**
   * Parse amount in standard string form (like 'EUR:20.5'),
   * throw if the input is not a valid amount.
   */
  static parseOrThrow(s5) {
    if (typeof s5 === "object") {
      if (typeof s5.currency !== "string") {
        throw Error("invalid amount object");
      }
      if (typeof s5.value !== "number") {
        throw Error("invalid amount object");
      }
      if (typeof s5.fraction !== "number") {
        throw Error("invalid amount object");
      }
      return { currency: s5.currency, value: s5.value, fraction: s5.fraction };
    } else if (typeof s5 === "string") {
      const res = Amounts.parse(s5);
      if (!res) {
        throw Error(`Can't parse amount: "${s5}"`);
      }
      return res;
    } else {
      throw Error("invalid amount (illegal type)");
    }
  }
  static min(a5, b4) {
    const cr = Amounts.cmp(a5, b4);
    if (cr >= 0) {
      return Amounts.jsonifyAmount(b4);
    } else {
      return Amounts.jsonifyAmount(a5);
    }
  }
  static max(a5, b4) {
    const cr = Amounts.cmp(a5, b4);
    if (cr >= 0) {
      return Amounts.jsonifyAmount(a5);
    } else {
      return Amounts.jsonifyAmount(b4);
    }
  }
  static mult(a5, n2) {
    a5 = this.jsonifyAmount(a5);
    if (!Number.isInteger(n2)) {
      throw Error("amount can only be multipied by an integer");
    }
    if (n2 < 0) {
      throw Error("amount can only be multiplied by a positive integer");
    }
    if (n2 == 0) {
      return {
        amount: Amounts.zeroOfCurrency(a5.currency),
        saturated: false
      };
    }
    let x6 = a5;
    let acc = Amounts.zeroOfCurrency(a5.currency);
    while (n2 > 1) {
      if (n2 % 2 == 0) {
        n2 = n2 / 2;
      } else {
        n2 = (n2 - 1) / 2;
        const r23 = Amounts.add(acc, x6);
        if (r23.saturated) {
          return r23;
        }
        acc = r23.amount;
      }
      const r22 = Amounts.add(x6, x6);
      if (r22.saturated) {
        return r22;
      }
      x6 = r22.amount;
    }
    return Amounts.add(acc, x6);
  }
  /**
   * Check if the argument is a valid amount in string form.
   */
  static check(a5) {
    if (typeof a5 !== "string") {
      return false;
    }
    try {
      const parsedAmount = Amounts.parse(a5);
      return !!parsedAmount;
    } catch (e4) {
      return false;
    }
  }
  /**
   * Convert to standard human-readable string representation that's
   * also used in JSON formats.
   */
  static stringify(a5) {
    a5 = Amounts.jsonifyAmount(a5);
    const s5 = this.stringifyValue(a5);
    return `${a5.currency}:${s5}`;
  }
  static isSameCurrency(a1, a22) {
    const x1 = this.jsonifyAmount(a1);
    const x22 = this.jsonifyAmount(a22);
    return x1.currency.toUpperCase() === x22.currency.toUpperCase();
  }
  static stringifyValue(a5, minFractional = 0) {
    const aJ = Amounts.jsonifyAmount(a5);
    const av = aJ.value + Math.floor(aJ.fraction / amountFractionalBase);
    const af = aJ.fraction % amountFractionalBase;
    let s5 = av.toString();
    if (af || minFractional) {
      s5 = s5 + FRAC_SEPARATOR;
      let n2 = af;
      for (let i4 = 0; i4 < amountFractionalLength; i4++) {
        if (!n2 && i4 >= minFractional) {
          break;
        }
        s5 = s5 + Math.floor(n2 / amountFractionalBase * 10).toString();
        n2 = n2 * 10 % amountFractionalBase;
      }
    }
    return s5;
  }
  /**
   * Number of fractional digits needed to fully represent the amount
   * @param a amount
   * @returns
   */
  static maxFractionalDigits(a5) {
    if (a5.fraction === 0)
      return 0;
    if (a5.fraction < 0) {
      console.error("amount fraction can not be negative", a5);
      return 0;
    }
    let i4 = 0;
    let check = true;
    let rest = a5.fraction;
    while (rest > 0 && check) {
      check = rest % 10 === 0;
      rest = rest / 10;
      i4++;
    }
    return amountFractionalLength - i4 + 1;
  }
  static stringifyValueWithSpec(value, spec) {
    const strValue = Amounts.stringifyValue(value);
    const pos = strValue.indexOf(FRAC_SEPARATOR);
    const originalPosition = pos < 0 ? strValue.length : pos;
    let currency = value.currency;
    const names2 = Object.keys(spec.alt_unit_names);
    let FRAC_POS_NEW_POSITION = originalPosition;
    if (names2.length > 0) {
      let unitIndex = "0";
      names2.forEach((index) => {
        const i4 = Number.parseInt(index, 10);
        if (Number.isNaN(i4))
          return;
        if (originalPosition - i4 <= 0)
          return;
        if (originalPosition - i4 < FRAC_POS_NEW_POSITION) {
          FRAC_POS_NEW_POSITION = originalPosition - i4;
          unitIndex = index;
        }
      });
      currency = spec.alt_unit_names[unitIndex];
    }
    if (originalPosition === FRAC_POS_NEW_POSITION) {
      const { normal: normal2, small: small2 } = splitNormalAndSmall(strValue, originalPosition, spec);
      return { currency, normal: normal2, small: small2 };
    }
    const intPart = strValue.substring(0, originalPosition);
    const fracPArt = strValue.substring(originalPosition + 1);
    const newValue = intPart.substring(0, FRAC_POS_NEW_POSITION) + FRAC_SEPARATOR + intPart.substring(FRAC_POS_NEW_POSITION) + fracPArt;
    const { normal, small } = splitNormalAndSmall(newValue, FRAC_POS_NEW_POSITION, spec);
    return { currency, normal, small };
  }
};
function splitNormalAndSmall(decimal, fracSeparatorIndex, spec) {
  let normal;
  let small;
  if (decimal.length - fracSeparatorIndex - 1 > spec.num_fractional_normal_digits) {
    const limit = fracSeparatorIndex + spec.num_fractional_normal_digits + 1;
    normal = decimal.substring(0, limit);
    small = decimal.substring(limit);
  } else {
    normal = decimal;
    small = void 0;
  }
  return { normal, small };
}

// ../taler-util/lib/punycode.js
var maxInt = 2147483647;
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128;
var delimiter = "-";
var regexPunycode = /^xn--/;
var regexNonASCII = /[^\0-\x7E]/;
var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
var errors = {
  overflow: "Overflow: input needs wider integers to process",
  "not-basic": "Illegal input >= 0x80 (not a basic code point)",
  "invalid-input": "Invalid input"
};
var baseMinusTMin = base - tMin;
var floor = Math.floor;
var stringFromCharCode = String.fromCharCode;
function error(type) {
  throw new RangeError(errors[type]);
}
function map(array, fn2) {
  const result = [];
  let length = array.length;
  while (length--) {
    result[length] = fn2(array[length]);
  }
  return result;
}
function mapDomain(string, fn2) {
  const parts = string.split("@");
  let result = "";
  if (parts.length > 1) {
    result = parts[0] + "@";
    string = parts[1];
  }
  string = string.replace(regexSeparators, ".");
  const labels = string.split(".");
  const encoded = map(labels, fn2).join(".");
  return result + encoded;
}
function ucs2decode(string) {
  const output = [];
  let counter2 = 0;
  const length = string.length;
  while (counter2 < length) {
    const value = string.charCodeAt(counter2++);
    if (value >= 55296 && value <= 56319 && counter2 < length) {
      const extra = string.charCodeAt(counter2++);
      if ((extra & 64512) == 56320) {
        output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
      } else {
        output.push(value);
        counter2--;
      }
    } else {
      output.push(value);
    }
  }
  return output;
}
var ucs2encode = (array) => String.fromCodePoint(...array);
var basicToDigit = function(codePoint) {
  if (codePoint - 48 < 10) {
    return codePoint - 22;
  }
  if (codePoint - 65 < 26) {
    return codePoint - 65;
  }
  if (codePoint - 97 < 26) {
    return codePoint - 97;
  }
  return base;
};
var digitToBasic = function(digit, flag) {
  return digit + 22 + 75 * Number(digit < 26) - (Number(flag != 0) << 5);
};
var adapt = function(delta, numPoints, firstTime) {
  let k5 = 0;
  delta = firstTime ? floor(delta / damp) : delta >> 1;
  delta += floor(delta / numPoints);
  for (
    ;
    /* no initialization */
    delta > baseMinusTMin * tMax >> 1;
    k5 += base
  ) {
    delta = floor(delta / baseMinusTMin);
  }
  return floor(k5 + (baseMinusTMin + 1) * delta / (delta + skew));
};
var decode = function(input) {
  const output = [];
  const inputLength = input.length;
  let i4 = 0;
  let n2 = initialN;
  let bias = initialBias;
  let basic = input.lastIndexOf(delimiter);
  if (basic < 0) {
    basic = 0;
  }
  for (let j4 = 0; j4 < basic; ++j4) {
    if (input.charCodeAt(j4) >= 128) {
      error("not-basic");
    }
    output.push(input.charCodeAt(j4));
  }
  for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
    let oldi = i4;
    for (let w5 = 1, k5 = base; ; k5 += base) {
      if (index >= inputLength) {
        error("invalid-input");
      }
      const digit = basicToDigit(input.charCodeAt(index++));
      if (digit >= base || digit > floor((maxInt - i4) / w5)) {
        error("overflow");
      }
      i4 += digit * w5;
      const t4 = k5 <= bias ? tMin : k5 >= bias + tMax ? tMax : k5 - bias;
      if (digit < t4) {
        break;
      }
      const baseMinusT = base - t4;
      if (w5 > floor(maxInt / baseMinusT)) {
        error("overflow");
      }
      w5 *= baseMinusT;
    }
    const out = output.length + 1;
    bias = adapt(i4 - oldi, out, oldi == 0);
    if (floor(i4 / out) > maxInt - n2) {
      error("overflow");
    }
    n2 += floor(i4 / out);
    i4 %= out;
    output.splice(i4++, 0, n2);
  }
  return String.fromCodePoint(...output);
};
var encode = function(inputArg) {
  const output = [];
  let input = ucs2decode(inputArg);
  let inputLength = input.length;
  let n2 = initialN;
  let delta = 0;
  let bias = initialBias;
  for (const currentValue of input) {
    if (currentValue < 128) {
      output.push(stringFromCharCode(currentValue));
    }
  }
  let basicLength = output.length;
  let handledCPCount = basicLength;
  if (basicLength) {
    output.push(delimiter);
  }
  while (handledCPCount < inputLength) {
    let m5 = maxInt;
    for (const currentValue of input) {
      if (currentValue >= n2 && currentValue < m5) {
        m5 = currentValue;
      }
    }
    const handledCPCountPlusOne = handledCPCount + 1;
    if (m5 - n2 > floor((maxInt - delta) / handledCPCountPlusOne)) {
      error("overflow");
    }
    delta += (m5 - n2) * handledCPCountPlusOne;
    n2 = m5;
    for (const currentValue of input) {
      if (currentValue < n2 && ++delta > maxInt) {
        error("overflow");
      }
      if (currentValue == n2) {
        let q5 = delta;
        for (let k5 = base; ; k5 += base) {
          const t4 = k5 <= bias ? tMin : k5 >= bias + tMax ? tMax : k5 - bias;
          if (q5 < t4) {
            break;
          }
          const qMinusT = q5 - t4;
          const baseMinusT = base - t4;
          output.push(stringFromCharCode(digitToBasic(t4 + qMinusT % baseMinusT, 0)));
          q5 = floor(qMinusT / baseMinusT);
        }
        output.push(stringFromCharCode(digitToBasic(q5, 0)));
        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
        delta = 0;
        ++handledCPCount;
      }
    }
    ++delta;
    ++n2;
  }
  return output.join("");
};
var toUnicode = function(input) {
  return mapDomain(input, function(string) {
    return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
  });
};
var toASCII = function(input) {
  return mapDomain(input, function(string) {
    return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
  });
};
var punycode = {
  /**
   * A string representing the current Punycode.js version number.
   * @memberOf punycode
   * @type String
   */
  version: "2.1.0",
  /**
   * An object of methods to convert from JavaScript's internal character
   * representation (UCS-2) to Unicode code points, and back.
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode
   * @type Object
   */
  ucs2: {
    decode: ucs2decode,
    encode: ucs2encode
  },
  decode,
  encode,
  toASCII,
  toUnicode
};

// ../taler-util/lib/whatwg-url.js
var utf8Encoder = new TextEncoder();
var utf8Decoder = new TextDecoder("utf-8", { ignoreBOM: true });
function utf8Encode(string) {
  return utf8Encoder.encode(string);
}
function utf8DecodeWithoutBOM(bytes) {
  return utf8Decoder.decode(bytes);
}
function parseUrlencoded(input) {
  const sequences = strictlySplitByteSequence(input, p("&"));
  const output = [];
  for (const bytes of sequences) {
    if (bytes.length === 0) {
      continue;
    }
    let name, value;
    const indexOfEqual = bytes.indexOf(p("="));
    if (indexOfEqual >= 0) {
      name = bytes.slice(0, indexOfEqual);
      value = bytes.slice(indexOfEqual + 1);
    } else {
      name = bytes;
      value = new Uint8Array(0);
    }
    name = replaceByteInByteSequence(name, 43, 32);
    value = replaceByteInByteSequence(value, 43, 32);
    const nameString = utf8DecodeWithoutBOM(percentDecodeBytes(name));
    const valueString = utf8DecodeWithoutBOM(percentDecodeBytes(value));
    output.push([nameString, valueString]);
  }
  return output;
}
function parseUrlencodedString(input) {
  return parseUrlencoded(utf8Encode(input));
}
function serializeUrlencoded(tuples, encodingOverride = void 0) {
  let encoding = "utf-8";
  if (encodingOverride !== void 0) {
    encoding = encodingOverride;
  }
  let output = "";
  for (const [i4, tuple] of tuples.entries()) {
    const name = utf8PercentEncodeString(tuple[0], isURLEncodedPercentEncode, true);
    let value = tuple[1];
    if (tuple.length > 2 && tuple[2] !== void 0) {
      if (tuple[2] === "hidden" && name === "_charset_") {
        value = encoding;
      } else if (tuple[2] === "file") {
        value = value.name;
      }
    }
    value = utf8PercentEncodeString(value, isURLEncodedPercentEncode, true);
    if (i4 !== 0) {
      output += "&";
    }
    output += `${name}=${value}`;
  }
  return output;
}
function strictlySplitByteSequence(buf, cp) {
  const list = [];
  let last = 0;
  let i4 = buf.indexOf(cp);
  while (i4 >= 0) {
    list.push(buf.slice(last, i4));
    last = i4 + 1;
    i4 = buf.indexOf(cp, last);
  }
  if (last !== buf.length) {
    list.push(buf.slice(last));
  }
  return list;
}
function replaceByteInByteSequence(buf, from, to) {
  let i4 = buf.indexOf(from);
  while (i4 >= 0) {
    buf[i4] = to;
    i4 = buf.indexOf(from, i4 + 1);
  }
  return buf;
}
function p(char) {
  return char.codePointAt(0);
}
function percentEncode(c4) {
  let hex = c4.toString(16).toUpperCase();
  if (hex.length === 1) {
    hex = `0${hex}`;
  }
  return `%${hex}`;
}
function percentDecodeBytes(input) {
  const output = new Uint8Array(input.byteLength);
  let outputIndex = 0;
  for (let i4 = 0; i4 < input.byteLength; ++i4) {
    const byte = input[i4];
    if (byte !== 37) {
      output[outputIndex++] = byte;
    } else if (byte === 37 && (!isASCIIHex(input[i4 + 1]) || !isASCIIHex(input[i4 + 2]))) {
      output[outputIndex++] = byte;
    } else {
      const bytePoint = parseInt(String.fromCodePoint(input[i4 + 1], input[i4 + 2]), 16);
      output[outputIndex++] = bytePoint;
      i4 += 2;
    }
  }
  return output.slice(0, outputIndex);
}
function percentDecodeString(input) {
  const bytes = utf8Encode(input);
  return percentDecodeBytes(bytes);
}
function isC0ControlPercentEncode(c4) {
  return c4 <= 31 || c4 > 126;
}
var extraFragmentPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("<"),
  p(">"),
  p("`")
]);
function isFragmentPercentEncode(c4) {
  return isC0ControlPercentEncode(c4) || extraFragmentPercentEncodeSet.has(c4);
}
var extraQueryPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("#"),
  p("<"),
  p(">")
]);
function isQueryPercentEncode(c4) {
  return isC0ControlPercentEncode(c4) || extraQueryPercentEncodeSet.has(c4);
}
function isSpecialQueryPercentEncode(c4) {
  return isQueryPercentEncode(c4) || c4 === p("'");
}
var extraPathPercentEncodeSet = /* @__PURE__ */ new Set([p("?"), p("`"), p("{"), p("}")]);
function isPathPercentEncode(c4) {
  return isQueryPercentEncode(c4) || extraPathPercentEncodeSet.has(c4);
}
var extraUserinfoPercentEncodeSet = /* @__PURE__ */ new Set([
  p("/"),
  p(":"),
  p(";"),
  p("="),
  p("@"),
  p("["),
  p("\\"),
  p("]"),
  p("^"),
  p("|")
]);
function isUserinfoPercentEncode(c4) {
  return isPathPercentEncode(c4) || extraUserinfoPercentEncodeSet.has(c4);
}
var extraComponentPercentEncodeSet = /* @__PURE__ */ new Set([
  p("$"),
  p("%"),
  p("&"),
  p("+"),
  p(",")
]);
function isComponentPercentEncode(c4) {
  return isUserinfoPercentEncode(c4) || extraComponentPercentEncodeSet.has(c4);
}
var extraURLEncodedPercentEncodeSet = /* @__PURE__ */ new Set([
  p("!"),
  p("'"),
  p("("),
  p(")"),
  p("~")
]);
function isURLEncodedPercentEncode(c4) {
  return isComponentPercentEncode(c4) || extraURLEncodedPercentEncodeSet.has(c4);
}
function utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate) {
  const bytes = utf8Encode(codePoint);
  let output = "";
  for (const byte of bytes) {
    if (!percentEncodePredicate(byte)) {
      output += String.fromCharCode(byte);
    } else {
      output += percentEncode(byte);
    }
  }
  return output;
}
function utf8PercentEncodeCodePoint(codePoint, percentEncodePredicate) {
  return utf8PercentEncodeCodePointInternal(String.fromCodePoint(codePoint), percentEncodePredicate);
}
function utf8PercentEncodeString(input, percentEncodePredicate, spaceAsPlus = false) {
  let output = "";
  for (const codePoint of input) {
    if (spaceAsPlus && codePoint === " ") {
      output += "+";
    } else {
      output += utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate);
    }
  }
  return output;
}
function isASCIIDigit(c4) {
  return c4 >= 48 && c4 <= 57;
}
function isASCIIAlpha(c4) {
  return c4 >= 65 && c4 <= 90 || c4 >= 97 && c4 <= 122;
}
function isASCIIAlphanumeric(c4) {
  return isASCIIAlpha(c4) || isASCIIDigit(c4);
}
function isASCIIHex(c4) {
  return isASCIIDigit(c4) || c4 >= 65 && c4 <= 70 || c4 >= 97 && c4 <= 102;
}
var URLSearchParamsImpl = class {
  constructor(init, { doNotStripQMark = false } = {}) {
    this._list = [];
    this._url = null;
    if (!doNotStripQMark && typeof init === "string" && init[0] === "?") {
      init = init.slice(1);
    }
    if (Array.isArray(init)) {
      for (const pair of init) {
        if (pair.length !== 2) {
          throw new TypeError("Failed to construct 'URLSearchParams': parameter 1 sequence's element does not contain exactly two elements.");
        }
        this._list.push([pair[0], pair[1]]);
      }
    } else if (typeof init === "object" && Object.getPrototypeOf(init) === null) {
      for (const name of Object.keys(init)) {
        const value = init[name];
        this._list.push([name, value]);
      }
    } else {
      this._list = parseUrlencodedString(init);
    }
  }
  _updateSteps() {
    if (this._url !== null) {
      let query = serializeUrlencoded(this._list);
      if (query === "") {
        query = null;
      }
      this._url._url.query = query;
    }
  }
  append(name, value) {
    this._list.push([name, value]);
    this._updateSteps();
  }
  delete(name) {
    let i4 = 0;
    while (i4 < this._list.length) {
      if (this._list[i4][0] === name) {
        this._list.splice(i4, 1);
      } else {
        i4++;
      }
    }
    this._updateSteps();
  }
  get(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return tuple[1];
      }
    }
    return null;
  }
  getAll(name) {
    const output = [];
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        output.push(tuple[1]);
      }
    }
    return output;
  }
  forEach(callbackfn, thisArg) {
    for (const tuple of this._list) {
      callbackfn.call(thisArg, tuple[1], tuple[0], this);
    }
  }
  has(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return true;
      }
    }
    return false;
  }
  set(name, value) {
    let found = false;
    let i4 = 0;
    while (i4 < this._list.length) {
      if (this._list[i4][0] === name) {
        if (found) {
          this._list.splice(i4, 1);
        } else {
          found = true;
          this._list[i4][1] = value;
          i4++;
        }
      } else {
        i4++;
      }
    }
    if (!found) {
      this._list.push([name, value]);
    }
    this._updateSteps();
  }
  sort() {
    this._list.sort((a5, b4) => {
      if (a5[0] < b4[0]) {
        return -1;
      }
      if (a5[0] > b4[0]) {
        return 1;
      }
      return 0;
    });
    this._updateSteps();
  }
  [Symbol.iterator]() {
    return this._list[Symbol.iterator]();
  }
  toString() {
    return serializeUrlencoded(this._list);
  }
};
var specialSchemes = {
  ftp: 21,
  file: null,
  http: 80,
  https: 443,
  ws: 80,
  wss: 443
};
var failure = Symbol("failure");
function countSymbols(str) {
  return [...str].length;
}
function at(input, idx) {
  const c4 = input[idx];
  return isNaN(c4) ? void 0 : String.fromCodePoint(c4);
}
function isSingleDot(buffer) {
  return buffer === "." || buffer.toLowerCase() === "%2e";
}
function isDoubleDot(buffer) {
  buffer = buffer.toLowerCase();
  return buffer === ".." || buffer === "%2e." || buffer === ".%2e" || buffer === "%2e%2e";
}
function isWindowsDriveLetterCodePoints(cp1, cp2) {
  return isASCIIAlpha(cp1) && (cp2 === p(":") || cp2 === p("|"));
}
function isWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && (string[1] === ":" || string[1] === "|");
}
function isNormalizedWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && string[1] === ":";
}
function containsForbiddenHostCodePoint(string) {
  return string.search(/\u0000|\u0009|\u000A|\u000D|\u0020|#|\/|:|<|>|\?|@|\[|\\|\]|\^|\|/u) !== -1;
}
function containsForbiddenDomainCodePoint(string) {
  return containsForbiddenHostCodePoint(string) || string.search(/[\u0000-\u001F]|%|\u007F/u) !== -1;
}
function isSpecialScheme(scheme) {
  return specialSchemes[scheme] !== void 0;
}
function isSpecial(url) {
  return isSpecialScheme(url.scheme);
}
function isNotSpecial(url) {
  return !isSpecialScheme(url.scheme);
}
function defaultPort(scheme) {
  return specialSchemes[scheme];
}
function parseIPv4Number(input) {
  if (input === "") {
    return failure;
  }
  let R3 = 10;
  if (input.length >= 2 && input.charAt(0) === "0" && input.charAt(1).toLowerCase() === "x") {
    input = input.substring(2);
    R3 = 16;
  } else if (input.length >= 2 && input.charAt(0) === "0") {
    input = input.substring(1);
    R3 = 8;
  }
  if (input === "") {
    return 0;
  }
  let regex = /[^0-7]/u;
  if (R3 === 10) {
    regex = /[^0-9]/u;
  }
  if (R3 === 16) {
    regex = /[^0-9A-Fa-f]/u;
  }
  if (regex.test(input)) {
    return failure;
  }
  return parseInt(input, R3);
}
function parseIPv4(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length > 1) {
      parts.pop();
    }
  }
  if (parts.length > 4) {
    return failure;
  }
  const numbers = [];
  for (const part of parts) {
    const n2 = parseIPv4Number(part);
    if (n2 === failure) {
      return failure;
    }
    numbers.push(n2);
  }
  for (let i4 = 0; i4 < numbers.length - 1; ++i4) {
    if (numbers[i4] > 255) {
      return failure;
    }
  }
  if (numbers[numbers.length - 1] >= __pow(256, 5 - numbers.length)) {
    return failure;
  }
  let ipv4 = numbers.pop();
  let counter2 = 0;
  for (const n2 of numbers) {
    ipv4 += n2 * __pow(256, 3 - counter2);
    ++counter2;
  }
  return ipv4;
}
function serializeIPv4(address) {
  let output = "";
  let n2 = address;
  for (let i4 = 1; i4 <= 4; ++i4) {
    output = String(n2 % 256) + output;
    if (i4 !== 4) {
      output = `.${output}`;
    }
    n2 = Math.floor(n2 / 256);
  }
  return output;
}
function parseIPv6(inputArg) {
  const address = [0, 0, 0, 0, 0, 0, 0, 0];
  let pieceIndex = 0;
  let compress = null;
  let pointer = 0;
  const input = Array.from(inputArg, (c4) => c4.codePointAt(0));
  if (input[pointer] === p(":")) {
    if (input[pointer + 1] !== p(":")) {
      return failure;
    }
    pointer += 2;
    ++pieceIndex;
    compress = pieceIndex;
  }
  while (pointer < input.length) {
    if (pieceIndex === 8) {
      return failure;
    }
    if (input[pointer] === p(":")) {
      if (compress !== null) {
        return failure;
      }
      ++pointer;
      ++pieceIndex;
      compress = pieceIndex;
      continue;
    }
    let value = 0;
    let length = 0;
    while (length < 4 && isASCIIHex(input[pointer])) {
      value = value * 16 + parseInt(at(input, pointer), 16);
      ++pointer;
      ++length;
    }
    if (input[pointer] === p(".")) {
      if (length === 0) {
        return failure;
      }
      pointer -= length;
      if (pieceIndex > 6) {
        return failure;
      }
      let numbersSeen = 0;
      while (input[pointer] !== void 0) {
        let ipv4Piece = null;
        if (numbersSeen > 0) {
          if (input[pointer] === p(".") && numbersSeen < 4) {
            ++pointer;
          } else {
            return failure;
          }
        }
        if (!isASCIIDigit(input[pointer])) {
          return failure;
        }
        while (isASCIIDigit(input[pointer])) {
          const number = parseInt(at(input, pointer));
          if (ipv4Piece === null) {
            ipv4Piece = number;
          } else if (ipv4Piece === 0) {
            return failure;
          } else {
            ipv4Piece = ipv4Piece * 10 + number;
          }
          if (ipv4Piece > 255) {
            return failure;
          }
          ++pointer;
        }
        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
        ++numbersSeen;
        if (numbersSeen === 2 || numbersSeen === 4) {
          ++pieceIndex;
        }
      }
      if (numbersSeen !== 4) {
        return failure;
      }
      break;
    } else if (input[pointer] === p(":")) {
      ++pointer;
      if (input[pointer] === void 0) {
        return failure;
      }
    } else if (input[pointer] !== void 0) {
      return failure;
    }
    address[pieceIndex] = value;
    ++pieceIndex;
  }
  if (compress !== null) {
    let swaps = pieceIndex - compress;
    pieceIndex = 7;
    while (pieceIndex !== 0 && swaps > 0) {
      const temp = address[compress + swaps - 1];
      address[compress + swaps - 1] = address[pieceIndex];
      address[pieceIndex] = temp;
      --pieceIndex;
      --swaps;
    }
  } else if (compress === null && pieceIndex !== 8) {
    return failure;
  }
  return address;
}
function serializeIPv6(address) {
  let output = "";
  const compress = findLongestZeroSequence(address);
  let ignore0 = false;
  for (let pieceIndex = 0; pieceIndex <= 7; ++pieceIndex) {
    if (ignore0 && address[pieceIndex] === 0) {
      continue;
    } else if (ignore0) {
      ignore0 = false;
    }
    if (compress === pieceIndex) {
      const separator = pieceIndex === 0 ? "::" : ":";
      output += separator;
      ignore0 = true;
      continue;
    }
    output += address[pieceIndex].toString(16);
    if (pieceIndex !== 7) {
      output += ":";
    }
  }
  return output;
}
function parseHost(input, isNotSpecialArg = false) {
  if (input[0] === "[") {
    if (input[input.length - 1] !== "]") {
      return failure;
    }
    return parseIPv6(input.substring(1, input.length - 1));
  }
  if (isNotSpecialArg) {
    return parseOpaqueHost(input);
  }
  const domain = utf8DecodeWithoutBOM(percentDecodeString(input));
  const asciiDomain = domainToASCII(domain);
  if (asciiDomain === failure) {
    return failure;
  }
  if (containsForbiddenDomainCodePoint(asciiDomain)) {
    return failure;
  }
  if (endsInANumber(asciiDomain)) {
    return parseIPv4(asciiDomain);
  }
  return asciiDomain;
}
function endsInANumber(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length === 1) {
      return false;
    }
    parts.pop();
  }
  const last = parts[parts.length - 1];
  if (parseIPv4Number(last) !== failure) {
    return true;
  }
  if (/^[0-9]+$/u.test(last)) {
    return true;
  }
  return false;
}
function parseOpaqueHost(input) {
  if (containsForbiddenHostCodePoint(input)) {
    return failure;
  }
  return utf8PercentEncodeString(input, isC0ControlPercentEncode);
}
function findLongestZeroSequence(arr) {
  let maxIdx = null;
  let maxLen = 1;
  let currStart = null;
  let currLen = 0;
  for (let i4 = 0; i4 < arr.length; ++i4) {
    if (arr[i4] !== 0) {
      if (currLen > maxLen) {
        maxIdx = currStart;
        maxLen = currLen;
      }
      currStart = null;
      currLen = 0;
    } else {
      if (currStart === null) {
        currStart = i4;
      }
      ++currLen;
    }
  }
  if (currLen > maxLen) {
    return currStart;
  }
  return maxIdx;
}
function serializeHost(host) {
  if (typeof host === "number") {
    return serializeIPv4(host);
  }
  if (host instanceof Array) {
    return `[${serializeIPv6(host)}]`;
  }
  return host;
}
function domainToASCII(domain, beStrict = false) {
  let result;
  try {
    result = punycode.toASCII(domain);
  } catch (e4) {
    return failure;
  }
  if (result === null || result === "") {
    return failure;
  }
  return result;
}
function trimControlChars(url) {
  return url.replace(/^[\u0000-\u001F\u0020]+|[\u0000-\u001F\u0020]+$/gu, "");
}
function trimTabAndNewline(url) {
  return url.replace(/\u0009|\u000A|\u000D/gu, "");
}
function shortenPath(url) {
  const { path } = url;
  if (path.length === 0) {
    return;
  }
  if (url.scheme === "file" && path.length === 1 && isNormalizedWindowsDriveLetter(path[0])) {
    return;
  }
  path.pop();
}
function includesCredentials(url) {
  return url.username !== "" || url.password !== "";
}
function cannotHaveAUsernamePasswordPort(url) {
  return url.host === null || url.host === "" || url.scheme === "file";
}
function hasAnOpaquePath(url) {
  return typeof url.path === "string";
}
function isNormalizedWindowsDriveLetter(string) {
  return /^[A-Za-z]:$/u.test(string);
}
var URLStateMachine = class {
  constructor(input, base2, encodingOverride, url, stateOverride) {
    this.table = {
      "parse scheme start": this.parseSchemeStart,
      "parse scheme": this.parseScheme,
      "parse no scheme": this.parseNoScheme,
      "parse special relative or authority": this.parseSpecialRelativeOrAuthority,
      "parse path or authority": this.parsePathOrAuthority,
      "parse relative": this.parseRelative,
      "parse relative slash": this.parseRelativeSlash,
      "parse special authority slashes": this.parseSpecialAuthoritySlashes,
      "parse special authority ignore slashes": this.parseSpecialAuthorityIgnoreSlashes,
      "parse authority": this.parseAuthority,
      "parse host": this.parseHostName,
      "parse hostname": this.parseHostName,
      "parse port": this.parsePort,
      "parse file": this.parseFile,
      "parse file slash": this.parseFileSlash,
      "parse file host": this.parseFileHost,
      "parse path start": this.parsePathStart,
      "parse path": this.parsePath,
      "parse opaque path": this.parseOpaquePath,
      "parse query": this.parseQuery,
      "parse fragment": this.parseFragment
    };
    this.pointer = 0;
    this.base = base2 || null;
    this.encodingOverride = encodingOverride || "utf-8";
    this.url = url;
    this.failure = false;
    this.parseError = false;
    if (!this.url) {
      this.url = {
        scheme: "",
        username: "",
        password: "",
        host: null,
        port: null,
        path: [],
        query: null,
        fragment: null
      };
      const res2 = trimControlChars(input);
      if (res2 !== input) {
        this.parseError = true;
      }
      input = res2;
    }
    const res = trimTabAndNewline(input);
    if (res !== input) {
      this.parseError = true;
    }
    input = res;
    this.state = stateOverride || "scheme start";
    this.buffer = "";
    this.atFlag = false;
    this.arrFlag = false;
    this.passwordTokenSeenFlag = false;
    this.input = Array.from(input, (c4) => c4.codePointAt(0));
    for (; this.pointer <= this.input.length; ++this.pointer) {
      const c4 = this.input[this.pointer];
      const cStr = isNaN(c4) ? void 0 : String.fromCodePoint(c4);
      const ret = this.table[`parse ${this.state}`].call(this, c4, cStr);
      if (!ret) {
        break;
      } else if (ret === failure) {
        this.failure = true;
        break;
      }
    }
  }
  parseSchemeStart(c4, cStr) {
    if (isASCIIAlpha(c4)) {
      this.buffer += cStr.toLowerCase();
      this.state = "scheme";
    } else if (!this.stateOverride) {
      this.state = "no scheme";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseScheme(c4, cStr) {
    if (isASCIIAlphanumeric(c4) || c4 === p("+") || c4 === p("-") || c4 === p(".")) {
      this.buffer += cStr.toLowerCase();
    } else if (c4 === p(":")) {
      if (this.stateOverride) {
        if (isSpecial(this.url) && !isSpecialScheme(this.buffer)) {
          return false;
        }
        if (!isSpecial(this.url) && isSpecialScheme(this.buffer)) {
          return false;
        }
        if ((includesCredentials(this.url) || this.url.port !== null) && this.buffer === "file") {
          return false;
        }
        if (this.url.scheme === "file" && this.url.host === "") {
          return false;
        }
      }
      this.url.scheme = this.buffer;
      if (this.stateOverride) {
        if (this.url.port === defaultPort(this.url.scheme)) {
          this.url.port = null;
        }
        return false;
      }
      this.buffer = "";
      if (this.url.scheme === "file") {
        if (this.input[this.pointer + 1] !== p("/") || this.input[this.pointer + 2] !== p("/")) {
          this.parseError = true;
        }
        this.state = "file";
      } else if (isSpecial(this.url) && this.base !== null && this.base.scheme === this.url.scheme) {
        this.state = "special relative or authority";
      } else if (isSpecial(this.url)) {
        this.state = "special authority slashes";
      } else if (this.input[this.pointer + 1] === p("/")) {
        this.state = "path or authority";
        ++this.pointer;
      } else {
        this.url.path = [""];
        this.state = "opaque path";
      }
    } else if (!this.stateOverride) {
      this.buffer = "";
      this.state = "no scheme";
      this.pointer = -1;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseNoScheme(c4) {
    if (this.base === null || hasAnOpaquePath(this.base) && c4 !== p("#")) {
      return failure;
    } else if (hasAnOpaquePath(this.base) && c4 === p("#")) {
      this.url.scheme = this.base.scheme;
      this.url.path = this.base.path;
      this.url.query = this.base.query;
      this.url.fragment = "";
      this.state = "fragment";
    } else if (this.base.scheme === "file") {
      this.state = "file";
      --this.pointer;
    } else {
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parseSpecialRelativeOrAuthority(c4) {
    if (c4 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parsePathOrAuthority(c4) {
    if (c4 === p("/")) {
      this.state = "authority";
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseRelative(c4) {
    this.url.scheme = this.base.scheme;
    if (c4 === p("/")) {
      this.state = "relative slash";
    } else if (isSpecial(this.url) && c4 === p("\\")) {
      this.parseError = true;
      this.state = "relative slash";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c4)) {
        this.url.query = null;
        this.url.path.pop();
        this.state = "path";
        --this.pointer;
      }
    }
    return true;
  }
  parseRelativeSlash(c4) {
    if (isSpecial(this.url) && (c4 === p("/") || c4 === p("\\"))) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "special authority ignore slashes";
    } else if (c4 === p("/")) {
      this.state = "authority";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthoritySlashes(c4) {
    if (c4 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "special authority ignore slashes";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthorityIgnoreSlashes(c4) {
    if (c4 !== p("/") && c4 !== p("\\")) {
      this.state = "authority";
      --this.pointer;
    } else {
      this.parseError = true;
    }
    return true;
  }
  parseAuthority(c4, cStr) {
    if (c4 === p("@")) {
      this.parseError = true;
      if (this.atFlag) {
        this.buffer = `%40${this.buffer}`;
      }
      this.atFlag = true;
      const len = countSymbols(this.buffer);
      for (let pointer = 0; pointer < len; ++pointer) {
        const codePoint = this.buffer.codePointAt(pointer);
        if (codePoint === p(":") && !this.passwordTokenSeenFlag) {
          this.passwordTokenSeenFlag = true;
          continue;
        }
        const encodedCodePoints = utf8PercentEncodeCodePoint(codePoint, isUserinfoPercentEncode);
        if (this.passwordTokenSeenFlag) {
          this.url.password += encodedCodePoints;
        } else {
          this.url.username += encodedCodePoints;
        }
      }
      this.buffer = "";
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\")) {
      if (this.atFlag && this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      this.pointer -= countSymbols(this.buffer) + 1;
      this.buffer = "";
      this.state = "host";
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parseHostName(c4, cStr) {
    if (this.stateOverride && this.url.scheme === "file") {
      --this.pointer;
      this.state = "file host";
    } else if (c4 === p(":") && !this.arrFlag) {
      if (this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      if (this.stateOverride === "hostname") {
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "port";
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\")) {
      --this.pointer;
      if (isSpecial(this.url) && this.buffer === "") {
        this.parseError = true;
        return failure;
      } else if (this.stateOverride && this.buffer === "" && (includesCredentials(this.url) || this.url.port !== null)) {
        this.parseError = true;
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "path start";
      if (this.stateOverride) {
        return false;
      }
    } else {
      if (c4 === p("[")) {
        this.arrFlag = true;
      } else if (c4 === p("]")) {
        this.arrFlag = false;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parsePort(c4, cStr) {
    if (isASCIIDigit(c4)) {
      this.buffer += cStr;
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\") || this.stateOverride) {
      if (this.buffer !== "") {
        const port = parseInt(this.buffer);
        if (port > __pow(2, 16) - 1) {
          this.parseError = true;
          return failure;
        }
        this.url.port = port === defaultPort(this.url.scheme) ? null : port;
        this.buffer = "";
      }
      if (this.stateOverride) {
        return false;
      }
      this.state = "path start";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseFile(c4) {
    this.url.scheme = "file";
    this.url.host = "";
    if (c4 === p("/") || c4 === p("\\")) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file slash";
    } else if (this.base !== null && this.base.scheme === "file") {
      this.url.host = this.base.host;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c4)) {
        this.url.query = null;
        if (!startsWithWindowsDriveLetter(this.input, this.pointer)) {
          shortenPath(this.url);
        } else {
          this.parseError = true;
          this.url.path = [];
        }
        this.state = "path";
        --this.pointer;
      }
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileSlash(c4) {
    if (c4 === p("/") || c4 === p("\\")) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file host";
    } else {
      if (this.base !== null && this.base.scheme === "file") {
        if (!startsWithWindowsDriveLetter(this.input, this.pointer) && isNormalizedWindowsDriveLetterString(this.base.path[0])) {
          this.url.path.push(this.base.path[0]);
        }
        this.url.host = this.base.host;
      }
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileHost(c4, cStr) {
    if (isNaN(c4) || c4 === p("/") || c4 === p("\\") || c4 === p("?") || c4 === p("#")) {
      --this.pointer;
      if (!this.stateOverride && isWindowsDriveLetterString(this.buffer)) {
        this.parseError = true;
        this.state = "path";
      } else if (this.buffer === "") {
        this.url.host = "";
        if (this.stateOverride) {
          return false;
        }
        this.state = "path start";
      } else {
        let host = parseHost(this.buffer, isNotSpecial(this.url));
        if (host === failure) {
          return failure;
        }
        if (host === "localhost") {
          host = "";
        }
        this.url.host = host;
        if (this.stateOverride) {
          return false;
        }
        this.buffer = "";
        this.state = "path start";
      }
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parsePathStart(c4) {
    if (isSpecial(this.url)) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "path";
      if (c4 !== p("/") && c4 !== p("\\")) {
        --this.pointer;
      }
    } else if (!this.stateOverride && c4 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (!this.stateOverride && c4 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else if (c4 !== void 0) {
      this.state = "path";
      if (c4 !== p("/")) {
        --this.pointer;
      }
    } else if (this.stateOverride && this.url.host === null) {
      this.url.path.push("");
    }
    return true;
  }
  parsePath(c4) {
    if (isNaN(c4) || c4 === p("/") || isSpecial(this.url) && c4 === p("\\") || !this.stateOverride && (c4 === p("?") || c4 === p("#"))) {
      if (isSpecial(this.url) && c4 === p("\\")) {
        this.parseError = true;
      }
      if (isDoubleDot(this.buffer)) {
        shortenPath(this.url);
        if (c4 !== p("/") && !(isSpecial(this.url) && c4 === p("\\"))) {
          this.url.path.push("");
        }
      } else if (isSingleDot(this.buffer) && c4 !== p("/") && !(isSpecial(this.url) && c4 === p("\\"))) {
        this.url.path.push("");
      } else if (!isSingleDot(this.buffer)) {
        if (this.url.scheme === "file" && this.url.path.length === 0 && isWindowsDriveLetterString(this.buffer)) {
          this.buffer = `${this.buffer[0]}:`;
        }
        this.url.path.push(this.buffer);
      }
      this.buffer = "";
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      }
      if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += utf8PercentEncodeCodePoint(c4, isPathPercentEncode);
    }
    return true;
  }
  parseOpaquePath(c4) {
    if (c4 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (c4 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else {
      if (!isNaN(c4) && c4 !== p("%")) {
        this.parseError = true;
      }
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      if (!isNaN(c4)) {
        this.url.path += utf8PercentEncodeCodePoint(c4, isC0ControlPercentEncode);
      }
    }
    return true;
  }
  parseQuery(c4, cStr) {
    if (!isSpecial(this.url) || this.url.scheme === "ws" || this.url.scheme === "wss") {
      this.encodingOverride = "utf-8";
    }
    if (!this.stateOverride && c4 === p("#") || isNaN(c4)) {
      const queryPercentEncodePredicate = isSpecial(this.url) ? isSpecialQueryPercentEncode : isQueryPercentEncode;
      this.url.query += utf8PercentEncodeString(this.buffer, queryPercentEncodePredicate);
      this.buffer = "";
      if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else if (!isNaN(c4)) {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parseFragment(c4) {
    if (!isNaN(c4)) {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.url.fragment += utf8PercentEncodeCodePoint(c4, isFragmentPercentEncode);
    }
    return true;
  }
};
var fileOtherwiseCodePoints = /* @__PURE__ */ new Set([p("/"), p("\\"), p("?"), p("#")]);
function startsWithWindowsDriveLetter(input, pointer) {
  const length = input.length - pointer;
  return length >= 2 && isWindowsDriveLetterCodePoints(input[pointer], input[pointer + 1]) && (length === 2 || fileOtherwiseCodePoints.has(input[pointer + 2]));
}
function serializeURL(url, excludeFragment) {
  let output = `${url.scheme}:`;
  if (url.host !== null) {
    output += "//";
    if (url.username !== "" || url.password !== "") {
      output += url.username;
      if (url.password !== "") {
        output += `:${url.password}`;
      }
      output += "@";
    }
    output += serializeHost(url.host);
    if (url.port !== null) {
      output += `:${url.port}`;
    }
  }
  if (url.host === null && !hasAnOpaquePath(url) && url.path.length > 1 && url.path[0] === "") {
    output += "/.";
  }
  output += serializePath(url);
  if (url.query !== null) {
    output += `?${url.query}`;
  }
  if (!excludeFragment && url.fragment !== null) {
    output += `#${url.fragment}`;
  }
  return output;
}
function serializeOrigin(tuple) {
  let result = `${tuple.scheme}://`;
  result += serializeHost(tuple.host);
  if (tuple.port !== null) {
    result += `:${tuple.port}`;
  }
  return result;
}
function serializePath(url) {
  if (typeof url.path === "string") {
    return url.path;
  }
  let output = "";
  for (const segment of url.path) {
    output += `/${segment}`;
  }
  return output;
}
function serializeURLOrigin(url) {
  switch (url.scheme) {
    case "blob":
      try {
        return serializeURLOrigin(parseURL(serializePath(url)));
      } catch (e4) {
        return "null";
      }
    case "ftp":
    case "http":
    case "https":
    case "ws":
    case "wss":
      return serializeOrigin({
        scheme: url.scheme,
        host: url.host,
        port: url.port
      });
    case "file":
      return "null";
    default:
      return "null";
  }
}
function basicURLParse(input, options) {
  if (options === void 0) {
    options = {};
  }
  const usm = new URLStateMachine(input, options.baseURL, options.encodingOverride, options.url, options.stateOverride);
  if (usm.failure) {
    return null;
  }
  return usm.url;
}
function setTheUsername(url, username) {
  url.username = utf8PercentEncodeString(username, isUserinfoPercentEncode);
}
function setThePassword(url, password) {
  url.password = utf8PercentEncodeString(password, isUserinfoPercentEncode);
}
function serializeInteger(integer) {
  return String(integer);
}
function parseURL(input, options) {
  if (options === void 0) {
    options = {};
  }
  return basicURLParse(input, {
    baseURL: options.baseURL,
    encodingOverride: options.encodingOverride
  });
}
var URLImpl = class {
  constructor(url, base2) {
    let parsedBase = null;
    if (base2 !== void 0) {
      parsedBase = basicURLParse(base2);
      if (parsedBase === null) {
        throw new TypeError(`Invalid base URL: ${base2}`);
      }
    }
    const parsedURL = basicURLParse(url, { baseURL: parsedBase });
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${url}`);
    }
    const query = parsedURL.query !== null ? parsedURL.query : "";
    this._url = parsedURL;
    this._query = new URLSearchParamsImpl(query, {
      doNotStripQMark: true
    });
    this._query._url = this;
  }
  get href() {
    return serializeURL(this._url);
  }
  set href(v3) {
    const parsedURL = basicURLParse(v3);
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${v3}`);
    }
    this._url = parsedURL;
    this._query._list.splice(0);
    const { query } = parsedURL;
    if (query !== null) {
      this._query._list = parseUrlencodedString(query);
    }
  }
  get origin() {
    return serializeURLOrigin(this._url);
  }
  get protocol() {
    return `${this._url.scheme}:`;
  }
  set protocol(v3) {
    basicURLParse(`${v3}:`, {
      url: this._url,
      stateOverride: "scheme start"
    });
  }
  get username() {
    return this._url.username;
  }
  set username(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setTheUsername(this._url, v3);
  }
  get password() {
    return this._url.password;
  }
  set password(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setThePassword(this._url, v3);
  }
  get host() {
    const url = this._url;
    if (url.host === null) {
      return "";
    }
    if (url.port === null) {
      return serializeHost(url.host);
    }
    return `${serializeHost(url.host)}:${serializeInteger(url.port)}`;
  }
  set host(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "host" });
  }
  get hostname() {
    if (this._url.host === null) {
      return "";
    }
    return serializeHost(this._url.host);
  }
  set hostname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "hostname" });
  }
  get port() {
    if (this._url.port === null) {
      return "";
    }
    return serializeInteger(this._url.port);
  }
  set port(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    if (v3 === "") {
      this._url.port = null;
    } else {
      basicURLParse(v3, { url: this._url, stateOverride: "port" });
    }
  }
  get pathname() {
    return serializePath(this._url);
  }
  set pathname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    this._url.path = [];
    basicURLParse(v3, { url: this._url, stateOverride: "path start" });
  }
  get search() {
    if (this._url.query === null || this._url.query === "") {
      return "";
    }
    return `?${this._url.query}`;
  }
  set search(v3) {
    const url = this._url;
    if (v3 === "") {
      url.query = null;
      this._query._list = [];
      return;
    }
    const input = v3[0] === "?" ? v3.substring(1) : v3;
    url.query = "";
    basicURLParse(input, { url, stateOverride: "query" });
    this._query._list = parseUrlencodedString(input);
  }
  get searchParams() {
    return this._query;
  }
  get hash() {
    if (this._url.fragment === null || this._url.fragment === "") {
      return "";
    }
    return `#${this._url.fragment}`;
  }
  set hash(v3) {
    if (v3 === "") {
      this._url.fragment = null;
      return;
    }
    const input = v3[0] === "#" ? v3.substring(1) : v3;
    this._url.fragment = "";
    basicURLParse(input, { url: this._url, stateOverride: "fragment" });
  }
  toJSON() {
    return this.href;
  }
};

// ../taler-util/lib/url.js
(function() {
  if (typeof globalThis === "object")
    return;
  Object.defineProperty(Object.prototype, "__magic__", {
    get: function() {
      return this;
    },
    configurable: true
    // This makes it possible to `delete` the getter later.
  });
  __magic__.globalThis = __magic__;
  delete Object.prototype.__magic__;
})();
var useOwnUrlImp = true;
var _URL = globalThis.URL;
if (useOwnUrlImp || !_URL) {
  globalThis.URL = _URL = URLImpl;
  _URL = URLImpl;
}
var URL2 = _URL;
var _URLSearchParams = globalThis.URLSearchParams;
if (useOwnUrlImp || !_URLSearchParams) {
  globalThis.URLSearchParams = URLSearchParamsImpl;
  _URLSearchParams = URLSearchParamsImpl;
}
var URLSearchParams = _URLSearchParams;

// ../taler-util/lib/helpers.js
function canonicalizeBaseUrl(url) {
  if (!url.startsWith("http") && !url.startsWith("https")) {
    url = "https://" + url;
  }
  const x6 = new URL2(url);
  if (!x6.pathname.endsWith("/")) {
    x6.pathname = x6.pathname + "/";
  }
  x6.search = "";
  x6.hash = "";
  return x6.href;
}
function canonicalJson(obj) {
  obj = JSON.parse(JSON.stringify(obj));
  if (typeof obj === "string") {
    return JSON.stringify(obj);
  }
  if (typeof obj === "number" || typeof obj === "boolean" || obj === null) {
    return JSON.stringify(obj);
  }
  if (Array.isArray(obj)) {
    const objs = obj.map((e4) => canonicalJson(e4));
    return `[${objs.join(",")}]`;
  }
  const keys = [];
  for (const key in obj) {
    keys.push(key);
  }
  keys.sort();
  let s5 = "{";
  for (let i4 = 0; i4 < keys.length; i4++) {
    const key = keys[i4];
    s5 += JSON.stringify(key) + ":" + canonicalJson(obj[key]);
    if (i4 !== keys.length - 1) {
      s5 += ",";
    }
  }
  return s5 + "}";
}
function strcmp(s1, s22) {
  if (s1 < s22) {
    return -1;
  }
  if (s1 > s22) {
    return 1;
  }
  return 0;
}
function j2s(x6) {
  return JSON.stringify(x6, void 0, 2);
}

// ../taler-util/lib/libtool-version.js
var LibtoolVersion;
(function(LibtoolVersion2) {
  function compare2(me, other) {
    const meVer = parseVersion(me);
    const otherVer = parseVersion(other);
    if (!(meVer && otherVer)) {
      return void 0;
    }
    const compatible = meVer.current - meVer.age <= otherVer.current && meVer.current >= otherVer.current - otherVer.age;
    const currentCmp = Math.sign(meVer.current - otherVer.current);
    return { compatible, currentCmp };
  }
  LibtoolVersion2.compare = compare2;
  function parseVersion(v3) {
    const [currentStr, revisionStr, ageStr, ...rest] = v3.split(":");
    if (rest.length !== 0) {
      return void 0;
    }
    const current = Number.parseInt(currentStr);
    const revision = Number.parseInt(revisionStr);
    const age = Number.parseInt(ageStr);
    if (Number.isNaN(current)) {
      return void 0;
    }
    if (Number.isNaN(revision)) {
      return void 0;
    }
    if (Number.isNaN(age)) {
      return void 0;
    }
    return { current, revision, age };
  }
  LibtoolVersion2.parseVersion = parseVersion;
})(LibtoolVersion || (LibtoolVersion = {}));

// ../taler-util/lib/notifications.js
var NotificationType;
(function(NotificationType2) {
  NotificationType2["BalanceChange"] = "balance-change";
  NotificationType2["ExchangeOperationError"] = "exchange-operation-error";
  NotificationType2["ExchangeAdded"] = "exchange-added";
  NotificationType2["BackupOperationError"] = "backup-error";
  NotificationType2["PendingOperationProcessed"] = "pending-operation-processed";
  NotificationType2["TransactionStateTransition"] = "transaction-state-transition";
})(NotificationType || (NotificationType = {}));

// ../taler-util/lib/sha256.js
var digestLength = 32;
var blockSize = 64;
var K2 = new Uint32Array([
  1116352408,
  1899447441,
  3049323471,
  3921009573,
  961987163,
  1508970993,
  2453635748,
  2870763221,
  3624381080,
  310598401,
  607225278,
  1426881987,
  1925078388,
  2162078206,
  2614888103,
  3248222580,
  3835390401,
  4022224774,
  264347078,
  604807628,
  770255983,
  1249150122,
  1555081692,
  1996064986,
  2554220882,
  2821834349,
  2952996808,
  3210313671,
  3336571891,
  3584528711,
  113926993,
  338241895,
  666307205,
  773529912,
  1294757372,
  1396182291,
  1695183700,
  1986661051,
  2177026350,
  2456956037,
  2730485921,
  2820302411,
  3259730800,
  3345764771,
  3516065817,
  3600352804,
  4094571909,
  275423344,
  430227734,
  506948616,
  659060556,
  883997877,
  958139571,
  1322822218,
  1537002063,
  1747873779,
  1955562222,
  2024104815,
  2227730452,
  2361852424,
  2428436474,
  2756734187,
  3204031479,
  3329325298
]);
function hashBlocks(w5, v3, p4, pos, len) {
  let a5, b4, c4, d5, e4, f3, g4, h5, u4, i4, j4, t1, t22;
  while (len >= 64) {
    a5 = v3[0];
    b4 = v3[1];
    c4 = v3[2];
    d5 = v3[3];
    e4 = v3[4];
    f3 = v3[5];
    g4 = v3[6];
    h5 = v3[7];
    for (i4 = 0; i4 < 16; i4++) {
      j4 = pos + i4 * 4;
      w5[i4] = (p4[j4] & 255) << 24 | (p4[j4 + 1] & 255) << 16 | (p4[j4 + 2] & 255) << 8 | p4[j4 + 3] & 255;
    }
    for (i4 = 16; i4 < 64; i4++) {
      u4 = w5[i4 - 2];
      t1 = (u4 >>> 17 | u4 << 32 - 17) ^ (u4 >>> 19 | u4 << 32 - 19) ^ u4 >>> 10;
      u4 = w5[i4 - 15];
      t22 = (u4 >>> 7 | u4 << 32 - 7) ^ (u4 >>> 18 | u4 << 32 - 18) ^ u4 >>> 3;
      w5[i4] = (t1 + w5[i4 - 7] | 0) + (t22 + w5[i4 - 16] | 0);
    }
    for (i4 = 0; i4 < 64; i4++) {
      t1 = (((e4 >>> 6 | e4 << 32 - 6) ^ (e4 >>> 11 | e4 << 32 - 11) ^ (e4 >>> 25 | e4 << 32 - 25)) + (e4 & f3 ^ ~e4 & g4) | 0) + (h5 + (K2[i4] + w5[i4] | 0) | 0) | 0;
      t22 = ((a5 >>> 2 | a5 << 32 - 2) ^ (a5 >>> 13 | a5 << 32 - 13) ^ (a5 >>> 22 | a5 << 32 - 22)) + (a5 & b4 ^ a5 & c4 ^ b4 & c4) | 0;
      h5 = g4;
      g4 = f3;
      f3 = e4;
      e4 = d5 + t1 | 0;
      d5 = c4;
      c4 = b4;
      b4 = a5;
      a5 = t1 + t22 | 0;
    }
    v3[0] += a5;
    v3[1] += b4;
    v3[2] += c4;
    v3[3] += d5;
    v3[4] += e4;
    v3[5] += f3;
    v3[6] += g4;
    v3[7] += h5;
    pos += 64;
    len -= 64;
  }
  return pos;
}
var HashSha256 = class {
  constructor() {
    this.digestLength = digestLength;
    this.blockSize = blockSize;
    this.state = new Int32Array(8);
    this.temp = new Int32Array(64);
    this.buffer = new Uint8Array(128);
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    this.reset();
  }
  // Resets hash state making it possible
  // to re-use this instance to hash other data.
  reset() {
    this.state[0] = 1779033703;
    this.state[1] = 3144134277;
    this.state[2] = 1013904242;
    this.state[3] = 2773480762;
    this.state[4] = 1359893119;
    this.state[5] = 2600822924;
    this.state[6] = 528734635;
    this.state[7] = 1541459225;
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    return this;
  }
  // Cleans internal buffers and re-initializes hash state.
  clean() {
    for (let i4 = 0; i4 < this.buffer.length; i4++) {
      this.buffer[i4] = 0;
    }
    for (let i4 = 0; i4 < this.temp.length; i4++) {
      this.temp[i4] = 0;
    }
    this.reset();
  }
  // Updates hash state with the given data.
  //
  // Optionally, length of the data can be specified to hash
  // fewer bytes than data.length.
  //
  // Throws error when trying to update already finalized hash:
  // instance must be reset to use it again.
  update(data, dataLength = data.length) {
    if (this.finished) {
      throw new Error("SHA256: can't update because hash was finished.");
    }
    let dataPos = 0;
    this.bytesHashed += dataLength;
    if (this.bufferLength > 0) {
      while (this.bufferLength < 64 && dataLength > 0) {
        this.buffer[this.bufferLength++] = data[dataPos++];
        dataLength--;
      }
      if (this.bufferLength === 64) {
        hashBlocks(this.temp, this.state, this.buffer, 0, 64);
        this.bufferLength = 0;
      }
    }
    if (dataLength >= 64) {
      dataPos = hashBlocks(this.temp, this.state, data, dataPos, dataLength);
      dataLength %= 64;
    }
    while (dataLength > 0) {
      this.buffer[this.bufferLength++] = data[dataPos++];
      dataLength--;
    }
    return this;
  }
  // Finalizes hash state and puts hash into out.
  //
  // If hash was already finalized, puts the same value.
  finish(out) {
    if (!this.finished) {
      const bytesHashed = this.bytesHashed;
      const left = this.bufferLength;
      const bitLenHi = bytesHashed / 536870912 | 0;
      const bitLenLo = bytesHashed << 3;
      const padLength = bytesHashed % 64 < 56 ? 64 : 128;
      this.buffer[left] = 128;
      for (let i4 = left + 1; i4 < padLength - 8; i4++) {
        this.buffer[i4] = 0;
      }
      this.buffer[padLength - 8] = bitLenHi >>> 24 & 255;
      this.buffer[padLength - 7] = bitLenHi >>> 16 & 255;
      this.buffer[padLength - 6] = bitLenHi >>> 8 & 255;
      this.buffer[padLength - 5] = bitLenHi >>> 0 & 255;
      this.buffer[padLength - 4] = bitLenLo >>> 24 & 255;
      this.buffer[padLength - 3] = bitLenLo >>> 16 & 255;
      this.buffer[padLength - 2] = bitLenLo >>> 8 & 255;
      this.buffer[padLength - 1] = bitLenLo >>> 0 & 255;
      hashBlocks(this.temp, this.state, this.buffer, 0, padLength);
      this.finished = true;
    }
    for (let i4 = 0; i4 < 8; i4++) {
      out[i4 * 4 + 0] = this.state[i4] >>> 24 & 255;
      out[i4 * 4 + 1] = this.state[i4] >>> 16 & 255;
      out[i4 * 4 + 2] = this.state[i4] >>> 8 & 255;
      out[i4 * 4 + 3] = this.state[i4] >>> 0 & 255;
    }
    return this;
  }
  // Returns the final hash digest.
  digest() {
    const out = new Uint8Array(this.digestLength);
    this.finish(out);
    return out;
  }
  // Internal function for use in HMAC for optimization.
  _saveState(out) {
    for (let i4 = 0; i4 < this.state.length; i4++) {
      out[i4] = this.state[i4];
    }
  }
  // Internal function for use in HMAC for optimization.
  _restoreState(from, bytesHashed) {
    for (let i4 = 0; i4 < this.state.length; i4++) {
      this.state[i4] = from[i4];
    }
    this.bytesHashed = bytesHashed;
    this.finished = false;
    this.bufferLength = 0;
  }
};
function sha256(data) {
  const h5 = new HashSha256().update(data);
  const digest = h5.digest();
  h5.clean();
  return digest;
}

// ../taler-util/lib/kdf.js
function sha512(data) {
  return hash(data);
}
function hmac(digest, blockSize2, key, message) {
  if (key.byteLength > blockSize2) {
    key = digest(key);
  }
  if (key.byteLength < blockSize2) {
    const k5 = key;
    key = new Uint8Array(blockSize2);
    key.set(k5, 0);
  }
  const okp = new Uint8Array(blockSize2);
  const ikp = new Uint8Array(blockSize2);
  for (let i4 = 0; i4 < blockSize2; i4++) {
    ikp[i4] = key[i4] ^ 54;
    okp[i4] = key[i4] ^ 92;
  }
  const b1 = new Uint8Array(blockSize2 + message.byteLength);
  b1.set(ikp, 0);
  b1.set(message, blockSize2);
  const h0 = digest(b1);
  const b22 = new Uint8Array(blockSize2 + h0.length);
  b22.set(okp, 0);
  b22.set(h0, blockSize2);
  return digest(b22);
}
function hmacSha512(key, message) {
  return hmac(sha512, 128, key, message);
}
function hmacSha256(key, message) {
  return hmac(sha256, 64, key, message);
}

// ../taler-util/lib/taler-crypto.js
var import_big_integer = __toESM(require_BigInteger(), 1);

// ../taler-util/lib/time.js
var opaque_AbsoluteTime = Symbol("opaque_AbsoluteTime");
var TalerPreciseTimestamp;
(function(TalerPreciseTimestamp2) {
  function now() {
    const absNow = AbsoluteTime.now();
    return AbsoluteTime.toPreciseTimestamp(absNow);
  }
  TalerPreciseTimestamp2.now = now;
  function round(t4) {
    return {
      t_s: t4.t_s
    };
  }
  TalerPreciseTimestamp2.round = round;
  function fromSeconds(s5) {
    return {
      t_s: Math.floor(s5),
      off_us: Math.floor((s5 - Math.floor(s5)) / 1e3 / 1e3)
    };
  }
  TalerPreciseTimestamp2.fromSeconds = fromSeconds;
  function fromMilliseconds(ms) {
    return {
      t_s: Math.floor(ms / 1e3),
      off_us: Math.floor((ms - Math.floor(ms / 1e3) * 1e3) * 1e3)
    };
  }
  TalerPreciseTimestamp2.fromMilliseconds = fromMilliseconds;
})(TalerPreciseTimestamp || (TalerPreciseTimestamp = {}));
var TalerProtocolTimestamp;
(function(TalerProtocolTimestamp2) {
  function now() {
    return AbsoluteTime.toProtocolTimestamp(AbsoluteTime.now());
  }
  TalerProtocolTimestamp2.now = now;
  function zero() {
    return {
      t_s: 0
    };
  }
  TalerProtocolTimestamp2.zero = zero;
  function never() {
    return {
      t_s: "never"
    };
  }
  TalerProtocolTimestamp2.never = never;
  function isNever(t4) {
    return t4.t_s === "never";
  }
  TalerProtocolTimestamp2.isNever = isNever;
  function fromSeconds(s5) {
    return {
      t_s: s5
    };
  }
  TalerProtocolTimestamp2.fromSeconds = fromSeconds;
  function min(t1, t22) {
    if (t1.t_s === "never") {
      return { t_s: t22.t_s };
    }
    if (t22.t_s === "never") {
      return { t_s: t1.t_s };
    }
    return { t_s: Math.min(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp2.min = min;
  function max(t1, t22) {
    if (t1.t_s === "never" || t22.t_s === "never") {
      return { t_s: "never" };
    }
    return { t_s: Math.max(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp2.max = max;
})(TalerProtocolTimestamp || (TalerProtocolTimestamp = {}));
var timeshift = 0;
var Duration;
(function(Duration2) {
  function toMilliseconds(d5) {
    if (d5.d_ms === "forever") {
      return Number.MAX_VALUE;
    }
    return d5.d_ms;
  }
  Duration2.toMilliseconds = toMilliseconds;
  function getRemaining(deadline, now = AbsoluteTime.now()) {
    if (deadline.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (now.t_ms === "never") {
      throw Error("invalid argument for 'now'");
    }
    if (deadline.t_ms < now.t_ms) {
      return { d_ms: 0 };
    }
    return { d_ms: deadline.t_ms - now.t_ms };
  }
  Duration2.getRemaining = getRemaining;
  function fromPrettyString(s5) {
    let dMs = 0;
    let currentNum = "";
    let parsingNum = true;
    for (let i4 = 0; i4 < s5.length; i4++) {
      const cc = s5.charCodeAt(i4);
      if (cc >= "0".charCodeAt(0) && cc <= "9".charCodeAt(0)) {
        if (!parsingNum) {
          throw Error("invalid duration, unexpected number");
        }
        currentNum += s5[i4];
        continue;
      }
      if (s5[i4] == " ") {
        if (currentNum != "") {
          parsingNum = false;
        }
        continue;
      }
      if (currentNum == "") {
        throw Error("invalid duration, missing number");
      }
      if (s5[i4] === "s") {
        dMs += 1e3 * Number.parseInt(currentNum, 10);
      } else if (s5[i4] === "m") {
        dMs += 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s5[i4] === "h") {
        dMs += 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s5[i4] === "d") {
        dMs += 24 * 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else {
        throw Error("invalid duration, unsupported unit");
      }
      currentNum = "";
      parsingNum = true;
    }
    return {
      d_ms: dMs
    };
  }
  Duration2.fromPrettyString = fromPrettyString;
  function cmp(d1, d22) {
    if (d1.d_ms === "forever") {
      if (d22.d_ms === "forever") {
        return 0;
      }
      return 1;
    }
    if (d22.d_ms === "forever") {
      return -1;
    }
    if (d1.d_ms == d22.d_ms) {
      return 0;
    }
    if (d1.d_ms > d22.d_ms) {
      return 1;
    }
    return -1;
  }
  Duration2.cmp = cmp;
  function max(d1, d22) {
    return durationMax(d1, d22);
  }
  Duration2.max = max;
  function min(d1, d22) {
    return durationMin(d1, d22);
  }
  Duration2.min = min;
  function multiply(d1, n2) {
    return durationMul(d1, n2);
  }
  Duration2.multiply = multiply;
  function toIntegerYears(d5) {
    if (typeof d5.d_ms !== "number") {
      throw Error("infinite duration");
    }
    return Math.ceil(d5.d_ms / 1e3 / 60 / 60 / 24 / 365);
  }
  Duration2.toIntegerYears = toIntegerYears;
  Duration2.fromSpec = durationFromSpec;
  function getForever() {
    return { d_ms: "forever" };
  }
  Duration2.getForever = getForever;
  function getZero() {
    return { d_ms: 0 };
  }
  Duration2.getZero = getZero;
  function fromTalerProtocolDuration(d5) {
    if (d5.d_us === "forever") {
      return {
        d_ms: "forever"
      };
    }
    return {
      d_ms: Math.floor(d5.d_us / 1e3)
    };
  }
  Duration2.fromTalerProtocolDuration = fromTalerProtocolDuration;
  function toTalerProtocolDuration(d5) {
    if (d5.d_ms === "forever") {
      return {
        d_us: "forever"
      };
    }
    return {
      d_us: d5.d_ms * 1e3
    };
  }
  Duration2.toTalerProtocolDuration = toTalerProtocolDuration;
  function fromMilliseconds(ms) {
    return {
      d_ms: ms
    };
  }
  Duration2.fromMilliseconds = fromMilliseconds;
  function clamp(args) {
    return durationMax(durationMin(args.value, args.upper), args.lower);
  }
  Duration2.clamp = clamp;
})(Duration || (Duration = {}));
var AbsoluteTime;
(function(AbsoluteTime2) {
  function getStampMsNow() {
    return (/* @__PURE__ */ new Date()).getTime();
  }
  AbsoluteTime2.getStampMsNow = getStampMsNow;
  function getStampMsNever() {
    return Number.MAX_SAFE_INTEGER;
  }
  AbsoluteTime2.getStampMsNever = getStampMsNever;
  function now() {
    return {
      t_ms: (/* @__PURE__ */ new Date()).getTime() + timeshift,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime2.now = now;
  function never() {
    return {
      t_ms: "never",
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime2.never = never;
  function fromMilliseconds(ms) {
    return {
      t_ms: ms,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime2.fromMilliseconds = fromMilliseconds;
  function cmp(t1, t22) {
    if (t1.t_ms === "never") {
      if (t22.t_ms === "never") {
        return 0;
      }
      return 1;
    }
    if (t22.t_ms === "never") {
      return -1;
    }
    if (t1.t_ms == t22.t_ms) {
      return 0;
    }
    if (t1.t_ms > t22.t_ms) {
      return 1;
    }
    return -1;
  }
  AbsoluteTime2.cmp = cmp;
  function min(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.min(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime2.min = min;
  function max(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime2.max = max;
  function difference(t1, t22) {
    if (t1.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (t22.t_ms === "never") {
      return { d_ms: "forever" };
    }
    return { d_ms: Math.abs(t1.t_ms - t22.t_ms) };
  }
  AbsoluteTime2.difference = difference;
  function isExpired(t4) {
    return cmp(t4, now()) <= 0;
  }
  AbsoluteTime2.isExpired = isExpired;
  function fromProtocolTimestamp(t4) {
    if (t4.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return {
      t_ms: t4.t_s * 1e3,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime2.fromProtocolTimestamp = fromProtocolTimestamp;
  function fromStampMs(stampMs) {
    return {
      t_ms: stampMs,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime2.fromStampMs = fromStampMs;
  function fromPreciseTimestamp(t4) {
    var _a;
    if (t4.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    const offsetUs = (_a = t4.off_us) != null ? _a : 0;
    return {
      t_ms: t4.t_s * 1e3 + Math.floor(offsetUs / 1e3),
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime2.fromPreciseTimestamp = fromPreciseTimestamp;
  function toStampMs(at2) {
    if (at2.t_ms === "never") {
      return Number.MAX_SAFE_INTEGER;
    }
    return at2.t_ms;
  }
  AbsoluteTime2.toStampMs = toStampMs;
  function toPreciseTimestamp(at2) {
    if (at2.t_ms == "never") {
      return {
        t_s: "never"
      };
    }
    const t_s = Math.floor(at2.t_ms / 1e3);
    const off_us = Math.floor(1e3 * (at2.t_ms - t_s * 1e3));
    return {
      t_s,
      off_us
    };
  }
  AbsoluteTime2.toPreciseTimestamp = toPreciseTimestamp;
  function toProtocolTimestamp(at2) {
    if (at2.t_ms === "never") {
      return { t_s: "never" };
    }
    return {
      t_s: Math.floor(at2.t_ms / 1e3)
    };
  }
  AbsoluteTime2.toProtocolTimestamp = toProtocolTimestamp;
  function isBetween(t4, start, end) {
    if (cmp(t4, start) < 0) {
      return false;
    }
    if (cmp(t4, end) > 0) {
      return false;
    }
    return true;
  }
  AbsoluteTime2.isBetween = isBetween;
  function toIsoString(t4) {
    if (t4.t_ms === "never") {
      return "<never>";
    } else {
      return new Date(t4.t_ms).toISOString();
    }
  }
  AbsoluteTime2.toIsoString = toIsoString;
  function addDuration(t1, d5) {
    if (t1.t_ms === "never" || d5.d_ms === "forever") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: t1.t_ms + d5.d_ms, [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime2.addDuration = addDuration;
  function subtractDuraction(t1, d5) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (d5.d_ms === "forever") {
      return { t_ms: 0, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(0, t1.t_ms - d5.d_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime2.subtractDuraction = subtractDuraction;
  function stringify(t4) {
    if (t4.t_ms === "never") {
      return "never";
    }
    return new Date(t4.t_ms).toISOString();
  }
  AbsoluteTime2.stringify = stringify;
})(AbsoluteTime || (AbsoluteTime = {}));
var SECONDS = 1e3;
var MINUTES = SECONDS * 60;
var HOURS = MINUTES * 60;
var DAYS = HOURS * 24;
var MONTHS = DAYS * 30;
var YEARS = DAYS * 365;
function durationFromSpec(spec) {
  var _a, _b, _c, _d, _e, _f;
  let d_ms = 0;
  d_ms += ((_a = spec.seconds) != null ? _a : 0) * SECONDS;
  d_ms += ((_b = spec.minutes) != null ? _b : 0) * MINUTES;
  d_ms += ((_c = spec.hours) != null ? _c : 0) * HOURS;
  d_ms += ((_d = spec.days) != null ? _d : 0) * DAYS;
  d_ms += ((_e = spec.months) != null ? _e : 0) * MONTHS;
  d_ms += ((_f = spec.years) != null ? _f : 0) * YEARS;
  return { d_ms };
}
function durationMin(d1, d22) {
  if (d1.d_ms === "forever") {
    return { d_ms: d22.d_ms };
  }
  if (d22.d_ms === "forever") {
    return { d_ms: d1.d_ms };
  }
  return { d_ms: Math.min(d1.d_ms, d22.d_ms) };
}
function durationMax(d1, d22) {
  if (d1.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  if (d22.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.max(d1.d_ms, d22.d_ms) };
}
function durationMul(d5, n2) {
  if (d5.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.round(d5.d_ms * n2) };
}
var codecForAbsoluteTime = {
  decode(x6, c4) {
    const t_ms = x6.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_ms: "never", [opaque_AbsoluteTime]: true };
      }
    } else if (typeof t_ms === "number") {
      return { t_ms, [opaque_AbsoluteTime]: true };
    }
    throw Error(`expected timestamp at ${renderContext(c4)}`);
  }
};
var codecForTimestamp = {
  decode(x6, c4) {
    const t_ms = x6.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_s: "never" };
      }
    } else if (typeof t_ms === "number") {
      return { t_s: Math.floor(t_ms / 1e3) };
    }
    const t_s = x6.t_s;
    if (typeof t_s === "string") {
      if (t_s === "never") {
        return { t_s: "never" };
      }
      throw Error(`expected timestamp at ${renderContext(c4)}`);
    }
    if (typeof t_s === "number") {
      return { t_s };
    }
    throw Error(`expected timestamp at ${renderContext(c4)}`);
  }
};

// ../taler-util/lib/taler-types.js
var DenomKeyType;
(function(DenomKeyType2) {
  DenomKeyType2["Rsa"] = "RSA";
  DenomKeyType2["ClauseSchnorr"] = "CS";
})(DenomKeyType || (DenomKeyType = {}));
(function(DenomKeyType2) {
  function toIntTag(t4) {
    switch (t4) {
      case DenomKeyType2.Rsa:
        return 1;
      case DenomKeyType2.ClauseSchnorr:
        return 2;
    }
  }
  DenomKeyType2.toIntTag = toIntTag;
})(DenomKeyType || (DenomKeyType = {}));
var DenominationPubKey;
(function(DenominationPubKey2) {
  function cmp(p1, p22) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if (p1.cipher < p22.cipher) {
      return -1;
    } else if (p1.cipher > p22.cipher) {
      return 1;
    } else if (p1.cipher === DenomKeyType.Rsa && p22.cipher === DenomKeyType.Rsa) {
      if (((_a = p1.age_mask) != null ? _a : 0) < ((_b = p22.age_mask) != null ? _b : 0)) {
        return -1;
      } else if (((_c = p1.age_mask) != null ? _c : 0) > ((_d = p22.age_mask) != null ? _d : 0)) {
        return 1;
      }
      return strcmp(p1.rsa_public_key, p22.rsa_public_key);
    } else if (p1.cipher === DenomKeyType.ClauseSchnorr && p22.cipher === DenomKeyType.ClauseSchnorr) {
      if (((_e = p1.age_mask) != null ? _e : 0) < ((_f = p22.age_mask) != null ? _f : 0)) {
        return -1;
      } else if (((_g = p1.age_mask) != null ? _g : 0) > ((_h = p22.age_mask) != null ? _h : 0)) {
        return 1;
      }
      return strcmp(p1.cs_public_key, p22.cs_public_key);
    } else {
      throw Error("unsupported cipher");
    }
  }
  DenominationPubKey2.cmp = cmp;
})(DenominationPubKey || (DenominationPubKey = {}));
var codecForNgDenominations = codecForAny();
var ExchangeProtocolVersion;
(function(ExchangeProtocolVersion2) {
  ExchangeProtocolVersion2[ExchangeProtocolVersion2["V12"] = 12] = "V12";
})(ExchangeProtocolVersion || (ExchangeProtocolVersion = {}));
var MerchantProtocolVersion;
(function(MerchantProtocolVersion2) {
  MerchantProtocolVersion2[MerchantProtocolVersion2["V3"] = 3] = "V3";
})(MerchantProtocolVersion || (MerchantProtocolVersion = {}));

// ../taler-util/lib/logging.js
var isNode = typeof process !== "undefined" && typeof process.release !== "undefined" && process.release.name === "node";
var LogLevel;
(function(LogLevel2) {
  LogLevel2["Trace"] = "trace";
  LogLevel2["Message"] = "message";
  LogLevel2["Info"] = "info";
  LogLevel2["Warn"] = "warn";
  LogLevel2["Error"] = "error";
  LogLevel2["None"] = "none";
})(LogLevel || (LogLevel = {}));
var globalLogLevel = LogLevel.Info;
var byTagLogLevel = {};
var nativeLogging = false;
function getGlobalLogLevel() {
  return globalLogLevel;
}
function setGlobalLogLevelFromString(logLevelStr) {
  globalLogLevel = getLevelForString(logLevelStr);
}
function getLevelForString(logLevelStr) {
  switch (logLevelStr.toLowerCase()) {
    case "trace":
      return LogLevel.Trace;
    case "info":
      return LogLevel.Info;
    case "warn":
    case "warning":
      return LogLevel.Warn;
    case "error":
      return LogLevel.Error;
    case "none":
      return LogLevel.None;
    default:
      if (isNode) {
        process.stderr.write(`Invalid log level, defaulting to WARNING
`);
      } else {
        console.warn(`Invalid log level, defaulting to WARNING`);
      }
      return LogLevel.Warn;
  }
}
function writeNativeLog(message, tag, level, args) {
  const logFn = globalThis.__nativeLog;
  if (logFn) {
    let m5;
    if (args.length == 0) {
      m5 = message;
    } else {
      m5 = message + " " + args.toString();
    }
    logFn(level, tag, message);
  }
}
function writeNodeLog(message, tag, level, args) {
  try {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} ${tag} ${level} ${message}`;
    if (args.length != 0) {
      msg += ` ${JSON.stringify(args, void 0, 2)}
`;
    } else {
      msg += `
`;
    }
    process.stderr.write(msg);
  } catch (e4) {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} (logger) FATAL `;
    if (e4 instanceof Error) {
      msg += `failed to write log: ${e4.message}
`;
    } else {
      msg += "failed to write log\n";
    }
    process.stderr.write(msg);
  }
}
var Logger = class {
  constructor(tag) {
    this.tag = tag;
  }
  shouldLogTrace() {
    var _a;
    const level = (_a = byTagLogLevel[this.tag]) != null ? _a : globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
        return true;
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogInfo() {
    var _a;
    const level = (_a = byTagLogLevel[this.tag]) != null ? _a : globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
        return true;
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogWarn() {
    var _a;
    const level = (_a = byTagLogLevel[this.tag]) != null ? _a : globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
        return true;
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogError() {
    var _a;
    const level = (_a = byTagLogLevel[this.tag]) != null ? _a : globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
        return true;
      case LogLevel.None:
        return false;
    }
  }
  info(message, ...args) {
    if (!this.shouldLogInfo()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 2, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "INFO", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  warn(message, ...args) {
    if (!this.shouldLogWarn()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 3, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "WARN", args);
    } else {
      console.warn(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  error(message, ...args) {
    if (!this.shouldLogError()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 4, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "ERROR", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} ERROR ` + message, ...args);
    }
  }
  trace(message, ...args) {
    if (!this.shouldLogTrace()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 1, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "TRACE", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} TRACE ` + message, ...args);
    }
  }
  reportBreak() {
    if (!this.shouldLogError()) {
      return;
    }
    const location2 = new Error("programming error");
    this.error(`assertion failed: ${location2.stack}`);
  }
};

// ../taler-util/lib/taler-crypto.js
function getRandomBytes(n2) {
  return randomBytes(n2);
}
var useNative = true;
var tart;
if (useNative) {
  tart = globalThis._tart;
}
var encTable = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
var EncodingError = class extends Error {
  constructor() {
    super("Encoding error");
    Object.setPrototypeOf(this, EncodingError.prototype);
  }
};
function getValue(chr) {
  let a5 = chr;
  switch (chr) {
    case "O":
    case "o":
      a5 = "0";
      break;
    case "i":
    case "I":
    case "l":
    case "L":
      a5 = "1";
      break;
    case "u":
    case "U":
      a5 = "V";
  }
  if (a5 >= "0" && a5 <= "9") {
    return a5.charCodeAt(0) - "0".charCodeAt(0);
  }
  if (a5 >= "a" && a5 <= "z")
    a5 = a5.toUpperCase();
  let dec = 0;
  if (a5 >= "A" && a5 <= "Z") {
    if ("I" < a5)
      dec++;
    if ("L" < a5)
      dec++;
    if ("O" < a5)
      dec++;
    if ("U" < a5)
      dec++;
    return a5.charCodeAt(0) - "A".charCodeAt(0) + 10 - dec;
  }
  throw new EncodingError();
}
function encodeCrock(data) {
  if (tart) {
    return tart.encodeCrock(data);
  }
  const dataBytes = new Uint8Array(data);
  let sb = "";
  const size = data.byteLength;
  let bitBuf = 0;
  let numBits = 0;
  let pos = 0;
  while (pos < size || numBits > 0) {
    if (pos < size && numBits < 5) {
      const d5 = dataBytes[pos++];
      bitBuf = bitBuf << 8 | d5;
      numBits += 8;
    }
    if (numBits < 5) {
      bitBuf = bitBuf << 5 - numBits;
      numBits = 5;
    }
    const v3 = bitBuf >>> numBits - 5 & 31;
    sb += encTable[v3];
    numBits -= 5;
  }
  return sb;
}
function kdf(outputLength, ikm, salt, info) {
  if (tart) {
    return tart.kdf(outputLength, ikm, salt, info);
  }
  salt = salt != null ? salt : new Uint8Array(64);
  const prk = hmacSha512(salt, ikm);
  info = info != null ? info : new Uint8Array(0);
  const N3 = Math.ceil(outputLength / 32);
  const output = new Uint8Array(N3 * 32);
  for (let i4 = 0; i4 < N3; i4++) {
    let buf;
    if (i4 == 0) {
      buf = new Uint8Array(info.byteLength + 1);
      buf.set(info, 0);
    } else {
      buf = new Uint8Array(info.byteLength + 1 + 32);
      for (let j4 = 0; j4 < 32; j4++) {
        buf[j4] = output[(i4 - 1) * 32 + j4];
      }
      buf.set(info, 32);
    }
    buf[buf.length - 1] = i4 + 1;
    const chunk = hmacSha256(prk, buf);
    output.set(chunk, i4 * 32);
  }
  return output.slice(0, outputLength);
}
function kdfKw(args) {
  return kdf(args.outputLength, args.ikm, args.salt, args.info);
}
function decodeCrock(encoded) {
  if (tart) {
    return tart.decodeCrock(encoded);
  }
  const size = encoded.length;
  let bitpos = 0;
  let bitbuf = 0;
  let readPosition = 0;
  const outLen = Math.floor(size * 5 / 8);
  const out = new Uint8Array(outLen);
  let outPos = 0;
  while (readPosition < size || bitpos > 0) {
    if (readPosition < size) {
      const v3 = getValue(encoded[readPosition++]);
      bitbuf = bitbuf << 5 | v3;
      bitpos += 5;
    }
    while (bitpos >= 8) {
      const d5 = bitbuf >>> bitpos - 8 & 255;
      out[outPos++] = d5;
      bitpos -= 8;
    }
    if (readPosition == size && bitpos > 0) {
      bitbuf = bitbuf << 8 - bitpos & 255;
      bitpos = bitbuf == 0 ? 0 : 8;
    }
  }
  return out;
}
var encoder;
function stringToBytes(s5) {
  if (!encoder) {
    encoder = new TextEncoder();
  }
  return encoder.encode(s5);
}
function typedArrayConcat(chunks) {
  let payloadLen = 0;
  for (const c4 of chunks) {
    payloadLen += c4.byteLength;
  }
  const buf = new ArrayBuffer(payloadLen);
  const u8buf = new Uint8Array(buf);
  let p4 = 0;
  for (const c4 of chunks) {
    u8buf.set(c4, p4);
    p4 += c4.byteLength;
  }
  return u8buf;
}
function hash2(d5) {
  if (tart) {
    return tart.hash(d5);
  }
  return hash(d5);
}
var logger = new Logger("talerCrypto.ts");
function bufferForUint32(n2) {
  const arrBuf = new ArrayBuffer(4);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  dv.setUint32(0, n2);
  return buf;
}
var TalerSignaturePurpose;
(function(TalerSignaturePurpose2) {
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_TRACK_TRANSACTION"] = 1103] = "MERCHANT_TRACK_TRANSACTION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_WITHDRAW"] = 1200] = "WALLET_RESERVE_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_DEPOSIT"] = 1201] = "WALLET_COIN_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["GLOBAL_FEES"] = 1022] = "GLOBAL_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DENOMINATION_KEY_VALIDITY"] = 1025] = "MASTER_DENOMINATION_KEY_VALIDITY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_FEES"] = 1028] = "MASTER_WIRE_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_DETAILS"] = 1030] = "MASTER_WIRE_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_MELT"] = 1202] = "WALLET_COIN_MELT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["TEST"] = 4242] = "TEST";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_PAYMENT_OK"] = 1104] = "MERCHANT_PAYMENT_OK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_CONTRACT"] = 1101] = "MERCHANT_CONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_REFUND"] = 1102] = "MERCHANT_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP"] = 1203] = "WALLET_COIN_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_LINK"] = 1204] = "WALLET_COIN_LINK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP_REFRESH"] = 1206] = "WALLET_COIN_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_AGE_ATTESTATION"] = 1207] = "WALLET_AGE_ATTESTATION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_CREATE"] = 1210] = "WALLET_PURSE_CREATE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DEPOSIT"] = 1211] = "WALLET_PURSE_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_MERGE"] = 1213] = "WALLET_PURSE_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_MERGE"] = 1214] = "WALLET_ACCOUNT_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_ECONTRACT"] = 1216] = "WALLET_PURSE_ECONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DELETE"] = 1220] = "WALLET_PURSE_DELETE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP"] = 1039] = "EXCHANGE_CONFIRM_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP_REFRESH"] = 1041] = "EXCHANGE_CONFIRM_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["TALER_SIGNATURE_AML_DECISION"] = 1350] = "TALER_SIGNATURE_AML_DECISION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["TALER_SIGNATURE_AML_QUERY"] = 1351] = "TALER_SIGNATURE_AML_QUERY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["TALER_SIGNATURE_MASTER_AML_KEY"] = 1017] = "TALER_SIGNATURE_MASTER_AML_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_UPLOAD"] = 1400] = "ANASTASIS_POLICY_UPLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_DOWNLOAD"] = 1401] = "ANASTASIS_POLICY_DOWNLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SYNC_BACKUP_UPLOAD"] = 1450] = "SYNC_BACKUP_UPLOAD";
})(TalerSignaturePurpose || (TalerSignaturePurpose = {}));
var WalletAccountMergeFlags;
(function(WalletAccountMergeFlags2) {
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["None"] = 0] = "None";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["MergeFullyPaidPurse"] = 1] = "MergeFullyPaidPurse";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateFromPurseQuota"] = 2] = "CreateFromPurseQuota";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateWithPurseFee"] = 3] = "CreateWithPurseFee";
})(WalletAccountMergeFlags || (WalletAccountMergeFlags = {}));
var SignaturePurposeBuilder = class {
  constructor(purposeNum) {
    this.purposeNum = purposeNum;
    this.chunks = [];
  }
  put(bytes) {
    this.chunks.push(Uint8Array.from(bytes));
    return this;
  }
  build() {
    let payloadLen = 0;
    for (const c4 of this.chunks) {
      payloadLen += c4.byteLength;
    }
    const buf = new ArrayBuffer(4 + 4 + payloadLen);
    const u8buf = new Uint8Array(buf);
    let p4 = 8;
    for (const c4 of this.chunks) {
      u8buf.set(c4, p4);
      p4 += c4.byteLength;
    }
    const dvbuf = new DataView(buf);
    dvbuf.setUint32(0, payloadLen + 4 + 4);
    dvbuf.setUint32(4, this.purposeNum);
    return u8buf;
  }
};
function buildSigPS(purposeNum) {
  return new SignaturePurposeBuilder(purposeNum);
}
function bigintToNaclArr(x6, size) {
  const byteArr = new Uint8Array(size);
  const arr = x6.toArray(256).value.reverse();
  byteArr.set(arr, 0);
  return byteArr;
}
function bigintFromNaclArr(arr) {
  let rev = new Uint8Array(arr);
  rev = rev.reverse();
  return import_big_integer.default.fromArray(Array.from(rev), 256, false);
}
var Edx25519;
(function(Edx255192) {
  const revL = [
    237,
    211,
    245,
    92,
    26,
    99,
    18,
    88,
    214,
    156,
    247,
    162,
    222,
    249,
    222,
    20,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    16
  ];
  const L5 = import_big_integer.default.fromArray(revL.reverse(), 256, false);
  function keyCreateFromSeed(seed) {
    return __async(this, null, function* () {
      return crypto_edx25519_private_key_create_from_seed(seed);
    });
  }
  Edx255192.keyCreateFromSeed = keyCreateFromSeed;
  function keyCreate() {
    return __async(this, null, function* () {
      return crypto_edx25519_private_key_create();
    });
  }
  Edx255192.keyCreate = keyCreate;
  function getPublic(priv) {
    return __async(this, null, function* () {
      return crypto_edx25519_get_public(priv);
    });
  }
  Edx255192.getPublic = getPublic;
  function sign(msg, key) {
    throw Error("not implemented");
  }
  Edx255192.sign = sign;
  function deriveFactor(pub, seed) {
    return __async(this, null, function* () {
      const res = kdfKw({
        outputLength: 64,
        salt: seed,
        ikm: pub,
        info: stringToBytes("edx25519-derivation")
      });
      return res;
    });
  }
  function privateKeyDerive(priv, seed) {
    return __async(this, null, function* () {
      const pub = yield getPublic(priv);
      const privDec = priv;
      const a5 = bigintFromNaclArr(privDec.subarray(0, 32));
      const factorEnc = yield deriveFactor(pub, seed);
      const factorModL = bigintFromNaclArr(factorEnc).mod(L5);
      const aPrime = a5.divide(8).multiply(factorModL).mod(L5).multiply(8).mod(L5);
      const bPrime = hash(typedArrayConcat([privDec.subarray(32, 64), factorEnc])).subarray(0, 32);
      const newPriv = typedArrayConcat([bigintToNaclArr(aPrime, 32), bPrime]);
      return newPriv;
    });
  }
  Edx255192.privateKeyDerive = privateKeyDerive;
  function publicKeyDerive(pub, seed) {
    return __async(this, null, function* () {
      const factorEnc = yield deriveFactor(pub, seed);
      const factorReduced = crypto_core_ed25519_scalar_reduce(factorEnc);
      const res = crypto_scalarmult_ed25519_noclamp(factorReduced, pub);
      return res;
    });
  }
  Edx255192.publicKeyDerive = publicKeyDerive;
})(Edx25519 || (Edx25519 = {}));
function invariant(cond) {
  if (!cond) {
    throw Error("invariant failed");
  }
}
var AgeRestriction;
(function(AgeRestriction2) {
  AgeRestriction2.AGE_UNRESTRICTED = 32;
  function hashCommitment(ac) {
    const hc = new HashState();
    for (const pub of ac.publicKeys) {
      hc.update(decodeCrock(pub));
    }
    return encodeCrock(hc.finish().subarray(0, 32));
  }
  AgeRestriction2.hashCommitment = hashCommitment;
  function countAgeGroups(mask) {
    let count = 0;
    let m5 = mask;
    while (m5 > 0) {
      count += m5 & 1;
      m5 = m5 >> 1;
    }
    return count;
  }
  AgeRestriction2.countAgeGroups = countAgeGroups;
  function getAgeGroupsFromMask(mask) {
    const groups = [];
    let age = 1;
    let m5 = mask >> 1;
    while (m5 > 0) {
      if (m5 & 1) {
        groups.push(age);
      }
      m5 = m5 >> 1;
      age++;
    }
    return groups;
  }
  AgeRestriction2.getAgeGroupsFromMask = getAgeGroupsFromMask;
  function getAgeGroupIndex(mask, age) {
    invariant((mask & 1) === 1);
    let i4 = 0;
    let m5 = mask;
    let a5 = age;
    while (m5 > 0) {
      if (a5 <= 0) {
        break;
      }
      m5 = m5 >> 1;
      i4 += m5 & 1;
      a5--;
    }
    return i4;
  }
  AgeRestriction2.getAgeGroupIndex = getAgeGroupIndex;
  function ageGroupSpecToMask(ageGroupSpec) {
    throw Error("not implemented");
  }
  AgeRestriction2.ageGroupSpecToMask = ageGroupSpecToMask;
  function restrictionCommit(ageMask, age) {
    return __async(this, null, function* () {
      invariant((ageMask & 1) === 1);
      const numPubs = countAgeGroups(ageMask) - 1;
      const numPrivs = getAgeGroupIndex(ageMask, age);
      const pubs = [];
      const privs = [];
      for (let i4 = 0; i4 < numPubs; i4++) {
        const priv = yield Edx25519.keyCreate();
        const pub = yield Edx25519.getPublic(priv);
        pubs.push(pub);
        if (i4 < numPrivs) {
          privs.push(priv);
        }
      }
      return {
        commitment: {
          mask: ageMask,
          publicKeys: pubs.map((x6) => encodeCrock(x6))
        },
        proof: {
          privateKeys: privs.map((x6) => encodeCrock(x6))
        }
      };
    });
  }
  AgeRestriction2.restrictionCommit = restrictionCommit;
  const PublishedAgeRestrictionBaseKey = decodeCrock("CH0VKFDZ2GWRWHQBBGEK9MWV5YDQVJ0RXEE0KYT3NMB69F0R96TG");
  function restrictionCommitSeeded(ageMask, age, seed) {
    return __async(this, null, function* () {
      invariant((ageMask & 1) === 1);
      const numPubs = countAgeGroups(ageMask) - 1;
      const numPrivs = getAgeGroupIndex(ageMask, age);
      const pubs = [];
      const privs = [];
      for (let i4 = 0; i4 < numPrivs; i4++) {
        const privSeed = yield kdfKw({
          outputLength: 32,
          ikm: seed,
          info: stringToBytes("age-commitment"),
          salt: bufferForUint32(i4)
        });
        const priv = yield Edx25519.keyCreateFromSeed(privSeed);
        const pub = yield Edx25519.getPublic(priv);
        pubs.push(pub);
        privs.push(priv);
      }
      for (let i4 = numPrivs; i4 < numPubs; i4++) {
        const deriveSeed = yield kdfKw({
          outputLength: 32,
          ikm: seed,
          info: stringToBytes("age-factor"),
          salt: bufferForUint32(i4)
        });
        const pub = yield Edx25519.publicKeyDerive(PublishedAgeRestrictionBaseKey, deriveSeed);
        pubs.push(pub);
      }
      return {
        commitment: {
          mask: ageMask,
          publicKeys: pubs.map((x6) => encodeCrock(x6))
        },
        proof: {
          privateKeys: privs.map((x6) => encodeCrock(x6))
        }
      };
    });
  }
  AgeRestriction2.restrictionCommitSeeded = restrictionCommitSeeded;
  function commitCompare(c1, c22, salt) {
    return __async(this, null, function* () {
      if (c1.publicKeys.length != c22.publicKeys.length) {
        return false;
      }
      for (let i4 = 0; i4 < c1.publicKeys.length; i4++) {
        const k1 = decodeCrock(c1.publicKeys[i4]);
        const k22 = yield Edx25519.publicKeyDerive(decodeCrock(c22.publicKeys[i4]), salt);
        if (k1 != k22) {
          return false;
        }
      }
      return true;
    });
  }
  AgeRestriction2.commitCompare = commitCompare;
  function commitmentDerive(commitmentProof, salt) {
    return __async(this, null, function* () {
      const newPrivs = [];
      const newPubs = [];
      for (const oldPub of commitmentProof.commitment.publicKeys) {
        newPubs.push(yield Edx25519.publicKeyDerive(decodeCrock(oldPub), salt));
      }
      for (const oldPriv of commitmentProof.proof.privateKeys) {
        newPrivs.push(yield Edx25519.privateKeyDerive(decodeCrock(oldPriv), salt));
      }
      return {
        commitment: {
          mask: commitmentProof.commitment.mask,
          publicKeys: newPubs.map((x6) => encodeCrock(x6))
        },
        proof: {
          privateKeys: newPrivs.map((x6) => encodeCrock(x6))
        }
      };
    });
  }
  AgeRestriction2.commitmentDerive = commitmentDerive;
  function commitmentAttest(commitmentProof, age) {
    const d5 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitmentProof.commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitmentProof.commitment.mask, age);
    if (group === 0) {
      return new Uint8Array(64);
    }
    const priv = commitmentProof.proof.privateKeys[group - 1];
    const pub = commitmentProof.commitment.publicKeys[group - 1];
    const sig = crypto_edx25519_sign_detached(d5, decodeCrock(priv), decodeCrock(pub));
    return sig;
  }
  AgeRestriction2.commitmentAttest = commitmentAttest;
  function commitmentVerify(commitment, sig, age) {
    const d5 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitment.mask, age);
    if (group === 0) {
      return true;
    }
    const pub = commitment.publicKeys[group - 1];
    return crypto_edx25519_sign_detached_verify(d5, decodeCrock(sig), decodeCrock(pub));
  }
  AgeRestriction2.commitmentVerify = commitmentVerify;
})(AgeRestriction || (AgeRestriction = {}));
var ContractFormatTag;
(function(ContractFormatTag2) {
  ContractFormatTag2[ContractFormatTag2["PaymentOffer"] = 0] = "PaymentOffer";
  ContractFormatTag2[ContractFormatTag2["PaymentRequest"] = 1] = "PaymentRequest";
})(ContractFormatTag || (ContractFormatTag = {}));

// ../taler-util/lib/bech32.js
var CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
var GENERATOR = [996825010, 642813549, 513874426, 1027748829, 705979059];
var encodings = {
  BECH32: "bech32",
  BECH32M: "bech32m"
};
var bech32_default = {
  decode: decode2,
  encode: encode2,
  encodings
};
function getEncodingConst(enc) {
  if (enc == encodings.BECH32) {
    return 1;
  } else if (enc == encodings.BECH32M) {
    return 734539939;
  } else {
    throw new Error("unknown encoding");
  }
}
function polymod(values) {
  var chk = 1;
  for (var p4 = 0; p4 < values.length; ++p4) {
    var top = chk >> 25;
    chk = (chk & 33554431) << 5 ^ values[p4];
    for (var i4 = 0; i4 < 5; ++i4) {
      if (top >> i4 & 1) {
        chk ^= GENERATOR[i4];
      }
    }
  }
  return chk;
}
function hrpExpand(hrp) {
  var ret = [];
  var p4;
  for (p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) >> 5);
  }
  ret.push(0);
  for (p4 = 0; p4 < hrp.length; ++p4) {
    ret.push(hrp.charCodeAt(p4) & 31);
  }
  return ret;
}
function verifyChecksum(hrp, data, enc) {
  return polymod(hrpExpand(hrp).concat(data)) === getEncodingConst(enc);
}
function createChecksum(hrp, data, enc) {
  var values = hrpExpand(hrp).concat(data).concat([0, 0, 0, 0, 0, 0]);
  var mod = polymod(values) ^ getEncodingConst(enc);
  var ret = [];
  for (var p4 = 0; p4 < 6; ++p4) {
    ret.push(mod >> 5 * (5 - p4) & 31);
  }
  return ret;
}
function encode2(hrp, data, enc) {
  var combined = data.concat(createChecksum(hrp, data, enc));
  var ret = hrp + "1";
  for (var p4 = 0; p4 < combined.length; ++p4) {
    ret += CHARSET.charAt(combined[p4]);
  }
  return ret;
}
function decode2(bechString, enc) {
  var p4;
  var has_lower = false;
  var has_upper = false;
  for (p4 = 0; p4 < bechString.length; ++p4) {
    if (bechString.charCodeAt(p4) < 33 || bechString.charCodeAt(p4) > 126) {
      return null;
    }
    if (bechString.charCodeAt(p4) >= 97 && bechString.charCodeAt(p4) <= 122) {
      has_lower = true;
    }
    if (bechString.charCodeAt(p4) >= 65 && bechString.charCodeAt(p4) <= 90) {
      has_upper = true;
    }
  }
  if (has_lower && has_upper) {
    return null;
  }
  bechString = bechString.toLowerCase();
  var pos = bechString.lastIndexOf("1");
  if (pos < 1 || pos + 7 > bechString.length || bechString.length > 90) {
    return null;
  }
  var hrp = bechString.substring(0, pos);
  var data = [];
  for (p4 = pos + 1; p4 < bechString.length; ++p4) {
    var d5 = CHARSET.indexOf(bechString.charAt(p4));
    if (d5 === -1) {
      return null;
    }
    data.push(d5);
  }
  if (!verifyChecksum(hrp, data, enc)) {
    return null;
  }
  return { hrp, data: data.slice(0, data.length - 6) };
}

// ../taler-util/lib/segwit_addr.js
var segwit_addr_default = {
  encode: encode3,
  decode: decode3
};
function convertbits(data, frombits, tobits, pad) {
  var acc = 0;
  var bits = 0;
  var ret = [];
  var maxv = (1 << tobits) - 1;
  for (var p4 = 0; p4 < data.length; ++p4) {
    var value = data[p4];
    if (value < 0 || value >> frombits !== 0) {
      return [];
    }
    acc = acc << frombits | value;
    bits += frombits;
    while (bits >= tobits) {
      bits -= tobits;
      ret.push(acc >> bits & maxv);
    }
  }
  if (pad) {
    if (bits > 0) {
      ret.push(acc << tobits - bits & maxv);
    }
  } else if (bits >= frombits || acc << tobits - bits & maxv) {
    return [];
  }
  return ret;
}
function decode3(hrp, addr) {
  var bech32m = false;
  var dec = bech32_default.decode(addr, bech32_default.encodings.BECH32);
  if (dec === null) {
    dec = bech32_default.decode(addr, bech32_default.encodings.BECH32M);
    bech32m = true;
  }
  if (dec === null || dec.hrp !== hrp || dec.data.length < 1 || dec.data[0] > 16) {
    return null;
  }
  var res = convertbits(dec.data.slice(1), 5, 8, false);
  if (res === null || res.length < 2 || res.length > 40) {
    return null;
  }
  if (dec.data[0] === 0 && res.length !== 20 && res.length !== 32) {
    return null;
  }
  if (dec.data[0] === 0 && bech32m) {
    return null;
  }
  if (dec.data[0] !== 0 && !bech32m) {
    return null;
  }
  return { version: dec.data[0], program: res };
}
function encode3(hrp, version, program) {
  var enc = bech32_default.encodings.BECH32;
  if (version > 0) {
    enc = bech32_default.encodings.BECH32M;
  }
  var ret = bech32_default.encode(hrp, [version].concat(convertbits(program, 8, 5, true)), enc);
  if (decode3(
    hrp,
    ret
    /*, enc*/
  ) === null) {
    return "";
  }
  return ret;
}

// ../taler-util/lib/bitcoin.js
function generateFakeSegwitAddress(reservePub, addr) {
  if (!reservePub)
    return [];
  let pub;
  try {
    pub = decodeCrock(reservePub);
  } catch (e4) {
  }
  if (!pub || pub.length !== 32)
    return [];
  const first_rnd = new Uint8Array(4);
  first_rnd.set(pub.subarray(0, 4));
  const second_rnd = new Uint8Array(4);
  second_rnd.set(pub.subarray(0, 4));
  first_rnd[0] = first_rnd[0] & 127;
  second_rnd[0] = second_rnd[0] | 128;
  const first_part = new Uint8Array(first_rnd.length + pub.length / 2);
  first_part.set(first_rnd, 0);
  first_part.set(pub.subarray(0, 16), 4);
  const second_part = new Uint8Array(first_rnd.length + pub.length / 2);
  second_part.set(second_rnd, 0);
  second_part.set(pub.subarray(16, 32), 4);
  const prefix2 = addr[0] === "t" && addr[1] == "b" ? "tb" : addr[0] === "b" && addr[1] == "c" && addr[2] === "r" && addr[3] == "t" ? "bcrt" : addr[0] === "b" && addr[1] == "c" ? "bc" : void 0;
  if (prefix2 === void 0)
    throw new Error("unknown bitcoin net");
  const addr1 = segwit_addr_default.encode(prefix2, 0, first_part);
  const addr2 = segwit_addr_default.encode(prefix2, 0, second_part);
  return [addr1, addr2];
}

// ../taler-util/lib/payto.js
function codecForPaytoString() {
  return {
    decode(x6, c4) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x6}`);
      }
      if (!x6.startsWith(paytoPfx)) {
        throw new DecodingError(`expected start with payto at ${renderContext(c4)} but got "${x6}"`);
      }
      return x6;
    }
  };
}
var paytoPfx = "payto://";
function buildPayto(type, first, second) {
  switch (type) {
    case "bitcoin": {
      const result = {
        isKnown: true,
        targetType: "bitcoin",
        targetPath: first,
        params: {},
        segwitAddrs: !second ? [] : generateFakeSegwitAddress(second, first)
      };
      return result;
    }
    case "iban": {
      const uppercased = first.toUpperCase();
      const result = {
        isKnown: true,
        targetType: "iban",
        iban: uppercased,
        params: {},
        targetPath: !second ? uppercased : `${second}/${uppercased}`
      };
      return result;
    }
    case "x-taler-bank": {
      if (!second)
        throw Error("missing account for payto://x-taler-bank");
      const result = {
        isKnown: true,
        targetType: "x-taler-bank",
        host: first,
        account: second,
        params: {},
        targetPath: `${first}/${second}`
      };
      return result;
    }
    default: {
      const unknownType = type;
      throw Error(`unknown payto:// type ${unknownType}`);
    }
  }
}
function stringifyPaytoUri(p4) {
  const url = new URL(`${paytoPfx}${p4.targetType}/${p4.targetPath}`);
  const paramList = !p4.params ? [] : Object.entries(p4.params);
  paramList.forEach(([key, value]) => {
    url.searchParams.set(key, value);
  });
  return url.href;
}
function parsePaytoUri(s5) {
  if (!s5.startsWith(paytoPfx)) {
    return void 0;
  }
  const [acct, search] = s5.slice(paytoPfx.length).split("?");
  const firstSlashPos = acct.indexOf("/");
  if (firstSlashPos === -1) {
    return void 0;
  }
  const targetType = acct.slice(0, firstSlashPos);
  const targetPath = acct.slice(firstSlashPos + 1);
  const params = {};
  const searchParams = new URLSearchParams(search || "");
  searchParams.forEach((v3, k5) => {
    params[k5] = v3;
  });
  if (targetType === "x-taler-bank") {
    const parts = targetPath.split("/");
    const host = parts[0];
    const account = parts[1];
    return {
      targetPath,
      targetType,
      params,
      isKnown: true,
      host,
      account
    };
  }
  if (targetType === "iban") {
    const parts = targetPath.split("/");
    let iban = void 0;
    let bic = void 0;
    if (parts.length === 1) {
      iban = parts[0].toUpperCase();
    }
    if (parts.length === 2) {
      bic = parts[0];
      iban = parts[1].toUpperCase();
    } else {
      iban = targetPath.toUpperCase();
    }
    return {
      isKnown: true,
      targetPath,
      targetType,
      params,
      iban,
      bic
    };
  }
  if (targetType === "bitcoin") {
    const msg = /\b([A-Z0-9]{52})\b/.exec(params["message"]);
    const reserve = !msg ? params["subject"] : msg[0];
    const segwitAddrs = !reserve ? [] : generateFakeSegwitAddress(reserve, targetPath);
    const result = {
      isKnown: true,
      targetPath,
      targetType,
      params,
      segwitAddrs
    };
    return result;
  }
  return {
    targetPath,
    targetType,
    params,
    isKnown: false
  };
}

// ../taler-util/lib/ReserveTransaction.js
var ReserveTransactionType;
(function(ReserveTransactionType2) {
  ReserveTransactionType2["Withdraw"] = "WITHDRAW";
  ReserveTransactionType2["Credit"] = "CREDIT";
  ReserveTransactionType2["Recoup"] = "RECOUP";
  ReserveTransactionType2["Closing"] = "CLOSING";
})(ReserveTransactionType || (ReserveTransactionType = {}));

// ../taler-util/lib/taleruri.js
function codecForTalerActionString() {
  return {
    decode(x6, c4) {
      if (typeof x6 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x6}`);
      }
      if (parseTalerUri(x6) === void 0) {
        throw new DecodingError(`invalid taler action at ${renderContext(c4)} but got "${x6}"`);
      }
      return x6;
    }
  };
}
function parseWithdrawUri(s5) {
  const pi = parseProtoInfo(s5, "withdraw");
  if (!pi) {
    return void 0;
  }
  const parts = pi.rest.split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const pathSegments = parts.slice(1, parts.length - 1);
  const withdrawId = parts[parts.length - 1];
  const p4 = [host, ...pathSegments].join("/");
  return {
    type: TalerUriAction.Withdraw,
    bankIntegrationApiBaseUrl: canonicalizeBaseUrl(`${pi.innerProto}://${p4}/`),
    withdrawalOperationId: withdrawId
  };
}
var TalerUriType;
(function(TalerUriType2) {
  TalerUriType2["TalerPay"] = "taler-pay";
  TalerUriType2["TalerTemplate"] = "taler-template";
  TalerUriType2["TalerPayTemplate"] = "taler-pay-template";
  TalerUriType2["TalerWithdraw"] = "taler-withdraw";
  TalerUriType2["TalerTip"] = "taler-tip";
  TalerUriType2["TalerRefund"] = "taler-refund";
  TalerUriType2["TalerPayPush"] = "taler-pay-push";
  TalerUriType2["TalerPayPull"] = "taler-pay-pull";
  TalerUriType2["TalerRecovery"] = "taler-recovery";
  TalerUriType2["TalerDevExperiment"] = "taler-dev-experiment";
  TalerUriType2["Unknown"] = "unknown";
})(TalerUriType || (TalerUriType = {}));
var talerActionPayPull = "pay-pull";
var talerActionPayPush = "pay-push";
var talerActionPayTemplate = "pay-template";
var TalerUriAction;
(function(TalerUriAction2) {
  TalerUriAction2["Pay"] = "pay";
  TalerUriAction2["Withdraw"] = "withdraw";
  TalerUriAction2["Refund"] = "refund";
  TalerUriAction2["Reward"] = "reward";
  TalerUriAction2["PayPull"] = "pay-pull";
  TalerUriAction2["PayPush"] = "pay-push";
  TalerUriAction2["PayTemplate"] = "pay-template";
  TalerUriAction2["Exchange"] = "exchange";
  TalerUriAction2["Auditor"] = "auditor";
  TalerUriAction2["Restore"] = "restore";
  TalerUriAction2["DevExperiment"] = "dev-experiment";
  TalerUriAction2["WithdrawExchange"] = "withdraw-exchange";
})(TalerUriAction || (TalerUriAction = {}));
function parseProtoInfo(s5, action) {
  const pfxPlain = `taler://${action}/`;
  const pfxHttp = `taler+http://${action}/`;
  if (s5.toLowerCase().startsWith(pfxPlain)) {
    return {
      innerProto: "https",
      rest: s5.substring(pfxPlain.length)
    };
  } else if (s5.toLowerCase().startsWith(pfxHttp)) {
    return {
      innerProto: "http",
      rest: s5.substring(pfxHttp.length)
    };
  } else {
    return void 0;
  }
}
var parsers = {
  [TalerUriAction.Pay]: parsePayUri,
  [TalerUriAction.PayPull]: parsePayPullUri,
  [TalerUriAction.PayPush]: parsePayPushUri,
  [TalerUriAction.PayTemplate]: parsePayTemplateUri,
  [TalerUriAction.Restore]: parseRestoreUri,
  [TalerUriAction.Refund]: parseRefundUri,
  [TalerUriAction.Reward]: parseRewardUri,
  [TalerUriAction.Withdraw]: parseWithdrawUri,
  [TalerUriAction.DevExperiment]: parseDevExperimentUri,
  [TalerUriAction.Exchange]: parseExchangeUri,
  [TalerUriAction.Auditor]: parseAuditorUri,
  [TalerUriAction.WithdrawExchange]: parseWithdrawExchangeUri
};
function parseTalerUri(string) {
  const https = string.startsWith("taler://");
  const http = string.startsWith("taler+http://");
  if (!https && !http)
    return void 0;
  const actionStart = https ? 8 : 13;
  const actionEnd = string.indexOf("/", actionStart + 1);
  const action = string.substring(actionStart, actionEnd);
  const found = Object.values(TalerUriAction).find((x6) => x6 === action);
  if (!found)
    return void 0;
  return parsers[found](string);
}
function parsePayUri(s5) {
  var _a, _b, _c;
  const pi = parseProtoInfo(s5, "pay");
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const q5 = new URLSearchParams((_a = c4[1]) != null ? _a : "");
  const claimToken = (_b = q5.get("c")) != null ? _b : void 0;
  const noncePriv = (_c = q5.get("n")) != null ? _c : void 0;
  const parts = c4[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const p4 = [host, ...pathSegments].join("/");
  const merchantBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${p4}/`);
  return {
    type: TalerUriAction.Pay,
    merchantBaseUrl,
    orderId,
    sessionId,
    claimToken,
    noncePriv
  };
}
function parsePayTemplateUri(uriString) {
  var _a;
  const pi = parseProtoInfo(uriString, talerActionPayTemplate);
  if (!pi) {
    return void 0;
  }
  const c4 = pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const q5 = new URLSearchParams((_a = c4[1]) != null ? _a : "");
  const params = {};
  q5.forEach((v3, k5) => {
    params[k5] = v3;
  });
  const host = parts[0].toLowerCase();
  const templateId = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.PayTemplate,
    merchantBaseUrl,
    templateId,
    templateParams: params
  };
}
function parsePayPushUri(s5) {
  const pi = parseProtoInfo(s5, talerActionPayPush);
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.PayPush,
    exchangeBaseUrl,
    contractPriv
  };
}
function parsePayPullUri(s5) {
  const pi = parseProtoInfo(s5, talerActionPayPull);
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.PayPull,
    exchangeBaseUrl,
    contractPriv
  };
}
function parseRewardUri(s5) {
  const pi = parseProtoInfo(s5, "reward");
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const rewardId = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.Reward,
    merchantBaseUrl,
    merchantRewardId: rewardId
  };
}
function parseExchangeUri(s5) {
  const pi = parseProtoInfo(s5, "exchange");
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const exchangePub = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.Exchange,
    exchangeBaseUrl,
    exchangePub
  };
}
function parseWithdrawExchangeUri(s5) {
  var _a, _b;
  const pi = parseProtoInfo(s5, "withdraw-exchange");
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const exchangePub = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  const q5 = new URLSearchParams((_a = c4[1]) != null ? _a : "");
  const amount = (_b = q5.get("a")) != null ? _b : void 0;
  return {
    type: TalerUriAction.WithdrawExchange,
    exchangeBaseUrl,
    exchangePub,
    amount
  };
}
function parseAuditorUri(s5) {
  const pi = parseProtoInfo(s5, "auditor");
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const auditorPub = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const auditorBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.Auditor,
    auditorBaseUrl,
    auditorPub
  };
}
function parseRefundUri(s5) {
  const pi = parseProtoInfo(s5, "refund");
  if (!pi) {
    return void 0;
  }
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.Refund,
    merchantBaseUrl,
    orderId
  };
}
function parseDevExperimentUri(s5) {
  const pi = parseProtoInfo(s5, "dev-experiment");
  const c4 = pi == null ? void 0 : pi.rest.split("?");
  if (!c4) {
    return void 0;
  }
  const parts = c4[0].split("/");
  return {
    type: TalerUriAction.DevExperiment,
    devExperimentId: parts[0]
  };
}
function parseRestoreUri(uri) {
  const pi = parseProtoInfo(uri, "restore");
  if (!pi) {
    return void 0;
  }
  const c4 = pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const walletRootPriv = parts[0];
  if (!walletRootPriv)
    return void 0;
  const providers = new Array();
  parts[1].split(",").map((name) => {
    const url = canonicalizeBaseUrl(`${pi.innerProto}://${decodeURIComponent(name)}/`);
    providers.push(url);
  });
  return {
    type: TalerUriAction.Restore,
    walletRootPriv,
    providers
  };
}
function stringifyWithdrawUri({ bankIntegrationApiBaseUrl, withdrawalOperationId }) {
  const { proto, path } = getUrlInfo(bankIntegrationApiBaseUrl);
  return `${proto}://withdraw/${path}${withdrawalOperationId}`;
}
function getUrlInfo(baseUrl, params = {}) {
  const url = new URL2(baseUrl);
  let proto;
  if (url.protocol === "https:") {
    proto = "taler";
  } else if (url.protocol === "http:") {
    proto = "taler+http";
  } else {
    throw Error(`Unsupported URL protocol in ${baseUrl}`);
  }
  let path = url.hostname;
  if (url.port) {
    path = path + ":" + url.port;
  }
  if (url.pathname) {
    path = path + url.pathname;
  }
  if (!path.endsWith("/")) {
    path = path + "/";
  }
  const qp = new URLSearchParams();
  let withParams = false;
  Object.entries(params).forEach(([name, value]) => {
    if (value !== void 0) {
      withParams = true;
      qp.append(name, value);
    }
  });
  const query = withParams ? "?" + qp.toString() : "";
  return { proto, path, query };
}

// ../taler-util/lib/transactions-types.js
var TransactionMajorState;
(function(TransactionMajorState2) {
  TransactionMajorState2["None"] = "none";
  TransactionMajorState2["Pending"] = "pending";
  TransactionMajorState2["Done"] = "done";
  TransactionMajorState2["Aborting"] = "aborting";
  TransactionMajorState2["Aborted"] = "aborted";
  TransactionMajorState2["Suspended"] = "suspended";
  TransactionMajorState2["Dialog"] = "dialog";
  TransactionMajorState2["SuspendedAborting"] = "suspended-aborting";
  TransactionMajorState2["Failed"] = "failed";
  TransactionMajorState2["Expired"] = "expired";
  TransactionMajorState2["Deleted"] = "deleted";
})(TransactionMajorState || (TransactionMajorState = {}));
var TransactionMinorState;
(function(TransactionMinorState2) {
  TransactionMinorState2["Unknown"] = "unknown";
  TransactionMinorState2["Deposit"] = "deposit";
  TransactionMinorState2["KycRequired"] = "kyc";
  TransactionMinorState2["AmlRequired"] = "aml";
  TransactionMinorState2["MergeKycRequired"] = "merge-kyc";
  TransactionMinorState2["Track"] = "track";
  TransactionMinorState2["SubmitPayment"] = "submit-payment";
  TransactionMinorState2["RebindSession"] = "rebind-session";
  TransactionMinorState2["Refresh"] = "refresh";
  TransactionMinorState2["Pickup"] = "pickup";
  TransactionMinorState2["AutoRefund"] = "auto-refund";
  TransactionMinorState2["User"] = "user";
  TransactionMinorState2["Bank"] = "bank";
  TransactionMinorState2["Exchange"] = "exchange";
  TransactionMinorState2["ClaimProposal"] = "claim-proposal";
  TransactionMinorState2["CheckRefund"] = "check-refund";
  TransactionMinorState2["CreatePurse"] = "create-purse";
  TransactionMinorState2["DeletePurse"] = "delete-purse";
  TransactionMinorState2["Ready"] = "ready";
  TransactionMinorState2["Merge"] = "merge";
  TransactionMinorState2["Repurchase"] = "repurchase";
  TransactionMinorState2["BankRegisterReserve"] = "bank-register-reserve";
  TransactionMinorState2["BankConfirmTransfer"] = "bank-confirm-transfer";
  TransactionMinorState2["WithdrawCoins"] = "withdraw-coins";
  TransactionMinorState2["ExchangeWaitReserve"] = "exchange-wait-reserve";
  TransactionMinorState2["AbortingBank"] = "aborting-bank";
  TransactionMinorState2["Aborting"] = "aborting";
  TransactionMinorState2["Refused"] = "refused";
  TransactionMinorState2["Withdraw"] = "withdraw";
  TransactionMinorState2["MerchantOrderProposed"] = "merchant-order-proposed";
  TransactionMinorState2["Proposed"] = "proposed";
  TransactionMinorState2["RefundAvailable"] = "refund-available";
  TransactionMinorState2["AcceptRefund"] = "accept-refund";
})(TransactionMinorState || (TransactionMinorState = {}));
var TransactionAction;
(function(TransactionAction2) {
  TransactionAction2["Delete"] = "delete";
  TransactionAction2["Suspend"] = "suspend";
  TransactionAction2["Resume"] = "resume";
  TransactionAction2["Abort"] = "abort";
  TransactionAction2["Fail"] = "fail";
  TransactionAction2["Retry"] = "retry";
})(TransactionAction || (TransactionAction = {}));
var TransactionType;
(function(TransactionType2) {
  TransactionType2["Withdrawal"] = "withdrawal";
  TransactionType2["InternalWithdrawal"] = "internal-withdrawal";
  TransactionType2["Payment"] = "payment";
  TransactionType2["Refund"] = "refund";
  TransactionType2["Refresh"] = "refresh";
  TransactionType2["Reward"] = "reward";
  TransactionType2["Deposit"] = "deposit";
  TransactionType2["PeerPushDebit"] = "peer-push-debit";
  TransactionType2["PeerPushCredit"] = "peer-push-credit";
  TransactionType2["PeerPullDebit"] = "peer-pull-debit";
  TransactionType2["PeerPullCredit"] = "peer-pull-credit";
})(TransactionType || (TransactionType = {}));
var WithdrawalType;
(function(WithdrawalType2) {
  WithdrawalType2["TalerBankIntegrationApi"] = "taler-bank-integration-api";
  WithdrawalType2["ManualTransfer"] = "manual-transfer";
})(WithdrawalType || (WithdrawalType = {}));
var PaymentStatus;
(function(PaymentStatus2) {
  PaymentStatus2["Aborted"] = "aborted";
  PaymentStatus2["Failed"] = "failed";
  PaymentStatus2["Paid"] = "paid";
  PaymentStatus2["Accepted"] = "accepted";
})(PaymentStatus || (PaymentStatus = {}));

// ../taler-util/lib/wallet-types.js
var TransactionAmountMode;
(function(TransactionAmountMode2) {
  TransactionAmountMode2["Effective"] = "effective";
  TransactionAmountMode2["Raw"] = "raw";
})(TransactionAmountMode || (TransactionAmountMode = {}));
var codecForConvertAmountRequest = buildCodecForObject().property("amount", codecForAmountString()).property("type", codecForEither(codecForConstString(TransactionAmountMode.Raw), codecForConstString(TransactionAmountMode.Effective))).build("ConvertAmountRequest");
var codecForGetAmountRequest = buildCodecForObject().property("currency", codecForString()).build("GetAmountRequest");
var codecForGetPlanForWalletInitiatedOperation = () => buildCodecForObject().property("mode", codecForEither(codecForConstString(TransactionAmountMode.Raw), codecForConstString(TransactionAmountMode.Effective))).property("instructedAmount", codecForAmountString());
var codecForGetPlanForWithdrawRequest = codecForGetPlanForWalletInitiatedOperation().property("type", codecForConstString(TransactionType.Withdrawal)).property("exchangeUrl", codecOptional(codecForString())).build("GetPlanForWithdrawRequest");
var codecForGetPlanForDepositRequest = codecForGetPlanForWalletInitiatedOperation().property("type", codecForConstString(TransactionType.Deposit)).property("account", codecForString()).build("GetPlanForDepositRequest");
var codecForGetPlanForPushDebitRequest = codecForGetPlanForWalletInitiatedOperation().property("type", codecForConstString(TransactionType.PeerPushDebit)).build("GetPlanForPushDebitRequest");
var codecForGetPlanForPullCreditRequest = codecForGetPlanForWalletInitiatedOperation().property("type", codecForConstString(TransactionType.PeerPullCredit)).property("exchangeUrl", codecForString()).build("GetPlanForPullCreditRequest");
var codecForGetPlanForPaymentRequest = buildCodecForObject().property("type", codecForConstString(TransactionType.Payment)).property("maxDepositFee", codecForAmountString()).property("maxWireFee", codecForAmountString()).build("GetPlanForPaymentRequest");
var codecForGetPlanForPullDebitRequest = buildCodecForObject().property("type", codecForConstString(TransactionType.PeerPullDebit)).build("GetPlanForPullDebitRequest");
var codecForGetPlanForPushCreditRequest = buildCodecForObject().property("type", codecForConstString(TransactionType.PeerPushCredit)).build("GetPlanForPushCreditRequest");
var BalanceFlag;
(function(BalanceFlag2) {
  BalanceFlag2["IncomingKyc"] = "incoming-kyc";
  BalanceFlag2["IncomingAml"] = "incoming-aml";
  BalanceFlag2["IncomingConfirmation"] = "incoming-confirmation";
  BalanceFlag2["OutgoingKyc"] = "outgoing-kyc";
})(BalanceFlag || (BalanceFlag = {}));
var ScopeType;
(function(ScopeType2) {
  ScopeType2["Global"] = "global";
  ScopeType2["Exchange"] = "exchange";
  ScopeType2["Auditor"] = "auditor";
})(ScopeType || (ScopeType = {}));
var CoinStatus;
(function(CoinStatus2) {
  CoinStatus2["Fresh"] = "fresh";
  CoinStatus2["FreshSuspended"] = "fresh-suspended";
  CoinStatus2["Dormant"] = "dormant";
})(CoinStatus || (CoinStatus = {}));
var ConfirmPayResultType;
(function(ConfirmPayResultType2) {
  ConfirmPayResultType2["Done"] = "done";
  ConfirmPayResultType2["Pending"] = "pending";
})(ConfirmPayResultType || (ConfirmPayResultType = {}));
var codecForTalerErrorDetail = () => buildCodecForObject().property("code", codecForNumber()).property("when", codecOptional(codecForAbsoluteTime)).property("hint", codecOptional(codecForString())).build("TalerErrorDetail");
var PreparePayResultType;
(function(PreparePayResultType2) {
  PreparePayResultType2["PaymentPossible"] = "payment-possible";
  PreparePayResultType2["InsufficientBalance"] = "insufficient-balance";
  PreparePayResultType2["AlreadyConfirmed"] = "already-confirmed";
})(PreparePayResultType || (PreparePayResultType = {}));
var RefreshReason;
(function(RefreshReason2) {
  RefreshReason2["Manual"] = "manual";
  RefreshReason2["PayMerchant"] = "pay-merchant";
  RefreshReason2["PayDeposit"] = "pay-deposit";
  RefreshReason2["PayPeerPush"] = "pay-peer-push";
  RefreshReason2["PayPeerPull"] = "pay-peer-pull";
  RefreshReason2["Refund"] = "refund";
  RefreshReason2["AbortPay"] = "abort-pay";
  RefreshReason2["AbortDeposit"] = "abort-deposit";
  RefreshReason2["AbortPeerPushDebit"] = "abort-peer-push-debit";
  RefreshReason2["Recoup"] = "recoup";
  RefreshReason2["BackupRestored"] = "backup-restored";
  RefreshReason2["Scheduled"] = "scheduled";
})(RefreshReason || (RefreshReason = {}));
var ExchangeTosStatus;
(function(ExchangeTosStatus2) {
  ExchangeTosStatus2["Pending"] = "pending";
  ExchangeTosStatus2["Proposed"] = "proposed";
  ExchangeTosStatus2["Accepted"] = "accepted";
})(ExchangeTosStatus || (ExchangeTosStatus = {}));
var ExchangeEntryStatus;
(function(ExchangeEntryStatus2) {
  ExchangeEntryStatus2["Preset"] = "preset";
  ExchangeEntryStatus2["Ephemeral"] = "ephemeral";
  ExchangeEntryStatus2["Used"] = "used";
})(ExchangeEntryStatus || (ExchangeEntryStatus = {}));
var ExchangeUpdateStatus;
(function(ExchangeUpdateStatus2) {
  ExchangeUpdateStatus2["Initial"] = "initial";
  ExchangeUpdateStatus2["InitialUpdate"] = "initial(update)";
  ExchangeUpdateStatus2["Suspended"] = "suspended";
  ExchangeUpdateStatus2["Failed"] = "failed";
  ExchangeUpdateStatus2["OutdatedUpdate"] = "outdated(update)";
  ExchangeUpdateStatus2["Ready"] = "ready";
  ExchangeUpdateStatus2["ReadyUpdate"] = "ready(update)";
})(ExchangeUpdateStatus || (ExchangeUpdateStatus = {}));
var RecoveryMergeStrategy;
(function(RecoveryMergeStrategy2) {
  RecoveryMergeStrategy2["Ours"] = "ours";
  RecoveryMergeStrategy2["Theirs"] = "theirs";
})(RecoveryMergeStrategy || (RecoveryMergeStrategy = {}));
var AttentionPriority;
(function(AttentionPriority2) {
  AttentionPriority2["High"] = "high";
  AttentionPriority2["Medium"] = "medium";
  AttentionPriority2["Low"] = "low";
})(AttentionPriority || (AttentionPriority = {}));
var AttentionType;
(function(AttentionType2) {
  AttentionType2["KycWithdrawal"] = "kyc-withdrawal";
  AttentionType2["BackupUnpaid"] = "backup-unpaid";
  AttentionType2["BackupExpiresSoon"] = "backup-expires-soon";
  AttentionType2["MerchantRefund"] = "merchant-refund";
  AttentionType2["ExchangeTosChanged"] = "exchange-tos-changed";
  AttentionType2["ExchangeKeyExpired"] = "exchange-key-expired";
  AttentionType2["ExchangeKeyExpiresSoon"] = "exchange-key-expires-soon";
  AttentionType2["ExchangeDenominationsExpired"] = "exchange-denominations-expired";
  AttentionType2["ExchangeDenominationsExpiresSoon"] = "exchange-denominations-expires-soon";
  AttentionType2["AuditorTosChanged"] = "auditor-tos-changed";
  AttentionType2["AuditorKeyExpires"] = "auditor-key-expires";
  AttentionType2["AuditorDenominationsExpires"] = "auditor-denominations-expires";
  AttentionType2["PullPaymentPaid"] = "pull-payment-paid";
  AttentionType2["PushPaymentReceived"] = "push-payment-withdrawn";
})(AttentionType || (AttentionType = {}));
var UserAttentionPriority = {
  "kyc-withdrawal": AttentionPriority.Medium,
  "backup-unpaid": AttentionPriority.High,
  "backup-expires-soon": AttentionPriority.Medium,
  "merchant-refund": AttentionPriority.Medium,
  "exchange-tos-changed": AttentionPriority.Medium,
  "exchange-key-expired": AttentionPriority.High,
  "exchange-key-expires-soon": AttentionPriority.Medium,
  "exchange-denominations-expired": AttentionPriority.High,
  "exchange-denominations-expires-soon": AttentionPriority.Medium,
  "auditor-tos-changed": AttentionPriority.Medium,
  "auditor-key-expires": AttentionPriority.Medium,
  "auditor-denominations-expires": AttentionPriority.Medium,
  "pull-payment-paid": AttentionPriority.High,
  "push-payment-withdrawn": AttentionPriority.High
};

// ../taler-util/lib/i18n.js
var jedLib = __toESM(require_jed(), 1);
var logger2 = new Logger("i18n/index.ts");
var jed = void 0;
function setupI18n(lang, strings2) {
  lang = lang.replace("_", "-");
  if (!strings2[lang]) {
    strings2[lang] = {};
  }
  jed = new jedLib.Jed(strings2[lang]);
}
function toI18nString(stringSeq) {
  let s5 = "";
  for (let i4 = 0; i4 < stringSeq.length; i4++) {
    s5 += stringSeq[i4];
    if (i4 < stringSeq.length - 1) {
      s5 += `%${i4 + 1}$s`;
    }
  }
  return s5;
}
function singular(stringSeq, ...values) {
  const s5 = toI18nString(stringSeq);
  const tr = jed.translate(s5).ifPlural(1, s5).fetch(...values);
  return tr;
}
function translate(stringSeq, ...values) {
  const s5 = toI18nString(stringSeq);
  if (!s5)
    return [];
  const translation = jed.ngettext(s5, s5, 1);
  return replacePlaceholderWithValues(translation, values);
}
function Translate({ children, debug }) {
  const c4 = [].concat(children);
  const s5 = stringifyArray(c4);
  if (!s5)
    return [];
  const translation = jed.ngettext(s5, s5, 1);
  if (debug) {
    console.log("looking for ", s5, "got", translation);
  }
  return replacePlaceholderWithValues(translation, c4);
}
function replacePlaceholderWithValues(translation, childArray) {
  const tr = translation.split(/%(\d+)\$s/);
  const placeholderChildren = [];
  for (let i4 = 0; i4 < childArray.length; i4++) {
    const x6 = childArray[i4];
    if (x6 === void 0) {
      continue;
    } else if (typeof x6 === "string") {
      continue;
    } else {
      placeholderChildren.push(x6);
    }
  }
  const result = [];
  for (let i4 = 0; i4 < tr.length; i4++) {
    if (i4 % 2 == 0) {
      result.push(tr[i4]);
    } else {
      const childIdx = Number.parseInt(tr[i4]) - 1;
      result.push(placeholderChildren[childIdx]);
    }
  }
  return result;
}
function stringifyArray(children) {
  let n2 = 1;
  const ss = children.map((c4) => {
    if (typeof c4 === "string") {
      return c4;
    }
    return `%${n2++}$s`;
  });
  const s5 = ss.join("").replace(/ +/g, " ").trim();
  return s5;
}
var i18n = {
  str: singular,
  singular,
  Translate,
  translate
};

// ../taler-util/lib/fnutils.js
var fnutil;
(function(fnutil2) {
  function all(arr, f3) {
    for (const x6 of arr) {
      if (!f3(x6)) {
        return false;
      }
    }
    return true;
  }
  fnutil2.all = all;
  function any(arr, f3) {
    for (const x6 of arr) {
      if (f3(x6)) {
        return true;
      }
    }
    return false;
  }
  fnutil2.any = any;
})(fnutil || (fnutil = {}));

// ../taler-util/lib/http-status-codes.js
var HttpStatusCode;
(function(HttpStatusCode3) {
  HttpStatusCode3[HttpStatusCode3["Continue"] = 100] = "Continue";
  HttpStatusCode3[HttpStatusCode3["SwitchingProtocols"] = 101] = "SwitchingProtocols";
  HttpStatusCode3[HttpStatusCode3["Processing"] = 102] = "Processing";
  HttpStatusCode3[HttpStatusCode3["Ok"] = 200] = "Ok";
  HttpStatusCode3[HttpStatusCode3["Created"] = 201] = "Created";
  HttpStatusCode3[HttpStatusCode3["Accepted"] = 202] = "Accepted";
  HttpStatusCode3[HttpStatusCode3["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
  HttpStatusCode3[HttpStatusCode3["NoContent"] = 204] = "NoContent";
  HttpStatusCode3[HttpStatusCode3["ResetContent"] = 205] = "ResetContent";
  HttpStatusCode3[HttpStatusCode3["PartialContent"] = 206] = "PartialContent";
  HttpStatusCode3[HttpStatusCode3["MultiStatus"] = 207] = "MultiStatus";
  HttpStatusCode3[HttpStatusCode3["AlreadyReported"] = 208] = "AlreadyReported";
  HttpStatusCode3[HttpStatusCode3["ImUsed"] = 226] = "ImUsed";
  HttpStatusCode3[HttpStatusCode3["MultipleChoices"] = 300] = "MultipleChoices";
  HttpStatusCode3[HttpStatusCode3["MovedPermanently"] = 301] = "MovedPermanently";
  HttpStatusCode3[HttpStatusCode3["Found"] = 302] = "Found";
  HttpStatusCode3[HttpStatusCode3["SeeOther"] = 303] = "SeeOther";
  HttpStatusCode3[HttpStatusCode3["NotModified"] = 304] = "NotModified";
  HttpStatusCode3[HttpStatusCode3["UseProxy"] = 305] = "UseProxy";
  HttpStatusCode3[HttpStatusCode3["SwitchProxy"] = 306] = "SwitchProxy";
  HttpStatusCode3[HttpStatusCode3["TemporaryRedirect"] = 307] = "TemporaryRedirect";
  HttpStatusCode3[HttpStatusCode3["PermanentRedirect"] = 308] = "PermanentRedirect";
  HttpStatusCode3[HttpStatusCode3["BadRequest"] = 400] = "BadRequest";
  HttpStatusCode3[HttpStatusCode3["Unauthorized"] = 401] = "Unauthorized";
  HttpStatusCode3[HttpStatusCode3["PaymentRequired"] = 402] = "PaymentRequired";
  HttpStatusCode3[HttpStatusCode3["Forbidden"] = 403] = "Forbidden";
  HttpStatusCode3[HttpStatusCode3["NotFound"] = 404] = "NotFound";
  HttpStatusCode3[HttpStatusCode3["MethodNotAllowed"] = 405] = "MethodNotAllowed";
  HttpStatusCode3[HttpStatusCode3["NotAcceptable"] = 406] = "NotAcceptable";
  HttpStatusCode3[HttpStatusCode3["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
  HttpStatusCode3[HttpStatusCode3["RequestTimeout"] = 408] = "RequestTimeout";
  HttpStatusCode3[HttpStatusCode3["Conflict"] = 409] = "Conflict";
  HttpStatusCode3[HttpStatusCode3["Gone"] = 410] = "Gone";
  HttpStatusCode3[HttpStatusCode3["LengthRequired"] = 411] = "LengthRequired";
  HttpStatusCode3[HttpStatusCode3["PreconditionFailed"] = 412] = "PreconditionFailed";
  HttpStatusCode3[HttpStatusCode3["PayloadTooLarge"] = 413] = "PayloadTooLarge";
  HttpStatusCode3[HttpStatusCode3["UriTooLong"] = 414] = "UriTooLong";
  HttpStatusCode3[HttpStatusCode3["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
  HttpStatusCode3[HttpStatusCode3["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
  HttpStatusCode3[HttpStatusCode3["ExpectationFailed"] = 417] = "ExpectationFailed";
  HttpStatusCode3[HttpStatusCode3["IAmATeapot"] = 418] = "IAmATeapot";
  HttpStatusCode3[HttpStatusCode3["MisdirectedRequest"] = 421] = "MisdirectedRequest";
  HttpStatusCode3[HttpStatusCode3["UnprocessableEntity"] = 422] = "UnprocessableEntity";
  HttpStatusCode3[HttpStatusCode3["Locked"] = 423] = "Locked";
  HttpStatusCode3[HttpStatusCode3["FailedDependency"] = 424] = "FailedDependency";
  HttpStatusCode3[HttpStatusCode3["UpgradeRequired"] = 426] = "UpgradeRequired";
  HttpStatusCode3[HttpStatusCode3["PreconditionRequired"] = 428] = "PreconditionRequired";
  HttpStatusCode3[HttpStatusCode3["TooManyRequests"] = 429] = "TooManyRequests";
  HttpStatusCode3[HttpStatusCode3["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
  HttpStatusCode3[HttpStatusCode3["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
  HttpStatusCode3[HttpStatusCode3["InternalServerError"] = 500] = "InternalServerError";
  HttpStatusCode3[HttpStatusCode3["NotImplemented"] = 501] = "NotImplemented";
  HttpStatusCode3[HttpStatusCode3["BadGateway"] = 502] = "BadGateway";
  HttpStatusCode3[HttpStatusCode3["ServiceUnavailable"] = 503] = "ServiceUnavailable";
  HttpStatusCode3[HttpStatusCode3["GatewayTimeout"] = 504] = "GatewayTimeout";
  HttpStatusCode3[HttpStatusCode3["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
  HttpStatusCode3[HttpStatusCode3["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
  HttpStatusCode3[HttpStatusCode3["InsufficientStorage"] = 507] = "InsufficientStorage";
  HttpStatusCode3[HttpStatusCode3["LoopDetected"] = 508] = "LoopDetected";
  HttpStatusCode3[HttpStatusCode3["NotExtended"] = 510] = "NotExtended";
  HttpStatusCode3[HttpStatusCode3["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

// ../taler-util/lib/RequestThrottler.js
var logger3 = new Logger("RequestThrottler.ts");
var MAX_PER_SECOND = 100;
var MAX_PER_MINUTE = 500;
var MAX_PER_HOUR = 2e3;
var OriginState = class {
  constructor() {
    this.tokensSecond = MAX_PER_SECOND;
    this.tokensMinute = MAX_PER_MINUTE;
    this.tokensHour = MAX_PER_HOUR;
    this.lastUpdate = AbsoluteTime.now();
  }
  refill() {
    const now = AbsoluteTime.now();
    if (AbsoluteTime.cmp(now, this.lastUpdate) < 0) {
      this.lastUpdate = now;
      return;
    }
    const d5 = AbsoluteTime.difference(now, this.lastUpdate);
    if (d5.d_ms === "forever") {
      throw Error("assertion failed");
    }
    this.tokensSecond = Math.min(MAX_PER_SECOND, this.tokensSecond + d5.d_ms / 1e3);
    this.tokensMinute = Math.min(MAX_PER_MINUTE, this.tokensMinute + d5.d_ms / 1e3 / 60);
    this.tokensHour = Math.min(MAX_PER_HOUR, this.tokensHour + d5.d_ms / 1e3 / 60 / 60);
    this.lastUpdate = now;
  }
  /**
   * Return true if the request for this origin should be throttled.
   * Otherwise, take a token out of the respective buckets.
   */
  applyThrottle() {
    this.refill();
    if (this.tokensSecond < 1) {
      logger3.warn("request throttled (per second limit exceeded)");
      return true;
    }
    if (this.tokensMinute < 1) {
      logger3.warn("request throttled (per minute limit exceeded)");
      return true;
    }
    if (this.tokensHour < 1) {
      logger3.warn("request throttled (per hour limit exceeded)");
      return true;
    }
    this.tokensSecond--;
    this.tokensMinute--;
    this.tokensHour--;
    return false;
  }
};
var RequestThrottler = class {
  constructor() {
    this.perOriginInfo = {};
  }
  /**
   * Get the throttling state for an origin, or
   * initialize if no state is associated with the
   * origin yet.
   */
  getState(origin) {
    const s5 = this.perOriginInfo[origin];
    if (s5) {
      return s5;
    }
    const ns = this.perOriginInfo[origin] = new OriginState();
    return ns;
  }
  /**
   * Apply throttling to a request.
   *
   * @returns whether the request should be throttled.
   */
  applyThrottle(requestUrl) {
    const origin = new URL(requestUrl).origin;
    return this.getState(origin).applyThrottle();
  }
  /**
   * Get the throttle statistics for a particular URL.
   */
  getThrottleStats(requestUrl) {
    const origin = new URL(requestUrl).origin;
    const state = this.getState(origin);
    return {
      tokensHour: state.tokensHour,
      tokensMinute: state.tokensMinute,
      tokensSecond: state.tokensSecond,
      maxTokensHour: MAX_PER_HOUR,
      maxTokensMinute: MAX_PER_MINUTE,
      maxTokensSecond: MAX_PER_SECOND
    };
  }
};

// ../taler-util/lib/TaskThrottler.js
var logger4 = new Logger("OperationThrottler.ts");

// ../taler-util/lib/CancellationToken.js
var NOOP = () => {
};
var CancellationToken = class {
  /**
   * Whether the token has been cancelled.
   */
  get isCancelled() {
    return this._isCancelled;
  }
  /**
   * Whether the token can be cancelled.
   */
  get canBeCancelled() {
    return this._canBeCancelled;
  }
  /**
   * Why this token has been cancelled.
   */
  get reason() {
    if (this.isCancelled) {
      return this._reason;
    } else {
      throw new Error("This token is not cancelled.");
    }
  }
  /**
   * Make a promise that resolves when the async operation resolves,
   * or rejects when the operation is rejected or this token is cancelled.
   */
  racePromise(asyncOperation) {
    if (!this.canBeCancelled) {
      return asyncOperation;
    }
    return new Promise((resolve, reject) => {
      const unregister = this.onCancelled((reason) => reject(new CancellationToken.CancellationError(reason)));
      asyncOperation.then((value) => {
        resolve(value);
        unregister();
      }, (err) => {
        reject(err);
        unregister();
      });
    });
  }
  /**
   * Throw a {CancellationToken.CancellationError} if this token is cancelled.
   */
  throwIfCancelled() {
    if (this._isCancelled) {
      throw new CancellationToken.CancellationError(this._reason);
    }
  }
  /**
   * Invoke the callback when this token is cancelled.
   * If this token is already cancelled, the callback is invoked immediately.
   * Returns a function that unregisters the cancellation callback.
   */
  onCancelled(cb) {
    var _a;
    if (!this.canBeCancelled) {
      return NOOP;
    }
    if (this.isCancelled) {
      cb(this.reason);
      return NOOP;
    }
    (_a = this._callbacks) == null ? void 0 : _a.add(cb);
    return () => {
      var _a2;
      return (_a2 = this._callbacks) == null ? void 0 : _a2.delete(cb);
    };
  }
  constructor(_isCancelled, _canBeCancelled) {
    this._isCancelled = _isCancelled;
    this._canBeCancelled = _canBeCancelled;
    this._callbacks = /* @__PURE__ */ new Set();
  }
  /**
   * Create a {CancellationTokenSource}.
   */
  static create() {
    const token = new CancellationToken(false, true);
    const cancel = (reason) => {
      var _a;
      if (token._isCancelled)
        return;
      token._isCancelled = true;
      token._reason = reason;
      (_a = token._callbacks) == null ? void 0 : _a.forEach((cb) => cb(reason));
      dispose();
    };
    const dispose = () => {
      token._canBeCancelled = token.isCancelled;
      delete token._callbacks;
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationTokenSource}.
   * The token will be cancelled automatically after the specified timeout in milliseconds.
   */
  static timeout(ms) {
    const { token, cancel: originalCancel, dispose: originalDispose } = CancellationToken.create();
    let timer;
    timer = setTimeout(() => originalCancel(CancellationToken.timeout), ms);
    const disposeTimer = () => {
      if (timer == null)
        return;
      clearTimeout(timer);
      timer = null;
    };
    const cancel = (reason) => {
      disposeTimer();
      originalCancel(reason);
    };
    const dispose = () => {
      disposeTimer();
      originalDispose();
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationToken} that is cancelled when all of the given tokens are cancelled.
   *
   * This is like {Promise<T>.all} for {CancellationToken}s.
   */
  static all(...tokens) {
    if (tokens.some((token) => !token.canBeCancelled)) {
      return CancellationToken.CONTINUE;
    }
    const combined = CancellationToken.create();
    let countdown = tokens.length;
    const handleNextTokenCancelled = () => {
      if (--countdown === 0) {
        const reasons = tokens.map((token) => token._reason);
        combined.cancel(reasons);
      }
    };
    tokens.forEach((token) => token.onCancelled(handleNextTokenCancelled));
    return combined.token;
  }
  /**
   * Create a {CancellationToken} that is cancelled when at least one of the given tokens is cancelled.
   *
   * This is like {Promise<T>.race} for {CancellationToken}s.
   */
  static race(...tokens) {
    for (const token of tokens) {
      if (token._isCancelled) {
        return token;
      }
    }
    const combined = CancellationToken.create();
    let unregistrations;
    const handleAnyTokenCancelled = (reason) => {
      unregistrations.forEach((unregister) => unregister());
      combined.cancel(reason);
    };
    unregistrations = tokens.map((token) => token.onCancelled(handleAnyTokenCancelled));
    return combined.token;
  }
};
CancellationToken.CANCELLED = new CancellationToken(true, true);
CancellationToken.CONTINUE = new CancellationToken(false, false);
(function(CancellationToken2) {
  class CancellationError extends Error {
    constructor(reason) {
      super("Operation cancelled");
      this.reason = reason;
      Object.setPrototypeOf(this, CancellationError.prototype);
    }
  }
  CancellationToken2.CancellationError = CancellationError;
})(CancellationToken || (CancellationToken = {}));

// ../taler-util/lib/contract-terms.js
var logger5 = new Logger("contractTerms.ts");
var ContractTermsUtil;
(function(ContractTermsUtil2) {
  function forgetAllImpl(anyJson, path, pred) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i4 = 0; i4 < dup.length; i4++) {
        dup[i4] = forgetAllImpl(dup[i4], [...path, `${i4}`], pred);
      }
    } else if (typeof dup === "object" && dup != null) {
      if (typeof dup.$forgettable === "object") {
        for (const x6 of Object.keys(dup.$forgettable)) {
          if (!pred([...path, x6])) {
            continue;
          }
          if (!dup.$forgotten) {
            dup.$forgotten = {};
          }
          if (!dup.$forgotten[x6]) {
            const membValCanon = stringToBytes(canonicalJson(scrub(dup[x6])) + "\0");
            const membSalt = stringToBytes(dup.$forgettable[x6] + "\0");
            const h5 = kdf(64, membValCanon, membSalt, new Uint8Array([]));
            dup.$forgotten[x6] = encodeCrock(h5);
          }
          delete dup[x6];
          delete dup.$forgettable[x6];
        }
        if (Object.keys(dup.$forgettable).length === 0) {
          delete dup.$forgettable;
        }
      }
      for (const x6 of Object.keys(dup)) {
        if (x6.startsWith("$")) {
          continue;
        }
        dup[x6] = forgetAllImpl(dup[x6], [...path, x6], pred);
      }
    }
    return dup;
  }
  ContractTermsUtil2.forgetAllImpl = forgetAllImpl;
  function scrub(anyJson) {
    return forgetAllImpl(anyJson, [], () => true);
  }
  ContractTermsUtil2.scrub = scrub;
  function forgetAll(anyJson, pred) {
    return forgetAllImpl(anyJson, [], pred);
  }
  ContractTermsUtil2.forgetAll = forgetAll;
  function saltForgettable(anyJson) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i4 = 0; i4 < dup.length; i4++) {
        dup[i4] = saltForgettable(dup[i4]);
      }
    } else if (typeof dup === "object" && dup !== null) {
      if (typeof dup.$forgettable === "object") {
        for (const k5 of Object.keys(dup.$forgettable)) {
          if (dup.$forgettable[k5] === true) {
            dup.$forgettable[k5] = encodeCrock(getRandomBytes(32));
          }
        }
      }
      for (const x6 of Object.keys(dup)) {
        if (x6.startsWith("$")) {
          continue;
        }
        dup[x6] = saltForgettable(dup[x6]);
      }
    }
    return dup;
  }
  ContractTermsUtil2.saltForgettable = saltForgettable;
  const nameRegex = /^[0-9A-Za-z_]+$/;
  function validateForgettable(anyJson) {
    var _a;
    if (typeof anyJson === "string") {
      return true;
    }
    if (typeof anyJson === "number") {
      return Number.isInteger(anyJson) && anyJson >= Number.MIN_SAFE_INTEGER && anyJson <= Number.MAX_SAFE_INTEGER;
    }
    if (typeof anyJson === "boolean") {
      return true;
    }
    if (anyJson === null) {
      return true;
    }
    if (Array.isArray(anyJson)) {
      return anyJson.every((x6) => validateForgettable(x6));
    }
    if (typeof anyJson === "object") {
      for (const k5 of Object.keys(anyJson)) {
        if (k5.match(nameRegex)) {
          if (validateForgettable(anyJson[k5])) {
            continue;
          } else {
            return false;
          }
        }
        if (k5 === "$forgettable") {
          const fga = anyJson.$forgettable;
          if (!fga || typeof fga !== "object") {
            return false;
          }
          for (const fk of Object.keys(fga)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (!(fk in anyJson)) {
              return false;
            }
            const fv = anyJson.$forgettable[fk];
            if (typeof fv !== "string") {
              return false;
            }
          }
        } else if (k5 === "$forgotten") {
          const fgo = anyJson.$forgotten;
          if (!fgo || typeof fgo !== "object") {
            return false;
          }
          for (const fk of Object.keys(fgo)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (fk in anyJson) {
              return false;
            }
            const fv = anyJson.$forgotten[fk];
            if (typeof fv !== "string") {
              return false;
            }
            try {
              const decFv = decodeCrock(fv);
              if (decFv.length != 64) {
                return false;
              }
            } catch (e4) {
              return false;
            }
            if (((_a = anyJson.$forgettable) == null ? void 0 : _a[k5]) !== void 0) {
              return false;
            }
          }
        } else {
          return false;
        }
      }
      return true;
    }
    return false;
  }
  ContractTermsUtil2.validateForgettable = validateForgettable;
  function validateNothingForgotten(contractTerms) {
    throw Error("not implemented yet");
  }
  ContractTermsUtil2.validateNothingForgotten = validateNothingForgotten;
  function hashContractTerms(contractTerms) {
    const cleaned = scrub(contractTerms);
    const canon = canonicalJson(cleaned) + "\0";
    const bytes = stringToBytes(canon);
    return encodeCrock(hash2(bytes));
  }
  ContractTermsUtil2.hashContractTerms = hashContractTerms;
})(ContractTermsUtil || (ContractTermsUtil = {}));

// ../taler-util/lib/base64.js
function base64FromArrayBuffer(arrayBuffer) {
  var base64 = "";
  var encodings2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  var bytes = new Uint8Array(arrayBuffer);
  var byteLength = bytes.byteLength;
  var byteRemainder = byteLength % 3;
  var mainLength = byteLength - byteRemainder;
  var a5, b4, c4, d5;
  var chunk;
  for (var i4 = 0; i4 < mainLength; i4 = i4 + 3) {
    chunk = bytes[i4] << 16 | bytes[i4 + 1] << 8 | bytes[i4 + 2];
    a5 = (chunk & 16515072) >> 18;
    b4 = (chunk & 258048) >> 12;
    c4 = (chunk & 4032) >> 6;
    d5 = chunk & 63;
    base64 += encodings2[a5] + encodings2[b4] + encodings2[c4] + encodings2[d5];
  }
  if (byteRemainder == 1) {
    chunk = bytes[mainLength];
    a5 = (chunk & 252) >> 2;
    b4 = (chunk & 3) << 4;
    base64 += encodings2[a5] + encodings2[b4] + "==";
  } else if (byteRemainder == 2) {
    chunk = bytes[mainLength] << 8 | bytes[mainLength + 1];
    a5 = (chunk & 64512) >> 10;
    b4 = (chunk & 1008) >> 4;
    c4 = (chunk & 15) << 2;
    base64 += encodings2[a5] + encodings2[b4] + encodings2[c4] + "=";
  }
  return base64;
}

// ../taler-util/lib/errors.js
function makeErrorDetail(code, detail, hint) {
  if (!hint && !detail.hint) {
    hint = getDefaultHint(code);
  }
  const when = AbsoluteTime.now();
  return __spreadValues({ code, when, hint }, detail);
}
function getDefaultHint(code) {
  const errName = TalerErrorCode[code];
  if (errName) {
    return `Error (${errName})`;
  } else {
    return `Error (<unknown>)`;
  }
}
var TalerError = class extends Error {
  constructor(d5) {
    var _a;
    super((_a = d5.hint) != null ? _a : `Error (code ${d5.code})`);
    this.errorDetail = d5;
    Object.setPrototypeOf(this, TalerError.prototype);
  }
  static fromDetail(code, detail, hint) {
    if (!hint) {
      hint = getDefaultHint(code);
    }
    const when = AbsoluteTime.now();
    return new TalerError(__spreadValues({ code, when, hint }, detail));
  }
  static fromUncheckedDetail(d5) {
    return new TalerError(__spreadValues({}, d5));
  }
  static fromException(e4) {
    const errDetail = getErrorDetailFromException(e4);
    return new TalerError(errDetail);
  }
  hasErrorCode(code) {
    return this.errorDetail.code === code;
  }
};
function getErrorDetailFromException(e4) {
  if (e4 instanceof TalerError) {
    return e4.errorDetail;
  }
  if (e4 instanceof Error) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {
      stack: e4.stack
    }, `unexpected exception (message: ${e4.message})`);
    return err2;
  }
  let excString;
  try {
    excString = e4.toString();
  } catch (e5) {
    excString = "can't stringify exception";
  }
  const err = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {}, `unexpected exception (not an exception, ${excString})`);
  return err;
}
function assertUnreachable(x6) {
  throw new Error("Didn't expect to get here");
}

// ../taler-util/lib/iban.js
var ccZero = "0".charCodeAt(0);
var ccNine = "9".charCodeAt(0);
var ccA = "A".charCodeAt(0);
var ccZ = "Z".charCodeAt(0);

// ../taler-util/lib/transaction-test-data.js
var sampleWalletCoreTransactions = [
  {
    type: TransactionType.Payment,
    txState: {
      major: TransactionMajorState.Done
    },
    amountRaw: "KUDOS:10",
    amountEffective: "KUDOS:10",
    totalRefundRaw: "KUDOS:0",
    totalRefundEffective: "KUDOS:0",
    status: PaymentStatus.Paid,
    refundPending: void 0,
    posConfirmation: void 0,
    pending: false,
    refunds: [],
    timestamp: {
      t_s: 1677166045
    },
    transactionId: "txn:payment:NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    proposalId: "NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    info: {
      merchant: {
        name: "woocommerce",
        website: "woocommerce.demo.taler.net",
        email: "foo@example.com",
        address: {},
        jurisdiction: {}
      },
      orderId: "wc_order_KQCRldghIgDRB-100",
      products: [
        {
          description: "Using GCC",
          quantity: 1,
          price: "KUDOS:10",
          product_id: "28"
        }
      ],
      summary: "WooTalerShop #100",
      contractTermsHash: "A02E1M6ARWKBJ87K2TV4S6WQ4X5YH7BRVR6MYCHCTVAED8MBXTFD6PZ5Q50Y7Z5K18PYBTDA14NQ56XPC1VCQW1EVRWTSB7ZYT65B5G",
      fulfillmentUrl: "https://woocommerce.demo.taler.net/?wc-api=wc_gnutaler_gateway&order_id=wc_order_KQCRldghIgDRB-100"
    },
    refundQueryActive: false,
    frozen: false
  },
  {
    type: TransactionType.Refresh,
    txState: {
      major: TransactionMajorState.Pending
    },
    refreshReason: RefreshReason.PayMerchant,
    amountEffective: "KUDOS:0",
    amountRaw: "KUDOS:0",
    refreshInputAmount: "KUDOS:1.5",
    refreshOutputAmount: "KUDOS:1.4",
    originatingTransactionId: "txn:proposal:ZCGBZFE8KZ1CBYYGSC3ZC8E40KVJWV16VYCTHGC8FFSVZ5HD24BG",
    pending: true,
    timestamp: {
      t_s: 1681376214
    },
    transactionId: "txn:refresh:QQSWHHXCRQ269G0E3RW14JMC6F7NFDYDW26NSFHRTXSKDS6CMCZ0",
    frozen: false,
    error: {
      code: 7029,
      when: {
        t_ms: 1681376473665
      },
      hint: "Error (WALLET_REFRESH_GROUP_INCOMPLETE)",
      numErrors: 1,
      errors: [
        {
          code: 7001,
          when: {
            t_ms: 1681376473189
          },
          hint: "unexpected exception (message: exchange wire fee signature invalid)",
          stack: "    at validateWireInfo (../taler-wallet-core-qjs.mjs:23166)\n"
        }
      ]
    }
  }
];

// ../taler-util/lib/http-impl.missing.js
var HttpLibImpl = class {
  get(url, opt) {
    throw new Error("Method not implemented.");
  }
  postJson(url, body, opt) {
    throw new Error("Method not implemented.");
  }
  fetch(url, opt) {
    throw new Error("Method not implemented.");
  }
};

// ../taler-util/lib/http-common.js
var textEncoder = new TextEncoder();
var logger6 = new Logger("http.ts");
var DEFAULT_REQUEST_TIMEOUT_MS = 6e4;
var Headers2 = class {
  constructor() {
    this.headerMap = /* @__PURE__ */ new Map();
  }
  get(name) {
    const r3 = this.headerMap.get(name.toLowerCase());
    if (r3) {
      return r3;
    }
    return null;
  }
  set(name, value) {
    const normalizedName = name.toLowerCase();
    const existing = this.headerMap.get(normalizedName);
    if (existing !== void 0) {
      this.headerMap.set(normalizedName, existing + "," + value);
    } else {
      this.headerMap.set(normalizedName, value);
    }
  }
  toJSON() {
    const m5 = {};
    this.headerMap.forEach((v3, k5) => m5[k5] = v3);
    return m5;
  }
};
function readTalerErrorResponse(httpResponse) {
  return __async(this, null, function* () {
    const contentType = httpResponse.headers.get("content-type");
    if (contentType !== "application/json") {
      throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
        requestUrl: httpResponse.requestUrl,
        requestMethod: httpResponse.requestMethod,
        httpStatusCode: httpResponse.status
      }, "Error response did not even contain JSON. The request URL might be wrong or the service might be unavailable.");
    }
    let errJson;
    try {
      errJson = yield httpResponse.json();
    } catch (e4) {
      throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
        requestUrl: httpResponse.requestUrl,
        requestMethod: httpResponse.requestMethod,
        httpStatusCode: httpResponse.status,
        validationError: e4.toString()
      }, "Couldn't parse JSON format from error response");
    }
    const talerErrorCode = errJson.code;
    if (typeof talerErrorCode !== "number") {
      logger6.warn(`malformed error response (status ${httpResponse.status}): ${j2s(errJson)}`);
      throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
        requestUrl: httpResponse.requestUrl,
        requestMethod: httpResponse.requestMethod,
        httpStatusCode: httpResponse.status
      }, "Error response did not contain error code");
    }
    return errJson;
  });
}
function readSuccessResponseJsonOrErrorCode(httpResponse, codec) {
  return __async(this, null, function* () {
    if (!(httpResponse.status >= 200 && httpResponse.status < 300)) {
      return {
        isError: true,
        talerErrorResponse: yield readTalerErrorResponse(httpResponse)
      };
    }
    let respJson;
    try {
      respJson = yield httpResponse.json();
    } catch (e4) {
      throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
        requestUrl: httpResponse.requestUrl,
        requestMethod: httpResponse.requestMethod,
        httpStatusCode: httpResponse.status,
        validationError: e4.toString()
      }, "Couldn't parse JSON format from response");
    }
    let parsedResponse;
    try {
      parsedResponse = codec.decode(respJson);
    } catch (e4) {
      throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
        requestUrl: httpResponse.requestUrl,
        requestMethod: httpResponse.requestMethod,
        httpStatusCode: httpResponse.status,
        validationError: e4.toString()
      }, "Response invalid");
    }
    return {
      isError: false,
      response: parsedResponse
    };
  });
}
function throwUnexpectedRequestError(httpResponse, talerErrorResponse) {
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, {
    requestUrl: httpResponse.requestUrl,
    requestMethod: httpResponse.requestMethod,
    httpStatusCode: httpResponse.status,
    errorResponse: talerErrorResponse
  }, `Unexpected HTTP status ${httpResponse.status} in response`);
}
function readSuccessResponseJsonOrThrow(httpResponse, codec) {
  return __async(this, null, function* () {
    const r3 = yield readSuccessResponseJsonOrErrorCode(httpResponse, codec);
    if (!r3.isError) {
      return r3.response;
    }
    throwUnexpectedRequestError(httpResponse, r3.talerErrorResponse);
  });
}
function encodeBody(body) {
  if (body == null) {
    return new ArrayBuffer(0);
  }
  if (typeof body === "string") {
    return textEncoder.encode(body).buffer;
  } else if (ArrayBuffer.isView(body)) {
    return body.buffer;
  } else if (body instanceof ArrayBuffer) {
    return body;
  } else if (typeof body === "object") {
    return textEncoder.encode(JSON.stringify(body)).buffer;
  }
  throw new TypeError("unsupported request body type");
}
function getDefaultHeaders(method) {
  const headers = {};
  if (method === "POST" || method === "PUT" || method === "PATCH") {
    headers["Content-Type"] = "application/json";
  }
  headers["Accept"] = "application/json";
  return headers;
}
function makeBasicAuthHeader(username, password) {
  const auth = `${username}:${password}`;
  const authEncoded = base64FromArrayBuffer(stringToBytes(auth));
  return `Basic ${authEncoded}`;
}

// ../taler-util/lib/http.js
function createPlatformHttpLib(args) {
  return new HttpLibImpl(args);
}

// ../taler-util/lib/MerchantApiClient.js
var logger7 = new Logger("MerchantApiClient.ts");

// ../taler-util/lib/bank-api-client.js
var logger8 = new Logger("bank-api-client.ts");
var CreditDebitIndicator;
(function(CreditDebitIndicator2) {
  CreditDebitIndicator2["Credit"] = "credit";
  CreditDebitIndicator2["Debit"] = "debit";
})(CreditDebitIndicator || (CreditDebitIndicator = {}));

// ../taler-util/lib/operation.js
function opSuccess(resp, codec) {
  return __async(this, null, function* () {
    const body = yield readSuccessResponseJsonOrThrow(resp, codec);
    return { type: "ok", body };
  });
}
function opFixedSuccess(body) {
  return { type: "ok", body };
}
function opEmptySuccess() {
  return { type: "ok", body: void 0 };
}
function opKnownFailure(s5, resp) {
  return __async(this, null, function* () {
    const detail = yield readTalerErrorResponse(resp);
    return { type: "fail", case: s5, detail };
  });
}
function opUnknownFailure(resp, text) {
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, {
    requestUrl: resp.requestUrl,
    requestMethod: resp.requestMethod,
    httpStatusCode: resp.status,
    errorResponse: text
  }, `Unexpected HTTP status ${resp.status} in response`);
}

// ../taler-util/lib/http-client/types.js
var codecForAccessToken = codecForString;
var codecForTokenSuccessResponse = () => buildCodecForObject().property("access_token", codecForAccessToken()).property("expiration", codecForTimestamp).build("TalerAuthentication.TokenSuccessResponse");
var codecForCurrencySpecificiation = () => buildCodecForObject().property("name", codecForString()).property("num_fractional_input_digits", codecForNumber()).property("num_fractional_normal_digits", codecForNumber()).property("num_fractional_trailing_zero_digits", codecForNumber()).property("alt_unit_names", codecForMap(codecForString())).build("CurrencySpecification");
var codecForIntegrationBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-bank-integration")).property("version", codecForString()).property("currency", codecForString()).build("TalerCorebankApi.IntegrationConfig");
var codecForCoreBankConfig = () => buildCodecForObject().property("name", codecForConstString("libeufin-bank")).property("version", codecForString()).property("allow_conversion", codecForBoolean()).property("allow_deletions", codecForBoolean()).property("allow_registrations", codecForBoolean()).property("currency_specification", codecForCurrencySpecificiation()).property("currency", codecForString()).build("TalerCorebankApi.Config");
var codecForBalance = () => buildCodecForObject().property("amount", codecForAmountString()).property("credit_debit_indicator", codecForEither(codecForConstString("credit"), codecForConstString("debit"))).build("TalerCorebankApi.Balance");
var codecForPublicAccount = () => buildCodecForObject().property("account_name", codecForString()).property("balance", codecForBalance()).property("payto_uri", codecForPaytoString()).build("TalerCorebankApi.PublicAccount");
var codecForPublicAccountsResponse = () => buildCodecForObject().property("public_accounts", codecForList(codecForPublicAccount())).build("TalerCorebankApi.PublicAccountsResponse");
var codecForAccountMinimalData = () => buildCodecForObject().property("balance", codecForBalance()).property("debit_threshold", codecForAmountString()).property("name", codecForString()).property("username", codecForString()).build("TalerCorebankApi.AccountMinimalData");
var codecForListBankAccountsResponse = () => buildCodecForObject().property("accounts", codecForList(codecForAccountMinimalData())).build("TalerCorebankApi.ListBankAccountsResponse");
var codecForAccountData = () => buildCodecForObject().property("name", codecForString()).property("balance", codecForBalance()).property("payto_uri", codecForPaytoString()).property("debit_threshold", codecForAmountString()).property("contact_data", codecOptional(codecForChallengeContactData())).property("cashout_payto_uri", codecOptional(codecForPaytoString())).build("TalerCorebankApi.AccountData");
var codecForChallengeContactData = () => buildCodecForObject().property("email", codecOptional(codecForString())).property("phone", codecOptional(codecForString())).build("TalerCorebankApi.ChallengeContactData");
var codecForBankAccountTransactionsResponse = () => buildCodecForObject().property("transactions", codecForList(codecForBankAccountTransactionInfo())).build("TalerCorebankApi.BankAccountTransactionsResponse");
var codecForBankAccountTransactionInfo = () => buildCodecForObject().property("creditor_payto_uri", codecForPaytoString()).property("debtor_payto_uri", codecForPaytoString()).property("amount", codecForAmountString()).property("direction", codecForEither(codecForConstString("debit"), codecForConstString("credit"))).property("subject", codecForString()).property("row_id", codecForNumber()).property("date", codecForTimestamp).build("TalerCorebankApi.BankAccountTransactionInfo");
var codecForBankAccountCreateWithdrawalResponse = () => buildCodecForObject().property("taler_withdraw_uri", codecForTalerActionString()).property("withdrawal_id", codecForString()).build("TalerCorebankApi.BankAccountCreateWithdrawalResponse");
var codecForBankAccountGetWithdrawalResponse = () => buildCodecForObject().property("amount", codecForAmountString()).property("aborted", codecForBoolean()).property("confirmation_done", codecForBoolean()).property("selected_exchange_account", codecOptional(codecForPaytoString())).property("selected_reserve_pub", codecOptional(codecForString())).property("selection_done", codecForBoolean()).build("TalerCorebankApi.BankAccountGetWithdrawalResponse");
var codecForCashoutPending = () => buildCodecForObject().property("cashout_id", codecForNumber()).build("TalerCorebankApi.CashoutPending");
var codecForCashoutConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashoutConversionResponse");
var codecForCashinConversionResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).build("TalerCorebankApi.CashinConversionResponse");
var codecForCashouts = () => buildCodecForObject().property("cashouts", codecForList(codecForCashoutInfo())).build("TalerCorebankApi.Cashouts");
var codecForCashoutInfo = () => buildCodecForObject().property("cashout_id", codecForNumber()).property("status", codecForEither(codecForConstString("pending"), codecForConstString("aborted"), codecForConstString("confirmed"))).build("TalerCorebankApi.CashoutInfo");
var codecForGlobalCashouts = () => buildCodecForObject().property("cashouts", codecForList(codecForGlobalCashoutInfo())).build("TalerCorebankApi.GlobalCashouts");
var codecForGlobalCashoutInfo = () => buildCodecForObject().property("cashout_id", codecForNumber()).property("username", codecForString()).property("status", codecForEither(codecForConstString("pending"), codecForConstString("aborted"), codecForConstString("confirmed"))).build("TalerCorebankApi.GlobalCashoutInfo");
var codecForCashoutStatusResponse = () => buildCodecForObject().property("amount_credit", codecForAmountString()).property("amount_debit", codecForAmountString()).property("confirmation_time", codecOptional(codecForTimestamp)).property("creation_time", codecForTimestamp).property("status", codecForEither(codecForConstString("pending"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("subject", codecForString()).build("TalerCorebankApi.CashoutStatusResponse");
var codecForMonitorResponse = () => buildCodecForUnion().discriminateOn("type").alternative("no-conversions", codecForMonitorNoConversion()).alternative("with-conversions", codecForMonitorWithCashout()).build("TalerWireGatewayApi.IncomingBankTransaction");
var codecForMonitorNoConversion = () => buildCodecForObject().property("type", codecForConstString("no-conversions")).property("talerInCount", codecForNumber()).property("talerInVolume", codecForAmountString()).property("talerOutCount", codecForNumber()).property("talerOutVolume", codecForAmountString()).build("TalerCorebankApi.MonitorJustPayouts");
var codecForMonitorWithCashout = () => buildCodecForObject().property("type", codecForConstString("with-conversions")).property("cashinCount", codecForNumber()).property("cashinFiatVolume", codecForAmountString()).property("cashinRegionalVolume", codecForAmountString()).property("cashoutCount", codecForNumber()).property("cashoutFiatVolume", codecForAmountString()).property("cashoutRegionalVolume", codecForAmountString()).property("talerInCount", codecForNumber()).property("talerInVolume", codecForAmountString()).property("talerOutCount", codecForNumber()).property("talerOutVolume", codecForAmountString()).build("TalerCorebankApi.MonitorWithCashout");
var codecForBankWithdrawalOperationStatus = () => buildCodecForObject().property("aborted", codecForBoolean()).property("selection_done", codecForBoolean()).property("transfer_done", codecForBoolean()).property("amount", codecForAmountString()).property("sender_wire", codecOptional(codecForPaytoString())).property("suggested_exchange", codecOptional(codecForString())).property("confirm_transfer_url", codecOptional(codecForURL())).property("wire_types", codecForList(codecForString())).build("TalerBankIntegrationApi.BankWithdrawalOperationStatus");
var codecForBankWithdrawalOperationPostResponse = () => buildCodecForObject().property("confirm_transfer_url", codecOptional(codecForURL())).property("transfer_done", codecForBoolean()).build("TalerBankIntegrationApi.BankWithdrawalOperationPostResponse");
var codecForMerchantIncomingHistory = () => buildCodecForObject().property("credit_account", codecForPaytoString()).property("incoming_transactions", codecForList(codecForMerchantIncomingBankTransaction())).build("TalerRevenueApi.MerchantIncomingHistory");
var codecForMerchantIncomingBankTransaction = () => buildCodecForObject().property("row_id", codecForNumber()).property("date", codecForTimestamp).property("amount", codecForAmountString()).property("debit_account", codecForPaytoString()).property("exchange_url", codecForURL()).property("wtid", codecForString()).build("TalerRevenueApi.MerchantIncomingBankTransaction");
var codecForTransferResponse = () => buildCodecForObject().property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.TransferResponse");
var codecForIncomingHistory = () => buildCodecForObject().property("credit_account", codecForPaytoString()).property("incoming_transactions", codecForList(codecForIncomingBankTransaction())).build("TalerWireGatewayApi.IncomingHistory");
var codecForIncomingBankTransaction = () => buildCodecForUnion().discriminateOn("type").alternative("RESERVE", codecForIncomingReserveTransaction()).alternative("WAD", codecForIncomingWadTransaction()).build("TalerWireGatewayApi.IncomingBankTransaction");
var codecForIncomingReserveTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("reserve_pub", codecForString()).property("row_id", codecForNumber()).property("type", codecForConstString("RESERVE")).build("TalerWireGatewayApi.IncomingReserveTransaction");
var codecForIncomingWadTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("credit_account", codecForPaytoString()).property("date", codecForTimestamp).property("debit_account", codecForPaytoString()).property("origin_exchange_url", codecForURL()).property("row_id", codecForNumber()).property("type", codecForConstString("WAD")).property("wad_id", codecForString()).build("TalerWireGatewayApi.IncomingWadTransaction");
var codecForOutgoingHistory = () => buildCodecForObject().property("debit_account", codecForPaytoString()).property("outgoing_transactions", codecForList(codecForOutgoingBankTransaction())).build("TalerWireGatewayApi.OutgoingHistory");
var codecForOutgoingBankTransaction = () => buildCodecForObject().property("amount", codecForAmountString()).property("credit_account", codecForPaytoString()).property("date", codecForTimestamp).property("exchange_base_url", codecForURL()).property("row_id", codecForNumber()).property("wtid", codecForString()).build("TalerWireGatewayApi.OutgoingBankTransaction");
var codecForAddIncomingResponse = () => buildCodecForObject().property("row_id", codecForNumber()).property("timestamp", codecForTimestamp).build("TalerWireGatewayApi.AddIncomingResponse");
var codecForConversionInfo = () => buildCodecForObject().property("cashin_fee", codecForAmountString()).property("cashin_min_amount", codecForAmountString()).property("cashin_ratio", codecForDecimalNumber()).property("cashin_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashin_tiny_amount", codecForAmountString()).property("cashout_fee", codecForAmountString()).property("cashout_min_amount", codecForAmountString()).property("cashout_ratio", codecForDecimalNumber()).property("cashout_rounding_mode", codecForEither(codecForConstString("zero"), codecForConstString("up"), codecForConstString("nearest"))).property("cashout_tiny_amount", codecForAmountString()).build("ConversionBankConfig.ConversionInfo");
var codecForConversionBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-conversion-info")).property("version", codecForString()).property("regional_currency", codecForString()).property("regional_currency_specification", codecForCurrencySpecificiation()).property("fiat_currency", codecForString()).property("fiat_currency_specification", codecForCurrencySpecificiation()).property("conversion_rate", codecOptional(codecForConversionInfo())).build("ConversionBankConfig.IntegrationConfig");
var codecForURL = codecForString;
var codecForDecimalNumber = codecForString;
var TanChannel;
(function(TanChannel3) {
  TanChannel3["SMS"] = "sms";
  TanChannel3["EMAIL"] = "email";
})(TanChannel || (TanChannel = {}));
var TalerCorebankApi;
(function(TalerCorebankApi6) {
  let MonitorTimeframeParam;
  (function(MonitorTimeframeParam2) {
    MonitorTimeframeParam2[MonitorTimeframeParam2["hour"] = 0] = "hour";
    MonitorTimeframeParam2[MonitorTimeframeParam2["day"] = 1] = "day";
    MonitorTimeframeParam2[MonitorTimeframeParam2["month"] = 2] = "month";
    MonitorTimeframeParam2[MonitorTimeframeParam2["year"] = 3] = "year";
    MonitorTimeframeParam2[MonitorTimeframeParam2["decade"] = 4] = "decade";
  })(MonitorTimeframeParam = TalerCorebankApi6.MonitorTimeframeParam || (TalerCorebankApi6.MonitorTimeframeParam = {}));
})(TalerCorebankApi || (TalerCorebankApi = {}));
var TalerExchangeApi;
(function(TalerExchangeApi2) {
  let AmlState;
  (function(AmlState2) {
    AmlState2[AmlState2["normal"] = 0] = "normal";
    AmlState2[AmlState2["pending"] = 1] = "pending";
    AmlState2[AmlState2["frozen"] = 2] = "frozen";
  })(AmlState = TalerExchangeApi2.AmlState || (TalerExchangeApi2.AmlState = {}));
})(TalerExchangeApi || (TalerExchangeApi = {}));

// ../taler-util/lib/http-client/utils.js
function makeBearerTokenAuthHeader(token) {
  return `Bearer secret-token:${token}`;
}
function addPaginationParams(url, pagination) {
  if (!pagination)
    return;
  if (pagination.timoutMs) {
    url.searchParams.set("long_poll_ms", String(pagination.timoutMs));
  }
  if (pagination.offset) {
    url.searchParams.set("start", pagination.offset);
  }
  const order = !pagination || pagination.order === "asc" ? 1 : -1;
  const limit = !pagination || !pagination.limit || pagination.limit === 0 ? 5 : Math.abs(pagination.limit);
  url.searchParams.set("delta", String(order * limit));
}

// ../taler-util/lib/http-client/authentication.js
var TalerAuthenticationHttpClient = class {
  constructor(baseUrl, username, httpClient) {
    this.baseUrl = baseUrl;
    this.username = username;
    this.PROTOCOL_VERSION = "0:0:0";
    this.httpLib = httpClient != null ? httpClient : createPlatformHttpLib();
  }
  isCompatible(version) {
    var _a;
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return (_a = compare2 == null ? void 0 : compare2.compatible) != null ? _a : false;
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-token
   *
   * @returns
   */
  createAccessToken(password, body) {
    return __async(this, null, function* () {
      const url = new URL(`token`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBasicAuthHeader(this.username, password)
        },
        body
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForTokenSuccessResponse());
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("wrong-credentials", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  deleteAccessToken(token) {
    return __async(this, null, function* () {
      const url = new URL(`token`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "DELETE",
        headers: {
          Authorization: makeBearerTokenAuthHeader(token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opEmptySuccess();
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
};

// ../taler-util/lib/http-client/bank-integration.js
var TalerBankIntegrationHttpClient = class {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient != null ? httpClient : createPlatformHttpLib();
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get--config
   *
   */
  getConfig() {
    return __async(this, null, function* () {
      const url = new URL(`config`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET"
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForIntegrationBankConfig());
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   *
   */
  getWithdrawalOperationById(woid, timeoutMs) {
    return __async(this, null, function* () {
      const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
      if (timeoutMs) {
        url.searchParams.set("long_poll_ms", String(timeoutMs));
      }
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET"
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForBankWithdrawalOperationStatus());
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#post-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   *
   */
  completeWithdrawalOperationById(woid, body) {
    return __async(this, null, function* () {
      const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        body
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForBankWithdrawalOperationPostResponse());
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict: {
          const body2 = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body2);
          switch (details.code) {
            case TalerErrorCode.BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT:
              return opKnownFailure("already-selected", resp);
            case TalerErrorCode.BANK_DUPLICATE_RESERVE_PUB_SUBJECT:
              return opKnownFailure("duplicated-reserve-id", resp);
            case TalerErrorCode.BANK_ACCOUNT_IS_NOT_EXCHANGE:
              return opKnownFailure("account-not-exchange", resp);
            default:
              return opUnknownFailure(resp, body2);
          }
        }
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
};

// ../taler-util/lib/http-client/bank-revenue.js
var TalerRevenueHttpClient = class {
  constructor(baseUrl, username, httpClient) {
    this.baseUrl = baseUrl;
    this.username = username;
    this.httpLib = httpClient != null ? httpClient : createPlatformHttpLib();
  }
  /**
   * https://docs.taler.net/core/api-bank-revenue.html#get-$BASE_URL-history
   *
   * @returns
   */
  getHistory(auth, pagination) {
    return __async(this, null, function* () {
      const url = new URL(`history`, this.baseUrl);
      addPaginationParams(url, pagination);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBasicAuthHeader(this.username, auth)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForMerchantIncomingHistory());
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-input", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("endpoint-wrong-or-username-wrong", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
};

// ../taler-util/lib/http-client/bank-wire.js
var TalerWireGatewayHttpClient = class {
  constructor(baseUrl, username, httpClient) {
    this.baseUrl = baseUrl;
    this.username = username;
    this.httpLib = httpClient != null ? httpClient : createPlatformHttpLib();
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post-$BASE_URL-transfer
   *
   */
  transfer(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`transfer`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBasicAuthHeader(this.username, auth)
        },
        body
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForTransferResponse());
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-input", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict:
          return opKnownFailure("request-uid-already-used", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get-$BASE_URL-history-incoming
   *
   */
  getHistoryIncoming(auth, pagination) {
    return __async(this, null, function* () {
      const url = new URL(`history/incoming`, this.baseUrl);
      addPaginationParams(url, pagination);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBasicAuthHeader(this.username, auth)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForIncomingHistory());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ incoming_transactions: [], credit_account: "" });
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-input", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#get-$BASE_URL-history-outgoing
   *
   */
  getHistoryOutgoing(auth, pagination) {
    return __async(this, null, function* () {
      const url = new URL(`history/outgoing`, this.baseUrl);
      addPaginationParams(url, pagination);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBasicAuthHeader(this.username, auth)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForOutgoingHistory());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ outgoing_transactions: [], debit_account: "" });
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-input", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-bank-wire.html#post-$BASE_URL-admin-add-incoming
   *
   */
  addIncoming(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`admin/add-incoming`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBasicAuthHeader(this.username, auth)
        },
        body
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForAddIncomingResponse());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ outgoing_transactions: [], debit_account: "" });
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-input", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict:
          return opKnownFailure("reserve-id-already-used", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
};

// ../taler-util/lib/http-client/bank-conversion.js
var TalerBankConversionHttpClient = class {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.httpLib = httpClient != null ? httpClient : createPlatformHttpLib();
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--config
   *
   */
  getConfig() {
    return __async(this, null, function* () {
      const url = new URL(`config`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET"
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForConversionBankConfig());
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--cashin-rate
   *
   */
  getCashinRate(conversion) {
    return __async(this, null, function* () {
      const url = new URL(`cashin-rate`, this.baseUrl);
      if (conversion.debit) {
        url.searchParams.set("amount_debit", Amounts.stringify(conversion.debit));
      }
      if (conversion.credit) {
        url.searchParams.set("amount_credit", Amounts.stringify(conversion.credit));
      }
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET"
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForCashinConversionResponse());
        case HttpStatusCode.BadRequest: {
          const body = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body);
          switch (details.code) {
            case TalerErrorCode.GENERIC_PARAMETER_MISSING:
              return opKnownFailure("missing-params", resp);
            case TalerErrorCode.GENERIC_PARAMETER_MALFORMED:
              return opKnownFailure("wrong-calculation", resp);
            case TalerErrorCode.GENERIC_CURRENCY_MISMATCH:
              return opKnownFailure("wrong-currency", resp);
            default:
              return opUnknownFailure(resp, body);
          }
        }
        case HttpStatusCode.Conflict:
          return opKnownFailure("amount-too-small", resp);
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-bank-conversion-info.html#get--cashout-rate
   *
   */
  getCashoutRate(conversion) {
    return __async(this, null, function* () {
      const url = new URL(`cashout-rate`, this.baseUrl);
      if (conversion.debit) {
        url.searchParams.set("amount_debit", Amounts.stringify(conversion.debit));
      }
      if (conversion.credit) {
        url.searchParams.set("amount_credit", Amounts.stringify(conversion.credit));
      }
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET"
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForCashoutConversionResponse());
        case HttpStatusCode.BadRequest: {
          const body = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body);
          switch (details.code) {
            case TalerErrorCode.GENERIC_PARAMETER_MISSING:
              return opKnownFailure("missing-params", resp);
            case TalerErrorCode.GENERIC_PARAMETER_MALFORMED:
              return opKnownFailure("wrong-calculation", resp);
            case TalerErrorCode.GENERIC_CURRENCY_MISMATCH:
              return opKnownFailure("wrong-currency", resp);
            default:
              return opUnknownFailure(resp, body);
          }
        }
        case HttpStatusCode.Conflict:
          return opKnownFailure("amount-too-small", resp);
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
};

// ../taler-util/lib/http-client/bank-core.js
var TalerCoreBankHttpClient = class {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.PROTOCOL_VERSION = "0:0:0";
    this.httpLib = httpClient != null ? httpClient : createPlatformHttpLib();
  }
  isCompatible(version) {
    var _a;
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return (_a = compare2 == null ? void 0 : compare2.compatible) != null ? _a : false;
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME
   *
   */
  getConfig() {
    return __async(this, null, function* () {
      const url = new URL(`config`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET"
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForCoreBankConfig());
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  //
  // ACCOUNTS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts
   *
   */
  createAccount(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`accounts`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        body,
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Created:
          return opEmptySuccess();
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-phone-or-email", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.Conflict: {
          const body2 = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body2);
          switch (details.code) {
            case TalerErrorCode.BANK_REGISTER_USERNAME_REUSE:
              return opKnownFailure("username-already-exists", resp);
            case TalerErrorCode.BANK_REGISTER_PAYTO_URI_REUSE:
              return opKnownFailure("payto-already-exists", resp);
            case TalerErrorCode.BANK_UNALLOWED_DEBIT:
              return opKnownFailure("insufficient-funds", resp);
            case TalerErrorCode.BANK_RESERVED_USERNAME_CONFLICT:
              return opKnownFailure("username-reserved", resp);
            default:
              return opUnknownFailure(resp, body2);
          }
        }
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#delete--accounts-$USERNAME
   *
   */
  deleteAccount(auth) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "DELETE",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.Conflict: {
          const body = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body);
          switch (details.code) {
            case TalerErrorCode.BANK_RESERVED_USERNAME_CONFLICT:
              return opKnownFailure("username-reserved", resp);
            case TalerErrorCode.BANK_ACCOUNT_BALANCE_NOT_ZERO:
              return opKnownFailure("balance-not-zero", resp);
            default:
              return opUnknownFailure(resp, body);
          }
        }
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--accounts-$USERNAME
   *
   */
  updateAccount(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "PATCH",
        body,
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.Forbidden:
          return opKnownFailure("cant-change-legal-name-or-admin", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#patch--accounts-$USERNAME-auth
   *
   */
  updatePassword(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/auth`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "PATCH",
        body,
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.Forbidden:
          return opKnownFailure("old-password-invalid-or-not-allowed", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/get-$BANK_API_BASE_URL-public-accounts
   *
   */
  getPublicAccounts(pagination) {
    return __async(this, null, function* () {
      const url = new URL(`public-accounts`, this.baseUrl);
      addPaginationParams(url, pagination);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {}
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForPublicAccountsResponse());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ public_accounts: [] });
        case HttpStatusCode.NotFound:
          return opFixedSuccess({ public_accounts: [] });
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts
   *
   */
  getAccounts(_0) {
    return __async(this, arguments, function* (auth, filter = {}, pagination) {
      const url = new URL(`accounts`, this.baseUrl);
      addPaginationParams(url, pagination);
      if (filter.account) {
        url.searchParams.set("filter_name", filter.account);
      }
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForListBankAccountsResponse());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ accounts: [] });
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME
   *
   */
  getAccount(auth) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForAccountData());
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  //
  // TRANSACTIONS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#get-$BANK_API_BASE_URL-accounts-$account_name-transactions
   *
   */
  getTransactions(auth, pagination) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/transactions`, this.baseUrl);
      addPaginationParams(url, pagination);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForBankAccountTransactionsResponse());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ transactions: [] });
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get-$BANK_API_BASE_URL-accounts-$account_name-transactions-$transaction_id
   *
   */
  getTransactionById(auth, txid) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/transactions/${String(txid)}`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForBankAccountTransactionInfo());
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post-$BANK_API_BASE_URL-accounts-$account_name-transactions
   *
   */
  createTransaction(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/transactions`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        },
        body
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-input", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict: {
          const body2 = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body2);
          switch (details.code) {
            case TalerErrorCode.BANK_SAME_ACCOUNT:
              return opKnownFailure("creditor-same", resp);
            case TalerErrorCode.BANK_UNKNOWN_CREDITOR:
              return opKnownFailure("creditor-not-found", resp);
            case TalerErrorCode.BANK_UNALLOWED_DEBIT:
              return opKnownFailure("insufficient-funds", resp);
            default:
              return opUnknownFailure(resp, body2);
          }
        }
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  //
  // WITHDRAWALS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post-$BANK_API_BASE_URL-accounts-$account_name-withdrawals
   *
   */
  createWithdrawal(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/withdrawals`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        },
        body
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForBankAccountCreateWithdrawalResponse());
        case HttpStatusCode.NotFound:
          return opKnownFailure("account-not-found", resp);
        case HttpStatusCode.Conflict:
          return opKnownFailure("insufficient-funds", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post-$BANK_API_BASE_URL-withdrawals-$withdrawal_id-abort
   *
   */
  abortWithdrawalById(wid) {
    return __async(this, null, function* () {
      const url = new URL(`withdrawals/${wid}/abort`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST"
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-id", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict:
          return opKnownFailure("previously-confirmed", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post-$BANK_API_BASE_URL-withdrawals-$withdrawal_id-confirm
   *
   */
  confirmWithdrawalById(wid) {
    return __async(this, null, function* () {
      const url = new URL(`withdrawals/${wid}/confirm`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST"
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-id", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict: {
          const body = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body);
          switch (details.code) {
            case TalerErrorCode.BANK_UNALLOWED_DEBIT:
              return opKnownFailure("insufficient-funds", resp);
            case TalerErrorCode.BANK_CONFIRM_INCOMPLETE:
              return opKnownFailure("no-exchange-or-reserve-selected", resp);
            case TalerErrorCode.BANK_CONFIRM_ABORT_CONFLICT:
              return opKnownFailure("previously-aborted", resp);
            default:
              return opUnknownFailure(resp, body);
          }
        }
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post-$BANK_API_BASE_URL-accounts-$account_name-withdrawals
   *
   */
  getWithdrawalById(wid) {
    return __async(this, null, function* () {
      const url = new URL(`withdrawals/${wid}`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET"
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForBankAccountGetWithdrawalResponse());
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-id", resp);
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  //
  // CASHOUTS
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-cashouts
   *
   */
  createCashout(auth, body) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/cashouts`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        },
        body
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForCashoutPending());
        case HttpStatusCode.NotFound:
          return opKnownFailure("account-not-found", resp);
        case HttpStatusCode.Conflict: {
          const body2 = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body2);
          switch (details.code) {
            case TalerErrorCode.BANK_TRANSFER_REQUEST_UID_REUSED:
              return opKnownFailure("request-already-used", resp);
            case TalerErrorCode.BANK_BAD_CONVERSION:
              return opKnownFailure("incorrect-exchange-rate", resp);
            case TalerErrorCode.BANK_MISSING_TAN_INFO:
              return opKnownFailure("no-contact-info", resp);
            case TalerErrorCode.BANK_UNALLOWED_DEBIT:
              return opKnownFailure("no-enough-balance", resp);
            default:
              return opUnknownFailure(resp, body2);
          }
        }
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        case HttpStatusCode.BadGateway:
          return opKnownFailure("tan-failed", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-cashouts-$CASHOUT_ID-abort
   *
   */
  abortCashoutById(auth, cid) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/cashouts/${cid}/abort`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict:
          return opKnownFailure("already-confirmed", resp);
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-cashouts-$CASHOUT_ID-confirm
   *
   */
  confirmCashoutById(auth, cid, body) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/cashouts/${cid}/confirm`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "POST",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        },
        body
      });
      switch (resp.status) {
        case HttpStatusCode.NoContent:
          return opEmptySuccess();
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.Conflict: {
          const body2 = yield resp.json();
          const details = codecForTalerErrorDetail().decode(body2);
          switch (details.code) {
            case TalerErrorCode.BANK_CONFIRM_ABORT_CONFLICT:
              return opKnownFailure("already-aborted", resp);
            case TalerErrorCode.BANK_CONFIRM_INCOMPLETE:
              return opKnownFailure("no-cashout-payto", resp);
            case TalerErrorCode.BANK_UNALLOWED_DEBIT:
              return opKnownFailure("no-enough-balance", resp);
            case TalerErrorCode.BANK_BAD_CONVERSION:
              return opKnownFailure("incorrect-exchange-rate", resp);
            case TalerErrorCode.BANK_TAN_CHALLENGE_FAILED:
              return opKnownFailure("invalid-code", resp);
            default:
              return opUnknownFailure(resp, body2);
          }
        }
        case HttpStatusCode.TooManyRequests:
          return opKnownFailure("too-many-attempts", resp);
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts-$CASHOUT_ID
   *
   */
  getCashoutById(auth, cid) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/cashouts/${cid}`, this.baseUrl);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForCashoutStatusResponse());
        case HttpStatusCode.NotFound:
          return opKnownFailure("not-found", resp);
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--accounts-$USERNAME-cashouts
   *
   */
  getAccountCashouts(auth, pagination) {
    return __async(this, null, function* () {
      const url = new URL(`accounts/${auth.username}/cashouts`, this.baseUrl);
      addPaginationParams(url, pagination);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth.token)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForCashouts());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ cashouts: [] });
        case HttpStatusCode.NotFound:
          return opKnownFailure("account-not-found", resp);
          ;
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#get--cashouts
   *
   */
  getGlobalCashouts(auth, pagination) {
    return __async(this, null, function* () {
      const url = new URL(`cashouts`, this.baseUrl);
      addPaginationParams(url, pagination);
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForGlobalCashouts());
        case HttpStatusCode.NoContent:
          return opFixedSuccess({ cashouts: [] });
        case HttpStatusCode.NotImplemented:
          return opKnownFailure("cashout-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  //
  // MONITOR
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#get--monitor
   *
   */
  getMonitor(_0) {
    return __async(this, arguments, function* (auth, params = {}) {
      const url = new URL(`monitor`, this.baseUrl);
      if (params.timeframe) {
        url.searchParams.set("timeframe", TalerCorebankApi.MonitorTimeframeParam[params.timeframe]);
      }
      if (params.which) {
        url.searchParams.set("which", String(params.which));
      }
      const resp = yield this.httpLib.fetch(url.href, {
        method: "GET",
        headers: {
          Authorization: makeBearerTokenAuthHeader(auth)
        }
      });
      switch (resp.status) {
        case HttpStatusCode.Ok:
          return opSuccess(resp, codecForMonitorResponse());
        case HttpStatusCode.BadRequest:
          return opKnownFailure("invalid-input", resp);
        case HttpStatusCode.Unauthorized:
          return opKnownFailure("unauthorized", resp);
        case HttpStatusCode.ServiceUnavailable:
          return opKnownFailure("monitor-not-supported", resp);
        default:
          return opUnknownFailure(resp, yield resp.text());
      }
    });
  }
  //
  // Others API
  //
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getIntegrationAPI() {
    const url = new URL(`taler-integration/`, this.baseUrl);
    return new TalerBankIntegrationHttpClient(url.href, this.httpLib);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
   *
   */
  getWireGatewayAPI(username) {
    const url = new URL(`accounts/${username}/taler-wire-gateway/`, this.baseUrl);
    return new TalerWireGatewayHttpClient(url.href, username, this.httpLib);
  }
  /**
  * https://docs.taler.net/core/api-corebank.html#taler-bank-integration-api
  *
  */
  getRevenueAPI(username) {
    const url = new URL(`accounts/${username}/taler-revenue/`, this.baseUrl);
    return new TalerRevenueHttpClient(url.href, username, this.httpLib);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-token
  *
  */
  getAuthenticationAPI(username) {
    const url = new URL(`accounts/${username}/`, this.baseUrl);
    return new TalerAuthenticationHttpClient(url.href, username, this.httpLib);
  }
  /**
   * https://docs.taler.net/core/api-corebank.html#post--accounts-$USERNAME-token
  *
  */
  getConversionInfoAPI() {
    const url = new URL(`conversion-info/`, this.baseUrl);
    return new TalerBankConversionHttpClient(url.href, this.httpLib);
  }
};

// ../taler-util/lib/index.browser.js
loadBrowserPrng();

// ../web-util/lib/index.browser.mjs
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_compat_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
var __create2 = Object.create;
var __defProp2 = Object.defineProperty;
var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
var __getOwnPropNames2 = Object.getOwnPropertyNames;
var __getProtoOf2 = Object.getPrototypeOf;
var __hasOwnProp2 = Object.prototype.hasOwnProperty;
var __commonJS2 = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames2(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export2 = (target, all) => {
  for (var name in all)
    __defProp2(target, name, { get: all[name], enumerable: true });
};
var __copyProps2 = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames2(from))
      if (!__hasOwnProp2.call(to, key) && key !== except)
        __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create2(__getProtoOf2(mod)) : {}, __copyProps2(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var require_react_development = __commonJS2({
  "../../node_modules/.pnpm/react@18.2.0/node_modules/react/cjs/react.development.js"(exports, module) {
    "use strict";
    if (true) {
      (function() {
        "use strict";
        if (typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ !== "undefined" && typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStart === "function") {
          __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStart(new Error());
        }
        var ReactVersion = "18.2.0";
        var REACT_ELEMENT_TYPE = Symbol.for("react.element");
        var REACT_PORTAL_TYPE = Symbol.for("react.portal");
        var REACT_FRAGMENT_TYPE = Symbol.for("react.fragment");
        var REACT_STRICT_MODE_TYPE = Symbol.for("react.strict_mode");
        var REACT_PROFILER_TYPE = Symbol.for("react.profiler");
        var REACT_PROVIDER_TYPE = Symbol.for("react.provider");
        var REACT_CONTEXT_TYPE = Symbol.for("react.context");
        var REACT_FORWARD_REF_TYPE = Symbol.for("react.forward_ref");
        var REACT_SUSPENSE_TYPE = Symbol.for("react.suspense");
        var REACT_SUSPENSE_LIST_TYPE = Symbol.for("react.suspense_list");
        var REACT_MEMO_TYPE = Symbol.for("react.memo");
        var REACT_LAZY_TYPE = Symbol.for("react.lazy");
        var REACT_OFFSCREEN_TYPE = Symbol.for("react.offscreen");
        var MAYBE_ITERATOR_SYMBOL = Symbol.iterator;
        var FAUX_ITERATOR_SYMBOL = "@@iterator";
        function getIteratorFn(maybeIterable) {
          if (maybeIterable === null || typeof maybeIterable !== "object") {
            return null;
          }
          var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];
          if (typeof maybeIterator === "function") {
            return maybeIterator;
          }
          return null;
        }
        var ReactCurrentDispatcher = {
          /**
           * @internal
           * @type {ReactComponent}
           */
          current: null
        };
        var ReactCurrentBatchConfig = {
          transition: null
        };
        var ReactCurrentActQueue = {
          current: null,
          // Used to reproduce behavior of `batchedUpdates` in legacy mode.
          isBatchingLegacy: false,
          didScheduleLegacyUpdate: false
        };
        var ReactCurrentOwner = {
          /**
           * @internal
           * @type {ReactComponent}
           */
          current: null
        };
        var ReactDebugCurrentFrame = {};
        var currentExtraStackFrame = null;
        function setExtraStackFrame(stack) {
          {
            currentExtraStackFrame = stack;
          }
        }
        {
          ReactDebugCurrentFrame.setExtraStackFrame = function(stack) {
            {
              currentExtraStackFrame = stack;
            }
          };
          ReactDebugCurrentFrame.getCurrentStack = null;
          ReactDebugCurrentFrame.getStackAddendum = function() {
            var stack = "";
            if (currentExtraStackFrame) {
              stack += currentExtraStackFrame;
            }
            var impl = ReactDebugCurrentFrame.getCurrentStack;
            if (impl) {
              stack += impl() || "";
            }
            return stack;
          };
        }
        var enableScopeAPI = false;
        var enableCacheElement = false;
        var enableTransitionTracing = false;
        var enableLegacyHidden = false;
        var enableDebugTracing = false;
        var ReactSharedInternals = {
          ReactCurrentDispatcher,
          ReactCurrentBatchConfig,
          ReactCurrentOwner
        };
        {
          ReactSharedInternals.ReactDebugCurrentFrame = ReactDebugCurrentFrame;
          ReactSharedInternals.ReactCurrentActQueue = ReactCurrentActQueue;
        }
        function warn(format2) {
          {
            {
              for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                args[_key - 1] = arguments[_key];
              }
              printWarning("warn", format2, args);
            }
          }
        }
        function error2(format2) {
          {
            {
              for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                args[_key2 - 1] = arguments[_key2];
              }
              printWarning("error", format2, args);
            }
          }
        }
        function printWarning(level, format2, args) {
          {
            var ReactDebugCurrentFrame2 = ReactSharedInternals.ReactDebugCurrentFrame;
            var stack = ReactDebugCurrentFrame2.getStackAddendum();
            if (stack !== "") {
              format2 += "%s";
              args = args.concat([stack]);
            }
            var argsWithFormat = args.map(function(item) {
              return String(item);
            });
            argsWithFormat.unshift("Warning: " + format2);
            Function.prototype.apply.call(console[level], console, argsWithFormat);
          }
        }
        var didWarnStateUpdateForUnmountedComponent = {};
        function warnNoop(publicInstance, callerName) {
          {
            var _constructor = publicInstance.constructor;
            var componentName = _constructor && (_constructor.displayName || _constructor.name) || "ReactClass";
            var warningKey = componentName + "." + callerName;
            if (didWarnStateUpdateForUnmountedComponent[warningKey]) {
              return;
            }
            error2("Can't call %s on a component that is not yet mounted. This is a no-op, but it might indicate a bug in your application. Instead, assign to `this.state` directly or define a `state = {};` class property with the desired state in the %s component.", callerName, componentName);
            didWarnStateUpdateForUnmountedComponent[warningKey] = true;
          }
        }
        var ReactNoopUpdateQueue = {
          /**
           * Checks whether or not this composite component is mounted.
           * @param {ReactClass} publicInstance The instance we want to test.
           * @return {boolean} True if mounted, false otherwise.
           * @protected
           * @final
           */
          isMounted: function(publicInstance) {
            return false;
          },
          /**
           * Forces an update. This should only be invoked when it is known with
           * certainty that we are **not** in a DOM transaction.
           *
           * You may want to call this when you know that some deeper aspect of the
           * component's state has changed but `setState` was not called.
           *
           * This will not invoke `shouldComponentUpdate`, but it will invoke
           * `componentWillUpdate` and `componentDidUpdate`.
           *
           * @param {ReactClass} publicInstance The instance that should rerender.
           * @param {?function} callback Called after component is updated.
           * @param {?string} callerName name of the calling function in the public API.
           * @internal
           */
          enqueueForceUpdate: function(publicInstance, callback, callerName) {
            warnNoop(publicInstance, "forceUpdate");
          },
          /**
           * Replaces all of the state. Always use this or `setState` to mutate state.
           * You should treat `this.state` as immutable.
           *
           * There is no guarantee that `this.state` will be immediately updated, so
           * accessing `this.state` after calling this method may return the old value.
           *
           * @param {ReactClass} publicInstance The instance that should rerender.
           * @param {object} completeState Next state.
           * @param {?function} callback Called after component is updated.
           * @param {?string} callerName name of the calling function in the public API.
           * @internal
           */
          enqueueReplaceState: function(publicInstance, completeState, callback, callerName) {
            warnNoop(publicInstance, "replaceState");
          },
          /**
           * Sets a subset of the state. This only exists because _pendingState is
           * internal. This provides a merging strategy that is not available to deep
           * properties which is confusing. TODO: Expose pendingState or don't use it
           * during the merge.
           *
           * @param {ReactClass} publicInstance The instance that should rerender.
           * @param {object} partialState Next partial state to be merged with state.
           * @param {?function} callback Called after component is updated.
           * @param {?string} Name of the calling function in the public API.
           * @internal
           */
          enqueueSetState: function(publicInstance, partialState, callback, callerName) {
            warnNoop(publicInstance, "setState");
          }
        };
        var assign2 = Object.assign;
        var emptyObject = {};
        {
          Object.freeze(emptyObject);
        }
        function Component(props, context, updater) {
          this.props = props;
          this.context = context;
          this.refs = emptyObject;
          this.updater = updater || ReactNoopUpdateQueue;
        }
        Component.prototype.isReactComponent = {};
        Component.prototype.setState = function(partialState, callback) {
          if (typeof partialState !== "object" && typeof partialState !== "function" && partialState != null) {
            throw new Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");
          }
          this.updater.enqueueSetState(this, partialState, callback, "setState");
        };
        Component.prototype.forceUpdate = function(callback) {
          this.updater.enqueueForceUpdate(this, callback, "forceUpdate");
        };
        {
          var deprecatedAPIs = {
            isMounted: ["isMounted", "Instead, make sure to clean up subscriptions and pending requests in componentWillUnmount to prevent memory leaks."],
            replaceState: ["replaceState", "Refactor your code to use setState instead (see https://github.com/facebook/react/issues/3236)."]
          };
          var defineDeprecationWarning = function(methodName, info) {
            Object.defineProperty(Component.prototype, methodName, {
              get: function() {
                warn("%s(...) is deprecated in plain JavaScript React classes. %s", info[0], info[1]);
                return void 0;
              }
            });
          };
          for (var fnName in deprecatedAPIs) {
            if (deprecatedAPIs.hasOwnProperty(fnName)) {
              defineDeprecationWarning(fnName, deprecatedAPIs[fnName]);
            }
          }
        }
        function ComponentDummy() {
        }
        ComponentDummy.prototype = Component.prototype;
        function PureComponent(props, context, updater) {
          this.props = props;
          this.context = context;
          this.refs = emptyObject;
          this.updater = updater || ReactNoopUpdateQueue;
        }
        var pureComponentPrototype = PureComponent.prototype = new ComponentDummy();
        pureComponentPrototype.constructor = PureComponent;
        assign2(pureComponentPrototype, Component.prototype);
        pureComponentPrototype.isPureReactComponent = true;
        function createRef() {
          var refObject = {
            current: null
          };
          {
            Object.seal(refObject);
          }
          return refObject;
        }
        var isArrayImpl = Array.isArray;
        function isArray(a32) {
          return isArrayImpl(a32);
        }
        function typeName(value) {
          {
            var hasToStringTag = typeof Symbol === "function" && Symbol.toStringTag;
            var type = hasToStringTag && value[Symbol.toStringTag] || value.constructor.name || "Object";
            return type;
          }
        }
        function willCoercionThrow(value) {
          {
            try {
              testStringCoercion(value);
              return false;
            } catch (e22) {
              return true;
            }
          }
        }
        function testStringCoercion(value) {
          return "" + value;
        }
        function checkKeyStringCoercion(value) {
          {
            if (willCoercionThrow(value)) {
              error2("The provided key is an unsupported type %s. This value must be coerced to a string before before using it here.", typeName(value));
              return testStringCoercion(value);
            }
          }
        }
        function getWrappedName(outerType, innerType, wrapperName) {
          var displayName = outerType.displayName;
          if (displayName) {
            return displayName;
          }
          var functionName = innerType.displayName || innerType.name || "";
          return functionName !== "" ? wrapperName + "(" + functionName + ")" : wrapperName;
        }
        function getContextName(type) {
          return type.displayName || "Context";
        }
        function getComponentNameFromType(type) {
          if (type == null) {
            return null;
          }
          {
            if (typeof type.tag === "number") {
              error2("Received an unexpected object in getComponentNameFromType(). This is likely a bug in React. Please file an issue.");
            }
          }
          if (typeof type === "function") {
            return type.displayName || type.name || null;
          }
          if (typeof type === "string") {
            return type;
          }
          switch (type) {
            case REACT_FRAGMENT_TYPE:
              return "Fragment";
            case REACT_PORTAL_TYPE:
              return "Portal";
            case REACT_PROFILER_TYPE:
              return "Profiler";
            case REACT_STRICT_MODE_TYPE:
              return "StrictMode";
            case REACT_SUSPENSE_TYPE:
              return "Suspense";
            case REACT_SUSPENSE_LIST_TYPE:
              return "SuspenseList";
          }
          if (typeof type === "object") {
            switch (type.$$typeof) {
              case REACT_CONTEXT_TYPE:
                var context = type;
                return getContextName(context) + ".Consumer";
              case REACT_PROVIDER_TYPE:
                var provider = type;
                return getContextName(provider._context) + ".Provider";
              case REACT_FORWARD_REF_TYPE:
                return getWrappedName(type, type.render, "ForwardRef");
              case REACT_MEMO_TYPE:
                var outerName = type.displayName || null;
                if (outerName !== null) {
                  return outerName;
                }
                return getComponentNameFromType(type.type) || "Memo";
              case REACT_LAZY_TYPE: {
                var lazyComponent = type;
                var payload = lazyComponent._payload;
                var init = lazyComponent._init;
                try {
                  return getComponentNameFromType(init(payload));
                } catch (x22) {
                  return null;
                }
              }
            }
          }
          return null;
        }
        var hasOwnProperty = Object.prototype.hasOwnProperty;
        var RESERVED_PROPS = {
          key: true,
          ref: true,
          __self: true,
          __source: true
        };
        var specialPropKeyWarningShown, specialPropRefWarningShown, didWarnAboutStringRefs;
        {
          didWarnAboutStringRefs = {};
        }
        function hasValidRef(config) {
          {
            if (hasOwnProperty.call(config, "ref")) {
              var getter = Object.getOwnPropertyDescriptor(config, "ref").get;
              if (getter && getter.isReactWarning) {
                return false;
              }
            }
          }
          return config.ref !== void 0;
        }
        function hasValidKey(config) {
          {
            if (hasOwnProperty.call(config, "key")) {
              var getter = Object.getOwnPropertyDescriptor(config, "key").get;
              if (getter && getter.isReactWarning) {
                return false;
              }
            }
          }
          return config.key !== void 0;
        }
        function defineKeyPropWarningGetter(props, displayName) {
          var warnAboutAccessingKey = function() {
            {
              if (!specialPropKeyWarningShown) {
                specialPropKeyWarningShown = true;
                error2("%s: `key` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", displayName);
              }
            }
          };
          warnAboutAccessingKey.isReactWarning = true;
          Object.defineProperty(props, "key", {
            get: warnAboutAccessingKey,
            configurable: true
          });
        }
        function defineRefPropWarningGetter(props, displayName) {
          var warnAboutAccessingRef = function() {
            {
              if (!specialPropRefWarningShown) {
                specialPropRefWarningShown = true;
                error2("%s: `ref` is not a prop. Trying to access it will result in `undefined` being returned. If you need to access the same value within the child component, you should pass it as a different prop. (https://reactjs.org/link/special-props)", displayName);
              }
            }
          };
          warnAboutAccessingRef.isReactWarning = true;
          Object.defineProperty(props, "ref", {
            get: warnAboutAccessingRef,
            configurable: true
          });
        }
        function warnIfStringRefCannotBeAutoConverted(config) {
          {
            if (typeof config.ref === "string" && ReactCurrentOwner.current && config.__self && ReactCurrentOwner.current.stateNode !== config.__self) {
              var componentName = getComponentNameFromType(ReactCurrentOwner.current.type);
              if (!didWarnAboutStringRefs[componentName]) {
                error2('Component "%s" contains the string ref "%s". Support for string refs will be removed in a future major release. This case cannot be automatically converted to an arrow function. We ask you to manually fix this case by using useRef() or createRef() instead. Learn more about using refs safely here: https://reactjs.org/link/strict-mode-string-ref', componentName, config.ref);
                didWarnAboutStringRefs[componentName] = true;
              }
            }
          }
        }
        var ReactElement = function(type, key, ref, self2, source, owner, props) {
          var element = {
            // This tag allows us to uniquely identify this as a React Element
            $$typeof: REACT_ELEMENT_TYPE,
            // Built-in properties that belong on the element
            type,
            key,
            ref,
            props,
            // Record the component responsible for creating this element.
            _owner: owner
          };
          {
            element._store = {};
            Object.defineProperty(element._store, "validated", {
              configurable: false,
              enumerable: false,
              writable: true,
              value: false
            });
            Object.defineProperty(element, "_self", {
              configurable: false,
              enumerable: false,
              writable: false,
              value: self2
            });
            Object.defineProperty(element, "_source", {
              configurable: false,
              enumerable: false,
              writable: false,
              value: source
            });
            if (Object.freeze) {
              Object.freeze(element.props);
              Object.freeze(element);
            }
          }
          return element;
        };
        function createElement2(type, config, children) {
          var propName;
          var props = {};
          var key = null;
          var ref = null;
          var self2 = null;
          var source = null;
          if (config != null) {
            if (hasValidRef(config)) {
              ref = config.ref;
              {
                warnIfStringRefCannotBeAutoConverted(config);
              }
            }
            if (hasValidKey(config)) {
              {
                checkKeyStringCoercion(config.key);
              }
              key = "" + config.key;
            }
            self2 = config.__self === void 0 ? null : config.__self;
            source = config.__source === void 0 ? null : config.__source;
            for (propName in config) {
              if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
                props[propName] = config[propName];
              }
            }
          }
          var childrenLength = arguments.length - 2;
          if (childrenLength === 1) {
            props.children = children;
          } else if (childrenLength > 1) {
            var childArray = Array(childrenLength);
            for (var i22 = 0; i22 < childrenLength; i22++) {
              childArray[i22] = arguments[i22 + 2];
            }
            {
              if (Object.freeze) {
                Object.freeze(childArray);
              }
            }
            props.children = childArray;
          }
          if (type && type.defaultProps) {
            var defaultProps = type.defaultProps;
            for (propName in defaultProps) {
              if (props[propName] === void 0) {
                props[propName] = defaultProps[propName];
              }
            }
          }
          {
            if (key || ref) {
              var displayName = typeof type === "function" ? type.displayName || type.name || "Unknown" : type;
              if (key) {
                defineKeyPropWarningGetter(props, displayName);
              }
              if (ref) {
                defineRefPropWarningGetter(props, displayName);
              }
            }
          }
          return ReactElement(type, key, ref, self2, source, ReactCurrentOwner.current, props);
        }
        function cloneAndReplaceKey(oldElement, newKey) {
          var newElement = ReactElement(oldElement.type, newKey, oldElement.ref, oldElement._self, oldElement._source, oldElement._owner, oldElement.props);
          return newElement;
        }
        function cloneElement(element, config, children) {
          if (element === null || element === void 0) {
            throw new Error("React.cloneElement(...): The argument must be a React element, but you passed " + element + ".");
          }
          var propName;
          var props = assign2({}, element.props);
          var key = element.key;
          var ref = element.ref;
          var self2 = element._self;
          var source = element._source;
          var owner = element._owner;
          if (config != null) {
            if (hasValidRef(config)) {
              ref = config.ref;
              owner = ReactCurrentOwner.current;
            }
            if (hasValidKey(config)) {
              {
                checkKeyStringCoercion(config.key);
              }
              key = "" + config.key;
            }
            var defaultProps;
            if (element.type && element.type.defaultProps) {
              defaultProps = element.type.defaultProps;
            }
            for (propName in config) {
              if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
                if (config[propName] === void 0 && defaultProps !== void 0) {
                  props[propName] = defaultProps[propName];
                } else {
                  props[propName] = config[propName];
                }
              }
            }
          }
          var childrenLength = arguments.length - 2;
          if (childrenLength === 1) {
            props.children = children;
          } else if (childrenLength > 1) {
            var childArray = Array(childrenLength);
            for (var i22 = 0; i22 < childrenLength; i22++) {
              childArray[i22] = arguments[i22 + 2];
            }
            props.children = childArray;
          }
          return ReactElement(element.type, key, ref, self2, source, owner, props);
        }
        function isValidElement(object) {
          return typeof object === "object" && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
        }
        var SEPARATOR = ".";
        var SUBSEPARATOR = ":";
        function escape(key) {
          var escapeRegex = /[=:]/g;
          var escaperLookup = {
            "=": "=0",
            ":": "=2"
          };
          var escapedString = key.replace(escapeRegex, function(match22) {
            return escaperLookup[match22];
          });
          return "$" + escapedString;
        }
        var didWarnAboutMaps = false;
        var userProvidedKeyEscapeRegex = /\/+/g;
        function escapeUserProvidedKey(text) {
          return text.replace(userProvidedKeyEscapeRegex, "$&/");
        }
        function getElementKey(element, index) {
          if (typeof element === "object" && element !== null && element.key != null) {
            {
              checkKeyStringCoercion(element.key);
            }
            return escape("" + element.key);
          }
          return index.toString(36);
        }
        function mapIntoArray(children, array, escapedPrefix, nameSoFar, callback) {
          var type = typeof children;
          if (type === "undefined" || type === "boolean") {
            children = null;
          }
          var invokeCallback = false;
          if (children === null) {
            invokeCallback = true;
          } else {
            switch (type) {
              case "string":
              case "number":
                invokeCallback = true;
                break;
              case "object":
                switch (children.$$typeof) {
                  case REACT_ELEMENT_TYPE:
                  case REACT_PORTAL_TYPE:
                    invokeCallback = true;
                }
            }
          }
          if (invokeCallback) {
            var _child = children;
            var mappedChild = callback(_child);
            var childKey = nameSoFar === "" ? SEPARATOR + getElementKey(_child, 0) : nameSoFar;
            if (isArray(mappedChild)) {
              var escapedChildKey = "";
              if (childKey != null) {
                escapedChildKey = escapeUserProvidedKey(childKey) + "/";
              }
              mapIntoArray(mappedChild, array, escapedChildKey, "", function(c22) {
                return c22;
              });
            } else if (mappedChild != null) {
              if (isValidElement(mappedChild)) {
                {
                  if (mappedChild.key && (!_child || _child.key !== mappedChild.key)) {
                    checkKeyStringCoercion(mappedChild.key);
                  }
                }
                mappedChild = cloneAndReplaceKey(
                  mappedChild,
                  // Keep both the (mapped) and old keys if they differ, just as
                  // traverseAllChildren used to do for objects as children
                  escapedPrefix + // $FlowFixMe Flow incorrectly thinks React.Portal doesn't have a key
                  (mappedChild.key && (!_child || _child.key !== mappedChild.key) ? (
                    // $FlowFixMe Flow incorrectly thinks existing element's key can be a number
                    // eslint-disable-next-line react-internal/safe-string-coercion
                    escapeUserProvidedKey("" + mappedChild.key) + "/"
                  ) : "") + childKey
                );
              }
              array.push(mappedChild);
            }
            return 1;
          }
          var child;
          var nextName;
          var subtreeCount = 0;
          var nextNamePrefix = nameSoFar === "" ? SEPARATOR : nameSoFar + SUBSEPARATOR;
          if (isArray(children)) {
            for (var i22 = 0; i22 < children.length; i22++) {
              child = children[i22];
              nextName = nextNamePrefix + getElementKey(child, i22);
              subtreeCount += mapIntoArray(child, array, escapedPrefix, nextName, callback);
            }
          } else {
            var iteratorFn = getIteratorFn(children);
            if (typeof iteratorFn === "function") {
              var iterableChildren = children;
              {
                if (iteratorFn === iterableChildren.entries) {
                  if (!didWarnAboutMaps) {
                    warn("Using Maps as children is not supported. Use an array of keyed ReactElements instead.");
                  }
                  didWarnAboutMaps = true;
                }
              }
              var iterator = iteratorFn.call(iterableChildren);
              var step;
              var ii = 0;
              while (!(step = iterator.next()).done) {
                child = step.value;
                nextName = nextNamePrefix + getElementKey(child, ii++);
                subtreeCount += mapIntoArray(child, array, escapedPrefix, nextName, callback);
              }
            } else if (type === "object") {
              var childrenString = String(children);
              throw new Error("Objects are not valid as a React child (found: " + (childrenString === "[object Object]" ? "object with keys {" + Object.keys(children).join(", ") + "}" : childrenString) + "). If you meant to render a collection of children, use an array instead.");
            }
          }
          return subtreeCount;
        }
        function mapChildren(children, func, context) {
          if (children == null) {
            return children;
          }
          var result = [];
          var count = 0;
          mapIntoArray(children, result, "", "", function(child) {
            return func.call(context, child, count++);
          });
          return result;
        }
        function countChildren(children) {
          var n2 = 0;
          mapChildren(children, function() {
            n2++;
          });
          return n2;
        }
        function forEachChildren(children, forEachFunc, forEachContext) {
          mapChildren(children, function() {
            forEachFunc.apply(this, arguments);
          }, forEachContext);
        }
        function toArray(children) {
          return mapChildren(children, function(child) {
            return child;
          }) || [];
        }
        function onlyChild(children) {
          if (!isValidElement(children)) {
            throw new Error("React.Children.only expected to receive a single React element child.");
          }
          return children;
        }
        function createContext4(defaultValue) {
          var context = {
            $$typeof: REACT_CONTEXT_TYPE,
            // As a workaround to support multiple concurrent renderers, we categorize
            // some renderers as primary and others as secondary. We only expect
            // there to be two concurrent renderers at most: React Native (primary) and
            // Fabric (secondary); React DOM (primary) and React ART (secondary).
            // Secondary renderers store their context values on separate fields.
            _currentValue: defaultValue,
            _currentValue2: defaultValue,
            // Used to track how many concurrent renderers this context currently
            // supports within in a single renderer. Such as parallel server rendering.
            _threadCount: 0,
            // These are circular
            Provider: null,
            Consumer: null,
            // Add these to use same hidden class in VM as ServerContext
            _defaultValue: null,
            _globalName: null
          };
          context.Provider = {
            $$typeof: REACT_PROVIDER_TYPE,
            _context: context
          };
          var hasWarnedAboutUsingNestedContextConsumers = false;
          var hasWarnedAboutUsingConsumerProvider = false;
          var hasWarnedAboutDisplayNameOnConsumer = false;
          {
            var Consumer = {
              $$typeof: REACT_CONTEXT_TYPE,
              _context: context
            };
            Object.defineProperties(Consumer, {
              Provider: {
                get: function() {
                  if (!hasWarnedAboutUsingConsumerProvider) {
                    hasWarnedAboutUsingConsumerProvider = true;
                    error2("Rendering <Context.Consumer.Provider> is not supported and will be removed in a future major release. Did you mean to render <Context.Provider> instead?");
                  }
                  return context.Provider;
                },
                set: function(_Provider) {
                  context.Provider = _Provider;
                }
              },
              _currentValue: {
                get: function() {
                  return context._currentValue;
                },
                set: function(_currentValue) {
                  context._currentValue = _currentValue;
                }
              },
              _currentValue2: {
                get: function() {
                  return context._currentValue2;
                },
                set: function(_currentValue2) {
                  context._currentValue2 = _currentValue2;
                }
              },
              _threadCount: {
                get: function() {
                  return context._threadCount;
                },
                set: function(_threadCount) {
                  context._threadCount = _threadCount;
                }
              },
              Consumer: {
                get: function() {
                  if (!hasWarnedAboutUsingNestedContextConsumers) {
                    hasWarnedAboutUsingNestedContextConsumers = true;
                    error2("Rendering <Context.Consumer.Consumer> is not supported and will be removed in a future major release. Did you mean to render <Context.Consumer> instead?");
                  }
                  return context.Consumer;
                }
              },
              displayName: {
                get: function() {
                  return context.displayName;
                },
                set: function(displayName) {
                  if (!hasWarnedAboutDisplayNameOnConsumer) {
                    warn("Setting `displayName` on Context.Consumer has no effect. You should set it directly on the context with Context.displayName = '%s'.", displayName);
                    hasWarnedAboutDisplayNameOnConsumer = true;
                  }
                }
              }
            });
            context.Consumer = Consumer;
          }
          {
            context._currentRenderer = null;
            context._currentRenderer2 = null;
          }
          return context;
        }
        var Uninitialized = -1;
        var Pending = 0;
        var Resolved = 1;
        var Rejected = 2;
        function lazyInitializer(payload) {
          if (payload._status === Uninitialized) {
            var ctor = payload._result;
            var thenable = ctor();
            thenable.then(function(moduleObject2) {
              if (payload._status === Pending || payload._status === Uninitialized) {
                var resolved = payload;
                resolved._status = Resolved;
                resolved._result = moduleObject2;
              }
            }, function(error22) {
              if (payload._status === Pending || payload._status === Uninitialized) {
                var rejected = payload;
                rejected._status = Rejected;
                rejected._result = error22;
              }
            });
            if (payload._status === Uninitialized) {
              var pending = payload;
              pending._status = Pending;
              pending._result = thenable;
            }
          }
          if (payload._status === Resolved) {
            var moduleObject = payload._result;
            {
              if (moduleObject === void 0) {
                error2("lazy: Expected the result of a dynamic import() call. Instead received: %s\n\nYour code should look like: \n  const MyComponent = lazy(() => import('./MyComponent'))\n\nDid you accidentally put curly braces around the import?", moduleObject);
              }
            }
            {
              if (!("default" in moduleObject)) {
                error2("lazy: Expected the result of a dynamic import() call. Instead received: %s\n\nYour code should look like: \n  const MyComponent = lazy(() => import('./MyComponent'))", moduleObject);
              }
            }
            return moduleObject.default;
          } else {
            throw payload._result;
          }
        }
        function lazy(ctor) {
          var payload = {
            // We use these fields to store the result.
            _status: Uninitialized,
            _result: ctor
          };
          var lazyType = {
            $$typeof: REACT_LAZY_TYPE,
            _payload: payload,
            _init: lazyInitializer
          };
          {
            var defaultProps;
            var propTypes;
            Object.defineProperties(lazyType, {
              defaultProps: {
                configurable: true,
                get: function() {
                  return defaultProps;
                },
                set: function(newDefaultProps) {
                  error2("React.lazy(...): It is not supported to assign `defaultProps` to a lazy component import. Either specify them where the component is defined, or create a wrapping component around it.");
                  defaultProps = newDefaultProps;
                  Object.defineProperty(lazyType, "defaultProps", {
                    enumerable: true
                  });
                }
              },
              propTypes: {
                configurable: true,
                get: function() {
                  return propTypes;
                },
                set: function(newPropTypes) {
                  error2("React.lazy(...): It is not supported to assign `propTypes` to a lazy component import. Either specify them where the component is defined, or create a wrapping component around it.");
                  propTypes = newPropTypes;
                  Object.defineProperty(lazyType, "propTypes", {
                    enumerable: true
                  });
                }
              }
            });
          }
          return lazyType;
        }
        function forwardRef(render2) {
          {
            if (render2 != null && render2.$$typeof === REACT_MEMO_TYPE) {
              error2("forwardRef requires a render function but received a `memo` component. Instead of forwardRef(memo(...)), use memo(forwardRef(...)).");
            } else if (typeof render2 !== "function") {
              error2("forwardRef requires a render function but was given %s.", render2 === null ? "null" : typeof render2);
            } else {
              if (render2.length !== 0 && render2.length !== 2) {
                error2("forwardRef render functions accept exactly two parameters: props and ref. %s", render2.length === 1 ? "Did you forget to use the ref parameter?" : "Any additional parameter will be undefined.");
              }
            }
            if (render2 != null) {
              if (render2.defaultProps != null || render2.propTypes != null) {
                error2("forwardRef render functions do not support propTypes or defaultProps. Did you accidentally pass a React component?");
              }
            }
          }
          var elementType = {
            $$typeof: REACT_FORWARD_REF_TYPE,
            render: render2
          };
          {
            var ownName;
            Object.defineProperty(elementType, "displayName", {
              enumerable: false,
              configurable: true,
              get: function() {
                return ownName;
              },
              set: function(name) {
                ownName = name;
                if (!render2.name && !render2.displayName) {
                  render2.displayName = name;
                }
              }
            });
          }
          return elementType;
        }
        var REACT_MODULE_REFERENCE;
        {
          REACT_MODULE_REFERENCE = Symbol.for("react.module.reference");
        }
        function isValidElementType(type) {
          if (typeof type === "string" || typeof type === "function") {
            return true;
          }
          if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || enableDebugTracing || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || enableLegacyHidden || type === REACT_OFFSCREEN_TYPE || enableScopeAPI || enableCacheElement || enableTransitionTracing) {
            return true;
          }
          if (typeof type === "object" && type !== null) {
            if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || // This needs to include all possible module reference object
            // types supported by any Flight configuration anywhere since
            // we don't know which Flight build this will end up being used
            // with.
            type.$$typeof === REACT_MODULE_REFERENCE || type.getModuleId !== void 0) {
              return true;
            }
          }
          return false;
        }
        function memo(type, compare2) {
          {
            if (!isValidElementType(type)) {
              error2("memo: The first argument must be a component. Instead received: %s", type === null ? "null" : typeof type);
            }
          }
          var elementType = {
            $$typeof: REACT_MEMO_TYPE,
            type,
            compare: compare2 === void 0 ? null : compare2
          };
          {
            var ownName;
            Object.defineProperty(elementType, "displayName", {
              enumerable: false,
              configurable: true,
              get: function() {
                return ownName;
              },
              set: function(name) {
                ownName = name;
                if (!type.name && !type.displayName) {
                  type.displayName = name;
                }
              }
            });
          }
          return elementType;
        }
        function resolveDispatcher() {
          var dispatcher = ReactCurrentDispatcher.current;
          {
            if (dispatcher === null) {
              error2("Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\n1. You might have mismatching versions of React and the renderer (such as React DOM)\n2. You might be breaking the Rules of Hooks\n3. You might have more than one copy of React in the same app\nSee https://reactjs.org/link/invalid-hook-call for tips about how to debug and fix this problem.");
            }
          }
          return dispatcher;
        }
        function useContext4(Context32) {
          var dispatcher = resolveDispatcher();
          {
            if (Context32._context !== void 0) {
              var realContext = Context32._context;
              if (realContext.Consumer === Context32) {
                error2("Calling useContext(Context.Consumer) is not supported, may cause bugs, and will be removed in a future major release. Did you mean to call useContext(Context) instead?");
              } else if (realContext.Provider === Context32) {
                error2("Calling useContext(Context.Provider) is not supported. Did you mean to call useContext(Context) instead?");
              }
            }
          }
          return dispatcher.useContext(Context32);
        }
        function useState14(initialState) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useState(initialState);
        }
        function useReducer(reducer, initialArg, init) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useReducer(reducer, initialArg, init);
        }
        function useRef2(initialValue) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useRef(initialValue);
        }
        function useEffect11(create2, deps) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useEffect(create2, deps);
        }
        function useInsertionEffect(create2, deps) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useInsertionEffect(create2, deps);
        }
        function useLayoutEffect(create2, deps) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useLayoutEffect(create2, deps);
        }
        function useCallback(callback, deps) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useCallback(callback, deps);
        }
        function useMemo2(create2, deps) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useMemo(create2, deps);
        }
        function useImperativeHandle(ref, create2, deps) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useImperativeHandle(ref, create2, deps);
        }
        function useDebugValue(value, formatterFn) {
          {
            var dispatcher = resolveDispatcher();
            return dispatcher.useDebugValue(value, formatterFn);
          }
        }
        function useTransition() {
          var dispatcher = resolveDispatcher();
          return dispatcher.useTransition();
        }
        function useDeferredValue(value) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useDeferredValue(value);
        }
        function useId() {
          var dispatcher = resolveDispatcher();
          return dispatcher.useId();
        }
        function useSyncExternalStore2(subscribe, getSnapshot, getServerSnapshot) {
          var dispatcher = resolveDispatcher();
          return dispatcher.useSyncExternalStore(subscribe, getSnapshot, getServerSnapshot);
        }
        var disabledDepth = 0;
        var prevLog;
        var prevInfo;
        var prevWarn;
        var prevError;
        var prevGroup;
        var prevGroupCollapsed;
        var prevGroupEnd;
        function disabledLog() {
        }
        disabledLog.__reactDisabledLog = true;
        function disableLogs() {
          {
            if (disabledDepth === 0) {
              prevLog = console.log;
              prevInfo = console.info;
              prevWarn = console.warn;
              prevError = console.error;
              prevGroup = console.group;
              prevGroupCollapsed = console.groupCollapsed;
              prevGroupEnd = console.groupEnd;
              var props = {
                configurable: true,
                enumerable: true,
                value: disabledLog,
                writable: true
              };
              Object.defineProperties(console, {
                info: props,
                log: props,
                warn: props,
                error: props,
                group: props,
                groupCollapsed: props,
                groupEnd: props
              });
            }
            disabledDepth++;
          }
        }
        function reenableLogs() {
          {
            disabledDepth--;
            if (disabledDepth === 0) {
              var props = {
                configurable: true,
                enumerable: true,
                writable: true
              };
              Object.defineProperties(console, {
                log: assign2({}, props, {
                  value: prevLog
                }),
                info: assign2({}, props, {
                  value: prevInfo
                }),
                warn: assign2({}, props, {
                  value: prevWarn
                }),
                error: assign2({}, props, {
                  value: prevError
                }),
                group: assign2({}, props, {
                  value: prevGroup
                }),
                groupCollapsed: assign2({}, props, {
                  value: prevGroupCollapsed
                }),
                groupEnd: assign2({}, props, {
                  value: prevGroupEnd
                })
              });
            }
            if (disabledDepth < 0) {
              error2("disabledDepth fell below zero. This is a bug in React. Please file an issue.");
            }
          }
        }
        var ReactCurrentDispatcher$1 = ReactSharedInternals.ReactCurrentDispatcher;
        var prefix2;
        function describeBuiltInComponentFrame(name, source, ownerFn) {
          {
            if (prefix2 === void 0) {
              try {
                throw Error();
              } catch (x22) {
                var match22 = x22.stack.trim().match(/\n( *(at )?)/);
                prefix2 = match22 && match22[1] || "";
              }
            }
            return "\n" + prefix2 + name;
          }
        }
        var reentry = false;
        var componentFrameCache;
        {
          var PossiblyWeakMap = typeof WeakMap === "function" ? WeakMap : Map;
          componentFrameCache = new PossiblyWeakMap();
        }
        function describeNativeComponentFrame(fn2, construct) {
          if (!fn2 || reentry) {
            return "";
          }
          {
            var frame = componentFrameCache.get(fn2);
            if (frame !== void 0) {
              return frame;
            }
          }
          var control;
          reentry = true;
          var previousPrepareStackTrace = Error.prepareStackTrace;
          Error.prepareStackTrace = void 0;
          var previousDispatcher;
          {
            previousDispatcher = ReactCurrentDispatcher$1.current;
            ReactCurrentDispatcher$1.current = null;
            disableLogs();
          }
          try {
            if (construct) {
              var Fake = function() {
                throw Error();
              };
              Object.defineProperty(Fake.prototype, "props", {
                set: function() {
                  throw Error();
                }
              });
              if (typeof Reflect === "object" && Reflect.construct) {
                try {
                  Reflect.construct(Fake, []);
                } catch (x22) {
                  control = x22;
                }
                Reflect.construct(fn2, [], Fake);
              } else {
                try {
                  Fake.call();
                } catch (x22) {
                  control = x22;
                }
                fn2.call(Fake.prototype);
              }
            } else {
              try {
                throw Error();
              } catch (x22) {
                control = x22;
              }
              fn2();
            }
          } catch (sample) {
            if (sample && control && typeof sample.stack === "string") {
              var sampleLines = sample.stack.split("\n");
              var controlLines = control.stack.split("\n");
              var s32 = sampleLines.length - 1;
              var c22 = controlLines.length - 1;
              while (s32 >= 1 && c22 >= 0 && sampleLines[s32] !== controlLines[c22]) {
                c22--;
              }
              for (; s32 >= 1 && c22 >= 0; s32--, c22--) {
                if (sampleLines[s32] !== controlLines[c22]) {
                  if (s32 !== 1 || c22 !== 1) {
                    do {
                      s32--;
                      c22--;
                      if (c22 < 0 || sampleLines[s32] !== controlLines[c22]) {
                        var _frame = "\n" + sampleLines[s32].replace(" at new ", " at ");
                        if (fn2.displayName && _frame.includes("<anonymous>")) {
                          _frame = _frame.replace("<anonymous>", fn2.displayName);
                        }
                        {
                          if (typeof fn2 === "function") {
                            componentFrameCache.set(fn2, _frame);
                          }
                        }
                        return _frame;
                      }
                    } while (s32 >= 1 && c22 >= 0);
                  }
                  break;
                }
              }
            }
          } finally {
            reentry = false;
            {
              ReactCurrentDispatcher$1.current = previousDispatcher;
              reenableLogs();
            }
            Error.prepareStackTrace = previousPrepareStackTrace;
          }
          var name = fn2 ? fn2.displayName || fn2.name : "";
          var syntheticFrame = name ? describeBuiltInComponentFrame(name) : "";
          {
            if (typeof fn2 === "function") {
              componentFrameCache.set(fn2, syntheticFrame);
            }
          }
          return syntheticFrame;
        }
        function describeFunctionComponentFrame(fn2, source, ownerFn) {
          {
            return describeNativeComponentFrame(fn2, false);
          }
        }
        function shouldConstruct(Component2) {
          var prototype = Component2.prototype;
          return !!(prototype && prototype.isReactComponent);
        }
        function describeUnknownElementTypeFrameInDEV(type, source, ownerFn) {
          if (type == null) {
            return "";
          }
          if (typeof type === "function") {
            {
              return describeNativeComponentFrame(type, shouldConstruct(type));
            }
          }
          if (typeof type === "string") {
            return describeBuiltInComponentFrame(type);
          }
          switch (type) {
            case REACT_SUSPENSE_TYPE:
              return describeBuiltInComponentFrame("Suspense");
            case REACT_SUSPENSE_LIST_TYPE:
              return describeBuiltInComponentFrame("SuspenseList");
          }
          if (typeof type === "object") {
            switch (type.$$typeof) {
              case REACT_FORWARD_REF_TYPE:
                return describeFunctionComponentFrame(type.render);
              case REACT_MEMO_TYPE:
                return describeUnknownElementTypeFrameInDEV(type.type, source, ownerFn);
              case REACT_LAZY_TYPE: {
                var lazyComponent = type;
                var payload = lazyComponent._payload;
                var init = lazyComponent._init;
                try {
                  return describeUnknownElementTypeFrameInDEV(init(payload), source, ownerFn);
                } catch (x22) {
                }
              }
            }
          }
          return "";
        }
        var loggedTypeFailures = {};
        var ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;
        function setCurrentlyValidatingElement(element) {
          {
            if (element) {
              var owner = element._owner;
              var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
              ReactDebugCurrentFrame$1.setExtraStackFrame(stack);
            } else {
              ReactDebugCurrentFrame$1.setExtraStackFrame(null);
            }
          }
        }
        function checkPropTypes(typeSpecs, values, location2, componentName, element) {
          {
            var has = Function.call.bind(hasOwnProperty);
            for (var typeSpecName in typeSpecs) {
              if (has(typeSpecs, typeSpecName)) {
                var error$1 = void 0;
                try {
                  if (typeof typeSpecs[typeSpecName] !== "function") {
                    var err = Error((componentName || "React class") + ": " + location2 + " type `" + typeSpecName + "` is invalid; it must be a function, usually from the `prop-types` package, but received `" + typeof typeSpecs[typeSpecName] + "`.This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.");
                    err.name = "Invariant Violation";
                    throw err;
                  }
                  error$1 = typeSpecs[typeSpecName](values, typeSpecName, componentName, location2, null, "SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED");
                } catch (ex) {
                  error$1 = ex;
                }
                if (error$1 && !(error$1 instanceof Error)) {
                  setCurrentlyValidatingElement(element);
                  error2("%s: type specification of %s `%s` is invalid; the type checker function must return `null` or an `Error` but returned a %s. You may have forgotten to pass an argument to the type checker creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and shape all require an argument).", componentName || "React class", location2, typeSpecName, typeof error$1);
                  setCurrentlyValidatingElement(null);
                }
                if (error$1 instanceof Error && !(error$1.message in loggedTypeFailures)) {
                  loggedTypeFailures[error$1.message] = true;
                  setCurrentlyValidatingElement(element);
                  error2("Failed %s type: %s", location2, error$1.message);
                  setCurrentlyValidatingElement(null);
                }
              }
            }
          }
        }
        function setCurrentlyValidatingElement$1(element) {
          {
            if (element) {
              var owner = element._owner;
              var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
              setExtraStackFrame(stack);
            } else {
              setExtraStackFrame(null);
            }
          }
        }
        var propTypesMisspellWarningShown;
        {
          propTypesMisspellWarningShown = false;
        }
        function getDeclarationErrorAddendum() {
          if (ReactCurrentOwner.current) {
            var name = getComponentNameFromType(ReactCurrentOwner.current.type);
            if (name) {
              return "\n\nCheck the render method of `" + name + "`.";
            }
          }
          return "";
        }
        function getSourceInfoErrorAddendum(source) {
          if (source !== void 0) {
            var fileName = source.fileName.replace(/^.*[\\\/]/, "");
            var lineNumber = source.lineNumber;
            return "\n\nCheck your code at " + fileName + ":" + lineNumber + ".";
          }
          return "";
        }
        function getSourceInfoErrorAddendumForProps(elementProps) {
          if (elementProps !== null && elementProps !== void 0) {
            return getSourceInfoErrorAddendum(elementProps.__source);
          }
          return "";
        }
        var ownerHasKeyUseWarning = {};
        function getCurrentComponentErrorInfo(parentType) {
          var info = getDeclarationErrorAddendum();
          if (!info) {
            var parentName = typeof parentType === "string" ? parentType : parentType.displayName || parentType.name;
            if (parentName) {
              info = "\n\nCheck the top-level render call using <" + parentName + ">.";
            }
          }
          return info;
        }
        function validateExplicitKey(element, parentType) {
          if (!element._store || element._store.validated || element.key != null) {
            return;
          }
          element._store.validated = true;
          var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);
          if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {
            return;
          }
          ownerHasKeyUseWarning[currentComponentErrorInfo] = true;
          var childOwner = "";
          if (element && element._owner && element._owner !== ReactCurrentOwner.current) {
            childOwner = " It was passed a child from " + getComponentNameFromType(element._owner.type) + ".";
          }
          {
            setCurrentlyValidatingElement$1(element);
            error2('Each child in a list should have a unique "key" prop.%s%s See https://reactjs.org/link/warning-keys for more information.', currentComponentErrorInfo, childOwner);
            setCurrentlyValidatingElement$1(null);
          }
        }
        function validateChildKeys(node, parentType) {
          if (typeof node !== "object") {
            return;
          }
          if (isArray(node)) {
            for (var i22 = 0; i22 < node.length; i22++) {
              var child = node[i22];
              if (isValidElement(child)) {
                validateExplicitKey(child, parentType);
              }
            }
          } else if (isValidElement(node)) {
            if (node._store) {
              node._store.validated = true;
            }
          } else if (node) {
            var iteratorFn = getIteratorFn(node);
            if (typeof iteratorFn === "function") {
              if (iteratorFn !== node.entries) {
                var iterator = iteratorFn.call(node);
                var step;
                while (!(step = iterator.next()).done) {
                  if (isValidElement(step.value)) {
                    validateExplicitKey(step.value, parentType);
                  }
                }
              }
            }
          }
        }
        function validatePropTypes(element) {
          {
            var type = element.type;
            if (type === null || type === void 0 || typeof type === "string") {
              return;
            }
            var propTypes;
            if (typeof type === "function") {
              propTypes = type.propTypes;
            } else if (typeof type === "object" && (type.$$typeof === REACT_FORWARD_REF_TYPE || // Note: Memo only checks outer props here.
            // Inner props are checked in the reconciler.
            type.$$typeof === REACT_MEMO_TYPE)) {
              propTypes = type.propTypes;
            } else {
              return;
            }
            if (propTypes) {
              var name = getComponentNameFromType(type);
              checkPropTypes(propTypes, element.props, "prop", name, element);
            } else if (type.PropTypes !== void 0 && !propTypesMisspellWarningShown) {
              propTypesMisspellWarningShown = true;
              var _name = getComponentNameFromType(type);
              error2("Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?", _name || "Unknown");
            }
            if (typeof type.getDefaultProps === "function" && !type.getDefaultProps.isReactClassApproved) {
              error2("getDefaultProps is only used on classic React.createClass definitions. Use a static property named `defaultProps` instead.");
            }
          }
        }
        function validateFragmentProps(fragment) {
          {
            var keys = Object.keys(fragment.props);
            for (var i22 = 0; i22 < keys.length; i22++) {
              var key = keys[i22];
              if (key !== "children" && key !== "key") {
                setCurrentlyValidatingElement$1(fragment);
                error2("Invalid prop `%s` supplied to `React.Fragment`. React.Fragment can only have `key` and `children` props.", key);
                setCurrentlyValidatingElement$1(null);
                break;
              }
            }
            if (fragment.ref !== null) {
              setCurrentlyValidatingElement$1(fragment);
              error2("Invalid attribute `ref` supplied to `React.Fragment`.");
              setCurrentlyValidatingElement$1(null);
            }
          }
        }
        function createElementWithValidation(type, props, children) {
          var validType = isValidElementType(type);
          if (!validType) {
            var info = "";
            if (type === void 0 || typeof type === "object" && type !== null && Object.keys(type).length === 0) {
              info += " You likely forgot to export your component from the file it's defined in, or you might have mixed up default and named imports.";
            }
            var sourceInfo = getSourceInfoErrorAddendumForProps(props);
            if (sourceInfo) {
              info += sourceInfo;
            } else {
              info += getDeclarationErrorAddendum();
            }
            var typeString;
            if (type === null) {
              typeString = "null";
            } else if (isArray(type)) {
              typeString = "array";
            } else if (type !== void 0 && type.$$typeof === REACT_ELEMENT_TYPE) {
              typeString = "<" + (getComponentNameFromType(type.type) || "Unknown") + " />";
              info = " Did you accidentally export a JSX literal instead of a component?";
            } else {
              typeString = typeof type;
            }
            {
              error2("React.createElement: type is invalid -- expected a string (for built-in components) or a class/function (for composite components) but got: %s.%s", typeString, info);
            }
          }
          var element = createElement2.apply(this, arguments);
          if (element == null) {
            return element;
          }
          if (validType) {
            for (var i22 = 2; i22 < arguments.length; i22++) {
              validateChildKeys(arguments[i22], type);
            }
          }
          if (type === REACT_FRAGMENT_TYPE) {
            validateFragmentProps(element);
          } else {
            validatePropTypes(element);
          }
          return element;
        }
        var didWarnAboutDeprecatedCreateFactory = false;
        function createFactoryWithValidation(type) {
          var validatedFactory = createElementWithValidation.bind(null, type);
          validatedFactory.type = type;
          {
            if (!didWarnAboutDeprecatedCreateFactory) {
              didWarnAboutDeprecatedCreateFactory = true;
              warn("React.createFactory() is deprecated and will be removed in a future major release. Consider using JSX or use React.createElement() directly instead.");
            }
            Object.defineProperty(validatedFactory, "type", {
              enumerable: false,
              get: function() {
                warn("Factory.type is deprecated. Access the class directly before passing it to createFactory.");
                Object.defineProperty(this, "type", {
                  value: type
                });
                return type;
              }
            });
          }
          return validatedFactory;
        }
        function cloneElementWithValidation(element, props, children) {
          var newElement = cloneElement.apply(this, arguments);
          for (var i22 = 2; i22 < arguments.length; i22++) {
            validateChildKeys(arguments[i22], newElement.type);
          }
          validatePropTypes(newElement);
          return newElement;
        }
        function startTransition(scope, options) {
          var prevTransition = ReactCurrentBatchConfig.transition;
          ReactCurrentBatchConfig.transition = {};
          var currentTransition = ReactCurrentBatchConfig.transition;
          {
            ReactCurrentBatchConfig.transition._updatedFibers = /* @__PURE__ */ new Set();
          }
          try {
            scope();
          } finally {
            ReactCurrentBatchConfig.transition = prevTransition;
            {
              if (prevTransition === null && currentTransition._updatedFibers) {
                var updatedFibersCount = currentTransition._updatedFibers.size;
                if (updatedFibersCount > 10) {
                  warn("Detected a large number of updates inside startTransition. If this is due to a subscription please re-write it to use React provided hooks. Otherwise concurrent mode guarantees are off the table.");
                }
                currentTransition._updatedFibers.clear();
              }
            }
          }
        }
        var didWarnAboutMessageChannel = false;
        var enqueueTaskImpl = null;
        function enqueueTask(task) {
          if (enqueueTaskImpl === null) {
            try {
              var requireString = ("require" + Math.random()).slice(0, 7);
              var nodeRequire = module && module[requireString];
              enqueueTaskImpl = nodeRequire.call(module, "timers").setImmediate;
            } catch (_err) {
              enqueueTaskImpl = function(callback) {
                {
                  if (didWarnAboutMessageChannel === false) {
                    didWarnAboutMessageChannel = true;
                    if (typeof MessageChannel === "undefined") {
                      error2("This browser does not have a MessageChannel implementation, so enqueuing tasks via await act(async () => ...) will fail. Please file an issue at https://github.com/facebook/react/issues if you encounter this warning.");
                    }
                  }
                }
                var channel = new MessageChannel();
                channel.port1.onmessage = callback;
                channel.port2.postMessage(void 0);
              };
            }
          }
          return enqueueTaskImpl(task);
        }
        var actScopeDepth = 0;
        var didWarnNoAwaitAct = false;
        function act(callback) {
          {
            var prevActScopeDepth = actScopeDepth;
            actScopeDepth++;
            if (ReactCurrentActQueue.current === null) {
              ReactCurrentActQueue.current = [];
            }
            var prevIsBatchingLegacy = ReactCurrentActQueue.isBatchingLegacy;
            var result;
            try {
              ReactCurrentActQueue.isBatchingLegacy = true;
              result = callback();
              if (!prevIsBatchingLegacy && ReactCurrentActQueue.didScheduleLegacyUpdate) {
                var queue = ReactCurrentActQueue.current;
                if (queue !== null) {
                  ReactCurrentActQueue.didScheduleLegacyUpdate = false;
                  flushActQueue(queue);
                }
              }
            } catch (error22) {
              popActScope(prevActScopeDepth);
              throw error22;
            } finally {
              ReactCurrentActQueue.isBatchingLegacy = prevIsBatchingLegacy;
            }
            if (result !== null && typeof result === "object" && typeof result.then === "function") {
              var thenableResult = result;
              var wasAwaited = false;
              var thenable = {
                then: function(resolve, reject) {
                  wasAwaited = true;
                  thenableResult.then(function(returnValue2) {
                    popActScope(prevActScopeDepth);
                    if (actScopeDepth === 0) {
                      recursivelyFlushAsyncActWork(returnValue2, resolve, reject);
                    } else {
                      resolve(returnValue2);
                    }
                  }, function(error22) {
                    popActScope(prevActScopeDepth);
                    reject(error22);
                  });
                }
              };
              {
                if (!didWarnNoAwaitAct && typeof Promise !== "undefined") {
                  Promise.resolve().then(function() {
                  }).then(function() {
                    if (!wasAwaited) {
                      didWarnNoAwaitAct = true;
                      error2("You called act(async () => ...) without await. This could lead to unexpected testing behaviour, interleaving multiple act calls and mixing their scopes. You should - await act(async () => ...);");
                    }
                  });
                }
              }
              return thenable;
            } else {
              var returnValue = result;
              popActScope(prevActScopeDepth);
              if (actScopeDepth === 0) {
                var _queue = ReactCurrentActQueue.current;
                if (_queue !== null) {
                  flushActQueue(_queue);
                  ReactCurrentActQueue.current = null;
                }
                var _thenable = {
                  then: function(resolve, reject) {
                    if (ReactCurrentActQueue.current === null) {
                      ReactCurrentActQueue.current = [];
                      recursivelyFlushAsyncActWork(returnValue, resolve, reject);
                    } else {
                      resolve(returnValue);
                    }
                  }
                };
                return _thenable;
              } else {
                var _thenable2 = {
                  then: function(resolve, reject) {
                    resolve(returnValue);
                  }
                };
                return _thenable2;
              }
            }
          }
        }
        function popActScope(prevActScopeDepth) {
          {
            if (prevActScopeDepth !== actScopeDepth - 1) {
              error2("You seem to have overlapping act() calls, this is not supported. Be sure to await previous act() calls before making a new one. ");
            }
            actScopeDepth = prevActScopeDepth;
          }
        }
        function recursivelyFlushAsyncActWork(returnValue, resolve, reject) {
          {
            var queue = ReactCurrentActQueue.current;
            if (queue !== null) {
              try {
                flushActQueue(queue);
                enqueueTask(function() {
                  if (queue.length === 0) {
                    ReactCurrentActQueue.current = null;
                    resolve(returnValue);
                  } else {
                    recursivelyFlushAsyncActWork(returnValue, resolve, reject);
                  }
                });
              } catch (error22) {
                reject(error22);
              }
            } else {
              resolve(returnValue);
            }
          }
        }
        var isFlushing = false;
        function flushActQueue(queue) {
          {
            if (!isFlushing) {
              isFlushing = true;
              var i22 = 0;
              try {
                for (; i22 < queue.length; i22++) {
                  var callback = queue[i22];
                  do {
                    callback = callback(true);
                  } while (callback !== null);
                }
                queue.length = 0;
              } catch (error22) {
                queue = queue.slice(i22 + 1);
                throw error22;
              } finally {
                isFlushing = false;
              }
            }
          }
        }
        var createElement$1 = createElementWithValidation;
        var cloneElement$1 = cloneElementWithValidation;
        var createFactory = createFactoryWithValidation;
        var Children = {
          map: mapChildren,
          forEach: forEachChildren,
          count: countChildren,
          toArray,
          only: onlyChild
        };
        exports.Children = Children;
        exports.Component = Component;
        exports.Fragment = REACT_FRAGMENT_TYPE;
        exports.Profiler = REACT_PROFILER_TYPE;
        exports.PureComponent = PureComponent;
        exports.StrictMode = REACT_STRICT_MODE_TYPE;
        exports.Suspense = REACT_SUSPENSE_TYPE;
        exports.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = ReactSharedInternals;
        exports.cloneElement = cloneElement$1;
        exports.createContext = createContext4;
        exports.createElement = createElement$1;
        exports.createFactory = createFactory;
        exports.createRef = createRef;
        exports.forwardRef = forwardRef;
        exports.isValidElement = isValidElement;
        exports.lazy = lazy;
        exports.memo = memo;
        exports.startTransition = startTransition;
        exports.unstable_act = act;
        exports.useCallback = useCallback;
        exports.useContext = useContext4;
        exports.useDebugValue = useDebugValue;
        exports.useDeferredValue = useDeferredValue;
        exports.useEffect = useEffect11;
        exports.useId = useId;
        exports.useImperativeHandle = useImperativeHandle;
        exports.useInsertionEffect = useInsertionEffect;
        exports.useLayoutEffect = useLayoutEffect;
        exports.useMemo = useMemo2;
        exports.useReducer = useReducer;
        exports.useRef = useRef2;
        exports.useState = useState14;
        exports.useSyncExternalStore = useSyncExternalStore2;
        exports.useTransition = useTransition;
        exports.version = ReactVersion;
        if (typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ !== "undefined" && typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStop === "function") {
          __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStop(new Error());
        }
      })();
    }
  }
});
var require_react = __commonJS2({
  "../../node_modules/.pnpm/react@18.2.0/node_modules/react/index.js"(exports, module) {
    "use strict";
    if (false) {
      module.exports = null;
    } else {
      module.exports = require_react_development();
    }
  }
});
var require_AcademicCapIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/AcademicCapIcon.js"(exports, module) {
    var React = require_react();
    function AcademicCapIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.26 10.147a60.436 60.436 0 00-.491 6.347A48.627 48.627 0 0112 20.904a48.627 48.627 0 018.232-4.41 60.46 60.46 0 00-.491-6.347m-15.482 0a50.57 50.57 0 00-2.658-.813A59.905 59.905 0 0112 3.493a59.902 59.902 0 0110.399 5.84c-.896.248-1.783.52-2.658.814m-15.482 0A50.697 50.697 0 0112 13.489a50.702 50.702 0 017.74-3.342M6.75 15a.75.75 0 100-1.5.75.75 0 000 1.5zm0 0v-3.675A55.378 55.378 0 0112 8.443m-7.007 11.55A5.981 5.981 0 006.75 15.75v-1.5"
      }));
    }
    var ForwardRef = React.forwardRef(AcademicCapIcon);
    module.exports = ForwardRef;
  }
});
var require_AdjustmentsHorizontalIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/AdjustmentsHorizontalIcon.js"(exports, module) {
    var React = require_react();
    function AdjustmentsHorizontalIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.5 6h9.75M10.5 6a1.5 1.5 0 11-3 0m3 0a1.5 1.5 0 10-3 0M3.75 6H7.5m3 12h9.75m-9.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-3.75 0H7.5m9-6h3.75m-3.75 0a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m-9.75 0h9.75"
      }));
    }
    var ForwardRef = React.forwardRef(AdjustmentsHorizontalIcon);
    module.exports = ForwardRef;
  }
});
var require_AdjustmentsVerticalIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/AdjustmentsVerticalIcon.js"(exports, module) {
    var React = require_react();
    function AdjustmentsVerticalIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6 13.5V3.75m0 9.75a1.5 1.5 0 010 3m0-3a1.5 1.5 0 000 3m0 3.75V16.5m12-3V3.75m0 9.75a1.5 1.5 0 010 3m0-3a1.5 1.5 0 000 3m0 3.75V16.5m-6-9V3.75m0 3.75a1.5 1.5 0 010 3m0-3a1.5 1.5 0 000 3m0 9.75V10.5"
      }));
    }
    var ForwardRef = React.forwardRef(AdjustmentsVerticalIcon);
    module.exports = ForwardRef;
  }
});
var require_ArchiveBoxArrowDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArchiveBoxArrowDownIcon.js"(exports, module) {
    var React = require_react();
    function ArchiveBoxArrowDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.25 7.5l-.625 10.632a2.25 2.25 0 01-2.247 2.118H6.622a2.25 2.25 0 01-2.247-2.118L3.75 7.5m8.25 3v6.75m0 0l-3-3m3 3l3-3M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125z"
      }));
    }
    var ForwardRef = React.forwardRef(ArchiveBoxArrowDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ArchiveBoxXMarkIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArchiveBoxXMarkIcon.js"(exports, module) {
    var React = require_react();
    function ArchiveBoxXMarkIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.25 7.5l-.625 10.632a2.25 2.25 0 01-2.247 2.118H6.622a2.25 2.25 0 01-2.247-2.118L3.75 7.5m6 4.125l2.25 2.25m0 0l2.25 2.25M12 13.875l2.25-2.25M12 13.875l-2.25 2.25M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125z"
      }));
    }
    var ForwardRef = React.forwardRef(ArchiveBoxXMarkIcon);
    module.exports = ForwardRef;
  }
});
var require_ArchiveBoxIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArchiveBoxIcon.js"(exports, module) {
    var React = require_react();
    function ArchiveBoxIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.25 7.5l-.625 10.632a2.25 2.25 0 01-2.247 2.118H6.622a2.25 2.25 0 01-2.247-2.118L3.75 7.5M10 11.25h4M3.375 7.5h17.25c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125z"
      }));
    }
    var ForwardRef = React.forwardRef(ArchiveBoxIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowDownCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowDownCircleIcon.js"(exports, module) {
    var React = require_react();
    function ArrowDownCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 12.75l3 3m0 0l3-3m-3 3v-7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowDownLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowDownLeftIcon.js"(exports, module) {
    var React = require_react();
    function ArrowDownLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 4.5l-15 15m0 0h11.25m-11.25 0V8.25"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowDownOnSquareStackIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowDownOnSquareStackIcon.js"(exports, module) {
    var React = require_react();
    function ArrowDownOnSquareStackIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.5 7.5h-.75A2.25 2.25 0 004.5 9.75v7.5a2.25 2.25 0 002.25 2.25h7.5a2.25 2.25 0 002.25-2.25v-7.5a2.25 2.25 0 00-2.25-2.25h-.75m-6 3.75l3 3m0 0l3-3m-3 3V1.5m6 9h.75a2.25 2.25 0 012.25 2.25v7.5a2.25 2.25 0 01-2.25 2.25h-7.5a2.25 2.25 0 01-2.25-2.25v-.75"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownOnSquareStackIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowDownOnSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowDownOnSquareIcon.js"(exports, module) {
    var React = require_react();
    function ArrowDownOnSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 8.25H7.5a2.25 2.25 0 00-2.25 2.25v9a2.25 2.25 0 002.25 2.25h9a2.25 2.25 0 002.25-2.25v-9a2.25 2.25 0 00-2.25-2.25H15M9 12l3 3m0 0l3-3m-3 3V2.25"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownOnSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowDownRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowDownRightIcon.js"(exports, module) {
    var React = require_react();
    function ArrowDownRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 4.5l15 15m0 0V8.25m0 11.25H8.25"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowDownTrayIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowDownTrayIcon.js"(exports, module) {
    var React = require_react();
    function ArrowDownTrayIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5M16.5 12L12 16.5m0 0L7.5 12m4.5 4.5V3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownTrayIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowDownIcon.js"(exports, module) {
    var React = require_react();
    function ArrowDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 13.5L12 21m0 0l-7.5-7.5M12 21V3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowLeftCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowLeftCircleIcon.js"(exports, module) {
    var React = require_react();
    function ArrowLeftCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M11.25 9l-3 3m0 0l3 3m-3-3h7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLeftCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowLeftOnRectangleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowLeftOnRectangleIcon.js"(exports, module) {
    var React = require_react();
    function ArrowLeftOnRectangleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLeftOnRectangleIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowLeftIcon.js"(exports, module) {
    var React = require_react();
    function ArrowLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.5 19.5L3 12m0 0l7.5-7.5M3 12h18"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowLongDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowLongDownIcon.js"(exports, module) {
    var React = require_react();
    function ArrowLongDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 17.25L12 21m0 0l-3.75-3.75M12 21V3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowLongLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowLongLeftIcon.js"(exports, module) {
    var React = require_react();
    function ArrowLongLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.75 15.75L3 12m0 0l3.75-3.75M3 12h18"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowLongRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowLongRightIcon.js"(exports, module) {
    var React = require_react();
    function ArrowLongRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17.25 8.25L21 12m0 0l-3.75 3.75M21 12H3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowLongUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowLongUpIcon.js"(exports, module) {
    var React = require_react();
    function ArrowLongUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 6.75L12 3m0 0l3.75 3.75M12 3v18"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowLongUpIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowPathRoundedSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowPathRoundedSquareIcon.js"(exports, module) {
    var React = require_react();
    function ArrowPathRoundedSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 12c0-1.232-.046-2.453-.138-3.662a4.006 4.006 0 00-3.7-3.7 48.678 48.678 0 00-7.324 0 4.006 4.006 0 00-3.7 3.7c-.017.22-.032.441-.046.662M19.5 12l3-3m-3 3l-3-3m-12 3c0 1.232.046 2.453.138 3.662a4.006 4.006 0 003.7 3.7 48.656 48.656 0 007.324 0 4.006 4.006 0 003.7-3.7c.017-.22.032-.441.046-.662M4.5 12l3 3m-3-3l-3 3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowPathRoundedSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowPathIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowPathIcon.js"(exports, module) {
    var React = require_react();
    function ArrowPathIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182m0-4.991v4.99"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowPathIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowRightCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowRightCircleIcon.js"(exports, module) {
    var React = require_react();
    function ArrowRightCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12.75 15l3-3m0 0l-3-3m3 3h-7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowRightCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowRightOnRectangleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowRightOnRectangleIcon.js"(exports, module) {
    var React = require_react();
    function ArrowRightOnRectangleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15m3 0l3-3m0 0l-3-3m3 3H9"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowRightOnRectangleIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowRightIcon.js"(exports, module) {
    var React = require_react();
    function ArrowRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13.5 4.5L21 12m0 0l-7.5 7.5M21 12H3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowSmallDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowSmallDownIcon.js"(exports, module) {
    var React = require_react();
    function ArrowSmallDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 4.5v15m0 0l6.75-6.75M12 19.5l-6.75-6.75"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowSmallLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowSmallLeftIcon.js"(exports, module) {
    var React = require_react();
    function ArrowSmallLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 12h-15m0 0l6.75 6.75M4.5 12l6.75-6.75"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowSmallRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowSmallRightIcon.js"(exports, module) {
    var React = require_react();
    function ArrowSmallRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 12h15m0 0l-6.75-6.75M19.5 12l-6.75 6.75"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowSmallUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowSmallUpIcon.js"(exports, module) {
    var React = require_react();
    function ArrowSmallUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 19.5v-15m0 0l-6.75 6.75M12 4.5l6.75 6.75"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowSmallUpIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowTopRightOnSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowTopRightOnSquareIcon.js"(exports, module) {
    var React = require_react();
    function ArrowTopRightOnSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13.5 6H5.25A2.25 2.25 0 003 8.25v10.5A2.25 2.25 0 005.25 21h10.5A2.25 2.25 0 0018 18.75V10.5m-10.5 6L21 3m0 0h-5.25M21 3v5.25"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowTopRightOnSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowTrendingDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowTrendingDownIcon.js"(exports, module) {
    var React = require_react();
    function ArrowTrendingDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 6L9 12.75l4.286-4.286a11.948 11.948 0 014.306 6.43l.776 2.898m0 0l3.182-5.511m-3.182 5.51l-5.511-3.181"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowTrendingDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowTrendingUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowTrendingUpIcon.js"(exports, module) {
    var React = require_react();
    function ArrowTrendingUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 18L9 11.25l4.306 4.307a11.95 11.95 0 015.814-5.519l2.74-1.22m0 0l-5.94-2.28m5.94 2.28l-2.28 5.941"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowTrendingUpIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUpCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUpCircleIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUpCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 11.25l-3-3m0 0l-3 3m3-3v7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUpLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUpLeftIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUpLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 19.5l-15-15m0 0v11.25m0-11.25h11.25"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUpOnSquareStackIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUpOnSquareStackIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUpOnSquareStackIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.5 7.5h-.75A2.25 2.25 0 004.5 9.75v7.5a2.25 2.25 0 002.25 2.25h7.5a2.25 2.25 0 002.25-2.25v-7.5a2.25 2.25 0 00-2.25-2.25h-.75m0-3l-3-3m0 0l-3 3m3-3v11.25m6-2.25h.75a2.25 2.25 0 012.25 2.25v7.5a2.25 2.25 0 01-2.25 2.25h-7.5a2.25 2.25 0 01-2.25-2.25v-.75"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpOnSquareStackIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUpOnSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUpOnSquareIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUpOnSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 8.25H7.5a2.25 2.25 0 00-2.25 2.25v9a2.25 2.25 0 002.25 2.25h9a2.25 2.25 0 002.25-2.25v-9a2.25 2.25 0 00-2.25-2.25H15m0-3l-3-3m0 0l-3 3m3-3V15"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpOnSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUpRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUpRightIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUpRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 19.5l15-15m0 0H8.25m11.25 0v11.25"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUpTrayIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUpTrayIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUpTrayIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5m-13.5-9L12 3m0 0l4.5 4.5M12 3v13.5"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpTrayIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUpIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 10.5L12 3m0 0l7.5 7.5M12 3v18"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUpIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUturnDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUturnDownIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUturnDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 15l-6 6m0 0l-6-6m6 6V9a6 6 0 0112 0v3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUturnLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUturnLeftIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUturnLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 15L3 9m0 0l6-6M3 9h12a6 6 0 010 12h-3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUturnRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUturnRightIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUturnRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 15l6-6m0 0l-6-6m6 6H9a6 6 0 000 12h3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowUturnUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowUturnUpIcon.js"(exports, module) {
    var React = require_react();
    function ArrowUturnUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 9l6-6m0 0l6 6m-6-6v12a6 6 0 01-12 0v-3"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowUturnUpIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowsPointingInIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowsPointingInIcon.js"(exports, module) {
    var React = require_react();
    function ArrowsPointingInIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 9V4.5M9 9H4.5M9 9L3.75 3.75M9 15v4.5M9 15H4.5M9 15l-5.25 5.25M15 9h4.5M15 9V4.5M15 9l5.25-5.25M15 15h4.5M15 15v4.5m0-4.5l5.25 5.25"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsPointingInIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowsPointingOutIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowsPointingOutIcon.js"(exports, module) {
    var React = require_react();
    function ArrowsPointingOutIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsPointingOutIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowsRightLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowsRightLeftIcon.js"(exports, module) {
    var React = require_react();
    function ArrowsRightLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.5 21L3 16.5m0 0L7.5 12M3 16.5h13.5m0-13.5L21 7.5m0 0L16.5 12M21 7.5H7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsRightLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ArrowsUpDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ArrowsUpDownIcon.js"(exports, module) {
    var React = require_react();
    function ArrowsUpDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 7.5L7.5 3m0 0L12 7.5M7.5 3v13.5m13.5 0L16.5 21m0 0L12 16.5m4.5 4.5V7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ArrowsUpDownIcon);
    module.exports = ForwardRef;
  }
});
var require_AtSymbolIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/AtSymbolIcon.js"(exports, module) {
    var React = require_react();
    function AtSymbolIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        d: "M16.5 12a4.5 4.5 0 11-9 0 4.5 4.5 0 019 0zm0 0c0 1.657 1.007 3 2.25 3S21 13.657 21 12a9 9 0 10-2.636 6.364M16.5 12V8.25"
      }));
    }
    var ForwardRef = React.forwardRef(AtSymbolIcon);
    module.exports = ForwardRef;
  }
});
var require_BackspaceIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BackspaceIcon.js"(exports, module) {
    var React = require_react();
    function BackspaceIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 9.75L14.25 12m0 0l2.25 2.25M14.25 12l2.25-2.25M14.25 12L12 14.25m-2.58 4.92l-6.375-6.375a1.125 1.125 0 010-1.59L9.42 4.83c.211-.211.498-.33.796-.33H19.5a2.25 2.25 0 012.25 2.25v10.5a2.25 2.25 0 01-2.25 2.25h-9.284c-.298 0-.585-.119-.796-.33z"
      }));
    }
    var ForwardRef = React.forwardRef(BackspaceIcon);
    module.exports = ForwardRef;
  }
});
var require_BackwardIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BackwardIcon.js"(exports, module) {
    var React = require_react();
    function BackwardIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 16.811c0 .864-.933 1.405-1.683.977l-7.108-4.062a1.125 1.125 0 010-1.953l7.108-4.062A1.125 1.125 0 0121 8.688v8.123zM11.25 16.811c0 .864-.933 1.405-1.683.977l-7.108-4.062a1.125 1.125 0 010-1.953L9.567 7.71a1.125 1.125 0 011.683.977v8.123z"
      }));
    }
    var ForwardRef = React.forwardRef(BackwardIcon);
    module.exports = ForwardRef;
  }
});
var require_BanknotesIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BanknotesIcon.js"(exports, module) {
    var React = require_react();
    function BanknotesIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 18.75a60.07 60.07 0 0115.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 013 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 00-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 01-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 003 15h-.75M15 10.5a3 3 0 11-6 0 3 3 0 016 0zm3 0h.008v.008H18V10.5zm-12 0h.008v.008H6V10.5z"
      }));
    }
    var ForwardRef = React.forwardRef(BanknotesIcon);
    module.exports = ForwardRef;
  }
});
var require_Bars2Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Bars2Icon.js"(exports, module) {
    var React = require_react();
    function Bars2Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 9h16.5m-16.5 6.75h16.5"
      }));
    }
    var ForwardRef = React.forwardRef(Bars2Icon);
    module.exports = ForwardRef;
  }
});
var require_Bars3BottomLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Bars3BottomLeftIcon.js"(exports, module) {
    var React = require_react();
    function Bars3BottomLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25H12"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3BottomLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_Bars3BottomRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Bars3BottomRightIcon.js"(exports, module) {
    var React = require_react();
    function Bars3BottomRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 6.75h16.5M3.75 12h16.5M12 17.25h8.25"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3BottomRightIcon);
    module.exports = ForwardRef;
  }
});
var require_Bars3CenterLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Bars3CenterLeftIcon.js"(exports, module) {
    var React = require_react();
    function Bars3CenterLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 6.75h16.5M3.75 12H12m-8.25 5.25h16.5"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3CenterLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_Bars3Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Bars3Icon.js"(exports, module) {
    var React = require_react();
    function Bars3Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"
      }));
    }
    var ForwardRef = React.forwardRef(Bars3Icon);
    module.exports = ForwardRef;
  }
});
var require_Bars4Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Bars4Icon.js"(exports, module) {
    var React = require_react();
    function Bars4Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 5.25h16.5m-16.5 4.5h16.5m-16.5 4.5h16.5m-16.5 4.5h16.5"
      }));
    }
    var ForwardRef = React.forwardRef(Bars4Icon);
    module.exports = ForwardRef;
  }
});
var require_BarsArrowDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BarsArrowDownIcon.js"(exports, module) {
    var React = require_react();
    function BarsArrowDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 4.5h14.25M3 9h9.75M3 13.5h9.75m4.5-4.5v12m0 0l-3.75-3.75M17.25 21L21 17.25"
      }));
    }
    var ForwardRef = React.forwardRef(BarsArrowDownIcon);
    module.exports = ForwardRef;
  }
});
var require_BarsArrowUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BarsArrowUpIcon.js"(exports, module) {
    var React = require_react();
    function BarsArrowUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 4.5h14.25M3 9h9.75M3 13.5h5.25m5.25-.75L17.25 9m0 0L21 12.75M17.25 9v12"
      }));
    }
    var ForwardRef = React.forwardRef(BarsArrowUpIcon);
    module.exports = ForwardRef;
  }
});
var require_Battery0Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Battery0Icon.js"(exports, module) {
    var React = require_react();
    function Battery0Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 10.5h.375c.621 0 1.125.504 1.125 1.125v2.25c0 .621-.504 1.125-1.125 1.125H21M3.75 18h15A2.25 2.25 0 0021 15.75v-6a2.25 2.25 0 00-2.25-2.25h-15A2.25 2.25 0 001.5 9.75v6A2.25 2.25 0 003.75 18z"
      }));
    }
    var ForwardRef = React.forwardRef(Battery0Icon);
    module.exports = ForwardRef;
  }
});
var require_Battery100Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Battery100Icon.js"(exports, module) {
    var React = require_react();
    function Battery100Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 10.5h.375c.621 0 1.125.504 1.125 1.125v2.25c0 .621-.504 1.125-1.125 1.125H21M4.5 10.5H18V15H4.5v-4.5zM3.75 18h15A2.25 2.25 0 0021 15.75v-6a2.25 2.25 0 00-2.25-2.25h-15A2.25 2.25 0 001.5 9.75v6A2.25 2.25 0 003.75 18z"
      }));
    }
    var ForwardRef = React.forwardRef(Battery100Icon);
    module.exports = ForwardRef;
  }
});
var require_Battery50Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Battery50Icon.js"(exports, module) {
    var React = require_react();
    function Battery50Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 10.5h.375c.621 0 1.125.504 1.125 1.125v2.25c0 .621-.504 1.125-1.125 1.125H21M4.5 10.5h6.75V15H4.5v-4.5zM3.75 18h15A2.25 2.25 0 0021 15.75v-6a2.25 2.25 0 00-2.25-2.25h-15A2.25 2.25 0 001.5 9.75v6A2.25 2.25 0 003.75 18z"
      }));
    }
    var ForwardRef = React.forwardRef(Battery50Icon);
    module.exports = ForwardRef;
  }
});
var require_BeakerIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BeakerIcon.js"(exports, module) {
    var React = require_react();
    function BeakerIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.75 3.104v5.714a2.25 2.25 0 01-.659 1.591L5 14.5M9.75 3.104c-.251.023-.501.05-.75.082m.75-.082a24.301 24.301 0 014.5 0m0 0v5.714c0 .597.237 1.17.659 1.591L19.8 15.3M14.25 3.104c.251.023.501.05.75.082M19.8 15.3l-1.57.393A9.065 9.065 0 0112 15a9.065 9.065 0 00-6.23-.693L5 14.5m14.8.8l1.402 1.402c1.232 1.232.65 3.318-1.067 3.611A48.309 48.309 0 0112 21c-2.773 0-5.491-.235-8.135-.687-1.718-.293-2.3-2.379-1.067-3.61L5 14.5"
      }));
    }
    var ForwardRef = React.forwardRef(BeakerIcon);
    module.exports = ForwardRef;
  }
});
var require_BellAlertIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BellAlertIcon.js"(exports, module) {
    var React = require_react();
    function BellAlertIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.857 17.082a23.848 23.848 0 005.454-1.31A8.967 8.967 0 0118 9.75v-.7V9A6 6 0 006 9v.75a8.967 8.967 0 01-2.312 6.022c1.733.64 3.56 1.085 5.455 1.31m5.714 0a24.255 24.255 0 01-5.714 0m5.714 0a3 3 0 11-5.714 0M3.124 7.5A8.969 8.969 0 015.292 3m13.416 0a8.969 8.969 0 012.168 4.5"
      }));
    }
    var ForwardRef = React.forwardRef(BellAlertIcon);
    module.exports = ForwardRef;
  }
});
var require_BellSlashIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BellSlashIcon.js"(exports, module) {
    var React = require_react();
    function BellSlashIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.143 17.082a24.248 24.248 0 003.844.148m-3.844-.148a23.856 23.856 0 01-5.455-1.31 8.964 8.964 0 002.3-5.542m3.155 6.852a3 3 0 005.667 1.97m1.965-2.277L21 21m-4.225-4.225a23.81 23.81 0 003.536-1.003A8.967 8.967 0 0118 9.75V9A6 6 0 006.53 6.53m10.245 10.245L6.53 6.53M3 3l3.53 3.53"
      }));
    }
    var ForwardRef = React.forwardRef(BellSlashIcon);
    module.exports = ForwardRef;
  }
});
var require_BellSnoozeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BellSnoozeIcon.js"(exports, module) {
    var React = require_react();
    function BellSnoozeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.857 17.082a23.848 23.848 0 005.454-1.31A8.967 8.967 0 0118 9.75v-.7V9A6 6 0 006 9v.75a8.967 8.967 0 01-2.312 6.022c1.733.64 3.56 1.085 5.455 1.31m5.714 0a24.255 24.255 0 01-5.714 0m5.714 0a3 3 0 11-5.714 0M10.5 8.25h3l-3 4.5h3"
      }));
    }
    var ForwardRef = React.forwardRef(BellSnoozeIcon);
    module.exports = ForwardRef;
  }
});
var require_BellIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BellIcon.js"(exports, module) {
    var React = require_react();
    function BellIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.857 17.082a23.848 23.848 0 005.454-1.31A8.967 8.967 0 0118 9.75v-.7V9A6 6 0 006 9v.75a8.967 8.967 0 01-2.312 6.022c1.733.64 3.56 1.085 5.455 1.31m5.714 0a24.255 24.255 0 01-5.714 0m5.714 0a3 3 0 11-5.714 0"
      }));
    }
    var ForwardRef = React.forwardRef(BellIcon);
    module.exports = ForwardRef;
  }
});
var require_BoltSlashIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BoltSlashIcon.js"(exports, module) {
    var React = require_react();
    function BoltSlashIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M11.412 15.655L9.75 21.75l3.745-4.012M9.257 13.5H3.75l2.659-2.849m2.048-2.194L14.25 2.25 12 10.5h8.25l-4.707 5.043M8.457 8.457L3 3m5.457 5.457l7.086 7.086m0 0L21 21"
      }));
    }
    var ForwardRef = React.forwardRef(BoltSlashIcon);
    module.exports = ForwardRef;
  }
});
var require_BoltIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BoltIcon.js"(exports, module) {
    var React = require_react();
    function BoltIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z"
      }));
    }
    var ForwardRef = React.forwardRef(BoltIcon);
    module.exports = ForwardRef;
  }
});
var require_BookOpenIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BookOpenIcon.js"(exports, module) {
    var React = require_react();
    function BookOpenIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 6.042A8.967 8.967 0 006 3.75c-1.052 0-2.062.18-3 .512v14.25A8.987 8.987 0 016 18c2.305 0 4.408.867 6 2.292m0-14.25a8.966 8.966 0 016-2.292c1.052 0 2.062.18 3 .512v14.25A8.987 8.987 0 0018 18a8.967 8.967 0 00-6 2.292m0-14.25v14.25"
      }));
    }
    var ForwardRef = React.forwardRef(BookOpenIcon);
    module.exports = ForwardRef;
  }
});
var require_BookmarkSlashIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BookmarkSlashIcon.js"(exports, module) {
    var React = require_react();
    function BookmarkSlashIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 3l1.664 1.664M21 21l-1.5-1.5m-5.485-1.242L12 17.25 4.5 21V8.742m.164-4.078a2.15 2.15 0 011.743-1.342 48.507 48.507 0 0111.186 0c1.1.128 1.907 1.077 1.907 2.185V19.5M4.664 4.664L19.5 19.5"
      }));
    }
    var ForwardRef = React.forwardRef(BookmarkSlashIcon);
    module.exports = ForwardRef;
  }
});
var require_BookmarkSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BookmarkSquareIcon.js"(exports, module) {
    var React = require_react();
    function BookmarkSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.5 3.75V16.5L12 14.25 7.5 16.5V3.75m9 0H18A2.25 2.25 0 0120.25 6v12A2.25 2.25 0 0118 20.25H6A2.25 2.25 0 013.75 18V6A2.25 2.25 0 016 3.75h1.5m9 0h-9"
      }));
    }
    var ForwardRef = React.forwardRef(BookmarkSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_BookmarkIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BookmarkIcon.js"(exports, module) {
    var React = require_react();
    function BookmarkIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17.593 3.322c1.1.128 1.907 1.077 1.907 2.185V21L12 17.25 4.5 21V5.507c0-1.108.806-2.057 1.907-2.185a48.507 48.507 0 0111.186 0z"
      }));
    }
    var ForwardRef = React.forwardRef(BookmarkIcon);
    module.exports = ForwardRef;
  }
});
var require_BriefcaseIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BriefcaseIcon.js"(exports, module) {
    var React = require_react();
    function BriefcaseIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.25 14.15v4.25c0 1.094-.787 2.036-1.872 2.18-2.087.277-4.216.42-6.378.42s-4.291-.143-6.378-.42c-1.085-.144-1.872-1.086-1.872-2.18v-4.25m16.5 0a2.18 2.18 0 00.75-1.661V8.706c0-1.081-.768-2.015-1.837-2.175a48.114 48.114 0 00-3.413-.387m4.5 8.006c-.194.165-.42.295-.673.38A23.978 23.978 0 0112 15.75c-2.648 0-5.195-.429-7.577-1.22a2.016 2.016 0 01-.673-.38m0 0A2.18 2.18 0 013 12.489V8.706c0-1.081.768-2.015 1.837-2.175a48.111 48.111 0 013.413-.387m7.5 0V5.25A2.25 2.25 0 0013.5 3h-3a2.25 2.25 0 00-2.25 2.25v.894m7.5 0a48.667 48.667 0 00-7.5 0M12 12.75h.008v.008H12v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(BriefcaseIcon);
    module.exports = ForwardRef;
  }
});
var require_BugAntIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BugAntIcon.js"(exports, module) {
    var React = require_react();
    function BugAntIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 12.75c1.148 0 2.278.08 3.383.237 1.037.146 1.866.966 1.866 2.013 0 3.728-2.35 6.75-5.25 6.75S6.75 18.728 6.75 15c0-1.046.83-1.867 1.866-2.013A24.204 24.204 0 0112 12.75zm0 0c2.883 0 5.647.508 8.207 1.44a23.91 23.91 0 01-1.152 6.06M12 12.75c-2.883 0-5.647.508-8.208 1.44.125 2.104.52 4.136 1.153 6.06M12 12.75a2.25 2.25 0 002.248-2.354M12 12.75a2.25 2.25 0 01-2.248-2.354M12 8.25c.995 0 1.971-.08 2.922-.236.403-.066.74-.358.795-.762a3.778 3.778 0 00-.399-2.25M12 8.25c-.995 0-1.97-.08-2.922-.236-.402-.066-.74-.358-.795-.762a3.734 3.734 0 01.4-2.253M12 8.25a2.25 2.25 0 00-2.248 2.146M12 8.25a2.25 2.25 0 012.248 2.146M8.683 5a6.032 6.032 0 01-1.155-1.002c.07-.63.27-1.222.574-1.747m.581 2.749A3.75 3.75 0 0115.318 5m0 0c.427-.283.815-.62 1.155-.999a4.471 4.471 0 00-.575-1.752M4.921 6a24.048 24.048 0 00-.392 3.314c1.668.546 3.416.914 5.223 1.082M19.08 6c.205 1.08.337 2.187.392 3.314a23.882 23.882 0 01-5.223 1.082"
      }));
    }
    var ForwardRef = React.forwardRef(BugAntIcon);
    module.exports = ForwardRef;
  }
});
var require_BuildingLibraryIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BuildingLibraryIcon.js"(exports, module) {
    var React = require_react();
    function BuildingLibraryIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 21v-8.25M15.75 21v-8.25M8.25 21v-8.25M3 9l9-6 9 6m-1.5 12V10.332A48.36 48.36 0 0012 9.75c-2.551 0-5.056.2-7.5.582V21M3 21h18M12 6.75h.008v.008H12V6.75z"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingLibraryIcon);
    module.exports = ForwardRef;
  }
});
var require_BuildingOffice2Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BuildingOffice2Icon.js"(exports, module) {
    var React = require_react();
    function BuildingOffice2Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 21h19.5m-18-18v18m10.5-18v18m6-13.5V21M6.75 6.75h.75m-.75 3h.75m-.75 3h.75m3-6h.75m-.75 3h.75m-.75 3h.75M6.75 21v-3.375c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21M3 3h12m-.75 4.5H21m-3.75 3.75h.008v.008h-.008v-.008zm0 3h.008v.008h-.008v-.008zm0 3h.008v.008h-.008v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingOffice2Icon);
    module.exports = ForwardRef;
  }
});
var require_BuildingOfficeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BuildingOfficeIcon.js"(exports, module) {
    var React = require_react();
    function BuildingOfficeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 21h16.5M4.5 3h15M5.25 3v18m13.5-18v18M9 6.75h1.5m-1.5 3h1.5m-1.5 3h1.5m3-6H15m-1.5 3H15m-1.5 3H15M9 21v-3.375c0-.621.504-1.125 1.125-1.125h3.75c.621 0 1.125.504 1.125 1.125V21"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingOfficeIcon);
    module.exports = ForwardRef;
  }
});
var require_BuildingStorefrontIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/BuildingStorefrontIcon.js"(exports, module) {
    var React = require_react();
    function BuildingStorefrontIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13.5 21v-7.5a.75.75 0 01.75-.75h3a.75.75 0 01.75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349m-16.5 11.65V9.35m0 0a3.001 3.001 0 003.75-.615A2.993 2.993 0 009.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 002.25 1.016c.896 0 1.7-.393 2.25-1.016a3.001 3.001 0 003.75.614m-16.5 0a3.004 3.004 0 01-.621-4.72L4.318 3.44A1.5 1.5 0 015.378 3h13.243a1.5 1.5 0 011.06.44l1.19 1.189a3 3 0 01-.621 4.72m-13.5 8.65h3.75a.75.75 0 00.75-.75V13.5a.75.75 0 00-.75-.75H6.75a.75.75 0 00-.75.75v3.75c0 .415.336.75.75.75z"
      }));
    }
    var ForwardRef = React.forwardRef(BuildingStorefrontIcon);
    module.exports = ForwardRef;
  }
});
var require_CakeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CakeIcon.js"(exports, module) {
    var React = require_react();
    function CakeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 8.25v-1.5m0 1.5c-1.355 0-2.697.056-4.024.166C6.845 8.51 6 9.473 6 10.608v2.513m6-4.87c1.355 0 2.697.055 4.024.165C17.155 8.51 18 9.473 18 10.608v2.513m-3-4.87v-1.5m-6 1.5v-1.5m12 9.75l-1.5.75a3.354 3.354 0 01-3 0 3.354 3.354 0 00-3 0 3.354 3.354 0 01-3 0 3.354 3.354 0 00-3 0 3.354 3.354 0 01-3 0L3 16.5m15-3.38a48.474 48.474 0 00-6-.37c-2.032 0-4.034.125-6 .37m12 0c.39.049.777.102 1.163.16 1.07.16 1.837 1.094 1.837 2.175v5.17c0 .62-.504 1.124-1.125 1.124H4.125A1.125 1.125 0 013 20.625v-5.17c0-1.08.768-2.014 1.837-2.174A47.78 47.78 0 016 13.12M12.265 3.11a.375.375 0 11-.53 0L12 2.845l.265.265zm-3 0a.375.375 0 11-.53 0L9 2.845l.265.265zm6 0a.375.375 0 11-.53 0L15 2.845l.265.265z"
      }));
    }
    var ForwardRef = React.forwardRef(CakeIcon);
    module.exports = ForwardRef;
  }
});
var require_CalculatorIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CalculatorIcon.js"(exports, module) {
    var React = require_react();
    function CalculatorIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 15.75V18m-7.5-6.75h.008v.008H8.25v-.008zm0 2.25h.008v.008H8.25V13.5zm0 2.25h.008v.008H8.25v-.008zm0 2.25h.008v.008H8.25V18zm2.498-6.75h.007v.008h-.007v-.008zm0 2.25h.007v.008h-.007V13.5zm0 2.25h.007v.008h-.007v-.008zm0 2.25h.007v.008h-.007V18zm2.504-6.75h.008v.008h-.008v-.008zm0 2.25h.008v.008h-.008V13.5zm0 2.25h.008v.008h-.008v-.008zm0 2.25h.008v.008h-.008V18zm2.498-6.75h.008v.008h-.008v-.008zm0 2.25h.008v.008h-.008V13.5zM8.25 6h7.5v2.25h-7.5V6zM12 2.25c-1.892 0-3.758.11-5.593.322C5.307 2.7 4.5 3.65 4.5 4.757V19.5a2.25 2.25 0 002.25 2.25h10.5a2.25 2.25 0 002.25-2.25V4.757c0-1.108-.806-2.057-1.907-2.185A48.507 48.507 0 0012 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(CalculatorIcon);
    module.exports = ForwardRef;
  }
});
var require_CalendarDaysIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CalendarDaysIcon.js"(exports, module) {
    var React = require_react();
    function CalendarDaysIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 012.25-2.25h13.5A2.25 2.25 0 0121 7.5v11.25m-18 0A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75m-18 0v-7.5A2.25 2.25 0 015.25 9h13.5A2.25 2.25 0 0121 11.25v7.5m-9-6h.008v.008H12v-.008zM12 15h.008v.008H12V15zm0 2.25h.008v.008H12v-.008zM9.75 15h.008v.008H9.75V15zm0 2.25h.008v.008H9.75v-.008zM7.5 15h.008v.008H7.5V15zm0 2.25h.008v.008H7.5v-.008zm6.75-4.5h.008v.008h-.008v-.008zm0 2.25h.008v.008h-.008V15zm0 2.25h.008v.008h-.008v-.008zm2.25-4.5h.008v.008H16.5v-.008zm0 2.25h.008v.008H16.5V15z"
      }));
    }
    var ForwardRef = React.forwardRef(CalendarDaysIcon);
    module.exports = ForwardRef;
  }
});
var require_CalendarIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CalendarIcon.js"(exports, module) {
    var React = require_react();
    function CalendarIcon2(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.75 3v2.25M17.25 3v2.25M3 18.75V7.5a2.25 2.25 0 012.25-2.25h13.5A2.25 2.25 0 0121 7.5v11.25m-18 0A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75m-18 0v-7.5A2.25 2.25 0 015.25 9h13.5A2.25 2.25 0 0121 11.25v7.5"
      }));
    }
    var ForwardRef = React.forwardRef(CalendarIcon2);
    module.exports = ForwardRef;
  }
});
var require_CameraIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CameraIcon.js"(exports, module) {
    var React = require_react();
    function CameraIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.827 6.175A2.31 2.31 0 015.186 7.23c-.38.054-.757.112-1.134.175C2.999 7.58 2.25 8.507 2.25 9.574V18a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18V9.574c0-1.067-.75-1.994-1.802-2.169a47.865 47.865 0 00-1.134-.175 2.31 2.31 0 01-1.64-1.055l-.822-1.316a2.192 2.192 0 00-1.736-1.039 48.774 48.774 0 00-5.232 0 2.192 2.192 0 00-1.736 1.039l-.821 1.316z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.5 12.75a4.5 4.5 0 11-9 0 4.5 4.5 0 019 0zM18.75 10.5h.008v.008h-.008V10.5z"
      }));
    }
    var ForwardRef = React.forwardRef(CameraIcon);
    module.exports = ForwardRef;
  }
});
var require_ChartBarSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChartBarSquareIcon.js"(exports, module) {
    var React = require_react();
    function ChartBarSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.5 14.25v2.25m3-4.5v4.5m3-6.75v6.75m3-9v9M6 20.25h12A2.25 2.25 0 0020.25 18V6A2.25 2.25 0 0018 3.75H6A2.25 2.25 0 003.75 6v12A2.25 2.25 0 006 20.25z"
      }));
    }
    var ForwardRef = React.forwardRef(ChartBarSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_ChartBarIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChartBarIcon.js"(exports, module) {
    var React = require_react();
    function ChartBarIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 013 19.875v-6.75zM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V8.625zM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V4.125z"
      }));
    }
    var ForwardRef = React.forwardRef(ChartBarIcon);
    module.exports = ForwardRef;
  }
});
var require_ChartPieIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChartPieIcon.js"(exports, module) {
    var React = require_react();
    function ChartPieIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.5 6a7.5 7.5 0 107.5 7.5h-7.5V6z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13.5 10.5H21A7.5 7.5 0 0013.5 3v7.5z"
      }));
    }
    var ForwardRef = React.forwardRef(ChartPieIcon);
    module.exports = ForwardRef;
  }
});
var require_ChatBubbleBottomCenterTextIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChatBubbleBottomCenterTextIcon.js"(exports, module) {
    var React = require_react();
    function ChatBubbleBottomCenterTextIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.5 8.25h9m-9 3H12m-9.75 1.51c0 1.6 1.123 2.994 2.707 3.227 1.129.166 2.27.293 3.423.379.35.026.67.21.865.501L12 21l2.755-4.133a1.14 1.14 0 01.865-.501 48.172 48.172 0 003.423-.379c1.584-.233 2.707-1.626 2.707-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0012 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018z"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleBottomCenterTextIcon);
    module.exports = ForwardRef;
  }
});
var require_ChatBubbleBottomCenterIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChatBubbleBottomCenterIcon.js"(exports, module) {
    var React = require_react();
    function ChatBubbleBottomCenterIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 12.76c0 1.6 1.123 2.994 2.707 3.227 1.068.157 2.148.279 3.238.364.466.037.893.281 1.153.671L12 21l2.652-3.978c.26-.39.687-.634 1.153-.67 1.09-.086 2.17-.208 3.238-.365 1.584-.233 2.707-1.626 2.707-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0012 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018z"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleBottomCenterIcon);
    module.exports = ForwardRef;
  }
});
var require_ChatBubbleLeftEllipsisIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChatBubbleLeftEllipsisIcon.js"(exports, module) {
    var React = require_react();
    function ChatBubbleLeftEllipsisIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.625 9.75a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H8.25m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H12m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0h-.375m-13.5 3.01c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.184-4.183a1.14 1.14 0 01.778-.332 48.294 48.294 0 005.83-.498c1.585-.233 2.708-1.626 2.708-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0012 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018z"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleLeftEllipsisIcon);
    module.exports = ForwardRef;
  }
});
var require_ChatBubbleLeftRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChatBubbleLeftRightIcon.js"(exports, module) {
    var React = require_react();
    function ChatBubbleLeftRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.25 8.511c.884.284 1.5 1.128 1.5 2.097v4.286c0 1.136-.847 2.1-1.98 2.193-.34.027-.68.052-1.02.072v3.091l-3-3c-1.354 0-2.694-.055-4.02-.163a2.115 2.115 0 01-.825-.242m9.345-8.334a2.126 2.126 0 00-.476-.095 48.64 48.64 0 00-8.048 0c-1.131.094-1.976 1.057-1.976 2.192v4.286c0 .837.46 1.58 1.155 1.951m9.345-8.334V6.637c0-1.621-1.152-3.026-2.76-3.235A48.455 48.455 0 0011.25 3c-2.115 0-4.198.137-6.24.402-1.608.209-2.76 1.614-2.76 3.235v6.226c0 1.621 1.152 3.026 2.76 3.235.577.075 1.157.14 1.74.194V21l4.155-4.155"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleLeftRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ChatBubbleLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChatBubbleLeftIcon.js"(exports, module) {
    var React = require_react();
    function ChatBubbleLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 12.76c0 1.6 1.123 2.994 2.707 3.227 1.087.16 2.185.283 3.293.369V21l4.076-4.076a1.526 1.526 0 011.037-.443 48.282 48.282 0 005.68-.494c1.584-.233 2.707-1.626 2.707-3.228V6.741c0-1.602-1.123-2.995-2.707-3.228A48.394 48.394 0 0012 3c-2.392 0-4.744.175-7.043.513C3.373 3.746 2.25 5.14 2.25 6.741v6.018z"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ChatBubbleOvalLeftEllipsisIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChatBubbleOvalLeftEllipsisIcon.js"(exports, module) {
    var React = require_react();
    function ChatBubbleOvalLeftEllipsisIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.625 12a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H8.25m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H12m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0h-.375M21 12c0 4.556-4.03 8.25-9 8.25a9.764 9.764 0 01-2.555-.337A5.972 5.972 0 015.41 20.97a5.969 5.969 0 01-.474-.065 4.48 4.48 0 00.978-2.025c.09-.457-.133-.901-.467-1.226C3.93 16.178 3 14.189 3 12c0-4.556 4.03-8.25 9-8.25s9 3.694 9 8.25z"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleOvalLeftEllipsisIcon);
    module.exports = ForwardRef;
  }
});
var require_ChatBubbleOvalLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChatBubbleOvalLeftIcon.js"(exports, module) {
    var React = require_react();
    function ChatBubbleOvalLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 20.25c4.97 0 9-3.694 9-8.25s-4.03-8.25-9-8.25S3 7.444 3 12c0 2.104.859 4.023 2.273 5.48.432.447.74 1.04.586 1.641a4.483 4.483 0 01-.923 1.785A5.969 5.969 0 006 21c1.282 0 2.47-.402 3.445-1.087.81.22 1.668.337 2.555.337z"
      }));
    }
    var ForwardRef = React.forwardRef(ChatBubbleOvalLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_CheckBadgeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CheckBadgeIcon.js"(exports, module) {
    var React = require_react();
    function CheckBadgeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 12.75L11.25 15 15 9.75M21 12c0 1.268-.63 2.39-1.593 3.068a3.745 3.745 0 01-1.043 3.296 3.745 3.745 0 01-3.296 1.043A3.745 3.745 0 0112 21c-1.268 0-2.39-.63-3.068-1.593a3.746 3.746 0 01-3.296-1.043 3.745 3.745 0 01-1.043-3.296A3.745 3.745 0 013 12c0-1.268.63-2.39 1.593-3.068a3.745 3.745 0 011.043-3.296 3.746 3.746 0 013.296-1.043A3.746 3.746 0 0112 3c1.268 0 2.39.63 3.068 1.593a3.746 3.746 0 013.296 1.043 3.746 3.746 0 011.043 3.296A3.745 3.745 0 0121 12z"
      }));
    }
    var ForwardRef = React.forwardRef(CheckBadgeIcon);
    module.exports = ForwardRef;
  }
});
var require_CheckCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CheckCircleIcon.js"(exports, module) {
    var React = require_react();
    function CheckCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CheckCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_CheckIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CheckIcon.js"(exports, module) {
    var React = require_react();
    function CheckIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 12.75l6 6 9-13.5"
      }));
    }
    var ForwardRef = React.forwardRef(CheckIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronDoubleDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronDoubleDownIcon.js"(exports, module) {
    var React = require_react();
    function ChevronDoubleDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 5.25l-7.5 7.5-7.5-7.5m15 6l-7.5 7.5-7.5-7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronDoubleLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronDoubleLeftIcon.js"(exports, module) {
    var React = require_react();
    function ChevronDoubleLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M18.75 19.5l-7.5-7.5 7.5-7.5m-6 15L5.25 12l7.5-7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronDoubleRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronDoubleRightIcon.js"(exports, module) {
    var React = require_react();
    function ChevronDoubleRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M11.25 4.5l7.5 7.5-7.5 7.5m-6-15l7.5 7.5-7.5 7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronDoubleUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronDoubleUpIcon.js"(exports, module) {
    var React = require_react();
    function ChevronDoubleUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 12.75l7.5-7.5 7.5 7.5m-15 6l7.5-7.5 7.5 7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDoubleUpIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronDownIcon.js"(exports, module) {
    var React = require_react();
    function ChevronDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 8.25l-7.5 7.5-7.5-7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronLeftIcon.js"(exports, module) {
    var React = require_react();
    function ChevronLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 19.5L8.25 12l7.5-7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronRightIcon.js"(exports, module) {
    var React = require_react();
    function ChevronRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 4.5l7.5 7.5-7.5 7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronRightIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronUpDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronUpDownIcon.js"(exports, module) {
    var React = require_react();
    function ChevronUpDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 15L12 18.75 15.75 15m-7.5-6L12 5.25 15.75 9"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronUpDownIcon);
    module.exports = ForwardRef;
  }
});
var require_ChevronUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ChevronUpIcon.js"(exports, module) {
    var React = require_react();
    function ChevronUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 15.75l7.5-7.5 7.5 7.5"
      }));
    }
    var ForwardRef = React.forwardRef(ChevronUpIcon);
    module.exports = ForwardRef;
  }
});
var require_CircleStackIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CircleStackIcon.js"(exports, module) {
    var React = require_react();
    function CircleStackIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.25 6.375c0 2.278-3.694 4.125-8.25 4.125S3.75 8.653 3.75 6.375m16.5 0c0-2.278-3.694-4.125-8.25-4.125S3.75 4.097 3.75 6.375m16.5 0v11.25c0 2.278-3.694 4.125-8.25 4.125s-8.25-1.847-8.25-4.125V6.375m16.5 0v3.75m-16.5-3.75v3.75m16.5 0v3.75C20.25 16.153 16.556 18 12 18s-8.25-1.847-8.25-4.125v-3.75m16.5 0c0 2.278-3.694 4.125-8.25 4.125s-8.25-1.847-8.25-4.125"
      }));
    }
    var ForwardRef = React.forwardRef(CircleStackIcon);
    module.exports = ForwardRef;
  }
});
var require_ClipboardDocumentCheckIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ClipboardDocumentCheckIcon.js"(exports, module) {
    var React = require_react();
    function ClipboardDocumentCheckIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M11.35 3.836c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 00.75-.75 2.25 2.25 0 00-.1-.664m-5.8 0A2.251 2.251 0 0113.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m8.9-4.414c.376.023.75.05 1.124.08 1.131.094 1.976 1.057 1.976 2.192V16.5A2.25 2.25 0 0118 18.75h-2.25m-7.5-10.5H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V18.75m-7.5-10.5h6.375c.621 0 1.125.504 1.125 1.125v9.375m-8.25-3l1.5 1.5 3-3.75"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardDocumentCheckIcon);
    module.exports = ForwardRef;
  }
});
var require_ClipboardDocumentListIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ClipboardDocumentListIcon.js"(exports, module) {
    var React = require_react();
    function ClipboardDocumentListIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 12h3.75M9 15h3.75M9 18h3.75m3 .75H18a2.25 2.25 0 002.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 00-1.123-.08m-5.801 0c-.065.21-.1.433-.1.664 0 .414.336.75.75.75h4.5a.75.75 0 00.75-.75 2.25 2.25 0 00-.1-.664m-5.8 0A2.251 2.251 0 0113.5 2.25H15c1.012 0 1.867.668 2.15 1.586m-5.8 0c-.376.023-.75.05-1.124.08C9.095 4.01 8.25 4.973 8.25 6.108V8.25m0 0H4.875c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V9.375c0-.621-.504-1.125-1.125-1.125H8.25zM6.75 12h.008v.008H6.75V12zm0 3h.008v.008H6.75V15zm0 3h.008v.008H6.75V18z"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardDocumentListIcon);
    module.exports = ForwardRef;
  }
});
var require_ClipboardDocumentIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ClipboardDocumentIcon.js"(exports, module) {
    var React = require_react();
    function ClipboardDocumentIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 7.5V6.108c0-1.135.845-2.098 1.976-2.192.373-.03.748-.057 1.123-.08M15.75 18H18a2.25 2.25 0 002.25-2.25V6.108c0-1.135-.845-2.098-1.976-2.192a48.424 48.424 0 00-1.123-.08M15.75 18.75v-1.875a3.375 3.375 0 00-3.375-3.375h-1.5a1.125 1.125 0 01-1.125-1.125v-1.5A3.375 3.375 0 006.375 7.5H5.25m11.9-3.664A2.251 2.251 0 0015 2.25h-1.5a2.251 2.251 0 00-2.15 1.586m5.8 0c.065.21.1.433.1.664v.75h-6V4.5c0-.231.035-.454.1-.664M6.75 7.5H4.875c-.621 0-1.125.504-1.125 1.125v12c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125V16.5a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardDocumentIcon);
    module.exports = ForwardRef;
  }
});
var require_ClipboardIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ClipboardIcon.js"(exports, module) {
    var React = require_react();
    function ClipboardIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.666 3.888A2.25 2.25 0 0013.5 2.25h-3c-1.03 0-1.9.693-2.166 1.638m7.332 0c.055.194.084.4.084.612v0a.75.75 0 01-.75.75H9a.75.75 0 01-.75-.75v0c0-.212.03-.418.084-.612m7.332 0c.646.049 1.288.11 1.927.184 1.1.128 1.907 1.077 1.907 2.185V19.5a2.25 2.25 0 01-2.25 2.25H6.75A2.25 2.25 0 014.5 19.5V6.257c0-1.108.806-2.057 1.907-2.185a48.208 48.208 0 011.927-.184"
      }));
    }
    var ForwardRef = React.forwardRef(ClipboardIcon);
    module.exports = ForwardRef;
  }
});
var require_ClockIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ClockIcon.js"(exports, module) {
    var React = require_react();
    function ClockIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 6v6h4.5m4.5 0a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ClockIcon);
    module.exports = ForwardRef;
  }
});
var require_CloudArrowDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CloudArrowDownIcon.js"(exports, module) {
    var React = require_react();
    function CloudArrowDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 9.75v6.75m0 0l-3-3m3 3l3-3m-8.25 6a4.5 4.5 0 01-1.41-8.775 5.25 5.25 0 0110.233-2.33 3 3 0 013.758 3.848A3.752 3.752 0 0118 19.5H6.75z"
      }));
    }
    var ForwardRef = React.forwardRef(CloudArrowDownIcon);
    module.exports = ForwardRef;
  }
});
var require_CloudArrowUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CloudArrowUpIcon.js"(exports, module) {
    var React = require_react();
    function CloudArrowUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 16.5V9.75m0 0l3 3m-3-3l-3 3M6.75 19.5a4.5 4.5 0 01-1.41-8.775 5.25 5.25 0 0110.233-2.33 3 3 0 013.758 3.848A3.752 3.752 0 0118 19.5H6.75z"
      }));
    }
    var ForwardRef = React.forwardRef(CloudArrowUpIcon);
    module.exports = ForwardRef;
  }
});
var require_CloudIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CloudIcon.js"(exports, module) {
    var React = require_react();
    function CloudIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 15a4.5 4.5 0 004.5 4.5H18a3.75 3.75 0 001.332-7.257 3 3 0 00-3.758-3.848 5.25 5.25 0 00-10.233 2.33A4.502 4.502 0 002.25 15z"
      }));
    }
    var ForwardRef = React.forwardRef(CloudIcon);
    module.exports = ForwardRef;
  }
});
var require_CodeBracketSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CodeBracketSquareIcon.js"(exports, module) {
    var React = require_react();
    function CodeBracketSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.25 9.75L16.5 12l-2.25 2.25m-4.5 0L7.5 12l2.25-2.25M6 20.25h12A2.25 2.25 0 0020.25 18V6A2.25 2.25 0 0018 3.75H6A2.25 2.25 0 003.75 6v12A2.25 2.25 0 006 20.25z"
      }));
    }
    var ForwardRef = React.forwardRef(CodeBracketSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_CodeBracketIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CodeBracketIcon.js"(exports, module) {
    var React = require_react();
    function CodeBracketIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17.25 6.75L22.5 12l-5.25 5.25m-10.5 0L1.5 12l5.25-5.25m7.5-3l-4.5 16.5"
      }));
    }
    var ForwardRef = React.forwardRef(CodeBracketIcon);
    module.exports = ForwardRef;
  }
});
var require_Cog6ToothIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Cog6ToothIcon.js"(exports, module) {
    var React = require_react();
    function Cog6ToothIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.324.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 011.37.49l1.296 2.247a1.125 1.125 0 01-.26 1.431l-1.003.827c-.293.24-.438.613-.431.992a6.759 6.759 0 010 .255c-.007.378.138.75.43.99l1.005.828c.424.35.534.954.26 1.43l-1.298 2.247a1.125 1.125 0 01-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.57 6.57 0 01-.22.128c-.331.183-.581.495-.644.869l-.213 1.28c-.09.543-.56.941-1.11.941h-2.594c-.55 0-1.02-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 01-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 01-1.369-.49l-1.297-2.247a1.125 1.125 0 01.26-1.431l1.004-.827c.292-.24.437-.613.43-.992a6.932 6.932 0 010-.255c.007-.378-.138-.75-.43-.99l-1.004-.828a1.125 1.125 0 01-.26-1.43l1.297-2.247a1.125 1.125 0 011.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.087.22-.128.332-.183.582-.495.644-.869l.214-1.281z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z"
      }));
    }
    var ForwardRef = React.forwardRef(Cog6ToothIcon);
    module.exports = ForwardRef;
  }
});
var require_Cog8ToothIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Cog8ToothIcon.js"(exports, module) {
    var React = require_react();
    function Cog8ToothIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.343 3.94c.09-.542.56-.94 1.11-.94h1.093c.55 0 1.02.398 1.11.94l.149.894c.07.424.384.764.78.93.398.164.855.142 1.205-.108l.737-.527a1.125 1.125 0 011.45.12l.773.774c.39.389.44 1.002.12 1.45l-.527.737c-.25.35-.272.806-.107 1.204.165.397.505.71.93.78l.893.15c.543.09.94.56.94 1.109v1.094c0 .55-.397 1.02-.94 1.11l-.893.149c-.425.07-.765.383-.93.78-.165.398-.143.854.107 1.204l.527.738c.32.447.269 1.06-.12 1.45l-.774.773a1.125 1.125 0 01-1.449.12l-.738-.527c-.35-.25-.806-.272-1.203-.107-.397.165-.71.505-.781.929l-.149.894c-.09.542-.56.94-1.11.94h-1.094c-.55 0-1.019-.398-1.11-.94l-.148-.894c-.071-.424-.384-.764-.781-.93-.398-.164-.854-.142-1.204.108l-.738.527c-.447.32-1.06.269-1.45-.12l-.773-.774a1.125 1.125 0 01-.12-1.45l.527-.737c.25-.35.273-.806.108-1.204-.165-.397-.505-.71-.93-.78l-.894-.15c-.542-.09-.94-.56-.94-1.109v-1.094c0-.55.398-1.02.94-1.11l.894-.149c.424-.07.765-.383.93-.78.165-.398.143-.854-.107-1.204l-.527-.738a1.125 1.125 0 01.12-1.45l.773-.773a1.125 1.125 0 011.45-.12l.737.527c.35.25.807.272 1.204.107.397-.165.71-.505.78-.929l.15-.894z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z"
      }));
    }
    var ForwardRef = React.forwardRef(Cog8ToothIcon);
    module.exports = ForwardRef;
  }
});
var require_CogIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CogIcon.js"(exports, module) {
    var React = require_react();
    function CogIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.5 12a7.5 7.5 0 0015 0m-15 0a7.5 7.5 0 1115 0m-15 0H3m16.5 0H21m-1.5 0H12m-8.457 3.077l1.41-.513m14.095-5.13l1.41-.513M5.106 17.785l1.15-.964m11.49-9.642l1.149-.964M7.501 19.795l.75-1.3m7.5-12.99l.75-1.3m-6.063 16.658l.26-1.477m2.605-14.772l.26-1.477m0 17.726l-.26-1.477M10.698 4.614l-.26-1.477M16.5 19.794l-.75-1.299M7.5 4.205L12 12m6.894 5.785l-1.149-.964M6.256 7.178l-1.15-.964m15.352 8.864l-1.41-.513M4.954 9.435l-1.41-.514M12.002 12l-3.75 6.495"
      }));
    }
    var ForwardRef = React.forwardRef(CogIcon);
    module.exports = ForwardRef;
  }
});
var require_CommandLineIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CommandLineIcon.js"(exports, module) {
    var React = require_react();
    function CommandLineIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.75 7.5l3 2.25-3 2.25m4.5 0h3m-9 8.25h13.5A2.25 2.25 0 0021 18V6a2.25 2.25 0 00-2.25-2.25H5.25A2.25 2.25 0 003 6v12a2.25 2.25 0 002.25 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(CommandLineIcon);
    module.exports = ForwardRef;
  }
});
var require_ComputerDesktopIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ComputerDesktopIcon.js"(exports, module) {
    var React = require_react();
    function ComputerDesktopIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 17.25v1.007a3 3 0 01-.879 2.122L7.5 21h9l-.621-.621A3 3 0 0115 18.257V17.25m6-12V15a2.25 2.25 0 01-2.25 2.25H5.25A2.25 2.25 0 013 15V5.25m18 0A2.25 2.25 0 0018.75 3H5.25A2.25 2.25 0 003 5.25m18 0V12a2.25 2.25 0 01-2.25 2.25H5.25A2.25 2.25 0 013 12V5.25"
      }));
    }
    var ForwardRef = React.forwardRef(ComputerDesktopIcon);
    module.exports = ForwardRef;
  }
});
var require_CpuChipIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CpuChipIcon.js"(exports, module) {
    var React = require_react();
    function CpuChipIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 3v1.5M4.5 8.25H3m18 0h-1.5M4.5 12H3m18 0h-1.5m-15 3.75H3m18 0h-1.5M8.25 19.5V21M12 3v1.5m0 15V21m3.75-18v1.5m0 15V21m-9-1.5h10.5a2.25 2.25 0 002.25-2.25V6.75a2.25 2.25 0 00-2.25-2.25H6.75A2.25 2.25 0 004.5 6.75v10.5a2.25 2.25 0 002.25 2.25zm.75-12h9v9h-9v-9z"
      }));
    }
    var ForwardRef = React.forwardRef(CpuChipIcon);
    module.exports = ForwardRef;
  }
});
var require_CreditCardIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CreditCardIcon.js"(exports, module) {
    var React = require_react();
    function CreditCardIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 8.25h19.5M2.25 9h19.5m-16.5 5.25h6m-6 2.25h3m-3.75 3h15a2.25 2.25 0 002.25-2.25V6.75A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25v10.5A2.25 2.25 0 004.5 19.5z"
      }));
    }
    var ForwardRef = React.forwardRef(CreditCardIcon);
    module.exports = ForwardRef;
  }
});
var require_CubeTransparentIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CubeTransparentIcon.js"(exports, module) {
    var React = require_react();
    function CubeTransparentIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 7.5l-2.25-1.313M21 7.5v2.25m0-2.25l-2.25 1.313M3 7.5l2.25-1.313M3 7.5l2.25 1.313M3 7.5v2.25m9 3l2.25-1.313M12 12.75l-2.25-1.313M12 12.75V15m0 6.75l2.25-1.313M12 21.75V19.5m0 2.25l-2.25-1.313m0-16.875L12 2.25l2.25 1.313M21 14.25v2.25l-2.25 1.313m-13.5 0L3 16.5v-2.25"
      }));
    }
    var ForwardRef = React.forwardRef(CubeTransparentIcon);
    module.exports = ForwardRef;
  }
});
var require_CubeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CubeIcon.js"(exports, module) {
    var React = require_react();
    function CubeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 7.5l-9-5.25L3 7.5m18 0l-9 5.25m9-5.25v9l-9 5.25M3 7.5l9 5.25M3 7.5v9l9 5.25m0-9v9"
      }));
    }
    var ForwardRef = React.forwardRef(CubeIcon);
    module.exports = ForwardRef;
  }
});
var require_CurrencyBangladeshiIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CurrencyBangladeshiIcon.js"(exports, module) {
    var React = require_react();
    function CurrencyBangladeshiIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 7.5l.415-.207a.75.75 0 011.085.67V10.5m0 0h6m-6 0h-1.5m1.5 0v5.438c0 .354.161.697.473.865a3.751 3.751 0 005.452-2.553c.083-.409-.263-.75-.68-.75h-.745M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyBangladeshiIcon);
    module.exports = ForwardRef;
  }
});
var require_CurrencyDollarIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CurrencyDollarIcon.js"(exports, module) {
    var React = require_react();
    function CurrencyDollarIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 6v12m-3-2.818l.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyDollarIcon);
    module.exports = ForwardRef;
  }
});
var require_CurrencyEuroIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CurrencyEuroIcon.js"(exports, module) {
    var React = require_react();
    function CurrencyEuroIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.25 7.756a4.5 4.5 0 100 8.488M7.5 10.5h5.25m-5.25 3h5.25M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyEuroIcon);
    module.exports = ForwardRef;
  }
});
var require_CurrencyPoundIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CurrencyPoundIcon.js"(exports, module) {
    var React = require_react();
    function CurrencyPoundIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.121 7.629A3 3 0 009.017 9.43c-.023.212-.002.425.028.636l.506 3.541a4.5 4.5 0 01-.43 2.65L9 16.5l1.539-.513a2.25 2.25 0 011.422 0l.655.218a2.25 2.25 0 001.718-.122L15 15.75M8.25 12H12m9 0a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyPoundIcon);
    module.exports = ForwardRef;
  }
});
var require_CurrencyRupeeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CurrencyRupeeIcon.js"(exports, module) {
    var React = require_react();
    function CurrencyRupeeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 8.25H9m6 3H9m3 6l-3-3h1.5a3 3 0 100-6M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyRupeeIcon);
    module.exports = ForwardRef;
  }
});
var require_CurrencyYenIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CurrencyYenIcon.js"(exports, module) {
    var React = require_react();
    function CurrencyYenIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 7.5l3 4.5m0 0l3-4.5M12 12v5.25M15 12H9m6 3H9m12-3a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(CurrencyYenIcon);
    module.exports = ForwardRef;
  }
});
var require_CursorArrowRaysIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CursorArrowRaysIcon.js"(exports, module) {
    var React = require_react();
    function CursorArrowRaysIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.042 21.672L13.684 16.6m0 0l-2.51 2.225.569-9.47 5.227 7.917-3.286-.672zM12 2.25V4.5m5.834.166l-1.591 1.591M20.25 10.5H18M7.757 14.743l-1.59 1.59M6 10.5H3.75m4.007-4.243l-1.59-1.59"
      }));
    }
    var ForwardRef = React.forwardRef(CursorArrowRaysIcon);
    module.exports = ForwardRef;
  }
});
var require_CursorArrowRippleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/CursorArrowRippleIcon.js"(exports, module) {
    var React = require_react();
    function CursorArrowRippleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.042 21.672L13.684 16.6m0 0l-2.51 2.225.569-9.47 5.227 7.917-3.286-.672zm-7.518-.267A8.25 8.25 0 1120.25 10.5M8.288 14.212A5.25 5.25 0 1117.25 10.5"
      }));
    }
    var ForwardRef = React.forwardRef(CursorArrowRippleIcon);
    module.exports = ForwardRef;
  }
});
var require_DevicePhoneMobileIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DevicePhoneMobileIcon.js"(exports, module) {
    var React = require_react();
    function DevicePhoneMobileIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.5 1.5H8.25A2.25 2.25 0 006 3.75v16.5a2.25 2.25 0 002.25 2.25h7.5A2.25 2.25 0 0018 20.25V3.75a2.25 2.25 0 00-2.25-2.25H13.5m-3 0V3h3V1.5m-3 0h3m-3 18.75h3"
      }));
    }
    var ForwardRef = React.forwardRef(DevicePhoneMobileIcon);
    module.exports = ForwardRef;
  }
});
var require_DeviceTabletIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DeviceTabletIcon.js"(exports, module) {
    var React = require_react();
    function DeviceTabletIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.5 19.5h3m-6.75 2.25h10.5a2.25 2.25 0 002.25-2.25v-15a2.25 2.25 0 00-2.25-2.25H6.75A2.25 2.25 0 004.5 4.5v15a2.25 2.25 0 002.25 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(DeviceTabletIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentArrowDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentArrowDownIcon.js"(exports, module) {
    var React = require_react();
    function DocumentArrowDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m.75 12l3 3m0 0l3-3m-3 3v-6m-1.5-9H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentArrowDownIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentArrowUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentArrowUpIcon.js"(exports, module) {
    var React = require_react();
    function DocumentArrowUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m6.75 12l-3-3m0 0l-3 3m3-3v6m-1.5-15H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentArrowUpIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentChartBarIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentChartBarIcon.js"(exports, module) {
    var React = require_react();
    function DocumentChartBarIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25M9 16.5v.75m3-3v3M15 12v5.25m-4.5-15H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentChartBarIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentCheckIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentCheckIcon.js"(exports, module) {
    var React = require_react();
    function DocumentCheckIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.125 2.25h-4.5c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125v-9M10.125 2.25h.375a9 9 0 019 9v.375M10.125 2.25A3.375 3.375 0 0113.5 5.625v1.5c0 .621.504 1.125 1.125 1.125h1.5a3.375 3.375 0 013.375 3.375M9 15l2.25 2.25L15 12"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentCheckIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentDuplicateIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentDuplicateIcon.js"(exports, module) {
    var React = require_react();
    function DocumentDuplicateIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 17.25v3.375c0 .621-.504 1.125-1.125 1.125h-9.75a1.125 1.125 0 01-1.125-1.125V7.875c0-.621.504-1.125 1.125-1.125H6.75a9.06 9.06 0 011.5.124m7.5 10.376h3.375c.621 0 1.125-.504 1.125-1.125V11.25c0-4.46-3.243-8.161-7.5-8.876a9.06 9.06 0 00-1.5-.124H9.375c-.621 0-1.125.504-1.125 1.125v3.5m7.5 10.375H9.375a1.125 1.125 0 01-1.125-1.125v-9.25m12 6.625v-1.875a3.375 3.375 0 00-3.375-3.375h-1.5a1.125 1.125 0 01-1.125-1.125v-1.5a3.375 3.375 0 00-3.375-3.375H9.75"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentDuplicateIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentMagnifyingGlassIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentMagnifyingGlassIcon.js"(exports, module) {
    var React = require_react();
    function DocumentMagnifyingGlassIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m5.231 13.481L15 17.25m-4.5-15H5.625c-.621 0-1.125.504-1.125 1.125v16.5c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9zm3.75 11.625a2.625 2.625 0 11-5.25 0 2.625 2.625 0 015.25 0z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentMagnifyingGlassIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentMinusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentMinusIcon.js"(exports, module) {
    var React = require_react();
    function DocumentMinusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m6.75 12H9m1.5-12H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentMinusIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentPlusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentPlusIcon.js"(exports, module) {
    var React = require_react();
    function DocumentPlusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m3.75 9v6m3-3H9m1.5-12H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentPlusIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentTextIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentTextIcon.js"(exports, module) {
    var React = require_react();
    function DocumentTextIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentTextIcon);
    module.exports = ForwardRef;
  }
});
var require_DocumentIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/DocumentIcon.js"(exports, module) {
    var React = require_react();
    function DocumentIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m2.25 0H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z"
      }));
    }
    var ForwardRef = React.forwardRef(DocumentIcon);
    module.exports = ForwardRef;
  }
});
var require_EllipsisHorizontalCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EllipsisHorizontalCircleIcon.js"(exports, module) {
    var React = require_react();
    function EllipsisHorizontalCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.625 12a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H8.25m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0H12m4.125 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm0 0h-.375M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(EllipsisHorizontalCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_EllipsisHorizontalIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EllipsisHorizontalIcon.js"(exports, module) {
    var React = require_react();
    function EllipsisHorizontalIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0zM12.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0zM18.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0z"
      }));
    }
    var ForwardRef = React.forwardRef(EllipsisHorizontalIcon);
    module.exports = ForwardRef;
  }
});
var require_EllipsisVerticalIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EllipsisVerticalIcon.js"(exports, module) {
    var React = require_react();
    function EllipsisVerticalIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 6.75a.75.75 0 110-1.5.75.75 0 010 1.5zM12 12.75a.75.75 0 110-1.5.75.75 0 010 1.5zM12 18.75a.75.75 0 110-1.5.75.75 0 010 1.5z"
      }));
    }
    var ForwardRef = React.forwardRef(EllipsisVerticalIcon);
    module.exports = ForwardRef;
  }
});
var require_EnvelopeOpenIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EnvelopeOpenIcon.js"(exports, module) {
    var React = require_react();
    function EnvelopeOpenIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21.75 9v.906a2.25 2.25 0 01-1.183 1.981l-6.478 3.488M2.25 9v.906a2.25 2.25 0 001.183 1.981l6.478 3.488m8.839 2.51l-4.66-2.51m0 0l-1.023-.55a2.25 2.25 0 00-2.134 0l-1.022.55m0 0l-4.661 2.51m16.5 1.615a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V8.844a2.25 2.25 0 011.183-1.98l7.5-4.04a2.25 2.25 0 012.134 0l7.5 4.04a2.25 2.25 0 011.183 1.98V19.5z"
      }));
    }
    var ForwardRef = React.forwardRef(EnvelopeOpenIcon);
    module.exports = ForwardRef;
  }
});
var require_EnvelopeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EnvelopeIcon.js"(exports, module) {
    var React = require_react();
    function EnvelopeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75"
      }));
    }
    var ForwardRef = React.forwardRef(EnvelopeIcon);
    module.exports = ForwardRef;
  }
});
var require_ExclamationCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ExclamationCircleIcon.js"(exports, module) {
    var React = require_react();
    function ExclamationCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 9v3.75m9-.75a9 9 0 11-18 0 9 9 0 0118 0zm-9 3.75h.008v.008H12v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(ExclamationCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_ExclamationTriangleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ExclamationTriangleIcon.js"(exports, module) {
    var React = require_react();
    function ExclamationTriangleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 9v3.75m-9.303 3.376c-.866 1.5.217 3.374 1.948 3.374h14.71c1.73 0 2.813-1.874 1.948-3.374L13.949 3.378c-.866-1.5-3.032-1.5-3.898 0L2.697 16.126zM12 15.75h.007v.008H12v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(ExclamationTriangleIcon);
    module.exports = ForwardRef;
  }
});
var require_EyeDropperIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EyeDropperIcon.js"(exports, module) {
    var React = require_react();
    function EyeDropperIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 11.25l1.5 1.5.75-.75V8.758l2.276-.61a3 3 0 10-3.675-3.675l-.61 2.277H12l-.75.75 1.5 1.5M15 11.25l-8.47 8.47c-.34.34-.8.53-1.28.53s-.94.19-1.28.53l-.97.97-.75-.75.97-.97c.34-.34.53-.8.53-1.28s.19-.94.53-1.28L12.75 9M15 11.25L12.75 9"
      }));
    }
    var ForwardRef = React.forwardRef(EyeDropperIcon);
    module.exports = ForwardRef;
  }
});
var require_EyeSlashIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EyeSlashIcon.js"(exports, module) {
    var React = require_react();
    function EyeSlashIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.98 8.223A10.477 10.477 0 001.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88"
      }));
    }
    var ForwardRef = React.forwardRef(EyeSlashIcon);
    module.exports = ForwardRef;
  }
});
var require_EyeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/EyeIcon.js"(exports, module) {
    var React = require_react();
    function EyeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 12a3 3 0 11-6 0 3 3 0 016 0z"
      }));
    }
    var ForwardRef = React.forwardRef(EyeIcon);
    module.exports = ForwardRef;
  }
});
var require_FaceFrownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FaceFrownIcon.js"(exports, module) {
    var React = require_react();
    function FaceFrownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.182 16.318A4.486 4.486 0 0012.016 15a4.486 4.486 0 00-3.198 1.318M21 12a9 9 0 11-18 0 9 9 0 0118 0zM9.75 9.75c0 .414-.168.75-.375.75S9 10.164 9 9.75 9.168 9 9.375 9s.375.336.375.75zm-.375 0h.008v.015h-.008V9.75zm5.625 0c0 .414-.168.75-.375.75s-.375-.336-.375-.75.168-.75.375-.75.375.336.375.75zm-.375 0h.008v.015h-.008V9.75z"
      }));
    }
    var ForwardRef = React.forwardRef(FaceFrownIcon);
    module.exports = ForwardRef;
  }
});
var require_FaceSmileIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FaceSmileIcon.js"(exports, module) {
    var React = require_react();
    function FaceSmileIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.182 15.182a4.5 4.5 0 01-6.364 0M21 12a9 9 0 11-18 0 9 9 0 0118 0zM9.75 9.75c0 .414-.168.75-.375.75S9 10.164 9 9.75 9.168 9 9.375 9s.375.336.375.75zm-.375 0h.008v.015h-.008V9.75zm5.625 0c0 .414-.168.75-.375.75s-.375-.336-.375-.75.168-.75.375-.75.375.336.375.75zm-.375 0h.008v.015h-.008V9.75z"
      }));
    }
    var ForwardRef = React.forwardRef(FaceSmileIcon);
    module.exports = ForwardRef;
  }
});
var require_FilmIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FilmIcon.js"(exports, module) {
    var React = require_react();
    function FilmIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 01-1.125-1.125M3.375 19.5h1.5C5.496 19.5 6 18.996 6 18.375m-3.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-1.5A1.125 1.125 0 0118 18.375M20.625 4.5H3.375m17.25 0c.621 0 1.125.504 1.125 1.125M20.625 4.5h-1.5C18.504 4.5 18 5.004 18 5.625m3.75 0v1.5c0 .621-.504 1.125-1.125 1.125M3.375 4.5c-.621 0-1.125.504-1.125 1.125M3.375 4.5h1.5C5.496 4.5 6 5.004 6 5.625m-3.75 0v1.5c0 .621.504 1.125 1.125 1.125m0 0h1.5m-1.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m1.5-3.75C5.496 8.25 6 7.746 6 7.125v-1.5M4.875 8.25C5.496 8.25 6 8.754 6 9.375v1.5m0-5.25v5.25m0-5.25C6 5.004 6.504 4.5 7.125 4.5h9.75c.621 0 1.125.504 1.125 1.125m1.125 2.625h1.5m-1.5 0A1.125 1.125 0 0118 7.125v-1.5m1.125 2.625c-.621 0-1.125.504-1.125 1.125v1.5m2.625-2.625c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125M18 5.625v5.25M7.125 12h9.75m-9.75 0A1.125 1.125 0 016 10.875M7.125 12C6.504 12 6 12.504 6 13.125m0-2.25C6 11.496 5.496 12 4.875 12M18 10.875c0 .621-.504 1.125-1.125 1.125M18 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m-12 5.25v-5.25m0 5.25c0 .621.504 1.125 1.125 1.125h9.75c.621 0 1.125-.504 1.125-1.125m-12 0v-1.5c0-.621-.504-1.125-1.125-1.125M18 18.375v-5.25m0 5.25v-1.5c0-.621.504-1.125 1.125-1.125M18 13.125v1.5c0 .621.504 1.125 1.125 1.125M18 13.125c0-.621.504-1.125 1.125-1.125M6 13.125v1.5c0 .621-.504 1.125-1.125 1.125M6 13.125C6 12.504 5.496 12 4.875 12m-1.5 0h1.5m-1.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M19.125 12h1.5m0 0c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h1.5m14.25 0h1.5"
      }));
    }
    var ForwardRef = React.forwardRef(FilmIcon);
    module.exports = ForwardRef;
  }
});
var require_FingerPrintIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FingerPrintIcon.js"(exports, module) {
    var React = require_react();
    function FingerPrintIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.864 4.243A7.5 7.5 0 0119.5 10.5c0 2.92-.556 5.709-1.568 8.268M5.742 6.364A7.465 7.465 0 004.5 10.5a7.464 7.464 0 01-1.15 3.993m1.989 3.559A11.209 11.209 0 008.25 10.5a3.75 3.75 0 117.5 0c0 .527-.021 1.049-.064 1.565M12 10.5a14.94 14.94 0 01-3.6 9.75m6.633-4.596a18.666 18.666 0 01-2.485 5.33"
      }));
    }
    var ForwardRef = React.forwardRef(FingerPrintIcon);
    module.exports = ForwardRef;
  }
});
var require_FireIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FireIcon.js"(exports, module) {
    var React = require_react();
    function FireIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.362 5.214A8.252 8.252 0 0112 21 8.25 8.25 0 016.038 7.048 8.287 8.287 0 009 9.6a8.983 8.983 0 013.361-6.867 8.21 8.21 0 003 2.48z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 18a3.75 3.75 0 00.495-7.467 5.99 5.99 0 00-1.925 3.546 5.974 5.974 0 01-2.133-1A3.75 3.75 0 0012 18z"
      }));
    }
    var ForwardRef = React.forwardRef(FireIcon);
    module.exports = ForwardRef;
  }
});
var require_FlagIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FlagIcon.js"(exports, module) {
    var React = require_react();
    function FlagIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 3v1.5M3 21v-6m0 0l2.77-.693a9 9 0 016.208.682l.108.054a9 9 0 006.086.71l3.114-.732a48.524 48.524 0 01-.005-10.499l-3.11.732a9 9 0 01-6.085-.711l-.108-.054a9 9 0 00-6.208-.682L3 4.5M3 15V4.5"
      }));
    }
    var ForwardRef = React.forwardRef(FlagIcon);
    module.exports = ForwardRef;
  }
});
var require_FolderArrowDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FolderArrowDownIcon.js"(exports, module) {
    var React = require_react();
    function FolderArrowDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 13.5l3 3m0 0l3-3m-3 3v-6m1.06-4.19l-2.12-2.12a1.5 1.5 0 00-1.061-.44H4.5A2.25 2.25 0 002.25 6v12a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18V9a2.25 2.25 0 00-2.25-2.25h-5.379a1.5 1.5 0 01-1.06-.44z"
      }));
    }
    var ForwardRef = React.forwardRef(FolderArrowDownIcon);
    module.exports = ForwardRef;
  }
});
var require_FolderMinusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FolderMinusIcon.js"(exports, module) {
    var React = require_react();
    function FolderMinusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 13.5H9m4.06-7.19l-2.12-2.12a1.5 1.5 0 00-1.061-.44H4.5A2.25 2.25 0 002.25 6v12a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18V9a2.25 2.25 0 00-2.25-2.25h-5.379a1.5 1.5 0 01-1.06-.44z"
      }));
    }
    var ForwardRef = React.forwardRef(FolderMinusIcon);
    module.exports = ForwardRef;
  }
});
var require_FolderOpenIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FolderOpenIcon.js"(exports, module) {
    var React = require_react();
    function FolderOpenIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 9.776c.112-.017.227-.026.344-.026h15.812c.117 0 .232.009.344.026m-16.5 0a2.25 2.25 0 00-1.883 2.542l.857 6a2.25 2.25 0 002.227 1.932H19.05a2.25 2.25 0 002.227-1.932l.857-6a2.25 2.25 0 00-1.883-2.542m-16.5 0V6A2.25 2.25 0 016 3.75h3.879a1.5 1.5 0 011.06.44l2.122 2.12a1.5 1.5 0 001.06.44H18A2.25 2.25 0 0120.25 9v.776"
      }));
    }
    var ForwardRef = React.forwardRef(FolderOpenIcon);
    module.exports = ForwardRef;
  }
});
var require_FolderPlusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FolderPlusIcon.js"(exports, module) {
    var React = require_react();
    function FolderPlusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 10.5v6m3-3H9m4.06-7.19l-2.12-2.12a1.5 1.5 0 00-1.061-.44H4.5A2.25 2.25 0 002.25 6v12a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18V9a2.25 2.25 0 00-2.25-2.25h-5.379a1.5 1.5 0 01-1.06-.44z"
      }));
    }
    var ForwardRef = React.forwardRef(FolderPlusIcon);
    module.exports = ForwardRef;
  }
});
var require_FolderIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FolderIcon.js"(exports, module) {
    var React = require_react();
    function FolderIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 12.75V12A2.25 2.25 0 014.5 9.75h15A2.25 2.25 0 0121.75 12v.75m-8.69-6.44l-2.12-2.12a1.5 1.5 0 00-1.061-.44H4.5A2.25 2.25 0 002.25 6v12a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18V9a2.25 2.25 0 00-2.25-2.25h-5.379a1.5 1.5 0 01-1.06-.44z"
      }));
    }
    var ForwardRef = React.forwardRef(FolderIcon);
    module.exports = ForwardRef;
  }
});
var require_ForwardIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ForwardIcon.js"(exports, module) {
    var React = require_react();
    function ForwardIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 8.688c0-.864.933-1.405 1.683-.977l7.108 4.062a1.125 1.125 0 010 1.953l-7.108 4.062A1.125 1.125 0 013 16.81V8.688zM12.75 8.688c0-.864.933-1.405 1.683-.977l7.108 4.062a1.125 1.125 0 010 1.953l-7.108 4.062a1.125 1.125 0 01-1.683-.977V8.688z"
      }));
    }
    var ForwardRef = React.forwardRef(ForwardIcon);
    module.exports = ForwardRef;
  }
});
var require_FunnelIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/FunnelIcon.js"(exports, module) {
    var React = require_react();
    function FunnelIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 3c2.755 0 5.455.232 8.083.678.533.09.917.556.917 1.096v1.044a2.25 2.25 0 01-.659 1.591l-5.432 5.432a2.25 2.25 0 00-.659 1.591v2.927a2.25 2.25 0 01-1.244 2.013L9.75 21v-6.568a2.25 2.25 0 00-.659-1.591L3.659 7.409A2.25 2.25 0 013 5.818V4.774c0-.54.384-1.006.917-1.096A48.32 48.32 0 0112 3z"
      }));
    }
    var ForwardRef = React.forwardRef(FunnelIcon);
    module.exports = ForwardRef;
  }
});
var require_GifIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/GifIcon.js"(exports, module) {
    var React = require_react();
    function GifIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12.75 8.25v7.5m6-7.5h-3V12m0 0v3.75m0-3.75H18M9.75 9.348c-1.03-1.464-2.698-1.464-3.728 0-1.03 1.465-1.03 3.84 0 5.304 1.03 1.464 2.699 1.464 3.728 0V12h-1.5M4.5 19.5h15a2.25 2.25 0 002.25-2.25V6.75A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25v10.5A2.25 2.25 0 004.5 19.5z"
      }));
    }
    var ForwardRef = React.forwardRef(GifIcon);
    module.exports = ForwardRef;
  }
});
var require_GiftTopIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/GiftTopIcon.js"(exports, module) {
    var React = require_react();
    function GiftTopIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 3.75v16.5M2.25 12h19.5M6.375 17.25a4.875 4.875 0 004.875-4.875V12m6.375 5.25a4.875 4.875 0 01-4.875-4.875V12m-9 8.25h16.5a1.5 1.5 0 001.5-1.5V5.25a1.5 1.5 0 00-1.5-1.5H3.75a1.5 1.5 0 00-1.5 1.5v13.5a1.5 1.5 0 001.5 1.5zm12.621-9.44c-1.409 1.41-4.242 1.061-4.242 1.061s-.349-2.833 1.06-4.242a2.25 2.25 0 013.182 3.182zM10.773 7.63c1.409 1.409 1.06 4.242 1.06 4.242S9 12.22 7.592 10.811a2.25 2.25 0 113.182-3.182z"
      }));
    }
    var ForwardRef = React.forwardRef(GiftTopIcon);
    module.exports = ForwardRef;
  }
});
var require_GiftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/GiftIcon.js"(exports, module) {
    var React = require_react();
    function GiftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 11.25v8.25a1.5 1.5 0 01-1.5 1.5H5.25a1.5 1.5 0 01-1.5-1.5v-8.25M12 4.875A2.625 2.625 0 109.375 7.5H12m0-2.625V7.5m0-2.625A2.625 2.625 0 1114.625 7.5H12m0 0V21m-8.625-9.75h18c.621 0 1.125-.504 1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125h-18c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125z"
      }));
    }
    var ForwardRef = React.forwardRef(GiftIcon);
    module.exports = ForwardRef;
  }
});
var require_GlobeAltIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/GlobeAltIcon.js"(exports, module) {
    var React = require_react();
    function GlobeAltIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 21a9.004 9.004 0 008.716-6.747M12 21a9.004 9.004 0 01-8.716-6.747M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeAltIcon);
    module.exports = ForwardRef;
  }
});
var require_GlobeAmericasIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/GlobeAmericasIcon.js"(exports, module) {
    var React = require_react();
    function GlobeAmericasIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.115 5.19l.319 1.913A6 6 0 008.11 10.36L9.75 12l-.387.775c-.217.433-.132.956.21 1.298l1.348 1.348c.21.21.329.497.329.795v1.089c0 .426.24.815.622 1.006l.153.076c.433.217.956.132 1.298-.21l.723-.723a8.7 8.7 0 002.288-4.042 1.087 1.087 0 00-.358-1.099l-1.33-1.108c-.251-.21-.582-.299-.905-.245l-1.17.195a1.125 1.125 0 01-.98-.314l-.295-.295a1.125 1.125 0 010-1.591l.13-.132a1.125 1.125 0 011.3-.21l.603.302a.809.809 0 001.086-1.086L14.25 7.5l1.256-.837a4.5 4.5 0 001.528-1.732l.146-.292M6.115 5.19A9 9 0 1017.18 4.64M6.115 5.19A8.965 8.965 0 0112 3c1.929 0 3.716.607 5.18 1.64"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeAmericasIcon);
    module.exports = ForwardRef;
  }
});
var require_GlobeAsiaAustraliaIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/GlobeAsiaAustraliaIcon.js"(exports, module) {
    var React = require_react();
    function GlobeAsiaAustraliaIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12.75 3.03v.568c0 .334.148.65.405.864l1.068.89c.442.369.535 1.01.216 1.49l-.51.766a2.25 2.25 0 01-1.161.886l-.143.048a1.107 1.107 0 00-.57 1.664c.369.555.169 1.307-.427 1.605L9 13.125l.423 1.059a.956.956 0 01-1.652.928l-.679-.906a1.125 1.125 0 00-1.906.172L4.5 15.75l-.612.153M12.75 3.031a9 9 0 00-8.862 12.872M12.75 3.031a9 9 0 016.69 14.036m0 0l-.177-.529A2.25 2.25 0 0017.128 15H16.5l-.324-.324a1.453 1.453 0 00-2.328.377l-.036.073a1.586 1.586 0 01-.982.816l-.99.282c-.55.157-.894.702-.8 1.267l.073.438c.08.474.49.821.97.821.846 0 1.598.542 1.865 1.345l.215.643m5.276-3.67a9.012 9.012 0 01-5.276 3.67m0 0a9 9 0 01-10.275-4.835M15.75 9c0 .896-.393 1.7-1.016 2.25"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeAsiaAustraliaIcon);
    module.exports = ForwardRef;
  }
});
var require_GlobeEuropeAfricaIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/GlobeEuropeAfricaIcon.js"(exports, module) {
    var React = require_react();
    function GlobeEuropeAfricaIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.893 13.393l-1.135-1.135a2.252 2.252 0 01-.421-.585l-1.08-2.16a.414.414 0 00-.663-.107.827.827 0 01-.812.21l-1.273-.363a.89.89 0 00-.738 1.595l.587.39c.59.395.674 1.23.172 1.732l-.2.2c-.212.212-.33.498-.33.796v.41c0 .409-.11.809-.32 1.158l-1.315 2.191a2.11 2.11 0 01-1.81 1.025 1.055 1.055 0 01-1.055-1.055v-1.172c0-.92-.56-1.747-1.414-2.089l-.655-.261a2.25 2.25 0 01-1.383-2.46l.007-.042a2.25 2.25 0 01.29-.787l.09-.15a2.25 2.25 0 012.37-1.048l1.178.236a1.125 1.125 0 001.302-.795l.208-.73a1.125 1.125 0 00-.578-1.315l-.665-.332-.091.091a2.25 2.25 0 01-1.591.659h-.18c-.249 0-.487.1-.662.274a.931.931 0 01-1.458-1.137l1.411-2.353a2.25 2.25 0 00.286-.76m11.928 9.869A9 9 0 008.965 3.525m11.928 9.868A9 9 0 118.965 3.525"
      }));
    }
    var ForwardRef = React.forwardRef(GlobeEuropeAfricaIcon);
    module.exports = ForwardRef;
  }
});
var require_HandRaisedIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/HandRaisedIcon.js"(exports, module) {
    var React = require_react();
    function HandRaisedIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.05 4.575a1.575 1.575 0 10-3.15 0v3m3.15-3v-1.5a1.575 1.575 0 013.15 0v1.5m-3.15 0l.075 5.925m3.075.75V4.575m0 0a1.575 1.575 0 013.15 0V15M6.9 7.575a1.575 1.575 0 10-3.15 0v8.175a6.75 6.75 0 006.75 6.75h2.018a5.25 5.25 0 003.712-1.538l1.732-1.732a5.25 5.25 0 001.538-3.712l.003-2.024a.668.668 0 01.198-.471 1.575 1.575 0 10-2.228-2.228 3.818 3.818 0 00-1.12 2.687M6.9 7.575V12m6.27 4.318A4.49 4.49 0 0116.35 15m.002 0h-.002"
      }));
    }
    var ForwardRef = React.forwardRef(HandRaisedIcon);
    module.exports = ForwardRef;
  }
});
var require_HandThumbDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/HandThumbDownIcon.js"(exports, module) {
    var React = require_react();
    function HandThumbDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.5 15h2.25m8.024-9.75c.011.05.028.1.052.148.591 1.2.924 2.55.924 3.977a8.96 8.96 0 01-.999 4.125m.023-8.25c-.076-.365.183-.75.575-.75h.908c.889 0 1.713.518 1.972 1.368.339 1.11.521 2.287.521 3.507 0 1.553-.295 3.036-.831 4.398C20.613 14.547 19.833 15 19 15h-1.053c-.472 0-.745-.556-.5-.96a8.95 8.95 0 00.303-.54m.023-8.25H16.48a4.5 4.5 0 01-1.423-.23l-3.114-1.04a4.5 4.5 0 00-1.423-.23H6.504c-.618 0-1.217.247-1.605.729A11.95 11.95 0 002.25 12c0 .434.023.863.068 1.285C2.427 14.306 3.346 15 4.372 15h3.126c.618 0 .991.724.725 1.282A7.471 7.471 0 007.5 19.5a2.25 2.25 0 002.25 2.25.75.75 0 00.75-.75v-.633c0-.573.11-1.14.322-1.672.304-.76.93-1.33 1.653-1.715a9.04 9.04 0 002.86-2.4c.498-.634 1.226-1.08 2.032-1.08h.384"
      }));
    }
    var ForwardRef = React.forwardRef(HandThumbDownIcon);
    module.exports = ForwardRef;
  }
});
var require_HandThumbUpIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/HandThumbUpIcon.js"(exports, module) {
    var React = require_react();
    function HandThumbUpIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.633 10.5c.806 0 1.533-.446 2.031-1.08a9.041 9.041 0 012.861-2.4c.723-.384 1.35-.956 1.653-1.715a4.498 4.498 0 00.322-1.672V3a.75.75 0 01.75-.75A2.25 2.25 0 0116.5 4.5c0 1.152-.26 2.243-.723 3.218-.266.558.107 1.282.725 1.282h3.126c1.026 0 1.945.694 2.054 1.715.045.422.068.85.068 1.285a11.95 11.95 0 01-2.649 7.521c-.388.482-.987.729-1.605.729H13.48c-.483 0-.964-.078-1.423-.23l-3.114-1.04a4.501 4.501 0 00-1.423-.23H5.904M14.25 9h2.25M5.904 18.75c.083.205.173.405.27.602.197.4-.078.898-.523.898h-.908c-.889 0-1.713-.518-1.972-1.368a12 12 0 01-.521-3.507c0-1.553.295-3.036.831-4.398C3.387 10.203 4.167 9.75 5 9.75h1.053c.472 0 .745.556.5.96a8.958 8.958 0 00-1.302 4.665c0 1.194.232 2.333.654 3.375z"
      }));
    }
    var ForwardRef = React.forwardRef(HandThumbUpIcon);
    module.exports = ForwardRef;
  }
});
var require_HashtagIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/HashtagIcon.js"(exports, module) {
    var React = require_react();
    function HashtagIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M5.25 8.25h15m-16.5 7.5h15m-1.8-13.5l-3.9 19.5m-2.1-19.5l-3.9 19.5"
      }));
    }
    var ForwardRef = React.forwardRef(HashtagIcon);
    module.exports = ForwardRef;
  }
});
var require_HeartIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/HeartIcon.js"(exports, module) {
    var React = require_react();
    function HeartIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z"
      }));
    }
    var ForwardRef = React.forwardRef(HeartIcon);
    module.exports = ForwardRef;
  }
});
var require_HomeModernIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/HomeModernIcon.js"(exports, module) {
    var React = require_react();
    function HomeModernIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 21v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21m0 0h4.5V3.545M12.75 21h7.5V10.75M2.25 21h1.5m18 0h-18M2.25 9l4.5-1.636M18.75 3l-1.5.545m0 6.205l3 1m1.5.5l-1.5-.5M6.75 7.364V3h-3v18m3-13.636l10.5-3.819"
      }));
    }
    var ForwardRef = React.forwardRef(HomeModernIcon);
    module.exports = ForwardRef;
  }
});
var require_HomeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/HomeIcon.js"(exports, module) {
    var React = require_react();
    function HomeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"
      }));
    }
    var ForwardRef = React.forwardRef(HomeIcon);
    module.exports = ForwardRef;
  }
});
var require_IdentificationIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/IdentificationIcon.js"(exports, module) {
    var React = require_react();
    function IdentificationIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 9h3.75M15 12h3.75M15 15h3.75M4.5 19.5h15a2.25 2.25 0 002.25-2.25V6.75A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25v10.5A2.25 2.25 0 004.5 19.5zm6-10.125a1.875 1.875 0 11-3.75 0 1.875 1.875 0 013.75 0zm1.294 6.336a6.721 6.721 0 01-3.17.789 6.721 6.721 0 01-3.168-.789 3.376 3.376 0 016.338 0z"
      }));
    }
    var ForwardRef = React.forwardRef(IdentificationIcon);
    module.exports = ForwardRef;
  }
});
var require_InboxArrowDownIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/InboxArrowDownIcon.js"(exports, module) {
    var React = require_react();
    function InboxArrowDownIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 3.75H6.912a2.25 2.25 0 00-2.15 1.588L2.35 13.177a2.25 2.25 0 00-.1.661V18a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18v-4.162c0-.224-.034-.447-.1-.661L19.24 5.338a2.25 2.25 0 00-2.15-1.588H15M2.25 13.5h3.86a2.25 2.25 0 012.012 1.244l.256.512a2.25 2.25 0 002.013 1.244h3.218a2.25 2.25 0 002.013-1.244l.256-.512a2.25 2.25 0 012.013-1.244h3.859M12 3v8.25m0 0l-3-3m3 3l3-3"
      }));
    }
    var ForwardRef = React.forwardRef(InboxArrowDownIcon);
    module.exports = ForwardRef;
  }
});
var require_InboxStackIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/InboxStackIcon.js"(exports, module) {
    var React = require_react();
    function InboxStackIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.875 14.25l1.214 1.942a2.25 2.25 0 001.908 1.058h2.006c.776 0 1.497-.4 1.908-1.058l1.214-1.942M2.41 9h4.636a2.25 2.25 0 011.872 1.002l.164.246a2.25 2.25 0 001.872 1.002h2.092a2.25 2.25 0 001.872-1.002l.164-.246A2.25 2.25 0 0116.954 9h4.636M2.41 9a2.25 2.25 0 00-.16.832V12a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 12V9.832c0-.287-.055-.57-.16-.832M2.41 9a2.25 2.25 0 01.382-.632l3.285-3.832a2.25 2.25 0 011.708-.786h8.43c.657 0 1.281.287 1.709.786l3.284 3.832c.163.19.291.404.382.632M4.5 20.25h15A2.25 2.25 0 0021.75 18v-2.625c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125V18a2.25 2.25 0 002.25 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(InboxStackIcon);
    module.exports = ForwardRef;
  }
});
var require_InboxIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/InboxIcon.js"(exports, module) {
    var React = require_react();
    function InboxIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 13.5h3.86a2.25 2.25 0 012.012 1.244l.256.512a2.25 2.25 0 002.013 1.244h3.218a2.25 2.25 0 002.013-1.244l.256-.512a2.25 2.25 0 012.013-1.244h3.859m-19.5.338V18a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18v-4.162c0-.224-.034-.447-.1-.661L19.24 5.338a2.25 2.25 0 00-2.15-1.588H6.911a2.25 2.25 0 00-2.15 1.588L2.35 13.177a2.25 2.25 0 00-.1.661z"
      }));
    }
    var ForwardRef = React.forwardRef(InboxIcon);
    module.exports = ForwardRef;
  }
});
var require_InformationCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/InformationCircleIcon.js"(exports, module) {
    var React = require_react();
    function InformationCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z"
      }));
    }
    var ForwardRef = React.forwardRef(InformationCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_KeyIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/KeyIcon.js"(exports, module) {
    var React = require_react();
    function KeyIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 5.25a3 3 0 013 3m3 0a6 6 0 01-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1121.75 8.25z"
      }));
    }
    var ForwardRef = React.forwardRef(KeyIcon);
    module.exports = ForwardRef;
  }
});
var require_LanguageIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/LanguageIcon.js"(exports, module) {
    var React = require_react();
    function LanguageIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.5 21l5.25-11.25L21 21m-9-3h7.5M3 5.621a48.474 48.474 0 016-.371m0 0c1.12 0 2.233.038 3.334.114M9 5.25V3m3.334 2.364C11.176 10.658 7.69 15.08 3 17.502m9.334-12.138c.896.061 1.785.147 2.666.257m-4.589 8.495a18.023 18.023 0 01-3.827-5.802"
      }));
    }
    var ForwardRef = React.forwardRef(LanguageIcon);
    module.exports = ForwardRef;
  }
});
var require_LifebuoyIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/LifebuoyIcon.js"(exports, module) {
    var React = require_react();
    function LifebuoyIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.712 4.33a9.027 9.027 0 011.652 1.306c.51.51.944 1.064 1.306 1.652M16.712 4.33l-3.448 4.138m3.448-4.138a9.014 9.014 0 00-9.424 0M19.67 7.288l-4.138 3.448m4.138-3.448a9.014 9.014 0 010 9.424m-4.138-5.976a3.736 3.736 0 00-.88-1.388 3.737 3.737 0 00-1.388-.88m2.268 2.268a3.765 3.765 0 010 2.528m-2.268-4.796a3.765 3.765 0 00-2.528 0m4.796 4.796c-.181.506-.475.982-.88 1.388a3.736 3.736 0 01-1.388.88m2.268-2.268l4.138 3.448m0 0a9.027 9.027 0 01-1.306 1.652c-.51.51-1.064.944-1.652 1.306m0 0l-3.448-4.138m3.448 4.138a9.014 9.014 0 01-9.424 0m5.976-4.138a3.765 3.765 0 01-2.528 0m0 0a3.736 3.736 0 01-1.388-.88 3.737 3.737 0 01-.88-1.388m2.268 2.268L7.288 19.67m0 0a9.024 9.024 0 01-1.652-1.306 9.027 9.027 0 01-1.306-1.652m0 0l4.138-3.448M4.33 16.712a9.014 9.014 0 010-9.424m4.138 5.976a3.765 3.765 0 010-2.528m0 0c.181-.506.475-.982.88-1.388a3.736 3.736 0 011.388-.88m-2.268 2.268L4.33 7.288m6.406 1.18L7.288 4.33m0 0a9.024 9.024 0 00-1.652 1.306A9.025 9.025 0 004.33 7.288"
      }));
    }
    var ForwardRef = React.forwardRef(LifebuoyIcon);
    module.exports = ForwardRef;
  }
});
var require_LightBulbIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/LightBulbIcon.js"(exports, module) {
    var React = require_react();
    function LightBulbIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 18v-5.25m0 0a6.01 6.01 0 001.5-.189m-1.5.189a6.01 6.01 0 01-1.5-.189m3.75 7.478a12.06 12.06 0 01-4.5 0m3.75 2.383a14.406 14.406 0 01-3 0M14.25 18v-.192c0-.983.658-1.823 1.508-2.316a7.5 7.5 0 10-7.517 0c.85.493 1.509 1.333 1.509 2.316V18"
      }));
    }
    var ForwardRef = React.forwardRef(LightBulbIcon);
    module.exports = ForwardRef;
  }
});
var require_LinkIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/LinkIcon.js"(exports, module) {
    var React = require_react();
    function LinkIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13.19 8.688a4.5 4.5 0 011.242 7.244l-4.5 4.5a4.5 4.5 0 01-6.364-6.364l1.757-1.757m13.35-.622l1.757-1.757a4.5 4.5 0 00-6.364-6.364l-4.5 4.5a4.5 4.5 0 001.242 7.244"
      }));
    }
    var ForwardRef = React.forwardRef(LinkIcon);
    module.exports = ForwardRef;
  }
});
var require_ListBulletIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ListBulletIcon.js"(exports, module) {
    var React = require_react();
    function ListBulletIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 6.75h12M8.25 12h12m-12 5.25h12M3.75 6.75h.007v.008H3.75V6.75zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zM3.75 12h.007v.008H3.75V12zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm-.375 5.25h.007v.008H3.75v-.008zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ListBulletIcon);
    module.exports = ForwardRef;
  }
});
var require_LockClosedIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/LockClosedIcon.js"(exports, module) {
    var React = require_react();
    function LockClosedIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 002.25-2.25v-6.75a2.25 2.25 0 00-2.25-2.25H6.75a2.25 2.25 0 00-2.25 2.25v6.75a2.25 2.25 0 002.25 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(LockClosedIcon);
    module.exports = ForwardRef;
  }
});
var require_LockOpenIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/LockOpenIcon.js"(exports, module) {
    var React = require_react();
    function LockOpenIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13.5 10.5V6.75a4.5 4.5 0 119 0v3.75M3.75 21.75h10.5a2.25 2.25 0 002.25-2.25v-6.75a2.25 2.25 0 00-2.25-2.25H3.75a2.25 2.25 0 00-2.25 2.25v6.75a2.25 2.25 0 002.25 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(LockOpenIcon);
    module.exports = ForwardRef;
  }
});
var require_MagnifyingGlassCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MagnifyingGlassCircleIcon.js"(exports, module) {
    var React = require_react();
    function MagnifyingGlassCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 15.75l-2.489-2.489m0 0a3.375 3.375 0 10-4.773-4.773 3.375 3.375 0 004.774 4.774zM21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_MagnifyingGlassMinusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MagnifyingGlassMinusIcon.js"(exports, module) {
    var React = require_react();
    function MagnifyingGlassMinusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607zM13.5 10.5h-6"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassMinusIcon);
    module.exports = ForwardRef;
  }
});
var require_MagnifyingGlassPlusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MagnifyingGlassPlusIcon.js"(exports, module) {
    var React = require_react();
    function MagnifyingGlassPlusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607zM10.5 7.5v6m3-3h-6"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassPlusIcon);
    module.exports = ForwardRef;
  }
});
var require_MagnifyingGlassIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MagnifyingGlassIcon.js"(exports, module) {
    var React = require_react();
    function MagnifyingGlassIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z"
      }));
    }
    var ForwardRef = React.forwardRef(MagnifyingGlassIcon);
    module.exports = ForwardRef;
  }
});
var require_MapPinIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MapPinIcon.js"(exports, module) {
    var React = require_react();
    function MapPinIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 10.5a3 3 0 11-6 0 3 3 0 016 0z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1115 0z"
      }));
    }
    var ForwardRef = React.forwardRef(MapPinIcon);
    module.exports = ForwardRef;
  }
});
var require_MapIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MapIcon.js"(exports, module) {
    var React = require_react();
    function MapIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 6.75V15m6-6v8.25m.503 3.498l4.875-2.437c.381-.19.622-.58.622-1.006V4.82c0-.836-.88-1.38-1.628-1.006l-3.869 1.934c-.317.159-.69.159-1.006 0L9.503 3.252a1.125 1.125 0 00-1.006 0L3.622 5.689C3.24 5.88 3 6.27 3 6.695V19.18c0 .836.88 1.38 1.628 1.006l3.869-1.934c.317-.159.69-.159 1.006 0l4.994 2.497c.317.158.69.158 1.006 0z"
      }));
    }
    var ForwardRef = React.forwardRef(MapIcon);
    module.exports = ForwardRef;
  }
});
var require_MegaphoneIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MegaphoneIcon.js"(exports, module) {
    var React = require_react();
    function MegaphoneIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M10.34 15.84c-.688-.06-1.386-.09-2.09-.09H7.5a4.5 4.5 0 110-9h.75c.704 0 1.402-.03 2.09-.09m0 9.18c.253.962.584 1.892.985 2.783.247.55.06 1.21-.463 1.511l-.657.38c-.551.318-1.26.117-1.527-.461a20.845 20.845 0 01-1.44-4.282m3.102.069a18.03 18.03 0 01-.59-4.59c0-1.586.205-3.124.59-4.59m0 9.18a23.848 23.848 0 018.835 2.535M10.34 6.66a23.847 23.847 0 008.835-2.535m0 0A23.74 23.74 0 0018.795 3m.38 1.125a23.91 23.91 0 011.014 5.395m-1.014 8.855c-.118.38-.245.754-.38 1.125m.38-1.125a23.91 23.91 0 001.014-5.395m0-3.46c.495.413.811 1.035.811 1.73 0 .695-.316 1.317-.811 1.73m0-3.46a24.347 24.347 0 010 3.46"
      }));
    }
    var ForwardRef = React.forwardRef(MegaphoneIcon);
    module.exports = ForwardRef;
  }
});
var require_MicrophoneIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MicrophoneIcon.js"(exports, module) {
    var React = require_react();
    function MicrophoneIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 18.75a6 6 0 006-6v-1.5m-6 7.5a6 6 0 01-6-6v-1.5m6 7.5v3.75m-3.75 0h7.5M12 15.75a3 3 0 01-3-3V4.5a3 3 0 116 0v8.25a3 3 0 01-3 3z"
      }));
    }
    var ForwardRef = React.forwardRef(MicrophoneIcon);
    module.exports = ForwardRef;
  }
});
var require_MinusCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MinusCircleIcon.js"(exports, module) {
    var React = require_react();
    function MinusCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 12H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(MinusCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_MinusSmallIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MinusSmallIcon.js"(exports, module) {
    var React = require_react();
    function MinusSmallIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M18 12H6"
      }));
    }
    var ForwardRef = React.forwardRef(MinusSmallIcon);
    module.exports = ForwardRef;
  }
});
var require_MinusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MinusIcon.js"(exports, module) {
    var React = require_react();
    function MinusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.5 12h-15"
      }));
    }
    var ForwardRef = React.forwardRef(MinusIcon);
    module.exports = ForwardRef;
  }
});
var require_MoonIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MoonIcon.js"(exports, module) {
    var React = require_react();
    function MoonIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21.752 15.002A9.718 9.718 0 0118 15.75c-5.385 0-9.75-4.365-9.75-9.75 0-1.33.266-2.597.748-3.752A9.753 9.753 0 003 11.25C3 16.635 7.365 21 12.75 21a9.753 9.753 0 009.002-5.998z"
      }));
    }
    var ForwardRef = React.forwardRef(MoonIcon);
    module.exports = ForwardRef;
  }
});
var require_MusicalNoteIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/MusicalNoteIcon.js"(exports, module) {
    var React = require_react();
    function MusicalNoteIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 9l10.5-3m0 6.553v3.75a2.25 2.25 0 01-1.632 2.163l-1.32.377a1.803 1.803 0 11-.99-3.467l2.31-.66a2.25 2.25 0 001.632-2.163zm0 0V2.25L9 5.25v10.303m0 0v3.75a2.25 2.25 0 01-1.632 2.163l-1.32.377a1.803 1.803 0 01-.99-3.467l2.31-.66A2.25 2.25 0 009 15.553z"
      }));
    }
    var ForwardRef = React.forwardRef(MusicalNoteIcon);
    module.exports = ForwardRef;
  }
});
var require_NewspaperIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/NewspaperIcon.js"(exports, module) {
    var React = require_react();
    function NewspaperIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 7.5h1.5m-1.5 3h1.5m-7.5 3h7.5m-7.5 3h7.5m3-9h3.375c.621 0 1.125.504 1.125 1.125V18a2.25 2.25 0 01-2.25 2.25M16.5 7.5V18a2.25 2.25 0 002.25 2.25M16.5 7.5V4.875c0-.621-.504-1.125-1.125-1.125H4.125C3.504 3.75 3 4.254 3 4.875V18a2.25 2.25 0 002.25 2.25h13.5M6 7.5h3v3H6v-3z"
      }));
    }
    var ForwardRef = React.forwardRef(NewspaperIcon);
    module.exports = ForwardRef;
  }
});
var require_NoSymbolIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/NoSymbolIcon.js"(exports, module) {
    var React = require_react();
    function NoSymbolIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"
      }));
    }
    var ForwardRef = React.forwardRef(NoSymbolIcon);
    module.exports = ForwardRef;
  }
});
var require_PaintBrushIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PaintBrushIcon.js"(exports, module) {
    var React = require_react();
    function PaintBrushIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42"
      }));
    }
    var ForwardRef = React.forwardRef(PaintBrushIcon);
    module.exports = ForwardRef;
  }
});
var require_PaperAirplaneIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PaperAirplaneIcon.js"(exports, module) {
    var React = require_react();
    function PaperAirplaneIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6 12L3.269 3.126A59.768 59.768 0 0121.485 12 59.77 59.77 0 013.27 20.876L5.999 12zm0 0h7.5"
      }));
    }
    var ForwardRef = React.forwardRef(PaperAirplaneIcon);
    module.exports = ForwardRef;
  }
});
var require_PaperClipIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PaperClipIcon.js"(exports, module) {
    var React = require_react();
    function PaperClipIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M18.375 12.739l-7.693 7.693a4.5 4.5 0 01-6.364-6.364l10.94-10.94A3 3 0 1119.5 7.372L8.552 18.32m.009-.01l-.01.01m5.699-9.941l-7.81 7.81a1.5 1.5 0 002.112 2.13"
      }));
    }
    var ForwardRef = React.forwardRef(PaperClipIcon);
    module.exports = ForwardRef;
  }
});
var require_PauseCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PauseCircleIcon.js"(exports, module) {
    var React = require_react();
    function PauseCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.25 9v6m-4.5 0V9M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(PauseCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_PauseIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PauseIcon.js"(exports, module) {
    var React = require_react();
    function PauseIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 5.25v13.5m-7.5-13.5v13.5"
      }));
    }
    var ForwardRef = React.forwardRef(PauseIcon);
    module.exports = ForwardRef;
  }
});
var require_PencilSquareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PencilSquareIcon.js"(exports, module) {
    var React = require_react();
    function PencilSquareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10"
      }));
    }
    var ForwardRef = React.forwardRef(PencilSquareIcon);
    module.exports = ForwardRef;
  }
});
var require_PencilIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PencilIcon.js"(exports, module) {
    var React = require_react();
    function PencilIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L6.832 19.82a4.5 4.5 0 01-1.897 1.13l-2.685.8.8-2.685a4.5 4.5 0 011.13-1.897L16.863 4.487zm0 0L19.5 7.125"
      }));
    }
    var ForwardRef = React.forwardRef(PencilIcon);
    module.exports = ForwardRef;
  }
});
var require_PhoneArrowDownLeftIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PhoneArrowDownLeftIcon.js"(exports, module) {
    var React = require_react();
    function PhoneArrowDownLeftIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.25 9.75v-4.5m0 4.5h4.5m-4.5 0l6-6m-3 18c-8.284 0-15-6.716-15-15V4.5A2.25 2.25 0 014.5 2.25h1.372c.516 0 .966.351 1.091.852l1.106 4.423c.11.44-.054.902-.417 1.173l-1.293.97a1.062 1.062 0 00-.38 1.21 12.035 12.035 0 007.143 7.143c.441.162.928-.004 1.21-.38l.97-1.293a1.125 1.125 0 011.173-.417l4.423 1.106c.5.125.852.575.852 1.091V19.5a2.25 2.25 0 01-2.25 2.25h-2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneArrowDownLeftIcon);
    module.exports = ForwardRef;
  }
});
var require_PhoneArrowUpRightIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PhoneArrowUpRightIcon.js"(exports, module) {
    var React = require_react();
    function PhoneArrowUpRightIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M20.25 3.75v4.5m0-4.5h-4.5m4.5 0l-6 6m3 12c-8.284 0-15-6.716-15-15V4.5A2.25 2.25 0 014.5 2.25h1.372c.516 0 .966.351 1.091.852l1.106 4.423c.11.44-.054.902-.417 1.173l-1.293.97a1.062 1.062 0 00-.38 1.21 12.035 12.035 0 007.143 7.143c.441.162.928-.004 1.21-.38l.97-1.293a1.125 1.125 0 011.173-.417l4.423 1.106c.5.125.852.575.852 1.091V19.5a2.25 2.25 0 01-2.25 2.25h-2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneArrowUpRightIcon);
    module.exports = ForwardRef;
  }
});
var require_PhoneXMarkIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PhoneXMarkIcon.js"(exports, module) {
    var React = require_react();
    function PhoneXMarkIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 3.75L18 6m0 0l2.25 2.25M18 6l2.25-2.25M18 6l-2.25 2.25m1.5 13.5c-8.284 0-15-6.716-15-15V4.5A2.25 2.25 0 014.5 2.25h1.372c.516 0 .966.351 1.091.852l1.106 4.423c.11.44-.054.902-.417 1.173l-1.293.97a1.062 1.062 0 00-.38 1.21 12.035 12.035 0 007.143 7.143c.441.162.928-.004 1.21-.38l.97-1.293a1.125 1.125 0 011.173-.417l4.423 1.106c.5.125.852.575.852 1.091V19.5a2.25 2.25 0 01-2.25 2.25h-2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneXMarkIcon);
    module.exports = ForwardRef;
  }
});
var require_PhoneIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PhoneIcon.js"(exports, module) {
    var React = require_react();
    function PhoneIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 6.75c0 8.284 6.716 15 15 15h2.25a2.25 2.25 0 002.25-2.25v-1.372c0-.516-.351-.966-.852-1.091l-4.423-1.106c-.44-.11-.902.055-1.173.417l-.97 1.293c-.282.376-.769.542-1.21.38a12.035 12.035 0 01-7.143-7.143c-.162-.441.004-.928.38-1.21l1.293-.97c.363-.271.527-.734.417-1.173L6.963 3.102a1.125 1.125 0 00-1.091-.852H4.5A2.25 2.25 0 002.25 4.5v2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(PhoneIcon);
    module.exports = ForwardRef;
  }
});
var require_PhotoIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PhotoIcon.js"(exports, module) {
    var React = require_react();
    function PhotoIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 001.5-1.5V6a1.5 1.5 0 00-1.5-1.5H3.75A1.5 1.5 0 002.25 6v12a1.5 1.5 0 001.5 1.5zm10.5-11.25h.008v.008h-.008V8.25zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z"
      }));
    }
    var ForwardRef = React.forwardRef(PhotoIcon);
    module.exports = ForwardRef;
  }
});
var require_PlayCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PlayCircleIcon.js"(exports, module) {
    var React = require_react();
    function PlayCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.91 11.672a.375.375 0 010 .656l-5.603 3.113a.375.375 0 01-.557-.328V8.887c0-.286.307-.466.557-.327l5.603 3.112z"
      }));
    }
    var ForwardRef = React.forwardRef(PlayCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_PlayPauseIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PlayPauseIcon.js"(exports, module) {
    var React = require_react();
    function PlayPauseIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 7.5V18M15 7.5V18M3 16.811V8.69c0-.864.933-1.406 1.683-.977l7.108 4.061a1.125 1.125 0 010 1.954l-7.108 4.061A1.125 1.125 0 013 16.811z"
      }));
    }
    var ForwardRef = React.forwardRef(PlayPauseIcon);
    module.exports = ForwardRef;
  }
});
var require_PlayIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PlayIcon.js"(exports, module) {
    var React = require_react();
    function PlayIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M5.25 5.653c0-.856.917-1.398 1.667-.986l11.54 6.348a1.125 1.125 0 010 1.971l-11.54 6.347a1.125 1.125 0 01-1.667-.985V5.653z"
      }));
    }
    var ForwardRef = React.forwardRef(PlayIcon);
    module.exports = ForwardRef;
  }
});
var require_PlusCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PlusCircleIcon.js"(exports, module) {
    var React = require_react();
    function PlusCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 9v6m3-3H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(PlusCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_PlusSmallIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PlusSmallIcon.js"(exports, module) {
    var React = require_react();
    function PlusSmallIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 6v12m6-6H6"
      }));
    }
    var ForwardRef = React.forwardRef(PlusSmallIcon);
    module.exports = ForwardRef;
  }
});
var require_PlusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PlusIcon.js"(exports, module) {
    var React = require_react();
    function PlusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 4.5v15m7.5-7.5h-15"
      }));
    }
    var ForwardRef = React.forwardRef(PlusIcon);
    module.exports = ForwardRef;
  }
});
var require_PowerIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PowerIcon.js"(exports, module) {
    var React = require_react();
    function PowerIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M5.636 5.636a9 9 0 1012.728 0M12 3v9"
      }));
    }
    var ForwardRef = React.forwardRef(PowerIcon);
    module.exports = ForwardRef;
  }
});
var require_PresentationChartBarIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PresentationChartBarIcon.js"(exports, module) {
    var React = require_react();
    function PresentationChartBarIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 3v11.25A2.25 2.25 0 006 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0118 16.5h-2.25m-7.5 0h7.5m-7.5 0l-1 3m8.5-3l1 3m0 0l.5 1.5m-.5-1.5h-9.5m0 0l-.5 1.5M9 11.25v1.5M12 9v3.75m3-6v6"
      }));
    }
    var ForwardRef = React.forwardRef(PresentationChartBarIcon);
    module.exports = ForwardRef;
  }
});
var require_PresentationChartLineIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PresentationChartLineIcon.js"(exports, module) {
    var React = require_react();
    function PresentationChartLineIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 3v11.25A2.25 2.25 0 006 16.5h2.25M3.75 3h-1.5m1.5 0h16.5m0 0h1.5m-1.5 0v11.25A2.25 2.25 0 0118 16.5h-2.25m-7.5 0h7.5m-7.5 0l-1 3m8.5-3l1 3m0 0l.5 1.5m-.5-1.5h-9.5m0 0l-.5 1.5m.75-9l3-3 2.148 2.148A12.061 12.061 0 0116.5 7.605"
      }));
    }
    var ForwardRef = React.forwardRef(PresentationChartLineIcon);
    module.exports = ForwardRef;
  }
});
var require_PrinterIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PrinterIcon.js"(exports, module) {
    var React = require_react();
    function PrinterIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.72 13.829c-.24.03-.48.062-.72.096m.72-.096a42.415 42.415 0 0110.56 0m-10.56 0L6.34 18m10.94-4.171c.24.03.48.062.72.096m-.72-.096L17.66 18m0 0l.229 2.523a1.125 1.125 0 01-1.12 1.227H7.231c-.662 0-1.18-.568-1.12-1.227L6.34 18m11.318 0h1.091A2.25 2.25 0 0021 15.75V9.456c0-1.081-.768-2.015-1.837-2.175a48.055 48.055 0 00-1.913-.247M6.34 18H5.25A2.25 2.25 0 013 15.75V9.456c0-1.081.768-2.015 1.837-2.175a48.041 48.041 0 011.913-.247m10.5 0a48.536 48.536 0 00-10.5 0m10.5 0V3.375c0-.621-.504-1.125-1.125-1.125h-8.25c-.621 0-1.125.504-1.125 1.125v3.659M18 10.5h.008v.008H18V10.5zm-3 0h.008v.008H15V10.5z"
      }));
    }
    var ForwardRef = React.forwardRef(PrinterIcon);
    module.exports = ForwardRef;
  }
});
var require_PuzzlePieceIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/PuzzlePieceIcon.js"(exports, module) {
    var React = require_react();
    function PuzzlePieceIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.25 6.087c0-.355.186-.676.401-.959.221-.29.349-.634.349-1.003 0-1.036-1.007-1.875-2.25-1.875s-2.25.84-2.25 1.875c0 .369.128.713.349 1.003.215.283.401.604.401.959v0a.64.64 0 01-.657.643 48.39 48.39 0 01-4.163-.3c.186 1.613.293 3.25.315 4.907a.656.656 0 01-.658.663v0c-.355 0-.676-.186-.959-.401a1.647 1.647 0 00-1.003-.349c-1.036 0-1.875 1.007-1.875 2.25s.84 2.25 1.875 2.25c.369 0 .713-.128 1.003-.349.283-.215.604-.401.959-.401v0c.31 0 .555.26.532.57a48.039 48.039 0 01-.642 5.056c1.518.19 3.058.309 4.616.354a.64.64 0 00.657-.643v0c0-.355-.186-.676-.401-.959a1.647 1.647 0 01-.349-1.003c0-1.035 1.008-1.875 2.25-1.875 1.243 0 2.25.84 2.25 1.875 0 .369-.128.713-.349 1.003-.215.283-.4.604-.4.959v0c0 .333.277.599.61.58a48.1 48.1 0 005.427-.63 48.05 48.05 0 00.582-4.717.532.532 0 00-.533-.57v0c-.355 0-.676.186-.959.401-.29.221-.634.349-1.003.349-1.035 0-1.875-1.007-1.875-2.25s.84-2.25 1.875-2.25c.37 0 .713.128 1.003.349.283.215.604.401.96.401v0a.656.656 0 00.658-.663 48.422 48.422 0 00-.37-5.36c-1.886.342-3.81.574-5.766.689a.578.578 0 01-.61-.58v0z"
      }));
    }
    var ForwardRef = React.forwardRef(PuzzlePieceIcon);
    module.exports = ForwardRef;
  }
});
var require_QrCodeIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/QrCodeIcon.js"(exports, module) {
    var React = require_react();
    function QrCodeIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 4.875c0-.621.504-1.125 1.125-1.125h4.5c.621 0 1.125.504 1.125 1.125v4.5c0 .621-.504 1.125-1.125 1.125h-4.5A1.125 1.125 0 013.75 9.375v-4.5zM3.75 14.625c0-.621.504-1.125 1.125-1.125h4.5c.621 0 1.125.504 1.125 1.125v4.5c0 .621-.504 1.125-1.125 1.125h-4.5a1.125 1.125 0 01-1.125-1.125v-4.5zM13.5 4.875c0-.621.504-1.125 1.125-1.125h4.5c.621 0 1.125.504 1.125 1.125v4.5c0 .621-.504 1.125-1.125 1.125h-4.5A1.125 1.125 0 0113.5 9.375v-4.5z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.75 6.75h.75v.75h-.75v-.75zM6.75 16.5h.75v.75h-.75v-.75zM16.5 6.75h.75v.75h-.75v-.75zM13.5 13.5h.75v.75h-.75v-.75zM13.5 19.5h.75v.75h-.75v-.75zM19.5 13.5h.75v.75h-.75v-.75zM19.5 19.5h.75v.75h-.75v-.75zM16.5 16.5h.75v.75h-.75v-.75z"
      }));
    }
    var ForwardRef = React.forwardRef(QrCodeIcon);
    module.exports = ForwardRef;
  }
});
var require_QuestionMarkCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/QuestionMarkCircleIcon.js"(exports, module) {
    var React = require_react();
    function QuestionMarkCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.879 7.519c1.171-1.025 3.071-1.025 4.242 0 1.172 1.025 1.172 2.687 0 3.712-.203.179-.43.326-.67.442-.745.361-1.45.999-1.45 1.827v.75M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9 5.25h.008v.008H12v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(QuestionMarkCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_QueueListIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/QueueListIcon.js"(exports, module) {
    var React = require_react();
    function QueueListIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 12h16.5m-16.5 3.75h16.5M3.75 19.5h16.5M5.625 4.5h12.75a1.875 1.875 0 010 3.75H5.625a1.875 1.875 0 010-3.75z"
      }));
    }
    var ForwardRef = React.forwardRef(QueueListIcon);
    module.exports = ForwardRef;
  }
});
var require_RadioIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/RadioIcon.js"(exports, module) {
    var React = require_react();
    function RadioIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 7.5l16.5-4.125M12 6.75c-2.708 0-5.363.224-7.948.655C2.999 7.58 2.25 8.507 2.25 9.574v9.176A2.25 2.25 0 004.5 21h15a2.25 2.25 0 002.25-2.25V9.574c0-1.067-.75-1.994-1.802-2.169A48.329 48.329 0 0012 6.75zm-1.683 6.443l-.005.005-.006-.005.006-.005.005.005zm-.005 2.127l-.005-.006.005-.005.005.005-.005.005zm-2.116-.006l-.005.006-.006-.006.005-.005.006.005zm-.005-2.116l-.006-.005.006-.005.005.005-.005.005zM9.255 10.5v.008h-.008V10.5h.008zm3.249 1.88l-.007.004-.003-.007.006-.003.004.006zm-1.38 5.126l-.003-.006.006-.004.004.007-.006.003zm.007-6.501l-.003.006-.007-.003.004-.007.006.004zm1.37 5.129l-.007-.004.004-.006.006.003-.004.007zm.504-1.877h-.008v-.007h.008v.007zM9.255 18v.008h-.008V18h.008zm-3.246-1.87l-.007.004L6 16.127l.006-.003.004.006zm1.366-5.119l-.004-.006.006-.004.004.007-.006.003zM7.38 17.5l-.003.006-.007-.003.004-.007.006.004zm-1.376-5.116L6 12.38l.003-.007.007.004-.004.007zm-.5 1.873h-.008v-.007h.008v.007zM17.25 12.75a.75.75 0 110-1.5.75.75 0 010 1.5zm0 4.5a.75.75 0 110-1.5.75.75 0 010 1.5z"
      }));
    }
    var ForwardRef = React.forwardRef(RadioIcon);
    module.exports = ForwardRef;
  }
});
var require_ReceiptPercentIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ReceiptPercentIcon.js"(exports, module) {
    var React = require_react();
    function ReceiptPercentIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 14.25l6-6m4.5-3.493V21.75l-3.75-1.5-3.75 1.5-3.75-1.5-3.75 1.5V4.757c0-1.108.806-2.057 1.907-2.185a48.507 48.507 0 0111.186 0c1.1.128 1.907 1.077 1.907 2.185zM9.75 9h.008v.008H9.75V9zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0zm4.125 4.5h.008v.008h-.008V13.5zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ReceiptPercentIcon);
    module.exports = ForwardRef;
  }
});
var require_ReceiptRefundIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ReceiptRefundIcon.js"(exports, module) {
    var React = require_react();
    function ReceiptRefundIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 9.75h4.875a2.625 2.625 0 010 5.25H12M8.25 9.75L10.5 7.5M8.25 9.75L10.5 12m9-7.243V21.75l-3.75-1.5-3.75 1.5-3.75-1.5-3.75 1.5V4.757c0-1.108.806-2.057 1.907-2.185a48.507 48.507 0 0111.186 0c1.1.128 1.907 1.077 1.907 2.185z"
      }));
    }
    var ForwardRef = React.forwardRef(ReceiptRefundIcon);
    module.exports = ForwardRef;
  }
});
var require_RectangleGroupIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/RectangleGroupIcon.js"(exports, module) {
    var React = require_react();
    function RectangleGroupIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 7.125C2.25 6.504 2.754 6 3.375 6h6c.621 0 1.125.504 1.125 1.125v3.75c0 .621-.504 1.125-1.125 1.125h-6a1.125 1.125 0 01-1.125-1.125v-3.75zM14.25 8.625c0-.621.504-1.125 1.125-1.125h5.25c.621 0 1.125.504 1.125 1.125v8.25c0 .621-.504 1.125-1.125 1.125h-5.25a1.125 1.125 0 01-1.125-1.125v-8.25zM3.75 16.125c0-.621.504-1.125 1.125-1.125h5.25c.621 0 1.125.504 1.125 1.125v2.25c0 .621-.504 1.125-1.125 1.125h-5.25a1.125 1.125 0 01-1.125-1.125v-2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(RectangleGroupIcon);
    module.exports = ForwardRef;
  }
});
var require_RectangleStackIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/RectangleStackIcon.js"(exports, module) {
    var React = require_react();
    function RectangleStackIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6 6.878V6a2.25 2.25 0 012.25-2.25h7.5A2.25 2.25 0 0118 6v.878m-12 0c.235-.083.487-.128.75-.128h10.5c.263 0 .515.045.75.128m-12 0A2.25 2.25 0 004.5 9v.878m13.5-3A2.25 2.25 0 0119.5 9v.878m0 0a2.246 2.246 0 00-.75-.128H5.25c-.263 0-.515.045-.75.128m15 0A2.25 2.25 0 0121 12v6a2.25 2.25 0 01-2.25 2.25H5.25A2.25 2.25 0 013 18v-6c0-.98.626-1.813 1.5-2.122"
      }));
    }
    var ForwardRef = React.forwardRef(RectangleStackIcon);
    module.exports = ForwardRef;
  }
});
var require_RocketLaunchIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/RocketLaunchIcon.js"(exports, module) {
    var React = require_react();
    function RocketLaunchIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.59 14.37a6 6 0 01-5.84 7.38v-4.8m5.84-2.58a14.98 14.98 0 006.16-12.12A14.98 14.98 0 009.631 8.41m5.96 5.96a14.926 14.926 0 01-5.841 2.58m-.119-8.54a6 6 0 00-7.381 5.84h4.8m2.581-5.84a14.927 14.927 0 00-2.58 5.84m2.699 2.7c-.103.021-.207.041-.311.06a15.09 15.09 0 01-2.448-2.448 14.9 14.9 0 01.06-.312m-2.24 2.39a4.493 4.493 0 00-1.757 4.306 4.493 4.493 0 004.306-1.758M16.5 9a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0z"
      }));
    }
    var ForwardRef = React.forwardRef(RocketLaunchIcon);
    module.exports = ForwardRef;
  }
});
var require_RssIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/RssIcon.js"(exports, module) {
    var React = require_react();
    function RssIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12.75 19.5v-.75a7.5 7.5 0 00-7.5-7.5H4.5m0-6.75h.75c7.87 0 14.25 6.38 14.25 14.25v.75M6 18.75a.75.75 0 11-1.5 0 .75.75 0 011.5 0z"
      }));
    }
    var ForwardRef = React.forwardRef(RssIcon);
    module.exports = ForwardRef;
  }
});
var require_ScaleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ScaleIcon.js"(exports, module) {
    var React = require_react();
    function ScaleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 3v17.25m0 0c-1.472 0-2.882.265-4.185.75M12 20.25c1.472 0 2.882.265 4.185.75M18.75 4.97A48.416 48.416 0 0012 4.5c-2.291 0-4.545.16-6.75.47m13.5 0c1.01.143 2.01.317 3 .52m-3-.52l2.62 10.726c.122.499-.106 1.028-.589 1.202a5.988 5.988 0 01-2.031.352 5.988 5.988 0 01-2.031-.352c-.483-.174-.711-.703-.59-1.202L18.75 4.971zm-16.5.52c.99-.203 1.99-.377 3-.52m0 0l2.62 10.726c.122.499-.106 1.028-.589 1.202a5.989 5.989 0 01-2.031.352 5.989 5.989 0 01-2.031-.352c-.483-.174-.711-.703-.59-1.202L5.25 4.971z"
      }));
    }
    var ForwardRef = React.forwardRef(ScaleIcon);
    module.exports = ForwardRef;
  }
});
var require_ScissorsIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ScissorsIcon.js"(exports, module) {
    var React = require_react();
    function ScissorsIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.848 8.25l1.536.887M7.848 8.25a3 3 0 11-5.196-3 3 3 0 015.196 3zm1.536.887a2.165 2.165 0 011.083 1.839c.005.351.054.695.14 1.024M9.384 9.137l2.077 1.199M7.848 15.75l1.536-.887m-1.536.887a3 3 0 11-5.196 3 3 3 0 015.196-3zm1.536-.887a2.165 2.165 0 001.083-1.838c.005-.352.054-.695.14-1.025m-1.223 2.863l2.077-1.199m0-3.328a4.323 4.323 0 012.068-1.379l5.325-1.628a4.5 4.5 0 012.48-.044l.803.215-7.794 4.5m-2.882-1.664A4.331 4.331 0 0010.607 12m3.736 0l7.794 4.5-.802.215a4.5 4.5 0 01-2.48-.043l-5.326-1.629a4.324 4.324 0 01-2.068-1.379M14.343 12l-2.882 1.664"
      }));
    }
    var ForwardRef = React.forwardRef(ScissorsIcon);
    module.exports = ForwardRef;
  }
});
var require_ServerStackIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ServerStackIcon.js"(exports, module) {
    var React = require_react();
    function ServerStackIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M5.25 14.25h13.5m-13.5 0a3 3 0 01-3-3m3 3a3 3 0 100 6h13.5a3 3 0 100-6m-16.5-3a3 3 0 013-3h13.5a3 3 0 013 3m-19.5 0a4.5 4.5 0 01.9-2.7L5.737 5.1a3.375 3.375 0 012.7-1.35h7.126c1.062 0 2.062.5 2.7 1.35l2.587 3.45a4.5 4.5 0 01.9 2.7m0 0a3 3 0 01-3 3m0 3h.008v.008h-.008v-.008zm0-6h.008v.008h-.008v-.008zm-3 6h.008v.008h-.008v-.008zm0-6h.008v.008h-.008v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(ServerStackIcon);
    module.exports = ForwardRef;
  }
});
var require_ServerIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ServerIcon.js"(exports, module) {
    var React = require_react();
    function ServerIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21.75 17.25v-.228a4.5 4.5 0 00-.12-1.03l-2.268-9.64a3.375 3.375 0 00-3.285-2.602H7.923a3.375 3.375 0 00-3.285 2.602l-2.268 9.64a4.5 4.5 0 00-.12 1.03v.228m19.5 0a3 3 0 01-3 3H5.25a3 3 0 01-3-3m19.5 0a3 3 0 00-3-3H5.25a3 3 0 00-3 3m16.5 0h.008v.008h-.008v-.008zm-3 0h.008v.008h-.008v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(ServerIcon);
    module.exports = ForwardRef;
  }
});
var require_ShareIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ShareIcon.js"(exports, module) {
    var React = require_react();
    function ShareIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.217 10.907a2.25 2.25 0 100 2.186m0-2.186c.18.324.283.696.283 1.093s-.103.77-.283 1.093m0-2.186l9.566-5.314m-9.566 7.5l9.566 5.314m0 0a2.25 2.25 0 103.935 2.186 2.25 2.25 0 00-3.935-2.186zm0-12.814a2.25 2.25 0 103.933-2.185 2.25 2.25 0 00-3.933 2.185z"
      }));
    }
    var ForwardRef = React.forwardRef(ShareIcon);
    module.exports = ForwardRef;
  }
});
var require_ShieldCheckIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ShieldCheckIcon.js"(exports, module) {
    var React = require_react();
    function ShieldCheckIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751h-.152c-3.196 0-6.1-1.248-8.25-3.285z"
      }));
    }
    var ForwardRef = React.forwardRef(ShieldCheckIcon);
    module.exports = ForwardRef;
  }
});
var require_ShieldExclamationIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ShieldExclamationIcon.js"(exports, module) {
    var React = require_react();
    function ShieldExclamationIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 9v3.75m0-10.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.75c0 5.592 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.57-.598-3.75h-.152c-3.196 0-6.1-1.249-8.25-3.286zm0 13.036h.008v.008H12v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(ShieldExclamationIcon);
    module.exports = ForwardRef;
  }
});
var require_ShoppingBagIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ShoppingBagIcon.js"(exports, module) {
    var React = require_react();
    function ShoppingBagIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 10.5V6a3.75 3.75 0 10-7.5 0v4.5m11.356-1.993l1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 01-1.12-1.243l1.264-12A1.125 1.125 0 015.513 7.5h12.974c.576 0 1.059.435 1.119 1.007zM8.625 10.5a.375.375 0 11-.75 0 .375.375 0 01.75 0zm7.5 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ShoppingBagIcon);
    module.exports = ForwardRef;
  }
});
var require_ShoppingCartIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ShoppingCartIcon.js"(exports, module) {
    var React = require_react();
    function ShoppingCartIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ShoppingCartIcon);
    module.exports = ForwardRef;
  }
});
var require_SignalSlashIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SignalSlashIcon.js"(exports, module) {
    var React = require_react();
    function SignalSlashIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 3l8.735 8.735m0 0a.374.374 0 11.53.53m-.53-.53l.53.53m0 0L21 21M14.652 9.348a3.75 3.75 0 010 5.304m2.121-7.425a6.75 6.75 0 010 9.546m2.121-11.667c3.808 3.807 3.808 9.98 0 13.788m-9.546-4.242a3.733 3.733 0 01-1.06-2.122m-1.061 4.243a6.75 6.75 0 01-1.625-6.929m-.496 9.05c-3.068-3.067-3.664-7.67-1.79-11.334M12 12h.008v.008H12V12z"
      }));
    }
    var ForwardRef = React.forwardRef(SignalSlashIcon);
    module.exports = ForwardRef;
  }
});
var require_SignalIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SignalIcon.js"(exports, module) {
    var React = require_react();
    function SignalIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.348 14.651a3.75 3.75 0 010-5.303m5.304 0a3.75 3.75 0 010 5.303m-7.425 2.122a6.75 6.75 0 010-9.546m9.546 0a6.75 6.75 0 010 9.546M5.106 18.894c-3.808-3.808-3.808-9.98 0-13.789m13.788 0c3.808 3.808 3.808 9.981 0 13.79M12 12h.008v.007H12V12zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z"
      }));
    }
    var ForwardRef = React.forwardRef(SignalIcon);
    module.exports = ForwardRef;
  }
});
var require_SparklesIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SparklesIcon.js"(exports, module) {
    var React = require_react();
    function SparklesIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.456 2.456L21.75 6l-1.035.259a3.375 3.375 0 00-2.456 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z"
      }));
    }
    var ForwardRef = React.forwardRef(SparklesIcon);
    module.exports = ForwardRef;
  }
});
var require_SpeakerWaveIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SpeakerWaveIcon.js"(exports, module) {
    var React = require_react();
    function SpeakerWaveIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19.114 5.636a9 9 0 010 12.728M16.463 8.288a5.25 5.25 0 010 7.424M6.75 8.25l4.72-4.72a.75.75 0 011.28.53v15.88a.75.75 0 01-1.28.53l-4.72-4.72H4.51c-.88 0-1.704-.507-1.938-1.354A9.01 9.01 0 012.25 12c0-.83.112-1.633.322-2.396C2.806 8.756 3.63 8.25 4.51 8.25H6.75z"
      }));
    }
    var ForwardRef = React.forwardRef(SpeakerWaveIcon);
    module.exports = ForwardRef;
  }
});
var require_SpeakerXMarkIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SpeakerXMarkIcon.js"(exports, module) {
    var React = require_react();
    function SpeakerXMarkIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17.25 9.75L19.5 12m0 0l2.25 2.25M19.5 12l2.25-2.25M19.5 12l-2.25 2.25m-10.5-6l4.72-4.72a.75.75 0 011.28.531V19.94a.75.75 0 01-1.28.53l-4.72-4.72H4.51c-.88 0-1.704-.506-1.938-1.354A9.01 9.01 0 012.25 12c0-.83.112-1.633.322-2.395C2.806 8.757 3.63 8.25 4.51 8.25H6.75z"
      }));
    }
    var ForwardRef = React.forwardRef(SpeakerXMarkIcon);
    module.exports = ForwardRef;
  }
});
var require_Square2StackIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Square2StackIcon.js"(exports, module) {
    var React = require_react();
    function Square2StackIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.5 8.25V6a2.25 2.25 0 00-2.25-2.25H6A2.25 2.25 0 003.75 6v8.25A2.25 2.25 0 006 16.5h2.25m8.25-8.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-7.5A2.25 2.25 0 018.25 18v-1.5m8.25-8.25h-6a2.25 2.25 0 00-2.25 2.25v6"
      }));
    }
    var ForwardRef = React.forwardRef(Square2StackIcon);
    module.exports = ForwardRef;
  }
});
var require_Square3Stack3DIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Square3Stack3DIcon.js"(exports, module) {
    var React = require_react();
    function Square3Stack3DIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6.429 9.75L2.25 12l4.179 2.25m0-4.5l5.571 3 5.571-3m-11.142 0L2.25 7.5 12 2.25l9.75 5.25-4.179 2.25m0 0L21.75 12l-4.179 2.25m0 0l4.179 2.25L12 21.75 2.25 16.5l4.179-2.25m11.142 0l-5.571 3-5.571-3"
      }));
    }
    var ForwardRef = React.forwardRef(Square3Stack3DIcon);
    module.exports = ForwardRef;
  }
});
var require_Squares2X2Icon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/Squares2X2Icon.js"(exports, module) {
    var React = require_react();
    function Squares2X2Icon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(Squares2X2Icon);
    module.exports = ForwardRef;
  }
});
var require_SquaresPlusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SquaresPlusIcon.js"(exports, module) {
    var React = require_react();
    function SquaresPlusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M13.5 16.875h3.375m0 0h3.375m-3.375 0V13.5m0 3.375v3.375M6 10.5h2.25a2.25 2.25 0 002.25-2.25V6a2.25 2.25 0 00-2.25-2.25H6A2.25 2.25 0 003.75 6v2.25A2.25 2.25 0 006 10.5zm0 9.75h2.25A2.25 2.25 0 0010.5 18v-2.25a2.25 2.25 0 00-2.25-2.25H6a2.25 2.25 0 00-2.25 2.25V18A2.25 2.25 0 006 20.25zm9.75-9.75H18a2.25 2.25 0 002.25-2.25V6A2.25 2.25 0 0018 3.75h-2.25A2.25 2.25 0 0013.5 6v2.25a2.25 2.25 0 002.25 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(SquaresPlusIcon);
    module.exports = ForwardRef;
  }
});
var require_StarIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/StarIcon.js"(exports, module) {
    var React = require_react();
    function StarIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z"
      }));
    }
    var ForwardRef = React.forwardRef(StarIcon);
    module.exports = ForwardRef;
  }
});
var require_StopCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/StopCircleIcon.js"(exports, module) {
    var React = require_react();
    function StopCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 9.563C9 9.252 9.252 9 9.563 9h4.874c.311 0 .563.252.563.563v4.874c0 .311-.252.563-.563.563H9.564A.562.562 0 019 14.437V9.564z"
      }));
    }
    var ForwardRef = React.forwardRef(StopCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_StopIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/StopIcon.js"(exports, module) {
    var React = require_react();
    function StopIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M5.25 7.5A2.25 2.25 0 017.5 5.25h9a2.25 2.25 0 012.25 2.25v9a2.25 2.25 0 01-2.25 2.25h-9a2.25 2.25 0 01-2.25-2.25v-9z"
      }));
    }
    var ForwardRef = React.forwardRef(StopIcon);
    module.exports = ForwardRef;
  }
});
var require_SunIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SunIcon.js"(exports, module) {
    var React = require_react();
    function SunIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M12 3v2.25m6.364.386l-1.591 1.591M21 12h-2.25m-.386 6.364l-1.591-1.591M12 18.75V21m-4.773-4.227l-1.591 1.591M5.25 12H3m4.227-4.773L5.636 5.636M15.75 12a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0z"
      }));
    }
    var ForwardRef = React.forwardRef(SunIcon);
    module.exports = ForwardRef;
  }
});
var require_SwatchIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/SwatchIcon.js"(exports, module) {
    var React = require_react();
    function SwatchIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.098 19.902a3.75 3.75 0 005.304 0l6.401-6.402M6.75 21A3.75 3.75 0 013 17.25V4.125C3 3.504 3.504 3 4.125 3h5.25c.621 0 1.125.504 1.125 1.125v4.072M6.75 21a3.75 3.75 0 003.75-3.75V8.197M6.75 21h13.125c.621 0 1.125-.504 1.125-1.125v-5.25c0-.621-.504-1.125-1.125-1.125h-4.072M10.5 8.197l2.88-2.88c.438-.439 1.15-.439 1.59 0l3.712 3.713c.44.44.44 1.152 0 1.59l-2.879 2.88M6.75 17.25h.008v.008H6.75v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(SwatchIcon);
    module.exports = ForwardRef;
  }
});
var require_TableCellsIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/TableCellsIcon.js"(exports, module) {
    var React = require_react();
    function TableCellsIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3.375 19.5h17.25m-17.25 0a1.125 1.125 0 01-1.125-1.125M3.375 19.5h7.5c.621 0 1.125-.504 1.125-1.125m-9.75 0V5.625m0 12.75v-1.5c0-.621.504-1.125 1.125-1.125m18.375 2.625V5.625m0 12.75c0 .621-.504 1.125-1.125 1.125m1.125-1.125v-1.5c0-.621-.504-1.125-1.125-1.125m0 3.75h-7.5A1.125 1.125 0 0112 18.375m9.75-12.75c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125m19.5 0v1.5c0 .621-.504 1.125-1.125 1.125M2.25 5.625v1.5c0 .621.504 1.125 1.125 1.125m0 0h17.25m-17.25 0h7.5c.621 0 1.125.504 1.125 1.125M3.375 8.25c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125m17.25-3.75h-7.5c-.621 0-1.125.504-1.125 1.125m8.625-1.125c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125v1.5c0 .621.504 1.125 1.125 1.125M12 10.875v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 10.875c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125M13.125 12h7.5m-7.5 0c-.621 0-1.125.504-1.125 1.125M20.625 12c.621 0 1.125.504 1.125 1.125v1.5c0 .621-.504 1.125-1.125 1.125m-17.25 0h7.5M12 14.625v-1.5m0 1.5c0 .621-.504 1.125-1.125 1.125M12 14.625c0 .621.504 1.125 1.125 1.125m-2.25 0c.621 0 1.125.504 1.125 1.125m0 1.5v-1.5m0 0c0-.621.504-1.125 1.125-1.125m0 0h7.5"
      }));
    }
    var ForwardRef = React.forwardRef(TableCellsIcon);
    module.exports = ForwardRef;
  }
});
var require_TagIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/TagIcon.js"(exports, module) {
    var React = require_react();
    function TagIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.568 3H5.25A2.25 2.25 0 003 5.25v4.318c0 .597.237 1.17.659 1.591l9.581 9.581c.699.699 1.78.872 2.607.33a18.095 18.095 0 005.223-5.223c.542-.827.369-1.908-.33-2.607L11.16 3.66A2.25 2.25 0 009.568 3z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6 6h.008v.008H6V6z"
      }));
    }
    var ForwardRef = React.forwardRef(TagIcon);
    module.exports = ForwardRef;
  }
});
var require_TicketIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/TicketIcon.js"(exports, module) {
    var React = require_react();
    function TicketIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.5 6v.75m0 3v.75m0 3v.75m0 3V18m-9-5.25h5.25M7.5 15h3M3.375 5.25c-.621 0-1.125.504-1.125 1.125v3.026a2.999 2.999 0 010 5.198v3.026c0 .621.504 1.125 1.125 1.125h17.25c.621 0 1.125-.504 1.125-1.125v-3.026a2.999 2.999 0 010-5.198V6.375c0-.621-.504-1.125-1.125-1.125H3.375z"
      }));
    }
    var ForwardRef = React.forwardRef(TicketIcon);
    module.exports = ForwardRef;
  }
});
var require_TrashIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/TrashIcon.js"(exports, module) {
    var React = require_react();
    function TrashIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0"
      }));
    }
    var ForwardRef = React.forwardRef(TrashIcon);
    module.exports = ForwardRef;
  }
});
var require_TrophyIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/TrophyIcon.js"(exports, module) {
    var React = require_react();
    function TrophyIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M16.5 18.75h-9m9 0a3 3 0 013 3h-15a3 3 0 013-3m9 0v-3.375c0-.621-.503-1.125-1.125-1.125h-.871M7.5 18.75v-3.375c0-.621.504-1.125 1.125-1.125h.872m5.007 0H9.497m5.007 0a7.454 7.454 0 01-.982-3.172M9.497 14.25a7.454 7.454 0 00.981-3.172M5.25 4.236c-.982.143-1.954.317-2.916.52A6.003 6.003 0 007.73 9.728M5.25 4.236V4.5c0 2.108.966 3.99 2.48 5.228M5.25 4.236V2.721C7.456 2.41 9.71 2.25 12 2.25c2.291 0 4.545.16 6.75.47v1.516M7.73 9.728a6.726 6.726 0 002.748 1.35m8.272-6.842V4.5c0 2.108-.966 3.99-2.48 5.228m2.48-5.492a46.32 46.32 0 012.916.52 6.003 6.003 0 01-5.395 4.972m0 0a6.726 6.726 0 01-2.749 1.35m0 0a6.772 6.772 0 01-3.044 0"
      }));
    }
    var ForwardRef = React.forwardRef(TrophyIcon);
    module.exports = ForwardRef;
  }
});
var require_TruckIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/TruckIcon.js"(exports, module) {
    var React = require_react();
    function TruckIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12"
      }));
    }
    var ForwardRef = React.forwardRef(TruckIcon);
    module.exports = ForwardRef;
  }
});
var require_TvIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/TvIcon.js"(exports, module) {
    var React = require_react();
    function TvIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6 20.25h12m-7.5-3v3m3-3v3m-10.125-3h17.25c.621 0 1.125-.504 1.125-1.125V4.875c0-.621-.504-1.125-1.125-1.125H3.375c-.621 0-1.125.504-1.125 1.125v11.25c0 .621.504 1.125 1.125 1.125z"
      }));
    }
    var ForwardRef = React.forwardRef(TvIcon);
    module.exports = ForwardRef;
  }
});
var require_UserCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/UserCircleIcon.js"(exports, module) {
    var React = require_react();
    function UserCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M17.982 18.725A7.488 7.488 0 0012 15.75a7.488 7.488 0 00-5.982 2.975m11.963 0a9 9 0 10-11.963 0m11.963 0A8.966 8.966 0 0112 21a8.966 8.966 0 01-5.982-2.275M15 9.75a3 3 0 11-6 0 3 3 0 016 0z"
      }));
    }
    var ForwardRef = React.forwardRef(UserCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_UserGroupIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/UserGroupIcon.js"(exports, module) {
    var React = require_react();
    function UserGroupIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M18 18.72a9.094 9.094 0 003.741-.479 3 3 0 00-4.682-2.72m.94 3.198l.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0112 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 016 18.719m12 0a5.971 5.971 0 00-.941-3.197m0 0A5.995 5.995 0 0012 12.75a5.995 5.995 0 00-5.058 2.772m0 0a3 3 0 00-4.681 2.72 8.986 8.986 0 003.74.477m.94-3.197a5.971 5.971 0 00-.94 3.197M15 6.75a3 3 0 11-6 0 3 3 0 016 0zm6 3a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0zm-13.5 0a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"
      }));
    }
    var ForwardRef = React.forwardRef(UserGroupIcon);
    module.exports = ForwardRef;
  }
});
var require_UserMinusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/UserMinusIcon.js"(exports, module) {
    var React = require_react();
    function UserMinusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M22 10.5h-6m-2.25-4.125a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zM4 19.235v-.11a6.375 6.375 0 0112.75 0v.109A12.318 12.318 0 0110.374 21c-2.331 0-4.512-.645-6.374-1.766z"
      }));
    }
    var ForwardRef = React.forwardRef(UserMinusIcon);
    module.exports = ForwardRef;
  }
});
var require_UserPlusIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/UserPlusIcon.js"(exports, module) {
    var React = require_react();
    function UserPlusIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M19 7.5v3m0 0v3m0-3h3m-3 0h-3m-2.25-4.125a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zM4 19.235v-.11a6.375 6.375 0 0112.75 0v.109A12.318 12.318 0 0110.374 21c-2.331 0-4.512-.645-6.374-1.766z"
      }));
    }
    var ForwardRef = React.forwardRef(UserPlusIcon);
    module.exports = ForwardRef;
  }
});
var require_UserIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/UserIcon.js"(exports, module) {
    var React = require_react();
    function UserIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z"
      }));
    }
    var ForwardRef = React.forwardRef(UserIcon);
    module.exports = ForwardRef;
  }
});
var require_UsersIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/UsersIcon.js"(exports, module) {
    var React = require_react();
    function UsersIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15 19.128a9.38 9.38 0 002.625.372 9.337 9.337 0 004.121-.952 4.125 4.125 0 00-7.533-2.493M15 19.128v-.003c0-1.113-.285-2.16-.786-3.07M15 19.128v.106A12.318 12.318 0 018.624 21c-2.331 0-4.512-.645-6.374-1.766l-.001-.109a6.375 6.375 0 0111.964-3.07M12 6.375a3.375 3.375 0 11-6.75 0 3.375 3.375 0 016.75 0zm8.25 2.25a2.625 2.625 0 11-5.25 0 2.625 2.625 0 015.25 0z"
      }));
    }
    var ForwardRef = React.forwardRef(UsersIcon);
    module.exports = ForwardRef;
  }
});
var require_VariableIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/VariableIcon.js"(exports, module) {
    var React = require_react();
    function VariableIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.745 3A23.933 23.933 0 003 12c0 3.183.62 6.22 1.745 9M19.5 3c.967 2.78 1.5 5.817 1.5 9s-.533 6.22-1.5 9M8.25 8.885l1.444-.89a.75.75 0 011.105.402l2.402 7.206a.75.75 0 001.104.401l1.445-.889m-8.25.75l.213.09a1.687 1.687 0 002.062-.617l4.45-6.676a1.688 1.688 0 012.062-.618l.213.09"
      }));
    }
    var ForwardRef = React.forwardRef(VariableIcon);
    module.exports = ForwardRef;
  }
});
var require_VideoCameraSlashIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/VideoCameraSlashIcon.js"(exports, module) {
    var React = require_react();
    function VideoCameraSlashIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M15.75 10.5l4.72-4.72a.75.75 0 011.28.53v11.38a.75.75 0 01-1.28.53l-4.72-4.72M12 18.75H4.5a2.25 2.25 0 01-2.25-2.25V9m12.841 9.091L16.5 19.5m-1.409-1.409c.407-.407.659-.97.659-1.591v-9a2.25 2.25 0 00-2.25-2.25h-9c-.621 0-1.184.252-1.591.659m12.182 12.182L2.909 5.909M1.5 4.5l1.409 1.409"
      }));
    }
    var ForwardRef = React.forwardRef(VideoCameraSlashIcon);
    module.exports = ForwardRef;
  }
});
var require_VideoCameraIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/VideoCameraIcon.js"(exports, module) {
    var React = require_react();
    function VideoCameraIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        d: "M15.75 10.5l4.72-4.72a.75.75 0 011.28.53v11.38a.75.75 0 01-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 002.25-2.25v-9a2.25 2.25 0 00-2.25-2.25h-9A2.25 2.25 0 002.25 7.5v9a2.25 2.25 0 002.25 2.25z"
      }));
    }
    var ForwardRef = React.forwardRef(VideoCameraIcon);
    module.exports = ForwardRef;
  }
});
var require_ViewColumnsIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ViewColumnsIcon.js"(exports, module) {
    var React = require_react();
    function ViewColumnsIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9 4.5v15m6-15v15m-10.875 0h15.75c.621 0 1.125-.504 1.125-1.125V5.625c0-.621-.504-1.125-1.125-1.125H4.125C3.504 4.5 3 5.004 3 5.625v12.75c0 .621.504 1.125 1.125 1.125z"
      }));
    }
    var ForwardRef = React.forwardRef(ViewColumnsIcon);
    module.exports = ForwardRef;
  }
});
var require_ViewfinderCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/ViewfinderCircleIcon.js"(exports, module) {
    var React = require_react();
    function ViewfinderCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M7.5 3.75H6A2.25 2.25 0 003.75 6v1.5M16.5 3.75H18A2.25 2.25 0 0120.25 6v1.5m0 9V18A2.25 2.25 0 0118 20.25h-1.5m-9 0H6A2.25 2.25 0 013.75 18v-1.5M15 12a3 3 0 11-6 0 3 3 0 016 0z"
      }));
    }
    var ForwardRef = React.forwardRef(ViewfinderCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_WalletIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/WalletIcon.js"(exports, module) {
    var React = require_react();
    function WalletIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21 12a2.25 2.25 0 00-2.25-2.25H15a3 3 0 11-6 0H5.25A2.25 2.25 0 003 12m18 0v6a2.25 2.25 0 01-2.25 2.25H5.25A2.25 2.25 0 013 18v-6m18 0V9M3 12V9m18 0a2.25 2.25 0 00-2.25-2.25H5.25A2.25 2.25 0 003 9m18 0V6a2.25 2.25 0 00-2.25-2.25H5.25A2.25 2.25 0 003 6v3"
      }));
    }
    var ForwardRef = React.forwardRef(WalletIcon);
    module.exports = ForwardRef;
  }
});
var require_WifiIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/WifiIcon.js"(exports, module) {
    var React = require_react();
    function WifiIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M8.288 15.038a5.25 5.25 0 017.424 0M5.106 11.856c3.807-3.808 9.98-3.808 13.788 0M1.924 8.674c5.565-5.565 14.587-5.565 20.152 0M12.53 18.22l-.53.53-.53-.53a.75.75 0 011.06 0z"
      }));
    }
    var ForwardRef = React.forwardRef(WifiIcon);
    module.exports = ForwardRef;
  }
});
var require_WindowIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/WindowIcon.js"(exports, module) {
    var React = require_react();
    function WindowIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M3 8.25V18a2.25 2.25 0 002.25 2.25h13.5A2.25 2.25 0 0021 18V8.25m-18 0V6a2.25 2.25 0 012.25-2.25h13.5A2.25 2.25 0 0121 6v2.25m-18 0h18M5.25 6h.008v.008H5.25V6zM7.5 6h.008v.008H7.5V6zm2.25 0h.008v.008H9.75V6z"
      }));
    }
    var ForwardRef = React.forwardRef(WindowIcon);
    module.exports = ForwardRef;
  }
});
var require_WrenchScrewdriverIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/WrenchScrewdriverIcon.js"(exports, module) {
    var React = require_react();
    function WrenchScrewdriverIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M11.42 15.17L17.25 21A2.652 2.652 0 0021 17.25l-5.877-5.877M11.42 15.17l2.496-3.03c.317-.384.74-.626 1.208-.766M11.42 15.17l-4.655 5.653a2.548 2.548 0 11-3.586-3.586l6.837-5.63m5.108-.233c.55-.164 1.163-.188 1.743-.14a4.5 4.5 0 004.486-6.336l-3.276 3.277a3.004 3.004 0 01-2.25-2.25l3.276-3.276a4.5 4.5 0 00-6.336 4.486c.091 1.076-.071 2.264-.904 2.95l-.102.085m-1.745 1.437L5.909 7.5H4.5L2.25 3.75l1.5-1.5L7.5 4.5v1.409l4.26 4.26m-1.745 1.437l1.745-1.437m6.615 8.206L15.75 15.75M4.867 19.125h.008v.008h-.008v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(WrenchScrewdriverIcon);
    module.exports = ForwardRef;
  }
});
var require_WrenchIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/WrenchIcon.js"(exports, module) {
    var React = require_react();
    function WrenchIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M21.75 6.75a4.5 4.5 0 01-4.884 4.484c-1.076-.091-2.264.071-2.95.904l-7.152 8.684a2.548 2.548 0 11-3.586-3.586l8.684-7.152c.833-.686.995-1.874.904-2.95a4.5 4.5 0 016.336-4.486l-3.276 3.276a3.004 3.004 0 002.25 2.25l3.276-3.276c.256.565.398 1.192.398 1.852z"
      }), /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M4.867 19.125h.008v.008h-.008v-.008z"
      }));
    }
    var ForwardRef = React.forwardRef(WrenchIcon);
    module.exports = ForwardRef;
  }
});
var require_XCircleIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/XCircleIcon.js"(exports, module) {
    var React = require_react();
    function XCircleIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M9.75 9.75l4.5 4.5m0-4.5l-4.5 4.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
      }));
    }
    var ForwardRef = React.forwardRef(XCircleIcon);
    module.exports = ForwardRef;
  }
});
var require_XMarkIcon = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/XMarkIcon.js"(exports, module) {
    var React = require_react();
    function XMarkIcon(_a, svgRef) {
      var _b = _a, {
        title,
        titleId
      } = _b, props = __objRest(_b, [
        "title",
        "titleId"
      ]);
      return /* @__PURE__ */ React.createElement("svg", Object.assign({
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        strokeWidth: 1.5,
        stroke: "currentColor",
        "aria-hidden": "true",
        ref: svgRef,
        "aria-labelledby": titleId
      }, props), title ? /* @__PURE__ */ React.createElement("title", {
        id: titleId
      }, title) : null, /* @__PURE__ */ React.createElement("path", {
        strokeLinecap: "round",
        strokeLinejoin: "round",
        d: "M6 18L18 6M6 6l12 12"
      }));
    }
    var ForwardRef = React.forwardRef(XMarkIcon);
    module.exports = ForwardRef;
  }
});
var require_outline = __commonJS2({
  "../../node_modules/.pnpm/@heroicons+react@2.0.17_react@18.2.0/node_modules/@heroicons/react/24/outline/index.js"(exports, module) {
    module.exports.AcademicCapIcon = require_AcademicCapIcon();
    module.exports.AdjustmentsHorizontalIcon = require_AdjustmentsHorizontalIcon();
    module.exports.AdjustmentsVerticalIcon = require_AdjustmentsVerticalIcon();
    module.exports.ArchiveBoxArrowDownIcon = require_ArchiveBoxArrowDownIcon();
    module.exports.ArchiveBoxXMarkIcon = require_ArchiveBoxXMarkIcon();
    module.exports.ArchiveBoxIcon = require_ArchiveBoxIcon();
    module.exports.ArrowDownCircleIcon = require_ArrowDownCircleIcon();
    module.exports.ArrowDownLeftIcon = require_ArrowDownLeftIcon();
    module.exports.ArrowDownOnSquareStackIcon = require_ArrowDownOnSquareStackIcon();
    module.exports.ArrowDownOnSquareIcon = require_ArrowDownOnSquareIcon();
    module.exports.ArrowDownRightIcon = require_ArrowDownRightIcon();
    module.exports.ArrowDownTrayIcon = require_ArrowDownTrayIcon();
    module.exports.ArrowDownIcon = require_ArrowDownIcon();
    module.exports.ArrowLeftCircleIcon = require_ArrowLeftCircleIcon();
    module.exports.ArrowLeftOnRectangleIcon = require_ArrowLeftOnRectangleIcon();
    module.exports.ArrowLeftIcon = require_ArrowLeftIcon();
    module.exports.ArrowLongDownIcon = require_ArrowLongDownIcon();
    module.exports.ArrowLongLeftIcon = require_ArrowLongLeftIcon();
    module.exports.ArrowLongRightIcon = require_ArrowLongRightIcon();
    module.exports.ArrowLongUpIcon = require_ArrowLongUpIcon();
    module.exports.ArrowPathRoundedSquareIcon = require_ArrowPathRoundedSquareIcon();
    module.exports.ArrowPathIcon = require_ArrowPathIcon();
    module.exports.ArrowRightCircleIcon = require_ArrowRightCircleIcon();
    module.exports.ArrowRightOnRectangleIcon = require_ArrowRightOnRectangleIcon();
    module.exports.ArrowRightIcon = require_ArrowRightIcon();
    module.exports.ArrowSmallDownIcon = require_ArrowSmallDownIcon();
    module.exports.ArrowSmallLeftIcon = require_ArrowSmallLeftIcon();
    module.exports.ArrowSmallRightIcon = require_ArrowSmallRightIcon();
    module.exports.ArrowSmallUpIcon = require_ArrowSmallUpIcon();
    module.exports.ArrowTopRightOnSquareIcon = require_ArrowTopRightOnSquareIcon();
    module.exports.ArrowTrendingDownIcon = require_ArrowTrendingDownIcon();
    module.exports.ArrowTrendingUpIcon = require_ArrowTrendingUpIcon();
    module.exports.ArrowUpCircleIcon = require_ArrowUpCircleIcon();
    module.exports.ArrowUpLeftIcon = require_ArrowUpLeftIcon();
    module.exports.ArrowUpOnSquareStackIcon = require_ArrowUpOnSquareStackIcon();
    module.exports.ArrowUpOnSquareIcon = require_ArrowUpOnSquareIcon();
    module.exports.ArrowUpRightIcon = require_ArrowUpRightIcon();
    module.exports.ArrowUpTrayIcon = require_ArrowUpTrayIcon();
    module.exports.ArrowUpIcon = require_ArrowUpIcon();
    module.exports.ArrowUturnDownIcon = require_ArrowUturnDownIcon();
    module.exports.ArrowUturnLeftIcon = require_ArrowUturnLeftIcon();
    module.exports.ArrowUturnRightIcon = require_ArrowUturnRightIcon();
    module.exports.ArrowUturnUpIcon = require_ArrowUturnUpIcon();
    module.exports.ArrowsPointingInIcon = require_ArrowsPointingInIcon();
    module.exports.ArrowsPointingOutIcon = require_ArrowsPointingOutIcon();
    module.exports.ArrowsRightLeft