/*
  This file is part of Challenger
  Copyright (C) 2023 Taler Systems SA

  Challenger is free software; you can redistribute it and/or modify it under the
  terms of the GNU Lesser General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  Challenger is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  Challenger; see the file COPYING.GPL.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file challenger/challenger-httpd_config.c
 * @brief headers for /config handler
 * @author Christian Grothoff
 */
#include "platform.h"
#include "challenger-httpd_config.h"
#include <taler/taler_json_lib.h>


/*
 * Protocol version history:
 *
 * 0: original design
 */


MHD_RESULT
CH_handler_config (struct CH_HandlerContext *hc,
                   const char *upload_data,
                   size_t *upload_data_size)
{
  (void) upload_data;
  (void) upload_data_size;
  return TALER_MHD_REPLY_JSON_PACK (
    hc->connection,
    MHD_HTTP_OK,
    GNUNET_JSON_pack_string ("implementation",
                             "urn:net:taler:specs:challenger:c-reference"),
    GNUNET_JSON_pack_string ("name",
                             "challenger"),
    GNUNET_JSON_pack_string ("version",
                             "0:1:0"));
}


/* end of challenger-httpd_config.c */
