/*
   This file is part of Challenger
   Copyright (C) 2023 Taler Systems SA

   Challenger is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   Challenger is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   Challenger; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file challengerdb/pg_validate_solve_pin.h
 * @brief implementation of the validate_solve_pin function for Postgres
 * @author Christian Grothoff
 */
#ifndef PG_VALIDATE_SOLVE_PIN_H
#define PG_VALIDATE_SOLVE_PIN_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "challenger_database_plugin.h"


/**
 * Check PIN entered to validate an address.
 *
 * @param cls
 * @param nonce unique nonce to use to identify the validation
 * @param new_pin the PIN the user entered
 * @param[out] solved set to true if the PIN was correct
 * @return transaction status:
 *   #GNUNET_DB_STATUS_SUCCESS_ONE_RESULT if the nonce was found
 *   #GNUNET_DB_STATUS_SUCCESS_NO_RESULTS if we do not know the nonce
 *   #GNUNET_DB_STATUS_HARD_ERROR on failure
 */
enum GNUNET_DB_QueryStatus
CH_PG_validate_solve_pin (void *cls,
                          const struct CHALLENGER_ValidationNonceP *nonce,
                          uint32_t new_pin,
                          bool *solved);


#endif
